;
;	>> Alien Swarm - Fix by JAC! & Paul Lay <<
;
;	For Atari 52000l. See http://www.atarimuseum.com/videogames/consoles/5200/conv_to_5200.html for details.
;
;	@com.wudsn.ide.asm.outputfileextension=.bin

; OS VARIABLES FOR 5200
; 
; PAGE 0
pokmsk	= $00				;pokmsk at $00 on Atari 5200 instead of $10 on Atari XL
rtclok	= $00				;Actually $01/$02, but XL code uses rtclok+0/1/2 and this program only needs the 2 first bytes of the clock
atract	= $04				;attact at $04 on Atari 5200 instead of $4D on Atari XL				
savmsc	= $58				;savmsc does not exist on Atari 5200 but we will set up it when configuring the graphics mode

; PAGE 2
vkeybd	= $fffe				;Dummy to keep the code unchanged
sdmactl = $07				;sdmactl at $07 on Atari 5200 instead of $22f on Atari XL
sdlstl	= $05				;sdlstl at $05/$06 on Atari 5200 instead of $230 on Atari XL
sskctl	= skctl				;There is no shadow on Atari 5200
stick0	= $278				;There is no stick0 but we will make the analog stick look like a digital one and store it here
strig0	= $284				;There is no strig0 but we will make this the shadow of the TRIG0 ($c010) of GITA
color0	= $0c				;Shadow is in ZP on Atari 5200 instead of $2c4 on Atari XL
color1	= $0d				;Shadow is in ZP on Atari 5200 instead of $2c5 on Atari XL
color2	= $0e				;Shadow is in ZP on Atari 5200 instead of $2c6 on Atari XL
memtop	= $2e5				;There is no memtop on Atari 5200 but we will set it up when configuring the graphics mode
chact	= $2f3				;There is no chact on Atari 5200 but we will support it in our own VBI routine

; HARDWARE REGISTERS

; GTIA
consol	   = $280			;There are no console keys on Atari 5200, so we replace console h/w reads with a new shadow based on the keypad keys
consol_reset = $07			;The constant value representing that no consol key is pressed

; POKEY
audf1	= $e800				;POKEY at different address $E8xx on Atari 5200 instead of $D2xx on Atari XL
audc1	= $e801
audf2	= $e802
audc2	= $e803
kbcode	= $281				;There is no keyboard on the Atari 5200, so eplace kbcode h/w reads with a byte variable read based on the keypad keys
random	= $e80a
irqen	= $e80e
skctl	= $e80f
skstat  = $e80f

; PIA
pactl	= $ffff				;Dummy to keep the code unchamged, there is no PIA in Atari 5200

; ANTIC
dmactl	= $d400
chactl	= $d401
vcount	= $d40b
nmien	= $d40e

;===============================================================

	icl "AlienSwarm.asm"		;Global defines

;===============================================================
	opt h-f+

	org $4000

	.proc start
	sei
	lda #$00			;Disable all interruptes
	sta nmien
	sta irqen
	sta dmactl			;Blank screen
	sta sdmactl
	
	mwa #empty_dl sdlstl		;Empty display list
	jsr copy_rom_to_ram

sync	lda vcount
	bne sync
	
	mwa #bios.deferred_vbi $204
	mwa #bios.kb_continue $20a
;	The trigger inputs, TRIG0 through TRIG3, are wired to the controller ports, one to a port.
;	The bottom button on either side of the leftmost controller zeroes the TRIG0 register when pressed,
;	and likewise for the other ports.
;	The bits in CONSOL, the 400/800's console switch port (START, OPTION, SELECT and speaker),
;	are used as outputs in the 5200, Bit 3, the 400/800's speaker control can still be toggled in
;	the 5200 to produce sounds through the TV speaker. 
;	Bit 2 controls the pots in the joystick controllers. It must be set high to enable the pots.
;	Bits 1 and 0 select which controller port is to be active at one time.
;	00 selects port #1 (the leftmost), 01 selects #2, 10 selects #3, and 11 selects #4.
;	The trigger buttons and pots are independent of this selection;
;	it applies only to the keypads and top side buttons on the controllers.
	mva #$04 $c01f			;Speaker off, Pots enabled, port #1 selected
	mva #consol_reset consol

	mva #$22 sdmactl		;Enable display
	mva #$40 nmien			;Enable NMI interrupts
	lda #$40			;Enable IRQ interrupts
	sta pokmsk
	sta irqen
	cli

;	.proc test_bios			;Uncomment to test BIOS handlers
;sm	= $100
;
;	mwa #test_dl sdlstl
;loop	ldy #0
;	lda strig0
;	jsr print_hex
;	lda stick0
;	jsr print_hex
;	lda kbcode
;	jsr print_hex
;	lda consol
;	jsr print_hex
;	jmp loop
;	
;	.proc print_hex
;	pha
;	lsr
;	lsr
;	lsr
;	lsr
;	tax
;	mva hextab,x sm,y+
;	pla
;	and #15
;	tax
;	mva hextab,x sm,y+
;	mva #" " sm,y+
;	rts
;
;	.local hextab
;	.byte "0123456789ABCDEF"
;	.endl
;	.endp
;
;	.local test_dl
;	.byte $70,$70,$70,$42,a(sm)
;	.byte $41, a(test_dl)
;	.endl
;	.endp

	jmp main

	.local empty_dl
	.byte $41, a(empty_dl)
	.endl

;===============================================================

	.proc copy_rom_to_ram
	zp_source = $80
	zp_dest   = zp_source+2
	zp_length = zp_dest+2
	
	mwa #main_rom zp_source
	mwa #main_ram zp_dest
	mwa #[.len main] zp_length

	ldx #$00
copy	lda (zp_source,x)
	sta (zp_dest,x)
	inw zp_source
	inw zp_dest
	dew zp_length
	lda zp_length
	ora zp_length+1
	bne copy
	rts
	.endp

	.endp

;===============================================================

	.proc bios

pot0    = $0011				;Shadow of potentiometer 0
pot1    = $0012				;Shadow of potentiometer 1
trig0	= $c010				;Hardware trigger 0

	.proc deferred_vbi
	center = 114			;Read analog stick and make it look like a digital stick
	threshold = 60

	lda pot0			;Read POT0 value (horizontal position)
	cmp #center+threshold		;Compare with right threshold
	rol stick0			;Feed carry into digital stick value
	cmp #center-threshold		;Compare with left threshold
	rol stick0			;Feed carry into digital stick value

	lda pot1			;Read POT1 value (vertical position)
	cmp #center+threshold		;Compare with down threshold
	rol stick0			;Feed carry into digital stick value
	cmp #center-threshold		;Compare with down threshold
	rol stick0			;Feed carry into digital stick value

	lda stick0			;0 indicates a press so the right/down values need to be inverted
	eor #2+8
	and #$0f
	sta stick0

	mva trig0 strig0		;Move hardware to shadow

	lda skstat			;Reset consol key shadow is no key is pressed anymore
	and #4
	beq key_pressed
	mva #consol_reset consol
key_pressed

	mva chact chactl		;Move shadow to hardware

	pla
	tay
	pla
	tax
	pla
	rti
	.endp

;===============================================================

	.proc kb_continue		;Keyboard continue routine, IN: <A>=key code
	sta kbcode			;Store key code in shadow.

	cmp #$0d			;Pause key pressed?
	beq pause
	
	ldx #.len mapping.key_values	;Map keypad key to to console key.
loop	cmp mapping.key_values,x
	beq match
	dex
	bpl loop

exit	pla
	tay
	pla
	tax
	pla
	rti
	
match	lda mapping.consol_values,x	;Cumulate pressed keys
	and #$ff
	and consol
	sta consol
	jmp exit
	
pause	lda main.pause_l12bb		;Copied from original code for simplicity
	eor #$80
	sta main.pause_l12bb
	jmp exit

	.local mapping			;Mapping of keypad codes to console key codes
	
	.local key_values
	.byte $0c,$0a,$0b
	.endl

	.local consol_values
	.byte $06,$05,$03
	.endl
	
	.endl
	
	.endp
	
	.endp				;End of bios

;===============================================================

	.macro m_title_options
	.byte '       *',$7f,'TWO PLAYERS'
	.byte '        #',$7f,'BEGINNER'
	.endm

	.macro m_open_screen		;This is used in the main part
	jsr open_screen
	.endm

; Set up an ANTIC D display.
; The original program used a CIOV call to do this, so it is replaced with
; codewhich configures the display as per a 16K Atari 400.    

	.proc open_screen		;96 lines high graphics 7 display with 24 lines padding
	ptr = $80
	dl = $2f98
	sm = $3060
	
	mwa #dl-1 memtop

	lda #$70
	sta dl
	sta dl+1
	sta dl+2

	mva #$4d dl+3

	lda #<sm
	sta savmsc
	sta ptr
	sta dl+4

	lda #>sm
	sta savmsc+1
	sta ptr+1
	sta dl+5

	.proc fill_dl
	ldx #94
	lda #$0d
loop	sta dl+6,x
	dex
	bpl loop
	.endp

	mva #$41 dl+101
	mwa #dl  dl+102

	.proc clear_sm
	ldx #$10
	lda #$00
	tay
loop	sta (ptr),y
	iny
	bne loop
	inc ptr+1
	dex
	bne loop
	.endp

	mwa #dl sdlstl
	rts
	.endp

;===============================================================

main_ram = $1006-$80

main_rom
	icl "AlienSwarm-Main.asm"

;===============================================================

	org $bfe8
	.byte "ALIEN SWARM JAC! FIX"	;20 characters title
	.byte 'xx'			;2 characters year
	.word start
