;
;	>> Alien Swarm - Fix by JAC! & Paul Lay <<
;
;	For Atari 400/800/800 XL. 
;
;	@com.wudsn.ide.asm.outputfileextension=.xex

; OS VARIABLES FOR XL/XE

; PAGE 0
pokmsk	= $10
rtclok	= $12
atract	= $4d
savmsc	= $58

; PAGE 2
vkeybd	= $208
sdmactl = $22f
sdlstl	= $230
sskctl	= $232
stick0	= $278
strig0	= $284
color0	= $2c4
color1	= $2c5
color2	= $2c6
memtop	= $2e5
chact	= $2f3

; HARDWARE REGISTERS

; GTIA
consol	= $d01f
consol_reset = $08

; POKEY
audf1	= $d200
audc1	= $d201
audf2	= $d202
audc2	= $d203
kbcode	= $d209
random	= $d20a
irqen	= $d20e
skctl	= $d20f
skstat  = $d20f

; PIA
pactl	= $d302

; ANTIC
dmactl	= $d400

; ROM VECTORS
	.enum cio
	iccom	= $0002
	icbal	= $0004
	icbah	= $0005
	icax1	= $000a
	icax2	= $000b
	.ende
iocb0	= $0340
ciov	= $e456

;===============================================================

	icl "AlienSwarm.asm"		;Global defines

;===============================================================
	.if .not .def JAC
; ANTIC 
chactl	= $d401


; PAGE 3
dunit	= $301
dcomnd	= $302
dbuflo	= $304
dbufhi	= $305
daux1	= $30a
daux2	= $30b

; ROM VECTORS
dskinv	= $e453
	.endif

;===============================================================

	.if .def JAC

	org $4000

	.proc start
	mva #1 580
	ldx #>[.len main+$ff]
	ldy #0
loop
source	lda main_load,y
target	sta main_ram,y
	iny
	bne loop
	inc source+2
	inc target+2
	dex
	bne loop

	jmp main.start_l105c
	.endp
	
	.else

	org $1006
start	= main.start_l105c
	.endif

;===============================================================

	.macro m_title_options
	.byte '  SELECT',$7f,'TWO PLAYERS'
	.byte '   OPTION',$7f,'BEGINNER'
	.endm
	
	.macro m_open_screen		; This is used in the main part
	ldx #$30
	lda #$0c
	sta iocb0+cio.iccom,x
	jsr ciov
	lda #$03
	sta iocb0+cio.iccom,x
	lda #<screen_spec
	sta iocb0+cio.icbal,x
	lda #>screen_spec
	sta iocb0+cio.icbah,x
	lda #$08
	sta iocb0+cio.icax1,x
	lda #$07
	sta iocb0+cio.icax2,x
	jsr ciov
	.endm

	.if .def jac
main_ram = $1006-$80
	.else
main_ram = $1006
	.endif

main_load
	icl "AlienSwarm-Main.asm"

;===============================================================

	run start

	