package clmedit;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.*;
import javax.swing.*;

public class EditorFrame extends javax.swing.JFrame {

    private DrawPanel drawPanel;
    private int[][][] caveData;
    
    private int[][] clipBoard1;
    private int[][] clipBoard2;
    
    private int[][] markClipBoard;
    

    /**
     * Creates new form EditorFrame
     */
    public EditorFrame() {
        initCaveData();
        initComponents();
        loadPersistence();
        initDrawPanel();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jfcLoad = new javax.swing.JFileChooser();
        jfcSave = new javax.swing.JFileChooser();
        jPanel1 = new javax.swing.JPanel();
        pElementButtons = new javax.swing.JPanel();
        btn0 = new javax.swing.JButton();
        btn2 = new javax.swing.JButton();
        btn3 = new javax.swing.JButton();
        btn4 = new javax.swing.JButton();
        btn6 = new javax.swing.JButton();
        btn7 = new javax.swing.JButton();
        btn8 = new javax.swing.JButton();
        btn16 = new javax.swing.JButton();
        btn17 = new javax.swing.JButton();
        btn20 = new javax.swing.JButton();
        btn30 = new javax.swing.JButton();
        btn5 = new javax.swing.JButton();
        btn1 = new javax.swing.JButton();
        btnSelection = new javax.swing.JButton();
        pCaveNumbers = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jspiCurrentCave = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        jspiCavesToSave = new javax.swing.JSpinner();
        jscCavePane = new javax.swing.JScrollPane();
        pCaveElements = new javax.swing.JPanel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jmFile = new javax.swing.JMenu();
        mniLoadFile = new javax.swing.JMenuItem();
        mniSaveFile = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jmiImport = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JPopupMenu.Separator();
        mniQuit = new javax.swing.JMenuItem();
        jmEdit = new javax.swing.JMenu();
        jmiCopy1 = new javax.swing.JMenuItem();
        jmiCopy2 = new javax.swing.JMenuItem();
        jSeparator3 = new javax.swing.JPopupMenu.Separator();
        jmiPaste1 = new javax.swing.JMenuItem();
        jmiPaste2 = new javax.swing.JMenuItem();
        jSeparator4 = new javax.swing.JPopupMenu.Separator();
        jmiClear = new javax.swing.JMenuItem();
        jmiCopyMark = new javax.swing.JMenuItem();
        jmiPasteMark = new javax.swing.JMenuItem();
        jmTransform = new javax.swing.JMenu();
        jmiFlipHorizontally = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Curse of the lost miner - editor v1.1a");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                handle_close(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        pElementButtons.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        pElementButtons.setLayout(new java.awt.GridBagLayout());

        btn0.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockFull.png"))); // NOI18N
        btn0.setToolTipText("Rock");
        btn0.setIconTextGap(1);
        btn0.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn0.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onRockFull(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn0, gridBagConstraints);

        btn2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockBottomRight.png"))); // NOI18N
        btn2.setToolTipText("Rock");
        btn2.setIconTextGap(1);
        btn2.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onRockBottomRight(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn2, gridBagConstraints);

        btn3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockBottomLeft.png"))); // NOI18N
        btn3.setToolTipText("Rock");
        btn3.setIconTextGap(1);
        btn3.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onRockBottomLeft(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn3, gridBagConstraints);

        btn4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockTopLeft.png"))); // NOI18N
        btn4.setToolTipText("Rock");
        btn4.setIconTextGap(1);
        btn4.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onRockTopLeft(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn4, gridBagConstraints);

        btn6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elDeathTopBottom.png"))); // NOI18N
        btn6.setToolTipText("Spikes (bottom-top)");
        btn6.setIconTextGap(1);
        btn6.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onDeathTopBottom(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn6, gridBagConstraints);

        btn7.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elLadder.png"))); // NOI18N
        btn7.setToolTipText("Ladder");
        btn7.setIconTextGap(1);
        btn7.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn7.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onLadder(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn7, gridBagConstraints);

        btn8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockBroken.png"))); // NOI18N
        btn8.setToolTipText("Broken rock");
        btn8.setIconTextGap(1);
        btn8.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn8.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onRockBroken(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn8, gridBagConstraints);

        btn16.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockUnstable.png"))); // NOI18N
        btn16.setToolTipText("Unstable rock");
        btn16.setIconTextGap(1);
        btn16.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn16.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onUnstableRock(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn16, gridBagConstraints);

        btn17.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elStartPosition.png"))); // NOI18N
        btn17.setToolTipText("Starting position");
        btn17.setIconTextGap(1);
        btn17.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn17.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onStartPosition(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn17, gridBagConstraints);

        btn20.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elDiamond.png"))); // NOI18N
        btn20.setToolTipText("Diamond");
        btn20.setIconTextGap(1);
        btn20.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn20.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onDiamond(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn20, gridBagConstraints);

        btn30.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elBlank.png"))); // NOI18N
        btn30.setToolTipText("Empty space");
        btn30.setIconTextGap(1);
        btn30.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn30.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onBlank(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn30, gridBagConstraints);

        btn5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elRockTopRight.png"))); // NOI18N
        btn5.setToolTipText("Rock");
        btn5.setIconTextGap(1);
        btn5.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onRockTopRight(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btn5, gridBagConstraints);

        btn1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elDeathBottomTop.png"))); // NOI18N
        btn1.setToolTipText("Spikes (bottom-top)");
        btn1.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btn1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onDeathBottomTop(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        pElementButtons.add(btn1, gridBagConstraints);

        btnSelection.setIcon(new javax.swing.ImageIcon(getClass().getResource("/clmedit/elSelection.png"))); // NOI18N
        btnSelection.setToolTipText("Rectangular selection");
        btnSelection.setMargin(new java.awt.Insets(2, 2, 2, 2));
        btnSelection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onSelectionMode(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        pElementButtons.add(btnSelection, gridBagConstraints);

        jPanel1.add(pElementButtons, java.awt.BorderLayout.WEST);

        pCaveNumbers.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        pCaveNumbers.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Cave:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        pCaveNumbers.add(jLabel1, gridBagConstraints);

        jspiCurrentCave.setModel(new javax.swing.SpinnerNumberModel(0, 0, 31, 1));
        jspiCurrentCave.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                onCurrentCaveChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        pCaveNumbers.add(jspiCurrentCave, gridBagConstraints);

        jLabel2.setText("Last cave to save:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        pCaveNumbers.add(jLabel2, gridBagConstraints);

        jspiCavesToSave.setModel(new javax.swing.SpinnerNumberModel(31, 0, 31, 1));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        pCaveNumbers.add(jspiCavesToSave, gridBagConstraints);

        jPanel1.add(pCaveNumbers, java.awt.BorderLayout.EAST);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        jscCavePane.setBackground(java.awt.Color.black);
        jscCavePane.setDoubleBuffered(true);

        pCaveElements.setBackground(java.awt.Color.black);
        pCaveElements.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 48, 48));
        jscCavePane.setViewportView(pCaveElements);

        getContentPane().add(jscCavePane, java.awt.BorderLayout.CENTER);

        jmFile.setMnemonic('F');
        jmFile.setText("File");

        mniLoadFile.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.CTRL_MASK));
        mniLoadFile.setMnemonic('L');
        mniLoadFile.setText("Load caves");
        mniLoadFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onLoad(evt);
            }
        });
        jmFile.add(mniLoadFile);

        mniSaveFile.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        mniSaveFile.setMnemonic('S');
        mniSaveFile.setText("Save caves...");
        mniSaveFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onSave(evt);
            }
        });
        jmFile.add(mniSaveFile);
        jmFile.add(jSeparator1);

        jmiImport.setMnemonic('I');
        jmiImport.setText("Import Caverns of the Lost Miner old caves...");
        jmiImport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onImportOldCaves(evt);
            }
        });
        jmFile.add(jmiImport);
        jmFile.add(jSeparator2);

        mniQuit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F4, java.awt.event.InputEvent.ALT_MASK));
        mniQuit.setMnemonic('Q');
        mniQuit.setText("Quit");
        mniQuit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onQuit(evt);
            }
        });
        jmFile.add(mniQuit);

        jMenuBar1.add(jmFile);

        jmEdit.setMnemonic('E');
        jmEdit.setText("Edit");

        jmiCopy1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jmiCopy1.setMnemonic('C');
        jmiCopy1.setText("Copy cave to clipboard 1");
        jmiCopy1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onCopy1(evt);
            }
        });
        jmEdit.add(jmiCopy1);

        jmiCopy2.setText("Copy cave to clipboard 2");
        jmiCopy2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onCopy2(evt);
            }
        });
        jmEdit.add(jmiCopy2);
        jmEdit.add(jSeparator3);

        jmiPaste1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jmiPaste1.setMnemonic('P');
        jmiPaste1.setText("Paste cave from clipboard 1");
        jmiPaste1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onPaste1(evt);
            }
        });
        jmEdit.add(jmiPaste1);

        jmiPaste2.setText("Paste cave from clipboard 2");
        jmiPaste2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onPaste2(evt);
            }
        });
        jmEdit.add(jmiPaste2);
        jmEdit.add(jSeparator4);

        jmiClear.setText("Clear cave");
        jmiClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onClearCave(evt);
            }
        });
        jmEdit.add(jmiClear);

        jmiCopyMark.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.CTRL_MASK));
        jmiCopyMark.setMnemonic('o');
        jmiCopyMark.setText("Copy selected area");
        jmiCopyMark.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onCopyMarkedArea(evt);
            }
        });
        jmEdit.add(jmiCopyMark);

        jmiPasteMark.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.CTRL_MASK));
        jmiPasteMark.setMnemonic('a');
        jmiPasteMark.setText("Paste to the topleft corner of the selection");
        jmiPasteMark.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onPasteMarkedArea(evt);
            }
        });
        jmEdit.add(jmiPasteMark);

        jMenuBar1.add(jmEdit);

        jmTransform.setMnemonic('T');
        jmTransform.setText("Transform");

        jmiFlipHorizontally.setMnemonic('F');
        jmiFlipHorizontally.setText("Flip cave horizontally");
        jmiFlipHorizontally.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onFlipHorizontally(evt);
            }
        });
        jmTransform.add(jmiFlipHorizontally);

        jMenuBar1.add(jmTransform);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void onQuit(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onQuit
        savePersistence();
        System.exit(0);
    }//GEN-LAST:event_onQuit

    private void onSave(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onSave

        int result = jfcSave.showSaveDialog(this);
        if (result != JFileChooser.APPROVE_OPTION) {
            return;
        }
        File f = jfcSave.getSelectedFile();
        if (f == null) {
            return;
        }

        try {
            Caves.saveCaves(f.getAbsolutePath(),caveData, (Integer)jspiCavesToSave.getValue());
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "<HTML>" + e.toString() + "<BR>" + e.getMessage() != null ? e.getMessage() : "No message");
        }

    }//GEN-LAST:event_onSave

    private void onDeathBottomTop(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onDeathBottomTop
        drawPanel.setCurrentElement(CalominConstants.DEATH_BOTTOM_TOP);

    }//GEN-LAST:event_onDeathBottomTop

    private void onRockTopRight(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onRockTopRight
        drawPanel.setCurrentElement(CalominConstants.ROCK_TR);

    }//GEN-LAST:event_onRockTopRight

    private void onDiamond(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onDiamond
        drawPanel.setCurrentElement(CalominConstants.DIAMOND);
    }//GEN-LAST:event_onDiamond

    private void onStartPosition(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onStartPosition
        drawPanel.setCurrentElement(CalominConstants.START_POSITION);
    }//GEN-LAST:event_onStartPosition

    private void onUnstableRock(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onUnstableRock
        drawPanel.setCurrentElement(CalominConstants.ROCK_UNSTABLE);
    }//GEN-LAST:event_onUnstableRock

    private void onRockBroken(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onRockBroken
        drawPanel.setCurrentElement(CalominConstants.ROCK_BROKEN);
    }//GEN-LAST:event_onRockBroken

    private void onLadder(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onLadder
        drawPanel.setCurrentElement(CalominConstants.LADDER);
    }//GEN-LAST:event_onLadder

    private void onDeathTopBottom(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onDeathTopBottom
        drawPanel.setCurrentElement(CalominConstants.DEATH_TOP_BOTTOM);

    }//GEN-LAST:event_onDeathTopBottom

    private void onRockTopLeft(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onRockTopLeft
        drawPanel.setCurrentElement(CalominConstants.ROCK_TL);
    }//GEN-LAST:event_onRockTopLeft

    private void onRockBottomLeft(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onRockBottomLeft
        drawPanel.setCurrentElement(CalominConstants.ROCK_BL);
    }//GEN-LAST:event_onRockBottomLeft

    private void onRockBottomRight(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onRockBottomRight
        drawPanel.setCurrentElement(CalominConstants.ROCK_BR);
    }//GEN-LAST:event_onRockBottomRight

    private void onRockFull(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onRockFull
        drawPanel.setCurrentElement(CalominConstants.ROCK_FULL);
    }//GEN-LAST:event_onRockFull

    private void onLoad(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onLoad

        int result = jfcLoad.showOpenDialog(this);
        if (result != JFileChooser.APPROVE_OPTION) {
            return;
        }
        File f = jfcLoad.getSelectedFile();
        if (f == null) {
            return;
        }

        try {
            int maxIndex = Caves.loadCaves(f.getAbsolutePath(),caveData);
            jspiCavesToSave.setValue(maxIndex);
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "<HTML>" + e.getClass().getName() + "<BR>" + e.getMessage() != null ? e.getMessage() : "No message" + "</HTML>");
        }

        drawPanel.setCurrentCave(0);


    }//GEN-LAST:event_onLoad

    private void handle_close(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_handle_close
        savePersistence();
        System.exit(0);
    }//GEN-LAST:event_handle_close

    private void onBlank(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onBlank
        drawPanel.setCurrentElement(CalominConstants.BLANK);
    }//GEN-LAST:event_onBlank

    private void onImportOldCaves(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onImportOldCaves

        int result = jfcLoad.showOpenDialog(this);
        if (result != JFileChooser.APPROVE_OPTION) {
            return;
        }
        File f = jfcLoad.getSelectedFile();
        if (f == null) {
            return;
        }

        try {
            int maxIndex = Caves.importOldCaves(f.getAbsolutePath(), caveData);
            jspiCavesToSave.setValue(maxIndex);
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "<HTML>" + e.getClass().getName() + "<BR>" + ((e.getMessage() != null) ? e.getMessage() : "No message") + "</HTML>");
        }

        drawPanel.setCurrentCave(0);
    }//GEN-LAST:event_onImportOldCaves

    private void onCurrentCaveChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_onCurrentCaveChanged
        drawPanel.setCurrentCave(((Integer)jspiCurrentCave.getValue()).intValue());
    }//GEN-LAST:event_onCurrentCaveChanged

    private void onCopy1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onCopy1
        deepCaveCopy(clipBoard1,caveData[drawPanel.getCurrentCave()]);
    }//GEN-LAST:event_onCopy1

    private void onCopy2(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onCopy2
        deepCaveCopy(clipBoard2,caveData[drawPanel.getCurrentCave()]);
    }//GEN-LAST:event_onCopy2

    private void onPaste1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onPaste1
        deepCaveCopy(caveData[drawPanel.getCurrentCave()],clipBoard1);
        drawPanel.repaint();
    }//GEN-LAST:event_onPaste1

    private void onPaste2(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onPaste2
        deepCaveCopy(caveData[drawPanel.getCurrentCave()],clipBoard2);
        drawPanel.repaint();
    }//GEN-LAST:event_onPaste2

    private void onClearCave(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onClearCave
       
        /*Ask for confirmation*/
        int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to clear the cave?","Confirm",JOptionPane.YES_NO_OPTION);
        if (result!=JOptionPane.YES_OPTION) return;
        
        int curCave = drawPanel.getCurrentCave();
        for(int y=0;y<22;y++) {
            for (int x=0;x<20;x++) {
                caveData[curCave][y][x]=CalominConstants.BLANK;
            }
        }
        
        drawPanel.repaint();
    }//GEN-LAST:event_onClearCave

    private void onCopyMarkedArea(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onCopyMarkedArea
        
        /* Check if there is an area*/
        Rectangle sr = drawPanel.getSelection();
        
        
        int lx = sr.width;
        int ly = sr.height;
            
            markClipBoard = new int[ly][lx];
            int curCave =drawPanel.getCurrentCave();
            
            for (int y=0;y<ly;y++) {
                for (int x=0;x<lx;x++) {
                    markClipBoard[y][x]=caveData[curCave][y+sr.y][x+sr.x];
                }
            }
        
    }//GEN-LAST:event_onCopyMarkedArea

    private void onPasteMarkedArea(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onPasteMarkedArea
        
        if (markClipBoard == null) return;
        
        int curCave =drawPanel.getCurrentCave();
        Point mark1 = new Point(drawPanel.getSelection().x,drawPanel.getSelection().y);
        
        for (int y=0;y<markClipBoard.length;y++) {
            for (int x=0;x<markClipBoard[y].length;x++) {
                
                int cy = y+mark1.y;
                int cx = x+mark1.x;
                
                if (cy<22 && cx<20) {
                    caveData[curCave][cy][cx]= markClipBoard[y][x];
                }
                
            }
        }
        
        drawPanel.repaint();
        
    }//GEN-LAST:event_onPasteMarkedArea

    private void onFlipHorizontally(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onFlipHorizontally
        
        int curCave = drawPanel.getCurrentCave();
        
        int[][] caveCopy = new int[22][20];
        deepCaveCopy(caveCopy, caveData[curCave]);
        
        for (int y=0;y<22;y++) {
            for (int x=0;x<20;x++) {
                caveData[curCave][y][19-x]=caveCopy[y][x];
            }
        }
        
        drawPanel.repaint();
    }//GEN-LAST:event_onFlipHorizontally

    private void onSelectionMode(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onSelectionMode
        drawPanel.setSelectionMode(true);
    }//GEN-LAST:event_onSelectionMode

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new EditorFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btn0;
    private javax.swing.JButton btn1;
    private javax.swing.JButton btn16;
    private javax.swing.JButton btn17;
    private javax.swing.JButton btn2;
    private javax.swing.JButton btn20;
    private javax.swing.JButton btn3;
    private javax.swing.JButton btn30;
    private javax.swing.JButton btn4;
    private javax.swing.JButton btn5;
    private javax.swing.JButton btn6;
    private javax.swing.JButton btn7;
    private javax.swing.JButton btn8;
    private javax.swing.JButton btnSelection;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JPopupMenu.Separator jSeparator2;
    private javax.swing.JPopupMenu.Separator jSeparator3;
    private javax.swing.JPopupMenu.Separator jSeparator4;
    private javax.swing.JFileChooser jfcLoad;
    private javax.swing.JFileChooser jfcSave;
    private javax.swing.JMenu jmEdit;
    private javax.swing.JMenu jmFile;
    private javax.swing.JMenu jmTransform;
    private javax.swing.JMenuItem jmiClear;
    private javax.swing.JMenuItem jmiCopy1;
    private javax.swing.JMenuItem jmiCopy2;
    private javax.swing.JMenuItem jmiCopyMark;
    private javax.swing.JMenuItem jmiFlipHorizontally;
    private javax.swing.JMenuItem jmiImport;
    private javax.swing.JMenuItem jmiPaste1;
    private javax.swing.JMenuItem jmiPaste2;
    private javax.swing.JMenuItem jmiPasteMark;
    javax.swing.JScrollPane jscCavePane;
    private javax.swing.JSpinner jspiCavesToSave;
    private javax.swing.JSpinner jspiCurrentCave;
    private javax.swing.JMenuItem mniLoadFile;
    private javax.swing.JMenuItem mniQuit;
    private javax.swing.JMenuItem mniSaveFile;
    private javax.swing.JPanel pCaveElements;
    private javax.swing.JPanel pCaveNumbers;
    private javax.swing.JPanel pElementButtons;
    // End of variables declaration//GEN-END:variables

    private void initDrawPanel() {
        drawPanel = new DrawPanel();
        drawPanel.initImages();
        drawPanel.setCaveData(caveData);
        drawPanel.setCurrentElement(0);
        drawPanel.setCurrentCave(0);
        pCaveElements.add("Center", drawPanel);
        jscCavePane.setViewportView(pCaveElements);

    }

    private void initCaveData() {
        caveData = new int[32][22][20];
        clipBoard1 = new int[22][20];
        clipBoard2 = new int[22][20];
        markClipBoard = null;
    }

    
    
    private void savePersistence() {
        
        try {
            FileOutputStream fos = new FileOutputStream(System.getProperty("user.home")+System.getProperty("file.separator")+".clmedit2.ser");
            DataOutputStream dos = new DataOutputStream(fos);
            
            dos.writeUTF(jfcLoad.getCurrentDirectory().getAbsolutePath());
            dos.writeUTF(jfcSave.getCurrentDirectory().getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    private void loadPersistence() {
        try {
            FileInputStream fis = new FileInputStream(System.getProperty("user.home")+System.getProperty("file.separator")+".clmedit2.ser");
            DataInputStream dis = new DataInputStream(fis);
            
            jfcLoad.setCurrentDirectory(new File((String)(dis.readUTF())));
            jfcSave.setCurrentDirectory(new File((String)(dis.readUTF())));
            
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    private void deepCaveCopy(int[][] dest,int[][] src) {
        for (int y=0;y<22;y++) {
            for (int x=0;x<20;x++) {
                dest[y][x] = src[y][x];
            }
        }
    }

}
