; "Duszpasterz Jan Rzygon" for Atari 8-bit by mgr_inz_rafal

; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <http:;www.gnu.org/licenses/>.

;	@com.wudsn.ide.asm.mainsourcefile=main.asm

; Some global variables
.var			ext_ram_bank		.byte
.var			ext_ram_bank_msg	.byte
.var			sparta_bank			.byte
.zpvar			ext_ram_tmp			.word
.zpvar			buf_addr_tmp		.word

EXTRAM_OBJECTS		equ		$4000			; 15kb for "ob"
EXTRAM_ITEMS		equ		$7400			; 3kb for "it"
EXTRAM_MESSAGES		equ		$4000			; 16kb for "ms" (in another bank)

; Reads record from the extended memory
.proc mem_read_record(.word buf_addr_tmp) .var
				ldy #0
@				lda (ext_ram_tmp),y
				sta (buf_addr_tmp),y
				tax
				inw ext_ram_tmp
				inw buf_addr_tmp
				cpx #$9b
				bne @-
				rts
.endp

; Size optimization
.proc mem_read_record_OPT1
				mem_read_record #io_buffer
				rts
.endp
.proc mem_read_binary_OPT1
				mem_read_binary #io_buffer #1
				rts
.endp
     
; Reads binary data from the extended memory
.proc mem_read_binary(.word buf_addr_tmp .byte length) .var
.var length .byte
				phr
				ldx length
				ldy #0
@				lda (ext_ram_tmp),y
				sta (buf_addr_tmp),y
				inw ext_ram_tmp
				inw buf_addr_tmp
				dex
				cpx #0
				bne @-
				plr
				rts
.endp 

; Switches back to the base memory
.proc main_mem
				lda @TAB_MEM_BANKS
;				and #%11111110
				sta PORTB
				rts
.endp

; Switches to extended RAM
.proc extended_mem(.byte y) .reg
				lda @TAB_MEM_BANKS+1,y
;				and #%11111110
				sta PORTB
				rts
.endp
