/*
Fairlight
Atari 8-bit conversion

Atari memory map:
0800 - 9fff: original code
a000 - b7ff: backbuffer
b800 - c8bf: music player + RMT modules (to be done)
c8c0 - cbff: original code
cc00 - ccff: stack used by flood fill?
cd00 - cd7f: screen data
cd80 - cfff: PMG area
d800 - dfff: rotation table (for speeding up rendering, created at runtime)
e000 - f7ff: screen

Free areas:
0200 - 07ff: 6 pages
cc00 - ceff: 3 pages
cf00 - cfff: 1 page (eventually, must change rendering code, which uses this as temporary storage)
f800 - fff9: 8 pages (almost)

Requirements:
Code: 5 pages
Skull: 9 pages (width 128 ($80), height 144, total size: 2288, $0900)
PMG: 2,5 pages

To Do:
1. Integrate music and sound effects (find zero page for RMT player: $c0/$df seem unused) (Done)
2. Change title screen to adjust for Atari texts (Done)
3. New colors (Done)
4. PMG overlays (Done)
5. Trainer. (Done)
6. Skull on game over (not enough memory)
7. Sync for 65816 (Done)
8. Move speedup routines into C64 code, to free more RAM
9. Move init code to $5000 ($180 bytes) (Done)

c64 infos:
3a38 - screen data, byte 0 = length, byte 1 = ??, byte 2 = copied to $2e, byte 3 - ?? data
		0 - bf: draw vector
		c0: set cursor pos
778f - set screen position pointers
78ba - print screen, screen number in $54, title = $4f
8490 - wait for any key
8498 - read key specified by A
84a1 - read joystick
84a9 - set screen color
99f6 - display disable
99ff - display enable
9a10 - font
9b61 - print texts? (parameters embedded in code, right after caller jsr)
9da8 - print texts on title screen
a000 - beff: bitmap backbuffer
c000 - c8bf: sound routines
c8c0 - cbff: game code?
cc00 - cfff: color memory, during rendering used as work memory?
e000 - feff: bitmap
$99E6  4C 56 98  JMP L_JMP_($9856)_($99E6) OK	; synchronize here?

Trainer: 
Inifinte energy:
$508F  A9 24     LDA #$24
$5091  8D 64 86  STA $8664 
$5094  8D 72 86  STA $8672 
$5097  60        RTS 
Infinite scrolls:
$50AA  A9 24     LDA #$24
$50AC  8D DF 98  STA $98DF 
$50AF  8D E2 98  STA $98E2 
$50B2  60        RTS 
Infinite potion:
$509E  A9 2F     LDA #$2F
$50A0  8D F7 98  STA $98F7 
$50A3  60        RTS 
Stop Enemies:
$50A4  A9 00     LDA #$00
$50A6  8D 2E 87  STA $872E 
$50A9  60        RTS 
All Doors Open:
$5098  A9 2C     LDA #$2C
$509A  8D A8 8F  STA $8FA8 
$509D  60        RTS 
Fly Mode On Jump:
$50B3  A9 2C     LDA #$2C
$50B5  8D AD 8C  STA $8CAD 
$50B8  60        RTS 
*/

		icl 'atari.hea'
		
rot_table		equ $d800
bitmapscreen	equ $e000
atari_code		equ $f900
atari_code_end	equ $fffa
atari_code_size = 7
mirror_table	equ $f800
ScreenSafetyBuffer	equ $0200

MUSIC_INGAME	equ $C05C

; colors
black			equ $00
white			equ $0e


		org $0800
		ins 'fl.dmp',+$0,   $1800
		org $3800
		ins 'fl.dmp',+$b800,$0c00
		
LOADING_ADR	equ $4400
		icl "rmtplayr_reloc.asm"			
		
		
		org $600
ldsrc	equ $fc
lddest	equ $fe

		sei
		lda #$0
		sta nmien
		lda portb
		ora #$02
		and #$fe
		sta portb
		
		;lda #$20
		;ldy #$d8
		;ldx #$18
		;jsr ldcopyini
		lda #$38
		ldy #$c0
		ldx #$0c
		jsr ldcopyini
		lda #$c5
		ldy #$cc
		ldx #$01
		jsr ldcopyini
		lda #>LOADING_ADR
		ldy #$b9
		ldx #$0f
		jsr ldcopyini
		
		lda portb
		ora #$01
		sta portb
		lda #$40
		sta nmien
		cli
		rts
		
ldcopyini	sta ldsrc+1
		sty lddest+1
		ldy #$0
		sty ldsrc
		sty lddest
ld1ini	lda (ldsrc),y
		sta (lddest),y
		iny
		bne ld1ini
		inc ldsrc+1
		inc lddest+1
		dex
		bne ld1ini
		rts
		
		ini $600
		
		org $2000
		ins 'fl.dmp',+$1800,$8000
		
;patches
;-------------------------------------------------------------------------
;//------------------------------
;$5200  A9 00     LDA #$00
;//------------------------------
;L_JSR_($5204)_($5AEE) BAD
;//------------------------------
;$5202  8D 20 D0  STA $D020 	; border color
;$5205  A9 03     LDA #$03
;$5207  0D 02 DD  ORA $DD02
;$520A  8D 02 DD  STA $DD02 ; ddr cia #2 porta
;$520D  A9 FC     LDA #$FC
;$520F  2D 00 DD  AND $DD00 
;$5212  8D 00 DD  STA $DD00 	; vram at $c000
;$5215  A9 38     LDA #$38	
;$5217  8D 18 D0  STA $D018 	; bitmap at $e000, color memory at $cc00
;$521A  A9 20     LDA #$20
;$521C  0D 11 D0  ORA $D011
;$521F  29 EF     AND #$EF
;$5221  8D 11 D0  STA $D011  ; bitmap mode on, display enable off
;$5224  78        SEI 
;$5225  A9 03     LDA #$03
;$5227  05 01     ORA $01
;$5229  29 FD     AND #$FD
;$522B  85 01     STA $01 ; ram at $a000 (basic)?
		;org $5200
		;:$522d-* nop
		;ert *<>$522d
;-------------------------------------------------------------------------
;$5276  20 00 C0  JSR L_JSR_($C000)_($5276) OK	; INIT SID TODO:
		org $5276
		nop
		nop
		nop
		ert *<>$5279
		
;-------------------------------------------------------------------------
;$525C  A9 F0     LDA #$F0
;$525E  8D FA FF  STA $FFFA 
;$5261  A9 83     LDA #$83
;$5263  8D FB FF  STA $FFFB 	; set NMI vector
		org $525c
		:$5266-* nop
		ert *<>$5266

		org $7507
		jmp speedup_7507
		:$751e-* nop
		ert *<>$751e
;-------------------------------------------------------------------------
;$74AC  A9 CF     LDA #$CF
;$74AE  85 0A     STA $0A 
		org $74ac
		lda #$cc
		
;-------------------------------------------------------------------------
;$7640  A5 04     LDA $04 
;$7642  18        CLC 
;$7643  69 40     ADC #$40	; TODO: stride for screen? ($140)
;$7645  85 04     STA $04 
;$7647  A5 05     LDA $05 
;$7649  69 01     ADC #$01
;$764B  85 05     STA $05 
;$764D  C9 BE     CMP #$BE
;$764F  F0 09     BEQ L_BRS_($765A)_($764F) OK
;$7651  D0 2C     BNE L_BRS_($767F)_($7651) OK
		org $7640
		inc $05
		lda $05
		cmp #$b8
		beq $765a
		bne $767f
		:$7653-* nop
		ert *<>$7653
		
;-------------------------------------------------------------------------
;$7670  38        SEC 
;$7671  E9 40     SBC #$40; TODO: stride for screen? ($140)
;$7673  85 04     STA $04 
;$7675  A5 05     LDA $05 
;$7677  E9 01     SBC #$01
;$7679  85 05     STA $05 
;$767B  C9 9E     CMP #$9E
;$767D  F0 AE     BEQ L_BRS_($762D)_($767D) OK
		org $7670
		sta $04
		dec $05
		lda $05
		cmp #$9f
		beq $762d
		bne $767f
		:$767f-* nop
		ert *<>$767f

;-------------------------------------------------------------------------
;$778F  86 02     STX $02 	; TODO: set screen position pointers; X = x coordinate, Y = y coordinate
;$7791  84 10     STY $10 	; $02 = x, $10 = y
;$7793  A9 BF     LDA #$BF	; y = $bf - y (191 - y)
;$7795  38        SEC 
;$7796  E5 10     SBC $10 
;$7798  85 10     STA $10 
;$779A  A9 F8     LDA #$F8
;$779C  25 02     AND $02
;$779E  85 06     STA $06 	; $06 = x & #$f8 (align to byte boundary)
;$77A0  A5 10     LDA $10 
;$77A2  29 07     AND #$07
;$77A4  05 06     ORA $06
;$77A6  A8        TAY 		; Y(reg) = (x & #$f8 | y & #$07)
;$77A7  A9 00     LDA #$00
;$77A9  85 03     STA $03 
;$77AB  A9 F8     LDA #$F8
;$77AD  25 10     AND $10
;$77AF  0A        ASL A 
;$77B0  26 03     ROL $03 
;$77B2  0A        ASL A 
;$77B3  26 03     ROL $03 
;$77B5  0A        ASL A 
;$77B6  26 03     ROL $03 
;$77B8  85 02     STA $02 	; WORD[$02] = (y & #$f8) * 8
;$77BA  A5 10     LDA $10 
;$77BC  4A        LSR A 
;$77BD  4A        LSR A 
;$77BE  4A        LSR A 
;$77BF  18        CLC 
;$77C0  65 03     ADC $03 	; $03 += (y / 8) (adjustment of address for 320 pixels in video memory?)
;$77C2  85 03     STA $03 
;$77C4  18        CLC 
;$77C5  A5 02     LDA $02 
;$77C7  69 20     ADC #$20
;$77C9  85 02     STA $02 	; $02 += #$20 (4 bytes, centering on 320 pixels c64 screen?)
;$77CB  85 04     STA $04 
;$77CD  08        PHP 
;$77CE  A5 03     LDA $03 
;$77D0  69 A0     ADC #$A0
;$77D2  85 05     STA $05 	; WORD[$05]: pointer to backbuffer (at $a000)
;$77D4  28        PLP 
;$77D5  A5 03     LDA $03 
;$77D7  69 E0     ADC #$E0	; WORD[$03]: pointer to bitmap ($e000)
;$77D9  85 03     STA $03 
;$77DB  8A        TXA 		; bit number in byte in screen memory (in X reg)
;$77DC  29 07     AND #$07	
;$77DE  85 06     STA $06 
;$77E0  A9 07     LDA #$07
;$77E2  38        SEC 
;$77E3  E5 06     SBC $06 
;$77E5  AA        TAX 
;$77E6  60        RTS 

		org $778F
		;tya			; 2
		;eor #$bf	; 2
		;sty $10	; 3
		;lda #$bf	; 2
		;sec		; 2
		;sbc $10	; 3
		tya			; 2
		eor #$ff	; 2 reverse subtract
		sec			; 2
		adc #$bf	; 2
		sta $10		; 3
		and #$07	; 2
		sta $06		; 3
		txa			; 2
		and #$f8	; 2
		ora $06		; 3
		tay			; 2 ; 21

		;lda $10		; 3
		;and #$f8	; 2
		;asl @		; 2
		;adc #$00	; 2
		;asl @		; 2
		;adc #$00	; 2
		;asl @		; 2
		;adc #$00	; 2
		;pha			; 3
		;and #$f8	; 2
		;sta $02		; 3
		;sta $04		; 3
		;pla			; 4
		;and #$07	; 2
		;sta $05
		lda #$00
		sta $02
		sta $04
		lda $10
		lsr @
		lsr @
		lsr @
		;clc
		;adc $05
		cmp #$18
		bcs ScreenOverflow
		ora #$a0	; 2
		sta $05		; 3
		ora #$e0	; 2
		sta $03		; 3 ; 44
	
End_778F	
		txa			; 2
		and #$07	; 2
		eor #$07	; 2
		tax			; 2 ; 8
					; 73
		rts
ScreenOverflow
		lda #>ScreenSafetyBuffer
		sta $05
		sta $03
		bne End_778F
		:$77e7-* nop
		ert *<>$77e7
		
;-------------------------------------------------------------------------
		org $7904
		jmp speedup_7904
		:$791f-* nop
		ert *<>$791f
		
;-------------------------------------------------------------------------
;$790A  A2 FE     LDX #$FE
;		org $790a
;		ldx #$f7
		
;-------------------------------------------------------------------------
		org $7bda
		jmp speedup_7bda
		
;-------------------------------------------------------------------------
;$7BDC  A2 1F     LDX #$1F
;		org $7bdc
;		ldx #$18
		
;-------------------------------------------------------------------------
;$7C11  A2 BE     LDX #$BE
		org $7c11
		ldx #$b7
		
; speedup
;-------------------------------------------------------------------------
;$7F40  A9 50     LDA #$50
;$7F42  85 14     STA $14 
;$7F44  A9 00     LDA #$00
;$7F46  85 13     STA $13 
;$7F48  A8        TAY 
;$7F49  20 F1 9B  JSR L_JSR_($9BF1)_($7F49) OK
		org $7f49
		jsr fill_page_50
		

; speedup
;-------------------------------------------------------------------------
;$7F65  A9 51     LDA #$51
;$7F67  85 14     STA $14 
;$7F69  A0 00     LDY #$00
;$7F6B  A9 FF     LDA #$FF
;$7F6D  20 F1 9B  JSR L_JSR_($9BF1)_($7F6D) OK
		org $7f6d
		jsr fill_page_51

; speedup
;-------------------------------------------------------------------------	
;$80B9  A9 53     LDA #$53
;$80BB  85 14     STA $14 
;$80BD  A9 00     LDA #$00
;$80BF  85 13     STA $13 
;$80C1  A8        TAY 
;$80C2  20 F1 9B  JSR L_JSR_($9BF1)_($80C2) OK
;$80C5  C6 14     DEC $14 
;$80C7  20 F1 9B  JSR L_JSR_($9BF1)_($80C7) OK
		org $80c2
		jsr fill_page_53
		
		org $80c7
		jsr fill_page_52
	
;-------------------------------------------------------------------------
;$81D5  B1 18     LDA ($18),Y 
;$81D7  49 FF     EOR #$FF
;$81D9  29 07     AND #$07
;$81DB  8D 2D 83  STA $832D 
		org $81db
		jsr set_mirror_83xx

;-------------------------------------------------------------------------
;$82E1  4C FA 82  JMP L_JMP_($82FA)_($82E1) OK		
		org $82e1
		jmp speedup_82fa
;//------------------------------
;$832A  85 0C     STA $0C 
;$832C  A9 00     LDA #$00
;$832E  49 FF     EOR #$FF
;$8330  29 07     AND #$07
;$8332  AA        TAX 
;$8333  A5 0C     LDA $0C 
;$8335  E0 00     CPX #$00
;$8337  F0 0A     BEQ L_BRS_($8343)_($8337) OK
;$8339  18        CLC 
;//------------------------------
;L_BRS_($833A)_($8341) OK
;//------------------------------
;$833A  6A        ROR A 
;$833B  90 03     BCC L_BRS_($8340)_($833B) OK
;$833D  09 80     ORA #$80
;$833F  18        CLC 
;//------------------------------
;L_BRS_($8340)_($833B) OK
;//------------------------------
;$8340  CA        DEX 
;$8341  D0 F7     BNE L_BRS_($833A)_($8341) OK
;//------------------------------
;L_BRS_($8343)_($8337) OK
;//------------------------------
		org $832a
		sta $0c
		tax
ldrt2	lda rot_table,x
		jmp $8343
set_mirror_83xx
		tax
		ora #>rot_table
		sta ldrt2+2
		sta s_82fa_rot+2
		txa
		rts
		:$8343-* nop
		ert *<>$8343
		
;-------------------------------------------------------------------------
;$83F3  20 00 C0  JSR L_JSR_($C000)_($83F3) OK	; TODO: SID
		org $83f3
		nop
		nop
		nop
		
;-------------------------------------------------------------------------
;$840F  20 90 84  JSR L_JSR_($8490)_($840F) OK
		org $840f
		jsr wait_for_key_or_joy_title_screen	
		
;-------------------------------------------------------------------------
;$8490  A9 00     LDA #$00		; TODO: wait for any key
;$8492  20 98 84  JSR L_JSR_($8498)_($8492) OK
;$8495  F0 F9     BEQ L_BRS_($8490)_($8495) OK
;$8497  60        RTS 
		org $8490
		jmp wait_for_key_or_joy
		:$8498-* nop
		ert *<>$8498
		
;-------------------------------------------------------------------------
;$8498  8D 00 DC  STA $DC00 	; TODO: read keyboard (A = keyboard line)
;$849B  AD 01 DC  LDA $DC01 
;$849E  49 FF     EOR #$FF
;$84A0  60        RTS 
		org $8498
		jsr readkey_c64
		nop
		nop
		nop
		eor #$ff
		rts
		:$84a1-* nop
		ert *<>$84a1
		
;-------------------------------------------------------------------------
;$84A1  A9 FF     LDA #$FF	; TODO: read joystick
;$84A3  20 98 84  JSR L_JSR_($8498)_($84A3) OK
;$84A6  29 1F     AND #$1F
;$84A8  60        RTS 
		org $84a1
		jmp read_joystick
		:$84a9-* nop
		ert *<>$84a9
		
;-------------------------------------------------------------------------
;$84A9  A5 2E     LDA $2E 		; TODO: set screen color
;$84AB  C9 30     CMP #$30
;$84AD  D0 04     BNE L_BRS_($84B3)_($84AD) OK
;$84AF  A9 07     LDA #$07
;$84B1  D0 42     BNE L_BRS_($84F5)_($84B1) OK
;//------------------------------
;L_BRS_($84B3)_($84AD) OK
;//------------------------------
;$84B3  C9 38     CMP #$38
;$84B5  D0 04     BNE L_BRS_($84BB)_($84B5) OK
;$84B7  A9 01     LDA #$01
;$84B9  D0 3A     BNE L_BRS_($84F5)_($84B9) OK
;//------------------------------
;L_BRS_($84BB)_($84B5) OK
;//------------------------------
;$84BB  C9 10     CMP #$10
;$84BD  D0 04     BNE L_BRS_($84C3)_($84BD) OK
;$84BF  A9 02     LDA #$02
;$84C1  D0 32     BNE L_BRS_($84F5)_($84C1) OK
;//------------------------------
;L_BRS_($84C3)_($84BD) OK
;//------------------------------
;$84C3  C9 68     CMP #$68
;$84C5  D0 04     BNE L_BRS_($84CB)_($84C5) OK
;$84C7  A9 03     LDA #$03
;$84C9  D0 2A     BNE L_BRS_($84F5)_($84C9) OK
;//------------------------------
;L_BRS_($84CB)_($84C5) OK
;//------------------------------
;$84CB  C9 48     CMP #$48
;$84CD  D0 04     BNE L_BRS_($84D3)_($84CD) OK
;$84CF  A9 0E     LDA #$0E
;$84D1  D0 22     BNE L_BRS_($84F5)_($84D1) OK
;//------------------------------
;L_BRS_($84D3)_($84CD) OK
;//------------------------------
;$84D3  C9 78     CMP #$78
;$84D5  D0 04     BNE L_BRS_($84DB)_($84D5) OK
;$84D7  A9 01     LDA #$01
;$84D9  D0 1A     BNE L_BRS_($84F5)_($84D9) OK
;//------------------------------
;L_BRS_($84DB)_($84D5) OK
;//------------------------------
;$84DB  C9 06     CMP #$06
;$84DD  D0 04     BNE L_BRS_($84E3)_($84DD) OK
;$84DF  A9 60     LDA #$60
;$84E1  D0 12     BNE L_BRS_($84F5)_($84E1) OK
;//------------------------------
;L_BRS_($84E3)_($84DD) OK
;//------------------------------
;$84E3  C9 70     CMP #$70
;$84E5  D0 04     BNE L_BRS_($84EB)_($84E5) OK
;$84E7  A9 07     LDA #$07
;$84E9  D0 0A     BNE L_BRS_($84F5)_($84E9) OK
;//------------------------------
;L_BRS_($84EB)_($84E5) OK
;//------------------------------
;$84EB  C9 08     CMP #$08
;$84ED  D0 04     BNE L_BRS_($84F3)_($84ED) OK
;$84EF  A9 06     LDA #$06
;$84F1  D0 02     BNE L_BRS_($84F5)_($84F1) OK
;//------------------------------
;L_BRS_($84F3)_($84ED) OK
;//------------------------------
;$84F3  A9 70     LDA #$70
;//------------------------------
;L_BRS_($84F5)_($84B1) OK
;L_BRS_($84F5)_($84B9) OK
;L_BRS_($84F5)_($84C1) OK
;L_BRS_($84F5)_($84C9) OK
;L_BRS_($84F5)_($84D1) OK
;L_BRS_($84F5)_($84D9) OK
;L_BRS_($84F5)_($84E1) OK
;L_BRS_($84F5)_($84E9) OK
;L_BRS_($84F5)_($84F1) OK
;//------------------------------
;$84F5  A2 00     LDX #$00
;//------------------------------
;L_BRS_($84F7)_($8504) OK
;//------------------------------
;$84F7  9D 00 CC  STA $CC00,X 
;$84FA  9D 00 CD  STA $CD00,X 
;$84FD  9D 00 CE  STA $CE00,X 
;$8500  9D 00 CF  STA $CF00,X 
;$8503  CA        DEX 
;$8504  D0 F1     BNE L_BRS_($84F7)_($8504) OK
;$8506  A9 00     LDA #$00
;$8508  A2 03     LDX #$03
;//------------------------------
;L_BRS_($850A)_($850E) OK
;//------------------------------
;$850A  9D 00 CC  STA $CC00,X 
;$850D  CA        DEX 
;$850E  10 FA     BPL L_BRS_($850A)_($850E) OK
;$8510  A2 18     LDX #$18
;$8512  A9 CC     LDA #$CC
;$8514  85 03     STA $03 
;$8516  A9 24     LDA #$24
;$8518  85 02     STA $02 
;//------------------------------
;L_BRS_($851A)_($852F) OK
;//------------------------------
;$851A  A9 00     LDA #$00
;$851C  A0 07     LDY #$07
;//------------------------------
;L_BRS_($851E)_($8521) OK
;//------------------------------
;$851E  91 02     STA ($02),Y 
;$8520  88        DEY 
;$8521  10 FB     BPL L_BRS_($851E)_($8521) OK
;$8523  A9 28     LDA #$28
;$8525  18        CLC 
;$8526  65 02     ADC $02 
;$8528  85 02     STA $02 
;$852A  90 02     BCC L_BRS_($852E)_($852A) OK
;$852C  E6 03     INC $03 
;//------------------------------
;L_BRS_($852E)_($852A) OK
;//------------------------------
;$852E  CA        DEX 
;$852F  D0 E9     BNE L_BRS_($851A)_($852F) OK
;$8531  A2 27     LDX #$27
;$8533  A9 00     LDA #$00
;//------------------------------
;L_BRS_($8535)_($8539) OK
;//------------------------------
;$8535  9D C0 CF  STA $CFC0,X 
;$8538  CA        DEX 
;$8539  10 FA     BPL L_BRS_($8535)_($8539) OK
;$853B  60        RTS 
;		org $84f5
;		tax
;		lda c64colors,x
;		sta colpf1
;		and #$f0
;		sta colbak
;		sta colpf2
;		rts
;c64colors	dta $00, $0e, $26, $9c, $58, $ba, $74, $ee, $18, $e6, $2a, $06, $0a, $be, $7a, $0e

		org $84a9
		lda $2e
		lsr @
		lsr @
		lsr @
		and #$0f
		beq SetColorReverse
		cmp #$08
		beq SetColorReverse
		tax
		lda spectrum_color,x
		sta colpf1
		and #$f0
		sta colbak
		sta colpf2
		ora #$04
		sta colpm2
		ora #$06
		sta colpm3
		and #$f0
		ora #$08
		sta color3
		; hide/show pmg based on current screen number
		lda $54
		cmp #$4f ; title screen?
		beq SetColorPMGTitleScreen
		lda #$45
		sta hposm0
		lda #$46
		sta hposp2
		lda #$58
		sta hposp3
		lda #$5C+4-2
		sta hposm1
		lda	#$5C-4-2
		sta hposm2
		lda #$5C-12-2
		sta hposm3
		rts
SetColorPMGTitleScreen
		lda #$00
		sta hposm0
		sta hposp2
		sta hposp3
		sta hposm1
		sta hposm2
		sta hposm3
		rts
SetColorReverse
		lda $2e
		and #$07
		bvc SetColorReverseNoBright
		ora #$08
SetColorReverseNoBright
		tax
		lda spectrum_color,x
		sta colpf2
		and #$f0
		sta colpf1
		sta colbak
		jmp SetColorPMGTitleScreen
		
spectrum_color
		.he 00,86,26,46,c4,96,ec,0a
		.he 00,8c,2a,4e,ca,9c,ee,0e
		
		:$853c-* nop
		ert *<>$853c
		
		org $85ee
		lda mirror_table,x
	
;-------------------------------------------------------------------------
;$8C5F  A5 FF     LDA $FF 	; sound mode flag: 1 = sound effects
;$8C61  C9 01     CMP #$01
;$8C63  D0 2F     BNE L_BRS_($8C94)_($8C63) OK
		org $8c5f
		:$8c65-* nop
		
;-------------------------------------------------------------------------
;$8C75  A9 0F     LDA #$0F
;$8C77  8D 18 D4  STA $D418 				; TODO: SID
;$8C7A  A2 00     LDX #$00
;$8C7C  A9 30     LDA #$30
;$8C7E  20 9D C0  JSR L_JSR_($C09D)_($8C7E) OK	; TODO: SID (sound effect)?
;$8C81  A2 07     LDX #$07
;$8C83  A9 30     LDA #$30
;$8C85  20 9D C0  JSR L_JSR_($C09D)_($8C85) OK	; TODO: SID (sound effect)?
;$8C88  A2 0E     LDX #$0E
;$8C8A  A9 40     LDA #$40
;$8C8C  20 9D C0  JSR L_JSR_($C09D)_($8C8C) OK; TODO: SID (sound effect)?
;$8C8F  A9 00     LDA #$00
;$8C91  8D 18 D4  STA $D418 				; TODO: SID
		org $8c75
		lda #$0b
		sta sfx_effect
		:$8c94-* nop
		ert *<>$8c94
		
;-------------------------------------------------------------------------
;$9874  20 11 C0  JSR L_JSR_($C011)_($9874) OK	; TODO: switch sound type
;$9877  A9 0F     LDA #$0F
;$9879  8D 18 D4  STA $D418 	; Select SID output volume
;$987C  D0 03     BNE L_BRS_($9881)_($987C) OK
;//------------------------------
;L_BRS_($987E)_($986E) OK
;//------------------------------
;$987E  20 1E C0  JSR L_JSR_($C01E)_($987E) OK	; TODO: sound?
		org $9874
		:$9881-* nop
		ert *<>$9881

		org $99E6
		jmp FrameSync
		
;-------------------------------------------------------------------------
;$99F6  A9 EF     LDA #$EF	; TODO: display disable
;$99F8  2D 11 D0  AND $D011 
;$99FB  8D 11 D0  STA $D011 
;$99FE  60        RTS 
		org $99f6
		;lda #0
		;lda #%00100001
		;sta _dmactl
		;rts
		jmp disable_screen
		:$99ff-* nop
		ert *<>$99ff
		
;-------------------------------------------------------------------------
;$99FF  A9 10     LDA #$10		; TODO: display enable
;$9A01  0D 11 D0  ORA $D011
;$9A04  8D 11 D0  STA $D011 
;$9A07  60        RTS 
		org $99ff
		;lda #%00100001
		lda #@dmactl(narrow|dma|players|missiles|lineX2)
		sta _dmactl
		rts
		:$9a08-* nop
		ert *<>$9a08
	
; speedup
;-------------------------------------------------------------------------
;$9B65  A9 51     LDA #$51
;$9B67  85 14     STA $14 
;//------------------------------
;L_BRS_($9B6A)_($9B50) BAD
;//------------------------------
;$9B69  A9 00     LDA #$00
;$9B6B  85 13     STA $13 
;$9B6D  85 91     STA $91 
;$9B6F  A8        TAY 
;$9B70  20 F1 9B  JSR L_JSR_($9BF1)_($9B70) OK
;$9B73  A9 50     LDA #$50
;$9B75  85 14     STA $14 
;$9B77  A9 00     LDA #$00
;//------------------------------
;L_BRS_($9B7B)_($9B19) BAD
;//------------------------------
;$9B79  20 F1 9B  JSR L_JSR_($9BF1)_($9B79) OK
		org $9b70
		jsr fill_page_51
		
		org $9b79
		jsr fill_page_50

; speedup		
;-------------------------------------------------------------------------
;$9C55  A6 84     LDX $84 
;$9C57  A8        TAY 
;$9C58  20 8F 77  JSR L_JSR_($778F)_($9C58) OK
;$9C5B  84 06     STY $06 
;$9C5D  8E 82 9C  STX $9C82 
;$9C60  B5 B0     LDA $B0,X 
;$9C62  85 1D     STA $1D 
;$9C64  49 FF     EOR #$FF
;$9C66  85 1C     STA $1C 
;$9C68  A9 50     LDA #$50
;$9C6A  85 1B     STA $1B 
		org $9c55
		ldx $84
		tay
		jsr $778f
		sty $06
		lda $b0,x
		sta $1d
		eor #$ff
		sta $1c
		ldy #<sp1_1c_check_nz
		cmp #$00
		bne sp1_04
		ldy #<sp1_1c_check_z
sp1_04	sty	sp1_1c_check+1
		ert >sp1_1c_check_nz <> >sp1_1c_check_z
		txa
		ora #>rot_table
		sta ldrt1+2
		ldx #<sp1_91_check1_z
		ldy #<sp1_91_check2_z
		lda #$02
		bit $91
		beq sp1_03
		ldx #<sp1_91_check1_nz
		ldy #<sp1_91_check2_nz
sp1_03
		stx sp1_91check_1+1
		sty sp1_91check_2+1
		ert >sp1_91_check1_z <> >sp1_91_check1_nz
		ert >sp1_91_check2_z <> >sp1_91_check2_nz
		ldx $1a
		; more init?
;//------------------------------
;L_JMP_($9C6C)_($9D82) OK
;//------------------------------
;$9C6C  A5 06     LDA $06 
;$9C6E  48        PHA 
;$9C6F  A0 00     LDY #$00
;$9C71  B1 1A     LDA ($1A),Y 
;$9C73  05 1C     ORA $1C
;$9C75  91 1A     STA ($1A),Y 
;$9C77  A5 93     LDA $93 
;$9C79  85 1F     STA $1F 
;$9C7B  A9 00     LDA #$00
;$9C7D  85 13     STA $13 
sp1_main_loop
		lda $06
		pha
		lda $5000,x
		ora $1c
		sta $5000,x
		lda $93
		sta $1f
		lda #$00
		sta $13
;//------------------------------
;L_JMP_($9C7F)_($9D0E) OK
;//------------------------------
;$9C7F  A0 00     LDY #$00
;$9C81  A9 00     LDA #$00
;$9C83  49 FF     EOR #$FF
;$9C85  29 07     AND #$07
;$9C87  AA        TAX 
;$9C88  B1 18     LDA ($18),Y 
;$9C8A  E0 00     CPX #$00
;$9C8C  F0 0A     BEQ L_BRS_($9C98)_($9C8C) OK
;$9C8E  18        CLC 
;//------------------------------
;L_BRS_($9C8F)_($9C96) OK
;//------------------------------
;$9C8F  6A        ROR A 
;$9C90  90 03     BCC L_BRS_($9C95)_($9C90) OK
;$9C92  09 80     ORA #$80
;$9C94  18        CLC 
;//------------------------------
;L_BRS_($9C95)_($9C90) OK
;//------------------------------
;$9C95  CA        DEX 
;$9C96  D0 F7     BNE L_BRS_($9C8F)_($9C96) OK
;//------------------------------
;L_BRS_($9C98)_($9C8C) OK
;//------------------------------
sp1_inner_loop
		ldy #$00
		lda ($18),y
		tay
ldrt1	lda rot_table,y

;$9C98  85 14     STA $14 
;$9C9A  25 1D     AND $1D
;$9C9C  05 13     ORA $13
;$9C9E  85 11     STA $11 
;$9CA0  E6 1B     INC $1B 
;$9CA2  B1 1A     LDA ($1A),Y 
;$9CA4  85 12     STA $12 
;$9CA6  49 FF     EOR #$FF
;$9CA8  25 11     AND $11
;$9CAA  85 11     STA $11 
;$9CAC  A5 12     LDA $12 
;$9CAE  A4 06     LDY $06 
;$9CB0  31 04     AND ($04),Y 
;$9CB2  05 11     ORA $11
		sta $14
		and $1d
		ora $13
		sta $11
		lda $5100,x
		;sta $12
		eor #$ff
		and $11
		sta $11
		;lda $12
		lda $5100,x
		ldy $06
		and ($04),y
		ora $11
sp1_91check_1
		jmp sp1_91_check1_nz
;$9CBC  85 11     STA $11 
;$9CBE  E6 1B     INC $1B 
;$9CC0  A0 00     LDY #$00
;$9CC2  B1 1A     LDA ($1A),Y 
;$9CC4  25 12     AND $12
;$9CC6  49 FF     EOR #$FF
;$9CC8  85 12     STA $12 
;$9CCA  49 FF     EOR #$FF
;$9CCC  05 11     ORA $11
;$9CCE  85 11     STA $11 
;$9CD0  E6 1B     INC $1B 
;$9CD2  B1 1A     LDA ($1A),Y 
;$9CD4  05 12     ORA $12
;$9CD6  25 11     AND $11
sp1_91_check1_nz
		sta $11
		lda $5200,x
		and $5100,x
		eor #$ff
		sta $12
		eor #$ff
		ora $11
		sta $11
		lda $5300,x
		ora $12
		and $11
;$9CD9  68        PLA 
;$9CDA  85 11     STA $11 
;$9CDC  A9 50     LDA #$50
;$9CDE  85 1B     STA $1B 
;$9CE0  A0 00     LDY #$00
;$9CE2  B1 1A     LDA ($1A),Y 
;$9CE4  85 12     STA $12 
;$9CE6  49 FF     EOR #$FF
;$9CE8  25 11     AND $11
;$9CEA  85 11     STA $11 
;$9CEC  A4 06     LDY $06 
;$9CEE  B1 02     LDA ($02),Y 
;$9CF0  25 12     AND $12
;$9CF2  05 11     ORA $11
;$9CF4  91 02     STA ($02),Y 
;$9CF6  98        TYA 
;$9CF7  18        CLC 
;$9CF8  69 08     ADC #$08
;$9CFA  85 06     STA $06 
;$9CFC  E6 1A     INC $1A 
;$9CFE  A5 14     LDA $14 
;$9D00  25 1C     AND $1C
;$9D02  85 13     STA $13 
;$9D04  E6 18     INC $18 
;$9D06  D0 02     BNE L_BRS_($9D0A)_($9D06) OK
;$9D08  E6 19     INC $19 
;//------------------------------
;L_BRS_($9D0A)_($9D06) OK
;//------------------------------
;$9D0A  C6 1F     DEC $1F 
;$9D0C  F0 03     BEQ L_BRS_($9D11)_($9D0C) OK
;$9D0E  4C 7F 9C  JMP L_JMP_($9C7F)_($9D0E) OK
sp1_91_check1_z
		sta $11
		lda $5000,x
		;sta $12
		eor #$ff
		and $11
		sta $11
		;ldy $06
		lda ($02),y
		;and $12
		and $5000,x
		ora $11
		sta ($02),y
		tya
		clc
		adc #$08
		sta $06
		inx
		lda $14
		and $1c
		sta $13
		inc $18
		bne sp1_01
		inc $19
sp1_01	dec $1f
		beq sp1_02
		jmp sp1_inner_loop

;//------------------------------
;$9D11  48        PHA 
;$9D12  A5 1C     LDA $1C 
;$9D14  F0 5E     BEQ L_BRS_($9D74)_($9D14) OK
;$9D16  68        PLA 
;$9D17  85 11     STA $11 
;$9D19  E6 1B     INC $1B 
;$9D1B  A0 00     LDY #$00
;$9D1D  B1 1A     LDA ($1A),Y 
;$9D1F  85 12     STA $12 
;$9D21  49 FF     EOR #$FF
;$9D23  25 11     AND $11
;$9D25  85 11     STA $11 
;$9D27  A4 06     LDY $06 
;$9D29  B1 04     LDA ($04),Y 
;$9D2B  25 12     AND $12
;$9D2D  05 11     ORA $11
sp1_02	
sp1_1c_check
		jmp sp1_1c_check_nz
sp1_1c_check_nz
		sta $11
		lda $5100,x
		;sta $12
		eor #$ff
		and $11
		sta $11
		ldy $06
		lda ($04),y
		and $5100,x
		ora $11
		
;$9D2F  48        PHA 
;$9D30  A9 02     LDA #$02
;$9D32  24 91     BIT $91 
;$9D34  F0 1E     BEQ L_BRS_($9D54)_($9D34) OK
;$9D36  68        PLA 
;$9D37  85 11     STA $11 
;$9D39  E6 1B     INC $1B 
;$9D3B  A0 00     LDY #$00
;$9D3D  B1 1A     LDA ($1A),Y 
;$9D3F  25 12     AND $12
;$9D41  49 FF     EOR #$FF
;$9D43  85 12     STA $12 
;$9D45  49 FF     EOR #$FF
;$9D47  05 11     ORA $11
;$9D49  85 11     STA $11 
;$9D4B  E6 1B     INC $1B 
;$9D4D  B1 1A     LDA ($1A),Y 
;$9D4F  05 12     ORA $12
;$9D51  25 11     AND $11
sp1_91check_2
		jmp sp1_91_check2_nz
sp1_91_check2_nz
		sta $11
		lda $5200,x
		and $5100,x
		eor #$ff
		sta $12
		eor #$ff
		ora $11
		sta $11
		lda $5300,x
		ora $12
		and $11
;$9D54  68        PLA 
;$9D55  85 11     STA $11 
;$9D57  A9 50     LDA #$50
;$9D59  85 1B     STA $1B 
;$9D5B  A0 00     LDY #$00
;$9D5D  B1 1A     LDA ($1A),Y 
;$9D5F  05 1D     ORA $1D
;$9D61  85 12     STA $12 
;$9D63  49 FF     EOR #$FF
;$9D65  25 11     AND $11
;$9D67  85 11     STA $11 
;$9D69  A4 06     LDY $06 
;$9D6B  B1 02     LDA ($02),Y 
;$9D6D  25 12     AND $12
;$9D6F  05 11     ORA $11
;$9D71  91 02     STA ($02),Y 
;$9D73  48        PHA 
sp1_91_check2_z
		sta $11
		lda $5000,x
		ora $1d
		sta $12
		eor #$ff
		and $11
		sta $11
		ldy $06
		lda ($02),y
		and $12
		ora $11
		sta ($02),y
		
sp1_1c_check_z
		pla
		tay
		inx
		dec $87
;-------------------------------------------------------------------------
;$9D76  A8        TAY 
;$9D77  E6 1A     INC $1A 
;$9D79  C6 87     DEC $87 
;$9D7B  F0 08     BEQ L_BRS_($9D85)_($9D7B) OK
;$9D7D  20 86 9D  JSR L_JSR_($9D86)_($9D7D) OK
;$9D80  84 06     STY $06 
;$9D82  4C 6C 9C  JMP L_JMP_($9C6C)_($9D82) OK
;//------------------------------
;L_BRS_($9D85)_($9D7B) OK
;//------------------------------
;$9D85  60        RTS 
;//------------------------------
;L_JSR_($9D86)_($9D7D) OK
;//------------------------------
;$9D86  98        TYA 
;$9D87  29 07     AND #$07
;$9D89  C9 07     CMP #$07
;$9D8B  F0 02     BEQ L_BRS_($9D8F)_($9D8B) OK
;$9D8D  C8        INY 
;$9D8E  60        RTS 
;$9D8F  A5 02     LDA $02 
;$9D91  18        CLC 
;$9D92  69 40     ADC #$40	; TODO: stride for screen? ($140)
;$9D94  85 02     STA $02 
;$9D96  85 04     STA $04 
;$9D98  A5 03     LDA $03 
;$9D9A  69 01     ADC #$01
;$9D9C  85 03     STA $03 
;$9D9E  38        SEC 
;$9D9F  E9 40     SBC #$40
;$9DA1  85 05     STA $05 
;$9DA3  98        TYA 
;$9DA4  29 F8     AND #$F8
;$9DA6  A8        TAY 
;$9DA7  60        RTS 
	;	org $9d8f
	;	inc $03
	;	inc $05
	;	tya
	;	and #$f8
	;	tay
	;	rts
		;org $9d7b
		beq su10
		and #$07		; speedup - inlining routine called only once
		cmp #$07
		beq su11
		iny
		sty $06
		jmp sp1_main_loop
su10	stx $1a
		rts
su11	inc $03			; fix for screen stride
		inc $05
		; test
		lda $03
		cmp #$f8
		bcs ScreenOverflow2
ScreenOverflow2Continue		
		tya
		and #$f8
		sta $06
		jmp sp1_main_loop
ScreenOverflow2
		lda #>ScreenSafetyBuffer
		sta $03
		sta $05
		jmp ScreenOverflow2Continue
		
		:$9da8-* nop
		ert *<>$9da8
		
		org $9da8+3
; texts for C64 title screen
		.he C8 58 AA 
		.he 06 01 09 12 0C 09 07 08 14	; FAIRLIGHT
		.he C8 58 A0 
		.he 01 00 10 12 05 0C 15 04 05 ; A PRELUDE
		.he C8 3C 82 
		.he 02 19 00 02 0F 00 0A 01 0E 07 05 02 0F 12 07 00 ; BY BO JANGEBORD
		.he C8 4C 78 
		.he 06 0F 12 00 14 08 05 00 05 04 07 05 ; FOR THE EDGE
		.he C8 14 50 
		.he 11 26 14 ; Q-T
		.he C8 14 46 
		.he 01 26 06 ; A-F
		.he C8 14 64 
		.he 19 26 10 ; Y-P
		.he C8 14 5A 
		.he 07 26 0C ; G-L
		.he C8 14 3C 
		.he 27 ;26 13 08 09 06 14 ; ?-SHIFT
		.he C8 14 32 
		.he 0E 26 28 ; N->
		.he C8 14 28 
		.he 18 26 02 ; X-B
		.he C8 14 1E 
		;.he 13 08 09 06 14 26 1A ; SHIFT-Z
		.he 1A
		.he C8 14 14 
		.he 1C 26 20 ; 1-5
		.he C8 14 0A 
		.he 22 26 1B ; 7-0
		.he C8 7C 3C 
		.he 0A 15 0D 10 ; JUMP
		.he C8 7C 32 
		.he 06 09 07 08 14 ; FIGHT
		.he C8 7C 28 
		.he 10 09 03 0B ; PICK
		.he C8 7C 1E 
		.he 04 12 0F 10 ; DROP
		.he C8 7C 14 
		.he 0F 02 0A ; OBJ
		.he C8 7C 0A 
		.he 15 13 05 ; USE
		;.he C8 A4 17 
		;.he 03 21 1F 00 16 05 12 13 09 0F 0E ; C64 VERSION
		;.he C8 A4 0F 
		;.he 02 19 00 14 25 00 09 0E 0E 13 ; BY T. INNS
		.he C8 A4 64 
		;.he 06 1C 26 0D 15 13 09 03 ; F1-MUSIC
		;.he 0F 10 14 09 0F 0E; OPTION
		.he 13 05 0C 05 03 14; SELECT
		.he C8 BC 5A 
		;.he 13 14 05 10 13 ; STEPS
		.he 0D 15 13 09 03 ; MUSIC
		.he C8 BC 50 
		;.he 13 09 0C 05 0E 03 05 ; SILENCE
		.he 13 14 05 10 13 ; STEPS
		.he A4 
		rts
		ert *>=$9e8b
		; free memory until $9ec2 ($60 bytes)




;-------------------------------------------------
;$9E8B  A2 0A     LDX #$0A	; TODO: this makes string "C64 VERSION BY T. INNS" on title screen to appear in non-negative mode
;$9E8D  A9 70     LDA #$70
;//------------------------------
;L_BRS_($9E8F)_($9E96) OK
;//------------------------------
;$9E8F  9D 60 CF  STA $CF60,X 
;$9E92  9D 88 CF  STA $CF88,X 
;$9E95  CA        DEX 
;$9E96  10 F7     BPL L_BRS_($9E8F)_($9E96) OK
;$9E98  A2 07     LDX #$07
;//------------------------------
;L_BRS_($9E9A)_($9EBF) OK
;//------------------------------
;$9E9A  BD 00 FB  LDA $FB00,X 
;$9E9D  29 0F     AND #$0F
;$9E9F  9D 00 FB  STA $FB00,X 
;$9EA2  BD 40 FC  LDA $FC40,X 
;$9EA5  29 0F     AND #$0F
;$9EA7  9D 40 FC  STA $FC40,X 
;$9EAA  BD 90 FC  LDA $FC90,X 
;$9EAD  29 F0     AND #$F0
;$9EAF  9D 90 FC  STA $FC90,X 
;$9EB2  BD 58 FB  LDA $FB58,X 
;$9EB5  49 FF     EOR #$FF
;$9EB7  29 F0     AND #$F0
;$9EB9  09 0C     ORA #$0C
;$9EBB  9D 58 FB  STA $FB58,X 
;$9EBE  CA        DEX 
;$9EBF  10 D9     BPL L_BRS_($9E9A)_($9EBF) OK
;$9EC1  60        RTS 
;		org $9e8b
;		rts
		
;		ldx #19*8
;		ldy #16
;		jsr $778f
;		iny
		; 1st line
;		ldx #$07
;ts0		lda ($02),y
;		eor #$0f
;		sta ($02),y
;		iny
;		dex
;		bpl ts0
;ts1		lda ($02),y
;		eor #$ff
;		sta ($02),y
;		iny
;		cpy #256-8
;		bne ts1
;ts11	lda ($02),y
;		eor #$f0
;		sta ($02),y
;		iny
;		bne ts11
;		jmp second_line_9e8b
		:$9ec2-* nop
		ert *<>$9ec2
		
; speedup
;-------------------------------------------------------------------------
;$9F67  A9 50     LDA #$50
;$9F69  85 14     STA $14 
;$9F6B  A9 00     LDA #$00
;$9F6D  85 13     STA $13 
;$9F6F  A8        TAY 
;$9F70  20 F1 9B  JSR L_JSR_($9BF1)_($9F70) OK
;$9F73  E6 14     INC $14 
;$9F75  20 F1 9B  JSR L_JSR_($9BF1)_($9F75) OK
		org $9f70
		jsr fill_page_50
		
		org $9f75
		jsr fill_page_51
		
; speedup
;-------------------------------------------------------------------------
;$9F9C  A9 51     LDA #$51
;$9F9E  85 14     STA $14 
;$9FA0  A9 00     LDA #$00
;$9FA2  85 13     STA $13 
;$9FA4  A8        TAY 
;$9FA5  A9 FF     LDA #$FF
;$9FA7  20 F1 9B  JSR L_JSR_($9BF1)_($9FA7) OK
;$9FAA  C6 14     DEC $14 
;$9FAC  A9 00     LDA #$00
;$9FAE  20 F1 9B  JSR L_JSR_($9BF1)_($9FAE) OK
		org $9fa7
		jsr fill_page_51
		
		org $9fae
		jsr fill_page_50
		
;-------------------------------------------------------------------------
		org $5000
start	cld
		ldx #$ff
		txs
		jsr atariinit
		jmp $522d
		
atariinit	equ *
		; init ANTIC + interrupts
		sei
		lda #0
		sta nmien	; disable interrupts
		sta irqen
		sta dmactl	; disable screen
		lda #$02
		sta chrctl
		lda #%11111110
		sta portb

		lda #$a0
		ldy #>atari_code
		ldx #atari_code_size
		jsr ldcopy
		
		lda #<nmi
		sta $fffa
		lda #>nmi
		sta $fffb
		lda #<irq
		sta $fffe
		lda #>irq
		sta $ffff
		
; memclear
		ldx #0
		txa
mm4		sta $0,x
		inx
		bne mm4

		; copy mem
		;lda #$d8
		;ldy #$08
		;ldx #$18
		;jsr ldcopy
		lda #$cc
		ldy #>mirror_table
		ldx #$01
		jsr ldcopy

		lda #$a0
		ldx #$18
		jsr memclear
		lda #$e0
		ldx #$18
		jsr memclear
		lda #$cd
		ldx #$3
		jsr memclear
		
		jsr init_rot_table
		
		; set screen data
		lda #$80
		clc
		ldy #$00
SetScreenDataLoop		
		sta $cd00,y
		iny
		adc #$01
		bcc SetScreenDataLoop
		
		; set screen
		lda #<dlist
		sta dlptr
		lda #>dlist
		sta dlptr+1
		lda #%00100001
		sta dmactl
		sta _dmactl
		lda #$c0
		sta nmien

		; init POKEY
		ldx #$08
		lda #$00
		sta skctl
clear	sta $d200,x
		dex
		bpl clear
		lda #$03
		sta skctl
		; init GTIA
		ldx #$0f
		lda #$00
cleargtia	sta $d000,x
		dex
		bpl cleargtia
		
		sta frame_counter
		sta last_frame_start
		
		; set colors
		lda #black
		sta colbak
		sta colpf2
		;lda #white
		sta colpf1
		
		; init PMG
		jsr PmgInit
		
		; init music
		; inicjalizacja playera na drugi utwor 
		ldx #<MUSIC_INGAME
		ldy #>MUSIC_INGAME
		lda #0
		jsr RASTERMUSICTRACKER		;Init
	
		rts
		
ldcopy	sta ldsrc+1
		sty lddest+1
		ldy #$0
		sty ldsrc
		sty lddest
ld1		lda (ldsrc),y
		sta (lddest),y
		iny
		bne ld1
		inc ldsrc+1
		inc lddest+1
		dex
		bne ld1
		rts
		
PmgInit
		lda #$80
		sta $02
		lda #$cd
		sta $03
		
		ldx #$0
		stx $04
PmgInitLoop		
		ldx $04
		lda PmgInitData,x
		cmp #$ff
		beq PmgInitEnd
		cmp #$fe
		beq PmgInitNext
		tay
		inx
		lda PmgInitData,x
		sta $05
		inx
		lda PmgInitData,x
		inx
		stx $04
		ldx $05
PmgFillLoop		
		sta ($02),y
		iny
		dex
		bne PmgFillLoop
		beq PmgInitLoop
PmgInitNext
		inx
		stx $04
		lda #$80
		clc
		adc $02
		sta $02
		scc:inc $03
		jmp PmgInitLoop
PmgInitEnd
		lda #$11
		sta gtictl
		lda #$E8
		sta color3
		lda #$03
		sta sizep0
		sta sizep1
		;lda #$5C	; skull
		;sta hposp0
		;lda #$7C	; skull
		;sta hposp1
		lda #$02	; skull
		sta colpm0
		sta colpm1	
		
		lda #$ff	; overlay
		sta sizem
		;lda #$45
		;sta hposm0
		lda #$01
		sta sizep2
		;lda #$46
		;sta hposp2
		;lda #$E4
		;sta colpm2
		lda #$01
		sta sizep3
		;lda #$58
		;sta hposp3
		;lda #$E6
		;sta colpm3
		;lda #$5C
		;sta hposm1
		lda #$00
		sta hposm2
		sta hposm3
		lda #$cc
		sta pmbase
		lda #$03
		sta pmcntl
		rts
		
PmgInitData
		dta $ae/2-1,4,3
		dta $d4/2-1,4,$fc
		dta $fe
		dta $38/2,$90/2,$ff
		dta $fe
		dta $38/2,$90/2,$ff
		dta $fe
		dta $b6/2,34/2-3,$7f
		dta $fe
		dta $cc/2-1,8/2,$ff
		dta $ff
		
memclear
		sta $03
		ldy #$00
		sty $02
		tya
mc1		sta ($02),y
		iny
		bne mc1
		inc $03
		dex
		bne mc1
		rts

init_rot_table
		lda #$07
		sta $ff
		lda #$00
		sta $fd
		lda #>rot_table
		sta $fe
rt1		ldy #0
rt5		tya
		ldx $ff
		cpx #$00
		beq rt2
		clc
rt4		ror @
		bcc rt3
		ora #$80
		clc
rt3		dex
		bne rt4
rt2		sta ($fd),y
		iny
		bne rt5
		inc $fe
		dec $ff
		bpl rt1
		rts

		org atari_code,$a000
FrameSync
FrameSyncWait		
		lda frame_counter
		sec
		sbc last_frame_start
		bpl FrameSyncCounterPositive
		eor #$ff
		clc
		adc #$01
FrameSyncCounterPositive
		cmp #FRAME_MIN
		bcc FrameSyncWait
FrameSyncEnd
		lda frame_counter
		sta last_frame_start
		;rts
		jmp $9856
		
nmi		bit nmist
		bpl vbl
		
dli		pha
		lda chradr
		clc
		adc #$04
		sta chradr
		sta wsync
		sta chbase
		pla
		rti

vbl		pha
		lda #>bitmapscreen
		sta chbase
		sta chradr
		lda _dmactl
		sta dmactl
		lda skstat
		and #$4
		bne vbl_nokey
		lda kbcode
		cmp #$1c
		bne vbl_nokey
		jmp $83f0
vbl_nokey
		inc frame_counter

		txa
		pha
		tya
		pha
		
		ldx PAL
		dex
		beq done_adjust
		dec adjust_counter
		bpl done_adjust
		mva #5 adjust_counter
		jmp done_music
		
done_adjust		
	lda $d01f				; ladujemy zawartosc rejestru CONSOL
	;cmp #$0D				; sprawdzamy czy jest nacisniety SELECT
	and #%010
	bne no_select
select
	;lda last_consol_state	; sprawdzamy czy od ostatniego sprawdzenia stan konsoli sie zmienil, tzn czy poprzednio klawisz SELECT byl nienacisniety
	;cmp #$0D
	eor last_consol_state
	beq no_select           ; jesli jest wcisniety caly czas to wychodzimy
	;lda #$0D
	lda $d01f
	and #%010
	sta last_consol_state   ; w przeciwnym razie zapisujemy jego stan
	lda sound_mode          ; sprawdzamy w jakim trybie jest player
	bne switch_to_music		; jesli nie jest to 0 to jestesmy w trybie efektow wiec przelaczamy na muzyke

switch_to_fx				; przelaczamy na efekty
	ldx #<MUSIC_INGAME      ; przy graniu efektow player musi byc caly czas wywolywany
	ldy #>MUSIC_INGAME      ; aby uniknac grania muzyki
	lda #$0A                ; przestawiamy go na sub-song nr 1 ktory petli sie na pustej linii 
	sta sound_mode
	jsr RASTERMUSICTRACKER
	jmp no_select	

switch_to_music             ; przelaczamy na muzyke - subsong nr 0
	ldx #<MUSIC_INGAME
	ldy #>MUSIC_INGAME
	lda #0
	sta sound_mode
	jsr RASTERMUSICTRACKER

no_select
	lda $d01f				; zapisujemy aktualny stan klawisza konsoli - bedziemy go sprawdzac jesli przy nastepnym przerwaniu wcisnieto SELECT
	and #%010
	sta last_consol_state

	lda sound_mode          ; sprawdzamy tryb playera jesli 0 to omijamy procedure odgrywania efektu
	beq playing_music       ; dzieki temu nawet jesli gra go wywola, to bedzie to ignorowane

playing_sfx					; gramy efekt - instrument o numerze w stx_effect
	lda #$f0				; glosnosc efektu - tylko gorna polowka
	sta RMTSFXVOLUME

	lda sfx_effect
	bmi playing_music		; jesli nr instrumentu to FF to wychodzimy 

	asl @						; * 2
	tay							;Y = 2,4,..,16	instrument  * 2 (0,2,4,..,126)
	ldx #6						;X = 6			kanal (6 - trzeci kanal prawego pokeya)
	lda #12						;A = 12			nuta (0..60)
	jsr RASTERMUSICTRACKER+15	;RMT_SFX start efekt

	lda sfx_effect				; powtarzamy procedure dla lewego pokeya
	bmi playing_music      		; RMT jest skonstruowany tak, ze jesli nie ma stereo to kody dla prawego pokeya sa nadpisywane i gra tylko lewy
								; dzieki temu nie musimy sprawdzac czy stereo jest czy go nie ma
	asl @						; * 2
	tay							;Y = 2,4,..,16	instrument * 2 (0,2,4,..,126)
	ldx #2						;X = 3			kanal (3 - trzeci kanal lewego (podstawowego) pokeya )
	lda #12						;A = 12			nuta (0..60)
	jsr RASTERMUSICTRACKER+15	;RMT_SFX start efekt
;
	lda #$ff
	sta sfx_effect				;resetujemy ustawiony efekt - dzieki temu wywola sie tylko raz
	
playing_music					; wywolanie playera co ramke - odgrywa efekt lub muzyke
	jsr RASTERMUSICTRACKER+3
		
done_music		
		pla
		tay
		pla
		tax
		pla
irq		rti

read_joystick
		lda trig0
		lsr @
		lda porta
		eor #$ff
		and #$0f
		bcs l1	
		ora #$10
l1		and #$1f
		rts

wait_for_key_or_joy_release
		lda skstat
		and #$04
		beq wait_for_key_or_joy_release
wait_for_key_or_joy_release_joy		
		jsr read_joystick
		bne wait_for_key_or_joy_release_joy
		rts
		
wait_for_key_or_joy
		jsr wait_for_key_or_joy_release
		lda skstat
		and #$4
		beq wait_for_key_or_joy_end
		jsr read_joystick
		beq wait_for_key_or_joy
wait_for_key_or_joy_end		
		rts
		
wait_for_key_or_joy_title_screen
		jsr wait_for_key_or_joy_release
		lda skstat
		and #$4
		bne check_joy
		lda kbcode
		cmp #$2d ; 'T'
		bne check_joy
		jmp Trainer
check_joy
		jsr read_joystick
		beq wait_for_key_or_joy_title_screen
		rts

readkey_c64
		eor #$ff
		sta keys_cols
		lda #$ff
		sta key_result
		lda skstat
		and #$04
		bne nokey
		stx rk_save_x+1
		sty rk_save_y+1
		lda kbcode
		bmi key_exit
		tay
		and #$3f
		tax
		lda atari_c64_keys,x
		and #$07
		tax
		lda _bits,x
		and keys_cols
		beq key_exit
		tya
		and #$3f
		tax
		lda atari_c64_keys,x
		lsr @
		lsr @
		lsr @
		lsr @
		tax
		lda _bits,x
		eor #$ff
		sta key_result
key_exit
rk_save_x
		ldx #$00
rk_save_y
		ldy #$00
nokey	lda key_result
		rts

		
atari_c64_keys
; c64 keyboard matrix
;  Bit    Col0  Col1  Col2  Col3  Col4  Col5  Col6  Col7
;  Row0   DEL   "3"   "5"   "7"   "9"   "+"   PND   "1"
;  Row1   RET   "W"   "R"   "Y"   "I"   "P"   "*"   <--
;  Row2   RIGHT "A"   "D"   "G"   "J"   "L"   ";"   CTRL
;  Row3   F7    "4"   "6"   "8"   "0"   "-"   HOME  "2"
;  Row4   F1    "Z"   "C"   "B"   "M"   "."  RSHIFT SPC
;  Row5   F3    "S"   "F"   "H"   "K"   ":"   "="   <C=>
;  Row6   F5    "E"   "T"   "U"   "O"   "@"   "^"   "Q"
;  Row7   DOWN LSHIFT "X"   "V"   "N"   ","   "/"   STOP
		dta $25	; L $00
		dta $42	; J $01
		dta $55	; ;: $02
		dta $ff	; F1 $03
		dta $ff	; F2 $04
		dta $54	; K $05
		dta $05	; +\ $06
		dta $16	; *^ $07
		dta $64	; O $08
		dta $ff	;   $09
		dta $15	; P $0A
		dta $63	; U $0B
		dta $17	; RETURN $0C
		dta $14	; I $0D
		dta $35	; -_ $0E
		dta $56	; =| $0F
		dta $73	; $10 V
		dta $ff	; $11 HELP
		dta $42	; $12 C
		dta $ff	; $13 F3
		dta $ff	; $14 F4
		dta $43	; $15 B
		dta $72 ; $16 X
		dta $41 ; $17 Z
		dta $31	; $18 4$
		dta $ff ; $19
		dta $01	; $1a 3#
		dta $32	; $1b 6&
		;dta $77 ; $1c ESC (RUN/STOP)
		dta $ff ; $1c ESC
		dta $02	; $1d 5%
		dta $37 ; $1e 2"
		dta $07 ; $1f 1!
		dta $75 ; $20 ,[
		;dta $47 ; $21 SPACE
		dta $77 ; $21 SPACE (RUN/STOP) (PAUSE)
		dta $45	; $22 .]
		dta $74	; $23 N
		dta $ff	; $24
		dta $44	; $25 M
		dta $76	; $26 /?
		dta $46 ; $27 LOGO (RSHIFT)
		dta $12	; $28 R
		dta $ff	; $29
		dta $61	; $2a E
		dta $13 ; $2b Y
		dta $ff	; $2c TAB
		dta $62	; $2d T
		dta $11	; $2e W
		dta $67	; $2f Q
		dta $04	; $30 9(
		dta $ff ; $31
		dta $34 ; $32 0)
		dta $03 ; $33 7'
		dta $00	; $34 BACKSPACE/DEL
		dta $33 ; $35 8@
		dta $ff ; $36 <CLEAR
		dta $ff ; $37 >INS
		dta $52 ; $38 F
		dta $53 ; $39 H
		dta $22 ; $3a D
		dta $ff ; $3b
		dta $ff ; $3c CAPS
		dta $23	; $3d G
		dta $51	; $3e S
		dta $21 ; $3f A
	
_bits	dta $01, $02, $04, $08, $10, $20, $40, $80
	
frame_counter		dta 0
last_frame_start	dta 0
FRAME_MIN = 2

sound_mode 
	dta 0	; tryb dzwieku 0 - muzyka, cokolwiek innego - efekty
sfx_effect 
	dta $ff	; nr instrumentu odgrywanego jako efekt, mozna zagrac dowolny. Wpisanie 0B powoduje odglos kroku jesli sound_mode == 1
			; FF oznacza brak (nie ma takiego instrumentu) i tak jest ustawiana ta flaga po odegraniu efektu
last_consol_state
	dta $02	; tu przechowujemy ostatni stan klawisza konsoli - czyli np. SELECT aby uniknac ciaglego przelaczania muzyka/efekty
			; gdy SELECT jest wcisniety i nie zostal puszczony

adjust_counter
		dta 5
			
keys_cols 	dta $00
key_result	dta $00
		
	
fill_page_50
		ldy #$1f
fp50	sta $5000,y
		sta $5020,y
		sta $5040,y
		sta $5060,y
		sta $5080,y
		sta $50a0,y
		sta $50c0,y
		sta $50e0,y
		dey
		bpl fp50
		iny
		rts
	
fill_page_51
		ldy #$1f
fp51	sta $5100,y
		sta $5120,y
		sta $5140,y
		sta $5160,y
		sta $5180,y
		sta $51a0,y
		sta $51c0,y
		sta $51e0,y
		dey
		bpl fp51
		iny
		rts
	
fill_page_52
		ldy #$1f
fp52	sta $5200,y
		sta $5220,y
		sta $5240,y
		sta $5260,y
		sta $5280,y
		sta $52a0,y
		sta $52c0,y
		sta $52e0,y
		dey
		bpl fp52
		iny
		rts

fill_page_53
		ldy #$1f
fp53	sta $5300,y
		sta $5320,y
		sta $5340,y
		sta $5360,y
		sta $5380,y
		sta $53a0,y
		sta $53c0,y
		sta $53e0,y
		dey
		bpl fp53
		iny
		rts

		
jump_82fa
		jmp $82fa
speedup_82fa
		; copies sprite data (pointer @ $13) to buffer at $5100 applying rotation
		; check if speedup can be run
		lda #$80	; check if 1a and 1e are both #$80
		cmp $1e
		bne jump_82fa
		cmp $1a
		bne jump_82fa
		lda $17
		cmp #$51
		bne jump_82fa
		; apply code changes
		lda $8352
		sta s_82fa_and+1
		eor #$ff
		sta s_82fa_and2+1
		; start
		ldx $16
		ldy #$00
speedup_82fa_outer_loop
		lda #$00
		sta $1c
		lda $94
		sta $1f
speedup_82fa_inner_loop
		lda ($13),y
		eor #$ff
		sta s_82fa_rot+1
s_82fa_rot
		lda rot_table
		sta $1d
s_82fa_and
		and #$00
		ora $1c
		eor #$ff
		sta $5100,x
		lda $1d
s_82fa_and2
		and #$00
		sta $1c
		inx
		iny
		dec $1f
		bne speedup_82fa_inner_loop
		eor #$ff
		sta $5100,x
		inx
		dec $1b
		bne speedup_82fa_outer_loop
		; epilogue
		stx $16
		tya
		clc
		adc $13
		sta $13
		bcc s_82fa_l1
		inc $14
s_82fa_l1
		jmp $83e0
		
speedup_7bda
		; copies screen buffer ($e000) to backbuffer ($a000), length $1800
		sty s7_restore_y+1
		ldy #$00
s7loop	lda $e000,y
		sta $a000,y
		lda $e100,y
		sta $a100,y
		lda $e200,y
		sta $a200,y
		lda $e300,y
		sta $a300,y
		lda $e400,y
		sta $a400,y
		lda $e500,y
		sta $a500,y
		lda $e600,y
		sta $a600,y
		lda $e700,y
		sta $a700,y
		lda $e800,y
		sta $a800,y
		lda $e900,y
		sta $a900,y
		lda $ea00,y
		sta $aa00,y
		lda $eb00,y
		sta $ab00,y
		lda $ec00,y
		sta $ac00,y
		lda $ed00,y
		sta $ad00,y
		lda $ee00,y
		sta $ae00,y
		lda $ef00,y
		sta $af00,y
		iny
		bne s7loop
s7loop2	lda $f000,y
		sta $b000,y
		lda $f100,y
		sta $b100,y
		lda $f200,y
		sta $b200,y
		lda $f300,y
		sta $b300,y
		lda $f400,y
		sta $b400,y
		lda $f500,y
		sta $b500,y
		lda $f600,y
		sta $b600,y
		lda $f700,y
		sta $b700,y
		iny
		bne s7loop2
s7_restore_y
		ldy #$ff
		rts
		
speedup_7904
		; clears screen buffer $e000
		ldx #$00
		txa
s7904_loop
		sta $e000,x
		sta $e100,x
		sta $e200,x
		sta $e300,x
		sta $e400,x
		sta $e500,x
		sta $e600,x
		sta $e700,x
		sta $e800,x
		sta $e900,x
		sta $ea00,x
		sta $eb00,x
		sta $ec00,x
		sta $ed00,x
		sta $ee00,x
		sta $ef00,x
		sta $f000,x
		sta $f100,x
		sta $f200,x
		sta $f300,x
		sta $f400,x
		sta $f500,x
		sta $f600,x
		sta $f700,x
		inx
		bne s7904_loop
		rts
		
;$7507  E6 0E     INC $0E 
;$7509  20 89 76  JSR L_JSR_($7689)_($7509) OK
;$750C  90 28     BCC L_BRS_($7536)_($750C) OK
;$750E  B1 04     LDA ($04),Y 
;$7510  D0 0C     BNE L_BRS_($751E)_($7510) OK
;$7512  A9 FF     LDA #$FF
;$7514  91 04     STA ($04),Y 
;$7516  20 0E 76  JSR L_JSR_($760E)_($7516) OK
;$7519  91 02     STA ($02),Y 
;$751B  4C 07 75  JMP L_JMP_($7507)_($751B) OK
speedup_7507
		; prepare
		; jsr 760f
		stx speedup_7507_load_x+1
		sty speedup_7507_load_y+1
		tya
		and #$0f
		bit $02
		bvc speedup_7507_prepare_1
		ora #$10
speedup_7507_prepare_1
		tay
		lda ($98),y
		sta speedup_7507_byte_0+1
		tya
		eor #$08
		tay 
		lda ($98),y
		sta speedup_7507_byte_1+1		
speedup_7507_load_y
		ldy #$00	
		ldx $0e
		sec
		; loop
speedup_7507_loop
		inx	
		tya			; jsr 7689
		sbc #$08
		bcc speedup_7507_exit_7536
		tay
		lda ($04),y
		bne speedup_7507_exit_751e
		lda #$ff
		sta ($04),y
speedup_7507_byte_0
		lda #$00
		sta ($02),y
		inx
		tya
		sbc #$08
		bcc speedup_7507_exit_7536
		tay
		lda ($04),y
		bne speedup_7507_exit_751e
		lda #$ff
		sta ($04),y
speedup_7507_byte_1
		lda #$00
		sta ($02),y
		jmp speedup_7507_loop
speedup_7507_exit_751e
		stx $0e
		
		;jmp $751e
		;speedup 751e
		lda ($04),y
		ldx #$ff
speedup_751e_loop		
		lsr @
		inx
		bcc speedup_751e_loop
		lda speedup_751e_masks,x
		sta $0b
		jmp $7533
speedup_751e_masks
		dta %00000001, %00000011, %00000111, %00001111, %00011111, %00111111, %01111111, %11111111
		
speedup_7507_exit_7536
		stx $0e
speedup_7507_load_x
		ldx #$00
		jmp $7536

disable_screen		
		lda #0
		sta _dmactl
		lda frame_counter
disable_screen_loop		
		cmp frame_counter
		beq disable_screen_loop
		rts

chradr	dta >bitmapscreen
_dmactl dta $00

;scr		:128 dta [#+$80]
scr 	equ $cd00

dlist	dta $70, $70, $70
		dta $42, a(scr), $02, $02, $82
		dta $42, a(scr), $02, $02, $82
		dta $42, a(scr), $02, $02, $82
		dta $42, a(scr), $02, $02, $82
		dta $42, a(scr), $02, $02, $82
		dta $42, a(scr), $02, $02, $02
		dta $41, a(dlist)

TrainerFlags
		dta 0, 0, 0, 0, 0, 0
		
Trainer
		jsr $99f6	; disable screen
		lda #$4f
		sta $54
		jsr $78ba	; render screen
		; clear arrows
		lda #8*8+32
TrainerClearLoopRows		
		pha
		jsr TrainerClearScreen
		pla
		sec
		sbc #$8
		cmp #8*8-8
		bcs TrainerClearLoopRows
		jsr $84a9	; set color
TrainerLoop		
		jsr TrainerUpdateTexts
		jsr $9b61	; print texts
		.he C8 58 AA 
		.he 06 01 09 12 0C 09 07 08 14	; FAIRLIGHT
		.he C8 58 A0 
		.he 01 00 10 12 05 0C 15 04 05 ; A PRELUDE
		.he C8 60 82
		.he 14 12 01 09 0E 05 12 ; TRAINER
		.he C8 14 64
		.he 1C 25 00 09 0E 06 09 0E 09 14 05 00 05 0E 05 12 07 19; 1. INFINITE ENERGY
		.he C8 14 5A
		.he 1D 25 00 09 0E 06 09 0E 09 14 05 00 13 03 12 0F 0C 0C 13; 2. INFINITE SCROLLS
		.he C8 14 50
		.he 1E 25 00 09 0E 06 09 0E 09 14 05 00 10 0F 14 09 0F 0E
		;.he ; 3. INFINITE POTION
		.he C8 14 46
		.he 1F 25 00 13 14 0F 10 00 05 0E 05 0D 09 05 13
		;.he ; 4. STOP ENEMIES
		.he C8 14 3C
		.he 20 25 00 01 0C 0C 00 04 0F 0F 12 13 00 0F 10 05 0E 
		;.he ; 5. ALL DOORS OPEN
		;.he 
		.he C8 14 32
		;.he ; 6. FLY MODE ON JUMP
		.he 21 25 00 06 0C 19 00 0D 0F 04 05 00 0F 0E 00 0A 15 0D 10
		.he C8 D4 64
TrainerFlagTexts		
		.he 0F 06 06
		.he C8 D4 5A
		.he 0F 06 06
		.he C8 D4 50
		.he 0F 06 06
		.he C8 D4 46
		.he 0F 06 06
		.he C8 D4 3C
		.he 0F 06 06
		.he C8 D4 32
		.he 0F 06 06
		.he A4
		jsr $99ff	; enable screen

TrainerWait	
		lda skstat
		and #$4
		bne TrainerWaitJoystick
		ldx #$00
		lda kbcode
TrainerKeyLoop		
		cmp TrainerKeys,x
		beq TrainerKeyChanged
		inx
		cpx #$6
		bne TrainerKeyLoop
TrainerWaitJoystick		
		jsr read_joystick
		beq TrainerWait
		
; TrainerApply
		ldx #$e5 ; sbc
		lda TrainerFlags
		beq TrainerApplyInifinteEnergy
		ldx #$24
TrainerApplyInifinteEnergy
		stx $8664
		stx $8672
		ldx #$91 ; sta (zp),y
		lda TrainerFlags+1
		beq TrainerApplyInifinteScrolls
		ldx #$24
TrainerApplyInifinteScrolls		
		stx $98DF
		stx $98E2
		ldx #$21
		lda TrainerFlags+2
		beq TrainerApplyInifintePotion
		ldx #$2f
TrainerApplyInifintePotion
		stx $98F7
		ldx #$0b
		lda TrainerFlags+3
		beq TrainerApplyStopEnemies
		ldx #$00
TrainerApplyStopEnemies		
		stx $872E
		ldx #$4c
		lda TrainerFlags+4
		beq TrainerApplyAllDoorsOpen
		ldx #$2c
TrainerApplyAllDoorsOpen
		stx $8FA8
		ldx #$4c
		lda TrainerFlags+5
		beq TrainerApplyFlyModeOnJump
		ldx #$2c
TrainerApplyFlyModeOnJump
		stx $8CAD
		rts
TrainerKeyChanged
		lda TrainerFlags,x
		eor #$ff
		sta TrainerFlags,x
WaitTrainerKeyRelease		
		lda skstat
		and #$4
		beq WaitTrainerKeyRelease
		jmp TrainerLoop
		
TrainerClearScreen
		ldx #14*8
		tay
		jsr $778f
		iny
		lda #$ff
		ldx #$00
TrainerClearLoop		
		sta ($02),y
		iny
		inx
		cpx #$28
		bne TrainerClearLoop
		rts
		
TrainerKeys
		dta $1f,$1e,$1a,$18,$1d,$1b
		
TrainerUpdateTexts
		ldx #0
		ldy #0
TrainerUpdateTextsLoop		
		lda TrainerFlags,x
		bne TrainerFlagOn
		lda #$0F
		sta TrainerFlagTexts,y
		lda #$06
		sta TrainerFlagTexts+1,y
		sta TrainerFlagTexts+2,y
		bne TrainerUpdateNext
TrainerFlagOn		
		lda #$0F
		sta TrainerFlagTexts,y
		lda #$0E
		sta TrainerFlagTexts+1,y
		lda #$00
		sta TrainerFlagTexts+2,y
TrainerUpdateNext
		tya
		clc
		adc #$06
		tay
		inx
		cpx #6
		bne TrainerUpdateTextsLoop
		rts
		
		ert * > atari_code_end
;fltest
;		jsr $99ff
;		lda #$4f
;fltest_loop
;		pha
;		sta $54
;		jsr $78ba
;		jsr $8490
;		pla
;		sec
;		sbc #$01
;		cmp #$01
;		bne fltest_loop
;		jmp fltest
		
		;org $5279
		;jmp fltest
		
		run start	
		
		
