/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: GED- (bitmap mode)           */
/***************************************/

dmactls equ $022f
dlptrs	equ $0230
gtictls equ $026f
colpm0s equ $02c0
colpm1s equ $02c1
colpm2s equ $02c2
colpm3s equ $02c3
color0s equ $02C4
color1s equ $02C5
color2s equ $02C6
color3s equ $02C7
color4s equ $02C8
chact	equ $02f3

	icl "loading.h"

	org $00

zc	.ds ZCOLORS

	org $f0

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
cloc	.ds 1
regA	.ds 1
regX	.ds 1
regY	.ds 1

WIDTH	= 32
HEIGHT	= 30

; ---	BASIC switch OFF
	org $2000\ mva #$ff portb\ rts\ ini $2000

; ---	MAIN PROGRAM
	org $2000
scr	ins "loading.raw"

	.ifdef nil_used
nil	:8*32 brk
	eif

	.ALIGN $0400
ant	ANTIC_PROGRAM scr,ant

fnt

main
; ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	lda:cmp:req $14		;wait 1 frame

	;sei			;stop interrups
	;mva #$00 nmien		;stop all interrupts
	;mva #$fe portb		;switch off ROM to get 16k more ram

	ZPINIT

////////////////////
// RASTER PROGRAM //
////////////////////

	;jmp raster_program_end

LOOP	lda vcount		;synchronization for the first screen line
	cmp #$02
	bne LOOP

	mva #scr32 dmactls	;set new screen width
	mva <ant dlptrs
	mva >ant dlptrs+1

; Initial values

c0	lda #$00
	sta colbaks
	lda #$02
	sta chact
	lda #$14
	sta gtictls
c1	lda #$EA
	sta color0s
c2	lda #$EE
	sta color1s
c3	lda #$E4
	sta color2s
c4	lda #$08
	sta color3s
s0	lda #$03
	sta sizep2
s1	lda #$03
	sta sizep3
x0	lda #$64
	sta hposp2
x1	lda #$84
	sta hposp3
c5	lda #$24
	sta colpm2s
c6	lda #$24
	sta colpm3s
s2	lda #$00
	sta sizem
x2	lda #$7C
	sta hposm0
x3	lda #$7E
	sta hposm1
x4	lda #$80
	sta hposm2
x5	lda #$82
	sta hposm3
c7	lda #$0C
	sta colpm0s
c8	lda #$0C
	sta colpm1s
s3	lda #$03
	sta sizep0
x6	lda #$60
	sta hposp0
s4	lda #$03
	sta sizep1
x7	lda #$80
	sta hposp1



raster_program_end

;	lda #$00
;	sta colpm0
;	sta colpm1
;	sta colpm2
;	sta colpm3
;	sta color0
;	sta color1
;	sta color2
;	sta color3
;	sta colbak

// -----------------------------------------------------------
//	EXIT
// -----------------------------------------------------------

;	lda trig0		; FIRE #0
;	beq stop

;	lda trig1		; FIRE #1
;	beq stop

;	lda consol		; START
;	and #1
;	beq stop

;	lda skctl		; ANY KEY
;	and #$04
;	bne skp

;stop	mva #$00 pmcntl		;PMG disabled
;	tax
;	sta:rne hposp0,x+

;	mva #$ff portb		;ROM switch on
;	mva #$40 nmien		;only NMI interrupts, DLI disabled
;	cli			;IRQ enabled

	rts			;return to ... DOS
;skp

// -----------------------------------------------------------

;	jmp LOOP

pmg equ $3800
	ift USESPRITES
	;.ALIGN $0800
;pmg	.ds $0300
	org $3b00
	ift FADECHR = 0
	SPRITES
	els
	.ds $500
	eif
	eif


;nil_used

.MACRO	ANTIC_PROGRAM
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	dta $70,$70,$70
	dta $4e,a(:1+$0000),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0100),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0200),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0300),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0400),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0500),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0600),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0700),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0800),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0900),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0A00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0B00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0C00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0D00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0E00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$0F00),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1000),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1100),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1200),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1300),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1400),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1500),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1600),$e,$e,$e,$e,$e,$e,$e
	dta $4e,a(:1+$1700),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	;dta $4e,a(nil),$e,$e,$e,$e,$e,$e,$e
	dta $41,a(:2)
.ENDM

CL

.MACRO	ZPINIT
.ENDM

ZCOLORS	= 0

FADECHR	= 0
; ---
	ini main
; ---

	opt l-

.MACRO	SPRITES
missiles
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 20 20
	.he E9 A8 14 88 DD 41 14 A8 55 14 14 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player0
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 20 20 20 30 38 38 1C 1E 0F 0F 07 07 03 01 01 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 7F 00 00 00 00 00 00 00 7F 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 04
	.he 04 04 0C 1C 1C 3C 38 78 F0 F0 E0 C0 C0 80 80 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 FE 00 00 00 00 00 00 00 FE 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player2
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 7F 7F FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FC 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player3
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 FE FE FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he 3F 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

