
; arkanoid game area: (28 x 32 "chars")
; - 2 lines of text
; - 1 line for the top tube
; - 18 lines of 13 bricks (plus the left and right tubes, half width of a brick each)
; - 8 empty lines
; - 1 line for the paddle
; - 1 empty line
; - 1 line for the extra paddles (players)

; bricks definition: (13x18 bricks, 18 lines of colors)
; 1: normal brick (one hit, plain color)
; 2: "gold" brick (restored after some seconds)
; 3: normal brick + bonus (one hit, plain color)
; 9 --> 14: "hard" brick need from 1 to 6 hits ($A .. $E)
; 15: "cross" brick, unbreakable ($F)

; 15 different bricks, 30 chars
; current list:
; - dark blue [0]
; - grey [1]
; - white dli, white [2,3]
; - "checkered" dli, white [4,5]
; - "diagonal" dli, white [6,7]
; - "pad" dli, white [8,9]
; - black (empty) [10] ($A)
; - "hard" dli, white [11,12] ($B,$C)
; - "cross" dli, white [13,14] ($D,$E)

; normal brick colors: (NTSC)
; - white: $0E
; - orange: $2A
; - cyan: $AC
; - green: $CA
; - red: $36
; - blue: $86
; - violet: $58
; - yellow: $1E
; + grey: $08
; + gold: $E8

; background colors:
; +colpf0 for backg 0, diagonal (+grey): $84, $94
; -colpf0 for backg 1, lines: $34, $44, -$84, $94, -$A4
; +colpf0 for backg 2, lines+squares: $34, $44, -$84, $94, -$A4
; colpf0 for backg 3, mountains: $34, $44, -$54, -$64, -$74, -$84, $94

; +colpf0 for backg 4, hex line: $34, $44, -$54, -$74, -$84, $94
; +colpf0 for backg 5, hex column filled: $34, $44, $54, -$64, -$74, $84, $94
; -colpf0 for backg 6, hex column filled (+grey): $34, $44, $84, $94
; -colpf0 for backg 7, hex circle: $34, $44, $84, $94


;================================================================================

; current level table (all levels are copied here first)
; 13*18 --> 234 + 20*2 + 3 = 277 bytes per level (x36 = 9972)

TabLevel
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0

	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0

	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0

	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0

TabDLI_COLPF2
	.byte 0,0						; 2 lines (first 2 border lines)
	.byte 1,1,1,1,1, 1,1,1,1,1
	.byte 1,1,1,1,1, 1,1,1			; 18 lines of bricks
	.byte 0,0,0,0,0, 0,0,0			; 8 lines

TabDLI_COLPF1
	.byte 0,0						; 2 lines (first 2 border lines)
	.byte 1,1,1,1,1, 1,1,1,1,1
	.byte 1,1,1,1,1, 1,1,1			; 18 lines of bricks
	.byte 0,0,0,0,0, 0,0,0			; 8 lines


;================================================================================

TabLevelAddress_LSB
	.byte <lv01
	.byte <lv14, <lv08
	.byte <lv07, <lv06, <lv02
	.byte <lv04, <lv20, <lv10, <lv18
	.byte <lv22, <lv09, <lv21, <lv16, <lv30
	.byte <lv25, <lv28, <lv23, <lv32, <lv34, <lv26
	.byte <lv13, <lv35, <lv27, <lv24, <lv03, <lv33, <lv31

TabLevelAddress_MSB
	.byte >lv01
	.byte >lv14, >lv08
	.byte >lv07, >lv06, >lv02
	.byte >lv04, >lv20, >lv10, >lv18
	.byte >lv22, >lv09, >lv21, >lv16, >lv30
	.byte >lv25, >lv28, >lv23, >lv32, >lv34, >lv26
	.byte >lv13, >lv35, >lv27, >lv24, >lv03, >lv33, >lv31


;================================================================================

TabLevelExtraAddress_LSB
	.byte <lv01b, <lv09, <lv08b, <lv02, <lv04
	.byte <lv22b, <lv06, <lv25, <lv21, <lv14, <lv07
	.byte <lv16, <lv18, <lv32, <lv26, <lv03, <lv35
	.byte <lv34, <lv24, <lv28, <lv33, <lv20, <lv10b
	.byte <lv27, <lv23, <lv13, <lv31b

TabLevelExtraAddress_MSB
	.byte >lv01b, >lv09, >lv08b, >lv02, >lv04
	.byte >lv22b, >lv06, >lv25, >lv21, >lv14, >lv07
	.byte >lv16, >lv18, >lv32, >lv26, >lv03, >lv35
	.byte >lv34, >lv24, >lv28, >lv33, >lv20, >lv10b
	.byte >lv27, >lv23, >lv13, >lv31b


;================================================================================
; all levels definitions
;================================================================================

lv01
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.by +$EA,0,0,0,0,0,0,0,0,0,0,0,0,0

	.by +$20,3,3,3,3,3,3,3,3,3,3,3,3,3
	.by +$20,1,1,1,1,1,1,1,1,1,1,1,1,1
	.by +$20,3,3,3,3,3,3,3,3,3,3,3,3,3
	.by +$20,1,1,1,1,1,1,1,1,1,1,1,1,1
	.by +$20,3,3,3,3,3,3,3,3,3,3,3,3,3

	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0

	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte 0,0,0,0,0, $26,$EE,$76,$48,$BA
	.byte 0,0,0,0,0, 0,0,0
; colpf1
	.byte $78,$78
	.byte 8,8,8,8,8, 8,8,8,8,8
	.byte 8,8,8,8,8, 8,8,8

; background index and color (colpf0)
	.byte 0, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte 0,0,0,0,0, $36,$1E,$86,$58,$CA
	.byte 0,0,0,0,0, 0,0,0
; colpf1
	.byte $88,$88
	.byte 8,8,8,8,8, 8,8,8,8,8
	.byte 8,8,8,8,8, 8,8,8

; background index and color (colpf0)
	.byte 0, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 78

;================================================================================

lv01b
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF
	.byte $23,$23,$23,$31,$23,$23,$00,$13,$13,$31,$13,$13,$13

	.byte $23,$23,$31,$31,$23,$23,$00,$13,$13,$31,$31,$13,$13
	.byte $23,$31,$31,$31,$31,$31,$00,$31,$31,$31,$31,$31,$13
	.byte $31,$31,$31,$31,$31,$31,$00,$31,$31,$31,$31,$31,$31
	.byte $23,$31,$31,$31,$31,$31,$00,$31,$31,$31,$31,$31,$13
	.byte $23,$23,$31,$31,$23,$23,$00,$13,$13,$31,$31,$13,$13

	.byte $23,$23,$23,$31,$23,$23,$00,$13,$13,$31,$13,$13,$13
	.byte $EA,$EA,$EA,$EA,$EA,$EA,$52,$EA,$EA,$EA,$EA,$EA,$EA
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $9E,$9E
	.byte $00,$00,$00,$EE,$26, $26,$26,$26,$26,$26
	.byte $26,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $98,$98
	.byte $08,$08,$08,$1A,$88, $88,$88,$88,$88,$88
	.byte $88,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
;----------------------------------------
.else
; colpf2
	.byte $AE,$AE
	.byte $00,$00,$00,$1E,$36, $36,$36,$36,$36,$36
	.byte $36,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $A8,$A8
	.byte $08,$08,$08,$2A,$98, $98,$98,$98,$98,$98
	.byte $98,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $A4
.endif
;----------------------------------------

; number of valid bricks
	.byte 96

;================================================================================

lv02
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,$CC,0,0,0,0,0,0
	.byte 0,0,0,$11,$11,$13,$31,$23,$21,$21,0,0,0

	.byte 0,0,$11,$11,$13,$31,$31,$31,$21,$21,$23,0,0
	.byte 0,0,$11,$13,$31,$31,$33,$31,$31,$23,$21,0,0
	.byte 0,$11,$13,$11,$31,$31,$31,$31,$33,$21,$21,$21,0
	.byte 0,$13,$11,$11,$31,$31,$31,$33,$31,$21,$21,$21,0
	.byte 0,$11,$11,$11,$31,$31,$33,$31,$31,$21,$21,$23,0

	.byte 0,$CC,0,0,$CC,0,$CC,0,$CC,0,0,$CC,0
	.byte 0,0,0,0,0,0,$CC,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,$CC,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,$CC,0,0,0,0,0,0
	.byte 0,0,0,0,$BF,0,$BF,0,0,0,0,0,0

	.byte 0,0,0,0,$BF,$BF,$BF,0,0,0,0,0,0
	.byte 0,0,0,0,0,$BF,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte 0,0,0,0,$BC, $BA,$BA,$BA,$BA,$BA
	.byte 0,0,0,0,$EE, $EE,$EE,0

; colpf1
	.byte $28,$28
	.byte 8,8,8,8,$76, $76,$76,$76,$76,$76
	.byte 8,8,8,8,$E8, $E8,$E8,8

; background index and color (colpf0)
	.byte 2, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte 0,0,0,0,$CC, $CA,$CA,$CA,$CA,$CA
	.byte 0,0,0,0,$EE, $EE,$EE,0

; colpf1
	.byte $38,$38
	.byte 8,8,8,8,$86, $86,$86,$86,$86,$86
	.byte 8,8,8,8,$E8, $E8,$E8,8

; background index and color (colpf0)
	.byte 2, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 67

;================================================================================

lv03
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$CA,$23,$CA,$21,$CA,$21,$CA,$21,$CA,$23,$CA,$00
	.byte $00,$BF,$BF,$BF,$BF,$BF,$BF,$BF,$BF,$BF,$BF,$BF,$00

	.byte $00,$21,$00,$21,$00,$23,$00,$21,$00,$21,$00,$21,$00
	.byte $00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00
	.byte $00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00
	.byte $00,$21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00
	.byte $00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00

	.byte $00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00
	.byte $00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$23,$00
	.byte $00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$00,$00
	.byte $00,$BF,$00,$BF,$00,$BF,$00,$BF,$00,$00,$00,$00,$00
	.byte $00,$BF,$00,$BF,$00,$BF,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$BF,$00,$BF,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$BF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$BA,$EE, $9C,$EE,$EE,$48,$EE
	.byte $EE,$26,$EE,$EE,$EE, $EE,$EE,$00
; colpf1
	.byte $78,$78
	.byte $E8,$E8,$E8,$08,$E8, $E8,$E8,$E8,$E8,$E8
	.byte $E8,$E8,$E8,$E8,$E8, $E8,$E8,$E8

; background index and color (colpf0)
	.byte 3, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$CA,$EE, $AC,$EE,$EE,$58,$EE
	.byte $EE,$36,$EE,$EE,$EE, $EE,$EE,$00
; colpf1
	.byte $88,$88
	.byte $E8,$E8,$E8,$08,$E8, $E8,$E8,$E8,$E8,$E8
	.byte $E8,$E8,$E8,$E8,$E8, $E8,$E8,$E8

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 29

;================================================================================

lv04
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$23,$00,$00,$00,$00,$00,$23,$00,$00,$00
	.byte $00,$00,$00,$23,$00,$00,$00,$00,$00,$23,$00,$00,$00
	.byte $00,$00,$00,$00,$23,$00,$00,$00,$23,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$23,$00,$00,$00,$23,$00,$00,$00,$00

	.byte $00,$00,$00,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$00,$00,$00
	.byte $00,$00,$00,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$00,$00,$00
	.byte $00,$00,$CA,$CA,$23,$CA,$CA,$CA,$23,$CA,$CA,$00,$00
	.byte $00,$00,$CA,$CA,$23,$CA,$CA,$CA,$23,$CA,$CA,$00,$00
	.byte $00,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$00

	.byte $00,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$00
	.byte $00,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$00
	.byte $00,$CA,$00,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$00,$CA,$00
	.byte $00,$CA,$00,$CA,$00,$00,$00,$00,$00,$CA,$00,$CA,$00
	.byte $00,$CA,$00,$CA,$00,$00,$00,$00,$00,$CA,$00,$CA,$00

	.byte $00,$00,$00,$00,$CA,$CA,$00,$CA,$CA,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$CA,$CA,$00,$CA,$CA,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$EE,$EE,$EE,$EE, $00,$00,$26,$26,$26
	.byte $00,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$1E,$1E,$1E,$1E, $00,$00,$36,$36,$36
	.byte $00,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 98

;================================================================================
/*
lv05
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00,$00
	.byte $00,$CF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$CF,$00

	.byte $00,$CF,$CF,$00,$CF,$00,$00,$00,$CF,$00,$CF,$CF,$00
	.byte $00,$00,$00,$00,$00,$00,$23,$00,$00,$00,$00,$00,$00
	.byte $00,$CF,$00,$00,$00,$CF,$23,$CF,$00,$00,$00,$CF,$00
	.byte $00,$00,$00,$CF,$00,$00,$23,$00,$00,$CF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$23,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$CF,$00,$00,$23,$00,$00,$CF,$00,$00,$00
	.byte $00,$CF,$00,$00,$00,$CF,$23,$CF,$00,$00,$00,$CF,$00
	.byte $00,$00,$00,$00,$00,$00,$23,$00,$00,$00,$00,$00,$00
	.byte $00,$CF,$CF,$00,$CF,$00,$00,$00,$CF,$00,$CF,$CF,$00
	.byte $00,$CF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$CF,$00

	.byte $00,$00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$00,$00,$00, $00,$0E,$1A,$9C,$BA
	.byte $26,$76,$48,$00,$00, $00,$00,$00
; colpf1
	.byte $28,$28
	.byte $E8,$E8,$E8,$E8,$E8, $E8,$E8,$E8,$E8,$E8
	.byte $E8,$E8,$E8,$E8,$E8, $E8,$E8,$E8

; background index and color (colpf0)
	.byte 2, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$00,$00, $00,$0E,$2A,$AC,$CA
	.byte $36,$86,$58,$00,$00, $00,$00,$00
; colpf1
	.byte $38,$38
	.byte $E8,$E8,$E8,$E8,$E8, $E8,$E8,$E8,$E8,$E8
	.byte $E8,$E8,$E8,$E8,$E8, $E8,$E8,$E8

; background index and color (colpf0)
	.byte 2, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 7
*/
;================================================================================

lv06
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$21,$21,$21,$00,$11,$11,$11,$00,$21,$21,$21,$00

	.byte $00,$21,$21,$21,$00,$11,$11,$11,$00,$21,$21,$21,$00
	.byte $00,$21,$21,$21,$00,$11,$13,$11,$00,$21,$21,$21,$00
	.byte $00,$21,$21,$21,$00,$11,$11,$11,$00,$21,$21,$21,$00
	.byte $00,$21,$23,$21,$00,$11,$11,$11,$00,$21,$23,$21,$00
	.byte $00,$21,$21,$21,$00,$11,$11,$11,$00,$21,$21,$21,$00

	.byte $00,$21,$21,$21,$00,$11,$11,$11,$00,$21,$21,$21,$00
	.byte $00,$21,$23,$21,$00,$11,$11,$11,$00,$21,$23,$21,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$EE, $48,$88,$26,$BA,$9C
	.byte $1A,$0E,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$0E, $1A,$9C,$BA,$26,$88
	.byte $48,$EE,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$1E, $58,$98,$36,$CA,$AC
	.byte $2A,$0E,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$0E, $2A,$AC,$CA,$36,$98
	.byte $58,$1E,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 72

;================================================================================

lv07
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $23,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21
	.byte $DF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DF

	.byte $23,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$23
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $23,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$23
	.byte $DF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DF
	.byte $23,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$23

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $23,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$23
	.byte $DF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DF
	.byte $23,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$23
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $23,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21
	.byte $DF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DF
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $9E,$9E
	.byte $00,$00,$00,$88,$EE, $88,$00,$1A,$EE,$0E
	.byte $00,$9C,$EE,$26,$00, $26,$EE,$00
; colpf1
	.byte $98,$98
	.byte $08,$08,$08,$08,$1A, $08,$08,$08,$1A,$08
	.byte $08,$08,$1A,$08,$08, $08,$1A,$08

; background index and color (colpf0)
	.byte 5, $94
;----------------------------------------
.else
; colpf2
	.byte $AE,$AE
	.byte $00,$00,$00,$98,$1E, $98,$00,$2A,$1E,$0E
	.byte $00,$AC,$1E,$36,$00, $36,$1E,$00
; colpf1
	.byte $A8,$A8
	.byte $08,$08,$08,$08,$2A, $08,$08,$08,$2A,$08
	.byte $08,$08,$2A,$08,$08, $08,$2A,$08

; background index and color (colpf0)
	.byte 5, $A4
.endif
;----------------------------------------

; number of valid bricks
	.byte 91

;================================================================================

lv08
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$CF,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$23,$23,$00,$23,$23,$00,$00,$00,$00

	.byte $00,$00,$23,$23,$00,$00,$CF,$00,$00,$23,$23,$00,$00
	.byte $13,$13,$00,$00,$23,$23,$00,$23,$23,$00,$00,$13,$13
	.byte $00,$00,$23,$23,$00,$00,$CF,$00,$00,$23,$23,$00,$00
	.byte $13,$13,$00,$00,$23,$23,$00,$23,$23,$00,$00,$13,$13
	.byte $00,$00,$23,$23,$00,$00,$CF,$00,$00,$23,$23,$00,$00

	.byte $13,$13,$00,$00,$23,$23,$00,$23,$23,$00,$00,$13,$13
	.byte $00,$00,$23,$23,$00,$00,$CF,$00,$00,$23,$23,$00,$00
	.byte $13,$13,$00,$00,$23,$23,$00,$23,$23,$00,$00,$13,$13
	.byte $00,$00,$23,$23,$00,$00,$CF,$00,$00,$23,$23,$00,$00
	.byte $13,$13,$00,$00,$23,$23,$00,$23,$23,$00,$00,$13,$13

	.byte $00,$00,$23,$23,$00,$00,$00,$00,$00,$23,$23,$00,$00
	.byte $23,$23,$00,$00,$00,$00,$00,$00,$00,$00,$00,$23,$23
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$00,$0E, $0E,$1A,$1A,$EE,$EE
	.byte $BA,$BA,$26,$26,$76, $76,$76,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$E8,$08, $E8,$0E,$E8,$1A,$E8
	.byte $EE,$E8,$BA,$E8,$26, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $34
;----------------------------------------
.else
; colpf2
	.byte $4E,$4E
	.byte $00,$00,$00,$00,$0E, $0E,$2A,$2A,$1E,$1E
	.byte $CA,$CA,$36,$36,$86, $86,$86,$00
; colpf1
	.byte $48,$48
	.byte $08,$08,$08,$E8,$08, $E8,$0E,$E8,$2A,$E8
	.byte $1E,$E8,$CA,$E8,$36, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $44
.endif
;----------------------------------------

; number of valid bricks
	.byte 72

;================================================================================

lv08b
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$CF,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$23,$21,$00,$23,$21,$00,$00,$00,$00

	.byte $00,$00,$23,$21,$00,$00,$CF,$00,$00,$23,$21,$00,$00
	.byte $13,$11,$00,$00,$21,$21,$00,$21,$21,$00,$00,$13,$11
	.byte $00,$00,$21,$21,$00,$00,$CF,$00,$00,$21,$21,$00,$00
	.byte $11,$11,$00,$00,$21,$23,$00,$21,$23,$00,$00,$11,$11
	.byte $00,$00,$21,$23,$00,$00,$CF,$00,$00,$21,$23,$00,$00

	.byte $11,$13,$00,$00,$21,$21,$00,$21,$21,$00,$00,$11,$13
	.byte $00,$00,$21,$21,$00,$00,$CF,$00,$00,$21,$21,$00,$00
	.byte $11,$11,$00,$00,$23,$21,$00,$23,$21,$00,$00,$11,$11
	.byte $00,$00,$23,$21,$00,$00,$CF,$00,$00,$23,$21,$00,$00
	.byte $13,$11,$00,$00,$23,$23,$00,$23,$23,$00,$00,$13,$11

	.byte $00,$00,$23,$23,$00,$00,$00,$00,$00,$23,$23,$00,$00
	.byte $23,$23,$00,$00,$00,$00,$00,$00,$00,$00,$00,$23,$23
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$00,$0E, $0E,$1A,$1A,$EE,$EE
	.byte $BA,$BA,$26,$26,$88, $88,$88,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$E8,$08, $E8,$0E,$E8,$1A,$E8
	.byte $EE,$E8,$BA,$E8,$26, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $34
;----------------------------------------
.else
; colpf2
	.byte $4E,$4E
	.byte $00,$00,$00,$00,$0E, $0E,$2A,$2A,$1E,$1E
	.byte $CA,$CA,$36,$36,$98, $98,$98,$00
; colpf1
	.byte $48,$48
	.byte $08,$08,$08,$E8,$08, $E8,$0E,$E8,$2A,$E8
	.byte $1E,$E8,$CA,$E8,$36, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $44
.endif
;----------------------------------------

; number of valid bricks
	.byte 72

;================================================================================

lv09
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21

	.byte $23,$23,$23,$23,$23,$23,$23,$23,$23,$23,$23,$23,$23
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $21,$21,$CF,$00,$CF,$23,$21,$23,$CF,$00,$CF,$23,$21
	.byte $21,$21,$CF,$00,$CF,$23,$23,$23,$CF,$00,$CF,$23,$21
	.byte $21,$21,$CF,$00,$CF,$23,$23,$23,$CF,$00,$CF,$23,$21

	.byte $21,$21,$CF,$00,$CF,$23,$21,$23,$CF,$00,$CF,$23,$21
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21
	.byte $21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $9E,$9E
	.byte $00,$00,$00,$00,$0E, $0E,$00,$26,$26,$26
	.byte $26,$00,$EE,$EE,$00, $00,$00,$00
; colpf1
	.byte $98,$98
	.byte $08,$08,$08,$08,$08, $08,$08,$E8,$E8,$E8
	.byte $E8,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 2, $94
;----------------------------------------
.else
; colpf2
	.byte $AE,$AE
	.byte $00,$00,$00,$00,$0E, $0E,$00,$36,$36,$36
	.byte $36,$00,$1E,$1E,$00, $00,$00,$00
; colpf1
	.byte $A8,$A8
	.byte $08,$08,$08,$08,$08, $08,$08,$E8,$E8,$E8
	.byte $E8,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 2, $A4
.endif
;----------------------------------------

; number of valid bricks
	.byte 80

;================================================================================

lv10
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$31,$33,$31,$33,$31,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$DF,$DF,$DF,$DF,$DF,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$31,$33,$31,$31,$31,$33,$31,$31,$31,$00,$00
	.byte $00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$31,$31,$31,$33,$31,$31,$31,$31,$31,$33,$31,$00
	.byte $00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$31,$31,$33,$31,$31,$31,$33,$31,$31,$00,$00
	.byte $00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$31,$31,$31,$33,$31,$31,$31,$00,$00,$00

	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$00,$EE,$00, $00,$EE,$00,$00,$EE
	.byte $00,$00,$EE,$00,$00,$EE, $00,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$1A,$08, $08,$1A,$08,$08,$1A
	.byte $08,$08,$1A,$08,$08, $1A,$08,$08

; background index and color (colpf0)
	.byte 5, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$1E,$00, $00,$1E,$00,$00,$1E
	.byte $00,$00,$1E,$00,$00,$1E, $00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$2A,$08, $08,$2A,$08,$08,$2A
	.byte $08,$08,$2A,$08,$08, $2A,$08,$08

; background index and color (colpf0)
	.byte 5, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 41

;================================================================================

lv10b
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$21,$23,$21,$23,$21,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$DF,$DF,$DF,$DF,$DF,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$21,$23,$21,$21,$21,$23,$21,$21,$21,$00,$00
	.byte $00,$00,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$21,$21,$21,$23,$21,$21,$21,$21,$21,$23,$21,$00
	.byte $00,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$21,$21,$23,$21,$21,$21,$23,$21,$21,$00,$00
	.byte $00,$00,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$21,$21,$21,$23,$21,$21,$21,$00,$00,$00

	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$9C,$EE,$00, $88,$EE,$00,$9C,$EE
	.byte $00,$88,$EE,$00,$9C, $EE,$00,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$1A,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $1A,$08,$08

; background index and color (colpf0)
	.byte 5, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$AC,$1E,$00, $98,$1E,$00,$AC,$1E
	.byte $00,$98,$1E,$00,$AC, $1E,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$2A,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $2A,$08,$08

; background index and color (colpf0)
	.byte 5, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 70

;================================================================================
/*
lv11
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$00
	.byte $00,$EF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EF,$00

	.byte $00,$EF,$00,$00,$00,$00,$21,$00,$00,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$00,$21,$11,$21,$00,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$21,$11,$31,$11,$21,$00,$00,$EF,$00
	.byte $00,$EF,$00,$21,$11,$31,$11,$31,$11,$21,$00,$EF,$00
	.byte $00,$00,$21,$31,$31,$21,$EC,$21,$31,$31,$21,$00,$00

	.byte $00,$EF,$00,$21,$11,$31,$11,$31,$11,$21,$00,$EF,$00
	.byte $00,$EF,$00,$00,$21,$11,$31,$11,$21,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$00,$21,$11,$21,$00,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$00,$00,$21,$00,$00,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EF,$00

	.byte $00,$EF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EF,$00
	.byte $00,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$00, $36,$36,$36,$36,$36
	.byte $36,$36,$36,$36,$00, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$2A,$2A,$2A, $2A,$2A,$2A,$2A,$08
	.byte $2A,$2A,$2A,$2A,$2A, $2A,$2A,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$00, $36,$36,$36,$36,$36
	.byte $36,$36,$36,$36,$00, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$2A,$2A,$2A, $2A,$2A,$2A,$2A,$08
	.byte $2A,$2A,$2A,$2A,$2A, $2A,$2A,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 41
*/
;================================================================================
/*
lv12
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $21,$21,$21,$21,$21,$21,$21,$23,$21,$21,$21,$21,$21
	.byte $31,$DF,$DF,$DF,$DF,$31,$DF,$31,$DF,$DF,$DF,$DF,$31

	.byte $31,$DF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DF,$31
	.byte $31,$DF,$21,$00,$00,$00,$00,$00,$00,$00,$21,$DF,$33
	.byte $31,$DF,$21,$23,$00,$00,$00,$00,$00,$23,$21,$DF,$31
	.byte $31,$DF,$33,$23,$23,$00,$00,$00,$23,$23,$33,$DF,$31
	.byte $00,$31,$DF,$33,$23,$23,$00,$23,$23,$33,$DF,$31,$00

	.byte $00,$00,$31,$DF,$33,$23,$21,$23,$33,$DF,$31,$00,$00
	.byte $00,$00,$00,$33,$DF,$33,$21,$33,$DF,$31,$00,$00,$00
	.byte $00,$00,$00,$00,$31,$DF,$31,$DF,$31,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$31,$23,$31,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$31,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$00,$BA,$EE, $EE,$EE,$EE,$EE,$EE
	.byte $EE,$EE,$EE,$BA,$EE, $00,$00,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$08,$1A, $1A,$1A,$1A,$1A,$1A
	.byte $1A,$1A,$1A,$1A,$1A, $08,$08,$08

; background index and color (colpf0)
	.byte 3, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$CA,$1E, $1E,$1E,$1E,$1E,$1E
	.byte $1E,$1E,$1E,$CA,$1E, $00,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$08,$2A, $2A,$2A,$2A,$2A,$2A
	.byte $2A,$2A,$2A,$2A,$2A, $08,$08,$08

; background index and color (colpf0)
	.byte 3, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 64
*/
;================================================================================

lv13
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00
	.byte $00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00

	.byte $00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$23,$21,$00,$00
	.byte $00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00
	.byte $00,$00,$CF,$00,$CF,$00,$CF,$23,$21,$21,$21,$00,$00
	.byte $00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00
	.byte $00,$00,$CF,$00,$CF,$23,$21,$21,$21,$21,$21,$00,$00

	.byte $00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00
	.byte $00,$00,$CF,$23,$21,$21,$21,$21,$21,$21,$21,$00,$00
	.byte $00,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$CF,$00,$00
	.byte $00,$00,$23,$21,$21,$21,$21,$21,$21,$21,$21,$00,$00
	.byte $00,$00,$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$00,$00,$00, $88,$00,$BA,$00,$26
	.byte $00,$48,$00,$EE,$00, $00,$00,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$E8,$E8, $E8,$E8,$E8,$E8,$E8
	.byte $E8,$E8,$E8,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 4, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$00,$00, $98,$00,$CA,$00,$36
	.byte $00,$58,$00,$1E,$00, $00,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$E8,$E8, $E8,$E8,$E8,$E8,$E8
	.byte $E8,$E8,$E8,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 4, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 38

;================================================================================

lv14
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $EB,$21,$21,$21,$EB,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $EB,$21,$21,$21,$EB,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$EB,$23,$EB,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$EB,$23,$EB,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$EB,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$EB,$00,$EB,$21,$21,$21,$EB,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$EB,$21,$21,$21,$EB,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$EB,$23,$EB,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$EB,$23,$EB,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$EB,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$EB,$00,$EB,$21,$21,$21,$EB
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$EB,$21,$21,$21,$EB
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$EB,$21,$EB,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$EB,$23,$EB,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EB,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EB,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$9E,$9C,$9C, $9C,$00,$EE,$EE,$EE
	.byte $EE,$00,$BE,$BC,$BA, $BA,$00,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$AE,$AC,$AC, $AC,$00,$1E,$1E,$1E
	.byte $1E,$00,$CE,$CC,$CA, $CA,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 54

;================================================================================
/*
lv15
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$DF,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$21,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$DF,$00,$DF,$00,$DF,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$23,$00,$21,$00,$21,$00,$00,$00,$00
	.byte $00,$00,$EC,$21,$EC,$21,$EC,$21,$EC,$21,$EC,$00,$00
	.byte $00,$00,$21,$00,$21,$00,$21,$00,$23,$00,$21,$00,$00
	.byte $00,$00,$DF,$00,$DF,$00,$DF,$00,$DF,$00,$DF,$00,$00
	.byte $00,$00,$DF,$31,$DF,$33,$DF,$31,$DF,$31,$DF,$00,$00

	.byte $00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00
	.byte $00,$00,$EC,$00,$00,$00,$00,$00,$00,$00,$EC,$00,$00
	.byte $00,$00,$21,$23,$21,$23,$21,$21,$21,$21,$23,$00,$00
	.byte $00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00
	.byte $00,$00,$00,$EC,$00,$00,$00,$00,$00,$EC,$00,$00,$00

	.byte $00,$00,$00,$21,$23,$21,$21,$23,$21,$21,$00,$00,$00
	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$EE,$9C,$EE, $BA,$EE,$48,$EE,$EE
	.byte $EE,$00,$BA,$EE,$00, $1A,$EE,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$1A,$08,$1A, $08,$08,$08,$1A,$1A
	.byte $1A,$08,$08,$1A,$08, $08,$1A,$08

; background index and color (colpf0)
	.byte 7, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$1E,$AC,$1E, $CA,$1E,$58,$1E,$1E
	.byte $1E,$00,$CA,$1E,$00, $2A,$1E,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$2A,$08,$2A, $08,$08,$08,$2A,$2A
	.byte $2A,$08,$08,$2A,$08, $08,$2A,$08

; background index and color (colpf0)
	.byte 7, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 37
*/
;================================================================================

lv16
	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$23,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$23,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$21,$EF,$23,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$23,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$23,$EF,$21,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$23,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$23,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$EF,$21,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$21,$EF,$23,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$EB,$EB,$EB,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $9C,$9C,$EE,$EE,$48, $48,$88,$88,$26,$26
	.byte $BA,$BA,$9C,$9C,$EE, $EE,$00,$00
; colpf1
	.byte $78,$78
	.byte $1A,$1A,$1A,$1A,$1A, $1A,$1A,$1A,$1A,$1A
	.byte $1A,$1A,$1A,$1A,$1A, $1A,$08,$00

; background index and color (colpf0)
	.byte 7, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $AC,$AC,$1E,$1E,$58, $58,$98,$98,$36,$36
	.byte $CA,$CA,$AC,$AC,$1E, $1E,$00,$00
; colpf1
	.byte $88,$88
	.byte $2A,$2A,$2A,$2A,$2A, $2A,$2A,$2A,$2A,$2A
	.byte $2A,$2A,$2A,$2A,$2A, $2A,$08,$00

; background index and color (colpf0)
	.byte 7, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 35

;================================================================================
/*
lv17
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$ED,$00,$ED,$00,$ED,$00,$ED,$00,$ED,$00,$00
	.byte $00,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$00
	.byte $00,$00,$ED,$00,$ED,$00,$ED,$00,$ED,$00,$ED,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$ED,$00,$ED,$00,$ED,$00,$ED,$00,$ED,$00,$ED,$00

	.byte $00,$23,$00,$21,$00,$23,$00,$23,$00,$21,$00,$23,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $9E,$9E
	.byte $00,$00,$00,$00,$00, $00,$00,$EE,$00,$00
	.byte $00,$26,$00,$00,$00, $76,$00,$00
; colpf1
	.byte $98,$98
	.byte $08,$08,$08,$08,$08, $08,$08,$1A,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
;----------------------------------------
.else
; colpf2
	.byte $AE,$AE
	.byte $00,$00,$00,$00,$00, $00,$00,$1E,$00,$00
	.byte $00,$36,$00,$00,$00, $86,$00,$00
; colpf1
	.byte $A8,$A8
	.byte $08,$08,$08,$08,$08, $08,$08,$2A,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $A4
.endif
;----------------------------------------

; number of valid bricks
	.byte 27
*/
;================================================================================

lv18
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$DF,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$21,$ED,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$21,$13,$21,$13,$21,$00,$00,$00,$00
	.byte $00,$00,$00,$21,$21,$11,$23,$11,$21,$21,$00,$00,$00
	.byte $00,$00,$00,$21,$21,$21,$21,$21,$21,$21,$00,$00,$00
	.byte $00,$00,$00,$21,$33,$21,$21,$21,$33,$21,$00,$00,$00

	.byte $00,$00,$00,$21,$21,$21,$21,$21,$21,$21,$00,$00,$00
	.byte $00,$00,$00,$00,$21,$33,$21,$33,$21,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$21,$21,$21,$21,$21,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$21,$21,$21,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$EE, $BA,$BA,$26,$26,$26
	.byte $26,$26,$26,$26,$00, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$1A, $08,$BC,$BA,$08,$EE
	.byte $08,$EE,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$1E, $CA,$CA,$36,$36,$36
	.byte $36,$36,$36,$36,$00, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$2A, $08,$CC,$CA,$08,$1E
	.byte $08,$1E,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 49

;================================================================================
/*
lv19
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$00
	.byte $00,$CB,$21,$21,$23,$21,$21,$21,$21,$23,$21,$CB,$00

	.byte $00,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$CB,$CB,$CB,$CB,$CB,$00,$CB,$CB,$CB,$CB,$CB,$00
	.byte $00,$CB,$23,$21,$21,$CB,$00,$CB,$23,$21,$21,$CB,$00
	.byte $00,$CB,$CB,$CB,$CB,$CB,$00,$CB,$CB,$CB,$CB,$CB,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$CB,$CB,$CB,$00,$CB,$CB,$CB,$00,$CB,$CB,$CB,$00
	.byte $00,$CB,$23,$CB,$00,$CB,$23,$CB,$00,$CB,$23,$CB,$00
	.byte $00,$CB,$CB,$CB,$00,$CB,$CB,$CB,$00,$CB,$CB,$CB,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$EE, $00,$00,$00,$9C,$00
	.byte $00,$00,$26,$00,$00, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$1E, $00,$00,$00,$AC,$00
	.byte $00,$00,$36,$00,$00, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 90
*/
;================================================================================

lv20
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$EF,$EF,$00,$00,$00,$EF,$EF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$EF,$00,$EF,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$23,$21,$23,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$21,$21,$21,$21,$21,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$23,$21,$11,$21,$23,$00,$00,$00,$00
	.byte $00,$EF,$EF,$EF,$EF,$21,$23,$21,$EF,$EF,$EF,$EF,$00
	.byte $EF,$00,$00,$00,$21,$21,$21,$21,$21,$00,$00,$00,$EF
	.byte $00,$00,$00,$00,$00,$23,$21,$23,$00,$00,$00,$00,$00

	.byte $00,$00,$EF,$EF,$EF,$21,$21,$21,$EF,$EF,$EF,$00,$00
	.byte $00,$EF,$00,$00,$21,$21,$21,$21,$21,$00,$00,$EF,$00
	.byte $00,$00,$00,$00,$00,$23,$21,$23,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$EF,$EF,$21,$21,$21,$EF,$EF,$00,$00,$00
	.byte $00,$00,$EF,$00,$00,$21,$21,$21,$00,$00,$EF,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$23,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$EF,$EF,$00,$EF,$EF,$00,$00,$00,$00
	.byte $00,$00,$00,$EF,$00,$00,$00,$00,$00,$EF,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$00,$9C, $9C,$9C,$EE,$BA,$EE
	.byte $BA,$EE,$BA,$EE,$BA, $BA,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$1A,$1A,$08, $08,$BA,$1A,$1A,$08
	.byte $1A,$1A,$08,$1A,$1A, $08,$1A,$1A

; background index and color (colpf0)
	.byte 5, $34
;----------------------------------------
.else
; colpf2
	.byte $4E,$4E
	.byte $00,$00,$00,$00,$AC, $AC,$AC,$1E,$CA,$1E
	.byte $CA,$1E,$CA,$1E,$CA, $CA,$00,$00
; colpf1
	.byte $48,$48
	.byte $08,$08,$2A,$2A,$08, $08,$CA,$2A,$2A,$08
	.byte $2A,$2A,$08,$2A,$2A, $08,$2A,$2A

; background index and color (colpf0)
	.byte 5, $44
.endif
;----------------------------------------

; number of valid bricks
	.byte 42

;================================================================================

lv21
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$DF,$DF,$DF,$00,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$DF,$31,$31,$33,$DF,$31,$33,$31,$DF,$00,$00
	.byte $00,$00,$DF,$31,$31,$31,$DF,$33,$31,$31,$DF,$00,$00

	.byte $00,$00,$DF,$33,$31,$11,$DF,$11,$31,$31,$DF,$00,$00
	.byte $00,$00,$DF,$31,$33,$11,$DF,$11,$31,$33,$DF,$00,$00
	.byte $00,$00,$00,$13,$11,$11,$23,$11,$11,$11,$00,$00,$00
	.byte $00,$00,$11,$11,$13,$11,$21,$11,$11,$11,$13,$00,$00
	.byte $00,$21,$23,$EA,$21,$21,$EA,$23,$21,$EA,$21,$21,$00

	.byte $21,$EA,$21,$EA,$21,$23,$EA,$21,$21,$EA,$21,$EA,$21
	.byte $23,$EA,$21,$EA,$21,$21,$EA,$23,$21,$EA,$23,$EA,$21
	.byte $21,$21,$EA,$21,$EA,$EA,$21,$EA,$EA,$23,$EA,$21,$21
	.byte $00,$21,$23,$21,$EA,$EA,$21,$EA,$EA,$21,$21,$21,$00
	.byte $00,$00,$00,$21,$21,$21,$23,$21,$23,$21,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$21,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$21,$11,$21,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$EE,$EE,$EE, $EE,$EE,$26,$26,$26
	.byte $26,$26,$26,$26,$26, $EE,$26,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$1A,$1A,$1A, $1A,$1A,$9C,$EE,$08
	.byte $08,$08,$08,$08,$EE, $08,$EE,$08

; background index and color (colpf0)
	.byte 2, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$1E,$1E,$1E, $1E,$1E,$36,$36,$36
	.byte $36,$36,$36,$36,$36, $1E,$36,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$2A,$2A,$2A, $2A,$2A,$AC,$CA,$08
	.byte $08,$08,$08,$08,$1E, $08,$1E,$08

; background index and color (colpf0)
	.byte 2, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 112

;================================================================================

lv22
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$23,$00,$21,$00,$21,$00,$23,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$21,$00,$23,$00,$23,$00,$21,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00

	.byte $00,$23,$00,$21,$00,$21,$00,$21,$00,$21,$00,$23,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$23,$00,$21,$00,$21,$00,$23,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$21,$00,$23,$00,$23,$00,$21,$00,$21,$00

	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$23,$00,$21,$00,$21,$00,$21,$00,$21,$00,$23,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$23,$00,$21,$00,$21,$00,$23,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00

	.byte $00,$21,$00,$21,$00,$23,$00,$23,$00,$21,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$EE,$00,$1A,$00, $9C,$00,$BA,$00,$26
	.byte $00,$88,$00,$48,$00, $EE,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$1E,$00,$2A,$00, $AC,$00,$CA,$00,$36
	.byte $00,$98,$00,$58,$00, $1E,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 48

;================================================================================

lv22b
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$21,$00,$23,$00,$21,$00,$21,$00,$23,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$21,$00,$23,$00,$23,$00,$21,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00

	.byte $00,$23,$00,$21,$00,$21,$00,$21,$00,$21,$00,$23,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$23,$00,$21,$00,$21,$00,$23,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$21,$00,$23,$00,$23,$00,$21,$00,$21,$00

	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$23,$00,$21,$00,$21,$00,$21,$00,$21,$00,$23,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $00,$21,$00,$23,$00,$21,$00,$21,$00,$23,$00,$21,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00

	.byte $00,$21,$00,$21,$00,$23,$00,$23,$00,$21,$00,$21,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$EE,$00,$1A,$00, $9C,$00,$BA,$00,$26
	.byte $00,$88,$00,$48,$00, $EE,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$1E,$00,$2A,$00, $AC,$00,$CA,$00,$36
	.byte $00,$98,$00,$58,$00, $1E,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 48

;================================================================================

lv23
	.byte $00,$EF,$00,$00,$EF,$23,$21,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$21,$23,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$23,$21,$21,$EF,$00,$00,$EF,$00

	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$21,$23,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$23,$21,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00

	.byte $00,$EF,$00,$00,$EF,$21,$21,$23,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$23,$21,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EF,$00,$00,$EF,$21,$21,$23,$EF,$00,$00,$EF,$00

	.byte $00,$EF,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$EF,$00
	.byte $00,$EA,$EA,$EA,$EA,$00,$00,$00,$EA,$EA,$EA,$EA,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $9C,$9C,$BA,$BA,$BA, $48,$48,$48,$EE,$EE
	.byte $EE,$88,$88,$88,$26, $26,$26,$00
; colpf1
	.byte $78,$78
	.byte $1A,$1A,$1A,$1A,$1A, $1A,$1A,$1A,$1A,$1A
	.byte $1A,$1A,$1A,$1A,$1A, $1A,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $AC,$AC,$CA,$CA,$CA, $58,$58,$58,$1E,$1E
	.byte $1E,$98,$98,$98,$36, $36,$36,$00
; colpf1
	.byte $88,$88
	.byte $2A,$2A,$2A,$2A,$2A, $2A,$2A,$2A,$2A,$2A
	.byte $2A,$2A,$2A,$2A,$2A, $2A,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 56

;================================================================================

lv24
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$23,$00

	.byte $00,$00,$00,$00,$EC,$EC,$EC,$EC,$EC,$EC,$00,$21,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$23,$00
	.byte $00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00,$DF,$00
	.byte $00,$DF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DF,$00
	.byte $00,$DF,$00,$23,$13,$23,$33,$23,$13,$23,$00,$DF,$00

	.byte $00,$DF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DF,$00
	.byte $00,$DF,$00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00
	.byte $00,$23,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$21,$00,$EC,$EC,$EC,$EC,$EC,$EC,$00,$00,$00,$00
	.byte $00,$23,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $9E,$9E
	.byte $00,$00,$00,$EE,$26, $26,$26,$EE,$EE,$EE
	.byte $EE,$EE,$BA,$BA,$BA, $EE,$00,$00
; colpf1
	.byte $98,$98
	.byte $08,$08,$08,$1A,$1A, $08,$1A,$1A,$1A,$1A
	.byte $1A,$1A,$1A,$08,$1A, $1A,$08,$08

; background index and color (colpf0)
	.byte 5, $94
;----------------------------------------
.else
; colpf2
	.byte $AE,$AE
	.byte $00,$00,$00,$1E,$36, $36,$36,$1E,$1E,$1E
	.byte $1E,$1E,$CA,$CA,$CA, $1E,$00,$00
; colpf1
	.byte $A8,$A8
	.byte $08,$08,$08,$2A,$2A, $08,$2A,$2A,$2A,$2A
	.byte $2A,$2A,$2A,$08,$2A, $2A,$08,$08

; background index and color (colpf0)
	.byte 5, $A4
.endif
;----------------------------------------

; number of valid bricks
	.byte 25

;================================================================================

lv25
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$21,$21,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$21,$21,$00
	.byte $13,$21,$21,$13,$11,$13,$11,$13,$11,$13,$21,$21,$13
	.byte $31,$33,$31,$31,$31,$31,$31,$31,$31,$31,$31,$33,$31
	.byte $11,$21,$21,$31,$31,$31,$33,$31,$31,$31,$21,$21,$11
	.byte $11,$21,$23,$11,$13,$11,$11,$11,$13,$11,$23,$21,$11

	.byte $23,$21,$21,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$21,$21,$23
	.byte $21,$23,$21,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$21,$23,$21
	.byte $00,$21,$21,$EA,$EA,$EA,$EA,$EA,$EA,$EA,$21,$21,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $9E,$9E
	.byte $00,$00,$00,$00,$00, $1A,$EE,$00,$EE,$1A
	.byte $26,$26,$26,$00,$00, $00,$00,$00
; colpf1
	.byte $98,$98
	.byte $08,$08,$08,$08,$08, $08,$9C,$08,$88,$9C
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
;----------------------------------------
.else
; colpf2
	.byte $AE,$AE
	.byte $00,$00,$00,$00,$00, $2A,$1E,$00,$1E,$2A
	.byte $36,$36,$36,$00,$00, $00,$00,$00
; colpf1
	.byte $A8,$A8
	.byte $08,$08,$08,$08,$08, $08,$AC,$08,$98,$AC
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $A4
.endif
;----------------------------------------

; number of valid bricks
	.byte 100

;================================================================================

lv26
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$EF,$21,$21,$21,$EF,$00,$EF,$21,$23,$21,$EF,$00
	.byte $00,$EF,$21,$23,$21,$EF,$00,$EF,$21,$21,$21,$EF,$00

	.byte $00,$EF,$21,$21,$21,$EF,$00,$EF,$23,$21,$21,$EF,$00
	.byte $00,$EF,$23,$21,$23,$EF,$00,$EF,$21,$21,$23,$EF,$00
	.byte $00,$00,$EB,$EB,$EB,$00,$00,$00,$EB,$EB,$EB,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$EF,$23,$21,$23,$EF,$00,$EF,$21,$21,$21,$EF,$00
	.byte $00,$EF,$21,$21,$21,$EF,$00,$EF,$23,$21,$23,$EF,$00
	.byte $00,$EF,$21,$21,$21,$EF,$00,$EF,$21,$21,$21,$EF,$00
	.byte $00,$EF,$23,$21,$21,$EF,$00,$EF,$21,$23,$21,$EF,$00
	.byte $00,$00,$EB,$EB,$EB,$00,$00,$00,$EB,$EB,$EB,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$9C,$9A, $78,$76,$48,$00,$00
	.byte $9C,$9A,$BC,$BA,$EE, $00,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$1A,$1A, $1A,$1A,$08,$08,$08
	.byte $1A,$1A,$1A,$1A,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $34
;----------------------------------------
.else
; colpf2
	.byte $4E,$4E
	.byte $00,$00,$00,$AC,$AA, $88,$86,$58,$00,$00
	.byte $AC,$AA,$CC,$CA,$1E, $00,$00,$00
; colpf1
	.byte $48,$48
	.byte $08,$08,$08,$2A,$2A, $2A,$2A,$08,$08,$08
	.byte $2A,$2A,$2A,$2A,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $44
.endif
;----------------------------------------

; number of valid bricks
	.byte 60

;================================================================================

lv27
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$EF,$00,$00,$00,$EF,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$EF,$23,$23,$23,$EF,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$EF,$21,$21,$21,$EF,$EF,$00,$00,$00
	.byte $00,$00,$00,$00,$EF,$21,$23,$21,$EF,$00,$EF,$00,$00
	.byte $00,$00,$00,$00,$EF,$21,$21,$21,$EF,$00,$EF,$00,$00
	.byte $00,$00,$00,$00,$EF,$23,$21,$23,$EF,$00,$EF,$00,$00

	.byte $00,$00,$00,$00,$EF,$21,$21,$21,$EF,$00,$EF,$00,$00
	.byte $00,$00,$00,$00,$EF,$21,$23,$21,$EF,$00,$EF,$00,$00
	.byte $00,$00,$00,$00,$EF,$21,$21,$21,$EF,$00,$EF,$00,$00
	.byte $00,$00,$00,$00,$EF,$23,$21,$23,$EF,$EF,$00,$00,$00
	.byte $00,$00,$00,$00,$EF,$21,$23,$21,$EF,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$EC,$EC,$EC,$EC,$EC,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$00,$00,$0E, $0E,$0E,$9C,$EE,$EE
	.byte $EE,$EE,$1C,$1A,$26, $00,$00,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$08,$1A, $1A,$1A,$1A,$1A,$1A
	.byte $1A,$1A,$1A,$1A,$1A, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$00,$0E, $0E,$0E,$AC,$1E,$1E
	.byte $1E,$1E,$2C,$2A,$36, $00,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$08,$2A, $2A,$2A,$2A,$2A,$2A
	.byte $2A,$2A,$2A,$2A,$2A, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 35

;================================================================================

lv28
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$EF,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$EF,$21,$EF,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$EF,$23,$21,$23,$EF,$00,$00,$00,$00
	.byte $00,$00,$00,$EF,$21,$21,$23,$21,$21,$EF,$00,$00,$00
	.byte $00,$00,$EF,$21,$23,$21,$21,$21,$23,$21,$EF,$00,$00
	.byte $00,$EB,$23,$21,$21,$21,$21,$21,$21,$21,$23,$EB,$00
	.byte $00,$00,$21,$21,$21,$EB,$EB,$EB,$21,$21,$EB,$00,$00

	.byte $00,$00,$23,$21,$21,$EB,$00,$EB,$21,$23,$EB,$00,$00
	.byte $00,$00,$21,$21,$23,$EB,$EB,$EB,$23,$21,$EB,$00,$00
	.byte $00,$00,$21,$21,$21,$EB,$00,$EB,$21,$21,$EB,$00,$00
	.byte $00,$00,$23,$21,$21,$EB,$EB,$EB,$21,$23,$EB,$00,$00
	.byte $00,$00,$21,$21,$23,$21,$21,$21,$23,$21,$EB,$00,$00

	.byte $00,$00,$21,$21,$21,$21,$23,$21,$21,$21,$EB,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$EE,$26, $26,$26,$28,$EE,$1A
	.byte $EE,$1A,$EE,$1A,$EE, $1A,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$1A,$1A, $1A,$1A,$1A,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $34
;----------------------------------------
.else
; colpf2
	.byte $4E,$4E
	.byte $00,$00,$00,$1E,$36, $36,$36,$38,$1E,$2A
	.byte $1E,$2A,$1E,$2A,$1E, $2A,$00,$00
; colpf1
	.byte $48,$48
	.byte $08,$08,$08,$2A,$2A, $2A,$2A,$2A,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $44
.endif
;----------------------------------------

; number of valid bricks
	.byte 88

;================================================================================
/*
lv29
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23
	.byte $52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52
	.byte $00,$21,$00,$23,$00,$21,$00,$21,$00,$23,$00,$21,$00

	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21
	.byte $52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52
	.byte $00,$23,$00,$21,$00,$21,$00,$21,$00,$21,$00,$23,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00

	.byte $21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21
	.byte $52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52
	.byte $00,$23,$00,$21,$00,$21,$00,$21,$00,$21,$00,$23,$00
	.byte $00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00
	.byte $23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23

	.byte $52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$EE,$EE,$BA,$BA, $48,$48,$9C,$9C,$76
	.byte $76,$1A,$1A,$26,$26, $0E,$0E,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 1, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$1E,$1E,$CA,$CA, $58,$58,$AC,$AC,$86
	.byte $86,$2A,$2A,$36,$36, $0E,$0E,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 1, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 46
*/
;================================================================================

lv30
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$52,$52,$52,$52,$52,$52,$52,$52,$52,$52,$52,$00
	.byte $00,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$52,$00
	.byte $00,$52,$00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00,$52,$00
	.byte $00,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$52,$00
	.byte $00,$52,$00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00,$52,$00

	.byte $00,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$52,$00
	.byte $00,$52,$00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00,$52,$00
	.byte $00,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$52,$00
	.byte $00,$52,$00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00,$52,$00
	.byte $00,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$52,$00

	.byte $00,$52,$52,$52,$52,$52,$52,$52,$52,$52,$52,$52,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$00, $00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$00, $00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 28

;================================================================================

lv31
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$52,$EB,$52,$EB,$52,$EB,$52,$EB,$52,$00,$00
	.byte $00,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$00
	.byte $00,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$00
	.byte $00,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$00
	.byte $00,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$00

	.byte $00,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$00
	.byte $00,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$00
	.byte $00,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$00
	.byte $00,$00,$52,$EB,$52,$EB,$52,$EB,$52,$EB,$52,$00,$00
	.byte $00,$00,$23,$21,$21,$23,$21,$23,$21,$21,$23,$00,$00

	.byte $00,$00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00,$00
	.byte $00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$00, $00,$26,$00,$48,$00
	.byte $9C,$00,$BA,$00,$EE, $00,$EE,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$1A,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$00, $00,$36,$00,$58,$00
	.byte $AC,$00,$CA,$00,$1E, $00,$1E,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$2A,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 46

;================================================================================

lv31b
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$52,$EB,$52,$EB,$52,$EB,$52,$EB,$52,$00,$00

	.byte $00,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$00
	.byte $00,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$00
	.byte $00,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$00
	.byte $00,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$00
	.byte $00,$00,$23,$00,$21,$00,$23,$00,$21,$00,$23,$00,$00

	.byte $00,$00,$52,$00,$52,$00,$52,$00,$52,$00,$52,$00,$00
	.byte $00,$00,$21,$00,$23,$00,$21,$00,$23,$00,$21,$00,$00
	.byte $00,$00,$52,$EB,$52,$EB,$52,$EB,$52,$EB,$52,$00,$00
	.byte $00,$00,$23,$21,$21,$23,$21,$23,$21,$21,$23,$00,$00
	.byte $00,$00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00,$00

	.byte $00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$00, $26,$00,$48,$00,$9C
	.byte $00,$BA,$00,$EE,$00, $EE,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $1A,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$00, $36,$00,$58,$00,$AC
	.byte $00,$CA,$00,$1E,$00, $1E,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $2A,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 46

;================================================================================

lv32
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00
	.byte $00,$EB,$EB,$21,$21,$21,$21,$21,$21,$21,$EB,$EB,$00
	.byte $00,$EB,$21,$EB,$21,$21,$21,$21,$21,$EB,$21,$EB,$00
	.byte $00,$EB,$21,$21,$EB,$33,$21,$33,$EB,$21,$21,$EB,$00

	.byte $00,$EB,$21,$21,$21,$33,$33,$33,$21,$21,$21,$EB,$00
	.byte $00,$EB,$21,$21,$21,$33,$33,$33,$21,$21,$21,$EB,$00
	.byte $00,$EB,$21,$21,$21,$21,$33,$21,$21,$21,$21,$EB,$00
	.byte $00,$EB,$21,$21,$21,$21,$21,$21,$21,$21,$21,$EB,$00
	.byte $00,$EB,$23,$23,$23,$23,$23,$23,$23,$23,$23,$EB,$00

	.byte $00,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$EB,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$00, $00,$00,$26,$26,$26
	.byte $26,$26,$26,$26,$EE, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 2, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$00, $00,$00,$36,$36,$36
	.byte $36,$36,$36,$36,$1E, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 110

;================================================================================

lv33
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$EF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EF,$00
	.byte $00,$21,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$EF,$21,$00
	.byte $00,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$00
	.byte $00,$23,$23,$23,$23,$23,$23,$23,$23,$23,$23,$23,$00
	.byte $00,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$00

	.byte $00,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$00
	.byte $00,$21,$EF,$EF,$EF,$21,$21,$21,$EF,$EF,$EF,$21,$00
	.byte $00,$EF,$00,$00,$EF,$23,$23,$23,$EF,$00,$00,$EF,$00
	.byte $00,$00,$00,$00,$EB,$EB,$EB,$EB,$EB,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$00,$00,$00, $00,$26,$28,$EE,$28
	.byte $26,$26,$24,$00,$00, $00,$00,$00
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$08,$08, $1A,$1A,$1A,$1A,$1A
	.byte $1A,$1A,$1A,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $34
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$00,$00, $00,$36,$38,$1E,$38
	.byte $36,$36,$34,$00,$00, $00,$00,$00
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$08,$08, $2A,$2A,$2A,$2A,$2A
	.byte $2A,$2A,$2A,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $44
.endif
;----------------------------------------

; number of valid bricks
	.byte 59

;================================================================================

lv34
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$EA,$EA,$EA,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$EA,$23,$00,$23,$EA,$00,$00,$00,$00,$00
	.byte $00,$00,$EA,$21,$21,$21,$21,$21,$EA,$00,$00,$00,$00

	.byte $00,$00,$EA,$00,$23,$00,$23,$00,$EA,$00,$00,$00,$00
	.byte $00,$00,$EA,$21,$21,$21,$21,$21,$EA,$00,$00,$00,$00
	.byte $00,$00,$EA,$00,$23,$00,$23,$00,$EA,$00,$00,$00,$00
	.byte $00,$00,$EA,$21,$21,$21,$21,$21,$EA,$00,$00,$00,$00
	.byte $00,$00,$00,$EA,$23,$00,$23,$EA,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$EA,$EA,$EA,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$EA,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$EA,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$DF,$00,$00,$00,$DF,$DF,$00,$00
	.byte $00,$00,$00,$00,$00,$DF,$00,$00,$DF,$DF,$DF,$DF,$00

	.byte $00,$00,$00,$00,$00,$DF,$00,$00,$DF,$DF,$DF,$DF,$00
	.byte $00,$00,$00,$00,$00,$DF,$00,$00,$DF,$DF,$DF,$DF,$00
	.byte $00,$00,$00,$00,$00,$DF,$00,$00,$00,$DF,$DF,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $2E,$2E
	.byte $00,$00,$00,$88,$9C, $88,$9C,$88,$9C,$88
	.byte $00,$00,$00,$EE,$EE, $EE,$EE,$EE
; colpf1
	.byte $28,$28
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$1A,$1A, $1A,$1A,$1A

; background index and color (colpf0)
	.byte 5, $24
;----------------------------------------
.else
; colpf2
	.byte $3E,$3E
	.byte $00,$00,$00,$98,$AC, $98,$AC,$98,$AC,$98
	.byte $00,$00,$00,$1E,$1E, $1E,$1E,$1E
; colpf1
	.byte $38,$38
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$2A,$2A, $2A,$2A,$2A

; background index and color (colpf0)
	.byte 5, $34
.endif
;----------------------------------------

; number of valid bricks
	.byte 45

;================================================================================

lv35
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$DF,$31,$DF,$23,$DF,$31,$DF,$00,$00,$00
	.byte $00,$00,$00,$DF,$33,$DF,$21,$DF,$33,$DF,$00,$00,$00

	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$23,$00,$00,$00,$00,$00,$21,$00,$00,$00
	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$21,$00,$00,$00,$00,$00,$23,$00,$00,$00
	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00

	.byte $00,$00,$00,$23,$00,$00,$00,$00,$00,$21,$00,$00,$00
	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$21,$00,$00,$00,$00,$00,$23,$00,$00,$00
	.byte $00,$00,$00,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$00,$00,$00
	.byte $00,$00,$00,$DF,$31,$DF,$23,$DF,$31,$DF,$00,$00,$00

	.byte $00,$00,$00,$DF,$33,$DF,$21,$DF,$33,$DF,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$EE,$EE, $EE,$9C,$EE,$BA,$EE
	.byte $26,$EE,$88,$EE,$EE, $EE,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$1A,$1A, $1A,$08,$1A,$08,$1A
	.byte $08,$1A,$08,$1A,$1A, $1A,$08,$08

; background index and color (colpf0)
	.byte 3, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$1E,$1E, $1E,$AC,$1E,$CA,$1E
	.byte $36,$1E,$98,$1E,$1E, $1E,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$2A,$2A, $2A,$08,$2A,$08,$2A
	.byte $08,$2A,$08,$2A,$2A, $2A,$08,$08

; background index and color (colpf0)
	.byte 3, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 20

/*
;================================================================================

lv00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

;----------------------------------------
.if .def PAL_VERSION
; colpf2
	.byte $7E,$7E
	.byte $00,$00,$00,$00,$00, $00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $78,$78
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $84
;----------------------------------------
.else
; colpf2
	.byte $8E,$8E
	.byte $00,$00,$00,$00,$00, $00,$00,$00,$00,$00
	.byte $00,$00,$00,$00,$00, $00,$00,$00
; colpf1
	.byte $88,$88
	.byte $08,$08,$08,$08,$08, $08,$08,$08,$08,$08
	.byte $08,$08,$08,$08,$08, $08,$08,$08

; background index and color (colpf0)
	.byte 5, $94
.endif
;----------------------------------------

; number of valid bricks
	.byte 1

;================================================================================
*/
