; Atari specific Pentagram routines
HostAllowMusic	equ $d0	; $e0+ used, low until free_zp used
HostInGame		equ $d1
HostInventoryP0PosX	equ $d2
HostInventoryP1PosX	equ $d3
HostInventoryP2PosX equ $d4
HostInventoryP0Color equ $d5
HostInventoryP1Color equ $d6
HostInventoryP2Color equ $d7
HostInventoryM0PosX equ $d8
HostInventoryM1PosX equ $d9
HostInventoryM2PosX equ $da


PMGMissile	= 3
PMGPlayer0	= 4
PMGPlayer1	= 5
PMGPlayer2	= 6
PMGPlayer3	= 7
PMGEnd		= $ff

PMGItemsOverlayVerticalPosition = $c8

HostInit
		lda #$00
		;sta HostAllowMusic
		;sta HostInGame
		tax
HostInitLoop		
		sta HostAllowMusic,x
		inx
		cpx #HostInventoryM2PosX-HostAllowMusic
		bne HostInitLoop
		lda #$40
		sta nmien
		rts
		
HostSetScreenColor	
		pha
		bit _bitmem6
		bne set_color_flash
		and #$07
		tax
		lda spectrum_color,x
		jmp host_set_color_write_regs
set_color_flash
		and #$07
		tax
		lda spectrum_color+8,x
host_set_color_write_regs
		jsr HostSetColorRegs
		;bit HostInGame		; this changes SCORE overlay color depending on screen color
		;bpl SkipSetScoreOverlayColor
		;eor #$f0
		;and #$f0
		;sta colpm3
SkipSetScoreOverlayColor		
		pla
		rts
		
HostSetColorRegs
		sta colpf1
		and #$f0
		sta colbak
		sta colpf2		
		rts

HostShowGameScreen
		bit HostInGame
		bpl HostShowGameScreenNotInGame
		rts
HostShowGameScreenNotInGame		
		;lda #$90	; fill inventory with amulets (testing code), use 5a to put basket, 90 - 94 for amulets
		;sta LA726
		;lda #$91
		;sta LA726+4
		;lda #$92
		;sta LA726+8
		lda #<GameScreenPMG
		ldx #>GameScreenPMG
		jsr PreparePMG		
		jsr EnablePMG
		ldy #14
FillPMGLives		
		lda PMGLives,y
		sta atari_pmg+PMGPlayer0*$100+$b0,y
		dey
		bpl FillPMGLives
		lda #%11000000
		sta sizem
		lda #%11
		sta sizep3
		lda #$00
		sta sizep0
		sta sizep1
		sta sizep2
		lda #$94
		sta hposp3
		lda #$50
		sta hposm3
		lda #$00
		sta colpm3
		lda #$ff
		sta HostInGame
		lda #$c0
		sta nmien
		rts

HostShowNonGameScreen
		;mva #$00 pmcntl		;PMG disabled
		;tax
		;sta:rne hposp0,x+
		
		;lda #%00100001
		;sta dmactl
		lda #$40
		sta nmien
		
		lda #$00
		sta hposp0
		sta hposp1
		sta hposp2
		sta hposp3
		sta hposm0
		sta hposm1
		sta hposm2
		sta hposm3
		
		lda #$0
		sta HostInGame
		jsr HostSetColorRegs

		rts
		
WaitForAnyKey
		lda trig0		; FIRE #0
		beq stop

		lda trig1		; FIRE #1
		beq stop

		lda consol		; START
		and #1
		beq stop

		lda skctl
		and #$04
		;beq stop
		bne WaitForAnyKey
		sec
		rts
		
stop	clc
		rts	

CheckAnyKey		
		lda trig0		; FIRE #0
		beq CheckAnyKeyEnd

		lda trig1		; FIRE #1
		beq CheckAnyKeyEnd

		lda consol		; START
		and #1
		beq CheckAnyKeyEnd

		lda skctl
		and #$04
		;beq stop
;		bne WaitForAnyKey
		sec
		rts
		
CheckAnyKeyEnd
		clc
		rts	
	
WaitForAnyKeyDepress
WaitTrig0
		lda trig0
		beq WaitTrig0
		
WaitTrig1
		lda trig1
		beq WaitTrig1
		
WaitConsol
		lda consol
		and #1
		beq WaitConsol
		
WaitKeyboard
		lda skctl
		and #$04
		beq WaitKeyboard
		
		rts
		
TitleScreenColors
		.he 44
		.he 47
		.he 44
		.he 44
		.he 44
		.he 44
		.he 44
TitleScreenPositions		
		.he 58,9f
		.he 50,8f
		.he 38,7f
		.he 50,6f
		.he 50,5f
		.he 58,4f
		.he 28,27
TitleScreenTexts
		dta c'PENTAGRA', c'M'*
		dta $3C, c' 1986 A', $3A, 'C', $3A, 'G', $BA
		dta c'ATARI VERSION 201', '6'*
		dta c'CODE MARIUS', 'Z'*
		dta c'MUSIC  MIKE', 'R'*
		dta c'COLOR JOS', 'E'*
		dta c'FIRE OR START TO PLA', c'Y'*
		
HostTitleScreen
		;jmp GameCompletedMsg
		
		jsr HostShowNonGameScreen
        jsr ClrWrkScr ; CALL ClrWrkScr
        ;lda #$45 ; LD   A,45
        ;jsr FillAttr ; CALL FillAttr
        lda #<TitleScreenColors ; 
        sta z80_e
        lda #>TitleScreenColors
        sta z80_d
        jsr exx ; EXX
        lda #<TitleScreenPositions 
        sta z80_l
        lda #>TitleScreenPositions
        sta z80_h
        lda #<TitleScreenTexts
        sta z80_e
        lda #>TitleScreenTexts
        sta z80_d
        lda #$07 ; LD   B,06
        sta z80_b
        lda #$00 ; XOR  A
        sta LA734 ; LD   (LA734),A
        jsr @@125 ; CALL @@125
		lda #$5
		jsr HostPlayMusic
		lda #$6e
		jsr HostSetColorRegs
		
		lda #<TitleScreenPMG
		ldx #>TitleScreenPMG
		jsr PreparePMG
		
		jsr EnablePMG
		
TitleScreenLoop		
		lda #<TitleScreenRaster
		ldx #>TitleScreenRaster
		jsr RunPMGRasterProgram
		
		jsr CheckAnyKey
		bne TitleScreenLoop
		
		;jsr WaitForAnyKey
		bcc HostTitleScreenEnd
		lda kbcode
		cmp #$2d ; T
		bne HostTitleScreenEnd
		jsr ClearPMGMem
		jsr WaitForAnyKeyDepress
		jsr HostTrainerScreen
		;jmp HostTitleScreen
HostTitleScreenEnd	
		lda #$00
		jsr HostSetColorRegs	
		jsr ClrScr
		jsr ClearPMGMem
		jsr WaitForAnyKeyDepress
		jsr HostSilenceMusic
		rts
	
TrainerScreenPositions		
		.he 20,8f
		.he 20,7f
		.he 20,6f
		.he 20,5f
		.he 30,3f
		.he 30,2f

TrainerScreenTexts
		dta c'1: UNLIMITED LIVES   OF', 'F'*
		dta c'2: INVINCIBILITY     OF', 'F'*
		dta c'3: NO EXTRA MONSTERS OF', 'F'*
		dta c'4: FRAME SKIPPING    OF', 'F'*
		dta c'NUMERIC KEY TO CHANG', 'E'*
		dta c'FIRE OR START TO PLA', c'Y'*
		
	
TextOffsets dta 21,	24+21, 2*24+21, 3*24+21

TrainerTextOn	dta c'ON', ' '*
TrainerTextOff	dta c'OF', 'F'*

TrainerUpdateTexts
		ldx #0
TrainerUpdateTextLoop		
		ldy TextOffsets,x
		lda FlagUnlimitedLives,x
		stx zp_tmp_0
		bpl TrainerFlagOff
		ldx #$00
LoopTextOn		
		lda TrainerTextOn,x
		sta TrainerScreenTexts,y
		iny
		inx
		cpx #3
		bne LoopTextOn
		beq TrainerUpdateTextNext
TrainerFlagOff
		ldx #$00
LoopTextOff
		lda TrainerTextOff,x
		sta TrainerScreenTexts,y
		iny
		inx
		cpx #3
		bne LoopTextOff
TrainerUpdateTextNext
		ldx zp_tmp_0
		inx
		cpx #$4
		bne TrainerUpdateTextLoop
		rts
TrainerKeys
		dta $1f, $1e, $1a, $18
HostTrainerScreen
		;jsr HostShowNonGameScreen
		lda #$00
		jsr HostSetColorRegs		
        jsr ClrWrkScr ; CALL ClrWrkScr
        ;lda #$45 ; LD   A,45
        ;jsr FillAttr ; CALL FillAttr
		jsr PrintBorder
HostTrainerScreenContinue
		jsr TrainerUpdateTexts
        lda #<TitleScreenColors ; 
        sta z80_e
        lda #>TitleScreenColors
        sta z80_d
        jsr exx ; EXX
        lda #<TrainerScreenPositions 
        sta z80_l
        lda #>TrainerScreenPositions
        sta z80_h
        lda #<TrainerScreenTexts
        sta z80_e
        lda #>TrainerScreenTexts
        sta z80_d
        lda #$06 ;
        sta z80_b
        lda #$01 ; XOR  A
        sta LA734 ; LD   (LA734),A
        jsr @@125 ; CALL @@125
		jsr UpdateScreen
		lda #$de
		jsr HostSetColorRegs
		jsr WaitForAnyKey
		bcc HostTrainerScreenEnd
		lda kbcode
		ldx #0
TrainerKeysLoop		
		cmp TrainerKeys,x
		bne TrainerKeysNext
		lda FlagUnlimitedLives,x
		eor #$ff
		sta FlagUnlimitedLives,x
		jsr WaitForAnyKeyDepress
		jmp HostTrainerScreenContinue
TrainerKeysNext
		inx
		cpx #4
		bne TrainerKeysLoop
HostTrainerScreenEnd		
		rts
		
HostGameOverScreen
		lda #$de
		jsr HostSetColorRegs
		lda #$b
		jsr HostPlayMusic
		
		lda #$00
		sta z80_reg0
		sta z80_reg1
		
		lda #<GameOverScreenPMG
		ldx #>GameOverScreenPMG
		jsr PreparePMG
		
		jsr EnablePMG

GameOverScreenLoop		
		lda #<GameOverScreenRaster
		ldx #>GameOverScreenRaster
		jsr RunPMGRasterProgram
		
		inc z80_reg0
		sne:inc z80_reg1
		;lda z80_reg1
		;cmp #6
		ldx #$5
		lda PAL
		lsr @
		beq GameOverNTSC
		ldx #$6
GameOverNTSC		
		cpx z80_reg1
		beq GameScreenEnd
		
		jsr CheckAnyKey
		bne GameOverScreenLoop
		jsr WaitForAnyKeyDepress
		
GameScreenEnd
		lda #$00
		jsr HostSetColorRegs	
		jsr ClrScr
		jsr ClearPMGMem
		jsr HostSilenceMusic
		rts
	
HostGameCompletedScreen
		lda #$8e
		jsr HostSetColorRegs

		lda #$3
		jsr HostPlayMusic
		
		lda #<GameCompletedScreenPMG
		ldx #>GameCompletedScreenPMG
		jsr PreparePMG
		
		jsr EnablePMG

GameCompletedScreenLoop		
		lda #<GameCompletedScreenRaster
		ldx #>GameCompletedScreenRaster
		jsr RunPMGRasterProgram
		
		jsr CheckAnyKey
		bne GameCompletedScreenLoop
		jsr WaitForAnyKeyDepress
		
GameCompletedEnd
		lda #$00
		jsr HostSetColorRegs	
		jsr ClearPMGMem
		jsr ClrScr
		jsr HostSilenceMusic
		rts
	
adjust_counter
		dta 5
		
HostVBI
		pha
		lda skstat
		and #$04
		bne HostVBINoKey
		lda kbcode
		cmp #$1c
		bne HostVBINoKey
		ldx #$ff
		txs
		jmp GameRestart
HostVBINoKey		
		bit HostAllowMusic
		bpl HostVBI_PMG
		tya
		pha
		txa
		pha
		ldx PAL
		dex
		beq done_adjust
		dec adjust_counter
		bpl done_adjust
		mva #5 adjust_counter
		jmp done_music
done_adjust		
		jsr RASTERMUSICTRACKER+3
done_music		
		pla
		tax
		pla
		tay
HostVBI_PMG
		bit HostInGame
		bpl HostVBI_End
		tya
		pha
		txa
		pha
		jsr HostSetPMGOnGameScreen
		pla
		tax
		pla
		tay
HostVBI_End		
		pla
		rts
		
HostPlayMusic
		ldx #<music
		ldy #>music
		jsr RASTERMUSICTRACKER
		lda #$ff
		sta HostAllowMusic
		rts
		
HostSilenceMusic
		lda #$00
		sta HostAllowMusic
		jsr RASTERMUSICTRACKER+9
		rts
		
EnablePMG
		mva >atari_pmg pmbase		;missiles and players data address
		mva #$03 pmcntl		;enable players and missiles

		lda #%00111101
		sta dmactl
		
		lda #$01
		sta gtictl
		rts
		
ClearPMGMem
		lda #$00
		tay
ClearPMGLoop		
		sta atari_pmg+$0300,y
		sta atari_pmg+$0400,y
		sta atari_pmg+$0500,y
		sta atari_pmg+$0600,y
		sta atari_pmg+$0700,y
		iny
		bne ClearPMGLoop
		rts

GameCompletedScreenPMG
		dta PMGPlayer0, $50, 8, %11111111
		dta PMGPlayer1, $50, 8, %11111110
		dta PMGPlayer0, $70, 8, %11101111
		dta PMGPlayer1, $70, 8, %01111111
		dta PMGMissile, $70, 8, %00001011
		dta PMGPlayer0, $80, 8, %00011101
		dta PMGPlayer1, $80, 8, %11111111
		dta PMGPlayer2, $90, 8, %11110111
		dta PMGPlayer3, $90, 8, %11111100
		dta PMGPlayer2, $a0, 8, %01111111
		dta PMGPlayer3, $a0, 8, %11011000
		dta PMGPlayer0, $c0, 8, %11110111
		dta PMGPlayer1, $c0, 8, %10000000
		dta PMGEnd

GameCompletedScreenRaster
		dta 56/2
		dta <hposp0,$64
		dta <colpm0,$e0
		dta <hposp1,$84
		dta <colpm1,$e0
		dta <sizep0,3
		dta <sizep1,3
		dta <sizep2,3
		dta <sizep3,3
		dta <sizem,$ff
		dta $ff
		dta 88/2
		dta <hposp0,$5c
		dta <colpm0,$90
		dta <hposp1,$7c
		dta <colpm1,$90
		dta <hposm0,$9c
		dta <hposm1,$a4		
		dta <hposp2,$64
		dta <colpm2,$30
		dta <hposp3,$84
		dta <colpm3,$30
		dta $ff
		dta 176/2
		dta <hposp0,$70
		dta <colpm0,$50
		dta <hposp1,$90
		dta <colpm1,$50
		dta $ff
		dta 0
		
GameOverScreenPMG
		dta PMGPlayer0, $40-1, 8+1, %11110111
		dta PMGMissile, $40-1, 8+1, %00000001
		dta PMGPlayer0, $70-1, 8+1, %11111111
		dta PMGMissile, $70-1, 8+1, %00000011
		dta PMGPlayer1, $70-1, 8+1, %11011111
		dta PMGPlayer2, $80, 8, %11111111
		dta PMGMissile, $80, 8, %11110000
		dta PMGEnd
		
GameOverScreenRaster
		dta 56/2
		dta <hposp0,$6c
		dta <hposm0,$88
		dta <colpm0,$20
		dta <sizep0,3
		dta <sizep1,3
		dta <sizep2,3
		dta <sizem,$ff
		dta <hposp2,$64
		dta <hposm2,$74
		dta <colpm2,$c0
		dta <hposm3,$8c
		dta <colpm3,$00
		dta $ff
		dta 72/2
		dta <hposp0,$58
		dta <hposm0,$78
		dta <colpm0,$50
		dta <hposp1,$84
		dta <colpm1,$50		
		dta $ff
		dta 0
		
TitleScreenPMG
		dta PMGMissile, $40, 8, $03	; green
		dta PMGPlayer0, $40, 8, $7f
		dta PMGPlayer1, $50, 8, %10111100	; blue
		dta PMGPlayer2, $50, 8, %00111111	; black on ".A.C.G."
		dta PMGPlayer0, $60, 8, %11111000	; ATARI
		dta PMGPlayer1, $60, 8, %11111110	; VERSION
		dta PMGPlayer2, $60, 8, %11110000	; 2016
		dta PMGPlayer3, $70, 8, %11110000	; violet on CODE
		dta PMGPlayer2, $70, 8, %11111110	; black on "MARIUSZ"
		dta PMGPlayer3, $80, 8, %11111000	; violet on MUSIC
		dta PMGPlayer2, $80, 8, %00111110	; black on "MIKER"
		dta PMGPlayer3, $90, 8, %01111100	; violet on COLOR
		dta PMGPlayer2, $90, 8, %00111100	; black on "JOSE"
		dta PMGMissile, $b8, 8, $03			; "OR"
		dta PMGPlayer0, $b8, 8, %11011110	; green on "TO PLAY"
		dta PMGPlayer1, $b8, 8, %11110000	; red on FIRE
		dta PMGPlayer2, $b8, 8, %11111000	; START
		dta PMGEnd
		
TitleScreenRaster
		dta 56/2
		dta <hposp0,$68
		dta <hposm0,$88
		dta <colpm0,$b0
		dta <sizep0,3
		dta <sizem,$ff
		dta <hposp1,$68
		dta <colpm1,$80
		dta <hposp2,$68+28-8
		dta <colpm2,$00
		dta <sizep1,3
		dta <sizep2,3
		dta <hposp3,$68
		dta <colpm3,$40
		dta <sizep3,3		
		dta $ff
		
		dta 88/2
		dta <hposp0,$5c
		dta <colpm0,$70
		dta <hposp1,$74
		dta <colpm1,$80
		dta <hposp2,$94
		dta <colpm2,$90
		dta $ff
		
		dta 106/2
		dta <hposp2,$68+28-8
		dta <colpm2,$00
		dta $ff
		
		dta 156/2
		dta <hposp0,$8c
		dta <hposm0,$68
		dta <colpm0,$e0
		dta <hposp1,$54
		dta <colpm1,$20
		dta <hposp2,$74
		dta <colpm2,$a0
		dta $ff
		
		dta 0
		
PreparePMG
		sta z80_l
		stx z80_h
		jsr ClearPMGMem
		ldy #$00
PreparePMGLoop		
		lda (z80_hl),y
		bmi PreparePMGEnd
		ora #>atari_pmg
		sta z80_d
		iny
		lda (z80_hl),y
		iny
		sta z80_e
		lda (z80_hl),y
		iny
		sta z80_b
		lda (z80_hl),y
		iny
		sty z80_c
		ldy #0
PreparePMGSetMemLoop		
		sta (z80_de),y
		iny
		cpy z80_b
		bne PreparePMGSetMemLoop
		ldy z80_c
		jmp PreparePMGLoop
PreparePMGEnd
		rts
		
RunPMGRasterProgram
		sta z80_l
		stx z80_h
		ldy #$ff
PMGRasterNextSync
		iny
PMGRasterLoop
		lda (z80_hl),y
		beq PMGRasterEnd
		iny
PMGRasterSyncLoop		
		cmp vcount
		bne PMGRasterSyncLoop
PMGRasterSetRegsLoop		
		lda (z80_hl),y
		bmi PMGRasterNextSync
		tax
		iny
		lda (z80_hl),y
		iny
		sta hposp0,x
		jmp PMGRasterSetRegsLoop
PMGRasterEnd
		rts
	

PMGAmulet1
		.he 00 0C 1E 3F 7F FF FF 
		.he 7F FF FF FF FF FF FF 
		.he FF FF FF FF FF FF 3F 38
		.he 00 00 00 00 2A 2A 2A 
		.he 3F 3F 3F 3F 3F 3F 3F 
		.he 3F 3F 3F 3F 3F 3F 2A 00
PMGAmulet2
		.he 0F 3F 7F 7F FF FF FF
		.he FF FF FF FF FF FF FF 
		.he FF FF FF FF FF FF 7C 7C
		.he 00 00 2A 2A 3F 3F 3F
		.he 3F 3F 3F 3F 3F 3F 3F 
		.he 3F 3F 3F 3F 3F 2A 00 00
PMGAmulet3
		.he 1C 3F 7F FF FF FF FF 
		.he FF FF FF FF FF FF FF 
		.he FF FF FF FF 7F 7F 3E 1C
		.he 00 00 00 2A 2A 3F 3F 
		.he 3F 3F 3F 3F 3F 3F 3F 
		.he 3F 3F 3F 3F 3F 3F 00 00
PMGAmulet4
		.he 03 03 7F FF FF FF FF
		.he FF FF FF FF FF FF FF 
		.he FF FF FF FF FF FF FF 79
		.he 00 2A 2A 2A 2A 3F 3F 
		.he 3F 3F 3F 3F 3F 3F 3F
		.he 3F 3F 3F 3F 3F 3F 2A 00
PMGAmulet5
		.he 07 1F 3F 7F FF FF FF 
		.he FF FF FF FF FF FF FF 
		.he FF FF FF 7F 3F 1F 1F 07
		.he 00 00 2A 2A 3F 3F 3F
		.he 3F 3F 3F 3F 3F 3F 3F 
		.he 3F 3F 3F 3F 3F 3F 2A 00
PMGBucket
		.he 1E 3F 7F 7F FF FF FF
		.he FF FF FF FF FF FF FF 
		.he 7F 7F 7F 7F 7F 3F 3F 1E
		.he 00 00 2A 2A 3F 3F 3F
		.he 3F 3F 3F 3F 3F 3F 3F 
		.he 2A 2A 2A 2A 2A 00 00 00		
		
PMGLives
		.he 30 38 38 38 78 7C 7C 7C 7C 7C 38 38 78 7C 6C

GameScreenPMG
		dta PMGMissile, $B8-1, 9, $C0 ; overlay on number of lives
		dta PMGPlayer3, $C0-1, 9, $1F ; overlay on SCORE
		dta PMGPlayer3, $D0-2, 9, $3F ; overlay on 000000
		dta PMGEnd

HostSetPMGOnGameScreen
		lda #$49
		sta hposp0
		lda #$d0
		sta colpm0
		rts
		
InventorySprites
		dta $90 ; amulet x
		dta $94 ; amulet eye
		dta $93 ; amulet man
		dta $92 ; amulet triangle
		dta $91 ; amulet circle
		dta $5a ; bucket
		dta $98 ; amulet x
		dta $9c ; amulet eye
		dta $9b ; amulet man
		dta $9a ; amulet triangle
		dta $99 ; amulet circle
		
InventorySpritesMapForDisplay
		dta $ac ; amulet x
		dta $b0 ; amulet eye
		dta $af ; amulet man
		dta $ae ; amulet triangle
		dta $ad ; amulet circle
		dta $5a ; bucket
		dta $ac ; amulet x
		dta $b0 ; amulet eye
		dta $af ; amulet man
		dta $ae ; amulet triangle
		dta $ad ; amulet circle

InventoryOverlaysLow
		dta l(PMGAmulet1),l(PMGAmulet2),l(PMGAmulet3),l(PMGAmulet4),l(PMGAmulet5),l(PMGBucket),l(PMGAmulet1),l(PMGAmulet2),l(PMGAmulet3),l(PMGAmulet4),l(PMGAmulet5)
InventoryOverlaysHigh
		dta h(PMGAmulet1),h(PMGAmulet2),h(PMGAmulet3),h(PMGAmulet4),h(PMGAmulet5),h(PMGBucket),h(PMGAmulet1),h(PMGAmulet2),h(PMGAmulet3),h(PMGAmulet4),h(PMGAmulet5)
		
PMGColors
		.he 70 90 C0 50 20 10 70 90 C0 50 20
		
PMGPositionsPlayers
		.he 49 55 61
PMGPositionsMissiles
		.he 51 5d 69
PMGPlayerMask
		dta %00000011,%00001100,%00110000
PMGPlayerMaskInv
		dta %11111100,%11110011,%11001111
		
HostShowInventory
		ldx #0
HostShowInventoryLoop
		txa
		asl @
		asl @
		tay
		lda LA726,y
		bne Inventory_Check_Item
		sta HostInventoryP0PosX,x
		sta HostInventoryM0PosX,x
		sta HostInventoryP0Color,x
		ldy #0
		txa
		clc
		adc #[>atari_pmg]+4
		sta z80_h
		lda #PMGItemsOverlayVerticalPosition
		sta z80_l
		lda #$0
Inventory_Clear_PMG_Loop		
		sta (z80_hl),y
		iny
		cpy #22
		bne Inventory_Clear_PMG_Loop
		lda #PMGItemsOverlayVerticalPosition-22
		sta z80_l
		lda #[>atari_pmg]+3
		sta z80_h
Inventory_Clear_PMG_Missile_Loop		
		lda (z80_hl),y
		and PMGPlayerMaskInv,x
		sta (z80_hl),y
		iny
		cpy #22*2
		bne Inventory_Clear_PMG_Missile_Loop
		jmp ShowInventoryNextLoop
Inventory_Check_Item
		ldy #0
Inventory_Check_Item_Loop		
		cmp InventorySprites,y
		beq Inventory_Found_Item
		iny
		cpy #11
		bne Inventory_Check_Item_Loop
		beq ShowInventoryNextLoop
Inventory_Found_Item
		lda PMGColors,y
		sta HostInventoryP0Color,x
		lda PMGPositionsPlayers,x
		sta HostInventoryP0PosX,x
		lda PMGPositionsMissiles,x
		sta HostInventoryM0PosX,x
		lda InventoryOverlaysLow,y
		sta z80_l
		lda InventoryOverlaysHigh,y
		sta z80_h
		lda #PMGItemsOverlayVerticalPosition
		sta z80_e
		txa
		clc
		adc #[>atari_pmg]+4
		sta z80_d
		ldy #$00
Inventory_Set_PMG_Player_Loop		
		lda (z80_hl),y
		sta (z80_de),y
		iny
		cpy #22
		bne Inventory_Set_PMG_Player_Loop
		lda #PMGItemsOverlayVerticalPosition-22
		sta z80_e
		lda #[>atari_pmg]+3
		sta z80_d
Inventory_Set_PMG_Missile_Loop		
		lda (z80_hl),y
		and PMGPlayerMask,x
		sta z80_b
		lda (z80_de),y
		and PMGPlayerMaskInv,x
		ora z80_b
		sta (z80_de),y
		iny
		cpy #22*2
		bne Inventory_Set_PMG_Missile_Loop
ShowInventoryNextLoop
		inx
		cpx #3
		jne HostShowInventoryLoop
		
		lda HostInventoryP1PosX
		sta hposp1
		lda HostInventoryP2PosX
		sta hposp2
		lda HostInventoryM0PosX
		sta hposm0
		lda HostInventoryM1PosX
		sta hposm1
		lda HostInventoryM2PosX
		sta hposm2
		lda HostInventoryP1Color
		sta colpm1
		lda HostInventoryP2Color
		sta colpm2
		
		rts

HostMapInventorySprite
		ldy #0
HostMapInventorySpriteLoop		
		cmp InventorySprites,y
		beq HostMapInventorySpriteFound
		iny
		cpy #11
		bne HostMapInventorySpriteLoop
		rts
HostMapInventorySpriteFound
		lda InventorySpritesMapForDisplay,y
		rts
		
HostDLI
		pha
		lda HostInventoryP0PosX
		sta hposp0
		lda HostInventoryP0Color
		sta colpm0
		pla
		rti
		
		
