		icl 'atari.hea'
		
; ---	BASIC switch OFF
		org $0600\ mva #$ff portb\ rts\ ini $0600

; files:
; te0400.bin:     	raw image of game 0300 - bfff
; te0400.bin.lzg: 	lzg compressed image of game 0300 - bf00
; tec800.bin:		raw image of game c800 - cfff
; ted800.bin:		raw image of game d800 - e5ff
; ted800.bin.lzg:	lzg compressed image of game d800 - e5ff
; tef300.bin:		raw image of game f300 - ffff
; tef300.bin.lzg:	raw image of game f300 - ffff

; Memmory map after loading:
;$2000 - $47ff:		loading screen
;$4800 - $bfff:		2nd part of main game (0400) compressed data
;$c000 - $c3ff:		startup and decompression code
;$c400 - $c7ff:		compressed f300 data
;$c800 - $cfff:		raw image of game c800 - cfff
;$d800 - $dfff: 	1st part of main game (0400) compressed data
;$f000 - $f7ff:		compressed d800 data

		org $4800
		ins 'te0400.bin.lzg',+$0000,$0800
		
		org $5000
		ins 'tec800.bin'
		
		org $5800
		ins 'ted800.bin.lzg'
		
		org $c000,$6000
		ins 'te0400.bin.lzg',+$8000
		
		org $c100,$6100
		; copy d800 -> 4000 (0800) bytes
		ldx #$08
		ldy #$00
MemSourceD800
		lda $d800,y
MemDestination4000
		sta $4000,y
		iny
		bne MemSourceD800
		inc MemSourceD800+2
		inc MemDestination4000+2
		dex
		bne MemSourceD800
		; decompress 0300 image
		lda #<$4000
		sta _in
		lda #>$4000
		sta _in+1
		lda #<$0400
		sta _out
		lda #>$0400
		sta _out+1
		jsr LZG_Decode
		; decompress d800 data
		lda #<$f000
		sta _in
		lda #>$f000
		sta _in+1
		lda #<$d800
		sta _out
		lda #>$d800
		sta _out+1
		jsr LZG_Decode
		; decompress f300 data
		lda #<[$c800-$0490]
		sta _in
		lda #>[$c800-$0490]
		sta _in+1
		lda #<$f300
		sta _out
		lda #>$f300
		sta _out+1
		jsr LZG_Decode
		; jump to game
		lda #$00
		sta colbak
		jmp $404c
		
		icl 'lzgmini_6502.s'
		ert *>= $c800-$0490
		
		org $6800-$0490
		ins 'tef300.bin.lzg'
		
		org $6800
ldsrc	equ $fc
lddest	equ $fe

		sei
		lda #$0
		sta nmien
		lda portb
		ora #$02
		and #$fe
		sta portb

		lda #$48
		ldy #$d8
		ldx #$08
		jsr ldcopy
		lda #$50
		ldy #$c8
		ldx #$08
		jsr ldcopy
		lda #$58
		ldy #$f0
		ldx #$08
		jsr ldcopy
		lda #$60
		ldy #$c0
		ldx #$08
		jsr ldcopy
		
		lda portb
		ora #$01
		sta portb
		lda #$40
		sta nmien
		cli
		rts
		
ldcopy	sta ldsrc+1
		sty lddest+1
		ldy #$0
		sty ldsrc
		sty lddest
ld1		lda (ldsrc),y
		sta (lddest),y
		iny
		bne ld1
		inc ldsrc+1
		inc lddest+1
		dex
		bne ld1
		rts
		
		ini $6800
		
		org $4800
		ins 'te0400.bin.lzg',+$0800,$7800
		
		org $0600
@		lda vcount
		bne @-
		sei
		lda #$0
		sta nmien
		sta dmactl
		lda portb
		ora #$02
		and #$fe
		sta portb
		jmp $c100
		
		run $0600
		
		