/*
Atari notes:
Free space: $C000 - $CFFF
			$D800 - $E1FF
Bitmap size (200 lines * 32 bytes) = $1900 bytes
Bitmap position: $E200 - $FAFF
PM/G base: $F800
PM/G data: $FB00 - FFF7
CPU vectors: $FFFA - $FFFF
*/

1st screen color: 00 07 03 08
2nd screen color: 00 08 03 02
3rd screen color: 00 07 06 08



0900 - 14FF?: SID music
1AC7 - 1B0C: table of screen pointers used when filling a bottle on screen
7EA7 - 8BA6: background buffer 3D view
C000 - C1FF: sprites
C200 - C3FF: unused
C400 - C7FF: color ram
C800 - CFFF: SID sound effects
E000 - FF3F: bitmap screen

158E: $7EA7 - pointer to backbuffer
1590: $8CB7 - pointer to?
1592: $7EA7 - pointer to backbuffer
1594: $8BC7 - pointer to?
1C60: Background color
1C61: Color - high nybble of video matrix at $C400
1C62: Color - low nybble of video matrix at $C400
1C63: Color - color ram
1C64: Next colors (copied by set color procedure)
1C65:
1C66:
1C67:
1C95: seconds
1C96: minutes
1C97: hours

1CA3: multiply 16bit by 8bit signed number, product 32bit
	: A/X - factor 1 (X = MSB)
	: Y - factor 2
	: $82/83/84/85 result
1D31: multiply two 16bit signed numbers, product 32bit
	: $88/89, $8C/$8D: arguments
	: $82/83/84/85 result
1E76: multiply two 8 signed bit numbers, product 16bit
	: X,Y arguments
	: $82/$83 result
1EDE: divide 32 bit number by 16 bit number
	: $88/$89/$8A/$8B: divisor
	: $8C/$8D: dividend
2CAA: sort visible objects on the scene, seems to use insertion sort and thus slow
3884: render one polygon
404C: game start
44DF: copy background buffer to screen (3D view)
	: screen address pointer stored at $1733 (initialized from $9651 = $E520)
	: backbuffer pointer stored at $158E = $7EA7
	: size = $68 lines x $100 pixels = $0D00 (104 lines, $0D00/3328 bytes)
4608: draw rectangle (horizon?) in backbuffer
	: A - color ($00 - $0F, colors 0-3 are solid, other colors are dithered)
	: $7A/$7B + Y - pointer to backbuffer location
	: X - height of rectangle
5ABC: handle pressing of A key (change angle)
5ADC: handle pressing of S key (change step)
5B33: set colors for 3D view	
686C: print a string
	: string pointer in Y - high byte, X - low byte
	: data pointer in $7C/$7D: data consists of screen memory pointer (two bytes)
	:	and one byte for string length
6B2A: fill bottle level on screen, bottle level stored in $156F	
6BD0: IRQ routine (reached through vector at $0314)
	: calls $0901 (SID music player) or $CC2D (SID effects player)
	: calls $6B2A (bottle level)
7698: clear backbuffer	
79F8: show sprite, sprite number in A, x position in X, y position in Y
7A41: hide sprite, sprite number in A
7B89: draw targeting cursor
8800: part of startup, updates left and right column on screen, code gets overwritten later
8AE0: part of startup, code overwritten later (trainer code patches)
8900: trainer
9600: World database with format the same as Driller
960A: color patterns (4 bytes each) for rendering colors, used by $4608, first four colors solid, next colors are dithered
9651: Screen pointer: top-left of 3D window, C64: E520, Atari: E504, Row 32, Column 32, Character column 4
9675: Screen pointer: position of million digit in top text, C64: E086, Atari: E100, Row 6, Column 128, Character column 16
9678: Screen pointer: position of room name text below 3D window, C64: F5A1, Atari: F574, Row 137, Column 96, Character column 12
967B: Screen pointer: hieroglyph left to room name, C64: F569, Atari: F56D, Row 137, Column 40, Character column 5
967E: Screen pointer: hieroglyph left to room name, C64: F589, Atari: F571, Row 137, Column 72, Character column 9
9681: Screen pointer: start of bitmap RAM, C64: E000, Atari: E000, Row 0, Column 0, Character column 0
9684: Screen pointer: ???, C64: E140, Atari: E140, Row 8, Column 0, Character column 0
9687: Screen pointer: ???, C64: E280, Atari: E280, Row 16, Column 0, Character column 0
968A: Screen pointer: center of the screen, C64: ECF8, Atari: EC8F, Row 80, Column 120, Character column 15
968D: Screen pointer: start of bitmap RAM, C64: E000, Atari: E000, Row 0, Column 0, Character column 0
9690: Screen pointer: position of 100,000 digit, C64: E096, Atari: E102, Row 6, Column 144, Character column 18
9693: Screen pointer: position of 100 digit, C64: E0B6, Atari: E106, Row 6, Column 176, Character column 22
9696: Screen pointer: hieroglyph right to room name, C64: F639, Atari: F587, Row 137, Column 248, Character column 31
9699: Screen pointer: hieroglyph right to room name, C64: F629, Atari: F585, Row 137, Column 232, Character column 29
969C: Screen pointer: hieroglyph right to room name, C64: F649, Atari: F589, Row 137, Column 264, Character column 33
969F: Screen pointer: right above room name, C64: F480, Atari: F410, Row 128, Column 128, Character column 16
96A2: Screen pointer: 3D window, C64: EA68, Atari: EA0D, Row 64, Column 104, Character column 13
96A5: Screen pointer: 3D window, C64: EBA8, Atari: EB4D, Row 72, Column 104, Character column 13
96A8: Screen pointer: 3D window, C64: ECE8, Atari: EC8D, Row 80, Column 104, Character column 13
96AB: Screen pointer: 3D window, C64: EE28, Atari: EDCD, Row 88, Column 104, Character column 13
96AE: Screen pointer: 3D window, C64: EF68, Atari: EF0D, Row 96, Column 104, Character column 13

CB4B: play sound effects specified in A
*/
/*
Profile report:
1. 1DD2		122 calls	214,638	1759	17,43%	divide 24bit by 16bit integer
2. 1CA3		708 calls	181,235	 255	14,72%	multiply 16bit by 8bit
3. 2CAA		  1 calls	160,241			13,01%	sort objects on scene
4. 3884		 19 calls	108,053	5687	 8,78%	render polygon
5. 304D		 19 calls	 86,165 4535	 7,00%
6. 1EDE		 55 calls	 71,208 1294	 5,78%	divide 32bit by 16bit
7. 4608		  2 calls	 46,556		 	 3,78%	render sky/ground
8. 3D16		 11 calls	 41,622		 	 3,38%
9. 1D31		 78 calls	 37,625	 482 	 3,06%	multiply 16bit by 16bit
10.44DF		  1 calls	 34,214		 	 2,78%	copy background buffer to screen
11.2008		  2 calls	 29,346		 	 2,38%
12.3485		426 calls	 24,664		 	 2,00%
13.3665		  5 calls 	 21,671		 	 1,76%
14.686C		  8 calls	 23,664		 	 1,92%	print text
15.3522		 18 calls	 16,801		 	 1,36%
*/
/*
Important differences between C64 and C+4 versions
Difference at 0900: 00 FF
09E0: STA $0900 replaced with JSR $FC30
09ED: STA $D418 replaced with STA $0298
Difference at 0AE4: 00 02
0AE5: STA $D416 replaced with STA $0296
0AF1: STA $D402,Y replaced with STA $0282,Y
0AFA: STA $D403,Y replaced with STA $0283,Y
0B09: STA $D405,Y replaced with STA $0285,Y
0B0F: STA $D406,Y replaced with STA $0286,Y
0B30: STA $D404,Y replaced with STA $0284,Y
0B36: STA $D404,Y replaced with STA $0284,Y
0BD1: STA $D404,Y replaced with STA $0284,Y
0BEB: STA $D401,Y replaced with STA $0281,Y
0BF0: STA $D400,Y replaced with STA $0280,Y
0C06: STA $D401,Y replaced with JSR $FC01
0C0A: STA $D400,Y replaced with JSR $FC1E
0C27: STA $D401,Y replaced with STA $0281,Y
0C2C: STA $D400,Y replaced with STA $0280,Y
0C45: STA $D404,Y replaced with STA $0284,Y
0D07: STA $D400,Y replaced with JSR $FC1E
0D0D: STA $D401,Y replaced with JSR $FC01
0D3C: STA $D400,Y replaced with JSR $FC1E
0D42: STA $D401,Y replaced with JSR $FC01
0D8D: STA $D400,Y replaced with JSR $FC1E
0D99: STA $D401,Y replaced with JSR $FC01
0DC2: STA $D404,Y replaced with STA $0284,Y
0DE1: STA $D402,Y replaced with STA $0282,Y
0DE4: STA $D415 replaced with STA $0295
0E30: STA $D403,Y replaced with STA $0283,Y
0E34: STA $D402,Y replaced with STA $0282,Y
0E54: STA $D400,Y replaced with STA $0280,Y
0E6E: STA $D401,Y replaced with JSR $FC01
0E72: STA $D400,Y replaced with JSR $FC1E
1AC8: Screen pointer FE DE
C64: FE6B, Atari: FE85, Row 195, Column 104, Character column 13
1ACA: Screen pointer FE DE
C64: FE6A, Atari: FE5D, Row 194, Column 104, Character column 13
1ACC: Screen pointer FE DE
C64: FE69, Atari: FE35, Row 193, Column 104, Character column 13
1ACE: Screen pointer FE DE
C64: FE68, Atari: FE0D, Row 192, Column 104, Character column 13
1AD0: Screen pointer FD DD
C64: FD2F, Atari: FDE5, Row 191, Column 104, Character column 13
1AD2: Screen pointer FD DD
C64: FD2E, Atari: FDBD, Row 190, Column 104, Character column 13
1AD4: Screen pointer FD DD
C64: FD2D, Atari: FD95, Row 189, Column 104, Character column 13
1AD6: Screen pointer FD DD
C64: FD2C, Atari: FD6D, Row 188, Column 104, Character column 13
1AD8: Screen pointer FD DD
C64: FD2B, Atari: FD45, Row 187, Column 104, Character column 13
1ADA: Screen pointer FD DD
C64: FD2A, Atari: FD1D, Row 186, Column 104, Character column 13
1ADC: Screen pointer FD DD
C64: FD29, Atari: FCF5, Row 185, Column 104, Character column 13
1ADE: Screen pointer FD DD
C64: FD28, Atari: FCCD, Row 184, Column 104, Character column 13
1AE0: Screen pointer FB DB
C64: FBEF, Atari: FCA5, Row 183, Column 104, Character column 13
1AE2: Screen pointer FB DB
C64: FBEE, Atari: FC7D, Row 182, Column 104, Character column 13
1AE4: Screen pointer FB DB
C64: FBED, Atari: FC55, Row 181, Column 104, Character column 13
1AE6: Screen pointer FB DB
C64: FBEC, Atari: FC2D, Row 180, Column 104, Character column 13
1AE8: Screen pointer FB DB
C64: FBEB, Atari: FC05, Row 179, Column 104, Character column 13
1AEA: Screen pointer FB DB
C64: FBEA, Atari: FBDD, Row 178, Column 104, Character column 13
1AEC: Screen pointer FB DB
C64: FBE9, Atari: FBB5, Row 177, Column 104, Character column 13
1AEE: Screen pointer FB DB
C64: FBE8, Atari: FB8D, Row 176, Column 104, Character column 13
1AF0: Screen pointer FA DA
C64: FAAF, Atari: FB65, Row 175, Column 104, Character column 13
1AF2: Screen pointer FA DA
C64: FAAE, Atari: FB3D, Row 174, Column 104, Character column 13
1AF4: Screen pointer FA DA
C64: FAAD, Atari: FB15, Row 173, Column 104, Character column 13
1AF6: Screen pointer FA DA
C64: FAAC, Atari: FAED, Row 172, Column 104, Character column 13
1AF8: Screen pointer FA DA
C64: FAAB, Atari: FAC5, Row 171, Column 104, Character column 13
1AFA: Screen pointer FA DA
C64: FAAA, Atari: FA9D, Row 170, Column 104, Character column 13
1AFC: Screen pointer FA DA
C64: FAA9, Atari: FA75, Row 169, Column 104, Character column 13
1AFE: Screen pointer FA DA
C64: FAA8, Atari: FA4D, Row 168, Column 104, Character column 13
1B00: Screen pointer F9 D9
C64: F96F, Atari: FA25, Row 167, Column 104, Character column 13
1B02: Screen pointer F9 D9
C64: F96E, Atari: F9FD, Row 166, Column 104, Character column 13
1B04: Screen pointer F9 D9
C64: F96D, Atari: F9D5, Row 165, Column 104, Character column 13
1B06: Screen pointer F9 D9
C64: F96C, Atari: F9AD, Row 164, Column 104, Character column 13
1B08: Screen pointer F9 D9
C64: F96B, Atari: F985, Row 163, Column 104, Character column 13
1B0A: Screen pointer F9 D9
C64: F96A, Atari: F95D, Row 162, Column 104, Character column 13
1B0C: Screen pointer F9 D9
C64: F969, Atari: F935, Row 161, Column 104, Character column 13
40FC: JSR $CD12 replaced with JSR $E512
4133: JSR $CB4B replaced with JSR $E34B
4149: STA $0900 replaced with JSR $FC30
4387: JSR $CD12 replaced with JSR $E512
4399: STA $0900 replaced with JSR $FC30
43A1: JSR $CB4B replaced with JSR $E34B
43B2: AND $D015 replaced with AND $0215
43B5: STA $D015 replaced with JSR $FC50
43F7: JSR $CB4B replaced with JSR $E34B
44E4: JSR $CB4B replaced with JSR $E34B
Difference at 4525: FF A7
Difference at 4526: FF 7D
4527: STA $FFFF,Y replaced with STA $D560,Y
Difference at 455E: 33 02
Difference at 455F: 30 03
Difference at 467B: 00 4E
Difference at 467D: 00 4E
Difference at 467F: 00 9D
Difference at 4681: 00 85
Difference at 4683: 00 0E
Difference at 4685: 00 1C
Difference at 4687: 00 36
Difference at 4688: 00 40
Difference at 487C: FF 06
Difference at 488F: 46 00
Difference at 4890: 46 00
Difference at 4945: FF C8
Difference at 4946: FF 96
Difference at 494F: FF C8
Difference at 4950: FF 96
Difference at 5B31: 3B 00
Difference at 5B32: 20 73
5B35: STA $01 replaced with NOP NOP
Difference at 5B66: D8 DC
Difference at 5B75: C4 CE
Difference at 5B8C: 9D BD
Difference at 5B8D: FF AC
Difference at 5B8E: FF FA
Difference at 5B92: 9D BD
Difference at 5B93: FF AC
Difference at 5B94: FF EC
5BB4: STA $D020 replaced with JSR $FC70
5BB7: STA $D021 replaced with STA $0021
Difference at 5BBB: 37 00
Difference at 5BBD: 37 0D
Difference at 5BBF: 37 FF
Difference at 5BC1: 38 FF
Difference at 5BC3: 38 00
Difference at 5BC5: 37 00
Difference at 5BC7: 37 00
Difference at 5BC9: 37 06
Difference at 5CBC: 58 0E
5CBD: JSR $3946 replaced with JSR $0046
Difference at 5CC0: 46 08
Difference at 5D86: 37 00
Difference at 5D87: 38 80
Difference at 5D88: 43 80
Difference at 5D89: 38 C0
Difference at 5D8A: 37 26
5E4B: JSR $CC2D replaced with JSR $E42D
5F42: JSR $CB4B replaced with JSR $E34B
66DE: JSR $CB4B replaced with JSR $E34B
Difference at 686A: 00 CF
Difference at 686B: 00 01
6948: STA $FFFF replaced with STA $D610
6A2E: STA $C407,X replaced with STA $F407,X
6A31: STA $C42F,X replaced with JSR $FCA2
6A47: STA $C407,X replaced with STA $F407,X
6A4A: STA $C42F,X replaced with JSR $FCA2
Difference at 6B29: 00 F0
6B5F: STA $FFFF,Y replaced with STA $DBEC,Y
Difference at 6BAF: A9 8D
Difference at 6BB0: D0 3F
Difference at 6BB1: 8D FF
Difference at 6BB2: 14 EA
Difference at 6BB3: 03 EA
Difference at 6BB4: A9 EA
Difference at 6BB5: 6B EA
Difference at 6BB6: 8D EA
Difference at 6BB7: 15 EA
Difference at 6BB8: 03 EA
Difference at 6BB9: A9 EA
Difference at 6BBA: B6 EA
Difference at 6BBB: 8D EA
Difference at 6BBC: 18 EA
Difference at 6BBD: 03 EA
Difference at 6BBE: A9 EA
Difference at 6BBF: 6E EA
Difference at 6BC0: 8D EA
Difference at 6BC1: 19 EA
Difference at 6BC2: 03 EA
Difference at 6BC3: A9 EA
Difference at 6BC4: 00 EA
Difference at 6BC5: 8D EA
Difference at 6BC6: 51 EA
Difference at 6BC7: 15 EA
Difference at 6BC8: 8D EA
Difference at 6BC9: C6 EA
Difference at 6BCA: 1A EA
Difference at 6BCB: 8D EA
Difference at 6BCC: AD EA
Difference at 6BCD: 6B EA
6C28: JSR $CC2D replaced with JSR $E42D
6D6F: JSR $CB4B replaced with JSR $E34B
6D79: Screen pointer FA DA
C64: FAF0, Atari: FA56, Row 168, Column 176, Character column 22
6D7F: Screen pointer FC DC
C64: FC30, Atari: FB96, Row 176, Column 176, Character column 22
6D93: Screen pointer FA DA
C64: FAF0, Atari: FA56, Row 168, Column 176, Character column 22
6D99: Screen pointer FC DC
C64: FC30, Atari: FB96, Row 176, Column 176, Character column 22
6DEB: JSR $CB4B replaced with JSR $E34B
6F02: LDA $DC00 replaced with JSR $FF58
6F4A: STA $DC00 replaced with JSR $FF50
6F4D: LDA $DC01 replaced with LDA $FF08
6F50: CMP $DC01 replaced with CMP $FF08
6FC9: Screen pointer FE DE
C64: FEA9, Atari: FE3D, Row 193, Column 168, Character column 21
Difference at 7069: A1 01
Difference at 7154: FF 79
Difference at 7155: FF 1A
Difference at 71E5: D0 02
71EB: AND $D015 replaced with AND $0215
71EE: STA $D015 replaced with STA $0215
728D: STA $0900 replaced with JSR $FC30
72B6: JSR $CB4B replaced with JSR $E34B
72CC: STA $D015 replaced with STA $0215
757D: Screen pointer E7 C7
C64: E7A9, Atari: E7AD, Row 49, Column 40, Character column 5
7701: Screen pointer FB DB
C64: FB28, Atari: FA5D, Row 168, Column 232, Character column 29
7707: Screen pointer FC DC
C64: FC68, Atari: FB9D, Row 176, Column 232, Character column 29
770D: Screen pointer FD DD
C64: FDA8, Atari: FCDD, Row 184, Column 232, Character column 29
7A03: STA $D027,X replaced with STA $0227,X
7A0A: STA $D001,X replaced with STA $0201,X
7A0F: STA $D000,X replaced with JSR $FAF0
7A1D: ORA $D015 replaced with ORA $0215
7A20: STA $D015 replaced with STA $0215
7A29: ORA $D010 replaced with ORA $0210
7A2C: STA $D010 replaced with STA $0210
7A34: AND $D010 replaced with AND $0210
7A37: STA $D010 replaced with STA $0210
7A3A: LDA $1AC6 replaced with JSR $FAA0
7A51: AND $D015 replaced with AND $0215
7A54: STA $D015 replaced with JSR $FC60
Difference at 7A8E: 04 55
Difference at 7AA0: 00 05
7AA9: Screen pointer F9 D9
C64: F938, Atari: F907, Row 160, Column 56, Character column 7
7AAF: Screen pointer FA DA
C64: FA78, Atari: FA47, Row 168, Column 56, Character column 7
7AB5: Screen pointer FB DB
C64: FBB8, Atari: FB87, Row 176, Column 56, Character column 7
7ABB: Screen pointer FC DC
C64: FCF8, Atari: FCC7, Row 184, Column 56, Character column 7
7AE8: LDA $FFFF replaced with LDA $1C98
Difference at 7B23: FF 60
Difference at 7B24: FF 7A
Difference at 7B3F: FF 60
Difference at 7B40: FF 7A
7C3B: JSR $CB4B replaced with JSR $E34B
7C60: JSR $CB4B replaced with JSR $E34B
7CA4: JSR $CB4B replaced with JSR $E34B
7DEF: STA $01 replaced with NOP NOP
7DF5: Screen pointer EB CB
C64: EBA7, Atari: EC64, Row 79, Column 96, Character column 12
7DF8: Screen pointer EA CA
C64: EA67, Atari: EB24, Row 71, Column 96, Character column 12
7DFB: Screen pointer EC CC
C64: ECE7, Atari: EDA4, Row 87, Column 96, Character column 12
7DFE: Screen pointer EB CB
C64: EBA7, Atari: EC64, Row 79, Column 96, Character column 12
7E01: Screen pointer EE CE
C64: EE27, Atari: EEE4, Row 95, Column 96, Character column 12
7E04: Screen pointer EC CC
C64: ECE7, Atari: EDA4, Row 87, Column 96, Character column 12
7E07: Screen pointer EF CF
C64: EF67, Atari: F024, Row 103, Column 96, Character column 12
7E0A: Screen pointer EE CE
C64: EE27, Atari: EEE4, Row 95, Column 96, Character column 12
7E13: STA $01 replaced with NOP NOP
Difference at 7E8D: A9 8D
Difference at 7E8E: 34 3F
Difference at 7E8F: 85 FF
Difference at 7E90: 01 EA
Difference at 7E98: DF E7
7E9C: STA $DF00,X replaced with STA $E700,X
7EA4: STA $01 replaced with NOP NOP
9652: Screen pointer E5 C5
C64: E520, Atari: E504, Row 32, Column 32, Character column 4
9676: Screen pointer E0 C0
C64: E086, Atari: E100, Row 6, Column 128, Character column 16
9679: Screen pointer F5 D5
C64: F5A1, Atari: F574, Row 137, Column 96, Character column 12
967C: Screen pointer F5 D5
C64: F569, Atari: F56D, Row 137, Column 40, Character column 5
967F: Screen pointer F5 D5
C64: F589, Atari: F571, Row 137, Column 72, Character column 9
9682: Screen pointer E0 C0
C64: E000, Atari: E000, Row 0, Column 0, Character column 0
9685: Screen pointer E1 C1
C64: E140, Atari: E140, Row 8, Column 0, Character column 0
9688: Screen pointer E2 C2
C64: E280, Atari: E280, Row 16, Column 0, Character column 0
968B: Screen pointer EC CC
C64: ECF8, Atari: EC8F, Row 80, Column 120, Character column 15
968E: Screen pointer E0 C0
C64: E000, Atari: E000, Row 0, Column 0, Character column 0
9691: Screen pointer E0 C0
C64: E096, Atari: E102, Row 6, Column 144, Character column 18
9694: Screen pointer E0 C0
C64: E0B6, Atari: E106, Row 6, Column 176, Character column 22
9697: Screen pointer F6 D6
C64: F639, Atari: F587, Row 137, Column 248, Character column 31
969A: Screen pointer F6 D6
C64: F629, Atari: F585, Row 137, Column 232, Character column 29
969D: Screen pointer F6 D6
C64: F649, Atari: F589, Row 137, Column 264, Character column 33
96A0: Screen pointer F4 D4
C64: F480, Atari: F410, Row 128, Column 128, Character column 16
96A3: Screen pointer EA CA
C64: EA68, Atari: EA0D, Row 64, Column 104, Character column 13
96A6: Screen pointer EB CB
C64: EBA8, Atari: EB4D, Row 72, Column 104, Character column 13
96A9: Screen pointer EC CC
C64: ECE8, Atari: EC8D, Row 80, Column 104, Character column 13
96AC: Screen pointer EE CE
C64: EE28, Atari: EDCD, Row 88, Column 104, Character column 13
96AF: Screen pointer EF CF
C64: EF68, Atari: EF0D, Row 96, Column 104, Character column 13

*/
$0000            .byte $2F,$37,$01,$AA,$B1,$91,$B3,$22
$0008            .byte $00,$00,$00,$4C,$00,$00,$00,$04
$0010            .byte $00,$00,$00,$00,$0B,$08,$19,$16
$0018            .byte $00,$0A,$76,$A3,$00,$00,$00,$00
$0020            .byte $00,$00,$40,$08,$B3,$BD,$00,$00
$0028            .byte $00,$00,$00,$01,$08,$74,$89,$74
$0030            .byte $89,$74,$89,$00,$A0,$00,$A0,$00
$0038            .byte $A0,$D2,$07,$00,$00,$00,$08,$00
$0040            .byte $00,$00,$08,$00,$00,$00,$00,$24
$0048            .byte $00,$01,$02,$05,$00,$00,$00,$19
$0050            .byte $35,$38,$01,$05,$00,$00,$00,$00
$0058            .byte $00,$00,$00,$00,$30,$40,$00,$01
$0060            .byte $0A,$8C,$10,$40,$08,$02,$0E,$00
$0068            .byte $0E,$02,$80,$B0,$B0,$00,$41,$41
$0070            .byte $21,$05,$05,$17,$00,$00,$00,$03
$0078            .byte $00,$01,$FF,$FF,$FF,$01,$01,$0E
$0080            .byte $00,$00,$FB,$00,$00,$00,$00,$01
$0088            .byte $02,$47,$31,$05,$00,$02,$FF,$58
$0090            .byte $00,$FF,$00,$00,$00,$00,$00,$00
$0098            .byte $00,$00,$03,$00,$00,$00,$00,$00
$00A0            .byte $00,$28,$F2,$40,$01,$00,$00,$07
$00A8            .byte $00,$00,$00,$00,$00,$00,$08,$0F
$00B0            .byte $00,$00,$3C,$03,$00,$00,$00,$01
$00B8            .byte $01,$60,$08,$FF,$9F,$00,$00,$00
$00C0            .byte $00,$00,$A0,$30,$FD,$40,$00,$00
$00C8            .byte $03,$05,$03,$40,$01,$02,$20,$00
$00D0            .byte $00,$00,$04,$00,$00,$27,$00,$08
$00D8            .byte $00,$84,$84,$84,$84,$84,$84,$84
$00E0            .byte $85,$85,$85,$85,$85,$85,$86,$86
$00E8            .byte $A4,$F1,$D0,$02,$C6,$F2,$C6,$F1
$00F0            .byte $8D,$00,$08,$60,$A4,$FD,$D0,$02
$00F8            .byte $C6,$04,$00,$00,$A9,$89,$FB,$04
$0100            .byte $BD,$C5,$B4,$9D,$F2,$07,$E8,$D0
$0108            .byte $F7,$CA,$9A,$A2,$01,$20,$F4,$00
$0110            .byte $99,$50,$03,$A0,$0C,$D9,$88,$01
$0118            .byte $F0,$05,$88,$10,$F8,$30,$09,$B9
$0120            .byte $95,$01,$8D,$26,$01,$D0,$09,$E8
$0128            .byte $20,$E8,$00,$CA,$D0,$FA,$F0,$DB
$0130            .byte $20,$F4,$00,$F0,$02,$D0,$F1,$A9
$0138            .byte $37,$85,$01,$58,$4C,$00,$89,$20
$0140            .byte $F4,$00,$AA,$20,$F4,$00,$D0,$E0
$0148            .byte $20,$F4,$00,$A8,$29,$07,$AA,$E8
$0150            .byte $E8,$E8,$98,$4A,$4A,$4A,$A8,$B9
$0158            .byte $A2,$01,$D0,$CC,$20,$F4,$00,$AA
$0160            .byte $20,$F4,$00,$85,$02,$20,$F4,$00
$0168            .byte $20,$E8,$00,$38,$E5,$02,$CA,$D0
$0170            .byte $F7,$F0,$BB,$20,$F4,$00,$AA,$A9
$0178            .byte $00,$F0,$AD,$E8,$E8,$E8,$A9,$00
$0180            .byte $F0,$A5,$E8,$B9,$B9,$01,$D0,$9F
$0188            .byte $E2,$E7,$E1,$D6,$D3,$EB,$BA,$DC
$0190            .byte $D2,$DF,$57,$63,$F4,$09,$18,$21
$0198            .byte $35,$4C,$57,$56,$55,$54,$5C,$5C
$01A0            .byte $5C,$5B,$FF,$01,$20,$55,$03,$4A
$01A8            .byte $0A,$02,$05,$C0,$33,$07,$FC,$AA
$01B0            .byte $3F,$3C,$10,$98,$27,$08,$04,$CF
$01B8            .byte $CC,$92,$66,$40,$2A,$13,$06,$88
$01C0            .byte $6C,$50,$01,$02,$85,$01,$02,$B0
$01C8            .byte $3D,$E9,$00,$0A,$8D,$1B,$09,$0A
$01D0            .byte $69,$00,$A8,$A2,$00,$B9,$41,$10
$01D8            .byte $9D,$E9,$14,$C8,$B9,$41,$10,$9D
$01E0            .byte $EC,$14,$C8,$E8,$E0,$03,$D0,$ED
$01E8            .byte $7D,$EA,$B8,$5B,$1D,$27,$1D,$81
$01F0            .byte $1B,$FF,$FF,$01,$21,$09,$7D,$EA
$01F8            .byte $7D,$EA,$FF,$04,$00,$22,$56,$89
$0200            .byte $8A,$00,$4E,$00,$2C,$38,$2C,$31
$0208            .byte $3A,$00,$31,$00,$00,$00,$00,$00
$0210            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0218            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0220            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0228            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0230            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0238            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0240            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0248            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0250            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0258            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0260            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0268            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0270            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0278            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0280            .byte $00,$00,$08,$00,$A0,$00,$0E,$0E
$0288            .byte $04,$0A,$00,$04,$0A,$00,$00,$48
$0290            .byte $EB,$80,$00,$00,$00,$00,$00,$00
$0298            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02A0            .byte $00,$00,$00,$00,$00,$00,$01,$00
$02A8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02B0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02B8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02C0            .byte $B1,$FE,$91,$FC,$C8,$D0,$F9,$E6
$02C8            .byte $FD,$E6,$FF,$D0,$F3,$C6,$01,$78
$02D0            .byte $4C,$01,$08,$00,$00,$00,$00,$00
$02D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02E0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02E8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$02F8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$0300            .byte $8B,$E3,$83,$A4,$7C,$A5,$1A,$A7
$0308            .byte $E4,$A7,$86,$AE,$00,$00,$00,$00
$0310            .byte $4C,$48,$B2,$00,$31,$EA,$66,$FE
$0318            .byte $47,$FE,$4A,$F3,$91,$F2,$0E,$F2
$0320            .byte $50,$F2,$33,$F3,$57,$F1,$CA,$F1
$0328            .byte $ED,$F6,$3E,$F1,$2F,$F3,$66,$FE
$0330            .byte $A5,$F4,$ED,$F5,$01,$00,$00,$01
$0338            .byte $01,$02,$02,$03,$04,$06,$07,$03
$0340            .byte $00,$06,$07,$0B,$03,$02,$03,$03
$0348            .byte $04,$05,$05,$06,$07,$07,$08,$09
$0350            .byte $4A,$E4,$48,$4A,$EA,$44,$AA,$44
$0358            .byte $DE,$A4,$D4,$44,$9D,$EC,$E7,$44
$0360            .byte $60,$64,$6E,$6E,$64,$60,$EB,$0E
$0368            .byte $2E,$20,$40,$57,$04,$04,$48,$48
$0370            .byte $E4,$AC,$20,$9B,$E7,$EE,$EE,$22
$0378            .byte $EE,$82,$82,$EE,$8E,$A8,$AE,$14
$0380            .byte $E2,$22,$2E,$EE,$82,$14,$E2,$A4
$0388            .byte $A4,$E4,$EE,$AA,$EE,$A2,$A2,$EE
$0390            .byte $0A,$0A,$46,$06,$4E,$0E,$00,$20
$0398            .byte $4E,$80,$4E,$20,$0E,$82,$46,$24
$03A0            .byte $40,$84,$0E,$EA,$EA,$EE,$8A,$EA
$03A8            .byte $CE,$A8,$C8,$A8,$A8,$CE,$CE,$A8
$03B0            .byte $AC,$A8,$A8,$CE,$EE,$88,$C8,$8A
$03B8            .byte $8A,$8E,$A4,$A4,$E4,$F0,$0C,$E7
$03C0            .byte $2A,$2A,$2C,$2A,$AA,$EA,$8A,$0E
$03C8            .byte $4C,$E7,$8A,$EA,$EE,$0B,$E1,$AE
$03D0            .byte $EE,$AA,$EA,$8A,$8C,$82,$EE,$A8
$03D8            .byte $EE,$C2,$A2,$AE,$EA,$8D,$E1,$4E
$03E0            .byte $AA,$AA,$AE,$AE,$4E,$4A,$AA,$AA
$03E8            .byte $4E,$44,$A4,$A4,$E0,$20,$40,$40
$03F0            .byte $80,$E0,$04,$08,$10,$20,$40,$FE
$03F8            .byte $00,$02,$0C,$30,$C0,$FE,$EB,$06
$0400            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0408            .byte $20,$54,$4F,$54,$41,$4C,$20,$45
$0410            .byte $43,$4C,$49,$50,$53,$45,$20,$54
$0418            .byte $52,$41,$49,$4E,$45,$52,$20,$20
$0420            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0428            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0430            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0438            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0440            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0448            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0450            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0458            .byte $20,$20,$20,$4E,$4F,$20,$20,$D7
$0460            .byte $D2,$C9,$D3,$D4,$A0,$D7,$C1,$D4
$0468            .byte $C3,$C8,$A0,$C3,$C8,$C5,$C1,$D4
$0470            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0478            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0480            .byte $20,$20,$20,$4E,$4F,$20,$20,$57
$0488            .byte $41,$54,$45,$52,$20,$42,$4F,$54
$0490            .byte $54,$4C,$45,$20,$43,$48,$45,$41
$0498            .byte $54,$20,$20,$20,$20,$20,$20,$20
$04A0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04A8            .byte $20,$20,$20,$4E,$4F,$20,$20,$48
$04B0            .byte $45,$41,$52,$54,$20,$43,$48,$45
$04B8            .byte $41,$54,$20,$20,$20,$20,$20,$20
$04C0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04D0            .byte $20,$20,$20,$4E,$4F,$20,$20,$46
$04D8            .byte $41,$4C,$4C,$20,$43,$48,$45,$41
$04E0            .byte $54,$20,$20,$20,$20,$20,$20,$20
$04E8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04F0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$04F8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0500            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0508            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0510            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0518            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0520            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0528            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0530            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0538            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0540            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0548            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0550            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0558            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0560            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0568            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0570            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0578            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0580            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0588            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0590            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0598            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05A0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05A8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05B0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05B8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05C0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05D0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05D8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05E0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05E8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05F0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$05F8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0600            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0608            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0610            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0618            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0620            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0628            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0630            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0638            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0640            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0648            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0650            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0658            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0660            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0668            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0670            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0678            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0680            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0688            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0690            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0698            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06A0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06A8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06B0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06B8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06C0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06D0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06D8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06E0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06E8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06F0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$06F8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0700            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0708            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0710            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0718            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0720            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0728            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0730            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0738            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0740            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0748            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0750            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0758            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0760            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0768            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0770            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0778            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0780            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0788            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0790            .byte $20,$20,$20,$20,$20,$20,$20,$20
$0798            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07A0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07A8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07B0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07B8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07C0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07C8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07D0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07D8            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07E0            .byte $20,$20,$20,$20,$20,$20,$20,$20
$07E8            .byte $07,$07,$07,$07,$07,$07,$07,$07
$07F0            .byte $07,$07,$00,$E2,$A1,$E1,$00,$04
$07F8            .byte $AA,$AE,$0A,$0A,$0E,$0A,$6A,$4A
$0800            .byte $04,$04,$04,$04,$00,$04
$0806  AA        TAX 
//------------------------------
L_JSR_($0808)_($C1EC) BAD
//------------------------------
$0807  AE 0A 0A  LDX $0A0A 
$080A  0E 0A 6A  ASL $6A0A 
$080D  4A        LSR A 
$080E  E4 48     CPX $48 
$0810  4A        LSR A 
$0811  EA        NOP 
$0812            .byte $44
$0813  AA        TAX 
$0814            .byte $44
$0815  DE A4 D4  DEC $D4A4,X 
$0818            .byte $44,$82,$82,$82,$82,$44
$081E  60        RTS 
//------------------------------
$081F            .byte $64
$0820  6E 6E 64  ROR $646E 
$0823  60        RTS 
//------------------------------
$0824            .byte $00,$00
$0826  0E 2E 20  ASL $202E 
$0829  40        RTI 
//------------------------------
$082A            .byte $02,$02,$04,$04
$082E  48        PHA 
$082F  48        PHA 
$0830  E4 AC     CPX $AC 
$0832  A4 A4     LDY $A4 
$0834  A4 EE     LDY $EE 
$0836  EE 22 EE  INC $EE22 
$0839            .byte $82,$82
$083B  EE 8E A8  INC $A88E 
$083E  AE E2 22  LDX $22E2 
$0841  2E EE 82  ROL $82EE 
$0844            .byte $E2
$0845  A4 A4     LDY $A4 
$0847  E4 EE     CPX $EE 
$0849  AA        TAX 
$084A  EE A2 A2  INC $A2A2 
$084D  EE 0A 0A  INC $0A0A 
$0850  46 06     LSR $06 
$0852  4E 0E 00  LSR $000E 
$0855  20 4E 80  JSR L_JSR_($804E)_($0855) JAM
$0858  4E 20 0E  LSR $0E20 
$085B            .byte $82
$085C  46 24     LSR $24 
$085E  40        RTI 
//------------------------------
$085F  84 0E     STY $0E 
$0861  EA        NOP 
$0862  EA        NOP 
$0863  EE 8A EA  INC $EA8A 
$0866  CE A8 C8  DEC $C8A8 
$0869  A8        TAY 
$086A  A8        TAY 
$086B  CE CE A8  DEC $A8CE 
$086E  AC A8 A8  LDY $A8A8 
$0871  CE EE 88  DEC $88EE 
$0874  C8        INY 
$0875  8A        TXA 
$0876  8A        TXA 
$0877  8E A4 A4  STX $A4A4 
$087A  E4 A4     CPX $A4 
$087C  A4 A4     LDY $A4 
$087E  2A        ROL A 
//------------------------------
L_BRS_($087F)_($08BD) OK
//------------------------------
$087F  2A        ROL A 
$0880  2C 2A AA  BIT $AA2A 
$0883  EA        NOP 
$0884  8A        TXA 
$0885  8E 8E 8E  STX $8E8E 
$0888  8A        TXA 
$0889  EA        NOP 
$088A  EE AA AA  INC $AAAA 
$088D  AA        TAX 
$088E  AA        TAX 
$088F  AE EE AA  LDX $AAEE 
$0892  EA        NOP 
$0893  8A        TXA 
$0894  8C 82 EE  STY $EE82 
$0897  A8        TAY 
$0898  EE C2 A2  INC $A2C2 
$089B  AE EA 4A  LDX $4AEA 
$089E  4A        LSR A 
$089F  4A        LSR A 
$08A0  4A        LSR A 
$08A1  4E AA AA  LSR $AAAA 
$08A4  AE AE 4E  LDX $4EAE 
$08A7  4A        LSR A 
$08A8  AA        TAX 
$08A9  AA        TAX 
$08AA  4E 44 A4  LSR $A444 
$08AD  A4 E0     LDY $E0 
$08AF  20 40 40  JSR L_JSR_($4040)_($08AF) BAD
$08B2            .byte $80
$08B3  E0 04     CPX #$04
$08B5  08        PHP 
$08B6  10 20     BPL L_BRS_($08D8)_($08B6) OK
$08B8  40        RTI 
//------------------------------
$08B9  FE 00 02  INC $0200,X 
$08BC            .byte $0C
$08BD  30 C0     BMI L_BRS_($087F)_($08BD) OK
$08BF  FE 00 00  INC $0000,X 
$08C2  06 38     ASL $38 
$08C4  C0 FE     CPY #$FE
$08C6  41 7F     EOR ($7F,X) 
$08C8  41 00     EOR ($00,X) 
$08CA  41 22     EOR ($22,X) 
$08CC            .byte $22
$08CD  3E 22 00  ROL $0022,X 
$08D0            .byte $22,$14,$14,$1C,$14,$00,$14,$00
//------------------------------
L_BRS_($08D8)_($08B6) OK
//------------------------------
$08D8  3E 7E 50  ROL $507E,X 
$08DB  70 60     BVS L_BRS_($093D)_($08DB) BAD
$08DD  40        RTI 
//------------------------------
$08DE  08        PHP 
$08DF            .byte $1C
$08E0  2A        ROL A 
$08E1  49 8B     EOR #$8B
$08E3            .byte $FC
$08E4  18        CLC 
$08E5  10 3C     BPL L_BRS_($0923)_($08E5) BAD
$08E7  10 28     BPL L_BRS_($0911)_($08E7) OK
$08E9  24 00     BIT $00 
$08EB            .byte $00,$04,$3C
$08EE  28        PLP 
$08EF  68        PLA 
$08F0  56 00     LSR $00,X 
$08F2            .byte $04,$3C
$08F4  28        PLP 
$08F5  68        PLA 
$08F6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$08FE            .byte $00,$00,$00
//------------------------------
L_JMP_($0901)_($09E3) OK
L_JSR_($0901)_($5E39) OK
L_JSR_($0901)_($6C16) OK
//------------------------------
$0901  AD 00 09  LDA $0900 
$0904  D0 09     BNE L_BRS_($090F)_($0904) OK
$0906  8D 9A 14  STA $149A 
$0909  20 50 0E  JSR L_JSR_($0E50)_($0909) OK
//------------------------------
L_BRS_($090C)_($0953) OK
//------------------------------
$090C  4C 4A 0E  JMP L_JMP_($0E4A)_($090C) OK
//------------------------------
L_BRS_($090F)_($0904) OK
//------------------------------
$090F  C9 02     CMP #$02
//------------------------------
L_BRS_($0911)_($08E7) OK
//------------------------------
$0911  B0 3D     BCS L_BRS_($0950)_($0911) OK
$0913  E9 00     SBC #$00
$0915  0A        ASL A 
$0916  8D 1B 09  STA $091B 
$0919  0A        ASL A 
$091A  69 00     ADC #$00
//------------------------------
L_JSR_($091C)_($9DFC) OK
L_JSR_($091C)_($9F1D) OK
L_JSR_($091C)_($9FF6) OK
L_JSR_($091C)_($A25E) OK
L_JSR_($091C)_($A616) OK
L_JSR_($091C)_($A62E) OK
L_JSR_($091C)_($A70F) OK
L_JSR_($091C)_($A93C) OK
L_JSR_($091C)_($AB71) OK
L_JSR_($091C)_($ACCB) OK
L_JSR_($091C)_($AD37) OK
L_JSR_($091C)_($B381) OK
L_JSR_($091C)_($B45A) OK
L_JSR_($091C)_($B479) OK
L_JSR_($091C)_($B55A) OK
L_JSR_($091C)_($B5C7) OK
L_JSR_($091C)_($B669) OK
L_JSR_($091C)_($B6B8) OK
L_JSR_($091C)_($B93A) OK
L_JSR_($091C)_($BA41) OK
//------------------------------
$091C  A8        TAY 
$091D  A2 00     LDX #$00
//------------------------------
L_BRS_($091F)_($0930) OK
//------------------------------
$091F  B9 41 10  LDA $1041,Y 
//------------------------------
L_BRS_($0923)_($08E5) BAD
//------------------------------
$0922  9D E9 14  STA $14E9,X 
$0925  C8        INY 
$0926  B9 41 10  LDA $1041,Y 
$0929  9D EC 14  STA $14EC,X 
$092C  C8        INY 
$092D  E8        INX 
$092E  E0 03     CPX #$03
$0930  D0 ED     BNE L_BRS_($091F)_($0930) OK
$0932  A2 02     LDX #$02
//------------------------------
L_BRS_($0934)_($0943) OK
//------------------------------
$0934  A9 00     LDA #$00
$0936  9D B5 14  STA $14B5,X 
$0939  9D B8 14  STA $14B8,X 
//------------------------------
L_BRS_($093D)_($08DB) BAD
//------------------------------
$093C  9D 9D 14  STA $149D,X 
$093F  20 9B 0E  JSR L_JSR_($0E9B)_($093F) OK
$0942  CA        DEX 
$0943  10 EF     BPL L_BRS_($0934)_($0943) OK
$0945  20 21 10  JSR L_JSR_($1021)_($0945) OK
$0948  A9 01     LDA #$01
$094A  8D 9A 14  STA $149A 
$094D  4C 4A 0E  JMP L_JMP_($0E4A)_($094D) OK
//------------------------------
L_BRS_($0950)_($0911) OK
//------------------------------
$0950  AD 9A 14  LDA $149A 
$0953  F0 B7     BEQ L_BRS_($090C)_($0953) OK
$0955  EE F6 14  INC $14F6 
$0958  EE F7 14  INC $14F7 
$095B  EE F8 14  INC $14F8 
$095E  A2 02     LDX #$02
$0960  8E 99 14  STX $1499 
//------------------------------
L_JMP_($0963)_($0E3C) OK
//------------------------------
$0963  AE 99 14  LDX $1499 
$0966  BD 85 14  LDA $1485,X 
$0969  8D F9 14  STA $14F9 
$096C  AD 9C 14  LDA $149C 
$096F  D0 16     BNE L_BRS_($0987)_($096F) OK
$0971  DE B5 14  DEC $14B5,X 
$0974  30 25     BMI L_BRS_($099B)_($0974) OK
$0976  BD CA 14  LDA $14CA,X 
$0979  F0 1D     BEQ L_BRS_($0998)_($0979) OK
$097B  8D 7E 09  STA $097E 
$097E  FE 96 14  INC $1496,X 
$0981  20 5B 0E  JSR L_JSR_($0E5B)_($0981) OK
$0984  4C A4 0D  JMP L_JMP_($0DA4)_($0984) OK
//------------------------------
L_BRS_($0987)_($096F) OK
//------------------------------
$0987  BD CD 14  LDA $14CD,X 
$098A  F0 0C     BEQ L_BRS_($0998)_($098A) OK
$098C  DE CD 14  DEC $14CD,X 
$098F  DE 96 14  DEC $1496,X 
$0992  20 5B 0E  JSR L_JSR_($0E5B)_($0992) OK
$0995  4C A4 0D  JMP L_JMP_($0DA4)_($0995) OK
//------------------------------
L_BRS_($0998)_($0979) OK
L_BRS_($0998)_($098A) OK
//------------------------------
$0998  4C 7D 0B  JMP L_JMP_($0B7D)_($0998) OK
//------------------------------
L_BRS_($099B)_($0974) OK
//------------------------------
$099B  A9 00     LDA #$00
$099D  BC B8 14  LDY $14B8,X 
$09A0  C0 02     CPY #$02
$09A2  F0 06     BEQ L_BRS_($09AA)_($09A2) OK
$09A4  9D BB 14  STA $14BB,X 
$09A7  9D B8 14  STA $14B8,X 
//------------------------------
L_BRS_($09AA)_($09A2) OK
//------------------------------
$09AA  8D EF 14  STA $14EF 
$09AD  9D C1 14  STA $14C1,X 
$09B0  9D CA 14  STA $14CA,X 
$09B3  A9 03     LDA #$03
$09B5  9D F3 14  STA $14F3,X 
$09B8  BD AC 14  LDA $14AC,X 
$09BB  85 A7     STA $A7 
$09BD  BD AF 14  LDA $14AF,X 
$09C0  85 A8     STA $A8 
//------------------------------
L_JMP_($09C2)_($09D7) OK
L_BRS_($09C2)_($09F5) OK
L_BRS_($09C2)_($0A14) OK
//------------------------------
$09C2  AC EF 14  LDY $14EF 
$09C5  EE EF 14  INC $14EF 
$09C8  B1 A7     LDA ($A7),Y 
$09CA  C8        INY 
$09CB  C9 FF     CMP #$FF
$09CD  D0 0B     BNE L_BRS_($09DA)_($09CD) OK
$09CF  20 9B 0E  JSR L_JSR_($0E9B)_($09CF) OK
$09D2  A9 00     LDA #$00
$09D4  8D EF 14  STA $14EF 
$09D7  4C C2 09  JMP L_JMP_($09C2)_($09D7) OK
//------------------------------
L_BRS_($09DA)_($09CD) OK
//------------------------------
$09DA  C9 FE     CMP #$FE
$09DC  D0 08     BNE L_BRS_($09E6)_($09DC) OK
$09DE  A9 00     LDA #$00
$09E0  8D 00 09  STA $0900 
$09E3  4C 01 09  JMP L_JMP_($0901)_($09E3) OK
//------------------------------
L_BRS_($09E6)_($09DC) OK
//------------------------------
$09E6  C9 FD     CMP #$FD
$09E8  D0 0D     BNE L_BRS_($09F7)_($09E8) OK
$09EA  B1 A7     LDA ($A7),Y 
$09EC  C8        INY 
$09ED  8D 18 D4  STA $D418                          // Select Filter Mode and Volume
$09F0  B1 A7     LDA ($A7),Y 
$09F2  C8        INY 
$09F3  C9 FF     CMP #$FF
$09F5  F0 CB     BEQ L_BRS_($09C2)_($09F5) OK
//------------------------------
L_BRS_($09F7)_($09E8) OK
//------------------------------
$09F7  C9 F0     CMP #$F0
$09F9  90 08     BCC L_BRS_($0A03)_($09F9) OK
$09FB  29 0F     AND #$0F
$09FD  8D 9B 14  STA $149B 
$0A00  B1 A7     LDA ($A7),Y 
$0A02  C8        INY 
//------------------------------
L_BRS_($0A03)_($09F9) OK
//------------------------------
$0A03  C9 C0     CMP #$C0
$0A05  90 0F     BCC L_BRS_($0A16)_($0A05) OK
$0A07  29 1F     AND #$1F
$0A09  0A        ASL A 
$0A0A  0A        ASL A 
$0A0B  0A        ASL A 
$0A0C  9D F0 14  STA $14F0,X 
$0A0F  B1 A7     LDA ($A7),Y 
//------------------------------
L_JSR_($0A11)_($B844) OK
//------------------------------
$0A11  C8        INY 
$0A12  C9 FF     CMP #$FF
$0A14  F0 AC     BEQ L_BRS_($09C2)_($0A14) OK
//------------------------------
L_BRS_($0A16)_($0A05) OK
//------------------------------
$0A16  C9 80     CMP #$80
$0A18  90 08     BCC L_BRS_($0A22)_($0A18) OK
$0A1A  29 3F     AND #$3F
$0A1C  9D B2 14  STA $14B2,X 
$0A1F  B1 A7     LDA ($A7),Y 
$0A21  C8        INY 
//------------------------------
L_BRS_($0A22)_($0A18) OK
//------------------------------
$0A22  C9 60     CMP #$60
$0A24  90 0F     BCC L_BRS_($0A35)_($0A24) OK
$0A26  C9 7F     CMP #$7F
$0A28  D0 0E     BNE L_BRS_($0A38)_($0A28) OK
$0A2A  A9 DE     LDA #$DE
//------------------------------
L_JMP_($0A2C)_($0A3E) OK
//------------------------------
$0A2C  9D CA 14  STA $14CA,X 
$0A2F  9D B8 14  STA $14B8,X 
//------------------------------
L_JMP_($0A32)_($0A50) OK
L_JMP_($0A32)_($0A7A) OK
//------------------------------
$0A32  B1 A7     LDA ($A7),Y 
$0A34  C8        INY 
//------------------------------
L_BRS_($0A35)_($0A24) OK
//------------------------------
$0A35  4C 8A 0A  JMP L_JMP_($0A8A)_($0A35) OK
//------------------------------
L_BRS_($0A38)_($0A28) OK
//------------------------------
$0A38  C9 7E     CMP #$7E
$0A3A  D0 05     BNE L_BRS_($0A41)_($0A3A) OK
$0A3C  A9 FE     LDA #$FE
$0A3E  4C 2C 0A  JMP L_JMP_($0A2C)_($0A3E) OK
//------------------------------
L_BRS_($0A41)_($0A3A) OK
//------------------------------
$0A41  C9 7D     CMP #$7D
$0A43  D0 0E     BNE L_BRS_($0A53)_($0A43) OK
$0A45  A9 01     LDA #$01
//------------------------------
L_JMP_($0A47)_($0A59) OK
//------------------------------
$0A47  9D B8 14  STA $14B8,X 
$0A4A  B1 A7     LDA ($A7),Y 
$0A4C  C8        INY 
$0A4D  9D BB 14  STA $14BB,X 
$0A50  4C 32 0A  JMP L_JMP_($0A32)_($0A50) OK
//------------------------------
L_BRS_($0A53)_($0A43) OK
//------------------------------
$0A53  C9 7C     CMP #$7C
$0A55  D0 05     BNE L_BRS_($0A5C)_($0A55) OK
$0A57  A9 02     LDA #$02
$0A59  4C 47 0A  JMP L_JMP_($0A47)_($0A59) OK
//------------------------------
L_BRS_($0A5C)_($0A55) OK
//------------------------------
$0A5C  C9 7B     CMP #$7B
$0A5E  D0 1D     BNE L_BRS_($0A7D)_($0A5E) OK
$0A60  A9 00     LDA #$00
$0A62  9D BB 14  STA $14BB,X 
$0A65  A9 01     LDA #$01
$0A67  9D B8 14  STA $14B8,X 
$0A6A  B1 A7     LDA ($A7),Y 
$0A6C  C8        INY 
$0A6D  18        CLC 
$0A6E  7D BE 14  ADC $14BE,X 
$0A71  9D C1 14  STA $14C1,X 
$0A74  B1 A7     LDA ($A7),Y 
$0A76  C8        INY 
$0A77  9D C4 14  STA $14C4,X 
$0A7A  4C 32 0A  JMP L_JMP_($0A32)_($0A7A) OK
//------------------------------
L_BRS_($0A7D)_($0A5E) OK
//------------------------------
$0A7D  C9 7A     CMP #$7A
$0A7F  D0 09     BNE L_BRS_($0A8A)_($0A7F) OK
$0A81  B1 A7     LDA ($A7),Y 
$0A83  C8        INY 
$0A84  9D DE 14  STA $14DE,X 
$0A87  B1 A7     LDA ($A7),Y 
$0A89  C8        INY 
//------------------------------
L_JMP_($0A8A)_($0A35) OK
L_BRS_($0A8A)_($0A7F) OK
//------------------------------
$0A8A  8C EF 14  STY $14EF 
$0A8D  18        CLC 
$0A8E  7D BE 14  ADC $14BE,X 
$0A91  9D 96 14  STA $1496,X 
$0A94  48        PHA 
$0A95  BC F0 14  LDY $14F0,X 
$0A98  A9 00     LDA #$00
$0A9A  9D FD 14  STA $14FD,X 
$0A9D  A9 FF     LDA #$FF
$0A9F  9D F6 14  STA $14F6,X 
$0AA2  B9 4A 10  LDA $104A,Y 
$0AA5  8D E4 0A  STA $0AE4 
$0AA8  68        PLA 
$0AA9  F0 30     BEQ L_BRS_($0ADB)_($0AA9) OK
$0AAB  BD BB 14  LDA $14BB,X 
$0AAE  D0 08     BNE L_BRS_($0AB8)_($0AAE) OK
$0AB0  B9 4D 10  LDA $104D,Y 
$0AB3  F0 03     BEQ L_BRS_($0AB8)_($0AB3) OK
$0AB5  9D BB 14  STA $14BB,X 
//------------------------------
L_BRS_($0AB8)_($0AAE) OK
L_BRS_($0AB8)_($0AB3) OK
//------------------------------
$0AB8  B9 4E 10  LDA $104E,Y 
$0ABB  29 80     AND #$80
$0ABD  F0 07     BEQ L_BRS_($0AC6)_($0ABD) OK
$0ABF  A9 01     LDA #$01
$0AC1  9D FA 14  STA $14FA,X 
$0AC4  D0 05     BNE L_BRS_($0ACB)_($0AC4) OK
//------------------------------
L_BRS_($0AC6)_($0ABD) OK
//------------------------------
$0AC6  A9 00     LDA #$00
$0AC8  9D FA 14  STA $14FA,X 
//------------------------------
L_BRS_($0ACB)_($0AC4) OK
//------------------------------
$0ACB  B9 4E 10  LDA $104E,Y 
$0ACE  29 02     AND #$02
$0AD0  F0 09     BEQ L_BRS_($0ADB)_($0AD0) OK
$0AD2  9D CD 14  STA $14CD,X 
$0AD5  FE 96 14  INC $1496,X 
$0AD8  FE 96 14  INC $1496,X 
//------------------------------
L_BRS_($0ADB)_($0AA9) OK
L_BRS_($0ADB)_($0AD0) OK
//------------------------------
$0ADB  20 5B 0E  JSR L_JSR_($0E5B)_($0ADB) OK
$0ADE  BD FA 14  LDA $14FA,X 
$0AE1  D0 1A     BNE L_BRS_($0AFD)_($0AE1) OK
$0AE3  A9 00     LDA #$00
$0AE5  8D 16 D4  STA $D416                          // Filter Cutoff Frequency: High-Byte
$0AE8  AC F9 14  LDY $14F9 
$0AEB  48        PHA 
$0AEC  29 F0     AND #$F0
$0AEE  9D A6 14  STA $14A6,X 
$0AF1  99 02 D4  STA $D402,Y                          // Voice 1: Pulse Waveform Width - Low-Byte
$0AF4  68        PLA 
$0AF5  29 0F     AND #$0F
$0AF7  9D A9 14  STA $14A9,X 
$0AFA  99 03 D4  STA $D403,Y                          // Voice 1: Pulse Waveform Width - High-Nybble
//------------------------------
L_BRS_($0AFD)_($0AE1) OK
//------------------------------
$0AFD  BD 93 14  LDA $1493,X 
$0B00  F0 37     BEQ L_BRS_($0B39)_($0B00) OK
$0B02  BD F0 14  LDA $14F0,X 
$0B05  AA        TAX 
$0B06  BD 48 10  LDA $1048,X 
$0B09  99 05 D4  STA $D405,Y                          // Voice 1: Attack / Decay Cycle Control
$0B0C  BD 49 10  LDA $1049,X 
$0B0F  99 06 D4  STA $D406,Y                          // Voice 1: Sustain / Release Cycle Control
$0B12  29 0F     AND #$0F
$0B14  C9 0F     CMP #$0F
$0B16  D0 0A     BNE L_BRS_($0B22)_($0B16) OK
$0B18  A9 01     LDA #$01
$0B1A  AE 99 14  LDX $1499 
$0B1D  9D 00 15  STA $1500,X 
$0B20  D0 08     BNE L_BRS_($0B2A)_($0B20) OK
//------------------------------
L_BRS_($0B22)_($0B16) OK
//------------------------------
$0B22  A9 00     LDA #$00
$0B24  AE 99 14  LDX $1499 
$0B27  9D 00 15  STA $1500,X 
//------------------------------
L_BRS_($0B2A)_($0B20) OK
//------------------------------
$0B2A  BD F0 14  LDA $14F0,X 
$0B2D  AA        TAX 
$0B2E  A9 00     LDA #$00
$0B30  99 04 D4  STA $D404,Y                          // Voice 1: Control Register
$0B33  BD 47 10  LDA $1047,X 
$0B36  99 04 D4  STA $D404,Y                          // Voice 1: Control Register
//------------------------------
L_BRS_($0B39)_($0B00) OK
//------------------------------
$0B39  AE 99 14  LDX $1499 
$0B3C  BD AC 14  LDA $14AC,X 
$0B3F  18        CLC 
$0B40  6D EF 14  ADC $14EF 
$0B43  9D AC 14  STA $14AC,X 
$0B46  90 03     BCC L_BRS_($0B4B)_($0B46) OK
$0B48  FE AF 14  INC $14AF,X 
//------------------------------
L_BRS_($0B4B)_($0B46) OK
//------------------------------
$0B4B  BD B2 14  LDA $14B2,X 
$0B4E  9D B5 14  STA $14B5,X 
$0B51  BD DE 14  LDA $14DE,X 
$0B54  9D E1 14  STA $14E1,X 
$0B57  BC 88 14  LDY $1488,X 
$0B5A  C8        INY 
$0B5B  98        TYA 
$0B5C  9D D3 14  STA $14D3,X 
$0B5F  4C A4 0D  JMP L_JMP_($0DA4)_($0B5F) OK
$0B62  28        PLP 
$0B63            .byte $43
$0B64  29 D7     AND #$D7
$0B66  41 4C     EOR ($4C,X) 
$0B68  4C 59 20  JMP L_JMP_($2059)_($0B68) OK
$0B6B            .byte $5B
$0B6C  C8        INY 
$0B6D  C1 C7     CMP ($C7,X) 
$0B6F  C1 D2     CMP ($D2,X) 
$0B71  5D 20 C2  EOR $C220,X 
$0B74  45 42     EOR $42 
$0B76  45 4E     EOR $4E 
$0B78  20 31 39  JSR L_JSR_($3931)_($0B78) BAD
$0B7B  38        SEC 
$0B7C  38        SEC 
//------------------------------
L_JMP_($0B7D)_($0998) OK
//------------------------------
$0B7D  BD 96 14  LDA $1496,X 
$0B80  F0 0D     BEQ L_BRS_($0B8F)_($0B80) OK
$0B82  BC F0 14  LDY $14F0,X 
$0B85  B9 4E 10  LDA $104E,Y 
$0B88  29 08     AND #$08
$0B8A  F0 06     BEQ L_BRS_($0B92)_($0B8A) OK
$0B8C  4C 13 0C  JMP L_JMP_($0C13)_($0B8C) OK
//------------------------------
L_BRS_($0B8F)_($0B80) OK
//------------------------------
$0B8F  4C A4 0D  JMP L_JMP_($0DA4)_($0B8F) OK
//------------------------------
L_BRS_($0B92)_($0B8A) OK
//------------------------------
$0B92  BC F0 14  LDY $14F0,X 
$0B95  B9 4E 10  LDA $104E,Y 
$0B98  AC F9 14  LDY $14F9 
$0B9B  29 01     AND #$01
$0B9D  F0 71     BEQ L_BRS_($0C10)_($0B9D) OK
$0B9F  BC F0 14  LDY $14F0,X 
$0BA2  B9 4B 10  LDA $104B,Y 
$0BA5  29 0F     AND #$0F
$0BA7  0A        ASL A 
$0BA8  0A        ASL A 
$0BA9  A8        TAY 
$0BAA  B9 81 14  LDA $1481,Y 
$0BAD  8D CC 0B  STA $0BCC 
$0BB0  B9 82 14  LDA $1482,Y 
$0BB3  8D CD 0B  STA $0BCD 
$0BB6  B9 83 14  LDA $1483,Y 
$0BB9  8D D7 0B  STA $0BD7 
$0BBC  B9 84 14  LDA $1484,Y 
$0BBF  8D D8 0B  STA $0BD8 
$0BC2  BD F6 14  LDA $14F6,X 
$0BC5  C9 0F     CMP #$0F
$0BC7  B0 47     BCS L_BRS_($0C10)_($0BC7) OK
$0BC9  48        PHA 
$0BCA  A8        TAY 
$0BCB  B9 85 14  LDA $1485,Y 
$0BCE  AC F9 14  LDY $14F9 
$0BD1  99 04 D4  STA $D404,Y                          // Voice 1: Control Register
$0BD4  68        PLA 
$0BD5  A8        TAY 
$0BD6  B9 85 14  LDA $1485,Y 
$0BD9  48        PHA 
$0BDA  BC F0 14  LDY $14F0,X 
$0BDD  B9 4B 10  LDA $104B,Y 
$0BE0  29 10     AND #$10
$0BE2  D0 12     BNE L_BRS_($0BF6)_($0BE2) OK
$0BE4  68        PLA 
$0BE5  AC F9 14  LDY $14F9 
$0BE8  18        CLC 
$0BE9  69 0D     ADC #$0D
$0BEB  99 01 D4  STA $D401,Y                          // Voice 1: Frequency Control - High-Byte
$0BEE  A9 00     LDA #$00
$0BF0  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0BF3  4C A4 0D  JMP L_JMP_($0DA4)_($0BF3) OK
//------------------------------
L_BRS_($0BF6)_($0BE2) OK
//------------------------------
$0BF6  68        PLA 
$0BF7  18        CLC 
$0BF8  7D 96 14  ADC $1496,X 
$0BFB  A8        TAY 
$0BFC  B9 BE 0F  LDA $0FBE,Y 
$0BFF  48        PHA 
$0C00  B9 5F 0F  LDA $0F5F,Y 
$0C03  AC F9 14  LDY $14F9 
$0C06  99 01 D4  STA $D401,Y                          // Voice 1: Frequency Control - High-Byte
$0C09  68        PLA 
$0C0A  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0C0D  4C A4 0D  JMP L_JMP_($0DA4)_($0C0D) OK
//------------------------------
L_BRS_($0C10)_($0B9D) OK
L_BRS_($0C10)_($0BC7) OK
L_BRS_($0C10)_($0C19) OK
//------------------------------
$0C10  4C 4B 0C  JMP L_JMP_($0C4B)_($0C10) OK
//------------------------------
L_JMP_($0C13)_($0B8C) OK
//------------------------------
$0C13  BC F0 14  LDY $14F0,X 
$0C16  BD FD 14  LDA $14FD,X 
$0C19  D0 F5     BNE L_BRS_($0C10)_($0C19) OK
$0C1B  BD F6 14  LDA $14F6,X 
$0C1E  C9 01     CMP #$01
$0C20  B0 12     BCS L_BRS_($0C34)_($0C20) OK
$0C22  A9 48     LDA #$48
$0C24  AC F9 14  LDY $14F9 
$0C27  99 01 D4  STA $D401,Y                          // Voice 1: Frequency Control - High-Byte
$0C2A  A9 00     LDA #$00
$0C2C  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0C2F  A9 81     LDA #$81
$0C31  4C 42 0C  JMP L_JMP_($0C42)_($0C31) OK
//------------------------------
L_BRS_($0C34)_($0C20) OK
//------------------------------
$0C34  20 5B 0E  JSR L_JSR_($0E5B)_($0C34) OK
$0C37  A9 01     LDA #$01
$0C39  9D FD 14  STA $14FD,X 
$0C3C  BC F0 14  LDY $14F0,X 
$0C3F  B9 47 10  LDA $1047,Y 
//------------------------------
L_JMP_($0C42)_($0C31) OK
//------------------------------
$0C42  AC F9 14  LDY $14F9 
$0C45  99 04 D4  STA $D404,Y                          // Voice 1: Control Register
$0C48  4C A4 0D  JMP L_JMP_($0DA4)_($0C48) OK
//------------------------------
L_JMP_($0C4B)_($0C10) OK
//------------------------------
$0C4B  BD B8 14  LDA $14B8,X 
$0C4E  D0 0B     BNE L_BRS_($0C5B)_($0C4E) OK
$0C50  BC F0 14  LDY $14F0,X 
$0C53  B9 4B 10  LDA $104B,Y 
$0C56  D0 06     BNE L_BRS_($0C5E)_($0C56) OK
$0C58  9D 03 15  STA $1503,X 
//------------------------------
L_BRS_($0C5B)_($0C4E) OK
//------------------------------
$0C5B  4C 13 0D  JMP L_JMP_($0D13)_($0C5B) OK
//------------------------------
L_BRS_($0C5E)_($0C56) OK
L_JMP_($0C5E)_($0DA1) OK
//------------------------------
$0C5E  9D 03 15  STA $1503,X 
$0C61  48        PHA 
$0C62  29 0F     AND #$0F
$0C64  8D D7 14  STA $14D7 
$0C67  68        PLA 
$0C68  4A        LSR A 
$0C69  4A        LSR A 
$0C6A  4A        LSR A 
$0C6B  4A        LSR A 
$0C6C  8D D6 14  STA $14D6 
$0C6F  BC 96 14  LDY $1496,X 
$0C72  B9 BF 0F  LDA $0FBF,Y 
$0C75  38        SEC 
$0C76  F9 BE 0F  SBC $0FBE,Y 
$0C79  8D E6 14  STA $14E6 
$0C7C  B9 60 0F  LDA $0F60,Y 
$0C7F  F9 5F 0F  SBC $0F5F,Y 
$0C82  8D E7 14  STA $14E7 
//------------------------------
L_JMP_($0C85)_($0C90) OK
//------------------------------
$0C85  CE D7 14  DEC $14D7 
$0C88  30 09     BMI L_BRS_($0C93)_($0C88) OK
$0C8A  4E E7 14  LSR $14E7 
$0C8D  6E E6 14  ROR $14E6 
$0C90  4C 85 0C  JMP L_JMP_($0C85)_($0C90) OK
//------------------------------
L_BRS_($0C93)_($0C88) OK
//------------------------------
$0C93  BD D8 14  LDA $14D8,X 
$0C96  10 0A     BPL L_BRS_($0CA2)_($0C96) OK
$0C98  DE DB 14  DEC $14DB,X 
$0C9B  D0 13     BNE L_BRS_($0CB0)_($0C9B) OK
$0C9D  FE D8 14  INC $14D8,X 
$0CA0  10 0E     BPL L_BRS_($0CB0)_($0CA0) OK
//------------------------------
L_BRS_($0CA2)_($0C96) OK
//------------------------------
$0CA2  FE DB 14  INC $14DB,X 
$0CA5  BD DB 14  LDA $14DB,X 
$0CA8  CD D6 14  CMP $14D6 
$0CAB  90 03     BCC L_BRS_($0CB0)_($0CAB) OK
$0CAD  DE D8 14  DEC $14D8,X 
//------------------------------
L_BRS_($0CB0)_($0C9B) OK
L_BRS_($0CB0)_($0CA0) OK
L_BRS_($0CB0)_($0CAB) OK
//------------------------------
$0CB0  BD E1 14  LDA $14E1,X 
$0CB3  F0 06     BEQ L_BRS_($0CBB)_($0CB3) OK
$0CB5  DE E1 14  DEC $14E1,X 
$0CB8  4C A4 0D  JMP L_JMP_($0DA4)_($0CB8) OK
//------------------------------
L_BRS_($0CBB)_($0CB3) OK
//------------------------------
$0CBB  BD A0 14  LDA $14A0,X 
$0CBE  8D E4 14  STA $14E4 
$0CC1  BD A3 14  LDA $14A3,X 
$0CC4  8D E5 14  STA $14E5 
$0CC7  AD D6 14  LDA $14D6 
$0CCA  4A        LSR A 
$0CCB  A8        TAY 
//------------------------------
L_JMP_($0CCC)_($0CE2) OK
//------------------------------
$0CCC  88        DEY 
$0CCD  30 16     BMI L_BRS_($0CE5)_($0CCD) OK
$0CCF  AD E4 14  LDA $14E4 
$0CD2  38        SEC 
$0CD3  ED E6 14  SBC $14E6 
$0CD6  8D E4 14  STA $14E4 
$0CD9  AD E5 14  LDA $14E5 
$0CDC  ED E7 14  SBC $14E7 
$0CDF  8D E5 14  STA $14E5 
$0CE2  4C CC 0C  JMP L_JMP_($0CCC)_($0CE2) OK
//------------------------------
L_BRS_($0CE5)_($0CCD) OK
//------------------------------
$0CE5  BC DB 14  LDY $14DB,X 
//------------------------------
L_JMP_($0CE8)_($0CFE) OK
//------------------------------
$0CE8  88        DEY 
$0CE9  30 16     BMI L_BRS_($0D01)_($0CE9) OK
$0CEB  AD E4 14  LDA $14E4 
$0CEE  18        CLC 
$0CEF  6D E6 14  ADC $14E6 
$0CF2  8D E4 14  STA $14E4 
$0CF5  AD E5 14  LDA $14E5 
$0CF8  6D E7 14  ADC $14E7 
$0CFB  8D E5 14  STA $14E5 
//------------------------------
L_JSR_($0D00)_($9745) BAD
//------------------------------
$0CFE  4C E8 0C  JMP L_JMP_($0CE8)_($0CFE) OK
//------------------------------
L_BRS_($0D01)_($0CE9) OK
//------------------------------
$0D01  AC F9 14  LDY $14F9 
$0D04  AD E4 14  LDA $14E4 
$0D07  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0D0A  AD E5 14  LDA $14E5 
$0D0D  99 01 D4  STA $D401,Y                          // Voice 1: Frequency Control - High-Byte
$0D10  4C A4 0D  JMP L_JMP_($0DA4)_($0D10) OK
//------------------------------
L_JMP_($0D13)_($0C5B) OK
//------------------------------
$0D13  BD BB 14  LDA $14BB,X 
$0D16  F0 36     BEQ L_BRS_($0D4E)_($0D16) OK
$0D18  8D E8 14  STA $14E8 
$0D1B  20 76 0E  JSR L_JSR_($0E76)_($0D1B) OK
//------------------------------
L_JMP_($0D1E)_($0D2E) OK
//------------------------------
$0D1E  BC D3 14  LDY $14D3,X 
$0D21  B9 06 15  LDA $1506,Y 
$0D24  C9 FF     CMP #$FF
$0D26  D0 09     BNE L_BRS_($0D31)_($0D26) OK
$0D28  BD 88 14  LDA $1488,X 
$0D2B  9D D3 14  STA $14D3,X 
$0D2E  4C 1E 0D  JMP L_JMP_($0D1E)_($0D2E) OK
//------------------------------
L_BRS_($0D31)_($0D26) OK
//------------------------------
$0D31  18        CLC 
$0D32  7D 96 14  ADC $1496,X 
$0D35  AC F9 14  LDY $14F9 
$0D38  AA        TAX 
$0D39  BD BE 0F  LDA $0FBE,X 
$0D3C  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0D3F  BD 5F 0F  LDA $0F5F,X 
$0D42  99 01 D4  STA $D401,Y                          // Voice 1: Frequency Control - High-Byte
$0D45  AE 99 14  LDX $1499 
$0D48  FE D3 14  INC $14D3,X 
$0D4B  4C A4 0D  JMP L_JMP_($0DA4)_($0D4B) OK
//------------------------------
L_BRS_($0D4E)_($0D16) OK
//------------------------------
$0D4E  BD C1 14  LDA $14C1,X 
$0D51  F0 51     BEQ L_BRS_($0DA4)_($0D51) OK
$0D53  8D D9 0E  STA $0ED9 
$0D56  BD C4 14  LDA $14C4,X 
$0D59  48        PHA 
$0D5A  29 0F     AND #$0F
$0D5C  8D 71 0D  STA $0D71 
$0D5F  8D 29 0F  STA $0F29 
$0D62  68        PLA 
$0D63  4A        LSR A 
$0D64  4A        LSR A 
$0D65  4A        LSR A 
$0D66  4A        LSR A 
$0D67  18        CLC 
$0D68  7D B5 14  ADC $14B5,X 
$0D6B  DD B2 14  CMP $14B2,X 
$0D6E  B0 2C     BCS L_BRS_($0D9C)_($0D6E) OK
$0D70  69 00     ADC #$00
$0D72  DD B2 14  CMP $14B2,X 
$0D75  90 25     BCC L_BRS_($0D9C)_($0D75) OK
$0D77  BC 96 14  LDY $1496,X 
$0D7A  20 D8 0E  JSR L_JSR_($0ED8)_($0D7A) OK
$0D7D  AE 99 14  LDX $1499 
$0D80  AC F9 14  LDY $14F9 
$0D83  BD A0 14  LDA $14A0,X 
$0D86  18        CLC 
$0D87  6D C7 14  ADC $14C7 
$0D8A  9D A0 14  STA $14A0,X 
$0D8D  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0D90  BD A3 14  LDA $14A3,X 
$0D93  6D C8 14  ADC $14C8 
$0D96  9D A3 14  STA $14A3,X 
$0D99  99 01 D4  STA $D401,Y                          // Voice 1: Frequency Control - High-Byte
//------------------------------
L_BRS_($0D9C)_($0D6E) OK
L_BRS_($0D9C)_($0D75) OK
//------------------------------
$0D9C  BD 03 15  LDA $1503,X 
$0D9F  F0 03     BEQ L_BRS_($0DA4)_($0D9F) OK
$0DA1  4C 5E 0C  JMP L_JMP_($0C5E)_($0DA1) OK
//------------------------------
L_JMP_($0DA4)_($0984) OK
L_JMP_($0DA4)_($0995) OK
L_JMP_($0DA4)_($0B5F) OK
L_JMP_($0DA4)_($0B8F) OK
L_JMP_($0DA4)_($0BF3) OK
L_JMP_($0DA4)_($0C0D) OK
L_JMP_($0DA4)_($0C48) OK
L_JMP_($0DA4)_($0CB8) OK
L_JMP_($0DA4)_($0D10) OK
L_JMP_($0DA4)_($0D4B) OK
L_BRS_($0DA4)_($0D51) OK
L_BRS_($0DA4)_($0D9F) OK
//------------------------------
$0DA4  BD B2 14  LDA $14B2,X 
$0DA7  F0 1C     BEQ L_BRS_($0DC5)_($0DA7) OK
$0DA9  BD 00 15  LDA $1500,X 
$0DAC  D0 17     BNE L_BRS_($0DC5)_($0DAC) OK
$0DAE  BD B2 14  LDA $14B2,X 
$0DB1  4A        LSR A 
$0DB2  DD B5 14  CMP $14B5,X 
$0DB5  D0 0E     BNE L_BRS_($0DC5)_($0DB5) OK
$0DB7  BC F0 14  LDY $14F0,X 
$0DBA  B9 47 10  LDA $1047,Y 
$0DBD  AC F9 14  LDY $14F9 
$0DC0  29 FE     AND #$FE
$0DC2  99 04 D4  STA $D404,Y                          // Voice 1: Control Register
//------------------------------
L_BRS_($0DC5)_($0DA7) OK
L_BRS_($0DC5)_($0DAC) OK
L_BRS_($0DC5)_($0DB5) OK
//------------------------------
$0DC5  BC F0 14  LDY $14F0,X 
$0DC8  B9 4C 10  LDA $104C,Y 
$0DCB  F0 6A     BEQ L_BRS_($0E37)_($0DCB) OK
$0DCD  B9 4E 10  LDA $104E,Y 
$0DD0  29 04     AND #$04
$0DD2  F0 16     BEQ L_BRS_($0DEA)_($0DD2) OK
$0DD4  BD A6 14  LDA $14A6,X 
$0DD7  18        CLC 
$0DD8  79 4C 10  ADC $104C,Y 
$0DDB  9D A6 14  STA $14A6,X 
$0DDE  AC F9 14  LDY $14F9 
$0DE1  99 02 D4  STA $D402,Y                          // Voice 1: Pulse Waveform Width - Low-Byte
$0DE4  8D 15 D4  STA $D415                          // Filter Cutoff Frequency: Low-Nybble
$0DE7  4C 37 0E  JMP L_JMP_($0E37)_($0DE7) OK
//------------------------------
L_BRS_($0DEA)_($0DD2) OK
//------------------------------
$0DEA  BD D0 14  LDA $14D0,X 
$0DED  D0 20     BNE L_BRS_($0E0F)_($0DED) OK
$0DEF  BD A6 14  LDA $14A6,X 
$0DF2  18        CLC 
$0DF3  79 4C 10  ADC $104C,Y 
$0DF6  48        PHA 
$0DF7  9D A6 14  STA $14A6,X 
$0DFA  BD A9 14  LDA $14A9,X 
$0DFD  69 00     ADC #$00
$0DFF  9D A9 14  STA $14A9,X 
$0E02  48        PHA 
$0E03  C9 0F     CMP #$0F
$0E05  90 25     BCC L_BRS_($0E2C)_($0E05) OK
$0E07  A9 01     LDA #$01
$0E09  9D D0 14  STA $14D0,X 
$0E0C  4C 2C 0E  JMP L_JMP_($0E2C)_($0E0C) OK
//------------------------------
L_BRS_($0E0F)_($0DED) OK
//------------------------------
$0E0F  BD A6 14  LDA $14A6,X 
$0E12  38        SEC 
$0E13  F9 4C 10  SBC $104C,Y 
$0E16  48        PHA 
$0E17  9D A6 14  STA $14A6,X 
$0E1A  BD A9 14  LDA $14A9,X 
$0E1D  E9 00     SBC #$00
$0E1F  9D A9 14  STA $14A9,X 
$0E22  48        PHA 
$0E23  C9 08     CMP #$08
$0E25  B0 05     BCS L_BRS_($0E2C)_($0E25) OK
$0E27  A9 00     LDA #$00
$0E29  9D D0 14  STA $14D0,X 
//------------------------------
L_BRS_($0E2C)_($0E05) OK
L_JMP_($0E2C)_($0E0C) OK
L_BRS_($0E2C)_($0E25) OK
//------------------------------
$0E2C  AC F9 14  LDY $14F9 
$0E2F  68        PLA 
$0E30  99 03 D4  STA $D403,Y                          // Voice 1: Pulse Waveform Width - High-Nybble
$0E33  68        PLA 
$0E34  99 02 D4  STA $D402,Y                          // Voice 1: Pulse Waveform Width - Low-Byte
//------------------------------
L_BRS_($0E37)_($0DCB) OK
L_JMP_($0E37)_($0DE7) OK
//------------------------------
$0E37  CE 99 14  DEC $1499 
$0E3A  30 03     BMI L_BRS_($0E3F)_($0E3A) OK
$0E3C  4C 63 09  JMP L_JMP_($0963)_($0E3C) OK
//------------------------------
L_BRS_($0E3F)_($0E3A) OK
//------------------------------
$0E3F  CE 9C 14  DEC $149C 
$0E42  10 06     BPL L_BRS_($0E4A)_($0E42) OK
$0E44  AD 9B 14  LDA $149B 
$0E47  8D 9C 14  STA $149C 
//------------------------------
L_JMP_($0E4A)_($090C) OK
L_JMP_($0E4A)_($094D) OK
L_BRS_($0E4A)_($0E42) OK
//------------------------------
$0E4A  A9 FF     LDA #$FF
$0E4C  8D 00 09  STA $0900 
$0E4F  60        RTS 
//------------------------------
L_JSR_($0E50)_($0909) OK
L_JSR_($0E50)_($1021) OK
//------------------------------
$0E50  A0 18     LDY #$18
$0E52  A9 00     LDA #$00
//------------------------------
L_BRS_($0E54)_($0E58) OK
//------------------------------
$0E54  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0E57  88        DEY 
$0E58  10 FA     BPL L_BRS_($0E54)_($0E58) OK
$0E5A  60        RTS 
//------------------------------
L_JSR_($0E5B)_($0981) OK
L_JSR_($0E5B)_($0992) OK
L_JSR_($0E5B)_($0ADB) OK
L_JSR_($0E5B)_($0C34) OK
//------------------------------
$0E5B  BC 96 14  LDY $1496,X 
$0E5E  B9 BE 0F  LDA $0FBE,Y 
$0E61  9D A0 14  STA $14A0,X 
$0E64  48        PHA 
$0E65  B9 5F 0F  LDA $0F5F,Y 
$0E68  9D A3 14  STA $14A3,X 
$0E6B  AC F9 14  LDY $14F9 
$0E6E  99 01 D4  STA $D401,Y                          // Voice 1: Frequency Control - High-Byte
$0E71  68        PLA 
$0E72  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$0E75  60        RTS 
//------------------------------
L_JSR_($0E76)_($0D1B) OK
//------------------------------
$0E76  BC 88 14  LDY $1488,X 
$0E79  C8        INY 
$0E7A  A2 00     LDX #$00
//------------------------------
L_BRS_($0E7C)_($0E8B) OK
//------------------------------
$0E7C  6E E8 14  ROR $14E8 
$0E7F  90 07     BCC L_BRS_($0E88)_($0E7F) OK
$0E81  BD 8B 14  LDA $148B,X 
$0E84  99 06 15  STA $1506,Y 
$0E87  C8        INY 
//------------------------------
L_BRS_($0E88)_($0E7F) OK
//------------------------------
$0E88  E8        INX 
$0E89  E0 08     CPX #$08
$0E8B  D0 EF     BNE L_BRS_($0E7C)_($0E8B) OK
$0E8D  AE 99 14  LDX $1499 
$0E90  A9 FF     LDA #$FF
$0E92  99 06 15  STA $1506,Y 
$0E95  A9 00     LDA #$00
$0E97  9D C1 14  STA $14C1,X 
$0E9A  60        RTS 
//------------------------------
L_JSR_($0E9B)_($093F) OK
L_JSR_($0E9B)_($09CF) OK
//------------------------------
$0E9B  BD E9 14  LDA $14E9,X 
$0E9E  85 A9     STA $A9 
$0EA0  BD EC 14  LDA $14EC,X 
$0EA3  85 AA     STA $AA 
//------------------------------
L_JMP_($0EA5)_($0EBA) OK
L_JMP_($0EA5)_($0EC3) OK
//------------------------------
$0EA5  BC 9D 14  LDY $149D,X 
$0EA8  FE 9D 14  INC $149D,X 
$0EAB  B1 A9     LDA ($A9),Y 
$0EAD  C9 C0     CMP #$C0
$0EAF  90 15     BCC L_BRS_($0EC6)_($0EAF) OK
$0EB1  C9 FF     CMP #$FF
$0EB3  D0 08     BNE L_BRS_($0EBD)_($0EB3) OK
$0EB5  A9 00     LDA #$00
$0EB7  9D 9D 14  STA $149D,X 
$0EBA  4C A5 0E  JMP L_JMP_($0EA5)_($0EBA) OK
//------------------------------
L_BRS_($0EBD)_($0EB3) OK
//------------------------------
$0EBD  18        CLC 
$0EBE  69 20     ADC #$20
$0EC0  9D BE 14  STA $14BE,X 
$0EC3  4C A5 0E  JMP L_JMP_($0EA5)_($0EC3) OK
//------------------------------
L_BRS_($0EC6)_($0EAF) OK
//------------------------------
$0EC6  A8        TAY 
$0EC7  B9 A7 10  LDA $10A7,Y 
$0ECA  9D AC 14  STA $14AC,X 
$0ECD  85 A7     STA $A7 
$0ECF  B9 C6 10  LDA $10C6,Y 
$0ED2  9D AF 14  STA $14AF,X 
$0ED5  85 A8     STA $A8 
$0ED7  60        RTS 
//------------------------------
L_JSR_($0ED8)_($0D7A) OK
//------------------------------
$0ED8  A2 00     LDX #$00
$0EDA  CC D9 0E  CPY $0ED9 
$0EDD  B0 23     BCS L_BRS_($0F02)_($0EDD) OK
$0EDF  A9 18     LDA #$18
$0EE1  8D 86 0D  STA $0D86 
$0EE4  A9 6D     LDA #$6D
$0EE6  8D 87 0D  STA $0D87 
$0EE9  8D 93 0D  STA $0D93 
$0EEC  38        SEC 
$0EED  BD BE 0F  LDA $0FBE,X 
$0EF0  F9 BE 0F  SBC $0FBE,Y 
$0EF3  8D C7 14  STA $14C7 
$0EF6  BD 5F 0F  LDA $0F5F,X 
$0EF9  F9 5F 0F  SBC $0F5F,Y 
$0EFC  8D C8 14  STA $14C8 
$0EFF  4C 22 0F  JMP L_JMP_($0F22)_($0EFF) OK
//------------------------------
L_BRS_($0F02)_($0EDD) OK
//------------------------------
$0F02  A9 38     LDA #$38
$0F04  8D 86 0D  STA $0D86 
$0F07  A9 ED     LDA #$ED
$0F09  8D 87 0D  STA $0D87 
$0F0C  8D 93 0D  STA $0D93 
$0F0F  38        SEC 
$0F10  B9 BE 0F  LDA $0FBE,Y 
$0F13  FD BE 0F  SBC $0FBE,X 
$0F16  8D C7 14  STA $14C7 
$0F19  B9 5F 0F  LDA $0F5F,Y 
$0F1C  FD 5F 0F  SBC $0F5F,X 
$0F1F  8D C8 14  STA $14C8 
//------------------------------
L_JMP_($0F22)_($0EFF) OK
//------------------------------
$0F22  AC 9B 14  LDY $149B 
$0F25  A9 00     LDA #$00
$0F27  18        CLC 
//------------------------------
L_BRS_($0F28)_($0F2B) OK
//------------------------------
$0F28  69 00     ADC #$00
$0F2A  88        DEY 
$0F2B  10 FB     BPL L_BRS_($0F28)_($0F2B) OK
$0F2D  8D C9 14  STA $14C9 
$0F30  18        CLC 
$0F31  A2 10     LDX #$10
$0F33  A9 00     LDA #$00
//------------------------------
L_BRS_($0F35)_($0F48) OK
//------------------------------
$0F35  2E C7 14  ROL $14C7 
$0F38  2E C8 14  ROL $14C8 
$0F3B  2A        ROL A 
$0F3C  B0 05     BCS L_BRS_($0F43)_($0F3C) OK
$0F3E  CD C9 14  CMP $14C9 
$0F41  90 04     BCC L_BRS_($0F47)_($0F41) OK
//------------------------------
L_BRS_($0F43)_($0F3C) OK
//------------------------------
$0F43  ED C9 14  SBC $14C9 
$0F46  38        SEC 
//------------------------------
L_BRS_($0F47)_($0F41) OK
//------------------------------
$0F47  CA        DEX 
$0F48  D0 EB     BNE L_BRS_($0F35)_($0F48) OK
$0F4A  2E C7 14  ROL $14C7 
$0F4D  2E C8 14  ROL $14C8 
$0F50  0A        ASL A 
$0F51  CD C9 14  CMP $14C9 
$0F54  90 08     BCC L_BRS_($0F5E)_($0F54) OK
$0F56  EE C7 14  INC $14C7 
$0F59  D0 03     BNE L_BRS_($0F5E)_($0F59) OK
$0F5B  EE C8 14  INC $14C8 
//------------------------------
L_BRS_($0F5E)_($0F54) OK
L_BRS_($0F5E)_($0F59) OK
//------------------------------
$0F5E  60        RTS 
//------------------------------
$0F5F            .byte $00
$0F60  01 01     ORA ($01,X)
$0F62  01 01     ORA ($01,X)
$0F64  01 01     ORA ($01,X)
$0F66  01 01     ORA ($01,X)
$0F68  01 01     ORA ($01,X)
$0F6A            .byte $02,$02,$02,$02,$02,$02,$02,$03
$0F72            .byte $03,$03,$03,$03,$04,$04,$04,$04
$0F7A  05 05     ORA $05
$0F7C  05 06     ORA $06
$0F7E  06 06     ASL $06 
$0F80            .byte $07,$07
$0F82  08        PHP 
$0F83  08        PHP 
$0F84  09 09     ORA #$09
$0F86  0A        ASL A 
$0F87  0A        ASL A 
$0F88            .byte $0B,$0C,$0C
$0F8B  0D 0E 0F  ORA $0F0E
$0F8E  10 11     BPL L_BRS_($0FA1)_($0F8E) BAD
$0F90            .byte $12,$13,$14
$0F93  15 16     ORA $16,X
$0F95  18        CLC 
$0F96  19 1B 1C  ORA $1C1B,Y
$0F99  1E 20 22  ASL $2220,X 
$0F9C  24 26     BIT $26 
$0F9E  28        PLP 
$0F9F            .byte $2B
//------------------------------
L_BRS_($0FA1)_($0F8E) BAD
//------------------------------
$0FA0  2D 30 33  AND $3330 
$0FA3  36 39     ROL $39,X 
$0FA5  3D 40 44  AND $4440,X 
$0FA8  48        PHA 
$0FA9  4C 51 56  JMP L_JMP_($5651)_($0FA9) OK
$0FAC            .byte $5B
$0FAD  60        RTS 
//------------------------------
$0FAE  66 6C     ROR $6C 
$0FB0            .byte $73,$7A
$0FB2  81 89     STA ($89,X) 
$0FB4  91 99     STA ($99),Y 
$0FB6            .byte $A3
$0FB7  AC B7 C1  LDY $C1B7 
$0FBA  CD D9 E6  CMP $E6D9 
$0FBD            .byte $F4,$00,$23,$34
$0FC1  46 5A     LSR $5A 
$0FC3  6E 84 9B  ROR $9B84 
$0FC6            .byte $B3
$0FC7  CD E9 06  CMP $06E9 
$0FCA  25 45     AND $45
$0FCC  68        PLA 
$0FCD  8C B3 DC  STY $DCB3 
$0FD0  08        PHP 
$0FD1  36 67     ROL $67,X 
$0FD3            .byte $9B,$D2,$0C
$0FD6  49 8B     EOR #$8B
$0FD8  D0 19     BNE L_BRS_($0FF3)_($0FD8) JAM
$0FDA            .byte $67
$0FDB  B9 10 6C  LDA $6C10,Y 
$0FDE  CE 35 A3  DEC $A335 
$0FE1            .byte $17,$93
$0FE3  15 9F     ORA $9F,X
$0FE5            .byte $3C
$0FE6  CD 72 20  CMP $2072 
$0FE9  D8        CLD 
$0FEA            .byte $9C,$6B
$0FEC  46 2F     LSR $2F 
$0FEE  25 2A     AND $2A
$0FF0            .byte $3F,$64
$0FF2  9A        TXS 
//------------------------------
L_BRS_($0FF3)_($0FD8) JAM
//------------------------------
$0FF3            .byte $E3,$3F
$0FF5  B1 38     LDA ($38),Y 
$0FF7  D6 8D     DEC $8D,X 
$0FF9  5E 4B 55  LSR $554B,X 
$0FFC  7E C8 34  ROR $34C8,X 
$0FFF  C6 7F     DEC $7F 
$1001  61 6F     ADC ($6F,X) 
$1003  AC 7E BC  LDY $BC7E 
$1006  95 A9     STA $A9,X 
$1008            .byte $FC
$1009  A1 69     LDA ($69,X) 
$100B  8C FE C2  STY $C2FE 
$100E            .byte $DF
$100F  58        CLI 
$1010            .byte $34
$1011  78        SEI 
$1012            .byte $2B,$53,$F7,$1F,$D2
$1017  19 FC 85  ORA $85FC,Y
$101A  BD B0 67  LDA $67B0,X 
$101D  49 4E     EOR #$4E
$101F  49 54     EOR #$54
//------------------------------
L_JSR_($1021)_($0945) OK
L_JSR_($1021)_($407A) OK
L_JSR_($1021)_($439C) OK
L_JSR_($1021)_($7290) OK
//------------------------------
$1021  20 50 0E  JSR L_JSR_($0E50)_($1021) OK
$1024  A9 00     LDA #$00
$1026  8D 15 D4  STA $D415                          // Filter Cutoff Frequency: Low-Nybble
$1029  A9 00     LDA #$00
$102B  8D 16 D4  STA $D416                          // Filter Cutoff Frequency: High-Byte
$102E  A9 77     LDA #$77
$1030  8D 17 D4  STA $D417                          // Filter Resonance Control / Voice Input Control
$1033  A9 5F     LDA #$5F
$1035  8D 18 D4  STA $D418                          // Select Filter Mode and Volume
$1038  A9 00     LDA #$00
$103A  8D 9C 14  STA $149C 
$103D  8D 9A 14  STA $149A 
$1040  60        RTS 
//------------------------------
$1041  E5 10     SBC $10 
$1043  20 11 57  JSR L_JSR_($5711)_($1043) OK
$1046  11 40     ORA ($40),Y
$1048            .byte $00,$00,$00,$00,$00,$00,$00
$104F  41 42     EOR ($42,X) 
$1051  24 02     BIT $02 
$1053            .byte $23,$0F,$00,$04
$1057  11 8A     ORA ($8A),Y
$1059  AC 00 64  LDY $6400 
$105C            .byte $0B,$00,$00
$105F  11 6C     ORA ($6C),Y
$1061            .byte $4F,$64,$63,$2F,$00,$04
$1067  41 3A     EOR ($3A,X) 
$1069  AC 20 00  LDY $0020 
$106C  08        PHP 
$106D            .byte $00,$04
$106F  81 42     STA ($42,X) 
$1071            .byte $00
$1072  20 00 01  JSR $0100
$1075            .byte $00,$00
$1077  11 3D     ORA ($3D),Y
$1079            .byte $1C,$22
$107B  35 00     AND $00,X 
$107D            .byte $00,$00
$107F  41 4C     EOR ($4C,X) 
$1081  2C 43 45  BIT $4543 
$1084            .byte $00,$00,$00
$1087  11 5D     ORA ($5D),Y
$1089  BC 44 65  LDY $6544,X 
$108C            .byte $22,$00,$04
$108F  41 4C     EOR ($4C,X) 
$1091            .byte $AF
$1092  30 00     BMI L_BRS_($1094)_($1092) JAM
//------------------------------
L_BRS_($1094)_($1092) JAM
//------------------------------
$1094            .byte $00,$00,$04
$1097  21 4A     AND ($4A,X) 
$1099  2A        ROL A 
$109A            .byte $80,$64,$22,$00,$04
$109F  41 6A     EOR ($6A,X) 
$10A1            .byte $6B
$10A2  41 00     EOR ($00,X) 
$10A4  40        RTI 
//------------------------------
$10A5            .byte $80,$04
$10A7  8E 92 B6  STX $B692 
$10AA            .byte $CF
$10AB  EC 08 18  CPX $1808 
$10AE            .byte $22,$3B
$10B0  40        RTI 
//------------------------------
$10B1  4E 56 79  LSR $7956 
$10B4            .byte $87
$10B5  95 B5     STA $B5,X 
$10B7            .byte $DC,$FF
$10B9  24 50     BIT $50 
$10BB            .byte $73
$10BC  78        SEI 
$10BD            .byte $9C
$10BE  C0 C2     CPY #$C2
$10C0  C4 F8     CPY $F8 
$10C2  2C 2E 30  BIT $302E 
$10C5            .byte $5C
$10C6  11 11     ORA ($11),Y
$10C8  11 11     ORA ($11),Y
$10CA  11 12     ORA ($12),Y
$10CC            .byte $12,$12,$12,$12,$12,$12,$12,$12
$10D4            .byte $12,$12,$12,$12,$13,$13,$13,$13
$10DC            .byte $13,$13,$13,$13,$13,$14,$14,$14
$10E4            .byte $14
$10E5  E0 01     CPX #$01
$10E7  01 01     ORA ($01,X)
$10E9  01 01     ORA ($01,X)
$10EB  01 01     ORA ($01,X)
$10ED  01 01     ORA ($01,X)
$10EF            .byte $0B,$0B,$0B,$0B
$10F3  01 01     ORA ($01,X)
$10F5            .byte $0B
$10F6  10 0B     BPL L_BRS_($1103)_($10F6) JAM
$10F8            .byte $0B
$10F9  01 10     ORA ($10,X)
$10FB  01 01     ORA ($01,X)
//------------------------------
L_BRS_($1103)_($10F6) JAM
//------------------------------
$10FD            .byte $13,$13,$13,$13,$0B,$0B,$13,$13
$1105            .byte $13,$13,$13,$13,$13,$13,$0B,$0B
$110D            .byte $0B,$0B
//------------------------------
L_JSR_($1110)_($97FF) BAD
//------------------------------
$110F  01 01     ORA ($01,X)
$1111  01 01     ORA ($01,X)
$1113            .byte $0B
$1114  10 0B     BPL L_BRS_($1121)_($1114) BAD
$1116            .byte $0B
$1117  01 13     ORA ($13,X)
$1119  01 01     ORA ($01,X)
$111B            .byte $13,$13,$13,$13,$FF
//------------------------------
L_BRS_($1121)_($1114) BAD
//------------------------------
$1120  E0 00     CPX #$00
$1122            .byte $00,$00,$00
$1125  06 07     ASL $07 
$1127            .byte $07,$07,$07
$112A  09 09     ORA #$09
$112C            .byte $07,$07
$112E  E0 08     CPX #$08
$1130  08        PHP 
$1131  08        PHP 
//------------------------------
L_JSR_($1132)_($BB8B) OK
//------------------------------
$1132  08        PHP 
$1133  18        CLC 
$1134  0A        ASL A 
$1135  0A        ASL A 
$1136  18        CLC 
$1137            .byte $0C
$1138  0D 0C 0D  ORA $0D0C
$113B            .byte $14,$14,$14,$14
$113F  16 17     ASL $17,X 
//------------------------------
L_BRS_($1141)_($11B8) JAM
//------------------------------
$1141            .byte $0C
$1142  0D D4 0C  ORA $0CD4
$1145  0D E0 05  ORA $05E0
$1148  05 05     ORA $05
$114A  05 17     ORA $17
$114C            .byte $0C
$114D  0D D4 0C  ORA $0CD4
$1150  0D EC 08  ORA $08EC
$1153  08        PHP 
$1154  08        PHP 
$1155  08        PHP 
$1156            .byte $FF
$1157  E0 05     CPX #$05
//------------------------------
L_BRS_($115A)_($11D1) BAD
//------------------------------
$1159  05 05     ORA $05
//------------------------------
L_BRS_($115C)_($11D7) BAD
//------------------------------
$115B  05 EC     ORA $EC
$115D  08        PHP 
$115E  E0 02     CPX #$02
$1160            .byte $02,$03,$02,$04
$1164  EC 04 E0  CPX $E004 
$1167  0E 0F 11  ASL $110F 
$116A            .byte $12
$116B  EC 02 02  CPX $0202 
$116E            .byte $03,$02
$1170  E0 15     CPX #$15
$1172            .byte $1B
//------------------------------
L_BRS_($1174)_($11CB) BAD
//------------------------------
$1173  19 1B 1A  ORA $1A1B,Y
$1176            .byte $1C
$1177  19 1C 1A  ORA $1A1C,Y
$117A  1D 1E 07  ORA $071E,X
$117D            .byte $00,$07,$00,$04
$1181  EC 04 E0  CPX $E004 
$1184  0E 0F 11  ASL $110F 
$1187            .byte $12
$1188  EC 02 02  CPX $0202 
$118B            .byte $03,$02,$FF
$118E  C0 BF     CPY #$BF
$1190            .byte $00,$FF,$F3
$1193  C1 83     CMP ($83,X) 
$1195            .byte $1A
$1196  21 21     AND ($21,X) 
$1198            .byte $1A,$1A
$119A  21 1A     AND ($1A,X) 
$119C  21 1A     AND ($1A,X) 
$119E  21 21     AND ($21,X) 
$11A0            .byte $1A,$1A
$11A2  21 1A     AND ($1A,X) 
$11A4  21 1A     AND ($1A,X) 
$11A6  21 21     AND ($21,X) 
$11A8            .byte $1A,$1A
$11AA  21 1A     AND ($1A,X) 
$11AC  21 1A     AND ($1A,X) 
$11AE  21 21     AND ($21,X) 
$11B0            .byte $1A,$1A
$11B2  21 1A     AND ($1A,X) 
$11B4  21 FF     AND ($FF,X) 
$11B6            .byte $C2,$97
$11B8  30 87     BMI L_BRS_($1141)_($11B8) JAM
$11BA  2D 97 30  AND $3097 
$11BD            .byte $87
$11BE  2D 30 83  AND $8330 
$11C1  2E 30 80  ROL $8030 
$11C4  2E 30 2E  ROL $2E30 
$11C7  30 2E     BMI L_BRS_($11F7)_($11C7) BAD
$11C9  30 2E     BMI L_BRS_($11F9)_($11C9) JAM
$11CB  30 A7     BMI L_BRS_($1174)_($11CB) BAD
//------------------------------
L_BRS_($11CE)_($1249) BAD
//------------------------------
$11CD  2D FF C2  AND $C2FF 
$11D0            .byte $97
$11D1  30 87     BMI L_BRS_($115A)_($11D1) BAD
$11D3            .byte $32,$33
$11D5  85 32     STA $32 
$11D7  30 83     BMI L_BRS_($115C)_($11D7) BAD
$11D9  2D 80 2D  AND $2D80 
$11DC  2E 2D 2E  ROL $2E2D 
$11DF  2D 2E 2D  AND $2D2E 
$11E2  2E 97 2B  ROL $2B97 
$11E5            .byte $87
$11E6  2D 97 2B  AND $2B97 
$11E9            .byte $87
$11EA  2D FF C3  AND $C3FF 
$11ED            .byte $97
$11EE  3E 81 3D  ROL $3D81,X 
$11F1  3E 3D 39  ROL $393D,X 
$11F4            .byte $97,$3C
//------------------------------
L_BRS_($11F7)_($11C7) BAD
//------------------------------
$11F6  81 3A     STA ($3A,X) 
//------------------------------
L_BRS_($11F9)_($11C9) JAM
//------------------------------
$11F8            .byte $3C,$3A
$11FA  35 80     AND $80,X 
$11FC  39 37 9D  AND $9D37,Y 
$11FF  39 80 39  AND $3980,Y 
$1202            .byte $3A
$1203  39 38 9B  AND $9B38,Y 
$1206  39 FF F3  AND $F3FF,Y 
$1209  C4 BF     CPY $BF 
$120B  7D 89 3E  ADC $3E89,X 
$120E  7D 8A 3C  ADC $3C8A,X 
$1211  7D 94 39  ADC $3994,X 
$1214  7D 8A 3C  ADC $3C8A,X 
$1217            .byte $FF,$C3,$BF
$121A  26 28     ROL $28 
$121C  29 B7     AND #$B7
$121E  28        PLP 
$121F            .byte $87
$1220  24 FF     BIT $FF 
$1222  C0 87     CPY #$87
$1224            .byte $00
$1225  C5 81     CMP $81 
$1227            .byte $3C,$3C,$3C,$3C,$87,$3C
$122D  C0 00     CPY #$00
$122F            .byte $00
$1230  C5 81     CMP $81 
$1232            .byte $3C,$3C,$3C,$3C,$87,$3C
$1238  C0 00     CPY #$00
$123A            .byte $FF,$C3,$BF,$1A
$123E  26 FF     ROL $FF 
$1240            .byte $C3,$B7,$32
$1243  81 31     STA ($31,X) 
$1245            .byte $32
$1246  31 2D     AND ($2D),Y 
$1248            .byte $B7
$1249  30 83     BMI L_BRS_($11CE)_($1249) BAD
$124B  2D 30 FF  AND $FF30 
$124E            .byte $BF
$124F  7D 89 3E  ADC $3E89,X 
$1252  7D 89 3E  ADC $3E89,X 
$1255            .byte $FF
$1256  C1 83     CMP ($83,X) 
$1258            .byte $1A
$1259  21 26     AND ($26,X) 
$125B            .byte $1A
$125C  21 26     AND ($26,X) 
$125E            .byte $1A
$125F  21 1A     AND ($1A,X) 
$1261  21 26     AND ($26,X) 
$1263            .byte $1A
$1264  21 26     AND ($26,X) 
$1266            .byte $1A
$1267  21 1A     AND ($1A,X) 
$1269  21 26     AND ($26,X) 
$126B            .byte $1A
$126C  21 26     AND ($26,X) 
$126E            .byte $1A
$126F  21 1A     AND ($1A,X) 
$1271  21 26     AND ($26,X) 
$1273            .byte $1A
$1274  21 26     AND ($26,X) 
$1276            .byte $1A
$1277  21 FF     AND ($FF,X) 
$1279            .byte $BF
$127A  7D 89 3E  ADC $3E89,X 
$127D  7D 8A 3C  ADC $3C8A,X 
$1280  7D 89 39  ADC $3989,X 
$1283  7D 8A 37  ADC $378A,X 
$1286            .byte $FF,$BF
$1288  7D 89 3E  ADC $3E89,X 
$128B  7D 8A 3F  ADC $3F8A,X 
$128E  7D 89 3C  ADC $3C89,X 
$1291  7D 89 3E  ADC $3E89,X 
$1294            .byte $FF
$1295  C6 B7     DEC $B7 
$1297  3E 81 3C  ROL $3C81,X 
$129A  3E 3C 39  ROL $393C,X 
$129D            .byte $8B,$3C,$AB
$12A0  39 83 3C  AND $3C83,Y 
$12A3  3E 81 39  ROL $3981,X 
$12A6            .byte $37,$A3
$12A8  39 87 3C  AND $3C87,Y 
$12AB  39 83 37  AND $3783,Y 
$12AE  39 81 37  AND $3781,Y 
$12B1  39 BB 37  AND $37BB,Y 
$12B4            .byte $FF,$A7
$12B6  3E 87 3E  ROL $3E87,X 
$12B9  85 3F     STA $3F 
$12BB  3E 83 3C  ROL $3C83,X 
$12BE  81 3F     STA ($3F,X) 
$12C0  3E A3 3C  ROL $3CA3,X 
$12C3            .byte $83,$3F
$12C5  3E 87 3C  ROL $3C87,X 
$12C8            .byte $83
$12C9  3E 3C 9B  ROL $9B3C,X 
$12CC  39 83 39  AND $3983,Y 
$12CF            .byte $8F,$3A,$37,$97
$12D3  39 83 3C  AND $3C83,Y 
$12D6  81 3E     STA ($3E,X) 
$12D8            .byte $3F,$9F
$12DA  3E FF C1  ROL $C1FF,X 
$12DD            .byte $83,$1A
$12DF  21 26     AND ($26,X) 
$12E1            .byte $1A
$12E2  21 26     AND ($26,X) 
$12E4            .byte $1A
$12E5  21 1A     AND ($1A,X) 
$12E7  21 26     AND ($26,X) 
$12E9            .byte $1A
$12EA  21 26     AND ($26,X) 
$12EC            .byte $1A
$12ED  21 1A     AND ($1A,X) 
$12EF            .byte $1F
$12F0  26 1A     ROL $1A 
$12F2            .byte $1F
$12F3  26 1A     ROL $1A 
$12F5            .byte $1F,$1A,$1F
$12F8  26 1A     ROL $1A 
$12FA            .byte $1F
$12FB  26 1A     ROL $1A 
$12FD            .byte $1F,$FF,$C7
$1300  B1 3E     LDA ($3E),Y 
$1302  81 3F     STA ($3F,X) 
$1304  3E 3C 3E  ROL $3E3C,X 
$1307            .byte $3F
$1308  3E 3F 8F  ROL $8F3F,X 
$130B            .byte $3C,$A7
$130D  39 83 3C  AND $3C83,Y 
$1310  3E 81 37  ROL $3781,X 
$1313  39 3A B1  AND $B13A,Y 
$1316  39 81 37  AND $3781,Y 
$1319  39 37 39  AND $3937,Y 
//------------------------------
L_BRS_($131D)_($1394) JAM
//------------------------------
$131C            .byte $9F,$37,$8F
//------------------------------
L_BRS_($1321)_($1398) BAD
//------------------------------
$131F  3E 87 3F  ROL $3F87,X 
$1322            .byte $3C,$FF,$C7,$9F
$1326  3E 8B 45  ROL $458B,X 
$1329            .byte $83
$132A  45 87     EOR $87 
$132C  46 83     LSR $83 
$132E  45 81     EOR $81 
$1330            .byte $43
$1331  45 97     EOR $97 
$1333  46 81     LSR $81 
$1335  46 48     LSR $48 
$1337  46 45     LSR $45 
$1339            .byte $9B
$133A  46 81     LSR $81 
$133C            .byte $3F
$133D  3E 97 3C  ROL $3C97,X 
$1340            .byte $87
$1341  3E 8F 3F  ROL $3F8F,X 
$1344            .byte $3C,$AF
$1346  39 C5 81  AND $81C5,Y 
$1349            .byte $3C,$3C,$3C,$3C,$87,$3C,$FF
$1350  C1 83     CMP ($83,X) 
$1352            .byte $1A,$1A
$1354  26 1A     ROL $1A 
$1356            .byte $1A
$1357  26 1A     ROL $1A 
$1359  26 1A     ROL $1A 
$135B            .byte $1A
$135C  26 1A     ROL $1A 
$135E            .byte $1A
//------------------------------
L_BRS_($1360)_($13C7) BAD
//------------------------------
$135F  26 1A     ROL $1A 
$1361  26 1A     ROL $1A 
$1363            .byte $1A
$1364  26 1A     ROL $1A 
$1366            .byte $1A
$1367  26 1A     ROL $1A 
$1369  26 1A     ROL $1A 
$136B            .byte $1A
$136C  26 1A     ROL $1A 
$136E            .byte $1A
$136F  26 1A     ROL $1A 
//------------------------------
L_BRS_($1371)_($13D0) OK
//------------------------------
$1371  26 FF     ROL $FF 
$1373  C6 BF     DEC $BF 
$1375  26 32     ROL $32 
//------------------------------
L_BRS_($1377)_($13DE) JAM
//------------------------------
$1377            .byte $FF
$1378  C8        INY 
$1379            .byte $97
$137A  35 87     AND $87,X 
$137C            .byte $37
//------------------------------
L_BRS_($137D)_($13EC) OK
//------------------------------
$137D  39 97 39  AND $3997,Y 
//------------------------------
L_BRS_($1380)_($13E7) OK
//------------------------------
$1380  81 38     STA ($38,X) 
$1382  39 38 39  AND $3938,Y 
$1385            .byte $A7
$1386  35 8F     AND $8F,X 
$1388            .byte $32
$1389  81 33     STA ($33,X) 
$138B  35 33     AND $33,X 
$138D  35 33     AND $33,X 
$138F  35 33     AND $33,X 
$1391  B1 32     LDA ($32),Y 
$1393            .byte $97
$1394  30 87     BMI L_BRS_($131D)_($1394) JAM
$1396            .byte $32,$97
$1398  30 87     BMI L_BRS_($1321)_($1398) BAD
$139A            .byte $32,$FF
$139C  C8        INY 
$139D            .byte $97,$32,$87,$34
$13A1  35 97     AND $97,X 
$13A3  35 81     AND $81,X 
$13A5            .byte $34
$13A6  35 34     AND $34,X 
$13A8  35 A7     AND $A7,X 
$13AA            .byte $32,$8F
$13AC  2D 81 2E  AND $2E81 
$13AF            .byte $2F
$13B0  2E 2F 2E  ROL $2E2F 
$13B3            .byte $2F
$13B4  2E B1 2D  ROL $2DB1 
$13B7            .byte $97
$13B8  2D 87 2D  AND $2D87 
$13BB            .byte $97
$13BC  2D 87 2D  AND $2D87 
$13BF            .byte $FF
$13C0  C9 FF     CMP #$FF
$13C2  C4 FF     CPY $FF 
$13C4            .byte $97,$32,$87
$13C7  30 97     BMI L_BRS_($1360)_($13C7) BAD
$13C9            .byte $32
$13CA  81 32     STA ($32,X) 
$13CC            .byte $34,$32,$34,$87
$13D0  30 9F     BMI L_BRS_($1371)_($13D0) OK
$13D2  2D 83 30  AND $3083 
$13D5            .byte $32,$34
$13D7  35 34     AND $34,X 
$13D9  35 8B     AND $8B,X 
$13DB            .byte $34
$13DC  81 32     STA ($32,X) 
$13DE  30 97     BMI L_BRS_($1377)_($13DE) JAM
$13E0  2D 83 2F  AND $2F83 
$13E3  30 32     BMI L_BRS_($1417)_($13E3) OK
$13E5  30 2F     BMI L_BRS_($1416)_($13E5) BAD
$13E7  30 97     BMI L_BRS_($1380)_($13E7) OK
$13E9            .byte $32,$83,$2F
$13EC  30 8F     BMI L_BRS_($137D)_($13EC) OK
$13EE            .byte $2F
$13EF  C5 81     CMP $81 
$13F1            .byte $3C,$3C,$3C,$3C,$87,$3C,$FF
$13F8  81 3E     STA ($3E,X) 
$13FA            .byte $3C
$13FB  3E 3F A3  ROL $A33F,X 
$13FE  3E 83 3E  ROL $3E83,X 
$1401            .byte $87,$3F,$83
$1404  3E 3C 81  ROL $813C,X 
$1407            .byte $3F
$1408  3E 3F 41  ROL $413F,X 
$140B            .byte $97,$3F,$83,$3C,$87
$1410  3E 8B 3F  ROL $3F8B,X 
$1413            .byte $87
//------------------------------
L_BRS_($1416)_($13E5) BAD
//------------------------------
$1414  3E 81 3C  ROL $3C81,X 
//------------------------------
L_BRS_($1417)_($13E3) OK
//------------------------------
$1417  3E A3 3C  ROL $3CA3,X 
$141A            .byte $83,$3C
$141C  3E 3C 3A  ROL $3A3C,X 
$141F  39 3A AF  AND $AF3A,Y 
$1422  39 C5 81  AND $81C5,Y 
$1425            .byte $3C,$3C,$3C,$3C,$87,$3C,$FF,$C7
$142D            .byte $FF
$142E  CA        DEX 
$142F            .byte $FF,$CB,$8B
$1432  3E 83 3C  ROL $3C83,X 
$1435            .byte $9B
$1436  3E 83 3C  ROL $3C83,X 
$1439            .byte $87
$143A  3E 3F 8F  ROL $8F3F,X 
$143D            .byte $3C,$97
$143F  39 83 3C  AND $3C83,Y 
$1442  3E 87 3C  ROL $3C87,X 
$1445            .byte $83,$3A
$1447  39 8F 39  AND $398F,Y 
$144A            .byte $9F
$144B  3E 87 3E  ROL $3E87,X 
$144E  40        RTI 
//------------------------------
$144F            .byte $8F,$3C,$9F
$1452  39 C5 81  AND $81C5,Y 
$1455            .byte $3C,$3C,$3C,$3C,$87,$3C,$FF,$CB
$145D            .byte $97
$145E  39 83 3E  AND $3E83,Y 
$1461            .byte $97
$1462  40        RTI 
//------------------------------
$1463            .byte $83
$1464  39 3E 41  AND $413E,Y 
$1467            .byte $8B
$1468  40        RTI 
//------------------------------
$1469  81 3E     STA ($3E,X) 
$146B            .byte $3C,$A7
$146D  39 81 3C  AND $3C81,Y 
$1470  3E 3C 3E  ROL $3E3C,X 
$1473            .byte $89
$1474  40        RTI 
//------------------------------
$1475  81 41     STA ($41,X) 
$1477  40        RTI 
//------------------------------
$1478  41 AF     EOR ($AF,X) 
$147A  3E 8F 3E  ROL $3E8F,X 
$147D            .byte $3C,$9F
$147F  39 FF 85  AND $85FF,Y 
$1482            .byte $14
$1483  85 14     STA $14 
$1485            .byte $00,$07
$1487  0E 00 0A  ASL $0A00 
$148A            .byte $14,$03,$04
$148D  05 07     ORA $07
$148F  08        PHP 
$1490  09 0A     ORA #$0A
$1492            .byte $0C
$1493  01 01     ORA ($01,X)
$1495  01 00     ORA ($00,X)
$1497            .byte $00,$00,$00,$00,$03,$00,$00,$00
$149F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14A7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14AF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14B7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14BF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14C7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14CF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14D7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14DF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14E7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14EF            .byte $00,$00,$00,$00,$03,$03,$03,$00
$14F7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$14FF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1507            .byte $00,$00,$00,$00,$00,$00,$00,$00
$150F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1517            .byte $00,$00,$00,$00,$00,$00,$00,$00
$151F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1527  01 03     ORA ($03,X)
$1529  09 03     ORA #$03
$152B            .byte $03
$152C  19 32 64  ORA $6432,Y
$152F            .byte $00,$00,$00,$0C,$00,$00,$00
$1536  36 35     ROL $35,X 
$1538  36 35     ROL $35,X 
$153A  36 35     ROL $35,X 
$153C  08        PHP 
$153D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1545            .byte $00,$00,$00,$00,$00,$00,$00,$00
$154D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1555            .byte $00,$00,$00,$00,$00,$00,$00,$00
$155D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1565            .byte $00,$00,$00
$1568  05 00     ORA $00
$156A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1572            .byte $00,$00,$00,$00,$00,$00,$00,$00
$157A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1582            .byte $00,$00,$00,$00,$00,$00,$00,$00
$158A            .byte $00
$158B  96 C8     STX $C8,Y 
$158D  96 A7     STX $A7,Y 
$158F  7E B7 8C  ROR $8CB7,X 
$1592            .byte $A7
$1593  7E C7 8B  ROR $8BC7,X 
$1596            .byte $00,$00,$00,$00,$00,$00,$00,$00
$159E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15A6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15AE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15B6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15BE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15C6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15CE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15D6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15DE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15E6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15EE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15F6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$15FE            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($1606)_($B8F7) JAM
L_JSR_($1606)_($B900) JAM
//------------------------------
$1606            .byte $00,$00,$00,$00,$00,$00,$00,$00
$160E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1616            .byte $00,$00,$00,$00,$00,$00,$00,$00
$161E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1626            .byte $00,$00,$00,$00,$00,$00,$00,$00
$162E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1636            .byte $00,$00,$00,$00,$00,$00,$00,$00
$163E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1646            .byte $00,$00,$00,$00,$00,$00,$00,$00
$164E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1656            .byte $00,$00,$00,$00,$00,$00,$00,$00
$165E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1666            .byte $00,$00,$00,$00,$00,$00,$00,$00
$166E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1676            .byte $00,$00,$00,$00,$00,$00,$00,$00
$167E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1686            .byte $00,$00,$00,$00,$00,$00,$00,$00
$168E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1696            .byte $00,$00,$00,$00,$00,$00,$00,$00
$169E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16A6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16AE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16B6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16BE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16C6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16CE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16D6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16DE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16E6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16EE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16F6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$16FE            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1706            .byte $00,$00,$00,$00,$00,$00,$00,$00
$170E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1716            .byte $00,$00,$00,$00,$00,$00,$00,$00
$171E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1726            .byte $00,$00,$00,$00,$00,$00,$00,$00
$172E            .byte $00,$00
$1730  55 00     EOR $00,X 
$1732            .byte $00,$00,$00,$00,$00,$00,$00,$00
$173A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1742            .byte $00,$00,$00,$00,$00,$00,$00,$00
$174A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1752            .byte $00,$00,$00,$00,$00,$00,$00,$00
$175A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1762            .byte $00,$00,$00,$00,$00,$00,$00,$00
$176A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1772            .byte $00,$00,$00,$00,$00,$00,$00,$00
$177A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1782            .byte $00,$00,$00,$00,$00,$00,$00,$00
$178A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1792            .byte $00,$00,$00,$00,$00,$00,$00,$00
$179A            .byte $00,$00,$00
$179D  40        RTI 
//------------------------------
$179E  06 40     ASL $40 
$17A0            .byte $0B,$3F
$17A2  11 3E     ORA ($3E),Y
$17A4  16 3C     ASL $3C,X 
$17A6            .byte $1B,$3A
$17A8  20 37 25  JSR L_JSR_($2537)_($17A8) BAD
$17AB            .byte $34
$17AC  29 31     AND #$31
$17AE  2D 2D 31  AND $312D 
$17B1  29 34     AND #$34
$17B3  25 37     AND $37
$17B5  20 3A 1B  JSR L_JSR_($1B3A)_($17B5) OK
$17B8            .byte $3C
$17B9  16 3E     ASL $3E,X 
$17BB  11 3F     ORA ($3F),Y
$17BD            .byte $0B
$17BE  40        RTI 
//------------------------------
$17BF  06 40     ASL $40 
$17C1            .byte $00
$17C2  40        RTI 
//------------------------------
$17C3            .byte $FA,$3F
$17C5  F5 3E     SBC $3E,X 
$17C7            .byte $EF,$3C
$17C9  EA        NOP 
$17CA            .byte $3A
$17CB  E5 37     SBC $37 
$17CD  E0 34     CPX #$34
$17CF            .byte $DB
$17D0  31 D7     AND ($D7),Y 
$17D2  2D D3 29  AND $29D3 
$17D5            .byte $CF
$17D6  25 CC     AND $CC
$17D8  20 C9 1B  JSR L_JSR_($1BC9)_($17D8) JAM
$17DB  C6 16     DEC $16 
$17DD  C4 11     CPY $11 
$17DF            .byte $C2,$0B
$17E1  C1 06     CMP ($06,X) 
$17E3  C0 00     CPY #$00
$17E5  C0 FA     CPY #$FA
$17E7  C0 F5     CPY #$F5
$17E9  C1 EF     CMP ($EF,X) 
$17EB            .byte $C2
$17EC  EA        NOP 
$17ED  C4 E5     CPY $E5 
$17EF  C6 E0     DEC $E0 
$17F1  C9 DB     CMP #$DB
$17F3  CC D7 CF  CPY $CFD7 
$17F6            .byte $D3,$D3,$CF,$D7
$17FA  CC DB C9  CPY $C9DB 
$17FD  E0 C6     CPX #$C6
$17FF  E5 C4     SBC $C4 
$1801  EA        NOP 
$1802            .byte $C2,$EF
$1804  C1 F5     CMP ($F5,X) 
$1806  C0 FA     CPY #$FA
$1808  C0 00     CPY #$00
$180A  C0 06     CPY #$06
$180C  C1 0B     CMP ($0B,X) 
$180E            .byte $C2
$180F  11 C4     ORA ($C4),Y
$1811  16 C6     ASL $C6,X 
$1813            .byte $1B
$1814  C9 20     CMP #$20
$1816  CC 25 CF  CPY $CF25 
$1819  29 D3     AND #$D3
$181B  2D D7 31  AND $31D7 
$181E            .byte $DB,$34
$1820  E0 37     CPX #$37
$1822  E5 3A     SBC $3A 
$1824  EA        NOP 
$1825            .byte $3C,$EF
$1827  3E F5 3F  ROL $3FF5,X 
$182A            .byte $FA
$182B  40        RTI 
//------------------------------
$182C  06 00     ASL $00 
$182E            .byte $04,$00,$03,$07,$04,$00,$04
$1835  05 06     ORA $06
$1837            .byte $02
$1838  01 00     ORA ($00,X)
$183A            .byte $04,$00,$04
$183D  05 01     ORA $01
$183F            .byte $00,$04,$02
$1842  06 07     ASL $07 
$1844            .byte $03,$00,$04,$00
$1848  01 02     ORA ($02,X)
$184A            .byte $03,$00,$04
$184D  05 04     ORA $04
$184F            .byte $07
$1850  06 05     ASL $05 
$1852            .byte $00,$03,$00,$03,$04,$00,$03,$03
$185A            .byte $02,$04,$00,$03,$02
$185F  01 04     ORA ($04,X)
$1861            .byte $00,$03
$1863  01 00     ORA ($00,X)
$1865            .byte $04,$00,$04,$00
$1869  01 02     ORA ($02,X)
$186B            .byte $03
$186C  05 00     ORA $00
$186E            .byte $04,$00,$03
$1871  05 04     ORA $04
$1873            .byte $00,$03,$03,$02
$1877  05 00     ORA $00
$1879            .byte $04,$02
$187B  01 04     ORA ($04,X)
$187D  05 00     ORA $00
$187F            .byte $03
$1880  01 00     ORA ($00,X)
$1882            .byte $04,$00,$04,$00
$1886  01 02     ORA ($02,X)
$1888            .byte $03
$1889  05 00     ORA $00
$188B            .byte $03,$00,$03,$04,$00,$04,$03,$02
$1893  05 04     ORA $04
$1895            .byte $00,$03,$02
$1898  01 05     ORA ($05,X)
$189A            .byte $00,$04
$189C  01 00     ORA ($00,X)
$189E            .byte $04
$189F  05 00     ORA $00
$18A1            .byte $04,$00
$18A3  01 02     ORA ($02,X)
$18A5            .byte $03
$18A6  06 00     ASL $00 
$18A8            .byte $04,$00,$03,$07,$04,$00,$04,$03
$18B0            .byte $02
$18B1  05 07     ORA $07
$18B3            .byte $00,$04,$02
$18B6  01 06     ORA ($06,X)
$18B8  05 00     ORA $00
$18BA            .byte $04
$18BB  01 00     ORA ($00,X)
$18BD            .byte $04
$18BE  06 00     ASL $00 
$18C0            .byte $04,$00
$18C2  01 02     ORA ($02,X)
$18C4            .byte $03,$00,$04,$04,$07
$18C9  05 06     ORA $06
$18CB  01 00     ORA ($00,X)
$18CD            .byte $00,$00
$18CF  01 02     ORA ($02,X)
$18D1            .byte $03,$04
$18D3  05 01     ORA $01
$18D5            .byte $00,$02,$00,$00,$00,$00,$00,$00
$18DD            .byte $00,$00,$00,$00,$00
$18E2  15 48     ORA $48,X
$18E4  01 5E     ORA ($5E,X)
$18E6            .byte $03
$18E7  91 03     STA ($03),Y 
$18E9  3D 04 92  AND $9204,X 
$18EC            .byte $04
$18ED  51 05     EOR ($05),Y 
$18EF            .byte $93
$18F0  05 57     ORA $57
$18F2  06 94     ASL $94 
$18F4  06 50     ASL $50 
$18F6            .byte $07
$18F7  4C 08 41  JMP L_JMP_($4108)_($18F7) BAD
$18FA            .byte $0B
$18FB  46 0C     LSR $0C 
$18FD  55 0D     EOR $0D,X 
$18FF            .byte $53
$1900  11 2B     ORA ($2B),Y
$1902  15 01     ORA $01,X
$1904  16 95     ASL $95,X 
$1906  16 20     ASL $20,X 
$1908  1E 52 1F  ASL $1F52,X 
$190B  49 29     EOR #$29
$190D  01 04     ORA ($04,X)
$190F            .byte $02,$02,$02,$02,$03,$03,$03,$02
$1917            .byte $02,$03,$02,$02,$03,$02,$02,$03
$191F            .byte $03,$02,$03
$1922  01 02     ORA ($02,X)
$1924            .byte $02,$02,$02
$1927  01 02     ORA ($02,X)
$1929            .byte $02,$02,$02,$02,$03,$03,$02,$02
$1931            .byte $02,$02,$02,$02
$1935  09 0C     ORA #$0C
$1937  0E 0A 10  ASL $100A 
$193A  10 10     BPL L_BRS_($194C)_($193A) BAD
$193C  10 10     BPL L_BRS_($194E)_($193C) BAD
$193E  10 10     BPL L_BRS_($1950)_($193E) BAD
$1940            .byte $13
$1941  16 19     ASL $19,X 
$1943            .byte $1C
$1944  20 48 45  JSR L_JSR_($4548)_($1944) OK
$1947  41 52     EOR ($52,X) 
$1949            .byte $54
//------------------------------
L_BRS_($194C)_($193A) BAD
//------------------------------
$194A  20 20 46  JSR L_JSR_($4620)_($194A) BAD
//------------------------------
L_BRS_($194E)_($193C) BAD
//------------------------------
$194D  41 49     EOR ($49,X) 
//------------------------------
L_BRS_($1950)_($193E) BAD
//------------------------------
$194F  4C 55 52  JMP L_JMP_($5255)_($194F) BAD
$1952  45 20     EOR $20 
$1954  20 20 53  JSR L_JSR_($5320)_($1954) BAD
$1957  55 4E     EOR $4E,X 
$1959  20 45 43  JSR L_JSR_($4345)_($1959) BAD
$195C  4C 49 50  JMP L_JMP_($5049)_($195C) BAD
$195F            .byte $53
$1960  45 44     EOR $44 
$1962  20 20 43  JSR L_JSR_($4320)_($1962) OK
$1965            .byte $52
$1966  55 53     EOR $53,X 
$1968  48        PHA 
$1969  45 44     EOR $44 
$196B  20 54 4F  JSR L_JSR_($4F54)_($196B) OK
$196E  20 44 45  JSR L_JSR_($4544)_($196E) BAD
$1971  41 54     EOR ($54,X) 
$1973  48        PHA 
$1974  20 20 20  JSR $2020
$1977  46 41     LSR $41 
$1979            .byte $54
$197A  41 4C     EOR ($4C,X) 
$197C  20 46 41  JSR L_JSR_($4146)_($197C) OK
$197F  4C 4C 20  JMP L_JMP_($204C)_($197F) BAD
$1982  20 20 20  JSR $2020
$1985            .byte $43
$1986  55 52     EOR $52,X 
$1988            .byte $53
$1989  45 20     EOR $20 
$198B            .byte $4F
$198C  56 45     LSR $45,X 
$198E            .byte $52,$43,$4F
$1991  4D 45 20  EOR $2045 
$1994  20 54 4F  JSR L_JSR_($4F54)_($1994) OK
$1997            .byte $54
$1998  41 4C     EOR ($4C,X) 
$199A  20 20 45  JSR L_JSR_($4520)_($199A) BAD
$199D            .byte $43
$199E  4C 49 50  JMP L_JMP_($5049)_($199E) BAD
$19A1            .byte $53
$19A2  45 20     EOR $20 
$19A4            .byte $54,$4F,$4F
$19A7  20 48 4F  JSR L_JSR_($4F48)_($19A7) BAD
$19AA            .byte $54
$19AB  20 54 4F  JSR L_JSR_($4F54)_($19AB) OK
$19AE  20 52 45  JSR L_JSR_($4552)_($19AE) BAD
$19B1            .byte $53,$54
$19B3  21 20     AND ($20,X) 
$19B5  20 20 52  JSR L_JSR_($5220)_($19B5) OK
$19B8  45 53     EOR $53 
$19BA            .byte $54
$19BB  49 4E     EOR #$4E
$19BD            .byte $47
$19BE  2E 2E 2E  ROL $2E2E 
$19C1  20 20 20  JSR $2020
$19C4  20 27 20  JSR L_JSR_($2027)_($19C4) OK
$19C7  41 4E     EOR ($4E,X) 
$19C9            .byte $4B
$19CA  48        PHA 
$19CB  20 46 4F  JSR L_JSR_($4F46)_($19CB) BAD
$19CE  55 4E     EOR $4E,X 
$19D0            .byte $44
$19D1  20 27 20  JSR L_JSR_($2027)_($19D1) OK
$19D4  20 20 57  JSR L_JSR_($5720)_($19D4) OK
$19D7  41 59     EOR ($59,X) 
$19D9  20 20 42  JSR L_JSR_($4220)_($19D9) BAD
$19DC  4C 4F 43  JMP L_JMP_($434F)_($19DC) BAD
$19DF            .byte $4B
$19E0  45 44     EOR $44 
$19E2  20 20 35  JSR L_JSR_($3520)_($19E2) OK
$19E5  20 41 4E  JSR L_JSR_($4E41)_($19E5) OK
$19E8            .byte $4B
$19E9  48        PHA 
$19EA            .byte $53
$19EB  20 52 45  JSR L_JSR_($4552)_($19EB) BAD
$19EE  51 55     EOR ($55),Y 
$19F0  49 52     EOR #$52
$19F2  45 44     EOR $44 
$19F4  20 20 20  JSR $2020
$19F7  24 32     BIT $32 
$19F9  4D 20 52  EOR $5220 
$19FC  45 57     EOR $57 
$19FE  41 52     EOR ($52,X) 
$1A00            .byte $44
$1A01  20 20 20  JSR $2020
$1A04  20 4D 41  JSR L_JSR_($414D)_($1A04) BAD
$1A07            .byte $4B
$1A08  45 20     EOR $20 
$1A0A            .byte $54
$1A0B  48        PHA 
$1A0C  45 20     EOR $20 
$1A0E  4D 41 54  EOR $5441 
$1A11            .byte $43
$1A12  48        PHA 
$1A13  20 54 4F  JSR L_JSR_($4F54)_($1A13) OK
$1A16  55 43     EOR $43,X 
$1A18  48        PHA 
$1A19  20 54 4F  JSR L_JSR_($4F54)_($1A19) OK
$1A1C  20 43 4F  JSR L_JSR_($4F43)_($1A1C) BAD
$1A1F  4C 4C 45  JMP L_JMP_($454C)_($1A1F) OK
$1A22            .byte $43,$54
$1A24  20 20 20  JSR $2020
$1A27  20 4E 4F  JSR L_JSR_($4F4E)_($1A27) BAD
$1A2A  20 45 4E  JSR L_JSR_($4E45)_($1A2A) BAD
$1A2D            .byte $54,$52
$1A2F  59 20 20  EOR $2020,Y 
$1A32  20 20 20  JSR $2020
$1A35  20 20 52  JSR L_JSR_($5220)_($1A35) OK
$1A38  45 4D     EOR $4D 
$1A3A            .byte $4F
$1A3B  56 45     LSR $45,X 
$1A3D  20 4C 49  JSR L_JSR_($494C)_($1A3D) BAD
$1A40            .byte $44
$1A41  20 20 20  JSR $2020
$1A44  20 20 20  JSR $2020
$1A47  50 4F     BVC L_BRS_($1A98)_($1A47) OK
$1A49  49 53     EOR #$53
$1A4B            .byte $4F
$1A4C  4E 20 41  LSR $4120 
$1A4F  49 52     EOR #$52
$1A51  20 20 20  JSR $2020
$1A54  20 20 20  JSR $2020
$1A57  4D 41 54  EOR $5441 
$1A5A            .byte $43
$1A5B  48        PHA 
$1A5C  20 4D 41  JSR L_JSR_($414D)_($1A5C) BAD
$1A5F            .byte $44
$1A60  45 20     EOR $20 
$1A62  20 20 47  JSR L_JSR_($4720)_($1A62) BAD
$1A65  41 4D     EOR ($4D,X) 
$1A67  45 20     EOR $20 
$1A69  20 4F 56  JSR L_JSR_($564F)_($1A69) BAD
$1A6C  45 52     EOR $52 
$1A6E  50 52     BVC L_BRS_($1AC2)_($1A6E) JAM
$1A70  45 53     EOR $53 
$1A72            .byte $53
$1A73  20 41 20  JSR L_JSR_($2041)_($1A73) OK
$1A76            .byte $4B
$1A77  45 59     EOR $59 
$1A79  20 20 53  JSR L_JSR_($5320)_($1A79) BAD
$1A7C  41 48     EOR ($48,X) 
$1A7E  41 52     EOR ($52,X) 
$1A80  41 48     EOR ($48,X) 
$1A82            .byte $4F,$52
$1A84  41 4B     EOR ($4B,X) 
$1A86  48        PHA 
$1A87            .byte $54
$1A88  59 4E 45  EOR $454E,Y 
$1A8B  50 48     BVC L_BRS_($1AD5)_($1A8B) BAD
$1A8D            .byte $54
$1A8E  48        PHA 
$1A8F  59 53 4B  EOR $4B53,Y 
$1A92  48        PHA 
$1A93  45 50     EOR $50 
$1A95            .byte $52
$1A96  45 53     EOR $53 
//------------------------------
L_BRS_($1A98)_($1A47) OK
//------------------------------
$1A98  48        PHA 
$1A99            .byte $52
$1A9A  41 4D     EOR ($4D,X) 
$1A9C  45 53     EOR $53 
$1A9E            .byte $53
$1A9F  45 53     EOR $53 
$1AA1  50 48     BVC L_BRS_($1AEB)_($1AA1) OK
$1AA3  41 52     EOR ($52,X) 
$1AA5  41 4F     EOR ($4F,X) 
$1AA7  48        PHA 
$1AA8            .byte $53
$1AA9  20 53 48  JSR L_JSR_($4853)_($1AA9) OK
$1AAC  41 42     EOR ($42,X) 
$1AAE  41 4B     EOR ($4B,X) 
$1AB0  41 49     EOR ($49,X) 
$1AB2  4C 4C 55  JMP L_JMP_($554C)_($1AB2) BAD
$1AB5            .byte $53
$1AB6  49 4F     EOR #$4F
$1AB8  4E 40 30  LSR $3040 
$1ABB            .byte $3A
$1ABC  20 20 20  JSR $2020
$1ABF  20 20 60  JSR L_JSR_($6020)_($1ABF) BAD
//------------------------------
L_BRS_($1AC2)_($1A6E) JAM
//------------------------------
$1AC2            .byte $54
$1AC3  45 05     EOR $05 
$1AC5            .byte $00,$00,$6B
$1AC8  FE 6A FE  INC $FE6A,X 
$1ACB  69 FE     ADC #$FE
$1ACD  68        PLA 
$1ACE  FE 2F FD  INC $FD2F,X 
$1AD1  2E FD 2D  ROL $2DFD 
//------------------------------
L_BRS_($1AD5)_($1A8B) BAD
//------------------------------
$1AD4  FD 2C FD  SBC $FD2C,X 
$1AD7            .byte $2B
$1AD8  FD 2A FD  SBC $FD2A,X 
$1ADB  29 FD     AND #$FD
$1ADD  28        PLP 
$1ADE  FD EF FB  SBC $FBEF,X 
$1AE1  EE FB ED  INC $EDFB 
$1AE4            .byte $FB
$1AE5  EC FB EB  CPX $EBFB 
$1AE8            .byte $FB
$1AE9  EA        NOP 
$1AEA            .byte $FB
//------------------------------
L_BRS_($1AEB)_($1AA1) OK
//------------------------------
$1AEB  E9 FB     SBC #$FB
$1AED  E8        INX 
$1AEE            .byte $FB,$AF,$FA
$1AF1  AE FA AD  LDX $ADFA 
$1AF4            .byte $FA
$1AF5  AC FA AB  LDY $ABFA 
$1AF8            .byte $FA
$1AF9  AA        TAX 
$1AFA            .byte $FA
$1AFB  A9 FA     LDA #$FA
$1AFD  A8        TAY 
$1AFE            .byte $FA,$6F
$1B00  F9 6E F9  SBC $F96E,Y 
$1B03  6D F9 6C  ADC $6CF9 
$1B06  F9 6B F9  SBC $F96B,Y 
$1B09  6A        ROR A 
$1B0A  F9 69 F9  SBC $F969,Y 
$1B0D  55 55     EOR $55,X 
$1B0F  56 5A     LSR $5A,X 
$1B11            .byte $5A,$5A
$1B13  56 56     LSR $56,X 
$1B15  55 55     EOR $55,X 
$1B17  65 A9     ADC $A9 
$1B19  A9 A9     LDA #$A9
$1B1B  A5 A5     LDA $A5 
$1B1D  55 55     EOR $55,X 
$1B1F  55 55     EOR $55,X 
$1B21  55 55     EOR $55,X 
$1B23  55 55     EOR $55,X 
$1B25  95 95     STA $95,X 
$1B27  55 55     EOR $55,X 
$1B29  55 55     EOR $55,X 
$1B2B  55 55     EOR $55,X 
$1B2D  59 6A 6A  EOR $6A6A,Y 
$1B30  6A        ROR A 
$1B31  6A        ROR A 
$1B32  6A        ROR A 
$1B33            .byte $5A,$5A
$1B35  59 6A AA  EOR $AA6A,Y 
$1B38  AA        TAX 
$1B39  AA        TAX 
//------------------------------
L_JSR_($1B3A)_($17B5) OK
//------------------------------
$1B3A  AA        TAX 
$1B3B  A9 A9     LDA #$A9
$1B3D  56 56     LSR $56,X 
$1B3F  55 55     EOR $55,X 
$1B41  55 55     EOR $55,X 
$1B43  55 55     EOR $55,X 
$1B45  A5 A5     LDA $A5 
$1B47  95 95     STA $95,X 
$1B49  55 55     EOR $55,X 
$1B4B  55 55     EOR $55,X 
$1B4D            .byte $33,$33,$CF,$CF,$3F,$3F,$3F,$3F
$1B55            .byte $FC,$FC,$FC,$FC,$FF,$FF,$FF,$FF
$1B5D            .byte $CF,$F3,$CF,$C3,$FF,$FF,$FF,$FF
$1B65            .byte $F3,$F3,$FC,$FC,$FF,$FF,$FF,$FF
$1B6D            .byte $FF,$FF,$FF,$F3
$1B71  CC F0 FC  CPY $FCF0 
$1B74            .byte $F3,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$1B7C            .byte $FF,$FF,$FF,$FF,$FF,$FF,$3F,$FF
$1B84            .byte $FF,$FF,$FF,$FF,$F3,$FC,$F3,$FC
$1B8C            .byte $F3,$FF,$FF,$FF,$3F,$3F,$3F,$3F
$1B94            .byte $CF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$1B9C            .byte $FC,$FF,$FF,$FF,$FF,$FF,$FF,$3F
$1BA4            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$1BAC            .byte $FC,$CF,$33,$33,$3C,$3F,$3F,$3C
$1BB4            .byte $3C,$FC,$FC,$FF,$FF,$3F
$1BBA  C0 F0     CPY #$F0
$1BBC            .byte $3F,$3F,$CF,$3F,$FF,$FF,$00,$03
//------------------------------
L_JSR_($1BC9)_($17D8) JAM
//------------------------------
$1BC4            .byte $FF,$FC,$F3,$F3,$CF,$3F,$FF,$CF
$1BCC            .byte $0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$1BD4            .byte $FF,$F3,$FF,$FF,$FF,$FF,$FF,$FF
$1BDC            .byte $FF,$3F,$FF,$FF,$FF,$FF,$FF,$FF
$1BE4            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$1BEC            .byte $FF,$FF,$CF,$CF,$CF,$0F,$CF,$FF
$1BF4            .byte $FF,$FF,$FF,$FF,$FC,$FF,$FF,$FF
//------------------------------
L_JSR_($1C02)_($4410) JAM
//------------------------------
$1BFC            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
//------------------------------
L_JSR_($1C05)_($BA8F) JAM
//------------------------------
$1C04            .byte $FF,$FF
$1C06  C0 CF     CPY #$CF
$1C08  C0 CF     CPY #$CF
$1C0A  C0 FF     CPY #$FF
//------------------------------
L_BRS_($1C10)_($1C1B) JAM
//------------------------------
$1C0C            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$1C14            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF
$1C1B  F0 F3     BEQ L_BRS_($1C10)_($1C1B) JAM
$1C1D            .byte $FF,$FF,$FF,$FF,$FF,$FF,$3F,$FF
$1C25            .byte $FF,$FF,$FF,$FF,$FF,$FF
$1C2B  FE FE EA  INC $EAFE,X 
$1C2E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C36            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C3E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C46            .byte $00,$00,$00,$00,$00,$00
$1C4C  20 2A 2A  JSR L_JSR_($2A2A)_($1C4C) BAD
$1C4F  2A        ROL A 
$1C50  2A        ROL A 
$1C51  2A        ROL A 
$1C52  2A        ROL A 
$1C53  2A        ROL A 
$1C54  2A        ROL A 
$1C55  2D 2A 20  AND $202A 
$1C58  2A        ROL A 
$1C59  2A        ROL A 
$1C5A  2A        ROL A 
$1C5B  20 00 00  JSR $0000
$1C5E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C66            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C6E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C76            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C7E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C86            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C8E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C96            .byte $00,$00,$00,$00,$00,$00,$00,$00
$1C9E            .byte $00,$00,$00,$00,$00
//------------------------------
L_JSR_($1CA3)_($3087) OK
L_JSR_($1CA3)_($35F1) OK
L_JSR_($1CA3)_($592E) OK
L_JSR_($1CA3)_($597C) OK
L_JSR_($1CA3)_($5AF5) OK
L_JSR_($1CA3)_($6211) OK
L_JSR_($1CA3)_($70E0) OK
//------------------------------
; 709 calls, 262376 clocks, 370 clocks per call
$1CA3  78        SEI 		; TODO: 16bit * 8bit signed multiply (2nd most called function)
$1CA4  85 88     STA $88 
$1CA6  86 89     STX $89 
$1CA8  84 8C     STY $8C 
$1CAA  A9 00     LDA #$00
$1CAC  8D 40 15  STA $1540 
$1CAF  85 82     STA $82 
$1CB1  85 83     STA $83 
$1CB3  85 84     STA $84 
$1CB5  85 85     STA $85 
$1CB7  98        TYA 
$1CB8  F0 70     BEQ L_BRS_($1D2A)_($1CB8) OK
$1CBA  10 0A     BPL L_BRS_($1CC6)_($1CBA) OK
$1CBC  A9 00     LDA #$00
$1CBE  38        SEC 
$1CBF  E5 8C     SBC $8C 
$1CC1  85 8C     STA $8C 
$1CC3  EE 40 15  INC $1540 
//------------------------------
L_BRS_($1CC6)_($1CBA) OK
//------------------------------
$1CC6  8A        TXA 
$1CC7  D0 07     BNE L_BRS_($1CD0)_($1CC7) OK
$1CC9  A5 88     LDA $88 
$1CCB  F0 5D     BEQ L_BRS_($1D2A)_($1CCB) OK
$1CCD  4C E2 1C  JMP L_JMP_($1CE2)_($1CCD) OK
//------------------------------
L_BRS_($1CD0)_($1CC7) OK
//------------------------------
$1CD0  10 10     BPL L_BRS_($1CE2)_($1CD0) OK
$1CD2  A9 00     LDA #$00
$1CD4  38        SEC 
$1CD5  E5 88     SBC $88 
$1CD7  85 88     STA $88 
$1CD9  A9 00     LDA #$00
$1CDB  E5 89     SBC $89 
$1CDD  85 89     STA $89 
$1CDF  EE 40 15  INC $1540 
//------------------------------
L_JMP_($1CE2)_($1CCD) OK
L_BRS_($1CE2)_($1CD0) OK
//------------------------------
$1CE2  A2 08     LDX #$08
//------------------------------
L_BRS_($1CE4)_($1D02) OK
//------------------------------
$1CE4  46 8C     LSR $8C 
$1CE6  90 13     BCC L_BRS_($1CFB)_($1CE6) OK
$1CE8  A5 82     LDA $82 
$1CEA  18        CLC 
$1CEB  65 88     ADC $88 
$1CED  85 82     STA $82 
$1CEF  A5 83     LDA $83 
$1CF1  65 89     ADC $89 
$1CF3  85 83     STA $83 
$1CF5  A5 84     LDA $84 
$1CF7  65 85     ADC $85 
$1CF9  85 84     STA $84 
//------------------------------
L_BRS_($1CFB)_($1CE6) OK
//------------------------------
$1CFB  06 88     ASL $88 
$1CFD  26 89     ROL $89 
$1CFF  26 85     ROL $85 
$1D01  CA        DEX 
$1D02  D0 E0     BNE L_BRS_($1CE4)_($1D02) OK
$1D04  AD 40 15  LDA $1540 
$1D07  F0 21     BEQ L_BRS_($1D2A)_($1D07) OK
$1D09  C9 02     CMP #$02
$1D0B  F0 1D     BEQ L_BRS_($1D2A)_($1D0B) OK
$1D0D  A9 FF     LDA #$FF
$1D0F  38        SEC 
$1D10  E5 84     SBC $84 
$1D12  85 84     STA $84 
$1D14  A9 FF     LDA #$FF
$1D16  E5 83     SBC $83 
$1D18  85 83     STA $83 
$1D1A  A9 FF     LDA #$FF
$1D1C  E5 82     SBC $82 
$1D1E  85 82     STA $82 
$1D20  E6 82     INC $82 
$1D22  D0 06     BNE L_BRS_($1D2A)_($1D22) OK
$1D24  E6 83     INC $83 
$1D26  D0 02     BNE L_BRS_($1D2A)_($1D26) OK
$1D28  E6 84     INC $84 
//------------------------------
L_BRS_($1D2A)_($1CB8) OK
L_BRS_($1D2A)_($1CCB) OK
L_BRS_($1D2A)_($1D07) OK
L_BRS_($1D2A)_($1D0B) OK
L_BRS_($1D2A)_($1D22) OK
L_BRS_($1D2A)_($1D26) OK
//------------------------------
$1D2A  AD C6 1A  LDA $1AC6 
$1D2D  D0 01     BNE L_BRS_($1D30)_($1D2D) OK
$1D2F  58        CLI 
//------------------------------
L_BRS_($1D30)_($1D2D) OK
//------------------------------
$1D30  60        RTS 
//------------------------------
L_JSR_($1D31)_($3134) OK
L_JSR_($1D31)_($3187) OK
L_JSR_($1D31)_($31FA) OK
L_JSR_($1D31)_($324D) OK
L_JSR_($1D31)_($32C0) OK
L_JSR_($1D31)_($3306) OK
L_JSR_($1D31)_($3379) OK
L_JSR_($1D31)_($33BF) OK
L_JSR_($1D31)_($3415) OK
L_JSR_($1D31)_($3457) OK
L_JSR_($1D31)_($3826) OK
L_JSR_($1D31)_($3857) OK
L_JSR_($1D31)_($4CDC) OK
L_JSR_($1D31)_($4DA8) OK
L_JSR_($1D31)_($530B) OK
L_JSR_($1D31)_($53BD) OK
L_JSR_($1D31)_($54FB) OK
L_JSR_($1D31)_($55A7) OK
L_JSR_($1D31)_($56C3) OK
L_JSR_($1D31)_($5761) OK
//------------------------------
$1D31  A9 00     LDA #$00	; TODO: 16bit * 16bit multiplication with 32 bit result
$1D33  8D 40 15  STA $1540 
$1D36  85 82     STA $82 
$1D38  85 83     STA $83 
$1D3A  85 84     STA $84 
$1D3C  85 85     STA $85 
$1D3E  A5 88     LDA $88 
$1D40  05 89     ORA $89
$1D42  D0 01     BNE L_BRS_($1D45)_($1D42) OK
//------------------------------
L_BRS_($1D44)_($1D49) OK
//------------------------------
$1D44  60        RTS 
//------------------------------
L_BRS_($1D45)_($1D42) OK
//------------------------------
$1D45  A5 8C     LDA $8C 
$1D47  05 8D     ORA $8D
$1D49  F0 F9     BEQ L_BRS_($1D44)_($1D49) OK
$1D4B  A5 8D     LDA $8D 
$1D4D  10 14     BPL L_BRS_($1D63)_($1D4D) OK
$1D4F  49 FF     EOR #$FF
$1D51  85 8D     STA $8D 
$1D53  A5 8C     LDA $8C 
$1D55  49 FF     EOR #$FF
$1D57  18        CLC 
$1D58  69 01     ADC #$01
$1D5A  85 8C     STA $8C 
$1D5C  90 02     BCC L_BRS_($1D60)_($1D5C) OK
$1D5E  E6 8D     INC $8D 
//------------------------------
L_BRS_($1D60)_($1D5C) OK
//------------------------------
$1D60  EE 40 15  INC $1540 
//------------------------------
L_BRS_($1D63)_($1D4D) OK
//------------------------------
$1D63  A5 89     LDA $89 
$1D65  10 14     BPL L_BRS_($1D7B)_($1D65) OK
$1D67  49 FF     EOR #$FF
$1D69  85 89     STA $89 
$1D6B  A5 88     LDA $88 
$1D6D  49 FF     EOR #$FF
$1D6F  18        CLC 
$1D70  69 01     ADC #$01
$1D72  85 88     STA $88 
$1D74  90 02     BCC L_BRS_($1D78)_($1D74) OK
$1D76  E6 89     INC $89 
//------------------------------
L_BRS_($1D78)_($1D74) OK
//------------------------------
$1D78  EE 40 15  INC $1540 
//------------------------------
L_BRS_($1D7B)_($1D65) OK
//------------------------------
$1D7B  A2 11     LDX #$11
$1D7D  18        CLC 
//------------------------------
L_BRS_($1D7E)_($1D96) OK
//------------------------------
$1D7E  66 85     ROR $85 
$1D80  66 84     ROR $84 
$1D82  66 89     ROR $89 
$1D84  66 88     ROR $88 
$1D86  90 0D     BCC L_BRS_($1D95)_($1D86) OK
$1D88  18        CLC 
$1D89  A5 8C     LDA $8C 
$1D8B  65 84     ADC $84 
$1D8D  85 84     STA $84 
$1D8F  A5 8D     LDA $8D 
$1D91  65 85     ADC $85 
$1D93  85 85     STA $85 
//------------------------------
L_BRS_($1D95)_($1D86) OK
//------------------------------
$1D95  CA        DEX 
$1D96  D0 E6     BNE L_BRS_($1D7E)_($1D96) OK
$1D98  AD 40 15  LDA $1540 
$1D9B  C9 01     CMP #$01
$1D9D  D0 28     BNE L_BRS_($1DC7)_($1D9D) OK
$1D9F  A5 85     LDA $85 
$1DA1  49 FF     EOR #$FF
$1DA3  85 85     STA $85 
$1DA5  A5 84     LDA $84 
$1DA7  49 FF     EOR #$FF
$1DA9  85 84     STA $84 
$1DAB  A5 89     LDA $89 
$1DAD  49 FF     EOR #$FF
$1DAF  85 83     STA $83 
$1DB1  A5 88     LDA $88 
$1DB3  49 FF     EOR #$FF
$1DB5  18        CLC 
$1DB6  69 01     ADC #$01
$1DB8  85 82     STA $82 
$1DBA  90 0A     BCC L_BRS_($1DC6)_($1DBA) OK
$1DBC  E6 83     INC $83 
$1DBE  D0 06     BNE L_BRS_($1DC6)_($1DBE) OK
$1DC0  E6 84     INC $84 
$1DC2  D0 02     BNE L_BRS_($1DC6)_($1DC2) OK
$1DC4  E6 85     INC $85 
//------------------------------
L_BRS_($1DC6)_($1DBA) OK
L_BRS_($1DC6)_($1DBE) OK
L_BRS_($1DC6)_($1DC2) OK
//------------------------------
$1DC6  60        RTS 
//------------------------------
L_BRS_($1DC7)_($1D9D) OK
//------------------------------
$1DC7  A5 89     LDA $89 
$1DC9  85 83     STA $83 
$1DCB  A5 88     LDA $88 
$1DCD  85 82     STA $82 
$1DCF  60        RTS 
//------------------------------
$1DD0  48        .byte 48
$1DD1  45		 .byte 45
//------------------------------
L_JSR_($1DD2)_($35B2) OK
L_JSR_($1DD2)_($3604) OK
L_JSR_($1DD2)_($61FC) OK
L_JSR_($1DD2)_($6260) OK
//------------------------------
; idea: 
; get position of most significant bit from dividend
; and then perform first loop of rol $89/rol $8a/rol $8b 
; (as rol $82/rol $83/rol $84 will be always 0 and 
; comparison of 84/83/82 vs 00/8D/8C will always skip subtraction)
; get position of most significant bit from divisor
; then perform rol $89/rol $8a/rol $8b/rol $82/rol $83/rol $84
; as comparison of 84/83/82 vs 00/8D/8C will always skip subtraction
; perform rest of iterations with full code
; 122 calls, 304496 clocks, 2495 clocks per call
$1DD2  85 88     STA $88 	; 1st most called function
$1DD4  86 89     STX $89 
$1DD6  84 8A     STY $8A 
$1DD8  A5 8A     LDA $8A 
$1DDA  8D D1 1D  STA $1DD1 
$1DDD  45 8D     EOR $8D 
$1DDF  8D D0 1D  STA $1DD0 
$1DE2  A5 8D     LDA $8D 
$1DE4  10 0D     BPL L_BRS_($1DF3)_($1DE4) OK
$1DE6  A9 00     LDA #$00
$1DE8  38        SEC 
$1DE9  E5 8C     SBC $8C 
$1DEB  85 8C     STA $8C 
$1DED  A9 00     LDA #$00
$1DEF  E5 8D     SBC $8D 
$1DF1  85 8D     STA $8D 
//------------------------------
L_BRS_($1DF3)_($1DE4) OK
//------------------------------
$1DF3  A5 8A     LDA $8A 
$1DF5  10 13     BPL L_BRS_($1E0A)_($1DF5) OK
$1DF7  A9 00     LDA #$00
$1DF9  38        SEC 
$1DFA  E5 88     SBC $88 
$1DFC  85 88     STA $88 
$1DFE  A9 00     LDA #$00
$1E00  E5 89     SBC $89 
$1E02  85 89     STA $89 
$1E04  A9 00     LDA #$00
$1E06  E5 8A     SBC $8A 
$1E08  85 8A     STA $8A 
//------------------------------
L_BRS_($1E0A)_($1DF5) OK
//------------------------------
$1E0A  A9 00     LDA #$00
$1E0C  85 82     STA $82 
$1E0E  85 83     STA $83 
$1E10  85 84     STA $84 
$1E12  A2 18     LDX #$18
$1E14  18        CLC 
//------------------------------
L_BRS_($1E15)_($1E3D) OK
//------------------------------
$1E15  26 88     ROL $88	; 5 
$1E17  26 89     ROL $89 	; 5
$1E19  26 8A     ROL $8A 	; 5
$1E1B  26 82     ROL $82 	; 5
$1E1D  26 83     ROL $83 	; 5
$1E1F  26 84     ROL $84 	; 5
$1E21  38        SEC 		; 2
$1E22  A5 82     LDA $82 	; 3
$1E24  E5 8C     SBC $8C 	; 3
$1E26  A8        TAY 		; 2
$1E27  A5 83     LDA $83 	; 3
$1E29  E5 8D     SBC $8D 	; 3
$1E2B  48        PHA 		; 3
$1E2C  A5 84     LDA $84 	; 3
$1E2E  E9 00     SBC #$00	; 2
$1E30  90 09     BCC L_BRS_($1E3B)_($1E30) OK ; 3/2
$1E32  85 84     STA $84 	; 3
$1E34  68        PLA 		; 4
$1E35  85 83     STA $83 	; 3
$1E37  84 82     STY $82 	; 3
$1E39  B0 01     BCS L_BRS_($1E3C)_($1E39) OK	; 3
//------------------------------
L_BRS_($1E3B)_($1E30) OK
//------------------------------
$1E3B  68        PLA 		; 4
//------------------------------
L_BRS_($1E3C)_($1E39) OK
//------------------------------
$1E3C  CA        DEX 		; 2
$1E3D  D0 D6     BNE L_BRS_($1E15)_($1E3D) OK ; 3 (61 or 76)*24 = 1464 or 1824, average = 1644
; eventually optimized version
; 8 loops with 3 rols/dex/bne = 8*(2+5+5+3+2+3)+7=8*20+7=167
; 8 loops with 6 rols/dex/bne = 8*(2+5*5+2+2+3)+7=8*34+7=279
; 8 loops full = 8*69 = 552
; total = 998
$1E3F  26 88     ROL $88 
$1E41  26 89     ROL $89 
$1E43  26 8A     ROL $8A 
$1E45  AD D0 1D  LDA $1DD0 
$1E48  10 13     BPL L_BRS_($1E5D)_($1E48) OK
$1E4A  A9 00     LDA #$00
$1E4C  38        SEC 
$1E4D  E5 88     SBC $88 
$1E4F  85 88     STA $88 
$1E51  A9 00     LDA #$00
$1E53  E5 89     SBC $89 
$1E55  85 89     STA $89 
$1E57  A9 00     LDA #$00
$1E59  E5 8A     SBC $8A 
$1E5B  85 8A     STA $8A 
//------------------------------
L_BRS_($1E5D)_($1E48) OK
//------------------------------
$1E5D  AD D1 1D  LDA $1DD1 
$1E60  10 13     BPL L_BRS_($1E75)_($1E60) OK
$1E62  A9 00     LDA #$00
$1E64  38        SEC 
$1E65  E5 82     SBC $82 
$1E67  85 82     STA $82 
$1E69  A9 00     LDA #$00
$1E6B  E5 83     SBC $83 
$1E6D  85 83     STA $83 
$1E6F  A9 00     LDA #$00
$1E71  E5 84     SBC $84 
$1E73  85 84     STA $84 
//------------------------------
L_BRS_($1E75)_($1E60) OK
//------------------------------
$1E75  60        RTS 
//------------------------------
L_JSR_($1E76)_($2FEA) OK
L_JSR_($1E76)_($45A7) OK
L_JSR_($1E76)_($487D) OK
L_JSR_($1E76)_($70F3) OK
L_JSR_($1E76)_($7101) OK
L_JSR_($1E76)_($710F) OK
L_JSR_($1E76)_($7D1F) OK
L_JSR_($1E76)_($7D3E) OK
//------------------------------
$1E76  A9 00     LDA #$00	; TODO: multiply signed 8-bit numbers
$1E78  8D 40 15  STA $1540 
$1E7B  85 83     STA $83 
$1E7D  85 82     STA $82 
$1E7F  8A        TXA 
$1E80  F0 5B     BEQ L_BRS_($1EDD)_($1E80) OK
$1E82  10 0B     BPL L_BRS_($1E8F)_($1E82) OK
$1E84  EE 40 15  INC $1540 
$1E87  85 84     STA $84 
$1E89  A9 00     LDA #$00
$1E8B  38        SEC 
$1E8C  E5 84     SBC $84 
$1E8E  AA        TAX 
//------------------------------
L_BRS_($1E8F)_($1E82) OK
//------------------------------
$1E8F  98        TYA 
$1E90  F0 4B     BEQ L_BRS_($1EDD)_($1E90) OK
$1E92  10 0A     BPL L_BRS_($1E9E)_($1E92) OK
$1E94  EE 40 15  INC $1540 
$1E97  85 84     STA $84 
$1E99  38        SEC 
$1E9A  A9 00     LDA #$00
$1E9C  E5 84     SBC $84 
//------------------------------
L_BRS_($1E9E)_($1E92) OK
//------------------------------
$1E9E  86 8C     STX $8C 
$1EA0  85 88     STA $88 
$1EA2  A2 08     LDX #$08
$1EA4  A9 00     LDA #$00
$1EA6  85 84     STA $84 
//------------------------------
L_BRS_($1EA8)_($1EBE) OK
//------------------------------
$1EA8  46 88     LSR $88 
$1EAA  90 0D     BCC L_BRS_($1EB9)_($1EAA) OK
$1EAC  A5 82     LDA $82 
$1EAE  18        CLC 
$1EAF  65 8C     ADC $8C 
$1EB1  85 82     STA $82 
$1EB3  A5 83     LDA $83 
$1EB5  65 84     ADC $84 
$1EB7  85 83     STA $83 
//------------------------------
L_BRS_($1EB9)_($1EAA) OK
//------------------------------
$1EB9  06 8C     ASL $8C 
$1EBB  26 84     ROL $84 
$1EBD  CA        DEX 
$1EBE  D0 E8     BNE L_BRS_($1EA8)_($1EBE) OK
$1EC0  AD 40 15  LDA $1540 
$1EC3  F0 18     BEQ L_BRS_($1EDD)_($1EC3) OK
$1EC5  C9 02     CMP #$02
$1EC7  F0 14     BEQ L_BRS_($1EDD)_($1EC7) OK
$1EC9  A9 FF     LDA #$FF
$1ECB  38        SEC 
$1ECC  E5 82     SBC $82 
$1ECE  85 82     STA $82 
$1ED0  A9 FF     LDA #$FF
$1ED2  38        SEC 
$1ED3  E5 83     SBC $83 
$1ED5  85 83     STA $83 
$1ED7  E6 82     INC $82 
$1ED9  D0 02     BNE L_BRS_($1EDD)_($1ED9) OK
$1EDB  E6 83     INC $83 
//------------------------------
L_BRS_($1EDD)_($1E80) OK
L_BRS_($1EDD)_($1E90) OK
L_BRS_($1EDD)_($1EC3) OK
L_BRS_($1EDD)_($1EC7) OK
L_BRS_($1EDD)_($1ED9) OK
//------------------------------
$1EDD  60        RTS 
//------------------------------
L_JSR_($1EDE)_($314F) OK
L_JSR_($1EDE)_($31A2) OK
L_JSR_($1EDE)_($3215) OK
L_JSR_($1EDE)_($3268) OK
L_JSR_($1EDE)_($32DB) OK
L_JSR_($1EDE)_($3321) OK
L_JSR_($1EDE)_($3394) OK
L_JSR_($1EDE)_($33DA) OK
L_JSR_($1EDE)_($3430) OK
L_JSR_($1EDE)_($3472) OK
L_JSR_($1EDE)_($4CF9) OK
L_JSR_($1EDE)_($4DC5) OK
L_JSR_($1EDE)_($5328) OK
L_JSR_($1EDE)_($53DA) OK
L_JSR_($1EDE)_($5518) OK
L_JSR_($1EDE)_($55C4) OK
L_JSR_($1EDE)_($56E0) OK
L_JSR_($1EDE)_($577E) OK
L_JSR_($1EDE)_($6853) OK
L_JSR_($1EDE)_($CBF5) OK
//------------------------------
; 55 calls, 102148 clocks, 1857 clocks per call
$1EDE  A9 00     LDA #$00	; TODO: 32bit/16bit Division
$1EE0  85 82     STA $82 
$1EE2  85 83     STA $83 
$1EE4  8D 40 15  STA $1540 
$1EE7  A5 88     LDA $88 
$1EE9  05 89     ORA $89
$1EEB  05 8A     ORA $8A
$1EED  05 8B     ORA $8B
$1EEF  D0 01     BNE L_BRS_($1EF2)_($1EEF) OK
$1EF1  60        RTS 
//------------------------------
L_BRS_($1EF2)_($1EEF) OK
//------------------------------
$1EF2  A5 8C     LDA $8C 
$1EF4  05 8D     ORA $8D
$1EF6  D0 01     BNE L_BRS_($1EF9)_($1EF6) OK
$1EF8  60        RTS 
//------------------------------
L_BRS_($1EF9)_($1EF6) OK
//------------------------------
$1EF9  A5 8B     LDA $8B 
$1EFB  10 1C     BPL L_BRS_($1F19)_($1EFB) OK
$1EFD  EE 40 15  INC $1540 
$1F00  A9 00     LDA #$00
$1F02  38        SEC 
$1F03  E5 88     SBC $88 
$1F05  85 88     STA $88 
$1F07  A9 00     LDA #$00
$1F09  E5 89     SBC $89 
$1F0B  85 89     STA $89 
$1F0D  A9 00     LDA #$00
$1F0F  E5 8A     SBC $8A 
$1F11  85 8A     STA $8A 
$1F13  A9 00     LDA #$00
$1F15  E5 8B     SBC $8B 
$1F17  85 8B     STA $8B 
//------------------------------
L_BRS_($1F19)_($1EFB) OK
//------------------------------
$1F19  A5 8D     LDA $8D 
$1F1B  10 14     BPL L_BRS_($1F31)_($1F1B) OK
$1F1D  EE 40 15  INC $1540 
$1F20  49 FF     EOR #$FF
$1F22  85 8D     STA $8D 
$1F24  A5 8C     LDA $8C 
$1F26  49 FF     EOR #$FF
$1F28  18        CLC 
$1F29  69 01     ADC #$01
$1F2B  85 8C     STA $8C 
$1F2D  90 02     BCC L_BRS_($1F31)_($1F2D) OK
$1F2F  E6 8D     INC $8D 
//------------------------------
L_BRS_($1F31)_($1F1B) OK
L_BRS_($1F31)_($1F2D) OK
//------------------------------
$1F31  A2 20     LDX #$20
$1F33  18        CLC 
//------------------------------
L_BRS_($1F34)_($1F55) OK
//------------------------------
$1F34  26 88     ROL $88 
$1F36  26 89     ROL $89 
$1F38  26 8A     ROL $8A 
$1F3A  26 8B     ROL $8B 
$1F3C  26 82     ROL $82 
$1F3E  26 83     ROL $83 
$1F40  38        SEC 
$1F41  A5 82     LDA $82 
$1F43  E5 8C     SBC $8C 
$1F45  A8        TAY 
$1F46  A5 83     LDA $83 
$1F48  E5 8D     SBC $8D 
$1F4A  90 08     BCC L_BRS_($1F54)_($1F4A) OK
$1F4C  85 83     STA $83 
$1F4E  98        TYA 
$1F4F  85 82     STA $82 
$1F51  4C 54 1F  JMP L_JMP_($1F54)_($1F51) OK
//------------------------------
L_BRS_($1F54)_($1F4A) OK
L_JMP_($1F54)_($1F51) OK
//------------------------------
$1F54  CA        DEX 
$1F55  D0 DD     BNE L_BRS_($1F34)_($1F55) OK
$1F57  26 88     ROL $88 
$1F59  26 89     ROL $89 
$1F5B  26 8A     ROL $8A 
$1F5D  26 8B     ROL $8B 
$1F5F  AD 40 15  LDA $1540 
$1F62  C9 01     CMP #$01
$1F64  D0 19     BNE L_BRS_($1F7F)_($1F64) OK
$1F66  A9 00     LDA #$00
$1F68  38        SEC 
$1F69  E5 88     SBC $88 
$1F6B  85 88     STA $88 
$1F6D  A9 00     LDA #$00
$1F6F  E5 89     SBC $89 
$1F71  85 89     STA $89 
$1F73  A9 00     LDA #$00
$1F75  E5 8A     SBC $8A 
$1F77  85 8A     STA $8A 
$1F79  A9 00     LDA #$00
$1F7B  E5 8B     SBC $8B 
$1F7D  85 8B     STA $8B 
//------------------------------
L_BRS_($1F7F)_($1F64) OK
//------------------------------
$1F7F  60        RTS 
//------------------------------
$1F80  20 33 33  JSR L_JSR_($3333)_($1F80) OK
$1F83  30 43     BMI L_BRS_($1FC8)_($1F83) OK
$1F85            .byte $33,$33,$43
//------------------------------
L_JSR_($1F88)_($40CE) OK
L_JSR_($1F88)_($4109) OK
L_JSR_($1F88)_($414F) OK
L_JSR_($1F88)_($43D2) OK
L_JSR_($1F88)_($67C4) OK
L_JSR_($1F88)_($7BFC) OK
L_JSR_($1F88)_($7C12) OK
L_JSR_($1F88)_($85D7) OK
//------------------------------
$1F88  AD 75 15  LDA $1575 
$1F8B  F0 08     BEQ L_BRS_($1F95)_($1F8B) OK
$1F8D  20 20 78  JSR L_JSR_($7820)_($1F8D) OK
$1F90  90 03     BCC L_BRS_($1F95)_($1F90) OK
$1F92  4C 04 20  JMP L_JMP_($2004)_($1F92) OK
//------------------------------
L_BRS_($1F95)_($1F8B) OK
L_BRS_($1F95)_($1F90) OK
//------------------------------
$1F95  AD 43 15  LDA $1543 
$1F98  29 04     AND #$04
$1F9A  D0 03     BNE L_BRS_($1F9F)_($1F9A) OK
$1F9C  4C F2 1F  JMP L_JMP_($1FF2)_($1F9C) OK
//------------------------------
L_BRS_($1F9F)_($1F9A) OK
//------------------------------
$1F9F  A9 01     LDA #$01
$1FA1  20 8B 7D  JSR L_JSR_($7D8B)_($1FA1) OK
$1FA4  20 9F 21  JSR L_JSR_($219F)_($1FA4) BAD
$1FA7  20 B9 23  JSR L_JSR_($23B9)_($1FA7) OK
$1FAA  A9 00     LDA #$00
$1FAC  8D 9B 17  STA $179B 
$1FAF  A9 38     LDA #$38
$1FB1  8D 99 17  STA $1799 
$1FB4  A9 17     LDA #$17
$1FB6  8D 9A 17  STA $179A 
$1FB9  AE 4B 15  LDX $154B 
$1FBC  F0 0D     BEQ L_BRS_($1FCB)_($1FBC) OK
$1FBE  AD 4C 15  LDA $154C 
$1FC1  85 80     STA $80 
$1FC3  AD 4D 15  LDA $154D 
$1FC6  85 81     STA $81 
//------------------------------
L_BRS_($1FC8)_($1F83) OK
//------------------------------
$1FC8  20 08 20  JSR L_JSR_($2008)_($1FC8) OK
//------------------------------
L_BRS_($1FCB)_($1FBC) OK
//------------------------------
$1FCB  A9 02     LDA #$02
$1FCD  20 8B 7D  JSR L_JSR_($7D8B)_($1FCD) OK
$1FD0  AE 49 1C  LDX $1C49 
$1FD3  F0 0D     BEQ L_BRS_($1FE2)_($1FD3) OK
$1FD5  AD 4A 1C  LDA $1C4A 
$1FD8  85 80     STA $80 
$1FDA  AD 4B 1C  LDA $1C4B 
$1FDD  85 81     STA $81 
$1FDF  20 08 20  JSR L_JSR_($2008)_($1FDF) OK
//------------------------------
L_BRS_($1FE2)_($1FD3) OK
//------------------------------
$1FE2  A9 03     LDA #$03
$1FE4  20 8B 7D  JSR L_JSR_($7D8B)_($1FE4) OK
$1FE7  20 AA 2C  JSR L_JSR_($2CAA)_($1FE7) OK
$1FEA  A9 04     LDA #$04
$1FEC  20 8B 7D  JSR L_JSR_($7D8B)_($1FEC) OK
$1FEF  4C F9 1F  JMP L_JMP_($1FF9)_($1FEF) OK
//------------------------------
L_JMP_($1FF2)_($1F9C) OK
//------------------------------
$1FF2  AD 44 15  LDA $1544 
$1FF5  29 08     AND #$08
$1FF7  F0 0B     BEQ L_BRS_($2004)_($1FF7) OK
//------------------------------
L_JMP_($1FF9)_($1FEF) OK
//------------------------------
$1FF9  20 E3 2D  JSR L_JSR_($2DE3)_($1FF9) BAD
$1FFC  20 7B 2E  JSR L_JSR_($2E7B)_($1FFC) OK
$1FFF  A9 05     LDA #$05
$2001  20 8B 7D  JSR L_JSR_($7D8B)_($2001) OK
//------------------------------
L_JMP_($2004)_($1F92) OK
L_BRS_($2004)_($1FF7) OK
//------------------------------
$2004  20 82 69  JSR L_JSR_($6982)_($2004) OK
$2007  60        RTS 
//------------------------------
L_JSR_($2008)_($1FC8) OK
L_JSR_($2008)_($1FDF) OK
//------------------------------
$2008  8E 86 1F  STX $1F86 
//------------------------------
L_JMP_($200B)_($2199) OK
//------------------------------
$200B  A5 80     LDA $80 
$200D  8D 7F 15  STA $157F 
//------------------------------
L_JSR_($2011)_($A3AB) BAD
//------------------------------
$2010  A5 81     LDA $81 
$2012  8D 80 15  STA $1580 
$2015  A0 00     LDY #$00
$2017  B1 80     LDA ($80),Y 
$2019  29 0F     AND #$0F
$201B  F0 0A     BEQ L_BRS_($2027)_($201B) OK
//------------------------------
L_JSR_($201E)_($A912) BAD
L_JSR_($201E)_($BB93) BAD
//------------------------------
$201D  C9 02     CMP #$02
$201F  F0 3A     BEQ L_BRS_($205B)_($201F) OK
$2021  B1 80     LDA ($80),Y 
$2023  29 40     AND #$40
$2025  F0 03     BEQ L_BRS_($202A)_($2025) OK
//------------------------------
L_JSR_($2027)_($19C4) OK
L_JSR_($2027)_($19D1) OK
L_BRS_($2027)_($201B) OK
//------------------------------
$2027  4C 7B 21  JMP L_JMP_($217B)_($2027) OK
//------------------------------
L_BRS_($202A)_($2025) OK
L_JSR_($202A)_($72F8) OK
L_JSR_($202A)_($730C) OK
//------------------------------
$202A  AD 35 17  LDA $1735 
$202D  D0 2C     BNE L_BRS_($205B)_($202D) OK
$202F  A2 00     LDX #$00
$2031  A9 03     LDA #$03
$2033  8D 85 1F  STA $1F85 
$2036  A0 01     LDY #$01
//------------------------------
L_BRS_($2038)_($2059) OK
//------------------------------
$2038  B1 80     LDA ($80),Y 
//------------------------------
L_JSR_($203A)_($71B2) OK
//------------------------------
$203A  DD 79 15  CMP $1579,X 
$203D  F0 05     BEQ L_BRS_($2044)_($203D) OK
$203F  30 03     BMI L_BRS_($2044)_($203F) OK
//------------------------------
L_JSR_($2041)_($1A73) OK
//------------------------------
$2041  4C 7B 21  JMP L_JMP_($217B)_($2041) OK
//------------------------------
L_BRS_($2044)_($203D) OK
L_BRS_($2044)_($203F) OK
//------------------------------
$2044  C8        INY 
//------------------------------
L_JMP_($2045)_($841E) OK
L_JMP_($2045)_($8424) OK
L_JMP_($2045)_($898C) OK
//------------------------------
$2045  C8        INY 
$2046  C8        INY 
$2047  18        CLC 
$2048  71 80     ADC ($80),Y 
$204A  E8        INX 
//------------------------------
L_JMP_($204C)_($197F) BAD
L_JMP_($204C)_($89A1) BAD
//------------------------------
$204B  DD 79 15  CMP $1579,X 
$204E  10 03     BPL L_BRS_($2053)_($204E) OK
$2050  4C 7B 21  JMP L_JMP_($217B)_($2050) OK
//------------------------------
L_BRS_($2053)_($204E) OK
//------------------------------
$2053  88        DEY 
$2054  88        DEY 
$2055  E8        INX 
$2056  CE 85 1F  DEC $1F85 
//------------------------------
L_JMP_($2059)_($0B68) OK
//------------------------------
$2059  D0 DD     BNE L_BRS_($2038)_($2059) OK
//------------------------------
L_BRS_($205B)_($201F) OK
L_BRS_($205B)_($202D) OK
//------------------------------
$205B  AD 98 15  LDA $1598 
$205E  85 7A     STA $7A 
$2060  AD 99 15  LDA $1599 
$2063  85 7B     STA $7B 
$2065  A9 00     LDA #$00
$2067  8D 87 1F  STA $1F87 
$206A  A9 03     LDA #$03
$206C  8D 84 1F  STA $1F84 
$206F  A2 00     LDX #$00
//------------------------------
L_JMP_($2071)_($212D) OK
L_JSR_($2072)_($9707) BAD
//------------------------------
$2071  A0 01     LDY #$01
$2073  BD 2E 1C  LDA $1C2E,X 
$2076  8D 80 1F  STA $1F80 
$2079  E8        INX 
$207A  BD 2E 1C  LDA $1C2E,X 
$207D  8D 82 1F  STA $1F82 
$2080  E8        INX 
$2081  A9 00     LDA #$00
$2083  8D 81 1F  STA $1F81 
$2086  B1 80     LDA ($80),Y 
$2088  4A        LSR A 
$2089  6E 81 1F  ROR $1F81 
$208C  4A        LSR A 
$208D  6E 81 1F  ROR $1F81 
$2090  8D 83 1F  STA $1F83 
$2093  AD 81 1F  LDA $1F81 
$2096  38        SEC 
$2097  ED 80 1F  SBC $1F80 
$209A  8D 81 1F  STA $1F81 
$209D  AD 83 1F  LDA $1F83 
$20A0  ED 82 1F  SBC $1F82 
$20A3  8D 83 1F  STA $1F83 
$20A6  30 0F     BMI L_BRS_($20B7)_($20A6) OK
$20A8  D0 05     BNE L_BRS_($20AF)_($20A8) OK
$20AA  AD 81 1F  LDA $1F81 
$20AD  F0 08     BEQ L_BRS_($20B7)_($20AD) OK
//------------------------------
L_BRS_($20AF)_($20A8) OK
//------------------------------
$20AF  A9 40     LDA #$40
$20B1  0D 87 1F  ORA $1F87
$20B4  8D 87 1F  STA $1F87 
//------------------------------
L_BRS_($20B7)_($20A6) OK
L_BRS_($20B7)_($20AD) OK
//------------------------------
$20B7  A0 00     LDY #$00
$20B9  4E 87 1F  LSR $1F87 
$20BC  AD 81 1F  LDA $1F81 
$20BF  91 7A     STA ($7A),Y 
$20C1  AD 83 1F  LDA $1F83 
$20C4  C8        INY 
$20C5  91 7A     STA ($7A),Y 
$20C7  C8        INY 
$20C8  98        TYA 
$20C9  18        CLC 
$20CA  65 7A     ADC $7A 
$20CC  85 7A     STA $7A 
$20CE  A5 7B     LDA $7B 
$20D0  69 00     ADC #$00
$20D2  85 7B     STA $7B 
$20D4  A9 00     LDA #$00
$20D6  8D 80 1F  STA $1F80 
$20D9  A0 04     LDY #$04
$20DB  B1 80     LDA ($80),Y 
$20DD  4A        LSR A 
$20DE  6E 80 1F  ROR $1F80 
$20E1  4A        LSR A 
$20E2  6E 80 1F  ROR $1F80 
$20E5  8D 82 1F  STA $1F82 
$20E8  AD 80 1F  LDA $1F80 
$20EB  18        CLC 
$20EC  6D 81 1F  ADC $1F81 
$20EF  8D 81 1F  STA $1F81 
$20F2  AD 82 1F  LDA $1F82 
$20F5  6D 83 1F  ADC $1F83 
$20F8  8D 83 1F  STA $1F83 
$20FB  10 08     BPL L_BRS_($2105)_($20FB) OK
$20FD  A9 40     LDA #$40
$20FF  0D 87 1F  ORA $1F87
$2102  8D 87 1F  STA $1F87 
//------------------------------
L_BRS_($2105)_($20FB) OK
//------------------------------
$2105  4E 87 1F  LSR $1F87 
$2108  A0 00     LDY #$00
$210A  AD 81 1F  LDA $1F81 
$210D  91 7A     STA ($7A),Y 
$210F  C8        INY 
$2110  AD 83 1F  LDA $1F83 
$2113  91 7A     STA ($7A),Y 
$2115  C8        INY 
$2116  98        TYA 
$2117  18        CLC 
$2118  65 7A     ADC $7A 
$211A  85 7A     STA $7A 
$211C  A5 7B     LDA $7B 
$211E  69 00     ADC #$00
$2120  85 7B     STA $7B 
$2122  E6 80     INC $80 
$2124  D0 02     BNE L_BRS_($2128)_($2124) OK
$2126  E6 81     INC $81 
//------------------------------
L_BRS_($2128)_($2124) OK
//------------------------------
$2128  CE 84 1F  DEC $1F84 
$212B  F0 03     BEQ L_BRS_($2130)_($212B) OK
$212D  4C 71 20  JMP L_JMP_($2071)_($212D) OK
//------------------------------
L_BRS_($2130)_($212B) OK
//------------------------------
$2130  AD 87 1F  LDA $1F87 
$2133  8D 3F 15  STA $153F 
$2136  AD 7F 15  LDA $157F 
$2139  85 80     STA $80 
$213B  AD 80 15  LDA $1580 
$213E  85 81     STA $81 
$2140  A0 07     LDY #$07
$2142  B1 80     LDA ($80),Y 
$2144  8D 46 15  STA $1546 
$2147  A0 00     LDY #$00
$2149  B1 80     LDA ($80),Y 
$214B  29 0F     AND #$0F
$214D  8D 52 15  STA $1552 
$2150  C9 01     CMP #$01
$2152  D0 06     BNE L_BRS_($215A)_($2152) OK
$2154  20 65 24  JSR L_JSR_($2465)_($2154) BAD
$2157  4C 7B 21  JMP L_JMP_($217B)_($2157) OK
//------------------------------
L_BRS_($215A)_($2152) OK
//------------------------------
$215A  C9 02     CMP #$02
$215C  D0 06     BNE L_BRS_($2164)_($215C) OK
$215E  20 46 2B  JSR L_JSR_($2B46)_($215E) OK
$2161  4C 7B 21  JMP L_JMP_($217B)_($2161) OK
//------------------------------
L_BRS_($2164)_($215C) OK
//------------------------------
$2164  C9 03     CMP #$03
$2166  D0 06     BNE L_BRS_($216E)_($2166) OK
$2168  20 60 2A  JSR L_JSR_($2A60)_($2168) BAD
$216B  4C 7B 21  JMP L_JMP_($217B)_($216B) OK
//------------------------------
L_BRS_($216E)_($2166) OK
//------------------------------
$216E  C9 0A     CMP #$0A
$2170  B0 06     BCS L_BRS_($2178)_($2170) OK
$2172  20 72 25  JSR L_JSR_($2572)_($2172) OK
$2175  4C 7B 21  JMP L_JMP_($217B)_($2175) OK
//------------------------------
L_BRS_($2178)_($2170) OK
//------------------------------
$2178  20 9E 29  JSR L_JSR_($299E)_($2178) OK
//------------------------------
L_JMP_($217B)_($2027) OK
L_JMP_($217B)_($2041) OK
L_JMP_($217B)_($2050) OK
L_JMP_($217B)_($2157) OK
L_JMP_($217B)_($2161) OK
L_JMP_($217B)_($216B) OK
L_JMP_($217B)_($2175) OK
//------------------------------
$217B  AD 7F 15  LDA $157F 
$217E  85 80     STA $80 
$2180  AD 80 15  LDA $1580 
$2183  85 81     STA $81 
$2185  A0 08     LDY #$08
$2187  B1 80     LDA ($80),Y 
$2189  18        CLC 
$218A  65 80     ADC $80 
$218C  85 80     STA $80 
$218E  A5 81     LDA $81 
$2190  69 00     ADC #$00
$2192  85 81     STA $81 
$2194  CE 86 1F  DEC $1F86 
$2197  F0 03     BEQ L_BRS_($219C)_($2197) OK
$2199  4C 0B 20  JMP L_JMP_($200B)_($2199) OK
//------------------------------
L_BRS_($219C)_($2197) OK
//------------------------------
$219C  60        RTS 
//------------------------------
$219D  0A        ASL A 
//------------------------------
L_JSR_($219F)_($1FA4) BAD
//------------------------------
$219E  09 AD     ORA #$AD
$21A0  35 17     AND $17,X 
$21A2  F0 03     BEQ L_BRS_($21A7)_($21A2) OK
$21A4  4C A6 23  JMP L_JMP_($23A6)_($21A4) OK
//------------------------------
L_BRS_($21A7)_($21A2) OK
//------------------------------
$21A7  A2 00     LDX #$00
$21A9  A9 06     LDA #$06
$21AB  8D 9D 21  STA $219D 
$21AE  A9 FF     LDA #$FF
//------------------------------
L_BRS_($21B0)_($21B7) OK
//------------------------------
$21B0  9D 79 15  STA $1579,X 
$21B3  E8        INX 
$21B4  CE 9D 21  DEC $219D 
$21B7  D0 F7     BNE L_BRS_($21B0)_($21B7) OK
$21B9  A9 04     LDA #$04
$21BB  8D 9D 21  STA $219D 
//------------------------------
L_JMP_($21BE)_($2316) OK
//------------------------------
$21BE  AD 9D 21  LDA $219D 
$21C1  C9 01     CMP #$01
$21C3  F0 04     BEQ L_BRS_($21C9)_($21C3) OK
$21C5  C9 02     CMP #$02
$21C7  D0 11     BNE L_BRS_($21DA)_($21C7) OK
//------------------------------
L_BRS_($21C9)_($21C3) OK
//------------------------------
$21C9  AD 39 1C  LDA $1C39 
$21CC  18        CLC 
$21CD  69 08     ADC #$08
$21CF  C9 48     CMP #$48
$21D1  30 03     BMI L_BRS_($21D6)_($21D1) OK
$21D3  38        SEC 
$21D4  E9 48     SBC #$48
//------------------------------
L_BRS_($21D6)_($21D1) OK
//------------------------------
$21D6  AA        TAX 
$21D7  AD 9D 21  LDA $219D 
//------------------------------
L_BRS_($21DA)_($21C7) OK
//------------------------------
$21DA  C9 01     CMP #$01
$21DC  F0 04     BEQ L_BRS_($21E2)_($21DC) OK
$21DE  C9 03     CMP #$03
$21E0  D0 11     BNE L_BRS_($21F3)_($21E0) OK
//------------------------------
L_BRS_($21E2)_($21DC) OK
//------------------------------
$21E2  AD 38 1C  LDA $1C38 
$21E5  18        CLC 
$21E6  69 08     ADC #$08
$21E8  C9 48     CMP #$48
$21EA  30 03     BMI L_BRS_($21EF)_($21EA) OK
$21EC  38        SEC 
$21ED  E9 48     SBC #$48
//------------------------------
L_BRS_($21EF)_($21EA) OK
//------------------------------
$21EF  A8        TAY 
$21F0  AD 9D 21  LDA $219D 
//------------------------------
L_BRS_($21F3)_($21E0) OK
//------------------------------
$21F3  C9 03     CMP #$03
$21F5  F0 04     BEQ L_BRS_($21FB)_($21F5) OK
$21F7  C9 04     CMP #$04
$21F9  D0 0F     BNE L_BRS_($220A)_($21F9) OK
//------------------------------
L_BRS_($21FB)_($21F5) OK
//------------------------------
$21FB  AD 39 1C  LDA $1C39 
$21FE  38        SEC 
$21FF  E9 08     SBC #$08
$2201  10 03     BPL L_BRS_($2206)_($2201) OK
$2203  18        CLC 
$2204  69 48     ADC #$48
//------------------------------
L_BRS_($2206)_($2201) OK
//------------------------------
$2206  AA        TAX 
$2207  AD 9D 21  LDA $219D 
//------------------------------
L_BRS_($220A)_($21F9) OK
//------------------------------
$220A  C9 02     CMP #$02
$220C  F0 04     BEQ L_BRS_($2212)_($220C) OK
$220E  C9 04     CMP #$04
$2210  D0 0C     BNE L_BRS_($221E)_($2210) OK
//------------------------------
L_BRS_($2212)_($220C) OK
//------------------------------
$2212  AD 38 1C  LDA $1C38 
$2215  38        SEC 
$2216  E9 08     SBC #$08
$2218  10 03     BPL L_BRS_($221D)_($2218) OK
$221A  18        CLC 
$221B  69 48     ADC #$48
//------------------------------
L_BRS_($221D)_($2218) OK
//------------------------------
$221D  A8        TAY 
//------------------------------
L_BRS_($221E)_($2210) OK
//------------------------------
$221E  8A        TXA 
$221F  C9 12     CMP #$12
$2221  10 05     BPL L_BRS_($2228)_($2221) OK
$2223  A2 01     LDX #$01
$2225  4C 3C 22  JMP L_JMP_($223C)_($2225) OK
//------------------------------
L_BRS_($2228)_($2221) OK
//------------------------------
$2228  C9 24     CMP #$24
$222A  10 05     BPL L_BRS_($2231)_($222A) OK
$222C  A2 03     LDX #$03
$222E  4C 3C 22  JMP L_JMP_($223C)_($222E) OK
//------------------------------
L_BRS_($2231)_($222A) OK
//------------------------------
$2231  C9 36     CMP #$36
$2233  10 05     BPL L_BRS_($223A)_($2233) OK
$2235  A2 05     LDX #$05
$2237  4C 3C 22  JMP L_JMP_($223C)_($2237) OK
//------------------------------
L_BRS_($223A)_($2233) OK
//------------------------------
$223A  A2 07     LDX #$07
//------------------------------
L_JMP_($223C)_($2225) OK
L_JMP_($223C)_($222E) OK
L_JMP_($223C)_($2237) OK
//------------------------------
$223C  98        TYA 
$223D  C9 12     CMP #$12
$223F  10 04     BPL L_BRS_($2245)_($223F) OK
$2241  E8        INX 
$2242  4C 61 22  JMP L_JMP_($2261)_($2242) OK
//------------------------------
L_BRS_($2245)_($223F) OK
//------------------------------
$2245  C9 24     CMP #$24
$2247  10 05     BPL L_BRS_($224E)_($2247) OK
$2249  A9 05     LDA #$05
$224B  4C 54 22  JMP L_JMP_($2254)_($224B) OK
//------------------------------
L_BRS_($224E)_($2247) OK
//------------------------------
$224E  C9 36     CMP #$36
$2250  10 0F     BPL L_BRS_($2261)_($2250) OK
$2252  A9 04     LDA #$04
//------------------------------
L_JMP_($2254)_($224B) OK
//------------------------------
$2254  86 82     STX $82 
$2256  18        CLC 
$2257  65 82     ADC $82 
$2259  C9 09     CMP #$09
$225B  30 03     BMI L_BRS_($2260)_($225B) OK
$225D  38        SEC 
$225E  E9 08     SBC #$08
//------------------------------
L_BRS_($2260)_($225B) OK
//------------------------------
$2260  AA        TAX 
//------------------------------
L_JMP_($2261)_($2242) OK
L_BRS_($2261)_($2250) OK
//------------------------------
$2261  CA        DEX 
$2262  8A        TXA 
$2263  0A        ASL A 
$2264  AA        TAX 
$2265  BD 74 22  LDA $2274,X 
$2268  8D 72 22  STA $2272 
$226B  BD 75 22  LDA $2275,X 
$226E  8D 73 22  STA $2273 
$2271  4C FF FF  JMP L_JMP_($FFFF)_($2271) JAM
$2274  84 22     STY $22 
$2276  96 22     STX $22,Y 
$2278  A8        TAY 
$2279            .byte $22
$227A  BA        TSX 
$227B            .byte $22
$227C  CC 22 DE  CPY $DE22 
$227F            .byte $22
$2280  F0 22     BEQ L_BRS_($22A4)_($2280) BAD
$2282            .byte $02,$23
$2284  A9 7F     LDA #$7F
$2286  8D 79 15  STA $1579 
$2289  A9 3F     LDA #$3F
$228B  8D 7B 15  STA $157B 
$228E  A9 7F     LDA #$7F
$2290  8D 7D 15  STA $157D 
$2293  4C 11 23  JMP L_JMP_($2311)_($2293) OK
$2296  A9 7F     LDA #$7F
$2298  8D 79 15  STA $1579 
$229B  A9 00     LDA #$00
$229D  8D 7C 15  STA $157C 
$22A0  A9 7F     LDA #$7F
//------------------------------
L_BRS_($22A4)_($2280) BAD
//------------------------------
$22A2  8D 7D 15  STA $157D 
$22A5  4C 11 23  JMP L_JMP_($2311)_($22A5) OK
$22A8  A9 7F     LDA #$7F
$22AA  8D 79 15  STA $1579 
$22AD  A9 3F     LDA #$3F
$22AF  8D 7B 15  STA $157B 
$22B2  A9 00     LDA #$00
$22B4  8D 7E 15  STA $157E 
$22B7  4C 11 23  JMP L_JMP_($2311)_($22B7) OK
$22BA  A9 7F     LDA #$7F
$22BC  8D 79 15  STA $1579 
$22BF  A9 00     LDA #$00
$22C1  8D 7C 15  STA $157C 
$22C4  A9 00     LDA #$00
$22C6  8D 7E 15  STA $157E 
$22C9  4C 11 23  JMP L_JMP_($2311)_($22C9) OK
$22CC  A9 00     LDA #$00
$22CE  8D 7A 15  STA $157A 
$22D1  A9 3F     LDA #$3F
$22D3  8D 7B 15  STA $157B 
$22D6  A9 00     LDA #$00
$22D8  8D 7E 15  STA $157E 
$22DB  4C 11 23  JMP L_JMP_($2311)_($22DB) OK
$22DE  A9 00     LDA #$00
$22E0  8D 7A 15  STA $157A 
$22E3  A9 00     LDA #$00
$22E5  8D 7C 15  STA $157C 
$22E8  A9 00     LDA #$00
$22EA  8D 7E 15  STA $157E 
$22ED  4C 11 23  JMP L_JMP_($2311)_($22ED) OK
$22F0  A9 00     LDA #$00
$22F2  8D 7A 15  STA $157A 
$22F5  A9 3F     LDA #$3F
$22F7  8D 7B 15  STA $157B 
$22FA  A9 7F     LDA #$7F
$22FC  8D 7D 15  STA $157D 
$22FF  4C 11 23  JMP L_JMP_($2311)_($22FF) OK
$2302  A9 00     LDA #$00
$2304  8D 7A 15  STA $157A 
$2307  A9 00     LDA #$00
$2309  8D 7C 15  STA $157C 
$230C  A9 7F     LDA #$7F
$230E  8D 7D 15  STA $157D 
//------------------------------
L_JMP_($2311)_($2293) OK
L_JMP_($2311)_($22A5) OK
L_JMP_($2311)_($22B7) OK
L_JMP_($2311)_($22C9) OK
L_JMP_($2311)_($22DB) OK
L_JMP_($2311)_($22ED) OK
L_JMP_($2311)_($22FF) OK
//------------------------------
$2311  CE 9D 21  DEC $219D 
$2314  F0 03     BEQ L_BRS_($2319)_($2314) OK
$2316  4C BE 21  JMP L_JMP_($21BE)_($2316) OK
//------------------------------
L_BRS_($2319)_($2314) OK
//------------------------------
$2319  AD 2F 1C  LDA $1C2F 
$231C  8D 9E 21  STA $219E 
$231F  AD 2E 1C  LDA $1C2E 
$2322  0A        ASL A 
$2323  2E 9E 21  ROL $219E 
$2326  0A        ASL A 
$2327  2E 9E 21  ROL $219E 
$232A  AD 79 15  LDA $1579 
$232D  C9 FF     CMP #$FF
$232F  D0 0A     BNE L_BRS_($233B)_($232F) OK
$2331  AE 9E 21  LDX $219E 
$2334  E8        INX 
$2335  8E 79 15  STX $1579 
$2338  4C 48 23  JMP L_JMP_($2348)_($2338) OK
//------------------------------
L_BRS_($233B)_($232F) OK
//------------------------------
$233B  AD 7A 15  LDA $157A 
$233E  C9 FF     CMP #$FF
$2340  D0 06     BNE L_BRS_($2348)_($2340) OK
$2342  AD 9E 21  LDA $219E 
$2345  8D 7A 15  STA $157A 
//------------------------------
L_JMP_($2348)_($2338) OK
L_BRS_($2348)_($2340) OK
//------------------------------
$2348  AD 31 1C  LDA $1C31 
$234B  8D 9E 21  STA $219E 
$234E  AD 30 1C  LDA $1C30 
$2351  0A        ASL A 
$2352  2E 9E 21  ROL $219E 
$2355  0A        ASL A 
$2356  2E 9E 21  ROL $219E 
$2359  AD 7B 15  LDA $157B 
$235C  C9 FF     CMP #$FF
$235E  D0 0A     BNE L_BRS_($236A)_($235E) OK
$2360  AE 9E 21  LDX $219E 
$2363  E8        INX 
$2364  8E 7B 15  STX $157B 
$2367  4C 77 23  JMP L_JMP_($2377)_($2367) OK
//------------------------------
L_BRS_($236A)_($235E) OK
//------------------------------
$236A  AD 7C 15  LDA $157C 
$236D  C9 FF     CMP #$FF
$236F  D0 06     BNE L_BRS_($2377)_($236F) OK
$2371  AD 9E 21  LDA $219E 
$2374  8D 7C 15  STA $157C 
//------------------------------
L_JMP_($2377)_($2367) OK
L_BRS_($2377)_($236F) OK
//------------------------------
$2377  AD 33 1C  LDA $1C33 
$237A  8D 9E 21  STA $219E 
$237D  AD 32 1C  LDA $1C32 
$2380  0A        ASL A 
$2381  2E 9E 21  ROL $219E 
$2384  0A        ASL A 
$2385  2E 9E 21  ROL $219E 
$2388  AD 7D 15  LDA $157D 
$238B  C9 FF     CMP #$FF
$238D  D0 0A     BNE L_BRS_($2399)_($238D) OK
$238F  AE 9E 21  LDX $219E 
$2392  E8        INX 
$2393  8E 7D 15  STX $157D 
$2396  4C A6 23  JMP L_JMP_($23A6)_($2396) OK
//------------------------------
L_BRS_($2399)_($238D) OK
//------------------------------
$2399  AD 7E 15  LDA $157E 
$239C  C9 FF     CMP #$FF
$239E  D0 06     BNE L_BRS_($23A6)_($239E) OK
$23A0  AE 9E 21  LDX $219E 
$23A3  8E 7E 15  STX $157E 
//------------------------------
L_JMP_($23A6)_($21A4) OK
L_JMP_($23A6)_($2396) OK
L_BRS_($23A6)_($239E) OK
//------------------------------
$23A6  60        RTS 
//------------------------------
$23A7  40        RTI 
//------------------------------
$23A8            .byte $00,$00,$00
$23AB  40        RTI 
//------------------------------
$23AC            .byte $00,$00,$00
$23AF  40        RTI 
//------------------------------
$23B0  19 00 00  ORA $0000,Y
$23B3            .byte $00
$23B4  40        RTI 
//------------------------------
$23B5            .byte $00,$00,$00,$14
//------------------------------
L_JSR_($23B9)_($1FA7) OK
//------------------------------
$23B9  A2 09     LDX #$09
//------------------------------
L_BRS_($23BB)_($23C2) OK
//------------------------------
$23BB  BD A6 23  LDA $23A6,X 
$23BE  9D 55 15  STA $1555,X 
$23C1  CA        DEX 
$23C2  D0 F7     BNE L_BRS_($23BB)_($23C2) OK
$23C4  AD 39 1C  LDA $1C39 
$23C7  F0 2B     BEQ L_BRS_($23F4)_($23C7) OK
$23C9  A2 09     LDX #$09
//------------------------------
L_BRS_($23CB)_($23D2) OK
//------------------------------
$23CB  BD A6 23  LDA $23A6,X 
$23CE  9D 5E 15  STA $155E,X 
$23D1  CA        DEX 
$23D2  D0 F7     BNE L_BRS_($23CB)_($23D2) OK
$23D4  AD 39 1C  LDA $1C39 
$23D7  0A        ASL A 
$23D8  AA        TAX 
$23D9  BD 9C 17  LDA $179C,X 
$23DC  8D 65 15  STA $1565 
$23DF  A9 00     LDA #$00
$23E1  38        SEC 
$23E2  ED 65 15  SBC $1565 
$23E5  8D 61 15  STA $1561 
$23E8  BD 9D 17  LDA $179D,X 
$23EB  8D 5F 15  STA $155F 
$23EE  8D 67 15  STA $1567 
$23F1  20 C6 2F  JSR L_JSR_($2FC6)_($23F1) OK
//------------------------------
L_BRS_($23F4)_($23C7) OK
//------------------------------
$23F4  AD 38 1C  LDA $1C38 
$23F7  F0 2B     BEQ L_BRS_($2424)_($23F7) OK
$23F9  A2 09     LDX #$09
//------------------------------
L_BRS_($23FB)_($2402) OK
//------------------------------
$23FB  BD A6 23  LDA $23A6,X 
$23FE  9D 5E 15  STA $155E,X 
$2401  CA        DEX 
$2402  D0 F7     BNE L_BRS_($23FB)_($2402) OK
$2404  AD 38 1C  LDA $1C38 
$2407  0A        ASL A 
$2408  AA        TAX 
$2409  BD 9C 17  LDA $179C,X 
$240C  8D 64 15  STA $1564 
$240F  A9 00     LDA #$00
$2411  38        SEC 
$2412  ED 64 15  SBC $1564 
$2415  8D 66 15  STA $1566 
$2418  BD 9D 17  LDA $179D,X 
$241B  8D 63 15  STA $1563 
$241E  8D 67 15  STA $1567 
$2421  20 C6 2F  JSR L_JSR_($2FC6)_($2421) OK
//------------------------------
L_BRS_($2424)_($23F7) OK
//------------------------------
$2424  A2 09     LDX #$09
//------------------------------
L_BRS_($2426)_($242D) OK
//------------------------------
$2426  BD AF 23  LDA $23AF,X 
$2429  9D 5E 15  STA $155E,X 
$242C  CA        DEX 
$242D  D0 F7     BNE L_BRS_($2426)_($242D) OK
$242F  20 C6 2F  JSR L_JSR_($2FC6)_($242F) OK
$2432  AD 92 15  LDA $1592 
$2435  8D 98 15  STA $1598 
$2438  AD 93 15  LDA $1593 
$243B  8D 99 15  STA $1599 
$243E  AD 90 15  LDA $1590 
$2441  8D 96 15  STA $1596 
$2444  AD 91 15  LDA $1591 
$2447  8D 97 15  STA $1597 
$244A  AD 94 15  LDA $1594 
$244D  18        CLC 
$244E  69 04     ADC #$04
$2450  8D 9A 15  STA $159A 
$2453  AD 95 15  LDA $1595 
$2456  69 00     ADC #$00
$2458  8D 9B 15  STA $159B 
$245B  A9 00     LDA #$00
$245D  8D 54 15  STA $1554 
$2460  8D 55 15  STA $1555 
$2463  60        RTS 
//------------------------------
L_JSR_($2465)_($2154) BAD
//------------------------------
$2464  41 A0     EOR ($A0,X) 
$2466            .byte $0B
$2467  AD 98 15  LDA $1598 
$246A  85 80     STA $80 
$246C  AD 99 15  LDA $1599 
$246F  85 81     STA $81 
$2471  B1 80     LDA ($80),Y 
$2473  85 1F     STA $1F 
$2475  85 25     STA $25 
$2477  85 2B     STA $2B 
$2479  85 31     STA $31 
$247B  88        DEY 
$247C  B1 80     LDA ($80),Y 
$247E  85 1E     STA $1E 
$2480  85 24     STA $24 
$2482  85 2A     STA $2A 
$2484  85 30     STA $30 
$2486  88        DEY 
$2487  B1 80     LDA ($80),Y 
$2489  85 07     STA $07 
$248B  85 0D     STA $0D 
$248D  85 13     STA $13 
$248F  85 19     STA $19 
$2491  88        DEY 
$2492  B1 80     LDA ($80),Y 
$2494  85 06     STA $06 
$2496  85 0C     STA $0C 
$2498  85 12     STA $12 
$249A  85 18     STA $18 
$249C  88        DEY 
$249D  B1 80     LDA ($80),Y 
$249F  85 11     STA $11 
$24A1  85 17     STA $17 
$24A3  85 29     STA $29 
$24A5  85 2F     STA $2F 
$24A7  88        DEY 
$24A8  B1 80     LDA ($80),Y 
$24AA  85 10     STA $10 
$24AC  85 16     STA $16 
$24AE  85 28     STA $28 
$24B0  85 2E     STA $2E 
$24B2  88        DEY 
$24B3  B1 80     LDA ($80),Y 
$24B5  85 05     STA $05 
$24B7  85 0B     STA $0B 
$24B9  85 1D     STA $1D 
$24BB  85 23     STA $23 
$24BD  88        DEY 
$24BE  B1 80     LDA ($80),Y 
$24C0  85 04     STA $04 
$24C2  85 0A     STA $0A 
$24C4  85 1C     STA $1C 
$24C6  85 22     STA $22 
$24C8  88        DEY 
$24C9  B1 80     LDA ($80),Y 
$24CB  85 09     STA $09 
$24CD  85 0F     STA $0F 
$24CF  85 21     STA $21 
$24D1  85 27     STA $27 
$24D3  88        DEY 
$24D4  B1 80     LDA ($80),Y 
$24D6  85 08     STA $08 
$24D8  85 0E     STA $0E 
$24DA  85 20     STA $20 
$24DC  85 26     STA $26 
$24DE  88        DEY 
$24DF  B1 80     LDA ($80),Y 
$24E1  85 03     STA $03 
$24E3  85 15     STA $15 
$24E5  85 1B     STA $1B 
$24E7  85 2D     STA $2D 
$24E9  88        DEY 
$24EA  B1 80     LDA ($80),Y 
$24EC  85 02     STA $02 
$24EE  85 14     STA $14 
$24F0  85 1A     STA $1A 
$24F2  85 2C     STA $2C 
$24F4  A9 08     LDA #$08
$24F6  8D 9E 15  STA $159E 
$24F9  20 21 36  JSR L_JSR_($3621)_($24F9) OK
$24FC  AD 45 15  LDA $1545 
$24FF  D0 01     BNE L_BRS_($2502)_($24FF) OK
$2501  60        RTS 
//------------------------------
L_BRS_($2502)_($24FF) OK
//------------------------------
$2502  AD 7F 15  LDA $157F 
$2505  85 80     STA $80 
$2507  AD 80 15  LDA $1580 
$250A  85 81     STA $81 
$250C  A9 00     LDA #$00
$250E  8D 45 15  STA $1545 
$2511  A2 03     LDX #$03
$2513  A0 09     LDY #$09
$2515  8E 64 24  STX $2464 
$2518  A2 00     LDX #$00
//------------------------------
L_BRS_($251A)_($2559) OK
//------------------------------
$251A  4E 3F 15  LSR $153F 
$251D  B0 08     BCS L_BRS_($2527)_($251D) OK
$251F  A9 00     LDA #$00
$2521  9D 2D 18  STA $182D,X 
$2524  4C 33 25  JMP L_JMP_($2533)_($2524) OK
//------------------------------
L_BRS_($2527)_($251D) OK
//------------------------------
$2527  B1 80     LDA ($80),Y 
$2529  29 0F     AND #$0F
$252B  9D 2D 18  STA $182D,X 
$252E  F0 03     BEQ L_BRS_($2533)_($252E) OK
$2530  8D 45 15  STA $1545 
//------------------------------
L_JMP_($2533)_($2524) OK
L_BRS_($2533)_($252E) OK
//------------------------------
$2533  4E 3F 15  LSR $153F 
//------------------------------
L_JSR_($2537)_($17A8) BAD
//------------------------------
$2536  B0 08     BCS L_BRS_($2540)_($2536) OK
$2538  A9 00     LDA #$00
$253A  9D 33 18  STA $1833,X 
$253D  4C 50 25  JMP L_JMP_($2550)_($253D) OK
//------------------------------
L_BRS_($2540)_($2536) OK
//------------------------------
$2540  B1 80     LDA ($80),Y 
$2542  29 F0     AND #$F0
$2544  4A        LSR A 
$2545  4A        LSR A 
$2546  4A        LSR A 
$2547  4A        LSR A 
$2548  9D 33 18  STA $1833,X 
$254B  F0 03     BEQ L_BRS_($2550)_($254B) OK
$254D  8D 45 15  STA $1545 
//------------------------------
L_JMP_($2550)_($253D) OK
L_BRS_($2550)_($254B) OK
//------------------------------
$2550  8A        TXA 
$2551  18        CLC 
$2552  69 0C     ADC #$0C
$2554  AA        TAX 
$2555  C8        INY 
$2556  CE 64 24  DEC $2464 
$2559  D0 BF     BNE L_BRS_($251A)_($2559) OK
$255B  AD 45 15  LDA $1545 
$255E  F0 11     BEQ L_BRS_($2571)_($255E) OK
$2560  A9 00     LDA #$00
$2562  8D 53 15  STA $1553 
$2565  A8        TAY 
$2566  AD 34 15  LDA $1534 
$2569  D0 03     BNE L_BRS_($256E)_($2569) OK
$256B  4C DF 39  JMP L_JMP_($39DF)_($256B) OK
//------------------------------
L_BRS_($256E)_($2569) OK
//------------------------------
$256E  4C 19 3B  JMP L_JMP_($3B19)_($256E) BAD
//------------------------------
L_BRS_($2571)_($255E) OK
//------------------------------
$2571  60        RTS 
//------------------------------
L_JSR_($2572)_($2172) OK
//------------------------------
$2572  AD 7F 15  LDA $157F 
$2575  85 7A     STA $7A 
$2577  AD 80 15  LDA $1580 
$257A  85 7B     STA $7B 
$257C  A0 0C     LDY #$0C
$257E  B1 7A     LDA ($7A),Y 
$2580  A0 0E     LDY #$0E
$2582  D1 7A     CMP ($7A),Y 
$2584  F0 18     BEQ L_BRS_($259E)_($2584) OK
$2586  A0 0D     LDY #$0D
$2588  B1 7A     LDA ($7A),Y 
$258A  A0 0F     LDY #$0F
$258C  D1 7A     CMP ($7A),Y 
$258E  D0 07     BNE L_BRS_($2597)_($258E) OK
$2590  A0 40     LDY #$40
$2592  A9 06     LDA #$06
$2594  4C B3 25  JMP L_JMP_($25B3)_($2594) OK
//------------------------------
L_BRS_($2597)_($258E) OK
//------------------------------
$2597  A0 7A     LDY #$7A
$2599  A9 08     LDA #$08
$259B  4C B3 25  JMP L_JMP_($25B3)_($259B) OK
//------------------------------
L_BRS_($259E)_($2584) OK
//------------------------------
$259E  A0 0D     LDY #$0D
$25A0  B1 7A     LDA ($7A),Y 
$25A2  A0 0F     LDY #$0F
$25A4  D1 7A     CMP ($7A),Y 
$25A6  F0 07     BEQ L_BRS_($25AF)_($25A6) OK
$25A8  A0 5D     LDY #$5D
$25AA  A9 06     LDA #$06
$25AC  4C B3 25  JMP L_JMP_($25B3)_($25AC) OK
//------------------------------
L_BRS_($25AF)_($25A6) OK
//------------------------------
$25AF  A0 25     LDY #$25
$25B1  A9 05     LDA #$05
//------------------------------
L_JMP_($25B3)_($2594) OK
L_JMP_($25B3)_($259B) OK
L_JMP_($25B3)_($25AC) OK
//------------------------------
$25B3  8D 9E 15  STA $159E 
$25B6  84 A4     STY $A4 
$25B8  A9 04     LDA #$04
$25BA  85 A0     STA $A0 
$25BC  A2 00     LDX #$00
$25BE  A0 0C     LDY #$0C
//------------------------------
L_BRS_($25C0)_($25D7) OK
//------------------------------
$25C0  B1 7A     LDA ($7A),Y 
$25C2  85 82     STA $82 
$25C4  A9 00     LDA #$00
$25C6  46 82     LSR $82 
$25C8  6A        ROR A 
$25C9  46 82     LSR $82 
$25CB  6A        ROR A 
$25CC  95 A6     STA $A6,X 
$25CE  E8        INX 
$25CF  A5 82     LDA $82 
$25D1  95 A6     STA $A6,X 
$25D3  E8        INX 
$25D4  C8        INY 
$25D5  C6 A0     DEC $A0 
$25D7  D0 E7     BNE L_BRS_($25C0)_($25D7) OK
$25D9  AD 98 15  LDA $1598 
$25DC  85 7A     STA $7A 
$25DE  AD 99 15  LDA $1599 
$25E1  85 7B     STA $7B 
$25E3  AD 52 15  LDA $1552 
$25E6  C9 04     CMP #$04
$25E8  F0 03     BEQ L_BRS_($25ED)_($25E8) OK
$25EA  4C 58 26  JMP L_JMP_($2658)_($25EA) OK
//------------------------------
L_BRS_($25ED)_($25E8) OK
//------------------------------
$25ED  A0 00     LDY #$00
$25EF  B1 7A     LDA ($7A),Y 
$25F1  85 02     STA $02 
$25F3  85 08     STA $08 
$25F5  85 0E     STA $0E 
$25F7  85 14     STA $14 
$25F9  C8        INY 
$25FA  B1 7A     LDA ($7A),Y 
$25FC  85 03     STA $03 
$25FE  85 09     STA $09 
$2600  85 0F     STA $0F 
$2602  85 15     STA $15 
$2604  C8        INY 
$2605  B1 7A     LDA ($7A),Y 
$2607  85 1A     STA $1A 
$2609  85 20     STA $20 
$260B  85 26     STA $26 
$260D  85 2C     STA $2C 
$260F  C8        INY 
$2610  B1 7A     LDA ($7A),Y 
$2612  85 1B     STA $1B 
$2614  85 21     STA $21 
$2616  85 27     STA $27 
$2618  85 2D     STA $2D 
$261A  A0 08     LDY #$08
$261C  B1 7A     LDA ($7A),Y 
$261E  85 0C     STA $0C 
$2620  85 12     STA $12 
$2622  18        CLC 
$2623  65 A8     ADC $A8 
$2625  85 24     STA $24 
$2627  85 2A     STA $2A 
$2629  C8        INY 
$262A  B1 7A     LDA ($7A),Y 
$262C  85 0D     STA $0D 
$262E  85 13     STA $13 
$2630  65 A9     ADC $A9 
$2632  85 25     STA $25 
$2634  85 2B     STA $2B 
$2636  C8        INY 
$2637  B1 7A     LDA ($7A),Y 
$2639  85 06     STA $06 
$263B  85 18     STA $18 
$263D  C8        INY 
$263E  B1 7A     LDA ($7A),Y 
$2640  85 07     STA $07 
$2642  85 19     STA $19 
$2644  A5 0C     LDA $0C 
$2646  18        CLC 
$2647  65 AC     ADC $AC 
$2649  85 1E     STA $1E 
$264B  85 30     STA $30 
$264D  A5 0D     LDA $0D 
$264F  65 AD     ADC $AD 
$2651  85 1F     STA $1F 
$2653  85 31     STA $31 
$2655  4C C7 26  JMP L_JMP_($26C7)_($2655) OK
//------------------------------
L_JMP_($2658)_($25EA) OK
//------------------------------
$2658  C9 05     CMP #$05
$265A  F0 03     BEQ L_BRS_($265F)_($265A) OK
$265C  4C 05 27  JMP L_JMP_($2705)_($265C) OK
//------------------------------
L_BRS_($265F)_($265A) OK
//------------------------------
$265F  A0 00     LDY #$00
$2661  B1 7A     LDA ($7A),Y 
$2663  85 1A     STA $1A 
$2665  85 20     STA $20 
$2667  85 26     STA $26 
$2669  85 2C     STA $2C 
$266B  C8        INY 
$266C  B1 7A     LDA ($7A),Y 
$266E  85 1B     STA $1B 
$2670  85 21     STA $21 
$2672  85 27     STA $27 
$2674  85 2D     STA $2D 
$2676  C8        INY 
$2677  B1 7A     LDA ($7A),Y 
$2679  85 02     STA $02 
$267B  85 08     STA $08 
$267D  85 0E     STA $0E 
$267F  85 14     STA $14 
$2681  C8        INY 
$2682  B1 7A     LDA ($7A),Y 
$2684  85 03     STA $03 
$2686  85 09     STA $09 
$2688  85 0F     STA $0F 
$268A  85 15     STA $15 
$268C  A0 08     LDY #$08
$268E  B1 7A     LDA ($7A),Y 
$2690  85 06     STA $06 
$2692  85 18     STA $18 
$2694  18        CLC 
$2695  65 A8     ADC $A8 
$2697  85 1E     STA $1E 
$2699  85 30     STA $30 
$269B  C8        INY 
$269C  B1 7A     LDA ($7A),Y 
$269E  85 07     STA $07 
$26A0  85 19     STA $19 
$26A2  65 A9     ADC $A9 
$26A4  85 1F     STA $1F 
$26A6  85 31     STA $31 
$26A8  C8        INY 
$26A9  B1 7A     LDA ($7A),Y 
$26AB  85 0C     STA $0C 
$26AD  85 12     STA $12 
$26AF  C8        INY 
$26B0  B1 7A     LDA ($7A),Y 
$26B2  85 0D     STA $0D 
$26B4  85 13     STA $13 
$26B6  A5 06     LDA $06 
$26B8  18        CLC 
$26B9  65 AC     ADC $AC 
$26BB  85 24     STA $24 
$26BD  85 2A     STA $2A 
$26BF  A5 07     LDA $07 
$26C1  65 AD     ADC $AD 
$26C3  85 25     STA $25 
$26C5  85 2B     STA $2B 
//------------------------------
L_JMP_($26C7)_($2655) OK
//------------------------------
$26C7  A0 04     LDY #$04
$26C9  B1 7A     LDA ($7A),Y 
$26CB  85 04     STA $04 
$26CD  85 0A     STA $0A 
$26CF  18        CLC 
$26D0  65 A6     ADC $A6 
$26D2  85 1C     STA $1C 
$26D4  85 28     STA $28 
$26D6  C8        INY 
$26D7  B1 7A     LDA ($7A),Y 
$26D9  85 05     STA $05 
$26DB  85 0B     STA $0B 
$26DD  65 A7     ADC $A7 
$26DF  85 1D     STA $1D 
$26E1  85 29     STA $29 
$26E3  C8        INY 
$26E4  B1 7A     LDA ($7A),Y 
$26E6  85 10     STA $10 
$26E8  85 16     STA $16 
$26EA  C8        INY 
$26EB  B1 7A     LDA ($7A),Y 
$26ED  85 11     STA $11 
$26EF  85 17     STA $17 
$26F1  A5 04     LDA $04 
$26F3  18        CLC 
$26F4  65 AA     ADC $AA 
$26F6  85 22     STA $22 
$26F8  85 2E     STA $2E 
$26FA  A5 05     LDA $05 
$26FC  65 AB     ADC $AB 
$26FE  85 23     STA $23 
$2700  85 2F     STA $2F 
$2702  4C 35 29  JMP L_JMP_($2935)_($2702) OK
//------------------------------
L_JMP_($2705)_($265C) OK
//------------------------------
$2705  C9 06     CMP #$06
$2707  F0 03     BEQ L_BRS_($270C)_($2707) OK
$2709  4C 76 27  JMP L_JMP_($2776)_($2709) OK
//------------------------------
L_BRS_($270C)_($2707) OK
//------------------------------
$270C  A0 00     LDY #$00
$270E  B1 7A     LDA ($7A),Y 
$2710  85 02     STA $02 
$2712  85 08     STA $08 
$2714  18        CLC 
$2715  65 A6     ADC $A6 
$2717  85 1A     STA $1A 
$2719  85 26     STA $26 
$271B  C8        INY 
$271C  B1 7A     LDA ($7A),Y 
$271E  85 03     STA $03 
$2720  85 09     STA $09 
$2722  65 A7     ADC $A7 
$2724  85 1B     STA $1B 
$2726  85 27     STA $27 
$2728  C8        INY 
$2729  B1 7A     LDA ($7A),Y 
$272B  85 0E     STA $0E 
$272D  85 14     STA $14 
$272F  C8        INY 
$2730  B1 7A     LDA ($7A),Y 
$2732  85 0F     STA $0F 
$2734  85 15     STA $15 
$2736  A5 02     LDA $02 
$2738  18        CLC 
$2739  65 AA     ADC $AA 
$273B  85 20     STA $20 
$273D  85 2C     STA $2C 
$273F  A5 03     LDA $03 
$2741  65 AB     ADC $AB 
$2743  85 2D     STA $2D 
$2745  85 21     STA $21 
$2747  C8        INY 
$2748  B1 7A     LDA ($7A),Y 
$274A  85 04     STA $04 
$274C  85 0A     STA $0A 
$274E  85 10     STA $10 
$2750  85 16     STA $16 
$2752  C8        INY 
$2753  B1 7A     LDA ($7A),Y 
$2755  85 05     STA $05 
$2757  85 0B     STA $0B 
$2759  85 11     STA $11 
$275B  85 17     STA $17 
$275D  C8        INY 
$275E  B1 7A     LDA ($7A),Y 
$2760  85 1C     STA $1C 
$2762  85 22     STA $22 
$2764  85 28     STA $28 
$2766  85 2E     STA $2E 
$2768  C8        INY 
$2769  B1 7A     LDA ($7A),Y 
$276B  85 1D     STA $1D 
$276D  85 23     STA $23 
$276F  85 29     STA $29 
$2771  85 2F     STA $2F 
$2773  4C E4 27  JMP L_JMP_($27E4)_($2773) OK
//------------------------------
L_JMP_($2776)_($2709) OK
//------------------------------
$2776  C9 07     CMP #$07
$2778  F0 03     BEQ L_BRS_($277D)_($2778) OK
$277A  4C 22 28  JMP L_JMP_($2822)_($277A) OK
//------------------------------
L_BRS_($277D)_($2778) OK
//------------------------------
$277D  A0 00     LDY #$00
$277F  B1 7A     LDA ($7A),Y 
$2781  85 0E     STA $0E 
$2783  85 14     STA $14 
$2785  18        CLC 
$2786  65 A6     ADC $A6 
$2788  85 20     STA $20 
$278A  85 2C     STA $2C 
$278C  C8        INY 
$278D  B1 7A     LDA ($7A),Y 
$278F  85 0F     STA $0F 
$2791  85 15     STA $15 
$2793  65 A7     ADC $A7 
$2795  85 21     STA $21 
$2797  85 2D     STA $2D 
$2799  A5 0E     LDA $0E 
$279B  18        CLC 
$279C  65 AA     ADC $AA 
$279E  85 1A     STA $1A 
$27A0  85 26     STA $26 
$27A2  A5 0F     LDA $0F 
$27A4  65 AB     ADC $AB 
$27A6  85 1B     STA $1B 
$27A8  85 27     STA $27 
$27AA  C8        INY 
$27AB  B1 7A     LDA ($7A),Y 
$27AD  85 02     STA $02 
$27AF  85 08     STA $08 
$27B1  C8        INY 
$27B2  B1 7A     LDA ($7A),Y 
$27B4  85 03     STA $03 
$27B6  85 09     STA $09 
$27B8  C8        INY 
$27B9  B1 7A     LDA ($7A),Y 
$27BB  85 1C     STA $1C 
$27BD  85 22     STA $22 
$27BF  85 28     STA $28 
$27C1  85 2E     STA $2E 
$27C3  C8        INY 
$27C4  B1 7A     LDA ($7A),Y 
$27C6  85 1D     STA $1D 
$27C8  85 23     STA $23 
$27CA  85 29     STA $29 
$27CC  85 2F     STA $2F 
$27CE  C8        INY 
$27CF  B1 7A     LDA ($7A),Y 
$27D1  85 04     STA $04 
$27D3  85 0A     STA $0A 
$27D5  85 10     STA $10 
$27D7  85 16     STA $16 
$27D9  C8        INY 
$27DA  B1 7A     LDA ($7A),Y 
$27DC  85 05     STA $05 
$27DE  85 0B     STA $0B 
$27E0  85 11     STA $11 
$27E2  85 17     STA $17 
//------------------------------
L_JMP_($27E4)_($2773) OK
//------------------------------
$27E4  A0 08     LDY #$08
$27E6  B1 7A     LDA ($7A),Y 
$27E8  85 06     STA $06 
$27EA  85 18     STA $18 
$27EC  18        CLC 
$27ED  65 A8     ADC $A8 
$27EF  85 1E     STA $1E 
$27F1  85 30     STA $30 
$27F3  C8        INY 
$27F4  B1 7A     LDA ($7A),Y 
$27F6  85 07     STA $07 
$27F8  85 19     STA $19 
$27FA  65 A9     ADC $A9 
$27FC  85 1F     STA $1F 
$27FE  85 31     STA $31 
$2800  C8        INY 
$2801  B1 7A     LDA ($7A),Y 
$2803  85 0C     STA $0C 
$2805  85 12     STA $12 
$2807  C8        INY 
$2808  B1 7A     LDA ($7A),Y 
$280A  85 0D     STA $0D 
$280C  85 13     STA $13 
$280E  A5 06     LDA $06 
$2810  18        CLC 
$2811  65 AC     ADC $AC 
$2813  85 24     STA $24 
$2815  85 2A     STA $2A 
$2817  A5 07     LDA $07 
$2819  65 AD     ADC $AD 
$281B  85 25     STA $25 
$281D  85 2B     STA $2B 
//------------------------------
L_JSR_($2820)_($72EF) BAD
//------------------------------
$281F  4C 35 29  JMP L_JMP_($2935)_($281F) OK
//------------------------------
L_JMP_($2822)_($277A) OK
//------------------------------
$2822  C9 08     CMP #$08
$2824  F0 03     BEQ L_BRS_($2829)_($2824) OK
$2826  4C 93 28  JMP L_JMP_($2893)_($2826) OK
//------------------------------
L_BRS_($2829)_($2824) OK
//------------------------------
$2829  A0 04     LDY #$04
$282B  B1 7A     LDA ($7A),Y 
$282D  85 0A     STA $0A 
$282F  85 10     STA $10 
$2831  18        CLC 
$2832  65 A8     ADC $A8 
$2834  85 22     STA $22 
$2836  85 28     STA $28 
$2838  C8        INY 
$2839  B1 7A     LDA ($7A),Y 
$283B  85 0B     STA $0B 
$283D  85 11     STA $11 
$283F  65 A9     ADC $A9 
$2841  85 23     STA $23 
$2843  85 29     STA $29 
$2845  A5 0A     LDA $0A 
$2847  18        CLC 
$2848  65 AC     ADC $AC 
$284A  85 1C     STA $1C 
$284C  85 2E     STA $2E 
$284E  A5 0B     LDA $0B 
$2850  65 AD     ADC $AD 
$2852  85 1D     STA $1D 
$2854  85 2F     STA $2F 
$2856  C8        INY 
$2857  B1 7A     LDA ($7A),Y 
$2859  85 04     STA $04 
$285B  85 16     STA $16 
$285D  C8        INY 
$285E  B1 7A     LDA ($7A),Y 
$2860  85 05     STA $05 
$2862  85 17     STA $17 
$2864  C8        INY 
$2865  B1 7A     LDA ($7A),Y 
$2867  85 06     STA $06 
$2869  85 0C     STA $0C 
$286B  85 12     STA $12 
$286D  85 18     STA $18 
$286F  C8        INY 
$2870  B1 7A     LDA ($7A),Y 
$2872  85 07     STA $07 
$2874  85 0D     STA $0D 
$2876  85 13     STA $13 
$2878  85 19     STA $19 
$287A  C8        INY 
$287B  B1 7A     LDA ($7A),Y 
$287D  85 1E     STA $1E 
$287F  85 24     STA $24 
$2881  85 2A     STA $2A 
$2883  85 30     STA $30 
$2885  C8        INY 
$2886  B1 7A     LDA ($7A),Y 
$2888  85 1F     STA $1F 
$288A  85 25     STA $25 
$288C  85 2B     STA $2B 
$288E  85 31     STA $31 
$2890  4C FA 28  JMP L_JMP_($28FA)_($2890) OK
//------------------------------
L_JMP_($2893)_($2826) OK
//------------------------------
$2893  A0 04     LDY #$04
$2895  B1 7A     LDA ($7A),Y 
$2897  85 16     STA $16 
$2899  85 04     STA $04 
$289B  18        CLC 
$289C  65 A8     ADC $A8 
$289E  85 1C     STA $1C 
$28A0  85 2E     STA $2E 
$28A2  C8        INY 
$28A3  B1 7A     LDA ($7A),Y 
$28A5  85 17     STA $17 
$28A7  85 05     STA $05 
$28A9  65 A9     ADC $A9 
$28AB  85 1D     STA $1D 
$28AD  85 2F     STA $2F 
$28AF  C8        INY 
$28B0  B1 7A     LDA ($7A),Y 
$28B2  85 0A     STA $0A 
$28B4  85 10     STA $10 
$28B6  C8        INY 
$28B7  B1 7A     LDA ($7A),Y 
$28B9  85 0B     STA $0B 
$28BB  85 11     STA $11 
$28BD  A5 04     LDA $04 
$28BF  18        CLC 
$28C0  65 AC     ADC $AC 
$28C2  85 22     STA $22 
$28C4  85 28     STA $28 
$28C6  A5 05     LDA $05 
$28C8  65 AD     ADC $AD 
$28CA  85 23     STA $23 
$28CC  85 29     STA $29 
$28CE  C8        INY 
$28CF  B1 7A     LDA ($7A),Y 
$28D1  85 1E     STA $1E 
$28D3  85 24     STA $24 
$28D5  85 2A     STA $2A 
$28D7  85 30     STA $30 
$28D9  C8        INY 
$28DA  B1 7A     LDA ($7A),Y 
$28DC  85 1F     STA $1F 
$28DE  85 25     STA $25 
$28E0  85 2B     STA $2B 
$28E2  85 31     STA $31 
$28E4  C8        INY 
$28E5  B1 7A     LDA ($7A),Y 
$28E7  85 06     STA $06 
$28E9  85 0C     STA $0C 
$28EB  85 12     STA $12 
$28ED  85 18     STA $18 
$28EF  C8        INY 
$28F0  B1 7A     LDA ($7A),Y 
$28F2  85 07     STA $07 
$28F4  85 0D     STA $0D 
$28F6  85 13     STA $13 
$28F8  85 19     STA $19 
//------------------------------
L_JMP_($28FA)_($2890) OK
//------------------------------
$28FA  A0 00     LDY #$00
$28FC  B1 7A     LDA ($7A),Y 
$28FE  85 02     STA $02 
$2900  85 08     STA $08 
$2902  18        CLC 
$2903  65 A6     ADC $A6 
$2905  85 1A     STA $1A 
$2907  85 26     STA $26 
$2909  C8        INY 
$290A  B1 7A     LDA ($7A),Y 
$290C  85 03     STA $03 
$290E  85 09     STA $09 
$2910  65 A7     ADC $A7 
$2912  85 1B     STA $1B 
$2914  85 27     STA $27 
$2916  C8        INY 
$2917  B1 7A     LDA ($7A),Y 
$2919  85 0E     STA $0E 
$291B  85 14     STA $14 
$291D  C8        INY 
$291E  B1 7A     LDA ($7A),Y 
$2920  85 0F     STA $0F 
$2922  85 15     STA $15 
$2924  A5 02     LDA $02 
$2926  18        CLC 
$2927  65 AA     ADC $AA 
$2929  85 20     STA $20 
$292B  85 2C     STA $2C 
$292D  A5 03     LDA $03 
$292F  65 AB     ADC $AB 
$2931  85 21     STA $21 
$2933  85 2D     STA $2D 
//------------------------------
L_JMP_($2935)_($2702) OK
L_JMP_($2935)_($281F) OK
//------------------------------
$2935  20 21 36  JSR L_JSR_($3621)_($2935) OK
$2938  AD 45 15  LDA $1545 
$293B  F0 5E     BEQ L_BRS_($299B)_($293B) OK
$293D  AD 7F 15  LDA $157F 
$2940  85 7A     STA $7A 
$2942  AD 80 15  LDA $1580 
$2945  85 7B     STA $7B 
$2947  A6 A4     LDX $A4 
$2949  BD 2C 18  LDA $182C,X 
$294C  85 A0     STA $A0 
$294E  E8        INX 
$294F  A0 09     LDY #$09
//------------------------------
L_BRS_($2951)_($2987) OK
//------------------------------
$2951  B1 7A     LDA ($7A),Y 
$2953  29 0F     AND #$0F
$2955  9D 2C 18  STA $182C,X 
$2958  BD 2D 18  LDA $182D,X 
$295B  18        CLC 
$295C  69 02     ADC #$02
$295E  85 82     STA $82 
$2960  8A        TXA 
$2961  18        CLC 
$2962  65 82     ADC $82 
$2964  AA        TAX 
$2965  C6 A0     DEC $A0 
$2967  D0 03     BNE L_BRS_($296C)_($2967) OK
$2969  4C 89 29  JMP L_JMP_($2989)_($2969) OK
//------------------------------
L_BRS_($296C)_($2967) OK
//------------------------------
$296C  B1 7A     LDA ($7A),Y 
$296E  29 F0     AND #$F0
$2970  4A        LSR A 
$2971  4A        LSR A 
$2972  4A        LSR A 
$2973  4A        LSR A 
$2974  9D 2C 18  STA $182C,X 
$2977  BD 2D 18  LDA $182D,X 
$297A  18        CLC 
$297B  69 02     ADC #$02
$297D  85 82     STA $82 
$297F  8A        TXA 
$2980  18        CLC 
$2981  65 82     ADC $82 
$2983  AA        TAX 
$2984  C8        INY 
$2985  C6 A0     DEC $A0 
$2987  D0 C8     BNE L_BRS_($2951)_($2987) OK
//------------------------------
L_JMP_($2989)_($2969) OK
//------------------------------
$2989  A9 01     LDA #$01
$298B  8D 53 15  STA $1553 
$298E  A4 A4     LDY $A4 
$2990  AD 34 15  LDA $1534 
$2993  D0 03     BNE L_BRS_($2998)_($2993) OK
$2995  4C DF 39  JMP L_JMP_($39DF)_($2995) OK
//------------------------------
L_BRS_($2998)_($2993) OK
//------------------------------
$2998  4C 19 3B  JMP L_JMP_($3B19)_($2998) BAD
//------------------------------
L_BRS_($299B)_($293B) OK
//------------------------------
$299B  60        RTS 
//------------------------------
$299C  35 35     AND $35,X 
//------------------------------
L_JSR_($299E)_($2178) OK
//------------------------------
$299E  AD 7F 15  LDA $157F 
$29A1  85 7A     STA $7A 
$29A3  AD 80 15  LDA $1580 
$29A6  85 7B     STA $7B 
$29A8  AD 52 15  LDA $1552 
$29AB  38        SEC 
$29AC  E9 08     SBC #$08
$29AE  8D 9E 15  STA $159E 
$29B1  8D 9C 29  STA $299C 
$29B4  A0 09     LDY #$09
$29B6  B1 7A     LDA ($7A),Y 
$29B8  8D 9D 29  STA $299D 
$29BB  C8        INY 
$29BC  A2 00     LDX #$00
//------------------------------
L_BRS_($29BE)_($2A21) OK
//------------------------------
$29BE  A9 00     LDA #$00
$29C0  85 82     STA $82 
$29C2  B1 7A     LDA ($7A),Y 
$29C4  4A        LSR A 
$29C5  66 82     ROR $82 
$29C7  4A        LSR A 
$29C8  66 82     ROR $82 
$29CA  85 83     STA $83 
$29CC  A5 82     LDA $82 
$29CE  38        SEC 
$29CF  ED 2E 1C  SBC $1C2E 
$29D2  95 02     STA $02,X 
$29D4  A5 83     LDA $83 
$29D6  E8        INX 
$29D7  ED 2F 1C  SBC $1C2F 
$29DA  95 02     STA $02,X 
$29DC  E8        INX 
$29DD  C8        INY 
$29DE  A9 00     LDA #$00
$29E0  85 82     STA $82 
$29E2  B1 7A     LDA ($7A),Y 
$29E4  4A        LSR A 
$29E5  66 82     ROR $82 
$29E7  4A        LSR A 
$29E8  66 82     ROR $82 
$29EA  85 83     STA $83 
$29EC  A5 82     LDA $82 
$29EE  38        SEC 
$29EF  ED 30 1C  SBC $1C30 
$29F2  95 02     STA $02,X 
$29F4  E8        INX 
$29F5  A5 83     LDA $83 
$29F7  ED 31 1C  SBC $1C31 
$29FA  95 02     STA $02,X 
$29FC  E8        INX 
$29FD  C8        INY 
$29FE  A9 00     LDA #$00
$2A00  85 82     STA $82 
$2A02  B1 7A     LDA ($7A),Y 
$2A04  4A        LSR A 
//------------------------------
L_JSR_($2A06)_($B903) BAD
//------------------------------
$2A05  66 82     ROR $82 
$2A07  4A        LSR A 
$2A08  66 82     ROR $82 
$2A0A  85 83     STA $83 
$2A0C  A5 82     LDA $82 
$2A0E  38        SEC 
$2A0F  ED 32 1C  SBC $1C32 
$2A12  95 02     STA $02,X 
$2A14  E8        INX 
$2A15  A5 83     LDA $83 
$2A17  ED 33 1C  SBC $1C33 
$2A1A  95 02     STA $02,X 
$2A1C  E8        INX 
$2A1D  C8        INY 
$2A1E  CE 9C 29  DEC $299C 
$2A21  D0 9B     BNE L_BRS_($29BE)_($2A21) OK
//------------------------------
L_JSR_($2A25)_($7BDD) BAD
//------------------------------
$2A23  20 21 36  JSR L_JSR_($3621)_($2A23) OK
$2A26  AD 45 15  LDA $1545 
//------------------------------
L_JSR_($2A2A)_($1C4C) BAD
//------------------------------
$2A29  F0 33     BEQ L_BRS_($2A5E)_($2A29) OK
$2A2B  A0 9F     LDY #$9F
$2A2D  AD 9E 15  LDA $159E 
$2A30  8D CD 18  STA $18CD 
$2A33  C9 02     CMP #$02
$2A35  08        PHP 
$2A36  AD 9D 29  LDA $299D 
$2A39  28        PLP 
$2A3A  F0 0D     BEQ L_BRS_($2A49)_($2A3A) OK
$2A3C  8D 2F 17  STA $172F 
$2A3F  A9 01     LDA #$01
$2A41  8D CC 18  STA $18CC 
$2A44  A9 02     LDA #$02
$2A46  4C 50 2A  JMP L_JMP_($2A50)_($2A46) OK
//------------------------------
L_BRS_($2A49)_($2A3A) OK
//------------------------------
$2A49  29 0F     AND #$0F
$2A4B  8D CC 18  STA $18CC 
$2A4E  A9 00     LDA #$00
//------------------------------
L_JMP_($2A50)_($2A46) OK
//------------------------------
$2A50  8D 53 15  STA $1553 
$2A53  AD 34 15  LDA $1534 
$2A56  D0 03     BNE L_BRS_($2A5B)_($2A56) OK
$2A58  4C DF 39  JMP L_JMP_($39DF)_($2A58) OK
//------------------------------
L_BRS_($2A5B)_($2A56) OK
//------------------------------
$2A5B  4C 19 3B  JMP L_JMP_($3B19)_($2A5B) BAD
//------------------------------
L_BRS_($2A5E)_($2A29) OK
//------------------------------
$2A5E  60        RTS 
//------------------------------
L_JSR_($2A60)_($2168) BAD
//------------------------------
$2A5F  35 AD     AND $AD,X 
$2A61  98        TYA 
$2A62  15 85     ORA $85,X
$2A64            .byte $7A
$2A65  AD 99 15  LDA $1599 
$2A68  85 7B     STA $7B 
$2A6A  A0 00     LDY #$00
$2A6C  B1 7A     LDA ($7A),Y 
$2A6E  85 02     STA $02 
$2A70  85 14     STA $14 
$2A72  C8        INY 
$2A73  B1 7A     LDA ($7A),Y 
$2A75  85 03     STA $03 
$2A77  85 15     STA $15 
$2A79  C8        INY 
$2A7A  B1 7A     LDA ($7A),Y 
$2A7C  85 08     STA $08 
$2A7E  85 0E     STA $0E 
$2A80  C8        INY 
$2A81  B1 7A     LDA ($7A),Y 
$2A83  85 09     STA $09 
$2A85  85 0F     STA $0F 
$2A87  C8        INY 
$2A88  B1 7A     LDA ($7A),Y 
$2A8A  85 04     STA $04 
$2A8C  85 0A     STA $0A 
$2A8E  C8        INY 
$2A8F  B1 7A     LDA ($7A),Y 
$2A91  85 05     STA $05 
$2A93  85 0B     STA $0B 
$2A95  C8        INY 
$2A96  B1 7A     LDA ($7A),Y 
$2A98  85 10     STA $10 
$2A9A  85 16     STA $16 
$2A9C  C8        INY 
$2A9D  B1 7A     LDA ($7A),Y 
$2A9F  85 11     STA $11 
$2AA1  85 17     STA $17 
$2AA3  AD 7F 15  LDA $157F 
$2AA6  85 7C     STA $7C 
$2AA8  AD 80 15  LDA $1580 
$2AAB  85 7D     STA $7D 
$2AAD  C8        INY 
$2AAE  B1 7A     LDA ($7A),Y 
$2AB0  85 06     STA $06 
$2AB2  85 18     STA $18 
$2AB4  C8        INY 
$2AB5  B1 7A     LDA ($7A),Y 
$2AB7  85 07     STA $07 
$2AB9  85 19     STA $19 
$2ABB  C8        INY 
$2ABC  B1 7A     LDA ($7A),Y 
$2ABE  85 12     STA $12 
$2AC0  85 0C     STA $0C 
$2AC2  C8        INY 
$2AC3  B1 7A     LDA ($7A),Y 
$2AC5  85 13     STA $13 
$2AC7  85 0D     STA $0D 
$2AC9  A0 04     LDY #$04
$2ACB  A2 01     LDX #$01
$2ACD  B1 7C     LDA ($7C),Y 
$2ACF  F0 1C     BEQ L_BRS_($2AED)_($2ACF) OK
$2AD1  A5 12     LDA $12 
$2AD3  85 18     STA $18 
$2AD5  A5 13     LDA $13 
$2AD7  85 19     STA $19 
$2AD9  A5 06     LDA $06 
$2ADB  85 0C     STA $0C 
$2ADD  A5 07     LDA $07 
$2ADF  85 0D     STA $0D 
$2AE1  C8        INY 
$2AE2  B1 7C     LDA ($7C),Y 
$2AE4  D0 05     BNE L_BRS_($2AEB)_($2AE4) OK
$2AE6  A2 02     LDX #$02
$2AE8  4C ED 2A  JMP L_JMP_($2AED)_($2AE8) OK
//------------------------------
L_BRS_($2AEB)_($2AE4) OK
//------------------------------
$2AEB  A2 03     LDX #$03
//------------------------------
L_BRS_($2AED)_($2ACF) OK
L_JMP_($2AED)_($2AE8) OK
//------------------------------
$2AED  8E 5F 2A  STX $2A5F 
$2AF0  A9 04     LDA #$04
$2AF2  8D 9E 15  STA $159E 
$2AF5  20 21 36  JSR L_JSR_($3621)_($2AF5) OK
$2AF8  AD 45 15  LDA $1545 
$2AFB  D0 01     BNE L_BRS_($2AFE)_($2AFB) OK
$2AFD  60        RTS 
//------------------------------
L_BRS_($2AFE)_($2AFB) OK
//------------------------------
$2AFE  A9 04     LDA #$04
$2B00  8D CD 18  STA $18CD 
$2B03  AD 3F 15  LDA $153F 
$2B06  AE 5F 2A  LDX $2A5F 
$2B09  E0 01     CPX #$01
$2B0B  F0 08     BEQ L_BRS_($2B15)_($2B0B) OK
$2B0D  E0 02     CPX #$02
$2B0F  F0 02     BEQ L_BRS_($2B13)_($2B0F) OK
$2B11  4A        LSR A 
$2B12  4A        LSR A 
//------------------------------
L_BRS_($2B13)_($2B0F) OK
//------------------------------
$2B13  4A        LSR A 
$2B14  4A        LSR A 
//------------------------------
L_BRS_($2B15)_($2B0B) OK
//------------------------------
$2B15  A0 09     LDY #$09
$2B17  48        PHA 
$2B18  B1 7C     LDA ($7C),Y 
$2B1A  A8        TAY 
$2B1B  68        PLA 
$2B1C  4A        LSR A 
$2B1D  90 08     BCC L_BRS_($2B27)_($2B1D) OK
$2B1F  98        TYA 
$2B20  29 0F     AND #$0F
$2B22  F0 21     BEQ L_BRS_($2B45)_($2B22) OK
$2B24  4C 30 2B  JMP L_JMP_($2B30)_($2B24) OK
//------------------------------
L_BRS_($2B27)_($2B1D) OK
//------------------------------
$2B27  98        TYA 
$2B28  29 F0     AND #$F0
$2B2A  F0 19     BEQ L_BRS_($2B45)_($2B2A) OK
$2B2C  4A        LSR A 
$2B2D  4A        LSR A 
$2B2E  4A        LSR A 
$2B2F  4A        LSR A 
//------------------------------
L_JMP_($2B30)_($2B24) OK
//------------------------------
$2B30  8D CC 18  STA $18CC 
$2B33  A9 00     LDA #$00
$2B35  8D 53 15  STA $1553 
$2B38  A0 9F     LDY #$9F
$2B3A  AD 34 15  LDA $1534 
$2B3D  D0 03     BNE L_BRS_($2B42)_($2B3D) OK
$2B3F  4C DF 39  JMP L_JMP_($39DF)_($2B3F) OK
//------------------------------
L_BRS_($2B42)_($2B3D) OK
//------------------------------
$2B42  4C 19 3B  JMP L_JMP_($3B19)_($2B42) BAD
//------------------------------
L_BRS_($2B45)_($2B22) OK
L_BRS_($2B45)_($2B2A) OK
//------------------------------
$2B45  60        RTS 
//------------------------------
L_JSR_($2B46)_($215E) OK
//------------------------------
$2B46  EE 9B 17  INC $179B 
$2B49  AD 99 17  LDA $1799 
$2B4C  85 7A     STA $7A 
$2B4E  AD 9A 17  LDA $179A 
$2B51  85 7B     STA $7B 
$2B53  AD 7F 15  LDA $157F 
$2B56  85 7C     STA $7C 
$2B58  AD 80 15  LDA $1580 
$2B5B  85 7D     STA $7D 
$2B5D  A0 07     LDY #$07
$2B5F  B1 7C     LDA ($7C),Y 
$2B61  A0 00     LDY #$00
$2B63  91 7A     STA ($7A),Y 
$2B65  A0 0A     LDY #$0A
$2B67  B1 7C     LDA ($7C),Y 
$2B69  A0 01     LDY #$01
$2B6B  91 7A     STA ($7A),Y 
$2B6D  88        DEY 
$2B6E  B1 7C     LDA ($7C),Y 
$2B70  29 40     AND #$40
$2B72  F0 03     BEQ L_BRS_($2B77)_($2B72) OK
$2B74  4C 90 2C  JMP L_JMP_($2C90)_($2B74) OK
//------------------------------
L_BRS_($2B77)_($2B72) OK
//------------------------------
$2B77  AD 3F 15  LDA $153F 
$2B7A  A0 0D     LDY #$0D
$2B7C  31 7C     AND ($7C),Y 
$2B7E  D0 03     BNE L_BRS_($2B83)_($2B7E) OK
$2B80  4C 90 2C  JMP L_JMP_($2C90)_($2B80) OK
//------------------------------
L_BRS_($2B83)_($2B7E) OK
//------------------------------
$2B83  AD 98 15  LDA $1598 
$2B86  85 7C     STA $7C 
$2B88  AD 99 15  LDA $1599 
$2B8B  85 7D     STA $7D 
$2B8D  A0 00     LDY #$00
$2B8F  B1 7C     LDA ($7C),Y 
$2B91  85 02     STA $02 
$2B93  85 08     STA $08 
$2B95  C8        INY 
$2B96  B1 7C     LDA ($7C),Y 
$2B98  85 03     STA $03 
$2B9A  85 09     STA $09 
$2B9C  A0 04     LDY #$04
$2B9E  B1 7C     LDA ($7C),Y 
$2BA0  85 04     STA $04 
$2BA2  85 0A     STA $0A 
$2BA4  C8        INY 
$2BA5  B1 7C     LDA ($7C),Y 
$2BA7  85 05     STA $05 
$2BA9  85 0B     STA $0B 
$2BAB  A0 08     LDY #$08
$2BAD  B1 7C     LDA ($7C),Y 
$2BAF  85 82     STA $82 
$2BB1  85 06     STA $06 
$2BB3  85 0C     STA $0C 
$2BB5  C8        INY 
$2BB6  B1 7C     LDA ($7C),Y 
$2BB8  85 83     STA $83 
$2BBA  85 07     STA $07 
$2BBC  85 0D     STA $0D 
$2BBE  10 12     BPL L_BRS_($2BD2)_($2BBE) OK
$2BC0  A5 82     LDA $82 
$2BC2  49 FF     EOR #$FF
$2BC4  18        CLC 
$2BC5  69 01     ADC #$01
$2BC7  85 82     STA $82 
$2BC9  C8        INY 
$2BCA  A5 83     LDA $83 
$2BCC  49 FF     EOR #$FF
$2BCE  69 00     ADC #$00
$2BD0  85 83     STA $83 
//------------------------------
L_BRS_($2BD2)_($2BBE) OK
//------------------------------
$2BD2  A5 03     LDA $03 
$2BD4  10 10     BPL L_BRS_($2BE6)_($2BD4) OK
$2BD6  A5 82     LDA $82 
$2BD8  38        SEC 
$2BD9  E5 02     SBC $02 
$2BDB  85 82     STA $82 
$2BDD  A5 83     LDA $83 
$2BDF  E5 03     SBC $03 
$2BE1  85 83     STA $83 
$2BE3  4C F3 2B  JMP L_JMP_($2BF3)_($2BE3) OK
//------------------------------
L_BRS_($2BE6)_($2BD4) OK
//------------------------------
$2BE6  A5 82     LDA $82 
$2BE8  18        CLC 
$2BE9  65 02     ADC $02 
$2BEB  85 82     STA $82 
$2BED  A5 83     LDA $83 
$2BEF  65 03     ADC $03 
$2BF1  85 83     STA $83 
//------------------------------
L_JMP_($2BF3)_($2BE3) OK
//------------------------------
$2BF3  A5 05     LDA $05 
$2BF5  10 10     BPL L_BRS_($2C07)_($2BF5) OK
$2BF7  A5 82     LDA $82 
$2BF9  38        SEC 
$2BFA  E5 04     SBC $04 
$2BFC  85 82     STA $82 
$2BFE  A5 83     LDA $83 
$2C00  E5 05     SBC $05 
$2C02  85 83     STA $83 
$2C04  4C 14 2C  JMP L_JMP_($2C14)_($2C04) OK
//------------------------------
L_BRS_($2C07)_($2BF5) OK
//------------------------------
$2C07  A5 82     LDA $82 
$2C09  18        CLC 
$2C0A  65 04     ADC $04 
$2C0C  85 82     STA $82 
//------------------------------
L_JSR_($2C0E)_($A874) OK
L_JSR_($2C0E)_($A882) OK
//------------------------------
$2C0E  A5 83     LDA $83 
$2C10  65 05     ADC $05 
$2C12  85 83     STA $83 
//------------------------------
L_JMP_($2C14)_($2C04) OK
//------------------------------
$2C14  AD 7F 15  LDA $157F 
$2C17  85 7C     STA $7C 
$2C19  AD 80 15  LDA $1580 
$2C1C  85 7D     STA $7D 
$2C1E  A0 0B     LDY #$0B
$2C20  A5 82     LDA $82 
$2C22  38        SEC 
$2C23  F1 7C     SBC ($7C),Y 
$2C25  C8        INY 
$2C26  85 82     STA $82 
$2C28  A5 83     LDA $83 
$2C2A  F1 7C     SBC ($7C),Y 
$2C2C  85 83     STA $83 
$2C2E  30 03     BMI L_BRS_($2C33)_($2C2E) OK
$2C30  4C 90 2C  JMP L_JMP_($2C90)_($2C30) OK
//------------------------------
L_BRS_($2C33)_($2C2E) OK
//------------------------------
$2C33  A9 02     LDA #$02
$2C35  8D 9E 15  STA $159E 
$2C38  20 21 36  JSR L_JSR_($3621)_($2C38) OK
$2C3B  AD 45 15  LDA $1545 
$2C3E  F0 47     BEQ L_BRS_($2C87)_($2C3E) OK
$2C40  A0 09     LDY #$09
$2C42  B1 7C     LDA ($7C),Y 
$2C44  29 0F     AND #$0F
$2C46  8D D5 18  STA $18D5 
$2C49  A9 00     LDA #$00
$2C4B  8D 53 15  STA $1553 
$2C4E  A0 A8     LDY #$A8
$2C50  20 DF 39  JSR L_JSR_($39DF)_($2C50) OK
$2C53  AD 99 17  LDA $1799 
$2C56  85 7A     STA $7A 
$2C58  AD 9A 17  LDA $179A 
$2C5B  85 7B     STA $7B 
$2C5D  AD 96 15  LDA $1596 
$2C60  38        SEC 
$2C61  E9 02     SBC #$02
$2C63  85 7C     STA $7C 
$2C65  AD 97 15  LDA $1597 
$2C68  E9 00     SBC #$00
$2C6A  85 7D     STA $7D 
$2C6C  A0 00     LDY #$00
$2C6E  B1 7C     LDA ($7C),Y 
$2C70  F0 15     BEQ L_BRS_($2C87)_($2C70) OK
$2C72  A0 04     LDY #$04
$2C74  91 7A     STA ($7A),Y 
$2C76  A0 01     LDY #$01
$2C78  B1 7C     LDA ($7C),Y 
$2C7A  A0 05     LDY #$05
$2C7C  91 7A     STA ($7A),Y 
$2C7E  A0 03     LDY #$03
$2C80  A9 01     LDA #$01
$2C82  91 7A     STA ($7A),Y 
$2C84  4C 96 2C  JMP L_JMP_($2C96)_($2C84) OK
//------------------------------
L_BRS_($2C87)_($2C3E) OK
L_BRS_($2C87)_($2C70) OK
//------------------------------
$2C87  A0 03     LDY #$03
$2C89  A9 02     LDA #$02
$2C8B  91 7A     STA ($7A),Y 
$2C8D  4C 96 2C  JMP L_JMP_($2C96)_($2C8D) OK
//------------------------------
L_JMP_($2C90)_($2B74) OK
L_JMP_($2C90)_($2B80) OK
L_JMP_($2C90)_($2C30) OK
//------------------------------
$2C90  A9 00     LDA #$00
$2C92  A0 03     LDY #$03
$2C94  91 7A     STA ($7A),Y 
//------------------------------
L_JMP_($2C96)_($2C84) OK
L_JMP_($2C96)_($2C8D) OK
//------------------------------
$2C96  AD 99 17  LDA $1799 
$2C99  18        CLC 
$2C9A  69 06     ADC #$06
$2C9C  8D 99 17  STA $1799 
$2C9F  90 03     BCC L_BRS_($2CA4)_($2C9F) OK
$2CA1  EE 9A 17  INC $179A 
//------------------------------
L_BRS_($2CA4)_($2C9F) OK
//------------------------------
$2CA4  60        RTS 
//------------------------------
$2CA5            .byte $00,$00
//------------------------------
L_BRS_($2CA7)_($2CAE) OK
L_BRS_($2CA7)_($2CB0) OK
//------------------------------
$2CA7  4C E1 2D  JMP L_JMP_($2DE1)_($2CA7) OK
//------------------------------
L_JSR_($2CAA)_($1FE7) OK
//------------------------------
$2CAA  AE 54 15  LDX $1554 	; TODO: sort the objects on the scene
//------------------------------
L_JMP_($2CAD)_($2DDD) OK
//------------------------------
$2CAD  CA        DEX 
$2CAE  F0 F7     BEQ L_BRS_($2CA7)_($2CAE) OK
$2CB0  30 F5     BMI L_BRS_($2CA7)_($2CB0) OK
$2CB2  8A        TXA 
$2CB3  48        PHA 
$2CB4  AD 94 15  LDA $1594 
$2CB7  18        CLC 
$2CB8  69 04     ADC #$04
$2CBA  85 7A     STA $7A 
$2CBC  AD 95 15  LDA $1595 
$2CBF  69 00     ADC #$00
$2CC1  85 7B     STA $7B 
$2CC3  A9 00     LDA #$00
$2CC5  85 B0     STA $B0 
$2CC7  AC 54 15  LDY $1554 
$2CCA  88        DEY 
$2CCB  84 B3     STY $B3 
//------------------------------
L_JMP_($2CCD)_($2DD4) OK
//------------------------------
$2CCD  A0 02     LDY #$02
$2CCF  B1 7A     LDA ($7A),Y 
$2CD1  85 7C     STA $7C 
$2CD3  C8        INY 
$2CD4  B1 7A     LDA ($7A),Y 
$2CD6  85 7D     STA $7D 
$2CD8  A0 06     LDY #$06
$2CDA  B1 7A     LDA ($7A),Y 
$2CDC  85 7E     STA $7E 
$2CDE  C8        INY 
$2CDF  B1 7A     LDA ($7A),Y 
$2CE1  85 7F     STA $7F 
$2CE3  A9 00     LDA #$00
$2CE5  85 B1     STA $B1 
//------------------------------
L_JMP_($2CE7)_($2D85) OK
//------------------------------
; orig timing:
; 5+2+2+2+5+2+5+2+2+5+2,5 = 34,5
; 2+2+2+5+2+2+2+5+2+5+2+2+5+2,5 = 40,5
; 2+2+5+2+4+2+2+5+2+4+2,5 = 32,5
; 5+2+4+2+2+5+2+4+2,5+4+2,5 = 35
; 2+5+2+5+3+2+5+5+3+2,5+3+2,5+3 = 43
; 2+4+2,5+3+2+5+2+5+2+5+5+2+4+2,5 = 46
; Total: 34,5+40,5+32,5+35+43+46 = 231,5
; All iterations: 231,5*3 = 694,5
; propozycja:
; revised timing:
; 4+2+4+4+4+2,5+4+2+4+4+4+2,5 = 41
; 4+4+2,5+4+4+2,5+4+4+2,5 = 31,5
; 4+2+4+3+4+4+3+2,5+3+2,5+3+4+2,5+3 = 44,5
; 4+2+4+4+4+4+2,5 = 24,5
; Total: 41+31,5+44,5+24,5 = 141,5
; All iterations: 141,5*3 = 424,5
; + copying loop:
		lda (7c),y		; 5
		sta item0,y		; 5
		lda (7e),y		; 5
		sta item1,y		; 5
		iny				; 2
		cpy #12			; 3
		bne loop		; 3 = 28*12 = 336
; copying full unroll:
		lda (7c),y
		sta item0
		lda (7e),y
		sta item1
		iny
		lda (7c),y
		sta item0+1
		lda (7e),y
		sta item1+1
		iny				; 5+4+5+4+2 = 20*12 = 240
		
; copy items to buffer item0,item1 ($0c bytes each)
		lda item00	; 4
		sec			; 2
		sbc item12	; 4
		lda item01	; 4
		sbc item13	; 4
		bpl sub_2caa_2d10 ; 2.5
		lda item10	; 4
		sec			; 2
		sbc item02	; 4
		lda item11	; 4
		sbc item03	; 4
		bmi sub_2caa_2d7d	; 2.5
sub_2caa_2d10
		lda item03	; 4
		eor item01	; 4
		bmi sub_2caa_2d6e	; 2.5
		lda item11	; 4
		eor item13	; 4
		bmi sub_2caa_2d77 ; 2.5
		lda item11	; 4
		eor item01	; 4
		bmi sub_2caa_2d7d	; 2.5
		lda item10	; 4
		sec			; 2
		sbc item00	; 4
		sta $83		; 3
		lda item11	; 4
		sbc item01	; 4
		sta $84		; 3
		bne sub_2caa_2d52	; 2.5
		lda $83		; 3
		beq sub_2caa_2d5c	; 2.5
		lda $84		; 3
sub_2caa_2d52
		eor item13	; 4
		bpl sub_2caa_2d6e	; 2.5
		jmp sub_2caa_2d77	; 3
sub_2caa_2d5c
		lda item12	; 4
		sec			; 2
		sbc item02	; 4
		lda item13	; 4
		sbc item03	; 4
		eor item13	; 4
		bmi sub_2caa_2d77	; 2.5
sub_2caa_2d6e
		; end, force shift
sub_2caa_2d77
		; end, force no shift
sub_2caa_2d7d
		; next iteration
		
$2CE7  48        PHA 
$2CE8  A8        TAY 
$2CE9  06 B1     ASL $B1 
$2CEB  06 B1     ASL $B1 
$2CED  B1 7C     LDA ($7C),Y ; Y = 0 [item0,0]
$2CEF  C8        INY 
$2CF0  C8        INY 
$2CF1  38        SEC 
$2CF2  F1 7E     SBC ($7E),Y ; Y = 2 [item1,2]
$2CF4  88        DEY 
$2CF5  B1 7C     LDA ($7C),Y ; Y = 1 [item0,1
$2CF7  C8        INY 
$2CF8  C8        INY 
$2CF9  F1 7E     SBC ($7E),Y ; Y = 3 [item1,3]
$2CFB  10 13     BPL L_BRS_($2D10)_($2CFB) OK ; branch if positive (item0,01 > item1,23)
$2CFD  88        DEY 	; here item0,01 < item1,23
$2CFE  88        DEY 
$2CFF  88        DEY 
$2D00  B1 7E     LDA ($7E),Y ; Y = 0 [item1,0]
$2D02  38        SEC 
$2D03  C8        INY 
$2D04  C8        INY 
$2D05  F1 7C     SBC ($7C),Y ; Y = 2 [item0,2]
$2D07  88        DEY 
$2D08  B1 7E     LDA ($7E),Y ; Y = 1 [item1,1]
$2D0A  C8        INY 
$2D0B  C8        INY 
$2D0C  F1 7C     SBC ($7C),Y ; Y = 3 [item0,3]
$2D0E  30 6D     BMI L_BRS_($2D7D)_($2D0E) OK ; branch to comparing next items if negative (item0,23 > item1,01)
//------------------------------
L_BRS_($2D10)_($2CFB) OK
//------------------------------
$2D10  88        DEY 	; here (item0,01 > item1,23) or ((item0,01 < item1,23) and (item1,01 > item0,23)) [unsigned]
$2D11  88        DEY 
$2D12  B1 7C     LDA ($7C),Y ; Y = 1
$2D14  29 80     AND #$80
$2D16  8D A5 2C  STA $2CA5 ; sign of item0,1
$2D19  C8        INY 
$2D1A  C8        INY 
$2D1B  B1 7C     LDA ($7C),Y ; Y = 3
$2D1D  29 80     AND #$80	; sign of item0,3
$2D1F  CD A5 2C  CMP $2CA5 
$2D22  D0 4A     BNE L_BRS_($2D6E)_($2D22) OK ; branch if signs item0,1 and item0,3 are not equal
$2D24  B1 7E     LDA ($7E),Y ; Y = 3 ; here sign of item0,1 and item0,3 are the same
$2D26  29 80     AND #$80
$2D28  8D A6 2C  STA $2CA6 ; sign of item1,3
$2D2B  88        DEY 
$2D2C  88        DEY 
$2D2D  B1 7E     LDA ($7E),Y ; Y = 1
$2D2F  29 80     AND #$80	; sign of item1,1
$2D31  CD A6 2C  CMP $2CA6 
$2D34  D0 41     BNE L_BRS_($2D77)_($2D34) OK ; branch if signs item1,3 and item1,1 are not equal
$2D36  CD A5 2C  CMP $2CA5 	; compare signs of item1,3 and item1,1 with sign of item0,1
$2D39  D0 42     BNE L_BRS_($2D7D)_($2D39) OK ; if sign item1,1 != item0,1, branch
$2D3B  88        DEY 	; here sign of item1,3 and item1,1 and item0,1 are the same
$2D3C  B1 7E     LDA ($7E),Y ; Y = 0 item1,0	; compare item0,01 and item1,01
$2D3E  38        SEC 
$2D3F  F1 7C     SBC ($7C),Y ; Y = 0 item0,0
$2D41  85 83     STA $83 
$2D43  C8        INY 
$2D44  B1 7E     LDA ($7E),Y ; Y = 1 item1,1
$2D46  F1 7C     SBC ($7C),Y ; Y = 1 item0,1
$2D48  85 84     STA $84 	; 83/84: item1,01 - item0,01
$2D4A  D0 06     BNE L_BRS_($2D52)_($2D4A) OK ; not equal item1,01 and item0,01
$2D4C  A5 83     LDA $83 
$2D4E  F0 0C     BEQ L_BRS_($2D5C)_($2D4E) OK ; equal item1,01 and item0,01
$2D50  A5 84     LDA $84 
//------------------------------
L_BRS_($2D52)_($2D4A) OK
//------------------------------
$2D52  29 80     AND #$80	; check if sign of (item1,01 - item0,01) is the same as item1,3
$2D54  CD A6 2C  CMP $2CA6 
$2D57  F0 15     BEQ L_BRS_($2D6E)_($2D57) OK
$2D59  4C 77 2D  JMP L_JMP_($2D77)_($2D59) OK
//------------------------------
L_BRS_($2D5C)_($2D4E) OK
//------------------------------
$2D5C  C8        INY 	; Y = 2
$2D5D  B1 7E     LDA ($7E),Y 
$2D5F  38        SEC 
$2D60  F1 7C     SBC ($7C),Y 
$2D62  C8        INY 	; Y = 3
$2D63  B1 7E     LDA ($7E),Y 
$2D65  F1 7C     SBC ($7C),Y 
$2D67  29 80     AND #$80	; compute sign of (item1,23 - item0,23)
$2D69  CD A6 2C  CMP $2CA6  ; check if the same as sign of sign of item1,3
$2D6C  D0 09     BNE L_BRS_($2D77)_($2D6C) OK ; branch if not
//------------------------------
L_BRS_($2D6E)_($2D22) OK
L_BRS_($2D6E)_($2D57) OK
//------------------------------
$2D6E  A5 B1     LDA $B1 
$2D70  09 01     ORA #$01
$2D72  85 B1     STA $B1 
$2D74  4C 7D 2D  JMP L_JMP_($2D7D)_($2D74) OK
//------------------------------
L_BRS_($2D77)_($2D34) OK
L_JMP_($2D77)_($2D59) OK
L_BRS_($2D77)_($2D6C) OK
//------------------------------
$2D77  A5 B1     LDA $B1 
$2D79  09 02     ORA #$02
$2D7B  85 B1     STA $B1 
//------------------------------
L_BRS_($2D7D)_($2D0E) OK
L_BRS_($2D7D)_($2D39) OK
L_JMP_($2D7D)_($2D74) OK
//------------------------------
$2D7D  68        PLA 
$2D7E  18        CLC 
$2D7F  69 04     ADC #$04
$2D81  C9 0C     CMP #$0C
$2D83  F0 03     BEQ L_BRS_($2D88)_($2D83) OK
$2D85  4C E7 2C  JMP L_JMP_($2CE7)_($2D85) OK
//------------------------------
L_BRS_($2D88)_($2D83) OK
//------------------------------
$2D88  A5 B1     LDA $B1 
$2D8A  C9 20     CMP #$20
$2D8C  F0 37     BEQ L_BRS_($2DC5)_($2D8C) OK
$2D8E  C9 08     CMP #$08
$2D90  F0 33     BEQ L_BRS_($2DC5)_($2D90) OK
$2D92  C9 02     CMP #$02
$2D94  F0 2F     BEQ L_BRS_($2DC5)_($2D94) OK
$2D96  C9 28     CMP #$28
$2D98  F0 2B     BEQ L_BRS_($2DC5)_($2D98) OK
$2D9A  C9 0A     CMP #$0A
$2D9C  F0 27     BEQ L_BRS_($2DC5)_($2D9C) OK
$2D9E  C9 22     CMP #$22
$2DA0  F0 23     BEQ L_BRS_($2DC5)_($2DA0) OK
$2DA2  C9 2A     CMP #$2A
$2DA4  F0 1F     BEQ L_BRS_($2DC5)_($2DA4) OK
$2DA6  A9 01     LDA #$01
$2DA8  85 B0     STA $B0 
$2DAA  A0 00     LDY #$00
//------------------------------
L_BRS_($2DAC)_($2DC3) OK
//------------------------------
$2DAC  B1 7A     LDA ($7A),Y 
$2DAE  AA        TAX 
$2DAF  C8        INY 
$2DB0  C8        INY 
$2DB1  C8        INY 
$2DB2  C8        INY 
$2DB3  B1 7A     LDA ($7A),Y 
$2DB5  48        PHA 
$2DB6  8A        TXA 
$2DB7  91 7A     STA ($7A),Y 
$2DB9  68        PLA 
$2DBA  88        DEY 
$2DBB  88        DEY 
$2DBC  88        DEY 
$2DBD  88        DEY 
$2DBE  91 7A     STA ($7A),Y 
$2DC0  C8        INY 
$2DC1  C0 04     CPY #$04
$2DC3  90 E7     BCC L_BRS_($2DAC)_($2DC3) OK
//------------------------------
L_BRS_($2DC5)_($2D8C) OK
L_BRS_($2DC5)_($2D90) OK
L_BRS_($2DC5)_($2D94) OK
L_BRS_($2DC5)_($2D98) OK
L_BRS_($2DC5)_($2D9C) OK
L_BRS_($2DC5)_($2DA0) OK
L_BRS_($2DC5)_($2DA4) OK
//------------------------------
$2DC5  A5 7A     LDA $7A 
$2DC7  18        CLC 
$2DC8  69 04     ADC #$04
$2DCA  85 7A     STA $7A 
$2DCC  90 02     BCC L_BRS_($2DD0)_($2DCC) OK
$2DCE  E6 7B     INC $7B 
//------------------------------
L_BRS_($2DD0)_($2DCC) OK
//------------------------------
$2DD0  C6 B3     DEC $B3 
$2DD2  F0 03     BEQ L_BRS_($2DD7)_($2DD2) OK
$2DD4  4C CD 2C  JMP L_JMP_($2CCD)_($2DD4) OK
//------------------------------
L_BRS_($2DD7)_($2DD2) OK
//------------------------------
$2DD7  A5 B0     LDA $B0 
$2DD9  F0 05     BEQ L_BRS_($2DE0)_($2DD9) OK
$2DDB  68        PLA 
$2DDC  AA        TAX 
$2DDD  4C AD 2C  JMP L_JMP_($2CAD)_($2DDD) OK
//------------------------------
L_BRS_($2DE0)_($2DD9) OK
//------------------------------
$2DE0  68        PLA 
//------------------------------
L_JMP_($2DE1)_($2CA7) OK
//------------------------------
$2DE1  60        RTS 
//------------------------------
L_JSR_($2DE3)_($1FF9) BAD
//------------------------------
$2DE2  35 20     AND $20,X 
$2DE4  60        RTS 
//------------------------------
$2DE5  45 AD     EOR $AD 
$2DE7  94 15     STY $15,X 
$2DE9  18        CLC 
$2DEA  69 04     ADC #$04
$2DEC  85 7A     STA $7A 
$2DEE  AD 95 15  LDA $1595 
$2DF1  69 00     ADC #$00
$2DF3  85 7B     STA $7B 
$2DF5  AD 54 15  LDA $1554 
$2DF8  F0 6D     BEQ L_BRS_($2E67)_($2DF8) OK
//------------------------------
L_BRS_($2DFA)_($2E65) OK
//------------------------------
$2DFA  48        PHA 
$2DFB  A0 00     LDY #$00
$2DFD  B1 7A     LDA ($7A),Y 
$2DFF  18        CLC 
$2E00  69 01     ADC #$01
$2E02  85 7C     STA $7C 
$2E04  C8        INY 
$2E05  B1 7A     LDA ($7A),Y 
$2E07  69 00     ADC #$00
$2E09  85 7D     STA $7D 
$2E0B  88        DEY 
$2E0C  B1 7C     LDA ($7C),Y 
$2E0E  F0 46     BEQ L_BRS_($2E56)_($2E0E) OK
$2E10  29 7F     AND #$7F
$2E12  8D E2 2D  STA $2DE2 
$2E15  E6 7C     INC $7C 
$2E17  D0 02     BNE L_BRS_($2E1B)_($2E17) OK
$2E19  E6 7D     INC $7D 
//------------------------------
L_BRS_($2E1B)_($2E17) OK
L_BRS_($2E1B)_($2E54) OK
//------------------------------
$2E1B  A0 00     LDY #$00
$2E1D  B1 7C     LDA ($7C),Y 
$2E1F  29 F0     AND #$F0
$2E21  4A        LSR A 
$2E22  4A        LSR A 
$2E23  4A        LSR A 
$2E24  4A        LSR A 
$2E25  8D 2F 17  STA $172F 
$2E28  B1 7C     LDA ($7C),Y 
$2E2A  29 0F     AND #$0F
$2E2C  8D 9E 15  STA $159E 
$2E2F  C9 02     CMP #$02
$2E31  F0 06     BEQ L_BRS_($2E39)_($2E31) OK
$2E33  20 16 3D  JSR L_JSR_($3D16)_($2E33) OK
$2E36  4C 3C 2E  JMP L_JMP_($2E3C)_($2E36) OK
//------------------------------
L_BRS_($2E39)_($2E31) OK
//------------------------------
$2E39  20 F3 3E  JSR L_JSR_($3EF3)_($2E39) OK
//------------------------------
L_JMP_($2E3C)_($2E36) OK
//------------------------------
$2E3C  20 84 38  JSR L_JSR_($3884)_($2E3C) OK
$2E3F  AD 9E 15  LDA $159E 
$2E42  0A        ASL A 
$2E43  18        CLC 
$2E44  69 01     ADC #$01
$2E46  18        CLC 
$2E47  65 7C     ADC $7C 
$2E49  85 7C     STA $7C 
$2E4B  A5 7D     LDA $7D 
$2E4D  69 00     ADC #$00
$2E4F  85 7D     STA $7D 
$2E51  CE E2 2D  DEC $2DE2 
$2E54  D0 C5     BNE L_BRS_($2E1B)_($2E54) OK
//------------------------------
L_BRS_($2E56)_($2E0E) OK
//------------------------------
$2E56  A5 7A     LDA $7A 
$2E58  18        CLC 
$2E59  69 04     ADC #$04
$2E5B  85 7A     STA $7A 
$2E5D  90 02     BCC L_BRS_($2E61)_($2E5D) OK
$2E5F  E6 7B     INC $7B 
//------------------------------
L_BRS_($2E61)_($2E5D) OK
//------------------------------
$2E61  68        PLA 
$2E62  38        SEC 
$2E63  E9 01     SBC #$01
$2E65  D0 93     BNE L_BRS_($2DFA)_($2E65) OK
//------------------------------
L_BRS_($2E67)_($2DF8) OK
//------------------------------
$2E67  AD 91 1C  LDA $1C91 
$2E6A  D0 08     BNE L_BRS_($2E74)_($2E6A) OK
$2E6C  AD A0 1C  LDA $1CA0 
$2E6F  F0 03     BEQ L_BRS_($2E74)_($2E6F) OK
$2E71  20 89 7B  JSR L_JSR_($7B89)_($2E71) OK
//------------------------------
L_BRS_($2E74)_($2E6A) OK
L_BRS_($2E74)_($2E6F) OK
//------------------------------
$2E74  60        RTS 
//------------------------------
$2E75            .byte $00,$00,$00
//------------------------------
L_BRS_($2E78)_($2E7E) OK
//------------------------------
$2E78  4C 68 2F  JMP L_JMP_($2F68)_($2E78) OK
//------------------------------
L_JSR_($2E7B)_($1FFC) OK
//------------------------------
$2E7B  AD 9B 17  LDA $179B 
$2E7E  F0 F8     BEQ L_BRS_($2E78)_($2E7E) OK
$2E80  8D 76 2E  STA $2E76 
$2E83  A9 38     LDA #$38
$2E85  85 7A     STA $7A 
$2E87  A9 17     LDA #$17
$2E89  85 7B     STA $7B 
//------------------------------
L_JMP_($2E8B)_($2F65) OK
//------------------------------
$2E8B  A0 03     LDY #$03
$2E8D  B1 7A     LDA ($7A),Y 
$2E8F  C9 01     CMP #$01
$2E91  D0 41     BNE L_BRS_($2ED4)_($2E91) OK
$2E93  AD 93 1C  LDA $1C93 
$2E96  48        PHA 
$2E97  AD 94 1C  LDA $1C94 
$2E9A  48        PHA 
$2E9B  A9 00     LDA #$00
$2E9D  8D 70 15  STA $1570 
$2EA0  C8        INY 
$2EA1  B1 7A     LDA ($7A),Y 
$2EA3  8D 93 1C  STA $1C93 
$2EA6  C8        INY 
$2EA7  B1 7A     LDA ($7A),Y 
$2EA9  8D 94 1C  STA $1C94 
$2EAC  A5 7A     LDA $7A 
$2EAE  48        PHA 
$2EAF  A5 7B     LDA $7B 
$2EB1  48        PHA 
$2EB2  20 52 60  JSR L_JSR_($6052)_($2EB2) OK
$2EB5  68        PLA 
$2EB6  85 7B     STA $7B 
$2EB8  68        PLA 
$2EB9  85 7A     STA $7A 
$2EBB  68        PLA 
$2EBC  8D 94 1C  STA $1C94 
$2EBF  68        PLA 
$2EC0  8D 93 1C  STA $1C93 
$2EC3  AD 70 15  LDA $1570 
$2EC6  A0 00     LDY #$00
$2EC8  D1 7A     CMP ($7A),Y 
$2ECA  F0 05     BEQ L_BRS_($2ED1)_($2ECA) OK
$2ECC  98        TYA 
$2ECD  A0 03     LDY #$03
$2ECF  91 7A     STA ($7A),Y 
//------------------------------
L_BRS_($2ED1)_($2ECA) OK
L_BRS_($2ED1)_($2ED6) OK
//------------------------------
$2ED1  4C 55 2F  JMP L_JMP_($2F55)_($2ED1) OK
//------------------------------
L_BRS_($2ED4)_($2E91) OK
//------------------------------
$2ED4  C9 02     CMP #$02
$2ED6  D0 F9     BNE L_BRS_($2ED1)_($2ED6) OK
$2ED8  A0 00     LDY #$00
$2EDA  B1 7A     LDA ($7A),Y 
$2EDC  8D 46 15  STA $1546 
$2EDF  A9 00     LDA #$00
$2EE1  20 C1 5C  JSR L_JSR_($5CC1)_($2EE1) BAD
$2EE4  AD 46 1C  LDA $1C46 
$2EE7  8D 75 2E  STA $2E75 
$2EEA  AD 32 15  LDA $1532 
$2EED  8D 77 2E  STA $2E77 
$2EF0  A0 01     LDY #$01
$2EF2  8C 46 1C  STY $1C46 
$2EF5  B1 7C     LDA ($7C),Y 
$2EF7  8D 37 15  STA $1537 
$2EFA  A9 00     LDA #$00
$2EFC  8D 32 15  STA $1532 
$2EFF  4E 37 15  LSR $1537 
$2F02  6A        ROR A 
$2F03  4E 37 15  LSR $1537 
$2F06  6A        ROR A 
$2F07  8D 36 15  STA $1536 
$2F0A  C8        INY 
$2F0B  B1 7C     LDA ($7C),Y 
$2F0D  8D 39 15  STA $1539 
$2F10  A9 00     LDA #$00
$2F12  4E 39 15  LSR $1539 
$2F15  6A        ROR A 
$2F16  4E 39 15  LSR $1539 
$2F19  6A        ROR A 
$2F1A  8D 38 15  STA $1538 
$2F1D  C8        INY 
$2F1E  B1 7C     LDA ($7C),Y 
$2F20  8D 3B 15  STA $153B 
$2F23  A9 00     LDA #$00
$2F25  4E 3B 15  LSR $153B 
$2F28  6A        ROR A 
$2F29  4E 3B 15  LSR $153B 
$2F2C  6A        ROR A 
$2F2D  8D 3A 15  STA $153A 
$2F30  A5 7A     LDA $7A 
$2F32  48        PHA 
$2F33  A5 7B     LDA $7B 
$2F35  48        PHA 
$2F36  20 77 4A  JSR L_JSR_($4A77)_($2F36) OK
$2F39  68        PLA 
$2F3A  85 7B     STA $7B 
$2F3C  68        PLA 
$2F3D  85 7A     STA $7A 
$2F3F  E0 00     CPX #$00
$2F41  D0 06     BNE L_BRS_($2F49)_($2F41) OK
$2F43  A0 03     LDY #$03
$2F45  A9 00     LDA #$00
$2F47  91 7A     STA ($7A),Y 
//------------------------------
L_BRS_($2F49)_($2F41) OK
//------------------------------
$2F49  AD 77 2E  LDA $2E77 
$2F4C  8D 32 15  STA $1532 
$2F4F  AD 75 2E  LDA $2E75 
$2F52  8D 46 1C  STA $1C46 
//------------------------------
L_JMP_($2F55)_($2ED1) OK
//------------------------------
$2F55  A5 7A     LDA $7A 
$2F57  18        CLC 
$2F58  69 06     ADC #$06
$2F5A  85 7A     STA $7A 
$2F5C  90 02     BCC L_BRS_($2F60)_($2F5C) OK
$2F5E  E6 7B     INC $7B 
//------------------------------
L_BRS_($2F60)_($2F5C) OK
//------------------------------
$2F60  CE 76 2E  DEC $2E76 
$2F63  F0 03     BEQ L_BRS_($2F68)_($2F63) OK
$2F65  4C 8B 2E  JMP L_JMP_($2E8B)_($2F65) OK
//------------------------------
L_JMP_($2F68)_($2E78) OK
L_BRS_($2F68)_($2F63) OK
//------------------------------
$2F68  AD 51 15  LDA $1551 
$2F6B  09 04     ORA #$04
$2F6D  8D 51 15  STA $1551 
//------------------------------
L_BRS_($2F70)_($2F75) OK
//------------------------------
$2F70  AD 51 15  LDA $1551 
$2F73  29 01     AND #$01
$2F75  D0 F9     BNE L_BRS_($2F70)_($2F75) OK
$2F77  AD 9B 17  LDA $179B 
$2F7A  8D 98 17  STA $1798 
$2F7D  A2 05     LDX #$05
$2F7F  A0 00     LDY #$00
//------------------------------
L_BRS_($2F81)_($2F94) OK
//------------------------------
$2F81  B9 6A 17  LDA $176A,Y 
$2F84  D9 39 17  CMP $1739,Y 
$2F87  90 02     BCC L_BRS_($2F8B)_($2F87) OK
$2F89  A9 05     LDA #$05
//------------------------------
L_BRS_($2F8B)_($2F87) OK
//------------------------------
$2F8B  99 3A 17  STA $173A,Y 
$2F8E  98        TYA 
$2F8F  18        CLC 
$2F90  69 06     ADC #$06
$2F92  A8        TAY 
$2F93  CA        DEX 
$2F94  D0 EB     BNE L_BRS_($2F81)_($2F94) OK
$2F96  A0 00     LDY #$00
//------------------------------
L_BRS_($2F98)_($2FA1) OK
//------------------------------
$2F98  B9 38 17  LDA $1738,Y 
$2F9B  99 68 17  STA $1768,Y 
$2F9E  C8        INY 
$2F9F  C0 1E     CPY #$1E
$2FA1  D0 F5     BNE L_BRS_($2F98)_($2FA1) OK
$2FA3  AD 4F 15  LDA $154F 
$2FA6  F0 03     BEQ L_BRS_($2FAB)_($2FA6) OK
$2FA8  20 33 5B  JSR L_JSR_($5B33)_($2FA8) BAD
//------------------------------
L_BRS_($2FAB)_($2FA6) OK
//------------------------------
$2FAB  20 DF 44  JSR L_JSR_($44DF)_($2FAB) OK
$2FAE  A9 00     LDA #$00
$2FB0  8D 51 15  STA $1551 
$2FB3  60        RTS 
//------------------------------
$2FB4  45 42     EOR $42 
$2FB6            .byte $42
$2FB7  45 45     EOR $45 
$2FB9            .byte $42,$42
$2FBB  45 45     EOR $45 
$2FBD            .byte $42,$42
$2FBF  45 45     EOR $45 
$2FC1            .byte $42,$42
$2FC3  45 45     EOR $45 
$2FC5            .byte $42
//------------------------------
L_JSR_($2FC6)_($23F1) OK
L_JSR_($2FC6)_($2421) OK
L_JSR_($2FC6)_($242F) OK
//------------------------------
$2FC6  A9 03     LDA #$03
$2FC8  85 B4     STA $B4 
$2FCA  A2 12     LDX #$12
$2FCC  A9 00     LDA #$00
//------------------------------
L_BRS_($2FCE)_($2FD2) OK
//------------------------------
$2FCE  9D B3 2F  STA $2FB3,X 
$2FD1  CA        DEX 
$2FD2  D0 FA     BNE L_BRS_($2FCE)_($2FD2) OK
$2FD4  85 B2     STA $B2 
$2FD6  85 B1     STA $B1 
//------------------------------
L_JMP_($2FD8)_($3021) OK
//------------------------------
$2FD8  85 B0     STA $B0 
$2FDA  A9 03     LDA #$03
$2FDC  85 B3     STA $B3 
//------------------------------
L_BRS_($2FDE)_($300B) OK
L_BRS_($2FDE)_($302E) OK
//------------------------------
$2FDE  A6 B0     LDX $B0 
$2FE0  A4 B1     LDY $B1 
$2FE2  B9 56 15  LDA $1556,Y 
$2FE5  A8        TAY 
$2FE6  BD 5F 15  LDA $155F,X 
$2FE9  AA        TAX 
$2FEA  20 76 1E  JSR L_JSR_($1E76)_($2FEA) OK
$2FED  A6 B2     LDX $B2 
$2FEF  BD B4 2F  LDA $2FB4,X 
$2FF2  18        CLC 
$2FF3  65 82     ADC $82 
$2FF5  9D B4 2F  STA $2FB4,X 
$2FF8  BD B5 2F  LDA $2FB5,X 
$2FFB  65 83     ADC $83 
$2FFD  9D B5 2F  STA $2FB5,X 
$3000  E6 B0     INC $B0 
$3002  A5 B1     LDA $B1 
$3004  18        CLC 
$3005  69 03     ADC #$03
$3007  85 B1     STA $B1 
$3009  C6 B3     DEC $B3 
$300B  D0 D1     BNE L_BRS_($2FDE)_($300B) OK
$300D  E6 B2     INC $B2 
$300F  E6 B2     INC $B2 
$3011  A5 B1     LDA $B1 
$3013  38        SEC 
$3014  E9 08     SBC #$08
$3016  85 B1     STA $B1 
$3018  C9 03     CMP #$03
$301A  B0 08     BCS L_BRS_($3024)_($301A) OK
$301C  A5 B0     LDA $B0 
$301E  38        SEC 
$301F  E9 03     SBC #$03
$3021  4C D8 2F  JMP L_JMP_($2FD8)_($3021) OK
//------------------------------
L_BRS_($3024)_($301A) OK
//------------------------------
$3024  A9 00     LDA #$00
$3026  85 B1     STA $B1 
$3028  A9 03     LDA #$03
$302A  85 B3     STA $B3 
$302C  C6 B4     DEC $B4 
$302E  D0 AE     BNE L_BRS_($2FDE)_($302E) OK
$3030  A2 12     LDX #$12
$3032  A0 09     LDY #$09
//------------------------------
L_BRS_($3034)_($304A) OK
//------------------------------
$3034  BD B3 2F  LDA $2FB3,X 
$3037  1E B2 2F  ASL $2FB2,X 
$303A  2A        ROL A 
$303B  1E B2 2F  ASL $2FB2,X 
$303E  2A        ROL A 
$303F  1E B2 2F  ASL $2FB2,X 
$3042  69 00     ADC #$00
$3044  99 55 15  STA $1555,Y 
$3047  CA        DEX 
$3048  CA        DEX 
$3049  88        DEY 
$304A  D0 E8     BNE L_BRS_($3034)_($304A) OK
$304C  60        RTS 
//------------------------------
L_JSR_($304D)_($3621) OK
//------------------------------
$304D  AD 9E 15  LDA $159E 
$3050  85 B2     STA $B2 
$3052  A0 0A     LDY #$0A
$3054  A9 00     LDA #$00
$3056  85 B3     STA $B3 
$3058  85 B0     STA $B0 
$305A  85 B1     STA $B1 
//------------------------------
L_BRS_($305C)_($306F) OK
//------------------------------
$305C  99 6F 00  STA $006F,Y 	; use sta zp,x
$305F  99 65 00  STA $0065,Y 
$3062  99 5B 00  STA $005B,Y 
$3065  99 51 00  STA $0051,Y 
$3068  99 47 00  STA $0047,Y 
$306B  99 3D 00  STA $003D,Y 
$306E  88        DEY 
$306F  D0 EB     BNE L_BRS_($305C)_($306F) OK
//------------------------------
L_BRS_($3071)_($30C9) OK
//------------------------------
$3071  A9 03     LDA #$03
$3073  85 B5     STA $B5 
//------------------------------
L_JMP_($3075)_($30C0) OK
//------------------------------
$3075  85 B4     STA $B4 
//------------------------------
L_BRS_($3077)_($30AD) OK
//------------------------------
$3077  A6 B3     LDX $B3 
$3079  BC 56 15  LDY $1556,X 
$307C  84 82     STY $82 
$307E  A4 B1     LDY $B1 
$3080  B9 02 00  LDA $0002,Y 
$3083  B6 03     LDX $03,Y 
$3085  A4 82     LDY $82 
$3087  20 A3 1C  JSR L_JSR_($1CA3)_($3087) OK	; multiply 16*8
$308A  06 82     ASL $82 	; 5;	lda $83		; 3
$308C  26 83     ROL $83 	; 5;	asl $82		; 5
$308E  26 84     ROL $84 	; 5;	rol @		; 2
$3090  06 82     ASL $82 	; 5;	rol $84		; 5
$3092  26 83     ROL $83 	; 5;	asl $82		; 5
$3094  26 84     ROL $84 	; 5;	rol @		; 2
$3096  A6 B0     LDX $B0 	; 3;	asl $84		; 5
$3098  B5 3E     LDA $3E,X 	; 4;	ldx $b0		; 3
$309A  18        CLC 		; 2;	clc			; 2
$309B  65 83     ADC $83 	; 3 = 42;	adc $3e,x	; 4 = 36
//------------------------------
L_BRS_($309D)_($30E6) OK
//------------------------------
$309D  95 3E     STA $3E,X 
$309F  B5 3F     LDA $3F,X 
$30A1  65 84     ADC $84 
$30A3  95 3F     STA $3F,X 
$30A5  E6 B3     INC $B3 
$30A7  E6 B1     INC $B1 	
$30A9  E6 B1     INC $B1 
$30AB  C6 B4     DEC $B4 
$30AD  D0 C8     BNE L_BRS_($3077)_($30AD) OK
$30AF  E6 B0     INC $B0 
$30B1  E6 B0     INC $B0 
$30B3  C6 B5     DEC $B5 
$30B5  F0 0C     BEQ L_BRS_($30C3)_($30B5) OK
$30B7  A5 B1     LDA $B1 	
$30B9  38        SEC 
$30BA  E9 06     SBC #$06
$30BC  85 B1     STA $B1 
$30BE  A9 03     LDA #$03
$30C0  4C 75 30  JMP L_JMP_($3075)_($30C0) OK
//------------------------------
L_BRS_($30C3)_($30B5) OK
//------------------------------
$30C3  A9 00     LDA #$00
$30C5  85 B3     STA $B3 
$30C7  C6 B2     DEC $B2 
$30C9  D0 A6     BNE L_BRS_($3071)_($30C9) OK
$30CB  60        RTS 
//------------------------------
L_JSR_($30CC)_($36F4) OK
L_JSR_($30CC)_($378E) OK
//------------------------------
$30CC  8A        TXA 
$30CD  48        PHA 
$30CE  48        PHA 
$30CF  AD 35 15  LDA $1535 
$30D2  0A        ASL A 
$30D3  A8        TAY 
$30D4  88        DEY 
$30D5  88        DEY 
$30D6  B9 E5 30  LDA $30E5,Y 
$30D9  8D E3 30  STA $30E3 
$30DC  B9 E6 30  LDA $30E6,Y 
$30DF  8D E4 30  STA $30E4 
$30E2  4C FF FF  JMP L_JMP_($FFFF)_($30E2) JAM
$30E5            .byte $EF
$30E6  30 B5     BMI L_BRS_($309D)_($30E6) OK
$30E8  31 7B     AND ($7B),Y 
$30EA            .byte $32,$34,$33
$30ED  ED 33 B5  SBC $B533 
$30F0  38        SEC 
$30F1  18        CLC 
$30F2  75 3C     ADC $3C,X 
$30F4  85 BC     STA $BC 
$30F6  85 88     STA $88 
$30F8  B5 39     LDA $39,X 
$30FA  75 3D     ADC $3D,X 
$30FC  85 BD     STA $BD 
$30FE  85 89     STA $89 
$3100  B5 38     LDA $38,X 
$3102  38        SEC 
$3103  F5 3E     SBC $3E,X 
$3105  85 82     STA $82 
$3107  B5 39     LDA $39,X 
$3109  F5 3F     SBC $3F,X 
$310B  85 83     STA $83 
$310D  A5 82     LDA $82 
$310F  38        SEC 
$3110  F5 42     SBC $42,X 
$3112  85 82     STA $82 
$3114  A5 83     LDA $83 
$3116  F5 43     SBC $43,X 
$3118  85 83     STA $83 
$311A  A5 82     LDA $82 
$311C  18        CLC 
$311D  75 3C     ADC $3C,X 
$311F  85 BE     STA $BE 
$3121  A5 83     LDA $83 
$3123  75 3D     ADC $3D,X 
$3125  85 BF     STA $BF 
$3127  B5 42     LDA $42,X 
$3129  38        SEC 
$312A  F5 3C     SBC $3C,X 
$312C  85 8C     STA $8C 
$312E  B5 43     LDA $43,X 
$3130  F5 3D     SBC $3D,X 
$3132  85 8D     STA $8D 
$3134  20 31 1D  JSR L_JSR_($1D31)_($3134) OK
$3137  A5 BE     LDA $BE 
$3139  85 8C     STA $8C 
$313B  A5 BF     LDA $BF 
$313D  85 8D     STA $8D 
$313F  A5 82     LDA $82 
$3141  85 88     STA $88 
$3143  A5 83     LDA $83 
$3145  85 89     STA $89 
$3147  A5 84     LDA $84 
$3149  85 8A     STA $8A 
$314B  A5 85     LDA $85 
$314D  85 8B     STA $8B 
$314F  20 DE 1E  JSR L_JSR_($1EDE)_($314F) OK
$3152  68        PLA 
$3153  AA        TAX 
$3154  B5 3C     LDA $3C,X 
$3156  18        CLC 
$3157  65 88     ADC $88 
$3159  95 3C     STA $3C,X 
$315B  B5 3D     LDA $3D,X 
$315D  65 89     ADC $89 
$315F  95 3D     STA $3D,X 
$3161  B5 3C     LDA $3C,X 
$3163  49 FF     EOR #$FF
$3165  18        CLC 
$3166  69 01     ADC #$01
$3168  95 38     STA $38,X 
$316A  B5 3D     LDA $3D,X 
$316C  49 FF     EOR #$FF
$316E  69 00     ADC #$00
$3170  95 39     STA $39,X 
$3172  B5 40     LDA $40,X 
$3174  38        SEC 
$3175  F5 3A     SBC $3A,X 
$3177  85 8C     STA $8C 
$3179  B5 41     LDA $41,X 
$317B  F5 3B     SBC $3B,X 
$317D  85 8D     STA $8D 
$317F  A5 BC     LDA $BC 
$3181  85 88     STA $88 
$3183  A5 BD     LDA $BD 
$3185  85 89     STA $89 
$3187  20 31 1D  JSR L_JSR_($1D31)_($3187) OK
$318A  A5 BE     LDA $BE 
$318C  85 8C     STA $8C 
$318E  A5 BF     LDA $BF 
$3190  85 8D     STA $8D 
$3192  A5 82     LDA $82 
$3194  85 88     STA $88 
$3196  A5 83     LDA $83 
$3198  85 89     STA $89 
$319A  A5 84     LDA $84 
$319C  85 8A     STA $8A 
$319E  A5 85     LDA $85 
$31A0  85 8B     STA $8B 
$31A2  20 DE 1E  JSR L_JSR_($1EDE)_($31A2) OK
$31A5  68        PLA 
$31A6  AA        TAX 
$31A7  A5 88     LDA $88 
$31A9  18        CLC 
$31AA  75 3A     ADC $3A,X 
$31AC  95 3A     STA $3A,X 
$31AE  A5 89     LDA $89 
$31B0  75 3B     ADC $3B,X 
$31B2  95 3B     STA $3B,X 
$31B4  60        RTS 
//------------------------------
$31B5  B5 3A     LDA $3A,X 
$31B7  18        CLC 
$31B8  75 3C     ADC $3C,X 
$31BA  85 BC     STA $BC 
$31BC  85 88     STA $88 
$31BE  B5 3B     LDA $3B,X 
$31C0  75 3D     ADC $3D,X 
$31C2  85 BD     STA $BD 
$31C4  85 89     STA $89 
$31C6  B5 3A     LDA $3A,X 
$31C8  38        SEC 
$31C9  F5 40     SBC $40,X 
$31CB  85 82     STA $82 
$31CD  B5 3B     LDA $3B,X 
$31CF  F5 41     SBC $41,X 
$31D1  85 83     STA $83 
$31D3  A5 82     LDA $82 
$31D5  38        SEC 
$31D6  F5 42     SBC $42,X 
$31D8  85 82     STA $82 
$31DA  A5 83     LDA $83 
$31DC  F5 43     SBC $43,X 
$31DE  85 83     STA $83 
$31E0  A5 82     LDA $82 
$31E2  18        CLC 
$31E3  75 3C     ADC $3C,X 
$31E5  85 BE     STA $BE 
$31E7  A5 83     LDA $83 
$31E9  75 3D     ADC $3D,X 
$31EB  85 BF     STA $BF 
$31ED  B5 42     LDA $42,X 
$31EF  38        SEC 
$31F0  F5 3C     SBC $3C,X 
$31F2  85 8C     STA $8C 
$31F4  B5 43     LDA $43,X 
$31F6  F5 3D     SBC $3D,X 
$31F8  85 8D     STA $8D 
$31FA  20 31 1D  JSR L_JSR_($1D31)_($31FA) OK
$31FD  A5 BE     LDA $BE 
$31FF  85 8C     STA $8C 
$3201  A5 BF     LDA $BF 
$3203  85 8D     STA $8D 
$3205  A5 82     LDA $82 
$3207  85 88     STA $88 
$3209  A5 83     LDA $83 
//------------------------------
L_JSR_($320B)_($BB6B) OK
//------------------------------
$320B  85 89     STA $89 
$320D  A5 84     LDA $84 
$320F  85 8A     STA $8A 
$3211  A5 85     LDA $85 
$3213  85 8B     STA $8B 
$3215  20 DE 1E  JSR L_JSR_($1EDE)_($3215) OK
$3218  68        PLA 
$3219  AA        TAX 
$321A  B5 3C     LDA $3C,X 
$321C  18        CLC 
$321D  65 88     ADC $88 
$321F  95 3C     STA $3C,X 
$3221  B5 3D     LDA $3D,X 
$3223  65 89     ADC $89 
$3225  95 3D     STA $3D,X 
$3227  B5 3C     LDA $3C,X 
$3229  49 FF     EOR #$FF
$322B  18        CLC 
$322C  69 01     ADC #$01
$322E  95 3A     STA $3A,X 
$3230  B5 3D     LDA $3D,X 
//------------------------------
L_JSR_($3233)_($BE18) BAD
//------------------------------
$3232  49 FF     EOR #$FF
$3234  69 00     ADC #$00
$3236  95 3B     STA $3B,X 
$3238  B5 3E     LDA $3E,X 
$323A  38        SEC 
$323B  F5 38     SBC $38,X 
$323D  85 8C     STA $8C 
$323F  B5 3F     LDA $3F,X 
$3241  F5 39     SBC $39,X 
$3243  85 8D     STA $8D 
$3245  A5 BC     LDA $BC 
$3247  85 88     STA $88 
$3249  A5 BD     LDA $BD 
$324B  85 89     STA $89 
$324D  20 31 1D  JSR L_JSR_($1D31)_($324D) OK
$3250  A5 BE     LDA $BE 
$3252  85 8C     STA $8C 
$3254  A5 BF     LDA $BF 
$3256  85 8D     STA $8D 
$3258  A5 82     LDA $82 
$325A  85 88     STA $88 
$325C  A5 83     LDA $83 
$325E  85 89     STA $89 
$3260  A5 84     LDA $84 
$3262  85 8A     STA $8A 
$3264  A5 85     LDA $85 
$3266  85 8B     STA $8B 
$3268  20 DE 1E  JSR L_JSR_($1EDE)_($3268) OK
$326B  68        PLA 
$326C  AA        TAX 
$326D  A5 88     LDA $88 
$326F  18        CLC 
$3270  75 38     ADC $38,X 
$3272  95 38     STA $38,X 
$3274  A5 89     LDA $89 
$3276  75 39     ADC $39,X 
$3278  95 39     STA $39,X 
$327A  60        RTS 
//------------------------------
$327B  B5 3C     LDA $3C,X 
$327D  38        SEC 
$327E  F5 38     SBC $38,X 
$3280  85 BC     STA $BC 
$3282  85 88     STA $88 
$3284  B5 3D     LDA $3D,X 
$3286  F5 39     SBC $39,X 
$3288  85 BD     STA $BD 
$328A  85 89     STA $89 
$328C  B5 3E     LDA $3E,X 
$328E  38        SEC 
$328F  F5 38     SBC $38,X 
$3291  85 82     STA $82 
$3293  B5 3F     LDA $3F,X 
$3295  F5 39     SBC $39,X 
$3297  85 83     STA $83 
$3299  A5 82     LDA $82 
$329B  38        SEC 
$329C  F5 42     SBC $42,X 
$329E  85 82     STA $82 
$32A0  A5 83     LDA $83 
$32A2  F5 43     SBC $43,X 
$32A4  85 83     STA $83 
$32A6  A5 82     LDA $82 
$32A8  18        CLC 
$32A9  75 3C     ADC $3C,X 
$32AB  85 BE     STA $BE 
$32AD  A5 83     LDA $83 
$32AF  75 3D     ADC $3D,X 
$32B1  85 BF     STA $BF 
$32B3  B5 42     LDA $42,X 
$32B5  38        SEC 
$32B6  F5 3C     SBC $3C,X 
$32B8  85 8C     STA $8C 
$32BA  B5 43     LDA $43,X 
$32BC  F5 3D     SBC $3D,X 
$32BE  85 8D     STA $8D 
$32C0  20 31 1D  JSR L_JSR_($1D31)_($32C0) OK
$32C3  A5 BE     LDA $BE 
$32C5  85 8C     STA $8C 
$32C7  A5 BF     LDA $BF 
$32C9  85 8D     STA $8D 
$32CB  A5 82     LDA $82 
$32CD  85 88     STA $88 
$32CF  A5 83     LDA $83 
$32D1  85 89     STA $89 
$32D3  A5 84     LDA $84 
$32D5  85 8A     STA $8A 
$32D7  A5 85     LDA $85 
$32D9  85 8B     STA $8B 
$32DB  20 DE 1E  JSR L_JSR_($1EDE)_($32DB) OK
$32DE  68        PLA 
$32DF  AA        TAX 
$32E0  B5 3C     LDA $3C,X 
$32E2  18        CLC 
$32E3  65 88     ADC $88 
$32E5  95 3C     STA $3C,X 
$32E7  95 38     STA $38,X 
$32E9  B5 3D     LDA $3D,X 
$32EB  65 89     ADC $89 
$32ED  95 3D     STA $3D,X 
$32EF  95 39     STA $39,X 
$32F1  B5 40     LDA $40,X 
$32F3  38        SEC 
$32F4  F5 3A     SBC $3A,X 
$32F6  85 8C     STA $8C 
$32F8  B5 41     LDA $41,X 
$32FA  F5 3B     SBC $3B,X 
$32FC  85 8D     STA $8D 
$32FE  A5 BC     LDA $BC 
$3300  85 88     STA $88 
$3302  A5 BD     LDA $BD 
$3304  85 89     STA $89 
$3306  20 31 1D  JSR L_JSR_($1D31)_($3306) OK
$3309  A5 BE     LDA $BE 
$330B  85 8C     STA $8C 
$330D  A5 BF     LDA $BF 
$330F  85 8D     STA $8D 
$3311  A5 82     LDA $82 
$3313  85 88     STA $88 
$3315  A5 83     LDA $83 
$3317  85 89     STA $89 
$3319  A5 84     LDA $84 
$331B  85 8A     STA $8A 
$331D  A5 85     LDA $85 
$331F  85 8B     STA $8B 
$3321  20 DE 1E  JSR L_JSR_($1EDE)_($3321) OK
$3324  68        PLA 
$3325  AA        TAX 
$3326  A5 88     LDA $88 
$3328  18        CLC 
$3329  75 3A     ADC $3A,X 
$332B  95 3A     STA $3A,X 
$332D  A5 89     LDA $89 
$332F  75 3B     ADC $3B,X 
$3331  95 3B     STA $3B,X 
//------------------------------
L_JSR_($3333)_($1F80) OK
//------------------------------
$3333  60        RTS 
//------------------------------
$3334  B5 3C     LDA $3C,X 
$3336  38        SEC 
$3337  F5 3A     SBC $3A,X 
$3339  85 BC     STA $BC 
$333B  85 88     STA $88 
$333D  B5 3D     LDA $3D,X 
$333F  F5 3B     SBC $3B,X 
$3341  85 BD     STA $BD 
$3343  85 89     STA $89 
$3345  B5 40     LDA $40,X 
$3347  38        SEC 
$3348  F5 3A     SBC $3A,X 
$334A  85 82     STA $82 
$334C  B5 41     LDA $41,X 
$334E  F5 3B     SBC $3B,X 
$3350  85 83     STA $83 
$3352  A5 82     LDA $82 
$3354  38        SEC 
$3355  F5 42     SBC $42,X 
$3357  85 82     STA $82 
$3359  A5 83     LDA $83 
$335B  F5 43     SBC $43,X 
$335D  85 83     STA $83 
$335F  A5 82     LDA $82 
$3361  18        CLC 
$3362  75 3C     ADC $3C,X 
$3364  85 BE     STA $BE 
$3366  A5 83     LDA $83 
$3368  75 3D     ADC $3D,X 
$336A  85 BF     STA $BF 
$336C  B5 42     LDA $42,X 
$336E  38        SEC 
$336F  F5 3C     SBC $3C,X 
$3371  85 8C     STA $8C 
$3373  B5 43     LDA $43,X 
$3375  F5 3D     SBC $3D,X 
$3377  85 8D     STA $8D 
$3379  20 31 1D  JSR L_JSR_($1D31)_($3379) OK
$337C  A5 BE     LDA $BE 
$337E  85 8C     STA $8C 
$3380  A5 BF     LDA $BF 
$3382  85 8D     STA $8D 
$3384  A5 82     LDA $82 
$3386  85 88     STA $88 
$3388  A5 83     LDA $83 
$338A  85 89     STA $89 
$338C  A5 84     LDA $84 
$338E  85 8A     STA $8A 
$3390  A5 85     LDA $85 
$3392  85 8B     STA $8B 
$3394  20 DE 1E  JSR L_JSR_($1EDE)_($3394) OK
$3397  68        PLA 
$3398  AA        TAX 
$3399  B5 3C     LDA $3C,X 
$339B  18        CLC 
$339C  65 88     ADC $88 
$339E  95 3C     STA $3C,X 
$33A0  95 3A     STA $3A,X 
$33A2  B5 3D     LDA $3D,X 
$33A4  65 89     ADC $89 
$33A6  95 3D     STA $3D,X 
$33A8  95 3B     STA $3B,X 
$33AA  B5 3E     LDA $3E,X 
$33AC  38        SEC 
$33AD  F5 38     SBC $38,X 
$33AF  85 8C     STA $8C 
$33B1  B5 3F     LDA $3F,X 
$33B3  F5 39     SBC $39,X 
$33B5  85 8D     STA $8D 
$33B7  A5 BC     LDA $BC 
$33B9  85 88     STA $88 
$33BB  A5 BD     LDA $BD 
$33BD  85 89     STA $89 
$33BF  20 31 1D  JSR L_JSR_($1D31)_($33BF) OK
$33C2  A5 BE     LDA $BE 
$33C4  85 8C     STA $8C 
$33C6  A5 BF     LDA $BF 
$33C8  85 8D     STA $8D 
$33CA  A5 82     LDA $82 
$33CC  85 88     STA $88 
$33CE  A5 83     LDA $83 
$33D0  85 89     STA $89 
$33D2  A5 84     LDA $84 
$33D4  85 8A     STA $8A 
$33D6  A5 85     LDA $85 
$33D8  85 8B     STA $8B 
$33DA  20 DE 1E  JSR L_JSR_($1EDE)_($33DA) OK
$33DD  68        PLA 
$33DE  AA        TAX 
$33DF  A5 88     LDA $88 
$33E1  18        CLC 
$33E2  75 38     ADC $38,X 
$33E4  95 38     STA $38,X 
$33E6  A5 89     LDA $89 
$33E8  75 39     ADC $39,X 
$33EA  95 39     STA $39,X 
$33EC  60        RTS 
//------------------------------
$33ED  B5 3C     LDA $3C,X 
$33EF  85 88     STA $88 
$33F1  85 BE     STA $BE 
$33F3  38        SEC 
$33F4  F5 42     SBC $42,X 
$33F6  85 BC     STA $BC 
$33F8  B5 3D     LDA $3D,X 
$33FA  85 89     STA $89 
$33FC  85 BF     STA $BF 
$33FE  F5 43     SBC $43,X 
$3400  85 BD     STA $BD 
$3402  B5 3E     LDA $3E,X 
$3404  38        SEC 
$3405  F5 38     SBC $38,X 
$3407  85 8C     STA $8C 
$3409  B5 3F     LDA $3F,X 
$340B  F5 39     SBC $39,X 
$340D  85 8D     STA $8D 
$340F  A9 00     LDA #$00
$3411  95 3D     STA $3D,X 
$3413  95 3C     STA $3C,X 
$3415  20 31 1D  JSR L_JSR_($1D31)_($3415) OK
$3418  A5 82     LDA $82 
$341A  85 88     STA $88 
$341C  A5 83     LDA $83 
$341E  85 89     STA $89 
$3420  A5 84     LDA $84 
$3422  85 8A     STA $8A 
$3424  A5 85     LDA $85 
$3426  85 8B     STA $8B 
$3428  A5 BC     LDA $BC 
$342A  85 8C     STA $8C 
$342C  A5 BD     LDA $BD 
$342E  85 8D     STA $8D 
$3430  20 DE 1E  JSR L_JSR_($1EDE)_($3430) OK
$3433  68        PLA 
$3434  AA        TAX 
$3435  A5 88     LDA $88 
$3437  18        CLC 
$3438  75 38     ADC $38,X 
$343A  95 38     STA $38,X 
$343C  A5 89     LDA $89 
$343E  75 39     ADC $39,X 
$3440  95 39     STA $39,X 
$3442  B5 40     LDA $40,X 
$3444  38        SEC 
$3445  F5 3A     SBC $3A,X 
$3447  85 88     STA $88 
$3449  B5 41     LDA $41,X 
$344B  F5 3B     SBC $3B,X 
$344D  85 89     STA $89 
$344F  A5 BE     LDA $BE 
$3451  85 8C     STA $8C 
$3453  A5 BF     LDA $BF 
$3455  85 8D     STA $8D 
$3457  20 31 1D  JSR L_JSR_($1D31)_($3457) OK
$345A  A5 82     LDA $82 
$345C  85 88     STA $88 
$345E  A5 83     LDA $83 
$3460  85 89     STA $89 
$3462  A5 84     LDA $84 
$3464  85 8A     STA $8A 
$3466  A5 85     LDA $85 
$3468  85 8B     STA $8B 
$346A  A5 BC     LDA $BC 
$346C  85 8C     STA $8C 
$346E  A5 BD     LDA $BD 
$3470  85 8D     STA $8D 
$3472  20 DE 1E  JSR L_JSR_($1EDE)_($3472) OK
$3475  68        PLA 
$3476  AA        TAX 
$3477  A5 88     LDA $88 
$3479  18        CLC 
$347A  75 3A     ADC $3A,X 
$347C  95 3A     STA $3A,X 
$347E  A5 89     LDA $89 
$3480  75 3B     ADC $3B,X 
$3482  95 3B     STA $3B,X 
$3484  60        RTS 
//------------------------------
L_JSR_($3485)_($363B) OK
L_JSR_($3485)_($367E) OK
//------------------------------
$3485  A0 00     LDY #$00
$3487  AD 35 15  LDA $1535 
$348A  C9 01     CMP #$01
$348C  D0 1C     BNE L_BRS_($34AA)_($348C) OK
$348E  B5 3E     LDA $3E,X 
$3490  18        CLC 
$3491  75 42     ADC $42,X 
$3493  85 AF     STA $AF 
$3495  B5 3F     LDA $3F,X 
$3497  75 43     ADC $43,X 
$3499  08        PHP 
$349A  D0 07     BNE L_BRS_($34A3)_($349A) OK
$349C  A5 AF     LDA $AF 
$349E  F0 1E     BEQ L_BRS_($34BE)_($349E) OK
$34A0  4C 20 35  JMP L_JMP_($3520)_($34A0) OK
//------------------------------
L_BRS_($34A3)_($349A) OK
//------------------------------
$34A3  28        PLP 
$34A4  10 3D     BPL L_BRS_($34E3)_($34A4) OK
$34A6  C8        INY 
$34A7  4C E3 34  JMP L_JMP_($34E3)_($34A7) OK
//------------------------------
L_BRS_($34AA)_($348C) OK
//------------------------------
$34AA  C9 02     CMP #$02
$34AC  D0 1C     BNE L_BRS_($34CA)_($34AC) OK
$34AE  B5 40     LDA $40,X 
$34B0  18        CLC 
$34B1  75 42     ADC $42,X 
$34B3  85 AF     STA $AF 
$34B5  B5 41     LDA $41,X 
$34B7  75 43     ADC $43,X 
$34B9  08        PHP 
$34BA  D0 07     BNE L_BRS_($34C3)_($34BA) OK
$34BC  A5 AF     LDA $AF 
//------------------------------
L_BRS_($34BE)_($349E) OK
//------------------------------
$34BE  F0 1E     BEQ L_BRS_($34DE)_($34BE) OK
$34C0  4C 20 35  JMP L_JMP_($3520)_($34C0) OK
//------------------------------
L_BRS_($34C3)_($34BA) OK
//------------------------------
$34C3  28        PLP 
$34C4  10 1D     BPL L_BRS_($34E3)_($34C4) OK
$34C6  C8        INY 
$34C7  4C E3 34  JMP L_JMP_($34E3)_($34C7) OK
//------------------------------
L_BRS_($34CA)_($34AC) OK
//------------------------------
$34CA  C9 03     CMP #$03
$34CC  D0 1D     BNE L_BRS_($34EB)_($34CC) OK
$34CE  B5 42     LDA $42,X 
$34D0  38        SEC 
$34D1  F5 3E     SBC $3E,X 
$34D3  85 AF     STA $AF 
$34D5  B5 43     LDA $43,X 
$34D7  F5 3F     SBC $3F,X 
$34D9  08        PHP 
$34DA  D0 08     BNE L_BRS_($34E4)_($34DA) OK
$34DC  A5 AF     LDA $AF 
//------------------------------
L_BRS_($34DE)_($34BE) OK
//------------------------------
$34DE  F0 3F     BEQ L_BRS_($351F)_($34DE) OK
$34E0  4C 20 35  JMP L_JMP_($3520)_($34E0) OK
//------------------------------
L_BRS_($34E3)_($34A4) OK
L_JMP_($34E3)_($34A7) OK
L_BRS_($34E3)_($34C4) OK
L_JMP_($34E3)_($34C7) OK
L_BRS_($34E3)_($34E5) OK
L_JMP_($34E3)_($34E8) OK
L_BRS_($34E3)_($3505) OK
L_JMP_($34E3)_($3508) OK
L_BRS_($34E3)_($3515) OK
L_JMP_($34E3)_($3518) OK
L_JMP_($34E3)_($351C) OK
//------------------------------
$34E3  60        RTS 
//------------------------------
L_BRS_($34E4)_($34DA) OK
//------------------------------
$34E4  28        PLP 
$34E5  10 FC     BPL L_BRS_($34E3)_($34E5) OK
$34E7  C8        INY 
$34E8  4C E3 34  JMP L_JMP_($34E3)_($34E8) OK
//------------------------------
L_BRS_($34EB)_($34CC) OK
//------------------------------
$34EB  C9 04     CMP #$04
$34ED  D0 1C     BNE L_BRS_($350B)_($34ED) OK
$34EF  B5 42     LDA $42,X 
$34F1  38        SEC 
$34F2  F5 40     SBC $40,X 
$34F4  85 AF     STA $AF 
$34F6  B5 43     LDA $43,X 
$34F8  F5 41     SBC $41,X 
$34FA  08        PHP 
$34FB  D0 07     BNE L_BRS_($3504)_($34FB) OK
$34FD  A5 AF     LDA $AF 
$34FF  F0 1E     BEQ L_BRS_($351F)_($34FF) OK
$3501  4C 20 35  JMP L_JMP_($3520)_($3501) OK
//------------------------------
L_BRS_($3504)_($34FB) OK
//------------------------------
$3504  28        PLP 
$3505  10 DC     BPL L_BRS_($34E3)_($3505) OK
$3507  C8        INY 
$3508  4C E3 34  JMP L_JMP_($34E3)_($3508) OK
//------------------------------
L_BRS_($350B)_($34ED) OK
//------------------------------
$350B  A9 80     LDA #$80
$350D  35 43     AND $43,X 
$350F  D0 0A     BNE L_BRS_($351B)_($350F) OK
$3511  B5 42     LDA $42,X 
$3513  15 43     ORA $43,X
$3515  D0 CC     BNE L_BRS_($34E3)_($3515) OK
$3517  88        DEY 
$3518  4C E3 34  JMP L_JMP_($34E3)_($3518) OK
//------------------------------
L_BRS_($351B)_($350F) OK
//------------------------------
$351B  C8        INY 
$351C  4C E3 34  JMP L_JMP_($34E3)_($351C) OK
//------------------------------
L_BRS_($351F)_($34DE) OK
L_BRS_($351F)_($34FF) OK
//------------------------------
$351F  88        DEY 
//------------------------------
L_JSR_($3520)_($19E2) OK
L_JMP_($3520)_($34A0) OK
L_JMP_($3520)_($34C0) OK
L_JMP_($3520)_($34E0) OK
L_JMP_($3520)_($3501) OK
//------------------------------
$3520  28        PLP 
//------------------------------
L_JSR_($3521)_($B3B9) OK
//------------------------------
$3521  60        RTS 
//------------------------------
L_JSR_($3522)_($39E1) OK
L_JSR_($3522)_($3BB7) OK
//------------------------------
$3522  AD 9E 15  LDA $159E 
$3525  85 B2     STA $B2 
$3527  A9 00     LDA #$00
$3529  85 B0     STA $B0 
$352B  85 B1     STA $B1 
$352D  AA        TAX 
$352E  A8        TAY 
//------------------------------
L_BRS_($352F)_($354A) OK
//------------------------------
$352F  B5 42     LDA $42,X 
$3531  D0 1A     BNE L_BRS_($354D)_($3531) OK
$3533  B5 43     LDA $43,X 
$3535  D0 16     BNE L_BRS_($354D)_($3535) OK
$3537  A9 40     LDA #$40
$3539  99 C0 00  STA $00C0,Y 
$353C  A9 34     LDA #$34
$353E  99 C1 00  STA $00C1,Y 
$3541  C8        INY 
$3542  C8        INY 
$3543  8A        TXA 
$3544  18        CLC 
$3545  69 06     ADC #$06
$3547  AA        TAX 
$3548  C6 B2     DEC $B2 
$354A  D0 E3     BNE L_BRS_($352F)_($354A) OK
$354C  60        RTS 
//------------------------------
L_BRS_($354D)_($3531) OK
L_BRS_($354D)_($3535) OK
L_JMP_($354D)_($361D) OK
//------------------------------
$354D  84 B0     STY $B0 
$354F  86 B1     STX $B1 
$3551  B5 3F     LDA $3F,X 
$3553  10 10     BPL L_BRS_($3565)_($3553) OK
$3555  B5 42     LDA $42,X 
$3557  18        CLC 
$3558  75 3E     ADC $3E,X 
$355A  B5 43     LDA $43,X 
$355C  75 3F     ADC $3F,X 
$355E  10 19     BPL L_BRS_($3579)_($355E) OK
$3560  A9 00     LDA #$00
$3562  4C BA 35  JMP L_JMP_($35BA)_($3562) OK
//------------------------------
L_BRS_($3565)_($3553) OK
//------------------------------
$3565  B5 3E     LDA $3E,X 
$3567  38        SEC 
$3568  F5 42     SBC $42,X 
$356A  B5 3F     LDA $3F,X 
$356C  F5 43     SBC $43,X 
$356E  30 09     BMI L_BRS_($3579)_($356E) OK
$3570  A9 40     LDA #$40
$3572  0A        ASL A 
$3573  38        SEC 
$3574  E9 01     SBC #$01
$3576  4C BA 35  JMP L_JMP_($35BA)_($3576) OK
//------------------------------
L_BRS_($3579)_($355E) OK
L_BRS_($3579)_($356E) OK
//------------------------------
$3579  A9 00     LDA #$00
$357B  85 82     STA $82 
$357D  B5 3E     LDA $3E,X 
$357F  85 83     STA $83 
$3581  B5 3F     LDA $3F,X 
$3583  85 84     STA $84 
$3585  10 11     BPL L_BRS_($3598)_($3585) OK
$3587  38        SEC 
$3588  66 84     ROR $84 
$358A  66 83     ROR $83 
$358C  66 82     ROR $82 
$358E  38        SEC 
$358F  66 84     ROR $84 
$3591  66 83     ROR $83 
$3593  66 82     ROR $82 
$3595  4C A4 35  JMP L_JMP_($35A4)_($3595) OK
//------------------------------
L_BRS_($3598)_($3585) OK
//------------------------------
$3598  46 84     LSR $84 
$359A  66 83     ROR $83 
$359C  66 82     ROR $82 
$359E  46 84     LSR $84 
$35A0  66 83     ROR $83 
$35A2  66 82     ROR $82 
//------------------------------
L_JMP_($35A4)_($3595) OK
//------------------------------
$35A4  B5 42     LDA $42,X 
$35A6  85 8C     STA $8C 
//------------------------------
L_JSR_($35A9)_($5B32) BAD
//------------------------------
$35A8  B5 43     LDA $43,X 
$35AA  85 8D     STA $8D 
$35AC  A5 82     LDA $82 
$35AE  A6 83     LDX $83 
$35B0  A4 84     LDY $84 
$35B2  20 D2 1D  JSR L_JSR_($1DD2)_($35B2) BAD
$35B5  A5 88     LDA $88 
$35B7  18        CLC 
$35B8  69 40     ADC #$40
//------------------------------
L_JMP_($35BA)_($3562) OK
L_JMP_($35BA)_($3576) OK
//------------------------------
$35BA  A6 B0     LDX $B0 
$35BC  95 C0     STA $C0,X 
$35BE  A6 B1     LDX $B1 
$35C0  B5 41     LDA $41,X 
$35C2  10 10     BPL L_BRS_($35D4)_($35C2) OK
$35C4  B5 42     LDA $42,X 
$35C6  18        CLC 
$35C7  75 40     ADC $40,X 
$35C9  B5 43     LDA $43,X 
$35CB  75 41     ADC $41,X 
$35CD  10 19     BPL L_BRS_($35E8)_($35CD) OK
$35CF  A9 00     LDA #$00
$35D1  4C 0C 36  JMP L_JMP_($360C)_($35D1) OK
//------------------------------
L_BRS_($35D4)_($35C2) OK
//------------------------------
$35D4  B5 40     LDA $40,X 
$35D6  38        SEC 
$35D7  F5 42     SBC $42,X 
$35D9  B5 41     LDA $41,X 
$35DB  F5 43     SBC $43,X 
$35DD  30 09     BMI L_BRS_($35E8)_($35DD) OK
$35DF  A9 34     LDA #$34
$35E1  0A        ASL A 
$35E2  38        SEC 
$35E3  E9 01     SBC #$01
$35E5  4C 0C 36  JMP L_JMP_($360C)_($35E5) OK
//------------------------------
L_BRS_($35E8)_($35CD) OK
L_BRS_($35E8)_($35DD) OK
//------------------------------
$35E8  A0 34     LDY #$34
$35EA  B5 40     LDA $40,X 
$35EC  48        PHA 
$35ED  B5 41     LDA $41,X 
$35EF  AA        TAX 
$35F0  68        PLA 
$35F1  20 A3 1C  JSR L_JSR_($1CA3)_($35F1) OK
$35F4  A6 B1     LDX $B1 
$35F6  B5 42     LDA $42,X 
$35F8  85 8C     STA $8C 
$35FA  B5 43     LDA $43,X 
$35FC  85 8D     STA $8D 
$35FE  A5 82     LDA $82 
$3600  A6 83     LDX $83 
$3602  A4 84     LDY $84 
$3604  20 D2 1D  JSR L_JSR_($1DD2)_($3604) BAD
$3607  A5 88     LDA $88 
$3609  18        CLC 
$360A  69 34     ADC #$34
//------------------------------
L_JMP_($360C)_($35D1) OK
L_JMP_($360C)_($35E5) OK
//------------------------------
$360C  A4 B0     LDY $B0 
$360E  99 C1 00  STA $00C1,Y 
$3611  C8        INY 
$3612  C8        INY 
$3613  A5 B1     LDA $B1 
$3615  18        CLC 
$3616  69 06     ADC #$06
$3618  AA        TAX 
$3619  C6 B2     DEC $B2 
$361B  F0 03     BEQ L_BRS_($3620)_($361B) OK
$361D  4C 4D 35  JMP L_JMP_($354D)_($361D) OK
//------------------------------
L_BRS_($3620)_($361B) OK
//------------------------------
$3620  60        RTS 
//------------------------------
L_JSR_($3621)_($24F9) OK
L_JSR_($3621)_($2935) OK
L_JSR_($3621)_($2A23) OK
L_JSR_($3621)_($2AF5) OK
L_JSR_($3621)_($2C38) OK
//------------------------------
$3621  20 4D 30  JSR L_JSR_($304D)_($3621) OK
$3624  A9 00     LDA #$00
$3626  8D 45 15  STA $1545 
$3629  8D 34 15  STA $1534 
$362C  AC 68 15  LDY $1568 
//------------------------------
L_BRS_($362F)_($365D) OK
//------------------------------
$362F  8C 35 15  STY $1535 
$3632  AD 9E 15  LDA $159E 
$3635  85 B0     STA $B0 
$3637  A2 00     LDX #$00
$3639  86 B1     STX $B1 
//------------------------------
L_BRS_($363B)_($3653) OK
//------------------------------
$363B  20 85 34  JSR L_JSR_($3485)_($363B) OK
$363E  C0 01     CPY #$01
$3640  F0 07     BEQ L_BRS_($3649)_($3640) OK
$3642  A9 01     LDA #$01
$3644  85 B1     STA $B1 
//------------------------------
L_JSR_($3647)_($97F2) BAD
//------------------------------
$3646  4C 4C 36  JMP L_JMP_($364C)_($3646) OK
//------------------------------
L_BRS_($3649)_($3640) OK
//------------------------------
$3649  8C 34 15  STY $1534 
//------------------------------
L_JMP_($364C)_($3646) OK
//------------------------------
$364C  8A        TXA 
$364D  18        CLC 
$364E  69 06     ADC #$06
$3650  AA        TAX 
$3651  C6 B0     DEC $B0 
$3653  D0 E6     BNE L_BRS_($363B)_($3653) OK
$3655  A5 B1     LDA $B1 
$3657  F0 08     BEQ L_BRS_($3661)_($3657) OK
$3659  AC 35 15  LDY $1535 
$365C  88        DEY 
$365D  D0 D0     BNE L_BRS_($362F)_($365D) OK
$365F  A9 01     LDA #$01
//------------------------------
L_BRS_($3661)_($3657) OK
//------------------------------
$3661  8D 45 15  STA $1545 
$3664  60        RTS 
//------------------------------
L_JSR_($3665)_($3BA3) OK
//------------------------------
$3665  AD 68 15  LDA $1568 
$3668  8D 35 15  STA $1535 
//------------------------------
L_JMP_($366B)_($37EF) OK
//------------------------------
$366B  A2 00     LDX #$00
$366D  A0 00     LDY #$00
$366F  86 B3     STX $B3 
$3671  86 B4     STX $B4 
$3673  AD 9E 15  LDA $159E 
$3676  85 B6     STA $B6 
$3678  84 B2     STY $B2 
$367A  84 B1     STY $B1 
//------------------------------
L_BRS_($367C)_($369A) OK
//------------------------------
$367C  84 82     STY $82 
$367E  20 85 34  JSR L_JSR_($3485)_($367E) OK
$3681  98        TYA 
$3682  F0 07     BEQ L_BRS_($368B)_($3682) OK
$3684  30 07     BMI L_BRS_($368D)_($3684) OK
$3686  E6 B2     INC $B2 
$3688  4C 8D 36  JMP L_JMP_($368D)_($3688) OK
//------------------------------
L_BRS_($368B)_($3682) OK
//------------------------------
$368B  E6 B1     INC $B1 
//------------------------------
L_BRS_($368D)_($3684) OK
L_JMP_($368D)_($3688) OK
//------------------------------
$368D  A4 82     LDY $82 
$368F  99 C0 00  STA $00C0,Y 
$3692  C8        INY 
$3693  8A        TXA 
$3694  18        CLC 
$3695  69 06     ADC #$06
$3697  AA        TAX 
$3698  C6 B6     DEC $B6 
$369A  D0 E0     BNE L_BRS_($367C)_($369A) OK
$369C  A5 B2     LDA $B2 
$369E  D0 03     BNE L_BRS_($36A3)_($369E) OK
$36A0  4C EA 37  JMP L_JMP_($37EA)_($36A0) OK
//------------------------------
L_BRS_($36A3)_($369E) OK
//------------------------------
$36A3  A5 B1     LDA $B1 
$36A5  D0 06     BNE L_BRS_($36AD)_($36A5) OK
$36A7  A9 00     LDA #$00
$36A9  8D 9E 15  STA $159E 
$36AC  60        RTS 
//------------------------------
L_BRS_($36AD)_($36A5) OK
//------------------------------
$36AD  A0 00     LDY #$00
$36AF  84 B0     STY $B0 
$36B1  AD 9E 15  LDA $159E 
$36B4  85 B7     STA $B7 
$36B6  C9 02     CMP #$02
$36B8  F0 20     BEQ L_BRS_($36DA)_($36B8) OK
$36BA  0A        ASL A 
$36BB  85 82     STA $82 
$36BD  0A        ASL A 
$36BE  18        CLC 
$36BF  65 82     ADC $82 
$36C1  AA        TAX 
$36C2  A5 3E     LDA $3E 
$36C4  95 3E     STA $3E,X 
$36C6  A5 3F     LDA $3F 
$36C8  95 3F     STA $3F,X 
$36CA  A5 40     LDA $40 
$36CC  95 40     STA $40,X 
$36CE  A5 41     LDA $41 
$36D0  95 41     STA $41,X 
$36D2  A5 42     LDA $42 
$36D4  95 42     STA $42,X 
$36D6  A5 43     LDA $43 
$36D8  95 43     STA $43,X 
//------------------------------
L_BRS_($36DA)_($36B8) OK
//------------------------------
$36DA  A2 00     LDX #$00
$36DC  86 B5     STX $B5 
$36DE  4C 28 37  JMP L_JMP_($3728)_($36DE) OK
//------------------------------
L_JMP_($36E1)_($3772) OK
//------------------------------
$36E1  A4 B4     LDY $B4 
$36E3  B9 C0 00  LDA $00C0,Y 
$36E6  30 40     BMI L_BRS_($3728)_($36E6) OK
$36E8  D9 BF 00  CMP $00BF,Y 
$36EB  F0 3B     BEQ L_BRS_($3728)_($36EB) OK
$36ED  B9 BF 00  LDA $00BF,Y 
$36F0  30 36     BMI L_BRS_($3728)_($36F0) OK
$36F2  A6 B3     LDX $B3 
$36F4  20 CC 30  JSR L_JSR_($30CC)_($36F4) OK
$36F7  A5 B0     LDA $B0 
$36F9  F0 16     BEQ L_BRS_($3711)_($36F9) OK
$36FB  A4 B5     LDY $B5 
$36FD  A9 06     LDA #$06
$36FF  85 B6     STA $B6 
//------------------------------
L_BRS_($3701)_($370C) OK
//------------------------------
$3701  CA        DEX 
$3702  88        DEY 
$3703  B9 9F 15  LDA $159F,Y 
$3706  D5 3E     CMP $3E,X 
$3708  D0 07     BNE L_BRS_($3711)_($3708) OK
$370A  C6 B6     DEC $B6 
$370C  D0 F3     BNE L_BRS_($3701)_($370C) OK
$370E  4C 28 37  JMP L_JMP_($3728)_($370E) OK
//------------------------------
L_BRS_($3711)_($36F9) OK
L_BRS_($3711)_($3708) OK
//------------------------------
$3711  A4 B5     LDY $B5 
$3713  A5 B3     LDA $B3 
$3715  38        SEC 
$3716  E9 06     SBC #$06
$3718  AA        TAX 
//------------------------------
L_BRS_($3719)_($3722) OK
//------------------------------
$3719  B5 3E     LDA $3E,X 
$371B  99 9F 15  STA $159F,Y 
$371E  E8        INX 
$371F  C8        INY 
$3720  E4 B3     CPX $B3 
$3722  90 F5     BCC L_BRS_($3719)_($3722) OK
$3724  E6 B0     INC $B0 
$3726  84 B5     STY $B5 
//------------------------------
L_JMP_($3728)_($36DE) OK
L_BRS_($3728)_($36E6) OK
L_BRS_($3728)_($36EB) OK
L_BRS_($3728)_($36F0) OK
L_JMP_($3728)_($370E) OK
//------------------------------
$3728  A4 B4     LDY $B4 
$372A  B9 C0 00  LDA $00C0,Y 
$372D  C9 01     CMP #$01
$372F  F0 34     BEQ L_BRS_($3765)_($372F) OK
$3731  A5 B0     LDA $B0 
$3733  F0 19     BEQ L_BRS_($374E)_($3733) OK
$3735  A4 B5     LDY $B5 
$3737  A5 B3     LDA $B3 
$3739  18        CLC 
$373A  69 05     ADC #$05
$373C  AA        TAX 
$373D  88        DEY 
//------------------------------
L_BRS_($373E)_($3749) OK
//------------------------------
$373E  B9 9F 15  LDA $159F,Y 
$3741  D5 3E     CMP $3E,X 
$3743  D0 09     BNE L_BRS_($374E)_($3743) OK
$3745  88        DEY 
$3746  CA        DEX 
$3747  E4 B3     CPX $B3 
$3749  B0 F3     BCS L_BRS_($373E)_($3749) OK
$374B  4C 65 37  JMP L_JMP_($3765)_($374B) OK
//------------------------------
L_BRS_($374E)_($3733) OK
L_BRS_($374E)_($3743) OK
//------------------------------
$374E  A6 B3     LDX $B3 
$3750  A4 B5     LDY $B5 
$3752  A9 06     LDA #$06
$3754  85 B6     STA $B6 
//------------------------------
L_BRS_($3756)_($375F) OK
//------------------------------
$3756  B5 3E     LDA $3E,X 
$3758  99 9F 15  STA $159F,Y 
$375B  E8        INX 
$375C  C8        INY 
$375D  C6 B6     DEC $B6 
$375F  D0 F5     BNE L_BRS_($3756)_($375F) OK
$3761  E6 B0     INC $B0 
$3763  84 B5     STY $B5 
//------------------------------
L_BRS_($3765)_($372F) OK
L_JMP_($3765)_($374B) OK
//------------------------------
$3765  A5 B3     LDA $B3 
$3767  18        CLC 
$3768  69 06     ADC #$06
$376A  85 B3     STA $B3 
$376C  E6 B4     INC $B4 
$376E  C6 B7     DEC $B7 
$3770  F0 03     BEQ L_BRS_($3775)_($3770) OK
$3772  4C E1 36  JMP L_JMP_($36E1)_($3772) OK
//------------------------------
L_BRS_($3775)_($3770) OK
//------------------------------
$3775  AD 9E 15  LDA $159E 
$3778  C9 02     CMP #$02
$377A  F0 48     BEQ L_BRS_($37C4)_($377A) OK
$377C  A5 C0     LDA $C0 
$377E  30 44     BMI L_BRS_($37C4)_($377E) OK
$3780  A4 B4     LDY $B4 
$3782  D9 BF 00  CMP $00BF,Y 
$3785  F0 3D     BEQ L_BRS_($37C4)_($3785) OK
$3787  B9 BF 00  LDA $00BF,Y 
$378A  30 38     BMI L_BRS_($37C4)_($378A) OK
$378C  A6 B3     LDX $B3 
$378E  20 CC 30  JSR L_JSR_($30CC)_($378E) OK
$3791  A5 B0     LDA $B0 
$3793  F0 2F     BEQ L_BRS_($37C4)_($3793) OK
$3795  A4 B5     LDY $B5 
$3797  A9 06     LDA #$06
$3799  85 B6     STA $B6 
//------------------------------
L_BRS_($379B)_($37A6) OK
//------------------------------
$379B  B5 3E     LDA $3E,X 
$379D  D9 9F 15  CMP $159F,Y 
$37A0  CA        DEX 
$37A1  88        DEY 
$37A2  D0 07     BNE L_BRS_($37AB)_($37A2) OK
$37A4  C6 B6     DEC $B6 
$37A6  D0 F3     BNE L_BRS_($379B)_($37A6) OK
$37A8  4C C4 37  JMP L_JMP_($37C4)_($37A8) OK
//------------------------------
L_BRS_($37AB)_($37A2) OK
//------------------------------
$37AB  A5 B3     LDA $B3 
$37AD  38        SEC 
$37AE  E9 06     SBC #$06
$37B0  AA        TAX 
$37B1  A4 B5     LDY $B5 
$37B3  A9 06     LDA #$06
$37B5  85 B6     STA $B6 
//------------------------------
L_BRS_($37B7)_($37C0) OK
//------------------------------
$37B7  B5 3E     LDA $3E,X 
$37B9  99 9F 15  STA $159F,Y 
$37BC  E8        INX 
$37BD  C8        INY 
$37BE  C6 B6     DEC $B6 
$37C0  D0 F5     BNE L_BRS_($37B7)_($37C0) OK
$37C2  E6 B0     INC $B0 
//------------------------------
L_BRS_($37C4)_($377A) OK
L_BRS_($37C4)_($377E) OK
L_BRS_($37C4)_($3785) OK
L_BRS_($37C4)_($378A) OK
L_BRS_($37C4)_($3793) OK
L_JMP_($37C4)_($37A8) OK
//------------------------------
$37C4  A5 B0     LDA $B0 
$37C6  8D 9E 15  STA $159E 
$37C9  C9 02     CMP #$02
$37CB  B0 08     BCS L_BRS_($37D5)_($37CB) OK
$37CD  A9 00     LDA #$00
$37CF  8D 9E 15  STA $159E 
$37D2  4C F2 37  JMP L_JMP_($37F2)_($37D2) OK
//------------------------------
L_BRS_($37D5)_($37CB) OK
//------------------------------
$37D5  0A        ASL A 
$37D6  85 82     STA $82 
$37D8  0A        ASL A 
$37D9  18        CLC 
$37DA  65 82     ADC $82 
$37DC  85 B6     STA $B6 
$37DE  A2 00     LDX #$00
//------------------------------
L_BRS_($37E0)_($37E8) OK
//------------------------------
$37E0  BD 9F 15  LDA $159F,X 
$37E3  95 3E     STA $3E,X 
$37E5  E8        INX 
$37E6  E4 B6     CPX $B6 
$37E8  90 F6     BCC L_BRS_($37E0)_($37E8) OK
//------------------------------
L_JMP_($37EA)_($36A0) OK
//------------------------------
$37EA  CE 35 15  DEC $1535 
$37ED  F0 03     BEQ L_BRS_($37F2)_($37ED) OK
$37EF  4C 6B 36  JMP L_JMP_($366B)_($37EF) OK
//------------------------------
L_JMP_($37F2)_($37D2) OK
L_BRS_($37F2)_($37ED) OK
//------------------------------
$37F2  60        RTS 
//------------------------------
L_JSR_($37F3)_($3A69) OK
L_JSR_($37F3)_($3A7C) OK
L_JSR_($37F3)_($3BCD) OK
L_JSR_($37F3)_($3BF1) OK
//------------------------------
$37F3  A5 7A     LDA $7A 
$37F5  48        PHA 
$37F6  A5 7B     LDA $7B 
$37F8  48        PHA 
$37F9  98        TYA 
$37FA  48        PHA 
$37FB  18        CLC 
$37FC  65 7A     ADC $7A 
$37FE  85 7A     STA $7A 
$3800  90 02     BCC L_BRS_($3804)_($3800) OK
$3802  E6 7B     INC $7B 
//------------------------------
L_BRS_($3804)_($3800) OK
//------------------------------
$3804  A0 04     LDY #$04
$3806  B1 7A     LDA ($7A),Y 
$3808  A0 00     LDY #$00
$380A  38        SEC 
$380B  F1 7A     SBC ($7A),Y 
$380D  85 88     STA $88 
$380F  A9 00     LDA #$00
$3811  E9 00     SBC #$00
$3813  85 89     STA $89 
$3815  A0 03     LDY #$03
$3817  B1 7A     LDA ($7A),Y 
$3819  A0 01     LDY #$01
$381B  38        SEC 
$381C  F1 7A     SBC ($7A),Y 
$381E  85 8C     STA $8C 
$3820  A9 00     LDA #$00
$3822  E9 00     SBC #$00
$3824  85 8D     STA $8D 
$3826  20 31 1D  JSR L_JSR_($1D31)_($3826) OK
$3829  A5 85     LDA $85 
$382B  48        PHA 
$382C  A5 84     LDA $84 
$382E  48        PHA 
$382F  A5 83     LDA $83 
$3831  48        PHA 
$3832  A5 82     LDA $82 
$3834  48        PHA 
$3835  A0 02     LDY #$02
$3837  B1 7A     LDA ($7A),Y 
$3839  A0 00     LDY #$00
$383B  38        SEC 
$383C  F1 7A     SBC ($7A),Y 
$383E  85 88     STA $88 
//------------------------------
L_BRS_($3840)_($387E) OK
//------------------------------
$3840  A9 00     LDA #$00
$3842  E9 00     SBC #$00
$3844  85 89     STA $89 
$3846  A0 05     LDY #$05
$3848  B1 7A     LDA ($7A),Y 
$384A  A0 01     LDY #$01
$384C  38        SEC 
$384D  F1 7A     SBC ($7A),Y 
$384F  85 8C     STA $8C 
$3851  A9 00     LDA #$00
$3853  E9 00     SBC #$00
$3855  85 8D     STA $8D 
$3857  20 31 1D  JSR L_JSR_($1D31)_($3857) OK
$385A  68        PLA 
$385B  38        SEC 
$385C  E5 82     SBC $82 
$385E  85 82     STA $82 
$3860  68        PLA 
$3861  E5 83     SBC $83 
$3863  85 83     STA $83 
$3865  68        PLA 
$3866  E5 84     SBC $84 
$3868  85 84     STA $84 
$386A  68        PLA 
$386B  E5 85     SBC $85 
$386D  85 85     STA $85 
$386F  18        CLC 
$3870  30 01     BMI L_BRS_($3873)_($3870) OK
$3872  38        SEC 
//------------------------------
L_BRS_($3873)_($3870) OK
//------------------------------
$3873  68        PLA 
$3874  A8        TAY 
$3875  68        PLA 
$3876  85 7B     STA $7B 
$3878  68        PLA 
$3879  85 7A     STA $7A 
$387B  60        RTS 
//------------------------------
$387C            .byte $00,$FC
$387E  F0 C0     BEQ L_BRS_($3840)_($387E) OK
$3880            .byte $03,$0F,$3F,$FF
//------------------------------
L_JSR_($3884)_($2E3C) OK
L_JSR_($3884)_($484D) OK
//------------------------------
$3884  AD 3E 15  LDA $153E 
$3887  85 B0     STA $B0 
$3889  AD 2F 17  LDA $172F 
$388C  38        SEC 
$388D  E9 01     SBC #$01
$388F  0A        ASL A 
$3890  0A        ASL A 
$3891  A8        TAY 
$3892  A2 04     LDX #$04
//------------------------------
L_BRS_($3894)_($389B) OK
//------------------------------
$3894  B9 0A 96  LDA $960A,Y 
$3897  95 B0     STA $B0,X 
$3899  C8        INY 
$389A  CA        DEX 
$389B  D0 F7     BNE L_BRS_($3894)_($389B) OK
$389D  A9 00     LDA #$00	; lookup table for framebuffer rows
$389F  85 82     STA $82 
$38A1  AD 3E 15  LDA $153E 	; ldx $b0
$38A4  4A        LSR A 		; lda lookupl,x
$38A5  66 82     ROR $82 	; sta $82
$38A7  4A        LSR A 		; lda lookuph,x
$38A8  66 82     ROR $82 	; sta $83
$38AA  4A        LSR A 
$38AB  AA        TAX 
$38AC  66 82     ROR $82 
$38AE  A5 82     LDA $82 
$38B0  18        CLC 
$38B1  6D 8E 15  ADC $158E 
$38B4  85 82     STA $82 
$38B6  8A        TXA 
$38B7  6D 8F 15  ADC $158F 
$38BA  85 83     STA $83 
//------------------------------
L_JMP_($38BC)_($39DB) OK
//------------------------------
$38BC  A4 B0     LDY $B0 
$38BE  B9 AD 16  LDA $16AD,Y 
$38C1  48        PHA 			; tax (3->2)
$38C2  A9 00     LDA #$00
$38C4  99 AD 16  STA $16AD,Y 
$38C7  68        PLA 			; txa (4->2)
$38C8  D0 03     BNE L_BRS_($38CD)_($38C8) OK
$38CA  4C C7 39  JMP L_JMP_($39C7)_($38CA) OK
//------------------------------
L_BRS_($38CD)_($38C8) OK
//------------------------------
$38CD  C9 02     CMP #$02
$38CF  F0 06     BEQ L_BRS_($38D7)_($38CF) OK
$38D1  B9 DB 15  LDA $15DB,Y 
$38D4  99 44 16  STA $1644,Y 
//------------------------------
L_BRS_($38D7)_($38CF) OK
//------------------------------
$38D7  B9 DB 15  LDA $15DB,Y 
$38DA  D9 44 16  CMP $1644,Y 
$38DD  90 0C     BCC L_BRS_($38EB)_($38DD) OK
$38DF  F0 0A     BEQ L_BRS_($38EB)_($38DF) OK
$38E1  BE 44 16  LDX $1644,Y 
$38E4  99 44 16  STA $1644,Y 
$38E7  8A        TXA 
$38E8  99 DB 15  STA $15DB,Y 
//------------------------------
L_BRS_($38EB)_($38DD) OK
L_BRS_($38EB)_($38DF) OK
//------------------------------
$38EB  48        PHA 	; tax
$38EC  29 7F     AND #$7F
$38EE  4A        LSR A 
$38EF  4A        LSR A 
$38F0  85 B5     STA $B5 
$38F2  B9 44 16  LDA $1644,Y 
$38F5  29 7F     AND #$7F
$38F7  4A        LSR A 
$38F8  4A        LSR A 
$38F9  85 B6     STA $B6 
$38FB  C5 B5     CMP $B5 
$38FD  D0 5C     BNE L_BRS_($395B)_($38FD) OK
$38FF  68        PLA 	; txa
$3900  29 03     AND #$03
$3902  D0 05     BNE L_BRS_($3909)_($3902) OK
$3904  A9 FF     LDA #$FF	; lookup table here
$3906  4C 1D 39  JMP L_JMP_($391D)_($3906) OK
//------------------------------
L_BRS_($3909)_($3902) OK
//------------------------------
$3909  C9 01     CMP #$01
$390B  D0 05     BNE L_BRS_($3912)_($390B) OK
$390D  A9 FC     LDA #$FC
$390F  4C 1D 39  JMP L_JMP_($391D)_($390F) OK
//------------------------------
L_BRS_($3912)_($390B) OK
//------------------------------
$3912  C9 02     CMP #$02
$3914  D0 05     BNE L_BRS_($391B)_($3914) OK
$3916  A9 F0     LDA #$F0
$3918  4C 1D 39  JMP L_JMP_($391D)_($3918) OK
//------------------------------
L_BRS_($391B)_($3914) OK
//------------------------------
$391B  A9 C0     LDA #$C0
//------------------------------
L_JMP_($391D)_($3906) OK
L_JMP_($391D)_($390F) OK
L_JMP_($391D)_($3918) OK
//------------------------------
$391D  48        PHA 
$391E  B9 44 16  LDA $1644,Y 
$3921  29 03     AND #$03
$3923  D0 05     BNE L_BRS_($392A)_($3923) OK
$3925  A9 03     LDA #$03		; lookup table here
$3927  4C 3E 39  JMP L_JMP_($393E)_($3927) OK
//------------------------------
L_BRS_($392A)_($3923) OK
//------------------------------
$392A  C9 01     CMP #$01
$392C  D0 05     BNE L_BRS_($3933)_($392C) OK
$392E  A9 0F     LDA #$0F
//------------------------------
L_JSR_($3931)_($0B78) BAD
//------------------------------
$3930  4C 3E 39  JMP L_JMP_($393E)_($3930) OK
//------------------------------
L_BRS_($3933)_($392C) OK
//------------------------------
$3933  C9 02     CMP #$02
$3935  D0 05     BNE L_BRS_($393C)_($3935) OK
$3937  A9 3F     LDA #$3F
$3939  4C 3E 39  JMP L_JMP_($393E)_($3939) OK
//------------------------------
L_BRS_($393C)_($3935) OK
//------------------------------
$393C  A9 FF     LDA #$FF
//------------------------------
L_JMP_($393E)_($3927) OK
L_JMP_($393E)_($3930) OK
L_JMP_($393E)_($3939) OK
//------------------------------
$393E  85 84     STA $84 
$3940  68        PLA 
$3941  25 84     AND $84
$3943  48        PHA 
$3944  A4 B5     LDY $B5 
//------------------------------
L_JSR_($3946)_($5CBD) OK
//------------------------------
$3946  49 FF     EOR #$FF
$3948  31 82     AND ($82),Y 
$394A  85 84     STA $84 
$394C  A5 B0     LDA $B0 
$394E  29 03     AND #$03
$3950  AA        TAX 
$3951  68        PLA 
$3952  35 B1     AND $B1,X 
$3954  05 84     ORA $84
$3956  91 82     STA ($82),Y 
$3958  4C C7 39  JMP L_JMP_($39C7)_($3958) OK
//------------------------------
L_BRS_($395B)_($38FD) OK
//------------------------------
$395B  68        PLA 	; txa
$395C  29 03     AND #$03
$395E  F0 1B     BEQ L_BRS_($397B)_($395E) OK
$3960  AA        TAX 
$3961  A4 B5     LDY $B5 
$3963  BD 7C 38  LDA $387C,X 
$3966  48        PHA 
$3967  49 FF     EOR #$FF
$3969  31 82     AND ($82),Y 
$396B  85 84     STA $84 
$396D  A5 B0     LDA $B0 
$396F  29 03     AND #$03
$3971  AA        TAX 
$3972  68        PLA 
$3973  35 B1     AND $B1,X 
$3975  05 84     ORA $84
$3977  91 82     STA ($82),Y 
$3979  E6 B5     INC $B5 
//------------------------------
L_BRS_($397B)_($395E) OK
//------------------------------
$397B  A4 B0     LDY $B0 
$397D  B9 44 16  LDA $1644,Y 
$3980  29 03     AND #$03
$3982  C9 03     CMP #$03
$3984  F0 1D     BEQ L_BRS_($39A3)_($3984) OK
$3986  AA        TAX 			; 2 ; tax
$3987  BD 80 38  LDA $3880,X 	; 4 ; lda table,x [3880 eor #$ff]
$398A  48        PHA 			; 3 ; ldy $b6
$398B  A4 B6     LDY $B6 		; 3 ; and ($82),y
$398D  49 FF     EOR #$FF		; 2 ; sta $84
$398F  31 82     AND ($82),Y 	; 5 ; lda $3880,x
$3991  85 84     STA $84 		; 3 ; ldx colorindex
$3993  A5 B0     LDA $B0 		; 3 ; and $b1,x
$3995  29 03     AND #$03		; 2 ; ora $84
$3997  AA        TAX 			; 2 ; sta ($82),y
$3998  68        PLA 			; 4 ;
$3999  35 B1     AND $B1,X 		; 4 ;
$399B  05 84     ORA $84		; 3 ;
$399D  91 82     STA ($82),Y 	; 6 = 46 cycles;
; fast version with eor
; tax			; 2
; lda color		; 3
; ldy $b6		; 3
; eor ($82),y	; 5
; and mask,x	; 4
; eor ($82),y	; 5
; sta ($82),y	; 6 - total 28 cycles

; faster
; tax			; 2
; ldy $b6		; 3
; lda ($82),y	; 5
; eor color		; 3
; and maskscreen,x	; 4
; eor color	; 3
; sta ($82),y	; 6 - total 26 cycles
$399F  C6 B6     DEC $B6 
$39A1  30 24     BMI L_BRS_($39C7)_($39A1) OK
//------------------------------
L_BRS_($39A3)_($3984) OK
//------------------------------
$39A3  A5 B6     LDA $B6 
$39A5  38        SEC 
$39A6  E5 B5     SBC $B5 
$39A8  30 1D     BMI L_BRS_($39C7)_($39A8) OK
$39AA  A8        TAY 
$39AB  A5 B5     LDA $B5 
$39AD  18        CLC 
$39AE  65 82     ADC $82 
$39B0  8D C2 39  STA $39C2 
$39B3  A5 83     LDA $83 
$39B5  69 00     ADC #$00
$39B7  8D C3 39  STA $39C3 
$39BA  A5 B0     LDA $B0 
$39BC  29 03     AND #$03
$39BE  AA        TAX 
$39BF  B5 B1     LDA $B1,X 
//------------------------------
L_BRS_($39C1)_($39C5) OK
//------------------------------
$39C1  99 FF FF  STA $FFFF,Y 
$39C4  88        DEY 
$39C5  10 FA     BPL L_BRS_($39C1)_($39C5) OK
//------------------------------
L_JMP_($39C7)_($38CA) OK
L_JMP_($39C7)_($3958) OK
L_BRS_($39C7)_($39A1) OK
L_BRS_($39C7)_($39A8) OK
//------------------------------
$39C7  A5 82     LDA $82 
$39C9  18        CLC 
$39CA  69 20     ADC #$20
$39CC  85 82     STA $82 
$39CE  90 02     BCC L_BRS_($39D2)_($39CE) OK
$39D0  E6 83     INC $83 
//------------------------------
L_BRS_($39D2)_($39CE) OK
//------------------------------
$39D2  E6 B0     INC $B0 		; ldx $b0
$39D4  AD 3D 15  LDA $153D 		; inx
$39D7  C5 B0     CMP $B0 		; cpx $153d
$39D9  30 03     BMI L_BRS_($39DE)_($39D9) OK
$39DB  4C BC 38  JMP L_JMP_($38BC)_($39DB) OK
//------------------------------
L_BRS_($39DE)_($39D9) OK
//------------------------------
$39DE  60        RTS 
//------------------------------
L_JMP_($39DF)_($256B) OK
L_JMP_($39DF)_($2995) OK
L_JMP_($39DF)_($2A58) OK
L_JMP_($39DF)_($2B3F) OK
L_JSR_($39DF)_($2C50) OK
//------------------------------
$39DF  98        TYA 
$39E0  48        PHA 
$39E1  20 22 35  JSR L_JSR_($3522)_($39E1) OK
$39E4  68        PLA 
$39E5  AA        TAX 
$39E6  A9 00     LDA #$00
$39E8  8D 45 15  STA $1545 
$39EB  AD 96 15  LDA $1596 
$39EE  85 7A     STA $7A 
$39F0  AD 97 15  LDA $1597 
$39F3  85 7B     STA $7B 
$39F5  AD 46 15  LDA $1546 
$39F8  A0 00     LDY #$00
$39FA  91 7A     STA ($7A),Y 
$39FC  98        TYA 
$39FD  C8        INY 
$39FE  91 7A     STA ($7A),Y 
$3A00  C8        INY 
$3A01  BD 2C 18  LDA $182C,X 
$3A04  E8        INX 
$3A05  85 A3     STA $A3 
$3A07  A5 7A     LDA $7A 
$3A09  8D A7 3A  STA $3AA7 
$3A0C  A5 7B     LDA $7B 
$3A0E  8D A8 3A  STA $3AA8 
//------------------------------
L_JMP_($3A11)_($3AC2) OK
//------------------------------
$3A11  BD 2C 18  LDA $182C,X 
$3A14  D0 0B     BNE L_BRS_($3A21)_($3A14) OK
$3A16  E8        INX 
$3A17  8A        TXA 
$3A18  18        CLC 
$3A19  7D 2C 18  ADC $182C,X 
$3A1C  AA        TAX 
$3A1D  E8        INX 
$3A1E  4C BE 3A  JMP L_JMP_($3ABE)_($3A1E) OK
//------------------------------
L_BRS_($3A21)_($3A14) OK
//------------------------------
$3A21  E8        INX 
$3A22  0A        ASL A 
$3A23  0A        ASL A 
$3A24  0A        ASL A 
$3A25  0A        ASL A 
$3A26  1D 2C 18  ORA $182C,X
$3A29  85 A5     STA $A5 
$3A2B  98        TYA 
$3A2C  48        PHA 
$3A2D  C8        INY 
$3A2E  84 A2     STY $A2 
$3A30  BD 2C 18  LDA $182C,X 
$3A33  E8        INX 
$3A34  85 A4     STA $A4 
//------------------------------
L_BRS_($3A36)_($3A57) OK
//------------------------------
$3A36  BD 2C 18  LDA $182C,X 
$3A39  0A        ASL A 
$3A3A  A8        TAY 
$3A3B  E8        INX 
$3A3C  B9 C0 00  LDA $00C0,Y 
$3A3F  C8        INY 
$3A40  84 A0     STY $A0 
$3A42  A4 A2     LDY $A2 
$3A44  91 7A     STA ($7A),Y 
$3A46  C8        INY 
$3A47  84 A2     STY $A2 
$3A49  A4 A0     LDY $A0 
$3A4B  B9 C0 00  LDA $00C0,Y 
$3A4E  A4 A2     LDY $A2 
$3A50  91 7A     STA ($7A),Y 
$3A52  C8        INY 
$3A53  84 A2     STY $A2 
$3A55  C6 A4     DEC $A4 
$3A57  D0 DD     BNE L_BRS_($3A36)_($3A57) OK
$3A59  68        PLA 
$3A5A  85 A1     STA $A1 
$3A5C  A8        TAY 
$3A5D  C8        INY 
$3A5E  AD 53 15  LDA $1553 
$3A61  F0 3B     BEQ L_BRS_($3A9E)_($3A61) OK
$3A63  C9 01     CMP #$01
$3A65  D0 0D     BNE L_BRS_($3A74)_($3A65) OK
$3A67  8A        TXA 
$3A68  48        PHA 
$3A69  20 F3 37  JSR L_JSR_($37F3)_($3A69) OK
$3A6C  68        PLA 
$3A6D  AA        TAX 
$3A6E  88        DEY 
$3A6F  B0 4D     BCS L_BRS_($3ABE)_($3A6F) OK
$3A71  4C 9E 3A  JMP L_JMP_($3A9E)_($3A71) OK
//------------------------------
L_BRS_($3A74)_($3A65) OK
//------------------------------
$3A74  A5 A5     LDA $A5 
$3A76  29 0F     AND #$0F
$3A78  85 A5     STA $A5 
$3A7A  8A        TXA 
$3A7B  48        PHA 
$3A7C  20 F3 37  JSR L_JSR_($37F3)_($3A7C) OK
$3A7F  68        PLA 
$3A80  AA        TAX 
$3A81  88        DEY 
$3A82  AD 2F 17  LDA $172F 
$3A85  90 0B     BCC L_BRS_($3A92)_($3A85) OK
$3A87  29 F0     AND #$F0
$3A89  F0 33     BEQ L_BRS_($3ABE)_($3A89) OK
$3A8B  05 A5     ORA $A5
$3A8D  85 A5     STA $A5 
$3A8F  4C 9E 3A  JMP L_JMP_($3A9E)_($3A8F) OK
//------------------------------
L_BRS_($3A92)_($3A85) OK
//------------------------------
$3A92  29 0F     AND #$0F
$3A94  F0 28     BEQ L_BRS_($3ABE)_($3A94) OK
$3A96  0A        ASL A 
$3A97  0A        ASL A 
$3A98  0A        ASL A 
$3A99  0A        ASL A 
$3A9A  05 A5     ORA $A5
$3A9C  85 A5     STA $A5 
//------------------------------
L_BRS_($3A9E)_($3A61) OK
L_JMP_($3A9E)_($3A71) OK
L_JMP_($3A9E)_($3A8F) OK
//------------------------------
$3A9E  A9 01     LDA #$01
$3AA0  8D 45 15  STA $1545 
$3AA3  8A        TXA 
$3AA4  A2 01     LDX #$01
$3AA6  FE FF FF  INC $FFFF,X 
$3AA9  AA        TAX 
$3AAA  A4 A1     LDY $A1 
$3AAC  A5 A5     LDA $A5 
$3AAE  91 7A     STA ($7A),Y 
$3AB0  A5 A2     LDA $A2 
$3AB2  18        CLC 
$3AB3  65 7A     ADC $7A 
$3AB5  85 7A     STA $7A 
$3AB7  A9 00     LDA #$00
$3AB9  A8        TAY 
$3ABA  65 7B     ADC $7B 
$3ABC  85 7B     STA $7B 
//------------------------------
L_JMP_($3ABE)_($3A1E) OK
L_BRS_($3ABE)_($3A6F) OK
L_BRS_($3ABE)_($3A89) OK
L_BRS_($3ABE)_($3A94) OK
//------------------------------
$3ABE  C6 A3     DEC $A3 
$3AC0  F0 03     BEQ L_BRS_($3AC5)_($3AC0) OK
$3AC2  4C 11 3A  JMP L_JMP_($3A11)_($3AC2) OK
//------------------------------
L_BRS_($3AC5)_($3AC0) OK
//------------------------------
$3AC5  AD 45 15  LDA $1545 
$3AC8  F0 4D     BEQ L_BRS_($3B17)_($3AC8) OK
$3ACA  AD 9A 15  LDA $159A 
$3ACD  85 7C     STA $7C 
$3ACF  AD 9B 15  LDA $159B 
$3AD2  85 7D     STA $7D 
$3AD4  A0 00     LDY #$00
$3AD6  AD 96 15  LDA $1596 
$3AD9  91 7C     STA ($7C),Y 
$3ADB  C8        INY 
$3ADC  AD 97 15  LDA $1597 
$3ADF  91 7C     STA ($7C),Y 
$3AE1  C8        INY 
$3AE2  A5 7A     LDA $7A 
$3AE4  8D 96 15  STA $1596 
$3AE7  A5 7B     LDA $7B 
$3AE9  8D 97 15  STA $1597 
$3AEC  AD 98 15  LDA $1598 
$3AEF  91 7C     STA ($7C),Y 
$3AF1  C8        INY 
$3AF2  AD 99 15  LDA $1599 
$3AF5  91 7C     STA ($7C),Y 
$3AF7  A5 7C     LDA $7C 
$3AF9  18        CLC 
$3AFA  69 04     ADC #$04
$3AFC  8D 9A 15  STA $159A 
$3AFF  A5 7D     LDA $7D 
$3B01  69 00     ADC #$00
$3B03  8D 9B 15  STA $159B 
$3B06  A9 0C     LDA #$0C
$3B08  18        CLC 
$3B09  6D 98 15  ADC $1598 
$3B0C  8D 98 15  STA $1598 
$3B0F  90 03     BCC L_BRS_($3B14)_($3B0F) OK
$3B11  EE 99 15  INC $1599 
//------------------------------
L_BRS_($3B14)_($3B0F) OK
//------------------------------
$3B14  EE 54 15  INC $1554 
//------------------------------
L_BRS_($3B17)_($3AC8) OK
//------------------------------
$3B17  60        RTS 
//------------------------------
L_JMP_($3B19)_($256E) BAD
L_JMP_($3B19)_($2998) BAD
L_JMP_($3B19)_($2A5B) BAD
L_JMP_($3B19)_($2B42) BAD
//------------------------------
$3B18  46 84     LSR $84 
$3B1A  A0 AD     LDY #$AD
$3B1C            .byte $9E
$3B1D  15 0A     ORA $0A,X
$3B1F  85 82     STA $82 
$3B21  0A        ASL A 
$3B22  18        CLC 
$3B23  65 82     ADC $82 
$3B25  AA        TAX 
//------------------------------
L_BRS_($3B26)_($3B2B) OK
//------------------------------
$3B26  B5 3D     LDA $3D,X 
$3B28  95 01     STA $01,X 
$3B2A  CA        DEX 
$3B2B  D0 F9     BNE L_BRS_($3B26)_($3B2B) OK
$3B2D  A0 00     LDY #$00
$3B2F  8C 45 15  STY $1545 
$3B32  AE 96 15  LDX $1596 
$3B35  86 7A     STX $7A 
$3B37  AE 97 15  LDX $1597 
$3B3A  86 7B     STX $7B 
$3B3C  AD 46 15  LDA $1546 
$3B3F  91 7A     STA ($7A),Y 
$3B41  C8        INY 
$3B42  A9 00     LDA #$00
$3B44  91 7A     STA ($7A),Y 
$3B46  C8        INY 
$3B47  84 A1     STY $A1 
$3B49  A4 A0     LDY $A0 
$3B4B  B9 2C 18  LDA $182C,Y 
$3B4E  C8        INY 
$3B4F  84 A0     STY $A0 
$3B51  85 A2     STA $A2 
//------------------------------
L_JMP_($3B53)_($3CBB) OK
//------------------------------
$3B53  A4 A0     LDY $A0 
$3B55  B9 2C 18  LDA $182C,Y 
$3B58  D0 0C     BNE L_BRS_($3B66)_($3B58) OK
$3B5A  C8        INY 
$3B5B  C8        INY 
$3B5C  98        TYA 
$3B5D  18        CLC 
$3B5E  79 2B 18  ADC $182B,Y 
$3B61  85 A0     STA $A0 
$3B63  4C B7 3C  JMP L_JMP_($3CB7)_($3B63) OK
//------------------------------
L_BRS_($3B66)_($3B58) OK
//------------------------------
$3B66  C8        INY 
$3B67  0A        ASL A 
$3B68  0A        ASL A 
$3B69  0A        ASL A 
$3B6A  0A        ASL A 
$3B6B  19 2C 18  ORA $182C,Y
$3B6E  C8        INY 
$3B6F  85 A4     STA $A4 
$3B71  29 0F     AND #$0F
$3B73  85 A5     STA $A5 
$3B75  8D 9E 15  STA $159E 
$3B78  A9 00     LDA #$00
$3B7A  48        PHA 
//------------------------------
L_BRS_($3B7B)_($3BA0) OK
//------------------------------
$3B7B  B9 2C 18  LDA $182C,Y 
$3B7E  C8        INY 
$3B7F  84 A0     STY $A0 
$3B81  0A        ASL A 
$3B82  85 83     STA $83 
$3B84  0A        ASL A 
$3B85  18        CLC 
$3B86  65 83     ADC $83 
$3B88  AA        TAX 
$3B89  68        PLA 
$3B8A  A8        TAY 
$3B8B  A9 06     LDA #$06
$3B8D  85 A3     STA $A3 
//------------------------------
L_BRS_($3B8F)_($3B98) OK
//------------------------------
$3B8F  B5 02     LDA $02,X 
$3B91  99 3E 00  STA $003E,Y 
$3B94  C8        INY 
$3B95  E8        INX 
$3B96  C6 A3     DEC $A3 
$3B98  D0 F5     BNE L_BRS_($3B8F)_($3B98) OK
$3B9A  98        TYA 
$3B9B  48        PHA 
$3B9C  A4 A0     LDY $A0 
$3B9E  C6 A5     DEC $A5 
$3BA0  D0 D9     BNE L_BRS_($3B7B)_($3BA0) OK
$3BA2  68        PLA 
$3BA3  20 65 36  JSR L_JSR_($3665)_($3BA3) OK
$3BA6  AD 9E 15  LDA $159E 
$3BA9  D0 03     BNE L_BRS_($3BAE)_($3BA9) OK
$3BAB  4C B7 3C  JMP L_JMP_($3CB7)_($3BAB) OK
//------------------------------
L_BRS_($3BAE)_($3BA9) OK
//------------------------------
$3BAE  A5 A4     LDA $A4 
$3BB0  29 F0     AND #$F0
$3BB2  0D 9E 15  ORA $159E
$3BB5  85 A4     STA $A4 
$3BB7  20 22 35  JSR L_JSR_($3522)_($3BB7) OK
$3BBA  AD 53 15  LDA $1553 
$3BBD  F0 63     BEQ L_BRS_($3C22)_($3BBD) OK
$3BBF  C9 01     CMP #$01
$3BC1  D0 1E     BNE L_BRS_($3BE1)_($3BC1) OK
$3BC3  A0 00     LDY #$00
$3BC5  A9 C0     LDA #$C0
$3BC7  85 7A     STA $7A 
$3BC9  A9 00     LDA #$00
$3BCB  85 7B     STA $7B 
$3BCD  20 F3 37  JSR L_JSR_($37F3)_($3BCD) OK
$3BD0  08        PHP 
$3BD1  AD 96 15  LDA $1596 
$3BD4  85 7A     STA $7A 
$3BD6  AD 97 15  LDA $1597 
$3BD9  85 7B     STA $7B 
$3BDB  28        PLP 
$3BDC  90 44     BCC L_BRS_($3C22)_($3BDC) OK
$3BDE  4C B7 3C  JMP L_JMP_($3CB7)_($3BDE) OK
//------------------------------
L_BRS_($3BE1)_($3BC1) OK
//------------------------------
$3BE1  A5 A4     LDA $A4 
$3BE3  29 0F     AND #$0F
$3BE5  85 A4     STA $A4 
$3BE7  A9 C0     LDA #$C0
$3BE9  85 7A     STA $7A 
$3BEB  A9 00     LDA #$00
$3BED  85 7B     STA $7B 
$3BEF  A0 00     LDY #$00
$3BF1  20 F3 37  JSR L_JSR_($37F3)_($3BF1) OK
$3BF4  08        PHP 
$3BF5  AD 96 15  LDA $1596 
$3BF8  85 7A     STA $7A 
$3BFA  AD 97 15  LDA $1597 
$3BFD  85 7B     STA $7B 
$3BFF  28        PLP 
$3C00  90 11     BCC L_BRS_($3C13)_($3C00) OK
$3C02  AD 2F 17  LDA $172F 
$3C05  29 F0     AND #$F0
$3C07  D0 03     BNE L_BRS_($3C0C)_($3C07) OK
//------------------------------
L_BRS_($3C09)_($3C18) OK
//------------------------------
$3C09  4C B7 3C  JMP L_JMP_($3CB7)_($3C09) OK
//------------------------------
L_BRS_($3C0C)_($3C07) OK
//------------------------------
$3C0C  05 A4     ORA $A4
$3C0E  85 A4     STA $A4 
//------------------------------
L_JSR_($3C11)_($9BBA) BAD
//------------------------------
$3C10  4C 22 3C  JMP L_JMP_($3C22)_($3C10) OK
//------------------------------
L_BRS_($3C13)_($3C00) OK
//------------------------------
$3C13  AD 2F 17  LDA $172F 
$3C16  29 0F     AND #$0F
$3C18  F0 EF     BEQ L_BRS_($3C09)_($3C18) OK
$3C1A  0A        ASL A 
$3C1B  0A        ASL A 
$3C1C  0A        ASL A 
$3C1D  0A        ASL A 
$3C1E  05 A4     ORA $A4
$3C20  85 A4     STA $A4 
//------------------------------
L_BRS_($3C22)_($3BBD) OK
L_BRS_($3C22)_($3BDC) OK
L_JMP_($3C22)_($3C10) OK
//------------------------------
$3C22  A9 01     LDA #$01
$3C24  A8        TAY 
$3C25  8D 45 15  STA $1545 
$3C28  B1 7A     LDA ($7A),Y 
$3C2A  18        CLC 
$3C2B  69 01     ADC #$01
$3C2D  91 7A     STA ($7A),Y 
$3C2F  A4 A1     LDY $A1 
$3C31  A5 A4     LDA $A4 
$3C33  91 7A     STA ($7A),Y 
$3C35  C8        INY 
$3C36  A2 00     LDX #$00
$3C38  AD 9E 15  LDA $159E 
$3C3B  0A        ASL A 
$3C3C  85 A5     STA $A5 
//------------------------------
L_BRS_($3C3E)_($3C46) OK
//------------------------------
$3C3E  B5 C0     LDA $C0,X 
$3C40  91 7A     STA ($7A),Y 
$3C42  E8        INX 
$3C43  C8        INY 
$3C44  E4 A5     CPX $A5 
$3C46  90 F6     BCC L_BRS_($3C3E)_($3C46) OK
$3C48  84 A1     STY $A1 
$3C4A  AD 9E 15  LDA $159E 
$3C4D  C9 04     CMP #$04
$3C4F  D0 66     BNE L_BRS_($3CB7)_($3C4F) OK
$3C51  84 A5     STY $A5 
$3C53  98        TYA 
$3C54  0A        ASL A 
$3C55  38        SEC 
$3C56  E9 08     SBC #$08
$3C58  A8        TAY 
$3C59  A9 00     LDA #$00
$3C5B  85 82     STA $82 
$3C5D  85 83     STA $83 
$3C5F  85 84     STA $84 
$3C61  85 85     STA $85 
//------------------------------
L_BRS_($3C63)_($3C9A) OK
//------------------------------
$3C63  B1 7A     LDA ($7A),Y 
$3C65  D0 16     BNE L_BRS_($3C7D)_($3C65) OK
$3C67  C8        INY 
$3C68  B1 7A     LDA ($7A),Y 
$3C6A  D0 05     BNE L_BRS_($3C71)_($3C6A) OK
$3C6C  E6 82     INC $82 
$3C6E  4C 97 3C  JMP L_JMP_($3C97)_($3C6E) OK
//------------------------------
L_BRS_($3C71)_($3C6A) OK
//------------------------------
$3C71  A9 34     LDA #$34
$3C73  0A        ASL A 
$3C74  D1 7A     CMP ($7A),Y 
$3C76  D0 3F     BNE L_BRS_($3CB7)_($3C76) OK
$3C78  E6 83     INC $83 
$3C7A  4C 97 3C  JMP L_JMP_($3C97)_($3C7A) OK
//------------------------------
L_BRS_($3C7D)_($3C65) OK
//------------------------------
$3C7D  A9 40     LDA #$40
$3C7F  0A        ASL A 
$3C80  D1 7A     CMP ($7A),Y 
$3C82  D0 33     BNE L_BRS_($3CB7)_($3C82) OK
$3C84  C8        INY 
$3C85  A9 34     LDA #$34
$3C87  0A        ASL A 
$3C88  D1 7A     CMP ($7A),Y 
$3C8A  D0 05     BNE L_BRS_($3C91)_($3C8A) OK
$3C8C  E6 84     INC $84 
$3C8E  4C 97 3C  JMP L_JMP_($3C97)_($3C8E) OK
//------------------------------
L_BRS_($3C91)_($3C8A) OK
//------------------------------
$3C91  C9 00     CMP #$00
$3C93  D0 22     BNE L_BRS_($3CB7)_($3C93) OK
$3C95  E6 85     INC $85 
//------------------------------
L_JMP_($3C97)_($3C6E) OK
L_JMP_($3C97)_($3C7A) OK
L_JMP_($3C97)_($3C8E) OK
//------------------------------
$3C97  C8        INY 
$3C98  C4 A5     CPY $A5 
$3C9A  D0 C7     BNE L_BRS_($3C63)_($3C9A) OK
$3C9C  A5 82     LDA $82 
$3C9E  18        CLC 
$3C9F  65 83     ADC $83 
$3CA1  65 84     ADC $84 
$3CA3  65 85     ADC $85 
$3CA5  C9 04     CMP #$04
$3CA7  D0 0E     BNE L_BRS_($3CB7)_($3CA7) OK
$3CA9  EE 55 15  INC $1555 
$3CAC  A0 01     LDY #$01
$3CAE  B1 7A     LDA ($7A),Y 
$3CB0  09 80     ORA #$80
$3CB2  91 7A     STA ($7A),Y 
$3CB4  4C C3 3C  JMP L_JMP_($3CC3)_($3CB4) OK
//------------------------------
L_JMP_($3CB7)_($3B63) OK
L_JMP_($3CB7)_($3BAB) OK
L_JMP_($3CB7)_($3BDE) OK
L_JMP_($3CB7)_($3C09) OK
L_BRS_($3CB7)_($3C4F) OK
L_BRS_($3CB7)_($3C76) OK
L_BRS_($3CB7)_($3C82) OK
L_BRS_($3CB7)_($3C93) OK
L_BRS_($3CB7)_($3CA7) OK
//------------------------------
$3CB7  C6 A2     DEC $A2 
$3CB9  F0 03     BEQ L_BRS_($3CBE)_($3CB9) OK
$3CBB  4C 53 3B  JMP L_JMP_($3B53)_($3CBB) OK
//------------------------------
L_BRS_($3CBE)_($3CB9) OK
//------------------------------
$3CBE  AD 45 15  LDA $1545 
$3CC1  F0 52     BEQ L_BRS_($3D15)_($3CC1) OK
//------------------------------
L_JMP_($3CC3)_($3CB4) OK
//------------------------------
$3CC3  AD 9A 15  LDA $159A 
$3CC6  85 7C     STA $7C 
$3CC8  AD 9B 15  LDA $159B 
$3CCB  85 7D     STA $7D 
$3CCD  A0 00     LDY #$00
$3CCF  AD 96 15  LDA $1596 
$3CD2  91 7C     STA ($7C),Y 
$3CD4  C8        INY 
$3CD5  AD 97 15  LDA $1597 
$3CD8  91 7C     STA ($7C),Y 
$3CDA  C8        INY 
$3CDB  A5 A1     LDA $A1 
$3CDD  18        CLC 
$3CDE  65 7A     ADC $7A 
$3CE0  8D 96 15  STA $1596 
$3CE3  A5 7B     LDA $7B 
$3CE5  69 00     ADC #$00
$3CE7  8D 97 15  STA $1597 
$3CEA  AD 98 15  LDA $1598 
$3CED  91 7C     STA ($7C),Y 
$3CEF  C8        INY 
$3CF0  AD 99 15  LDA $1599 
$3CF3  91 7C     STA ($7C),Y 
$3CF5  A5 7C     LDA $7C 
$3CF7  18        CLC 
$3CF8  69 04     ADC #$04
$3CFA  8D 9A 15  STA $159A 
$3CFD  A5 7D     LDA $7D 
$3CFF  69 00     ADC #$00
//------------------------------
L_JSR_($3D01)_($9C26) OK
//------------------------------
$3D01  8D 9B 15  STA $159B 
$3D04  A9 0C     LDA #$0C
$3D06  18        CLC 
$3D07  6D 98 15  ADC $1598 
$3D0A  8D 98 15  STA $1598 
$3D0D  90 03     BCC L_BRS_($3D12)_($3D0D) OK
$3D0F  EE 99 15  INC $1599 
//------------------------------
L_BRS_($3D12)_($3D0D) OK
//------------------------------
$3D12  EE 54 15  INC $1554 
//------------------------------
L_BRS_($3D15)_($3CC1) OK
//------------------------------
$3D15  60        RTS 
//------------------------------
L_JSR_($3D16)_($2E33) OK
//------------------------------
$3D16  AD 9E 15  LDA $159E 
$3D19  0A        ASL A 
$3D1A  A8        TAY 
$3D1B  AA        TAX 
//------------------------------
L_BRS_($3D1C)_($3D22) OK
//------------------------------
$3D1C  B1 7C     LDA ($7C),Y 
$3D1E  99 BF 00  STA $00BF,Y 
$3D21  88        DEY 
$3D22  D0 F8     BNE L_BRS_($3D1C)_($3D22) OK
$3D24  A9 20     LDA #$20
$3D26  0A        ASL A 
$3D27  0A        ASL A 
$3D28  0A        ASL A 
$3D29  38        SEC 
$3D2A  E9 01     SBC #$01
$3D2C  85 B0     STA $B0 
$3D2E  38        SEC 
$3D2F  E5 C0     SBC $C0 
$3D31  85 C0     STA $C0 
$3D33  95 C0     STA $C0,X 
$3D35  A5 C1     LDA $C1 
$3D37  95 C1     STA $C1,X 
$3D39  A2 01     LDX #$01
$3D3B  B5 C0     LDA $C0,X 
$3D3D  8D 3D 15  STA $153D 
$3D40  8D 3E 15  STA $153E 
$3D43  E8        INX 
$3D44  E8        INX 
//------------------------------
L_BRS_($3D45)_($3D68) OK
//------------------------------
$3D45  A5 B0     LDA $B0 
$3D47  38        SEC 
$3D48  F5 BF     SBC $BF,X 
$3D4A  95 BF     STA $BF,X 
$3D4C  B5 C0     LDA $C0,X 
$3D4E  CD 3D 15  CMP $153D 
$3D51  90 03     BCC L_BRS_($3D56)_($3D51) OK
$3D53  8D 3D 15  STA $153D 
//------------------------------
L_BRS_($3D56)_($3D51) OK
//------------------------------
$3D56  CD 3E 15  CMP $153E 
$3D59  B0 03     BCS L_BRS_($3D5E)_($3D59) OK
$3D5B  8D 3E 15  STA $153E 
//------------------------------
L_BRS_($3D5E)_($3D59) OK
//------------------------------
$3D5E  AD 9E 15  LDA $159E 
$3D61  0A        ASL A 
$3D62  85 82     STA $82 
$3D64  E8        INX 
$3D65  E8        INX 
$3D66  E4 82     CPX $82 
$3D68  90 DB     BCC L_BRS_($3D45)_($3D68) OK
$3D6A  A2 00     LDX #$00
//------------------------------
L_JMP_($3D6C)_($3EEF) OK
//------------------------------
$3D6C  B5 C1     LDA $C1,X 
$3D6E  A8        TAY 
$3D6F  D5 C3     CMP $C3,X 
$3D71  D0 20     BNE L_BRS_($3D93)_($3D71) OK
$3D73  CD 3D 15  CMP $153D 
$3D76  F0 05     BEQ L_BRS_($3D7D)_($3D76) OK
$3D78  CD 3E 15  CMP $153E 
$3D7B  D0 13     BNE L_BRS_($3D90)_($3D7B) OK
//------------------------------
L_BRS_($3D7D)_($3D76) OK
//------------------------------
$3D7D  B5 C0     LDA $C0,X 
$3D7F  D5 C2     CMP $C2,X 
$3D81  F0 0D     BEQ L_BRS_($3D90)_($3D81) OK
$3D83  99 DB 15  STA $15DB,Y 
$3D86  B5 C2     LDA $C2,X 
$3D88  99 44 16  STA $1644,Y 
$3D8B  A9 02     LDA #$02
$3D8D  99 AD 16  STA $16AD,Y 
//------------------------------
L_BRS_($3D90)_($3D7B) OK
L_BRS_($3D90)_($3D81) OK
//------------------------------
$3D90  4C E3 3E  JMP L_JMP_($3EE3)_($3D90) OK
//------------------------------
L_BRS_($3D93)_($3D71) OK
//------------------------------
$3D93  B5 C1     LDA $C1,X 
$3D95  D5 C3     CMP $C3,X 
$3D97  90 05     BCC L_BRS_($3D9E)_($3D97) OK
$3D99  B4 C3     LDY $C3,X 
$3D9B  4C 9F 3D  JMP L_JMP_($3D9F)_($3D9B) OK
//------------------------------
L_BRS_($3D9E)_($3D97) OK
//------------------------------
$3D9E  A8        TAY 
//------------------------------
L_JMP_($3D9F)_($3D9B) OK		
//------------------------------
$3D9F  B5 C2     LDA $C2,X 
$3DA1  D5 C0     CMP $C0,X 
$3DA3  D0 3B     BNE L_BRS_($3DE0)_($3DA3) OK
$3DA5  B5 C1     LDA $C1,X 
$3DA7  38        SEC 
$3DA8  F5 C3     SBC $C3,X 
$3DAA  10 05     BPL L_BRS_($3DB1)_($3DAA) OK
$3DAC  49 FF     EOR #$FF
$3DAE  18        CLC 
$3DAF  69 01     ADC #$01
//------------------------------
L_BRS_($3DB1)_($3DAA) OK
//------------------------------
$3DB1  85 82     STA $82 
//------------------------------
L_BRS_($3DB3)_($3DDB) OK
//------------------------------
$3DB3  B9 AD 16  LDA $16AD,Y 
$3DB6  D0 0D     BNE L_BRS_($3DC5)_($3DB6) OK
$3DB8  B5 C0     LDA $C0,X 
$3DBA  99 DB 15  STA $15DB,Y 
$3DBD  A9 01     LDA #$01
$3DBF  99 AD 16  STA $16AD,Y 
$3DC2  4C D8 3D  JMP L_JMP_($3DD8)_($3DC2) OK
//------------------------------
L_BRS_($3DC5)_($3DB6) OK
//------------------------------
$3DC5  C9 01     CMP #$01
$3DC7  D0 0F     BNE L_BRS_($3DD8)_($3DC7) OK
$3DC9  B5 C0     LDA $C0,X 
$3DCB  D9 DB 15  CMP $15DB,Y 
$3DCE  F0 08     BEQ L_BRS_($3DD8)_($3DCE) OK
$3DD0  99 44 16  STA $1644,Y 
$3DD3  A9 02     LDA #$02
$3DD5  99 AD 16  STA $16AD,Y 
//------------------------------
L_JMP_($3DD8)_($3DC2) OK
L_BRS_($3DD8)_($3DC7) OK
L_BRS_($3DD8)_($3DCE) OK
//------------------------------
$3DD8  C8        INY 
$3DD9  C6 82     DEC $82 
$3DDB  10 D6     BPL L_BRS_($3DB3)_($3DDB) OK
$3DDD  4C E3 3E  JMP L_JMP_($3EE3)_($3DDD) OK
//------------------------------
L_BRS_($3DE0)_($3DA3) OK
//------------------------------
$3DE0  B5 C0     LDA $C0,X 
$3DE2  8D 2B 17  STA $172B 
$3DE5  B5 C2     LDA $C2,X 
$3DE7  38        SEC 
$3DE8  ED 2B 17  SBC $172B 
$3DEB  10 10     BPL L_BRS_($3DFD)_($3DEB) OK
$3DED  49 FF     EOR #$FF
$3DEF  18        CLC 
$3DF0  69 01     ADC #$01
$3DF2  85 B1     STA $B1 
$3DF4  A9 FF     LDA #$FF
$3DF6  85 B5     STA $B5 
$3DF8  85 B6     STA $B6 
$3DFA  4C 05 3E  JMP L_JMP_($3E05)_($3DFA) OK
//------------------------------
L_BRS_($3DFD)_($3DEB) OK
//------------------------------
$3DFD  85 B1     STA $B1 
$3DFF  A9 01     LDA #$01
//------------------------------
L_JSR_($3E01)_($B929) OK
//------------------------------
$3E01  85 B5     STA $B5 
$3E03  85 B6     STA $B6 
//------------------------------
L_JMP_($3E05)_($3DFA) OK
//------------------------------
$3E05  B5 C1     LDA $C1,X 
$3E07  8D 2C 17  STA $172C 
$3E0A  B5 C3     LDA $C3,X 
$3E0C  38        SEC 
$3E0D  ED 2C 17  SBC $172C 
$3E10  10 10     BPL L_BRS_($3E22)_($3E10) OK
$3E12  49 FF     EOR #$FF
$3E14  18        CLC 
$3E15  69 01     ADC #$01
$3E17  85 B2     STA $B2 
$3E19  A9 FF     LDA #$FF
$3E1B  85 B3     STA $B3 
$3E1D  85 B4     STA $B4 
$3E1F  4C 2A 3E  JMP L_JMP_($3E2A)_($3E1F) OK
//------------------------------
L_BRS_($3E22)_($3E10) OK
//------------------------------
$3E22  85 B2     STA $B2 
$3E24  A9 01     LDA #$01
$3E26  85 B3     STA $B3 
$3E28  85 B4     STA $B4 
//------------------------------
L_JMP_($3E2A)_($3E1F) OK
//------------------------------
$3E2A  A5 B1     LDA $B1 
$3E2C  C5 B2     CMP $B2 
$3E2E  B0 5A     BCS L_BRS_($3E8A)_($3E2E) OK
$3E30  A5 B2     LDA $B2 
$3E32  85 B7     STA $B7 
$3E34  4A        LSR A 
$3E35  85 B8     STA $B8 
//------------------------------
L_BRS_($3E37)_($3E85) OK
//------------------------------
$3E37  AC 2C 17  LDY $172C 
$3E3A  B9 AD 16  LDA $16AD,Y 
$3E3D  D0 0E     BNE L_BRS_($3E4D)_($3E3D) OK
$3E3F  A9 01     LDA #$01
$3E41  99 AD 16  STA $16AD,Y 
$3E44  AD 2B 17  LDA $172B 
$3E47  99 DB 15  STA $15DB,Y 
$3E4A  4C 61 3E  JMP L_JMP_($3E61)_($3E4A) OK
//------------------------------
L_BRS_($3E4D)_($3E3D) OK
//------------------------------
$3E4D  C9 01     CMP #$01
$3E4F  D0 10     BNE L_BRS_($3E61)_($3E4F) OK
$3E51  AD 2B 17  LDA $172B 
$3E54  D9 DB 15  CMP $15DB,Y 
$3E57  F0 08     BEQ L_BRS_($3E61)_($3E57) OK
$3E59  99 44 16  STA $1644,Y 
$3E5C  A9 02     LDA #$02
$3E5E  99 AD 16  STA $16AD,Y 
//------------------------------
L_JMP_($3E61)_($3E4A) OK
L_BRS_($3E61)_($3E4F) OK
L_BRS_($3E61)_($3E57) OK
//------------------------------
$3E61  AD 2C 17  LDA $172C 
$3E64  18        CLC 
$3E65  65 B3     ADC $B3 
$3E67  8D 2C 17  STA $172C 
$3E6A  A5 B8     LDA $B8 
$3E6C  18        CLC 
$3E6D  65 B1     ADC $B1 
$3E6F  85 B8     STA $B8 
$3E71  C5 B2     CMP $B2 
$3E73  90 0E     BCC L_BRS_($3E83)_($3E73) OK
$3E75  38        SEC 
$3E76  E5 B2     SBC $B2 
$3E78  85 B8     STA $B8 
$3E7A  AD 2B 17  LDA $172B 
$3E7D  18        CLC 
$3E7E  65 B6     ADC $B6 
$3E80  8D 2B 17  STA $172B 
//------------------------------
L_BRS_($3E83)_($3E73) OK
//------------------------------
$3E83  C6 B7     DEC $B7 
$3E85  D0 B0     BNE L_BRS_($3E37)_($3E85) OK
$3E87  4C E3 3E  JMP L_JMP_($3EE3)_($3E87) OK
//------------------------------
L_BRS_($3E8A)_($3E2E) OK
//------------------------------
$3E8A  A5 B2     LDA $B2 
$3E8C  85 B7     STA $B7 
$3E8E  A5 B1     LDA $B1 
$3E90  4A        LSR A 
$3E91  85 B8     STA $B8 
//------------------------------
L_BRS_($3E93)_($3EE1) OK
//------------------------------
$3E93  AC 2C 17  LDY $172C 
$3E96  B9 AD 16  LDA $16AD,Y 
$3E99  D0 0E     BNE L_BRS_($3EA9)_($3E99) OK
$3E9B  A9 01     LDA #$01
$3E9D  99 AD 16  STA $16AD,Y 
$3EA0  AD 2B 17  LDA $172B 
$3EA3  99 DB 15  STA $15DB,Y 
$3EA6  4C BD 3E  JMP L_JMP_($3EBD)_($3EA6) OK
//------------------------------
L_BRS_($3EA9)_($3E99) OK
//------------------------------
$3EA9  C9 01     CMP #$01
$3EAB  D0 10     BNE L_BRS_($3EBD)_($3EAB) OK
$3EAD  AD 2B 17  LDA $172B 
$3EB0  D9 DB 15  CMP $15DB,Y 
$3EB3  F0 0B     BEQ L_BRS_($3EC0)_($3EB3) OK
$3EB5  99 44 16  STA $1644,Y 
$3EB8  A9 02     LDA #$02
$3EBA  99 AD 16  STA $16AD,Y 
//------------------------------
L_JMP_($3EBD)_($3EA6) OK
L_BRS_($3EBD)_($3EAB) OK
L_BRS_($3EBD)_($3ECF) OK
//------------------------------
$3EBD  AD 2B 17  LDA $172B 
//------------------------------
L_BRS_($3EC0)_($3EB3) OK
//------------------------------
$3EC0  18        CLC 
$3EC1  65 B5     ADC $B5 
$3EC3  8D 2B 17  STA $172B 
$3EC6  A5 B8     LDA $B8 
$3EC8  18        CLC 
$3EC9  65 B2     ADC $B2 
$3ECB  85 B8     STA $B8 
$3ECD  C5 B1     CMP $B1 
$3ECF  90 EC     BCC L_BRS_($3EBD)_($3ECF) OK
$3ED1  38        SEC 
$3ED2  E5 B1     SBC $B1 
$3ED4  85 B8     STA $B8 
$3ED6  AD 2C 17  LDA $172C 
$3ED9  18        CLC 
$3EDA  65 B4     ADC $B4 
$3EDC  8D 2C 17  STA $172C 
$3EDF  C6 B7     DEC $B7 
$3EE1  D0 B0     BNE L_BRS_($3E93)_($3EE1) OK
//------------------------------
L_JMP_($3EE3)_($3D90) OK
L_JMP_($3EE3)_($3DDD) OK
L_JMP_($3EE3)_($3E87) OK
//------------------------------
$3EE3  AD 9E 15  LDA $159E 
$3EE6  0A        ASL A 
$3EE7  85 82     STA $82 
$3EE9  E8        INX 
$3EEA  E8        INX 
$3EEB  E4 82     CPX $82 
$3EED  B0 03     BCS L_BRS_($3EF2)_($3EED) OK
$3EEF  4C 6C 3D  JMP L_JMP_($3D6C)_($3EEF) OK
//------------------------------
L_BRS_($3EF2)_($3EED) OK
//------------------------------
$3EF2  60        RTS 
//------------------------------
L_JSR_($3EF3)_($2E39) OK
//------------------------------
$3EF3  A9 20     LDA #$20
$3EF5  0A        ASL A 
$3EF6  0A        ASL A 
$3EF7  0A        ASL A 
$3EF8  38        SEC 
$3EF9  E9 01     SBC #$01
$3EFB  85 B0     STA $B0 
$3EFD  38        SEC 
$3EFE  A0 01     LDY #$01
$3F00  F1 7C     SBC ($7C),Y 
$3F02  85 C0     STA $C0 
$3F04  C8        INY 
$3F05  B1 7C     LDA ($7C),Y 
$3F07  85 C1     STA $C1 
$3F09  C8        INY 
$3F0A  A5 B0     LDA $B0 
$3F0C  38        SEC 
$3F0D  F1 7C     SBC ($7C),Y 
$3F0F  85 C2     STA $C2 
$3F11  C8        INY 
$3F12  B1 7C     LDA ($7C),Y 
$3F14  85 C3     STA $C3 
$3F16  C5 C1     CMP $C1 
$3F18  D0 17     BNE L_BRS_($3F31)_($3F18) OK
$3F1A  AA        TAX 
$3F1B  8D 3E 15  STA $153E 
$3F1E  8D 3D 15  STA $153D 
$3F21  A9 02     LDA #$02
$3F23  9D AD 16  STA $16AD,X 
$3F26  A5 C0     LDA $C0 
$3F28  9D DB 15  STA $15DB,X 
$3F2B  A5 C2     LDA $C2 
$3F2D  9D 44 16  STA $1644,X 
$3F30  60        RTS 
//------------------------------
L_BRS_($3F31)_($3F18) OK
//------------------------------
$3F31  A5 C0     LDA $C0 
$3F33  C5 C2     CMP $C2 
$3F35  D0 2C     BNE L_BRS_($3F63)_($3F35) OK
$3F37  A5 C3     LDA $C3 
$3F39  AA        TAX 
$3F3A  38        SEC 
$3F3B  A4 C1     LDY $C1 
$3F3D  E5 C1     SBC $C1 
$3F3F  10 08     BPL L_BRS_($3F49)_($3F3F) OK
$3F41  A5 C1     LDA $C1 
$3F43  AA        TAX 
$3F44  A4 C3     LDY $C3 
$3F46  38        SEC 
$3F47  E5 C3     SBC $C3 
//------------------------------
L_BRS_($3F49)_($3F3F) OK
//------------------------------
$3F49  8C 3E 15  STY $153E 
$3F4C  8E 3D 15  STX $153D 
$3F4F  AA        TAX 
//------------------------------
L_BRS_($3F50)_($3F5E) OK
L_BRS_($3F50)_($3F60) OK
//------------------------------
$3F50  A5 C0     LDA $C0 
$3F52  99 DB 15  STA $15DB,Y 
$3F55  A9 01     LDA #$01
$3F57  99 AD 16  STA $16AD,Y 
$3F5A  C8        INY 
$3F5B  CC 3D 15  CPY $153D 
$3F5E  90 F0     BCC L_BRS_($3F50)_($3F5E) OK
$3F60  F0 EE     BEQ L_BRS_($3F50)_($3F60) OK
$3F62  60        RTS 
//------------------------------
L_BRS_($3F63)_($3F35) OK
//------------------------------
$3F63  A9 01     LDA #$01
$3F65  85 B2     STA $B2 
$3F67  85 B3     STA $B3 
$3F69  A5 C2     LDA $C2 
$3F6B  38        SEC 
$3F6C  E5 C0     SBC $C0 
$3F6E  10 09     BPL L_BRS_($3F79)_($3F6E) OK
$3F70  49 FF     EOR #$FF
$3F72  18        CLC 
$3F73  69 01     ADC #$01
$3F75  A2 FF     LDX #$FF
$3F77  86 B2     STX $B2 
//------------------------------
L_BRS_($3F79)_($3F6E) OK
//------------------------------
$3F79  85 83     STA $83 
$3F7B  A5 C3     LDA $C3 
$3F7D  8D 3D 15  STA $153D 
$3F80  A4 C1     LDY $C1 
$3F82  38        SEC 
$3F83  E5 C1     SBC $C1 
$3F85  10 1B     BPL L_BRS_($3FA2)_($3F85) OK
$3F87  A2 FF     LDX #$FF
$3F89  86 B3     STX $B3 
$3F8B  48        PHA 
$3F8C  A5 B2     LDA $B2 
$3F8E  49 FF     EOR #$FF
$3F90  18        CLC 
$3F91  69 01     ADC #$01
$3F93  85 B2     STA $B2 
$3F95  68        PLA 
$3F96  49 FF     EOR #$FF
$3F98  18        CLC 
$3F99  69 01     ADC #$01
$3F9B  A4 C3     LDY $C3 
$3F9D  A6 C1     LDX $C1 
$3F9F  8E 3D 15  STX $153D 
//------------------------------
L_BRS_($3FA2)_($3F85) OK
//------------------------------
$3FA2  8C 3E 15  STY $153E 
$3FA5  85 82     STA $82 
$3FA7  38        SEC 
$3FA8  E5 83     SBC $83 
$3FAA  30 45     BMI L_BRS_($3FF1)_($3FAA) OK
$3FAC  A5 82     LDA $82 
$3FAE  85 B4     STA $B4 
$3FB0  A5 83     LDA $83 
$3FB2  85 B5     STA $B5 
$3FB4  A5 B4     LDA $B4 
$3FB6  85 B1     STA $B1 
$3FB8  4A        LSR A 
$3FB9  85 B0     STA $B0 
$3FBB  A5 B3     LDA $B3 
$3FBD  08        PHP 
$3FBE  A5 C0     LDA $C0 
$3FC0  28        PLP 
$3FC1  10 02     BPL L_BRS_($3FC5)_($3FC1) OK
$3FC3  A5 C2     LDA $C2 
//------------------------------
L_BRS_($3FC5)_($3FC1) OK
//------------------------------
$3FC5  99 DB 15  STA $15DB,Y 
$3FC8  AA        TAX 
$3FC9  A9 01     LDA #$01
$3FCB  99 AD 16  STA $16AD,Y 
//------------------------------
L_BRS_($3FCE)_($3FEE) OK
//------------------------------
$3FCE  A5 B5     LDA $B5 
$3FD0  18        CLC 
$3FD1  65 B0     ADC $B0 
$3FD3  85 B0     STA $B0 
$3FD5  38        SEC 
$3FD6  E5 B4     SBC $B4 
$3FD8  30 07     BMI L_BRS_($3FE1)_($3FD8) OK
$3FDA  85 B0     STA $B0 
$3FDC  8A        TXA 
$3FDD  18        CLC 
$3FDE  65 B2     ADC $B2 
$3FE0  AA        TAX 
//------------------------------
L_BRS_($3FE1)_($3FD8) OK
//------------------------------
$3FE1  C8        INY 
$3FE2  8A        TXA 
$3FE3  99 DB 15  STA $15DB,Y 
$3FE6  AA        TAX 
$3FE7  A9 01     LDA #$01
$3FE9  99 AD 16  STA $16AD,Y 
$3FEC  C6 B1     DEC $B1 
$3FEE  D0 DE     BNE L_BRS_($3FCE)_($3FEE) OK
$3FF0  60        RTS 
//------------------------------
L_BRS_($3FF1)_($3FAA) OK
//------------------------------
$3FF1  A5 82     LDA $82 
$3FF3  85 B5     STA $B5 
$3FF5  A5 83     LDA $83 
$3FF7  85 B4     STA $B4 
$3FF9  85 B1     STA $B1 
$3FFB  4A        LSR A 
$3FFC  85 B0     STA $B0 
$3FFE  A5 C0     LDA $C0 
//------------------------------
L_JSR_($4000)_($98EB) OK
//------------------------------
$4000  A6 B3     LDX $B3 
$4002  10 02     BPL L_BRS_($4006)_($4002) OK
$4004  A5 C2     LDA $C2 
//------------------------------
L_BRS_($4006)_($4002) OK
//------------------------------
$4006  85 84     STA $84 
$4008  99 DB 15  STA $15DB,Y 
$400B  A9 01     LDA #$01
$400D  99 AD 16  STA $16AD,Y 
//------------------------------
L_BRS_($4010)_($403F) OK
//------------------------------
$4010  A5 84     LDA $84 
$4012  18        CLC 
$4013  65 B2     ADC $B2 
$4015  85 84     STA $84 
$4017  A5 B5     LDA $B5 
$4019  18        CLC 
$401A  65 B0     ADC $B0 
$401C  85 B0     STA $B0 
$401E  38        SEC 
$401F  E5 B4     SBC $B4 
$4021  30 1A     BMI L_BRS_($403D)_($4021) OK
$4023  85 B0     STA $B0 
$4025  A5 84     LDA $84 
$4027  38        SEC 
$4028  E5 B2     SBC $B2 
$402A  99 44 16  STA $1644,Y 
$402D  A9 02     LDA #$02
$402F  99 AD 16  STA $16AD,Y 
$4032  C8        INY 
$4033  A5 84     LDA $84 
$4035  99 DB 15  STA $15DB,Y 
$4038  A9 01     LDA #$01
$403A  99 AD 16  STA $16AD,Y 
//------------------------------
L_BRS_($403D)_($4021) OK
//------------------------------
$403D  C6 B1     DEC $B1 
//------------------------------
L_JSR_($4040)_($08AF) BAD
//------------------------------
$403F  D0 CF     BNE L_BRS_($4010)_($403F) OK
$4041  A5 84     LDA $84 
$4043  99 44 16  STA $1644,Y 
$4046  A9 02     LDA #$02
$4048  99 AD 16  STA $16AD,Y 
$404B  60        RTS 
//------------------------------
L_JMP_($404C)_($8899) OK
L_JSR_($404C)_($917A) OK
//------------------------------
$404C  A9 2B     LDA #$2B							; TODO: C64 startup
$404E  8D 11 D0  STA $D011                          ; bitmap + 25 rows screen + Y scroll (2) // Control Register 1
$4051  A9 00     LDA #$00
$4053  8D 20 D0  STA $D020                          // Border Color
$4056  A9 0A     LDA #$0A
//------------------------------
L_BRS_($4058)_($4065) OK
//------------------------------
$4058  A2 00     LDX #$00
//------------------------------
L_BRS_($405A)_($4060) OK
//------------------------------
$405A  A0 00     LDY #$00
//------------------------------
L_BRS_($405C)_($405D) OK
//------------------------------
$405C  88        DEY 
$405D  D0 FD     BNE L_BRS_($405C)_($405D) OK
$405F  CA        DEX 
$4060  D0 F8     BNE L_BRS_($405A)_($4060) OK
$4062  38        SEC 
$4063  E9 01     SBC #$01
$4065  D0 F1     BNE L_BRS_($4058)_($4065) OK
$4067  78        SEI 
$4068  A9 37     LDA #$37
$406A  85 01     STA $01 
$406C  A9 C0     LDA #$C0
$406E  20 90 FF  JSR L_JSR_($FF90)_($406E) JAM	; TODO: KERNAL SETMSG
$4071  20 8C 7E  JSR L_JSR_($7E8C)_($4071) OK	; page 0 backup
$4074  A9 37     LDA #$37
$4076  85 01     STA $01 
$4078  A9 00     LDA #$00
$407A  20 21 10  JSR L_JSR_($1021)_($407A) OK	; SID player init
$407D  A9 01     LDA #$01
$407F  8D 37 17  STA $1737 
$4082  8D 36 17  STA $1736 
$4085  8D 00 09  STA $0900 
$4088  A9 D1     LDA #$D1		; chrout vector
$408A  8D 26 03  STA $0326 
$408D  A9 7D     LDA #$7D
$408F  8D 27 03  STA $0327 
$4092  A2 FF     LDX #$FF
$4094  9A        TXS 
$4095  A9 35     LDA #$35
$4097  85 01     STA $01 
$4099  A9 01     LDA #$01
$409B  8D 77 15  STA $1577 
$409E  8D 89 15  STA $1589 
$40A1  20 AE 6B  JSR L_JSR_($6BAE)_($40A1) OK
$40A4  20 91 48  JSR L_JSR_($4891)_($40A4) OK
$40A7  A9 00     LDA #$00
$40A9  8D 1B D0  STA $D01B                          ; sprite priority - above BG // Sprite to Background Display Priority
$40AC  8D 1D D0  STA $D01D                          ; sprite expand - none // Sprites Expand 2x Horizontal (X)
$40AF  8D 17 D0  STA $D017                          ; none // Sprites Expand 2x Vertical (Y)
$40B2  A9 F8     LDA #$F8
$40B4  8D 1C D0  STA $D01C                          ; sprites 7,6,5,4,3 multicolor // Sprites Multi-Color Mode Select
$40B7  A9 07     LDA #$07
$40B9  8D 25 D0  STA $D025                          // Sprite Multi-Color Register 0
$40BC  A9 02     LDA #$02
$40BE  8D 26 D0  STA $D026                          // Sprite Multi-Color Register 1
$40C1  20 12 CD  JSR L_JSR_($CD12)_($40C1) OK		; TODO: sfx?
$40C4  A9 FD     LDA #$FD
$40C6  8D 43 15  STA $1543 
$40C9  A9 FF     LDA #$FF
$40CB  8D 44 15  STA $1544 
$40CE  20 88 1F  JSR L_JSR_($1F88)_($40CE) OK
$40D1  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$40D4  29 FC     AND #$FC
$40D6  8D 00 DD  STA $DD00                          ; VIC at $c000 // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$40D9  AD 18 D0  LDA $D018                          // Memory Control Register
$40DC  09 08     ORA #$08
$40DE  8D 18 D0  STA $D018                          // Memory Control Register
$40E1  AD 16 D0  LDA $D016                          // Control Register 2
$40E4  09 10     ORA #$10
$40E6  8D 16 D0  STA $D016                          ; multicolor // Control Register 2
$40E9  AD 11 D0  LDA $D011                          // Control Register 1
$40EC  09 30     ORA #$30
$40EE  8D 11 D0  STA $D011                          ; display on + bitmap // Control Register 1
$40F1  A9 00     LDA #$00
$40F3  8D 21 D0  STA $D021                          // Background Color 0
$40F6  8D 20 D0  STA $D020                          // Border Color
$40F9  4C 13 41  JMP L_JMP_($4113)_($40F9) OK
//------------------------------
L_JMP_($40FC)_($4162) OK
//------------------------------
$40FC  20 12 CD  JSR L_JSR_($CD12)_($40FC) OK		; TODO: sfx
$40FF  A9 FD     LDA #$FD
$4101  8D 43 15  STA $1543 
$4104  A9 FF     LDA #$FF
//------------------------------
L_JMP_($4108)_($18F7) BAD
//------------------------------
$4106  8D 44 15  STA $1544 
$4109  20 88 1F  JSR L_JSR_($1F88)_($4109) OK
$410C  AD 77 15  LDA $1577 
$410F  C9 03     CMP #$03
$4111  F0 26     BEQ L_BRS_($4139)_($4111) OK
//------------------------------
L_JMP_($4113)_($40F9) OK
//------------------------------
$4113  A2 6E     LDX #$6E	; TODO: print text PRESS A KEY @F480, len = 0B
$4115  A0 1A     LDY #$1A
$4117  A9 9F     LDA #$9F
$4119  85 7C     STA $7C 
$411B  A9 96     LDA #$96
$411D  85 7D     STA $7D 
$411F  20 6C 68  JSR L_JSR_($686C)_($411F) OK
//------------------------------
L_BRS_($4122)_($4125) OK
//------------------------------
$4122  20 00 6F  JSR L_JSR_($6F00)_($4122) OK
$4125  B0 FB     BCS L_BRS_($4122)_($4125) OK
//------------------------------
L_BRS_($4127)_($412A) OK
//------------------------------
$4127  20 00 6F  JSR L_JSR_($6F00)_($4127) OK
$412A  90 FB     BCC L_BRS_($4127)_($412A) OK
//------------------------------
L_BRS_($412C)_($412F) OK
//------------------------------
$412C  20 00 6F  JSR L_JSR_($6F00)_($412C) OK
$412F  B0 FB     BCS L_BRS_($412C)_($412F) OK
$4131  A9 07     LDA #$07
$4133  20 4B CB  JSR L_JSR_($CB4B)_($4133) OK	; TODO: start sound effect (7: Fail)
$4136  20 DF 44  JSR L_JSR_($44DF)_($4136) OK
//------------------------------
L_BRS_($4139)_($4111) OK
//------------------------------
$4139  A9 00     LDA #$00
$413B  8D 89 15  STA $1589 
$413E  AD 36 17  LDA $1736 
$4141  D0 0F     BNE L_BRS_($4152)_($4141) OK
$4143  AD 37 17  LDA $1737 
//------------------------------
L_JSR_($4146)_($197C) OK
//------------------------------
$4146  8D 36 17  STA $1736 
$4149  8D 00 09  STA $0900 
//------------------------------
L_JSR_($414D)_($1A04) BAD
L_JSR_($414D)_($1A5C) BAD
//------------------------------
$414C  4C 52 41  JMP L_JMP_($4152)_($414C) OK
//------------------------------
L_BRS_($414F)_($415D) OK
L_JMP_($414F)_($8430) OK
//------------------------------
$414F  20 88 1F  JSR L_JSR_($1F88)_($414F) OK
//------------------------------
L_BRS_($4152)_($4141) OK
L_JMP_($4152)_($414C) OK
L_JSR_($4153)_($843D) BAD
//------------------------------
$4152  20 6D 41  JSR L_JSR_($416D)_($4152) OK
//------------------------------
L_JSR_($4157)_($8976) BAD
//------------------------------
$4155  20 14 44  JSR L_JSR_($4414)_($4155) OK
$4158  AD 43 15  LDA $1543 
$415B  29 02     AND #$02
$415D  F0 F0     BEQ L_BRS_($414F)_($415D) OK
$415F  20 91 48  JSR L_JSR_($4891)_($415F) OK
$4162  4C FC 40  JMP L_JMP_($40FC)_($4162) OK
$4165  46 41     LSR $41 
$4167  45 45     EOR $45 
$4169            .byte $42,$42
$416B  45 45     EOR $45 
//------------------------------
L_JSR_($416D)_($4152) OK
//------------------------------
$416D  A9 00     LDA #$00
$416F  8D 43 15  STA $1543 
$4172  8D 44 15  STA $1544 
$4175  8D 70 15  STA $1570 
$4178  8D 72 15  STA $1572 
$417B  8D 73 15  STA $1573 
$417E  8D 49 15  STA $1549 
$4181  8D 47 15  STA $1547 
$4184  8D 74 15  STA $1574 
$4187  20 8B 7D  JSR L_JSR_($7D8B)_($4187) OK
$418A  AD 6D 1C  LDA $1C6D 
$418D  29 80     AND #$80
$418F  F0 09     BEQ L_BRS_($419A)_($418F) OK
$4191  A9 05     LDA #$05
$4193  8D 89 15  STA $1589 
$4196  08        PHP 
$4197  4C 3D 43  JMP L_JMP_($433D)_($4197) OK
//------------------------------
L_BRS_($419A)_($418F) OK
//------------------------------
$419A  AD 76 15  LDA $1576 
$419D  F0 0B     BEQ L_BRS_($41AA)_($419D) OK
$419F  AD 89 15  LDA $1589 
$41A2  D0 06     BNE L_BRS_($41AA)_($41A2) OK
$41A4  20 50 79  JSR L_JSR_($7950)_($41A4) OK
$41A7  4C 3C 43  JMP L_JMP_($433C)_($41A7) OK
//------------------------------
L_BRS_($41AA)_($419D) OK
L_BRS_($41AA)_($41A2) OK
//------------------------------
$41AA  AD 77 15  LDA $1577 
$41AD  C9 03     CMP #$03
$41AF  D0 03     BNE L_BRS_($41B4)_($41AF) OK
$41B1  4C 38 42  JMP L_JMP_($4238)_($41B1) OK
//------------------------------
L_BRS_($41B4)_($41AF) OK
L_BRS_($41B4)_($4203) OK
//------------------------------
$41B4  20 00 6F  JSR L_JSR_($6F00)_($41B4) OK
$41B7  08        PHP 
$41B8  B0 16     BCS L_BRS_($41D0)_($41B8) OK
$41BA  A9 00     LDA #$00
$41BC  8D 6C 15  STA $156C 
$41BF  CD 48 15  CMP $1548 
$41C2  F0 0C     BEQ L_BRS_($41D0)_($41C2) OK
$41C4  8D 48 15  STA $1548 
$41C7  A9 20     LDA #$20
$41C9  8D 44 15  STA $1544 
$41CC  28        PLP 
$41CD  4C 3C 43  JMP L_JMP_($433C)_($41CD) OK
//------------------------------
L_BRS_($41D0)_($41B8) OK
L_BRS_($41D0)_($41C2) OK
//------------------------------
$41D0  AD 89 15  LDA $1589 
$41D3  F0 03     BEQ L_BRS_($41D8)_($41D3) OK
$41D5  4C 3D 43  JMP L_JMP_($433D)_($41D5) OK
//------------------------------
L_BRS_($41D8)_($41D3) OK
//------------------------------
$41D8  AD 6D 15  LDA $156D 
$41DB  F0 0F     BEQ L_BRS_($41EC)_($41DB) OK
$41DD  A9 00     LDA #$00
$41DF  8D 6D 15  STA $156D 
$41E2  AD 90 1C  LDA $1C90 
$41E5  F0 05     BEQ L_BRS_($41EC)_($41E5) OK
$41E7  A9 04     LDA #$04
$41E9  8D 43 15  STA $1543 
//------------------------------
L_BRS_($41EC)_($41DB) OK
L_BRS_($41EC)_($41E5) OK
//------------------------------
$41EC  AD 8E 1C  LDA $1C8E 
$41EF  CD A1 1C  CMP $1CA1 
$41F2  F0 0E     BEQ L_BRS_($4202)_($41F2) OK
$41F4  8D A1 1C  STA $1CA1 
$41F7  A9 01     LDA #$01
$41F9  8D 74 15  STA $1574 
$41FC  28        PLP 
$41FD  B0 06     BCS L_BRS_($4205)_($41FD) OK
$41FF  4C 3C 43  JMP L_JMP_($433C)_($41FF) OK
//------------------------------
L_BRS_($4202)_($41F2) OK
//------------------------------
$4202  28        PLP 
$4203  90 AF     BCC L_BRS_($41B4)_($4203) OK
//------------------------------
L_BRS_($4205)_($41FD) OK
//------------------------------
$4205  AC DA 18  LDY $18DA 
//------------------------------
L_JMP_($4208)_($422F) OK
//------------------------------
$4208  AD E2 18  LDA $18E2 
$420B  8D 6C 41  STA $416C 
$420E  B9 DA 18  LDA $18DA,Y 
$4211  A2 00     LDX #$00
//------------------------------
L_BRS_($4213)_($421D) OK
//------------------------------
$4213  DD E3 18  CMP $18E3,X 
$4216  F0 0C     BEQ L_BRS_($4224)_($4216) OK
$4218  E8        INX 
$4219  E8        INX 
$421A  CE 6C 41  DEC $416C 
$421D  D0 F4     BNE L_BRS_($4213)_($421D) OK
//------------------------------
L_JSR_($4220)_($19D9) BAD
//------------------------------
$421F  A9 7F     LDA #$7F
$4221  4C 29 42  JMP L_JMP_($4229)_($4221) OK
//------------------------------
L_BRS_($4224)_($4216) OK
//------------------------------
$4224  E8        INX 
$4225  BD E3 18  LDA $18E3,X 
$4228  E8        INX 
//------------------------------
L_JMP_($4229)_($4221) OK
//------------------------------
$4229  99 65 41  STA $4165,Y 
$422C  88        DEY 
$422D  F0 03     BEQ L_BRS_($4232)_($422D) OK
$422F  4C 08 42  JMP L_JMP_($4208)_($422F) OK
//------------------------------
L_BRS_($4232)_($422D) OK
//------------------------------
$4232  8C 6C 41  STY $416C 
$4235  4C 8A 42  JMP L_JMP_($428A)_($4235) OK
//------------------------------
L_JMP_($4238)_($41B1) OK
//------------------------------
$4238  20 00 6F  JSR L_JSR_($6F00)_($4238) OK
$423B  90 08     BCC L_BRS_($4245)_($423B) OK
$423D  A9 01     LDA #$01
$423F  8D 77 15  STA $1577 
$4242  4C F5 43  JMP L_JMP_($43F5)_($4242) OK
//------------------------------
L_BRS_($4245)_($423B) OK
//------------------------------
$4245  A9 01     LDA #$01
$4247  8D DA 18  STA $18DA 
$424A  AD 83 15  LDA $1583 
$424D  85 7A     STA $7A 
$424F  AD 84 15  LDA $1584 
$4252  85 7B     STA $7B 
$4254  A0 00     LDY #$00
$4256  AD 85 15  LDA $1585 
$4259  F0 12     BEQ L_BRS_($426D)_($4259) OK
$425B  B1 7A     LDA ($7A),Y 
$425D  CE 85 15  DEC $1585 
$4260  D0 28     BNE L_BRS_($428A)_($4260) OK
$4262  EE 83 15  INC $1583 
$4265  D0 23     BNE L_BRS_($428A)_($4265) OK
$4267  EE 84 15  INC $1584 
$426A  4C 8A 42  JMP L_JMP_($428A)_($426A) OK
//------------------------------
L_BRS_($426D)_($4259) OK
//------------------------------
$426D  B1 7A     LDA ($7A),Y 
$426F  D0 03     BNE L_BRS_($4274)_($426F) OK
$4271  4C 04 44  JMP L_JMP_($4404)_($4271) OK
//------------------------------
L_BRS_($4274)_($426F) OK
//------------------------------
$4274  EE 83 15  INC $1583 
$4277  D0 03     BNE L_BRS_($427C)_($4277) OK
$4279  EE 84 15  INC $1584 
//------------------------------
L_BRS_($427C)_($4277) OK
//------------------------------
$427C  B1 7A     LDA ($7A),Y 
$427E  10 0A     BPL L_BRS_($428A)_($427E) OK
$4280  29 7F     AND #$7F
$4282  AA        TAX 
$4283  CA        DEX 
$4284  8E 85 15  STX $1585 
$4287  C8        INY 
$4288  B1 7A     LDA ($7A),Y 
//------------------------------
L_JMP_($428A)_($4235) OK
L_BRS_($428A)_($4260) OK
L_BRS_($428A)_($4265) OK
L_JMP_($428A)_($426A) OK
L_BRS_($428A)_($427E) OK
//------------------------------
$428A  C9 1F     CMP #$1F
$428C  D0 38     BNE L_BRS_($42C6)_($428C) OK
$428E  AD DA 18  LDA $18DA 
$4291  C9 01     CMP #$01
$4293  D0 31     BNE L_BRS_($42C6)_($4293) OK
$4295  A2 B4     LDX #$B4
$4297  A0 19     LDY #$19	; text RESTING...
$4299  AD 90 1C  LDA $1C90 
$429C  08        PHP 
$429D  A9 01     LDA #$01
$429F  28        PLP 
$42A0  F0 10     BEQ L_BRS_($42B2)_($42A0) OK
$42A2  A2 A4     LDX #$A4
$42A4  A0 19     LDY #$19	; TOO HOT TO REST!
$42A6  A9 32     LDA #$32
$42A8  8D 4E 15  STA $154E 
$42AB  A9 20     LDA #$20
$42AD  8D 44 15  STA $1544 
$42B0  A9 00     LDA #$00
//------------------------------
L_BRS_($42B2)_($42A0) OK
//------------------------------
$42B2  8D 6C 15  STA $156C 
$42B5  8D 48 15  STA $1548 
$42B8  A9 78     LDA #$78
$42BA  85 7C     STA $7C 
$42BC  A9 96     LDA #$96
$42BE  85 7D     STA $7D 
$42C0  20 6C 68  JSR L_JSR_($686C)_($42C0) OK	; print text @F5A1, len = $10
$42C3  4C 3C 43  JMP L_JMP_($433C)_($42C3) OK
//------------------------------
L_BRS_($42C6)_($428C) OK
L_BRS_($42C6)_($4293) OK
//------------------------------
$42C6  AA        TAX 
$42C7  A9 00     LDA #$00
$42C9  8D 6C 15  STA $156C 
$42CC  CD 48 15  CMP $1548 
$42CF  F0 08     BEQ L_BRS_($42D9)_($42CF) OK
$42D1  8D 48 15  STA $1548 
$42D4  A9 20     LDA #$20
$42D6  8D 44 15  STA $1544 
//------------------------------
L_BRS_($42D9)_($42CF) OK
//------------------------------
$42D9  8A        TXA 
//------------------------------
L_JMP_($42DA)_($4339) OK
//------------------------------
$42DA  C9 01     CMP #$01
$42DC  90 4C     BCC L_BRS_($432A)_($42DC) OK
$42DE  C9 15     CMP #$15
$42E0  B0 1F     BCS L_BRS_($4301)_($42E0) OK
$42E2  C9 03     CMP #$03
$42E4  90 15     BCC L_BRS_($42FB)_($42E4) OK
$42E6  C9 07     CMP #$07
$42E8  B0 11     BCS L_BRS_($42FB)_($42E8) OK
$42EA  AE 91 1C  LDX $1C91 
$42ED  F0 0C     BEQ L_BRS_($42FB)_($42ED) OK
$42EF  8D 65 41  STA $4165 
$42F2  A9 1D     LDA #$1D
$42F4  38        SEC 
$42F5  ED 65 41  SBC $4165 
$42F8  4C 01 43  JMP L_JMP_($4301)_($42F8) OK
//------------------------------
L_BRS_($42FB)_($42E4) OK
L_BRS_($42FB)_($42E8) OK
L_BRS_($42FB)_($42ED) OK
//------------------------------
$42FB  20 42 58  JSR L_JSR_($5842)_($42FB) BAD
$42FE  4C 2A 43  JMP L_JMP_($432A)_($42FE) OK
//------------------------------
L_BRS_($4301)_($42E0) OK
L_JMP_($4301)_($42F8) OK
//------------------------------
$4301  C9 1F     CMP #$1F
$4303  B0 1B     BCS L_BRS_($4320)_($4303) OK
$4305  C9 16     CMP #$16
$4307  D0 11     BNE L_BRS_($431A)_($4307) OK
$4309  AC 91 1C  LDY $1C91 
$430C  D0 0C     BNE L_BRS_($431A)_($430C) OK
$430E  A9 1E     LDA #$1E
$4310  20 5E 5E  JSR L_JSR_($5E5E)_($4310) OK
$4313  A9 16     LDA #$16
$4315  20 5E 5E  JSR L_JSR_($5E5E)_($4315) OK
$4318  A9 1E     LDA #$1E
//------------------------------
L_BRS_($431A)_($4307) OK
L_BRS_($431A)_($430C) OK
//------------------------------
$431A  20 5E 5E  JSR L_JSR_($5E5E)_($431A) OK
$431D  4C 2A 43  JMP L_JMP_($432A)_($431D) OK
//------------------------------
L_JSR_($4320)_($1962) OK
L_BRS_($4320)_($4303) OK
//------------------------------
$4320  C9 29     CMP #$29
$4322  D0 06     BNE L_BRS_($432A)_($4322) OK
$4324  20 C7 71  JSR L_JSR_($71C7)_($4324) BAD
$4327  4C 2A 43  JMP L_JMP_($432A)_($4327) OK
//------------------------------
L_BRS_($432A)_($42DC) OK
L_JMP_($432A)_($42FE) OK
L_JMP_($432A)_($431D) OK
L_BRS_($432A)_($4322) OK
L_JMP_($432A)_($4327) OK
//------------------------------
$432A  CE DA 18  DEC $18DA 
$432D  F0 0D     BEQ L_BRS_($433C)_($432D) OK
$432F  AC 6C 41  LDY $416C 
$4332  C8        INY 
$4333  B9 66 41  LDA $4166,Y 
$4336  8C 6C 41  STY $416C 
$4339  4C DA 42  JMP L_JMP_($42DA)_($4339) OK
//------------------------------
L_JMP_($433C)_($41A7) OK
L_JMP_($433C)_($41CD) OK
L_JMP_($433C)_($41FF) OK
L_JMP_($433C)_($42C3) OK
L_BRS_($433C)_($432D) OK
//------------------------------
$433C  60        RTS 
//------------------------------
L_JMP_($433D)_($4197) OK
L_JMP_($433D)_($41D5) OK
//------------------------------
$433D  28        PLP 
$433E  AD 51 15  LDA $1551 
$4341  09 04     ORA #$04
//------------------------------
L_JSR_($4345)_($1959) BAD
L_JSR_($4345)_($89B8) BAD
//------------------------------
$4343  8D 51 15  STA $1551 
//------------------------------
L_BRS_($4346)_($434B) OK
//------------------------------
$4346  AD 51 15  LDA $1551 
$4349  29 01     AND #$01
$434B  D0 F9     BNE L_BRS_($4346)_($434B) OK
//------------------------------
L_JMP_($434F)_($19DC) BAD
//------------------------------
$434D  AD 89 15  LDA $1589 
$4350  A2 44     LDX #$44	; HEART FAILURE
$4352  A0 19     LDY #$19
$4354  C9 01     CMP #$01
$4356  F0 24     BEQ L_BRS_($437C)_($4356) OK
$4358  A2 54     LDX #$54	; SUN ECLIPSED
$435A  A0 19     LDY #$19
$435C  C9 02     CMP #$02
$435E  F0 1C     BEQ L_BRS_($437C)_($435E) OK
$4360  A2 74     LDX #$74	;  FATAL FALL
$4362  A0 19     LDY #$19
$4364  C9 04     CMP #$04
$4366  F0 14     BEQ L_BRS_($437C)_($4366) OK
$4368  A2 84     LDX #$84	; CURSES OVERCOME
$436A  A0 19     LDY #$19
$436C  C9 05     CMP #$05
$436E  F0 0C     BEQ L_BRS_($437C)_($436E) OK
$4370  A2 94     LDX #$94
$4372  A0 19     LDY #$19	; TOTAL ECLIPSE
$4374  C9 06     CMP #$06
$4376  F0 04     BEQ L_BRS_($437C)_($4376) OK
$4378  A2 64     LDX #$64	; SUN ECLIPSED
$437A  A0 19     LDY #$19
//------------------------------
L_BRS_($437C)_($4356) OK
L_BRS_($437C)_($435E) OK
L_BRS_($437C)_($4366) OK
L_BRS_($437C)_($436E) OK
L_BRS_($437C)_($4376) OK
//------------------------------
$437C  A9 78     LDA #$78
$437E  85 7C     STA $7C 
$4380  A9 96     LDA #$96
$4382  85 7D     STA $7D 
$4384  20 6C 68  JSR L_JSR_($686C)_($4384) OK
$4387  20 12 CD  JSR L_JSR_($CD12)_($4387) OK	; TODO: sfx?
$438A  A9 1E     LDA #$1E
$438C  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($438F)_($4392) OK
//------------------------------
$438F  AD 4E 15  LDA $154E 
$4392  D0 FB     BNE L_BRS_($438F)_($4392) OK
$4394  A9 00     LDA #$00
$4396  8D 36 17  STA $1736 
$4399  8D 00 09  STA $0900 
$439C  20 21 10  JSR L_JSR_($1021)_($439C) OK
$439F  A9 08     LDA #$08
$43A1  20 4B CB  JSR L_JSR_($CB4B)_($43A1) OK	; TODO: start sound effect (8: Bonus #1)
$43A4  AD 06 96  LDA $9606 
$43A7  8D 47 1C  STA $1C47 
$43AA  AD 07 96  LDA $9607 
$43AD  8D 50 15  STA $1550 
$43B0  A9 FC     LDA #$FC
$43B2  2D 15 D0  AND $D015                          // Sprite display Enable
$43B5  8D 15 D0  STA $D015                          ; disable sprites 0,1 // Sprite display Enable
$43B8  A9 00     LDA #$00
$43BA  8D A0 1C  STA $1CA0 
$43BD  8D 91 1C  STA $1C91 
$43C0  A9 01     LDA #$01
$43C2  8D 46 1C  STA $1C46 
$43C5  20 A2 49  JSR L_JSR_($49A2)_($43C5) OK
$43C8  A9 04     LDA #$04
$43CA  8D 43 15  STA $1543 
$43CD  A9 00     LDA #$00
$43CF  8D 44 15  STA $1544 
$43D2  20 88 1F  JSR L_JSR_($1F88)_($43D2) OK
$43D5  20 E8 7B  JSR L_JSR_($7BE8)_($43D5) OK
$43D8  A2 04     LDX #$04
//------------------------------
L_BRS_($43DA)_($43EE) OK
//------------------------------
$43DA  A9 32     LDA #$32
$43DC  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($43DF)_($43EB) OK
//------------------------------
$43DF  86 82     STX $82 
$43E1  20 00 6F  JSR L_JSR_($6F00)_($43E1) OK
$43E4  B0 0F     BCS L_BRS_($43F5)_($43E4) OK
$43E6  A6 82     LDX $82 
$43E8  AD 4E 15  LDA $154E 
$43EB  D0 F2     BNE L_BRS_($43DF)_($43EB) OK
$43ED  CA        DEX 
$43EE  D0 EA     BNE L_BRS_($43DA)_($43EE) OK
$43F0  A9 03     LDA #$03
$43F2  8D 77 15  STA $1577 
//------------------------------
L_JMP_($43F5)_($4242) OK
L_BRS_($43F5)_($43E4) OK
//------------------------------
$43F5  A9 03     LDA #$03
$43F7  20 4B CB  JSR L_JSR_($CB4B)_($43F7) OK	; TODO: start sound effect (3: Fire)
$43FA  A9 1E     LDA #$1E
$43FC  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($43FF)_($4402) OK
//------------------------------
$43FF  AD 4E 15  LDA $154E 
$4402  D0 FB     BNE L_BRS_($43FF)_($4402) OK
//------------------------------
L_JMP_($4404)_($4271) OK
//------------------------------
$4404  A9 02     LDA #$02
$4406  8D 43 15  STA $1543 
$4409  A9 00     LDA #$00
$440B  8D 44 15  STA $1544 
$440E  60        RTS 
//------------------------------
$440F  58        CLI 
$4410  20 02 1C  JSR L_JSR_($1C02)_($4410) JAM
$4413            .byte $03
//------------------------------
L_JSR_($4414)_($4155) OK
//------------------------------
$4414  AD 73 15  LDA $1573 
$4417  D0 06     BNE L_BRS_($441F)_($4417) OK
$4419  AD 74 15  LDA $1574 
$441C  D0 01     BNE L_BRS_($441F)_($441C) OK
$441E  60        RTS 
//------------------------------
L_BRS_($441F)_($4417) OK
L_BRS_($441F)_($441C) OK
//------------------------------
$441F  AD 70 15  LDA $1570 
$4422  F0 4E     BEQ L_BRS_($4472)_($4422) OK
$4424  8D 46 15  STA $1546 
$4427  A9 00     LDA #$00
$4429  20 C1 5C  JSR L_JSR_($5CC1)_($4429) BAD
$442C  D0 44     BNE L_BRS_($4472)_($442C) OK
$442E  A0 00     LDY #$00
//------------------------------
L_JSR_($4431)_($B145) BAD
//------------------------------
$4430  B1 7C     LDA ($7C),Y 
$4432  29 0F     AND #$0F
$4434  18        CLC 
$4435  69 35     ADC #$35
$4437  85 7E     STA $7E 
$4439  A9 19     LDA #$19
$443B  69 00     ADC #$00
$443D  85 7F     STA $7F 
$443F  A0 08     LDY #$08
$4441  B1 7C     LDA ($7C),Y 
$4443  38        SEC 
$4444  A0 00     LDY #$00
$4446  F1 7E     SBC ($7E),Y 
//------------------------------
L_JMP_($4449)_($8418) BAD
//------------------------------
$4448  F0 15     BEQ L_BRS_($445F)_($4448) OK
$444A  48        PHA 
$444B  A5 7C     LDA $7C 
$444D  18        CLC 
$444E  71 7E     ADC ($7E),Y 
//------------------------------
L_JSR_($4450)_($98D8) OK
//------------------------------
$4450  85 7C     STA $7C 
$4452  A5 7D     LDA $7D 
$4454  69 00     ADC #$00
$4456  85 7D     STA $7D 
$4458  68        PLA 
$4459  20 DB 62  JSR L_JSR_($62DB)_($4459) OK
$445C  4C 72 44  JMP L_JMP_($4472)_($445C) OK
//------------------------------
L_BRS_($445F)_($4448) OK
//------------------------------
$445F  AE 47 15  LDX $1547 
$4462  F0 0E     BEQ L_BRS_($4472)_($4462) OK
$4464  A9 12     LDA #$12
$4466  85 7C     STA $7C 
$4468  A9 44     LDA #$44
$446A  85 7D     STA $7D 
$446C  AD 11 44  LDA $4411 
$446F  20 DB 62  JSR L_JSR_($62DB)_($446F) OK
//------------------------------
L_BRS_($4472)_($4422) OK
L_BRS_($4472)_($442C) OK
L_JMP_($4472)_($445C) OK
L_BRS_($4472)_($4462) OK
//------------------------------
$4472  AD 86 15  LDA $1586 
$4475  85 7C     STA $7C 
$4477  AD 87 15  LDA $1587 
$447A  85 7D     STA $7D 
$447C  A0 00     LDY #$00
$447E  B1 7C     LDA ($7C),Y 
$4480  F0 26     BEQ L_BRS_($44A8)_($4480) OK
$4482  E6 7C     INC $7C 
$4484  D0 02     BNE L_BRS_($4488)_($4484) OK
$4486  E6 7D     INC $7D 
//------------------------------
L_BRS_($4488)_($4484) OK
//------------------------------
$4488  8D 0F 44  STA $440F 
//------------------------------
L_BRS_($448B)_($44A6) OK
//------------------------------
$448B  B1 7C     LDA ($7C),Y 
$448D  E6 7C     INC $7C 
$448F  D0 02     BNE L_BRS_($4493)_($448F) OK
$4491  E6 7D     INC $7D 
//------------------------------
L_BRS_($4493)_($448F) OK
//------------------------------
$4493  48        PHA 
$4494  20 DB 62  JSR L_JSR_($62DB)_($4494) OK
$4497  68        PLA 
$4498  18        CLC 
$4499  65 7C     ADC $7C 
$449B  85 7C     STA $7C 
$449D  90 02     BCC L_BRS_($44A1)_($449D) OK
$449F  E6 7D     INC $7D 
//------------------------------
L_BRS_($44A1)_($449D) OK
//------------------------------
$44A1  A0 00     LDY #$00
$44A3  CE 0F 44  DEC $440F 
$44A6  D0 E3     BNE L_BRS_($448B)_($44A6) OK
//------------------------------
L_BRS_($44A8)_($4480) OK
//------------------------------
$44A8  AD 5E 1C  LDA $1C5E 
$44AB  85 7C     STA $7C 
$44AD  AD 5F 1C  LDA $1C5F 
$44B0  85 7D     STA $7D 
$44B2  A0 00     LDY #$00
$44B4  B1 7C     LDA ($7C),Y 
$44B6  F0 26     BEQ L_BRS_($44DE)_($44B6) OK
$44B8  E6 7C     INC $7C 
$44BA  D0 02     BNE L_BRS_($44BE)_($44BA) OK
$44BC  E6 7D     INC $7D 
//------------------------------
L_BRS_($44BE)_($44BA) OK
//------------------------------
$44BE  8D 0F 44  STA $440F 
//------------------------------
L_BRS_($44C1)_($44DC) OK
//------------------------------
$44C1  B1 7C     LDA ($7C),Y 
$44C3  E6 7C     INC $7C 
$44C5  D0 02     BNE L_BRS_($44C9)_($44C5) OK
$44C7  E6 7D     INC $7D 
//------------------------------
L_BRS_($44C9)_($44C5) OK
//------------------------------
$44C9  48        PHA 
$44CA  20 DB 62  JSR L_JSR_($62DB)_($44CA) OK
$44CD  68        PLA 
$44CE  18        CLC 
$44CF  65 7C     ADC $7C 
$44D1  85 7C     STA $7C 
$44D3  90 02     BCC L_BRS_($44D7)_($44D3) OK
$44D5  E6 7D     INC $7D 
//------------------------------
L_BRS_($44D7)_($44D3) OK
//------------------------------
$44D7  A0 00     LDY #$00
$44D9  CE 0F 44  DEC $440F 
$44DC  D0 E3     BNE L_BRS_($44C1)_($44DC) OK
//------------------------------
L_BRS_($44DE)_($44B6) OK
//------------------------------
$44DE  60        RTS 
//------------------------------
L_JSR_($44DF)_($2FAB) OK
L_JSR_($44DF)_($4136) OK
L_JSR_($44DF)_($5FF8) OK
L_JSR_($44DF)_($72C6) OK
L_JSR_($44DF)_($76CA) OK
//------------------------------
$44DF  AD 49 15  LDA $1549 
$44E2  F0 03     BEQ L_BRS_($44E7)_($44E2) OK
$44E4  20 4B CB  JSR L_JSR_($CB4B)_($44E4) OK	; TODO: start sound effect
//------------------------------
L_BRS_($44E7)_($44E2) OK
//------------------------------
$44E7  A9 68     LDA #$68
$44E9  4A        LSR A 
$44EA  4A        LSR A 
$44EB  4A        LSR A 
$44EC  85 B1     STA $B1 
$44EE  A9 00     LDA #$00
$44F0  85 82     STA $82 
$44F2  A9 68     LDA #$68
$44F4  38        SEC 
$44F5  E9 08     SBC #$08
$44F7  4A        LSR A 
$44F8  66 82     ROR $82 
$44FA  4A        LSR A 
$44FB  66 82     ROR $82 
$44FD  4A        LSR A 
$44FE  85 83     STA $83 
$4500  AD 8E 15  LDA $158E 
$4503  18        CLC 
$4504  65 82     ADC $82 
$4506  8D 25 45  STA $4525 
$4509  AD 8F 15  LDA $158F 
$450C  65 83     ADC $83 
//------------------------------
L_BRS_($450E)_($455F) OK
//------------------------------
$450E  8D 26 45  STA $4526 
$4511  AD 33 17  LDA $1733 
$4514  8D 28 45  STA $4528 
$4517  AD 34 17  LDA $1734 
$451A  8D 29 45  STA $4529 
//------------------------------
L_BRS_($451D)_($455B) OK
//------------------------------
$451D  A0 00     LDY #$00
//------------------------------
L_JSR_($4520)_($199A) BAD
//------------------------------
$451F  A2 00     LDX #$00
$4521  CA        DEX 
$4522  18        CLC 
$4523  78        SEI 
//------------------------------
L_BRS_($4524)_($452F) OK
L_BRS_($4524)_($4534) OK
//------------------------------
$4524  BD FF FF  LDA $FFFF,X 	; TODO: copy backbuffer to screen
$4527  99 FF FF  STA $FFFF,Y 
$452A  CA        DEX 
$452B  98        TYA 
$452C  69 08     ADC #$08
$452E  A8        TAY 
$452F  90 F3     BCC L_BRS_($4524)_($452F) OK
$4531  C8        INY 
$4532  C0 08     CPY #$08
$4534  90 EE     BCC L_BRS_($4524)_($4534) OK
$4536  58        CLI 
$4537  AD 28 45  LDA $4528 
$453A  18        CLC 
$453B  69 40     ADC #$40
$453D  8D 28 45  STA $4528 
$4540  90 03     BCC L_BRS_($4545)_($4540) OK
//------------------------------
L_JSR_($4544)_($196E) BAD
//------------------------------
$4542  EE 29 45  INC $4529 
//------------------------------
L_BRS_($4545)_($4540) OK
//------------------------------
$4545  EE 29 45  INC $4529 
//------------------------------
L_JSR_($4548)_($1944) OK
//------------------------------
$4548  AD 25 45  LDA $4525 
$454B  38        SEC 
//------------------------------
L_JMP_($454C)_($1A1F) OK
//------------------------------
$454C  E9 00     SBC #$00
$454E  8D 25 45  STA $4525 
//------------------------------
L_JSR_($4552)_($19AE) BAD
L_JSR_($4552)_($19EB) BAD
//------------------------------
$4551  B0 03     BCS L_BRS_($4556)_($4551) OK
$4553  CE 26 45  DEC $4526 
//------------------------------
L_BRS_($4556)_($4551) OK
//------------------------------
$4556  CE 26 45  DEC $4526 
$4559  C6 B1     DEC $B1 
$455B  D0 C0     BNE L_BRS_($451D)_($455B) OK
$455D  60        RTS 
//------------------------------
$455E            .byte $33
$455F  30 AD     BMI L_BRS_($450E)_($455F) OK
$4561  90 1C     BCC L_BRS_($457F)_($4561) OK
$4563  D0 01     BNE L_BRS_($4566)_($4563) OK
$4565  60        RTS 
//------------------------------
L_BRS_($4566)_($4563) OK
//------------------------------
$4566  29 0F     AND #$0F
$4568  8D 5F 45  STA $455F 
$456B  AD 90 1C  LDA $1C90 
$456E  4A        LSR A 
$456F  4A        LSR A 
$4570  4A        LSR A 
$4571  4A        LSR A 
$4572  8D 5E 45  STA $455E 
$4575  F0 5E     BEQ L_BRS_($45D5)_($4575) OK
$4577  AD 5F 45  LDA $455F 
$457A  F0 60     BEQ L_BRS_($45DC)_($457A) OK
$457C  AD 38 1C  LDA $1C38 
//------------------------------
L_BRS_($457F)_($4561) OK
//------------------------------
$457F  C9 08     CMP #$08
$4581  30 21     BMI L_BRS_($45A4)_($4581) OK
$4583  C9 1D     CMP #$1D
$4585  30 55     BMI L_BRS_($45DC)_($4585) OK
$4587  C9 41     CMP #$41
$4589  10 16     BPL L_BRS_($45A1)_($4589) OK
$458B  C9 2C     CMP #$2C
$458D  10 46     BPL L_BRS_($45D5)_($458D) OK
$458F  AC 5E 45  LDY $455E 
$4592  AE 5F 45  LDX $455F 
$4595  8C 5F 45  STY $455F 
$4598  8E 5E 45  STX $455E 
$459B  38        SEC 
$459C  E9 24     SBC #$24
$459E  4C A4 45  JMP L_JMP_($45A4)_($459E) OK
//------------------------------
L_BRS_($45A1)_($4589) OK
//------------------------------
$45A1  38        SEC 
$45A2  E9 48     SBC #$48
//------------------------------
L_BRS_($45A4)_($4581) OK
L_JMP_($45A4)_($459E) OK
//------------------------------
$45A4  AA        TAX 
$45A5  A0 0D     LDY #$0D
$45A7  20 76 1E  JSR L_JSR_($1E76)_($45A7) OK
$45AA  A9 3A     LDA #$3A
$45AC  18        CLC 
$45AD  65 82     ADC $82 
$45AF  85 82     STA $82 
$45B1  AA        TAX 
$45B2  A9 00     LDA #$00
$45B4  65 83     ADC $83 
$45B6  10 05     BPL L_BRS_($45BD)_($45B6) OK
$45B8  A2 00     LDX #$00
$45BA  4C CA 45  JMP L_JMP_($45CA)_($45BA) OK
//------------------------------
L_BRS_($45BD)_($45B6) OK
//------------------------------
$45BD  A5 82     LDA $82 
$45BF  38        SEC 
$45C0  E9 68     SBC #$68
$45C2  A5 83     LDA $83 
$45C4  E9 00     SBC #$00
$45C6  30 02     BMI L_BRS_($45CA)_($45C6) OK
$45C8  A2 68     LDX #$68
//------------------------------
L_JMP_($45CA)_($45BA) OK
L_BRS_($45CA)_($45C6) OK
//------------------------------
$45CA  8A        TXA 
$45CB  38        SEC 
$45CC  E9 68     SBC #$68
$45CE  49 FF     EOR #$FF
$45D0  A8        TAY 
$45D1  C8        INY 
$45D2  4C E0 45  JMP L_JMP_($45E0)_($45D2) OK
//------------------------------
L_BRS_($45D5)_($4575) OK
L_BRS_($45D5)_($458D) OK
//------------------------------
$45D5  A0 68     LDY #$68
$45D7  A2 00     LDX #$00
$45D9  4C E0 45  JMP L_JMP_($45E0)_($45D9) OK
//------------------------------
L_BRS_($45DC)_($457A) OK
L_BRS_($45DC)_($4585) OK
//------------------------------
$45DC  A0 00     LDY #$00
$45DE  A2 68     LDX #$68
//------------------------------
L_JMP_($45E0)_($45D2) OK
L_JMP_($45E0)_($45D9) OK
//------------------------------
$45E0  AD 8E 15  LDA $158E 
$45E3  85 7A     STA $7A 
$45E5  AD 8F 15  LDA $158F 
$45E8  85 7B     STA $7B 
$45EA  E0 00     CPX #$00
$45EC  F0 0C     BEQ L_BRS_($45FA)_($45EC) OK
$45EE  98        TYA 
$45EF  48        PHA 
$45F0  8A        TXA 
$45F1  A8        TAY 
$45F2  AD 5E 45  LDA $455E 
$45F5  20 08 46  JSR L_JSR_($4608)_($45F5) OK
$45F8  68        PLA 
$45F9  A8        TAY 
//------------------------------
L_BRS_($45FA)_($45EC) OK
//------------------------------
$45FA  C0 00     CPY #$00
$45FC  F0 09     BEQ L_BRS_($4607)_($45FC) OK
$45FE  AD 5F 45  LDA $455F 
$4601  20 08 46  JSR L_JSR_($4608)_($4601) OK
$4604  20 90 46  JSR L_JSR_($4690)_($4604) OK
//------------------------------
L_BRS_($4607)_($45FC) OK
//------------------------------
$4607  60        RTS 
//------------------------------
L_JSR_($4608)_($45F5) OK
L_JSR_($4608)_($4601) OK
//------------------------------
$4608  38        SEC 			; TODO: Draw rectangle (horizon?)
$4609  E9 01     SBC #$01
$460B  0A        ASL A 
$460C  0A        ASL A 
$460D  AA        TAX 
$460E  98        TYA 
$460F  48        PHA 
$4610  A0 04     LDY #$04
//------------------------------
L_BRS_($4612)_($461A) OK
//------------------------------
$4612  BD 0A 96  LDA $960A,X 
$4615  99 B0 00  STA $00B0,Y 
$4618  E8        INX 
$4619  88        DEY 
$461A  D0 F6     BNE L_BRS_($4612)_($461A) OK
$461C  68        PLA 
$461D  AA        TAX 
//------------------------------
L_BRS_($461E)_($463A) OK
//------------------------------
$461E  8A        TXA 
//------------------------------
L_JSR_($4620)_($194A) BAD
//------------------------------
$461F  29 03     AND #$03
$4621  A8        TAY 
$4622  B9 B1 00  LDA $00B1,Y 
$4625  A0 00     LDY #$00
//------------------------------
L_BRS_($4627)_($462C) OK
//------------------------------
$4627  91 7A     STA ($7A),Y 
$4629  C8        INY 
$462A  C0 20     CPY #$20
$462C  D0 F9     BNE L_BRS_($4627)_($462C) OK
$462E  A5 7A     LDA $7A 
$4630  18        CLC 
$4631  69 20     ADC #$20
$4633  85 7A     STA $7A 
$4635  90 02     BCC L_BRS_($4639)_($4635) OK
$4637  E6 7B     INC $7B 
//------------------------------
L_BRS_($4639)_($4635) OK
//------------------------------
$4639  CA        DEX 
$463A  D0 E2     BNE L_BRS_($461E)_($463A) OK
$463C  60        RTS 
//------------------------------
$463D            .byte $02,$03,$04
$4640  05 05     ORA $05
$4642  06 06     ASL $06 
$4644            .byte $07,$07,$07,$07,$07
$4649  08        PHP 
$464A  08        PHP 
$464B  08        PHP 
$464C  08        PHP 
$464D  08        PHP 
$464E  08        PHP 
$464F  08        PHP 
$4650  08        PHP 
$4651  08        PHP 
$4652            .byte $07,$07,$07,$07,$07
$4657  06 06     ASL $06 
$4659  05 05     ORA $05
$465B            .byte $04,$03,$02,$02,$03,$04,$04
$4662  05 05     ORA $05
$4664  05 06     ORA $06
$4666  06 06     ASL $06 
$4668            .byte $07,$07,$07,$07,$07,$07,$07,$07
$4670            .byte $07
$4671  06 06     ASL $06 
$4673  06 05     ASL $05 
$4675  05 05     ORA $05
$4677            .byte $04,$04,$03,$02,$00,$00,$00,$00
$467F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4687            .byte $00,$00,$00,$00,$00,$0B,$0C,$0F
$468F            .byte $03
//------------------------------
L_JSR_($4690)_($4604) OK
//------------------------------
$4690  A9 0D     LDA #$0D
$4692  8D 7C 48  STA $487C 
$4695  A9 34     LDA #$34
$4697  8D 88 46  STA $4688 
$469A  A9 48     LDA #$48
$469C  38        SEC 
$469D  ED 38 1C  SBC $1C38 
$46A0  8D 87 46  STA $4687 
$46A3  AD 3A 1C  LDA $1C3A 
$46A6  20 51 48  JSR L_JSR_($4851)_($46A6) OK
$46A9  A5 82     LDA $82 
$46AB  8D 7D 46  STA $467D 
$46AE  A5 83     LDA $83 
$46B0  8D 7E 46  STA $467E 
$46B3  A9 0D     LDA #$0D
$46B5  4A        LSR A 
$46B6  8D 7C 48  STA $487C 
$46B9  AD 39 1C  LDA $1C39 
$46BC  8D 87 46  STA $4687 
$46BF  A9 40     LDA #$40
$46C1  8D 88 46  STA $4688 
$46C4  AD 3B 1C  LDA $1C3B 
$46C7  20 51 48  JSR L_JSR_($4851)_($46C7) OK
$46CA  A5 82     LDA $82 
$46CC  8D 7B 46  STA $467B 
$46CF  A5 83     LDA $83 
$46D1  8D 7C 46  STA $467C 
$46D4  A9 A1     LDA #$A1
$46D6  8D 7F 46  STA $467F 
$46D9  A9 00     LDA #$00
$46DB  8D 80 46  STA $4680 
$46DE  A9 89     LDA #$89
$46E0  8D 81 46  STA $4681 
$46E3  A9 00     LDA #$00
$46E5  8D 82 46  STA $4682 
$46E8  A9 10     LDA #$10
$46EA  8D 83 46  STA $4683 
$46ED  0A        ASL A 
$46EE  8D 85 46  STA $4685 
$46F1  A9 3D     LDA #$3D
$46F3  85 7A     STA $7A 
$46F5  A9 46     LDA #$46
$46F7  85 7B     STA $7B 
$46F9  A9 02     LDA #$02
$46FB  8D 2F 17  STA $172F 
$46FE  20 75 47  JSR L_JSR_($4775)_($46FE) OK
$4701  AD 3C 1C  LDA $1C3C 
$4704  30 15     BMI L_BRS_($471B)_($4704) OK
$4706  18        CLC 
$4707  6D 7B 46  ADC $467B 
$470A  8D 7B 46  STA $467B 
$470D  A9 00     LDA #$00
$470F  6D 7C 46  ADC $467C 
$4712  8D 7C 46  STA $467C 
$4715  AD 3C 1C  LDA $1C3C 
$4718  4C 30 47  JMP L_JMP_($4730)_($4718) OK
//------------------------------
L_BRS_($471B)_($4704) OK
//------------------------------
$471B  18        CLC 
$471C  6D 7B 46  ADC $467B 
//------------------------------
L_JSR_($4720)_($1A62) BAD
//------------------------------
$471F  8D 7B 46  STA $467B 
$4722  A9 FF     LDA #$FF
$4724  6D 7C 46  ADC $467C 
$4727  8D 7C 46  STA $467C 
$472A  A9 00     LDA #$00
$472C  38        SEC 
$472D  ED 3C 1C  SBC $1C3C 
//------------------------------
L_JMP_($4730)_($4718) OK
//------------------------------
$4730  C9 09     CMP #$09
$4732  10 10     BPL L_BRS_($4744)_($4732) OK
$4734  A8        TAY 
$4735  C8        INY 
$4736  98        TYA 
$4737  4A        LSR A 
$4738  A8        TAY 
$4739  B9 8B 46  LDA $468B,Y 
$473C  8D 66 1C  STA $1C66 
$473F  A9 01     LDA #$01
$4741  8D 4F 15  STA $154F 
//------------------------------
L_BRS_($4744)_($4732) OK
//------------------------------
$4744  A9 9D     LDA #$9D
$4746  8D 7F 46  STA $467F 
$4749  A9 00     LDA #$00
$474B  8D 80 46  STA $4680 
$474E  A9 85     LDA #$85
$4750  8D 81 46  STA $4681 
$4753  A9 00     LDA #$00
$4755  8D 82 46  STA $4682 
$4758  A9 0E     LDA #$0E
$475A  8D 83 46  STA $4683 
$475D  0A        ASL A 
$475E  8D 85 46  STA $4685 
$4761  A9 5E     LDA #$5E
$4763  85 7A     STA $7A 
$4765  A9 46     LDA #$46
$4767  85 7B     STA $7B 
$4769  A9 08     LDA #$08
$476B  8D 2F 17  STA $172F 
$476E  20 75 47  JSR L_JSR_($4775)_($476E) OK
$4771  60        RTS 
//------------------------------
L_BRS_($4772)_($4783) OK
L_BRS_($4772)_($478F) OK
L_BRS_($4772)_($479F) OK
L_BRS_($4772)_($47AB) OK
//------------------------------
$4772  4C 50 48  JMP L_JMP_($4850)_($4772) OK
//------------------------------
L_JSR_($4775)_($46FE) OK
L_JSR_($4775)_($476E) OK
//------------------------------
$4775  AD 7B 46  LDA $467B 
$4778  18        CLC 
$4779  6D 83 46  ADC $4683 
$477C  AA        TAX 
$477D  AD 7C 46  LDA $467C 
$4780  6D 84 46  ADC $4684 
$4783  30 ED     BMI L_BRS_($4772)_($4783) OK
$4785  A8        TAY 
$4786  8A        TXA 
$4787  38        SEC 
$4788  ED 7F 46  SBC $467F 
$478B  98        TYA 
$478C  ED 80 46  SBC $4680 
$478F  10 E1     BPL L_BRS_($4772)_($478F) OK
$4791  AD 7D 46  LDA $467D 
$4794  18        CLC 
$4795  6D 83 46  ADC $4683 
$4798  AA        TAX 
$4799  AD 7E 46  LDA $467E 
$479C  6D 84 46  ADC $4684 
$479F  30 D1     BMI L_BRS_($4772)_($479F) OK
$47A1  A8        TAY 
$47A2  8A        TXA 
$47A3  38        SEC 
$47A4  ED 81 46  SBC $4681 
$47A7  98        TYA 
$47A8  ED 82 46  SBC $4682 
$47AB  10 C5     BPL L_BRS_($4772)_($47AB) OK
$47AD  8E 3D 15  STX $153D 
$47B0  A9 00     LDA #$00
$47B2  8D 89 46  STA $4689 
$47B5  8A        TXA 
$47B6  38        SEC 
$47B7  E9 68     SBC #$68
$47B9  8D 8A 46  STA $468A 
$47BC  98        TYA 
$47BD  E9 00     SBC #$00
$47BF  30 0B     BMI L_BRS_($47CC)_($47BF) OK
$47C1  AD 8A 46  LDA $468A 
$47C4  8D 89 46  STA $4689 
$47C7  A9 68     LDA #$68
$47C9  8D 3D 15  STA $153D 
//------------------------------
L_BRS_($47CC)_($47BF) OK
//------------------------------
$47CC  8A        TXA 
$47CD  38        SEC 
$47CE  ED 85 46  SBC $4685 
$47D1  8D 3E 15  STA $153E 
$47D4  98        TYA 
$47D5  ED 86 46  SBC $4686 
$47D8  10 05     BPL L_BRS_($47DF)_($47D8) OK
$47DA  A9 00     LDA #$00
$47DC  8D 3E 15  STA $153E 
//------------------------------
L_BRS_($47DF)_($47D8) OK
//------------------------------
$47DF  AD 3D 15  LDA $153D 
$47E2  38        SEC 
$47E3  ED 3E 15  SBC $153E 
$47E6  18        CLC 
$47E7  69 01     ADC #$01
$47E9  8D 8A 46  STA $468A 
$47EC  AC 89 46  LDY $4689 
$47EF  AE 3D 15  LDX $153D 
//------------------------------
L_BRS_($47F2)_($484B) OK
//------------------------------
$47F2  AD 7B 46  LDA $467B 
$47F5  38        SEC 
$47F6  F1 7A     SBC ($7A),Y 
$47F8  F0 0A     BEQ L_BRS_($4804)_($47F8) OK
$47FA  9D DB 15  STA $15DB,X 
$47FD  AD 7C 46  LDA $467C 
$4800  E9 00     SBC #$00
$4802  10 08     BPL L_BRS_($480C)_($4802) OK
//------------------------------
L_BRS_($4804)_($47F8) OK
//------------------------------
$4804  A9 01     LDA #$01
$4806  9D DB 15  STA $15DB,X 
$4809  4C 13 48  JMP L_JMP_($4813)_($4809) OK
//------------------------------
L_BRS_($480C)_($4802) OK
//------------------------------
$480C  A9 80     LDA #$80
$480E  DD DB 15  CMP $15DB,X 
$4811  90 33     BCC L_BRS_($4846)_($4811) OK
//------------------------------
L_JMP_($4813)_($4809) OK
//------------------------------
$4813  AD 7B 46  LDA $467B 
$4816  18        CLC 
$4817  71 7A     ADC ($7A),Y 
$4819  F0 2B     BEQ L_BRS_($4846)_($4819) OK
$481B  9D 44 16  STA $1644,X 
$481E  AD 7C 46  LDA $467C 
$4821  69 00     ADC #$00
$4823  30 21     BMI L_BRS_($4846)_($4823) OK
$4825  A9 80     LDA #$80
$4827  DD 44 16  CMP $1644,X 
$482A  B0 03     BCS L_BRS_($482F)_($482A) OK
$482C  9D 44 16  STA $1644,X 
//------------------------------
L_BRS_($482F)_($482A) OK
//------------------------------
$482F  A9 02     LDA #$02
$4831  9D AD 16  STA $16AD,X 
$4834  A9 00     LDA #$00
$4836  38        SEC 
$4837  FD DB 15  SBC $15DB,X 
$483A  9D DB 15  STA $15DB,X 
$483D  A9 00     LDA #$00
$483F  38        SEC 
$4840  FD 44 16  SBC $1644,X 
//------------------------------
L_JSR_($4843)_($897C) OK
L_JSR_($4843)_($8999) OK
//------------------------------
$4843  9D 44 16  STA $1644,X 
//------------------------------
L_BRS_($4846)_($4811) OK
L_BRS_($4846)_($4819) OK
L_BRS_($4846)_($4823) OK
//------------------------------
$4846  C8        INY 
$4847  CA        DEX 
$4848  CE 8A 46  DEC $468A 
$484B  D0 A5     BNE L_BRS_($47F2)_($484B) OK
$484D  20 84 38  JSR L_JSR_($3884)_($484D) OK
//------------------------------
L_JMP_($4850)_($4772) OK
//------------------------------
$4850  60        RTS 
//------------------------------
L_JSR_($4851)_($46A6) OK
L_JSR_($4851)_($46C7) OK
//------------------------------
$4851  A2 00     LDX #$00
//------------------------------
L_JSR_($4853)_($1AA9) OK
//------------------------------
$4853  38        SEC 
$4854  ED 87 46  SBC $4687 
$4857  10 07     BPL L_BRS_($4860)_($4857) OK
$4859  49 FF     EOR #$FF
$485B  18        CLC 
$485C  69 01     ADC #$01
$485E  A2 01     LDX #$01
//------------------------------
L_BRS_($4860)_($4857) OK
//------------------------------
$4860  C9 24     CMP #$24
$4862  30 0E     BMI L_BRS_($4872)_($4862) OK
$4864  38        SEC 
$4865  E9 48     SBC #$48
$4867  49 FF     EOR #$FF
$4869  18        CLC 
$486A  69 01     ADC #$01
$486C  A8        TAY 
$486D  8A        TXA 
$486E  49 01     EOR #$01
$4870  AA        TAX 
$4871  98        TYA 
//------------------------------
L_BRS_($4872)_($4862) OK
//------------------------------
$4872  A8        TAY 
$4873  8A        TXA 
$4874  F0 05     BEQ L_BRS_($487B)_($4874) OK
$4876  98        TYA 
$4877  49 FF     EOR #$FF
$4879  A8        TAY 
$487A  C8        INY 
//------------------------------
L_BRS_($487B)_($4874) OK
//------------------------------
$487B  A2 FF     LDX #$FF
$487D  20 76 1E  JSR L_JSR_($1E76)_($487D) OK
$4880  AD 88 46  LDA $4688 
$4883  18        CLC 
$4884  65 82     ADC $82 
$4886  85 82     STA $82 
$4888  A9 00     LDA #$00
$488A  65 83     ADC $83 
$488C  85 83     STA $83 
$488E  60        RTS 
//------------------------------
$488F  46 46     LSR $46 
//------------------------------
L_JSR_($4891)_($40A4) OK
L_JSR_($4891)_($415F) OK
//------------------------------
$4891  AD B7 96  LDA $96B7 
$4894  8D 95 1C  STA $1C95 
$4897  AD B8 96  LDA $96B8 
$489A  8D 96 1C  STA $1C96 
$489D  AD B9 96  LDA $96B9 
$48A0  8D 97 1C  STA $1C97 
$48A3  AD BE 96  LDA $96BE 
$48A6  8D 3F 1C  STA $1C3F 
$48A9  AD C3 96  LDA $96C3 
$48AC  8D 3D 1C  STA $1C3D 
$48AF  A9 01     LDA #$01
$48B1  8D 89 15  STA $1589 
$48B4  A9 3F     LDA #$3F
$48B6  8D 4A 15  STA $154A 
$48B9  A9 03     LDA #$03
$48BB  8D 3A 1C  STA $1C3A 
$48BE  A9 36     LDA #$36
$48C0  8D 3B 1C  STA $1C3B 
$48C3  A9 0E     LDA #$0E
$48C5  8D 3C 1C  STA $1C3C 
$48C8  A9 FF     LDA #$FF
$48CA  8D A0 1C  STA $1CA0 
$48CD  A9 00     LDA #$00
$48CF  8D 91 1C  STA $1C91 
$48D2  8D 9B 17  STA $179B 
$48D5  8D 98 17  STA $1798 
$48D8  8D 49 15  STA $1549 
$48DB  8D 98 1C  STA $1C98 
$48DE  8D 99 1C  STA $1C99 
$48E1  8D 9A 1C  STA $1C9A 
$48E4  8D 9B 1C  STA $1C9B 
$48E7  8D 9C 1C  STA $1C9C 
$48EA  8D A1 1C  STA $1CA1 
$48ED  8D 75 15  STA $1575 
$48F0  8D 6D 15  STA $156D 
$48F3  8D 6C 15  STA $156C 
$48F6  8D 48 15  STA $1548 
$48F9  8D 68 1C  STA $1C68 
$48FC  8D 69 1C  STA $1C69 
$48FF  8D 6A 1C  STA $1C6A 
$4902  8D 6C 1C  STA $1C6C 
$4905  8D 6D 1C  STA $1C6D 
$4908  8D 6E 1C  STA $1C6E 
$490B  8D 6F 1C  STA $1C6F 
$490E  A2 20     LDX #$20
//------------------------------
L_BRS_($4910)_($4914) OK
//------------------------------
$4910  9D 6F 1C  STA $1C6F,X 
$4913  CA        DEX 
$4914  D0 FA     BNE L_BRS_($4910)_($4914) OK
$4916  AD 08 96  LDA $9608 
$4919  8D 6B 1C  STA $1C6B 
$491C  AE 3D 1C  LDX $1C3D 
$491F  BD 27 15  LDA $1527,X 
$4922  8D 3E 1C  STA $1C3E 
$4925  20 8F 6F  JSR L_JSR_($6F8F)_($4925) OK
$4928  AD 78 15  LDA $1578 
$492B  F0 63     BEQ L_BRS_($4990)_($492B) OK
$492D  8D 90 48  STA $4890 
$4930  A2 00     LDX #$00
$4932  AD 8C 15  LDA $158C 
$4935  8D 45 49  STA $4945 
$4938  8D 4F 49  STA $494F 
$493B  AD 8D 15  LDA $158D 
$493E  8D 46 49  STA $4946 
$4941  8D 50 49  STA $4950 
//------------------------------
L_BRS_($4944)_($498E) OK
L_JSR_($4944)_($72EA) OK
L_JSR_($4946)_($72FE) BAD
L_JSR_($4946)_($841B) BAD
L_JSR_($4946)_($8421) BAD
//------------------------------
$4944  BD FF FF  LDA $FFFF,X 
$4947  18        CLC 
$4948  6D 8A 15  ADC $158A 
//------------------------------
L_JSR_($494C)_($1A3D) BAD
//------------------------------
$494B  85 7C     STA $7C 
$494D  E8        INX 
$494E  BD FF FF  LDA $FFFF,X 
$4951  6D 8B 15  ADC $158B 
$4954  85 7D     STA $7D 
$4956  E8        INX 
$4957  A0 01     LDY #$01
$4959  B1 7C     LDA ($7C),Y 
$495B  F0 2E     BEQ L_BRS_($498B)_($495B) OK
$495D  48        PHA 
$495E  A5 7C     LDA $7C 
$4960  18        CLC 
$4961  69 0F     ADC #$0F
$4963  85 7C     STA $7C 
$4965  90 02     BCC L_BRS_($4969)_($4965) OK
$4967  E6 7D     INC $7D 
//------------------------------
L_BRS_($4969)_($4965) OK
//------------------------------
$4969  68        PLA 
$496A  8D 8F 48  STA $488F 
//------------------------------
L_BRS_($496D)_($4989) OK
//------------------------------
$496D  A0 00     LDY #$00
$496F  B1 7C     LDA ($7C),Y 
$4971  29 9F     AND #$9F
$4973  10 02     BPL L_BRS_($4977)_($4973) OK
$4975  09 40     ORA #$40
//------------------------------
L_BRS_($4977)_($4973) OK
//------------------------------
$4977  91 7C     STA ($7C),Y 
$4979  A0 08     LDY #$08
$497B  B1 7C     LDA ($7C),Y 
$497D  18        CLC 
$497E  65 7C     ADC $7C 
$4980  85 7C     STA $7C 
$4982  90 02     BCC L_BRS_($4986)_($4982) OK
$4984  E6 7D     INC $7D 
//------------------------------
L_BRS_($4986)_($4982) OK
//------------------------------
$4986  CE 8F 48  DEC $488F 
$4989  D0 E2     BNE L_BRS_($496D)_($4989) OK
//------------------------------
L_BRS_($498B)_($495B) OK
//------------------------------
$498B  CE 90 48  DEC $4890 
$498E  D0 B4     BNE L_BRS_($4944)_($498E) OK
//------------------------------
L_BRS_($4990)_($492B) OK
//------------------------------
$4990  AD 03 96  LDA $9603 
$4993  8D 47 1C  STA $1C47 
$4996  AD 04 96  LDA $9604 
$4999  8D 50 15  STA $1550 
$499C  20 A2 49  JSR L_JSR_($49A2)_($499C) OK
$499F  60        RTS 
//------------------------------
$49A0  46 46     LSR $46 
//------------------------------
L_JSR_($49A2)_($43C5) OK
L_JSR_($49A2)_($499C) OK
L_JSR_($49A2)_($670A) OK
//------------------------------
$49A2  A9 02     LDA #$02
$49A4  8D 3F 1C  STA $1C3F 
$49A7  8D 37 1C  STA $1C37 
$49AA  AD 2E 15  LDA $152E 
$49AD  8D 36 1C  STA $1C36 
$49B0  20 6A 70  JSR L_JSR_($706A)_($49B0) BAD
$49B3  AD 50 15  LDA $1550 
$49B6  8D 46 15  STA $1546 
$49B9  A9 00     LDA #$00
$49BB  20 C1 5C  JSR L_JSR_($5CC1)_($49BB) BAD
$49BE  D0 6E     BNE L_BRS_($4A2E)_($49BE) OK
$49C0  A0 01     LDY #$01
$49C2  B1 7C     LDA ($7C),Y 
$49C4  85 82     STA $82 
$49C6  A9 00     LDA #$00
$49C8  46 82     LSR $82 
$49CA  6A        ROR A 
$49CB  46 82     LSR $82 
$49CD  6A        ROR A 
$49CE  18        CLC 
$49CF  69 20     ADC #$20
$49D1  8D 2E 1C  STA $1C2E 
$49D4  A5 82     LDA $82 
$49D6  69 00     ADC #$00
$49D8  8D 2F 1C  STA $1C2F 
$49DB  A0 03     LDY #$03
$49DD  B1 7C     LDA ($7C),Y 
$49DF  85 82     STA $82 
$49E1  A9 00     LDA #$00
$49E3  46 82     LSR $82 
$49E5  6A        ROR A 
$49E6  46 82     LSR $82 
$49E8  6A        ROR A 
$49E9  18        CLC 
$49EA  69 20     ADC #$20
$49EC  8D 32 1C  STA $1C32 
$49EF  A5 82     LDA $82 
$49F1  69 00     ADC #$00
$49F3  8D 33 1C  STA $1C33 
$49F6  A0 02     LDY #$02
$49F8  B1 7C     LDA ($7C),Y 
$49FA  85 82     STA $82 
$49FC  AD 46 1C  LDA $1C46 
$49FF  D0 0B     BNE L_BRS_($4A0C)_($49FF) OK
$4A01  AD 42 1C  LDA $1C42 
$4A04  38        SEC 
$4A05  E9 01     SBC #$01
$4A07  18        CLC 
$4A08  65 82     ADC $82 
$4A0A  85 82     STA $82 
//------------------------------
L_BRS_($4A0C)_($49FF) OK
//------------------------------
$4A0C  A9 00     LDA #$00
$4A0E  46 82     LSR $82 
$4A10  6A        ROR A 
$4A11  46 82     LSR $82 
$4A13  6A        ROR A 
$4A14  18        CLC 
$4A15  69 20     ADC #$20
$4A17  8D 30 1C  STA $1C30 
$4A1A  A5 82     LDA $82 
$4A1C  69 00     ADC #$00
$4A1E  8D 31 1C  STA $1C31 
$4A21  A0 04     LDY #$04
$4A23  B1 7C     LDA ($7C),Y 
$4A25  8D 38 1C  STA $1C38 
$4A28  C8        INY 
$4A29  B1 7C     LDA ($7C),Y 
$4A2B  8D 39 1C  STA $1C39 
//------------------------------
L_BRS_($4A2E)_($49BE) OK
//------------------------------
$4A2E  60        RTS 
//------------------------------
$4A2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A3F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A47            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A5F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A67            .byte $00,$00,$00,$00,$00,$00,$00,$00
$4A6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($4A77)_($2F36) OK
L_JSR_($4A77)_($58CA) OK
L_JSR_($4A77)_($59E1) OK
L_JSR_($4A77)_($788B) OK
L_JSR_($4A77)_($79AB) OK
//------------------------------
$4A77  AD 32 15  LDA $1532 
$4A7A  F0 73     BEQ L_BRS_($4AEF)_($4A7A) OK
$4A7C  AD 37 15  LDA $1537 
$4A7F  C9 7F     CMP #$7F
$4A81  F0 67     BEQ L_BRS_($4AEA)_($4A81) OK
$4A83  C9 9F     CMP #$9F
$4A85  F0 63     BEQ L_BRS_($4AEA)_($4A85) OK
$4A87  AD 3B 15  LDA $153B 
$4A8A  C9 7F     CMP #$7F
$4A8C  F0 5C     BEQ L_BRS_($4AEA)_($4A8C) OK
$4A8E  C9 9F     CMP #$9F
$4A90  F0 58     BEQ L_BRS_($4AEA)_($4A90) OK
$4A92  A2 00     LDX #$00
$4A94  AD 37 15  LDA $1537 
$4A97  30 21     BMI L_BRS_($4ABA)_($4A97) OK
$4A99  AD 36 15  LDA $1536 
$4A9C  38        SEC 
$4A9D  E9 C0     SBC #$C0
$4A9F  AD 37 15  LDA $1537 
$4AA2  E9 1F     SBC #$1F
$4AA4  10 14     BPL L_BRS_($4ABA)_($4AA4) OK
$4AA6  AD 3B 15  LDA $153B 
$4AA9  30 0F     BMI L_BRS_($4ABA)_($4AA9) OK
$4AAB  AD 3A 15  LDA $153A 
$4AAE  38        SEC 
$4AAF  E9 C0     SBC #$C0
$4AB1  AD 3B 15  LDA $153B 
$4AB4  E9 1F     SBC #$1F
$4AB6  10 02     BPL L_BRS_($4ABA)_($4AB6) OK
$4AB8  A2 02     LDX #$02
//------------------------------
L_BRS_($4ABA)_($4A97) OK
L_BRS_($4ABA)_($4AA4) OK
L_BRS_($4ABA)_($4AA9) OK
L_BRS_($4ABA)_($4AB6) OK
//------------------------------
$4ABA  AD 2F 1C  LDA $1C2F 
$4ABD  30 20     BMI L_BRS_($4ADF)_($4ABD) OK
$4ABF  AD 2E 1C  LDA $1C2E 
$4AC2  38        SEC 
$4AC3  E9 C0     SBC #$C0
$4AC5  AD 2F 1C  LDA $1C2F 
$4AC8  E9 1F     SBC #$1F
$4ACA  10 13     BPL L_BRS_($4ADF)_($4ACA) OK
$4ACC  AD 33 1C  LDA $1C33 
$4ACF  30 0E     BMI L_BRS_($4ADF)_($4ACF) OK
$4AD1  AD 32 1C  LDA $1C32 
$4AD4  38        SEC 
$4AD5  E9 C0     SBC #$C0
$4AD7  AD 33 1C  LDA $1C33 
$4ADA  E9 1F     SBC #$1F
$4ADC  10 01     BPL L_BRS_($4ADF)_($4ADC) OK
$4ADE  E8        INX 
//------------------------------
L_BRS_($4ADF)_($4ABD) OK
L_BRS_($4ADF)_($4ACA) OK
L_BRS_($4ADF)_($4ACF) OK
L_BRS_($4ADF)_($4ADC) OK
//------------------------------
$4ADF  E0 01     CPX #$01
$4AE1  F0 0C     BEQ L_BRS_($4AEF)_($4AE1) OK
$4AE3  E0 03     CPX #$03
$4AE5  F0 08     BEQ L_BRS_($4AEF)_($4AE5) OK
$4AE7  4C CA 4E  JMP L_JMP_($4ECA)_($4AE7) OK
//------------------------------
L_BRS_($4AEA)_($4A81) OK
L_BRS_($4AEA)_($4A85) OK
L_BRS_($4AEA)_($4A8C) OK
L_BRS_($4AEA)_($4A90) OK
//------------------------------
$4AEA  A2 00     LDX #$00
$4AEC  4C 34 4F  JMP L_JMP_($4F34)_($4AEC) OK
//------------------------------
L_BRS_($4AEF)_($4A7A) OK
L_BRS_($4AEF)_($4AE1) OK
L_BRS_($4AEF)_($4AE5) OK
//------------------------------
$4AEF  A9 00     LDA #$00
$4AF1  8D 6E 4A  STA $4A6E 
$4AF4  8D 6F 4A  STA $4A6F 
$4AF7  8D 74 4A  STA $4A74 
$4AFA  8D 6C 4A  STA $4A6C 
$4AFD  8D 6D 4A  STA $4A6D 
$4B00  8D 76 4A  STA $4A76 
$4B03  A9 FF     LDA #$FF
$4B05  8D 5B 4A  STA $4A5B 
$4B08  8D 5C 4A  STA $4A5C 
$4B0B  AD 32 15  LDA $1532 
$4B0E  8D 75 4A  STA $4A75 
$4B11  F0 03     BEQ L_BRS_($4B16)_($4B11) OK
$4B13  CE 75 4A  DEC $4A75 
//------------------------------
L_BRS_($4B16)_($4B11) OK
//------------------------------
$4B16  AD 46 1C  LDA $1C46 
$4B19  D0 1E     BNE L_BRS_($4B39)_($4B19) OK
$4B1B  A9 02     LDA #$02
$4B1D  8D 6F 4A  STA $4A6F 
$4B20  A2 05     LDX #$05
//------------------------------
L_BRS_($4B22)_($4B29) OK
//------------------------------
$4B22  BD 2E 1C  LDA $1C2E,X 
$4B25  9D 65 4A  STA $4A65,X 
$4B28  CA        DEX 
$4B29  10 F7     BPL L_BRS_($4B22)_($4B29) OK
$4B2B  AD 42 1C  LDA $1C42 
$4B2E  20 61 50  JSR L_JSR_($5061)_($4B2E) OK
$4B31  8D 6C 4A  STA $4A6C 
$4B34  A5 83     LDA $83 
$4B36  8D 6D 4A  STA $4A6D 
//------------------------------
L_BRS_($4B39)_($4B19) OK
//------------------------------
$4B39  A0 04     LDY #$04
$4B3B  A2 00     LDX #$00
$4B3D  AD 75 4A  LDA $4A75 
$4B40  85 82     STA $82 
$4B42  AD 76 4A  LDA $4A76 
$4B45  85 83     STA $83 
$4B47  06 82     ASL $82 
$4B49  26 83     ROL $83 
//------------------------------
L_JMP_($4B4B)_($4BCD) OK
//------------------------------
$4B4B  8A        TXA 
$4B4C  0A        ASL A 
$4B4D  0A        ASL A 
$4B4E  AA        TAX 
$4B4F  B9 36 15  LDA $1536,Y 
$4B52  18        CLC 
$4B53  6D 75 4A  ADC $4A75 
$4B56  99 35 4A  STA $4A35,Y 
$4B59  B9 37 15  LDA $1537,Y 
$4B5C  6D 76 4A  ADC $4A76 
$4B5F  99 36 4A  STA $4A36,Y 
$4B62  B9 2E 1C  LDA $1C2E,Y 
$4B65  38        SEC 
$4B66  ED 75 4A  SBC $4A75 
$4B69  99 3B 4A  STA $4A3B,Y 
$4B6C  B9 2F 1C  LDA $1C2F,Y 
$4B6F  ED 76 4A  SBC $4A76 
$4B72  99 3C 4A  STA $4A3C,Y 
$4B75  B9 36 15  LDA $1536,Y 
$4B78  99 53 4A  STA $4A53,Y 
$4B7B  99 5F 4A  STA $4A5F,Y 
$4B7E  38        SEC 
$4B7F  F9 2E 1C  SBC $1C2E,Y 
$4B82  99 2F 4A  STA $4A2F,Y 
$4B85  B9 37 15  LDA $1537,Y 
$4B88  99 54 4A  STA $4A54,Y 
$4B8B  99 60 4A  STA $4A60,Y 
$4B8E  F9 2F 1C  SBC $1C2F,Y 
$4B91  99 30 4A  STA $4A30,Y 
$4B94  30 0A     BMI L_BRS_($4BA0)_($4B94) OK
$4B96  19 2F 4A  ORA $4A2F,Y
$4B99  F0 2C     BEQ L_BRS_($4BC7)_($4B99) OK
$4B9B  E8        INX 
$4B9C  E8        INX 
$4B9D  4C C7 4B  JMP L_JMP_($4BC7)_($4B9D) OK
//------------------------------
L_BRS_($4BA0)_($4B94) OK
//------------------------------
$4BA0  E8        INX 
$4BA1  B9 3C 4A  LDA $4A3C,Y 
$4BA4  48        PHA 
$4BA5  B9 3B 4A  LDA $4A3B,Y 
$4BA8  48        PHA 
$4BA9  B9 35 4A  LDA $4A35,Y 
$4BAC  38        SEC 
$4BAD  E5 82     SBC $82 
$4BAF  99 3B 4A  STA $4A3B,Y 
$4BB2  B9 36 4A  LDA $4A36,Y 
$4BB5  E5 83     SBC $83 
$4BB7  99 3C 4A  STA $4A3C,Y 
$4BBA  68        PLA 
$4BBB  18        CLC 
$4BBC  65 82     ADC $82 
$4BBE  99 35 4A  STA $4A35,Y 
$4BC1  68        PLA 
$4BC2  65 83     ADC $83 
$4BC4  99 36 4A  STA $4A36,Y 
//------------------------------
L_BRS_($4BC7)_($4B99) OK
L_JMP_($4BC7)_($4B9D) OK
//------------------------------
$4BC7  88        DEY 
$4BC8  88        DEY 
$4BC9  C0 FE     CPY #$FE
$4BCB  F0 03     BEQ L_BRS_($4BD0)_($4BCB) OK
$4BCD  4C 4B 4B  JMP L_JMP_($4B4B)_($4BCD) OK
//------------------------------
L_BRS_($4BD0)_($4BCB) OK
//------------------------------
$4BD0  8A        TXA 
$4BD1  D0 06     BNE L_BRS_($4BD9)_($4BD1) OK
$4BD3  4C 34 4F  JMP L_JMP_($4F34)_($4BD3) OK
//------------------------------
L_BRS_($4BD6)_($4BDF) OK
L_BRS_($4BD6)_($4C29) OK
//------------------------------
$4BD6  4C 0A 4E  JMP L_JMP_($4E0A)_($4BD6) OK
//------------------------------
L_BRS_($4BD9)_($4BD1) OK
//------------------------------
$4BD9  8D 6B 4A  STA $4A6B 
$4BDC  AD 46 1C  LDA $1C46 
$4BDF  D0 F5     BNE L_BRS_($4BD6)_($4BDF) OK
$4BE1  EE 75 4A  INC $4A75 
$4BE4  AD 3D 4A  LDA $4A3D 
$4BE7  18        CLC 
$4BE8  6D 75 4A  ADC $4A75 
$4BEB  8D 3D 4A  STA $4A3D 
$4BEE  AD 3E 4A  LDA $4A3E 
$4BF1  6D 76 4A  ADC $4A76 
$4BF4  8D 3E 4A  STA $4A3E 
$4BF7  AD 37 4A  LDA $4A37 
$4BFA  38        SEC 
$4BFB  ED 75 4A  SBC $4A75 
//------------------------------
L_JMP_($4C00)_($C99A) BAD
//------------------------------
$4BFE  8D 37 4A  STA $4A37 
$4C01  AD 38 4A  LDA $4A38 
$4C04  ED 76 4A  SBC $4A76 
$4C07  8D 38 4A  STA $4A38 
$4C0A  CE 75 4A  DEC $4A75 
$4C0D  AD 37 4A  LDA $4A37 
$4C10  18        CLC 
$4C11  6D 6C 4A  ADC $4A6C 
$4C14  8D 37 4A  STA $4A37 
$4C17  AD 38 4A  LDA $4A38 
$4C1A  6D 6D 4A  ADC $4A6D 
$4C1D  8D 38 4A  STA $4A38 
//------------------------------
L_JMP_($4C20)_($4D51) OK
L_JMP_($4C20)_($4D66) OK
L_JMP_($4C20)_($4DF2) OK
L_JMP_($4C20)_($4E07) OK
//------------------------------
$4C20  20 FB 50  JSR L_JSR_($50FB)_($4C20) OK
$4C23  AD 70 4A  LDA $4A70 
$4C26  0D 71 4A  ORA $4A71
$4C29  D0 AB     BNE L_BRS_($4BD6)_($4C29) OK
//------------------------------
L_JMP_($4C2D)_($718F) BAD
//------------------------------
$4C2B  AD 74 4A  LDA $4A74 
$4C2E  F0 65     BEQ L_BRS_($4C95)_($4C2E) OK
$4C30  AD 72 4A  LDA $4A72 
$4C33  85 7E     STA $7E 
$4C35  AD 73 4A  LDA $4A73 
$4C38  85 7F     STA $7F 
$4C3A  A0 01     LDY #$01
$4C3C  B1 7E     LDA ($7E),Y 
$4C3E  20 61 50  JSR L_JSR_($5061)_($4C3E) OK
$4C41  38        SEC 
$4C42  ED 36 15  SBC $1536 
$4C45  A5 83     LDA $83 
$4C47  ED 37 15  SBC $1537 
$4C4A  10 51     BPL L_BRS_($4C9D)_($4C4A) OK
$4C4C  B1 7E     LDA ($7E),Y 
$4C4E  18        CLC 
$4C4F  A0 04     LDY #$04
$4C51  71 7E     ADC ($7E),Y 
$4C53  20 61 50  JSR L_JSR_($5061)_($4C53) OK
$4C56  38        SEC 
$4C57  ED 36 15  SBC $1536 
$4C5A  A5 83     LDA $83 
$4C5C  ED 37 15  SBC $1537 
$4C5F  30 3C     BMI L_BRS_($4C9D)_($4C5F) OK
$4C61  88        DEY 
$4C62  B1 7E     LDA ($7E),Y 
$4C64  20 61 50  JSR L_JSR_($5061)_($4C64) OK
$4C67  38        SEC 
$4C68  ED 3A 15  SBC $153A 
$4C6B  A5 83     LDA $83 
$4C6D  ED 3B 15  SBC $153B 
$4C70  10 2B     BPL L_BRS_($4C9D)_($4C70) OK
$4C72  B1 7E     LDA ($7E),Y 
$4C74  18        CLC 
$4C75  A0 06     LDY #$06
$4C77  71 7E     ADC ($7E),Y 
$4C79  20 61 50  JSR L_JSR_($5061)_($4C79) OK
$4C7C  38        SEC 
$4C7D  ED 3A 15  SBC $153A 
$4C80  A5 83     LDA $83 
$4C82  ED 3B 15  SBC $153B 
$4C85  30 16     BMI L_BRS_($4C9D)_($4C85) OK
$4C87  A2 05     LDX #$05
//------------------------------
L_BRS_($4C89)_($4C90) OK
//------------------------------
$4C89  BD 36 15  LDA $1536,X 
$4C8C  9D 65 4A  STA $4A65,X 
$4C8F  CA        DEX 
$4C90  10 F7     BPL L_BRS_($4C89)_($4C90) OK
$4C92  20 FB 50  JSR L_JSR_($50FB)_($4C92) OK
//------------------------------
L_BRS_($4C95)_($4C2E) OK
//------------------------------
$4C95  A9 00     LDA #$00
$4C97  8D 6F 4A  STA $4A6F 
$4C9A  4C 0A 4E  JMP L_JMP_($4E0A)_($4C9A) OK
//------------------------------
L_BRS_($4C9D)_($4C4A) OK
L_BRS_($4C9D)_($4C5F) OK
L_BRS_($4C9D)_($4C70) OK
L_BRS_($4C9D)_($4C85) OK
//------------------------------
$4C9D  A0 01     LDY #$01
$4C9F  AD 6B 4A  LDA $4A6B 
$4CA2  29 01     AND #$01
$4CA4  F0 08     BEQ L_BRS_($4CAE)_($4CA4) OK
$4CA6  B1 7E     LDA ($7E),Y 
$4CA8  4C BC 4C  JMP L_JMP_($4CBC)_($4CA8) OK
//------------------------------
L_BRS_($4CAB)_($4CB3) OK
//------------------------------
$4CAB  4C 69 4D  JMP L_JMP_($4D69)_($4CAB) OK
//------------------------------
L_BRS_($4CAE)_($4CA4) OK
//------------------------------
$4CAE  AD 6B 4A  LDA $4A6B 
$4CB1  29 02     AND #$02
$4CB3  F0 F6     BEQ L_BRS_($4CAB)_($4CB3) OK
$4CB5  B1 7E     LDA ($7E),Y 
$4CB7  18        CLC 
$4CB8  A0 04     LDY #$04
$4CBA  71 7E     ADC ($7E),Y 
//------------------------------
L_JMP_($4CBC)_($4CA8) OK
//------------------------------
$4CBC  20 61 50  JSR L_JSR_($5061)_($4CBC) OK
$4CBF  8D 65 4A  STA $4A65 
$4CC2  38        SEC 
$4CC3  ED 2E 1C  SBC $1C2E 
$4CC6  85 88     STA $88 
$4CC8  A5 83     LDA $83 
$4CCA  8D 66 4A  STA $4A66 
$4CCD  ED 2F 1C  SBC $1C2F 
$4CD0  85 89     STA $89 
$4CD2  AD 33 4A  LDA $4A33 
$4CD5  85 8C     STA $8C 
$4CD7  AD 34 4A  LDA $4A34 
$4CDA  85 8D     STA $8D 
$4CDC  20 31 1D  JSR L_JSR_($1D31)_($4CDC) OK
$4CDF  A5 82     LDA $82 
$4CE1  85 88     STA $88 
$4CE3  A5 83     LDA $83 
$4CE5  85 89     STA $89 
$4CE7  A5 84     LDA $84 
$4CE9  85 8A     STA $8A 
$4CEB  A5 85     LDA $85 
$4CED  85 8B     STA $8B 
$4CEF  AD 2F 4A  LDA $4A2F 
$4CF2  85 8C     STA $8C 
$4CF4  AD 30 4A  LDA $4A30 
$4CF7  85 8D     STA $8D 
$4CF9  20 DE 1E  JSR L_JSR_($1EDE)_($4CF9) OK
$4CFC  AD 32 1C  LDA $1C32 
$4CFF  18        CLC 
$4D00  65 88     ADC $88 
$4D02  8D 69 4A  STA $4A69 
$4D05  AD 33 1C  LDA $1C33 
$4D08  65 89     ADC $89 
$4D0A  8D 6A 4A  STA $4A6A 
$4D0D  A0 03     LDY #$03
$4D0F  B1 7E     LDA ($7E),Y 
$4D11  20 61 50  JSR L_JSR_($5061)_($4D11) OK
$4D14  38        SEC 
$4D15  AD 69 4A  LDA $4A69 
$4D18  E5 82     SBC $82 
$4D1A  AD 6A 4A  LDA $4A6A 
$4D1D  E5 83     SBC $83 
$4D1F  30 48     BMI L_BRS_($4D69)_($4D1F) OK
$4D21  B1 7E     LDA ($7E),Y 
$4D23  18        CLC 
$4D24  A0 06     LDY #$06
$4D26  71 7E     ADC ($7E),Y 
$4D28  20 61 50  JSR L_JSR_($5061)_($4D28) OK
$4D2B  38        SEC 
$4D2C  AD 69 4A  LDA $4A69 
$4D2F  E5 82     SBC $82 
$4D31  AD 6A 4A  LDA $4A6A 
$4D34  E5 83     SBC $83 
$4D36  10 31     BPL L_BRS_($4D69)_($4D36) OK
$4D38  AD 6B 4A  LDA $4A6B 
$4D3B  29 01     AND #$01
$4D3D  F0 15     BEQ L_BRS_($4D54)_($4D3D) OK
$4D3F  AD 65 4A  LDA $4A65 
$4D42  38        SEC 
$4D43  ED 32 15  SBC $1532 
$4D46  8D 65 4A  STA $4A65 
$4D49  AD 66 4A  LDA $4A66 
$4D4C  E9 00     SBC #$00
$4D4E  8D 66 4A  STA $4A66 
$4D51  4C 20 4C  JMP L_JMP_($4C20)_($4D51) OK
//------------------------------
L_BRS_($4D54)_($4D3D) OK
//------------------------------
$4D54  AD 65 4A  LDA $4A65 
$4D57  18        CLC 
$4D58  6D 32 15  ADC $1532 
$4D5B  8D 65 4A  STA $4A65 
$4D5E  AD 66 4A  LDA $4A66 
$4D61  69 00     ADC #$00
$4D63  8D 66 4A  STA $4A66 
$4D66  4C 20 4C  JMP L_JMP_($4C20)_($4D66) OK
//------------------------------
L_JMP_($4D69)_($4CAB) OK
L_BRS_($4D69)_($4D1F) OK
L_BRS_($4D69)_($4D36) OK
//------------------------------
$4D69  A0 03     LDY #$03
$4D6B  AD 6B 4A  LDA $4A6B 
$4D6E  29 10     AND #$10
$4D70  F0 08     BEQ L_BRS_($4D7A)_($4D70) OK
$4D72  B1 7E     LDA ($7E),Y 
$4D74  4C 88 4D  JMP L_JMP_($4D88)_($4D74) OK
//------------------------------
L_BRS_($4D77)_($4D7F) OK
//------------------------------
$4D77  4C 0A 4E  JMP L_JMP_($4E0A)_($4D77) OK
//------------------------------
L_BRS_($4D7A)_($4D70) OK
//------------------------------
$4D7A  AD 6B 4A  LDA $4A6B 
$4D7D  29 20     AND #$20
$4D7F  F0 F6     BEQ L_BRS_($4D77)_($4D7F) OK
$4D81  B1 7E     LDA ($7E),Y 
$4D83  18        CLC 
$4D84  A0 06     LDY #$06
$4D86  71 7E     ADC ($7E),Y 
//------------------------------
L_JMP_($4D88)_($4D74) OK
//------------------------------
$4D88  20 61 50  JSR L_JSR_($5061)_($4D88) OK
$4D8B  8D 69 4A  STA $4A69 
$4D8E  38        SEC 
$4D8F  ED 32 1C  SBC $1C32 
$4D92  85 88     STA $88 
$4D94  A5 83     LDA $83 
$4D96  8D 6A 4A  STA $4A6A 
$4D99  ED 33 1C  SBC $1C33 
$4D9C  85 89     STA $89 
$4D9E  AD 2F 4A  LDA $4A2F 
$4DA1  85 8C     STA $8C 
$4DA3  AD 30 4A  LDA $4A30 
$4DA6  85 8D     STA $8D 
$4DA8  20 31 1D  JSR L_JSR_($1D31)_($4DA8) OK
$4DAB  A5 82     LDA $82 
$4DAD  85 88     STA $88 
$4DAF  A5 83     LDA $83 
$4DB1  85 89     STA $89 
$4DB3  A5 84     LDA $84 
$4DB5  85 8A     STA $8A 
$4DB7  A5 85     LDA $85 
$4DB9  85 8B     STA $8B 
$4DBB  AD 33 4A  LDA $4A33 
$4DBE  85 8C     STA $8C 
$4DC0  AD 34 4A  LDA $4A34 
$4DC3  85 8D     STA $8D 
$4DC5  20 DE 1E  JSR L_JSR_($1EDE)_($4DC5) OK
$4DC8  AD 2E 1C  LDA $1C2E 
$4DCB  18        CLC 
$4DCC  65 88     ADC $88 
$4DCE  8D 65 4A  STA $4A65 
$4DD1  AD 2F 1C  LDA $1C2F 
$4DD4  65 89     ADC $89 
$4DD6  8D 66 4A  STA $4A66 
$4DD9  AD 6B 4A  LDA $4A6B 
$4DDC  29 10     AND #$10
$4DDE  F0 15     BEQ L_BRS_($4DF5)_($4DDE) OK
$4DE0  AD 69 4A  LDA $4A69 
$4DE3  38        SEC 
$4DE4  ED 32 15  SBC $1532 
$4DE7  8D 69 4A  STA $4A69 
$4DEA  AD 6A 4A  LDA $4A6A 
$4DED  E9 00     SBC #$00
$4DEF  8D 6A 4A  STA $4A6A 
$4DF2  4C 20 4C  JMP L_JMP_($4C20)_($4DF2) OK
//------------------------------
L_BRS_($4DF5)_($4DDE) OK
//------------------------------
$4DF5  AD 69 4A  LDA $4A69 
$4DF8  18        CLC 
$4DF9  6D 32 15  ADC $1532 
$4DFC  8D 69 4A  STA $4A69 
$4DFF  AD 6A 4A  LDA $4A6A 
$4E02  69 00     ADC #$00
$4E04  8D 6A 4A  STA $4A6A 
$4E07  4C 20 4C  JMP L_JMP_($4C20)_($4E07) OK
//------------------------------
L_JMP_($4E0A)_($4BD6) OK
L_JMP_($4E0A)_($4C9A) OK
L_JMP_($4E0A)_($4D77) OK
//------------------------------
$4E0A  20 FF 51  JSR L_JSR_($51FF)_($4E0A) OK
$4E0D  AD 32 15  LDA $1532 
$4E10  D0 05     BNE L_BRS_($4E17)_($4E10) OK
$4E12  A2 01     LDX #$01
$4E14  4C 34 4F  JMP L_JMP_($4F34)_($4E14) OK
//------------------------------
L_BRS_($4E17)_($4E10) OK
//------------------------------
$4E17  AD 6F 4A  LDA $4A6F 
$4E1A  D0 19     BNE L_BRS_($4E35)_($4E1A) OK
//------------------------------
L_BRS_($4E1C)_($4E50) OK
//------------------------------
$4E1C  A2 05     LDX #$05
//------------------------------
L_BRS_($4E1E)_($4E25) OK
//------------------------------
$4E1E  BD 5F 4A  LDA $4A5F,X 
$4E21  9D 36 15  STA $1536,X 
$4E24  CA        DEX 
$4E25  10 F7     BPL L_BRS_($4E1E)_($4E25) OK
$4E27  AD 70 15  LDA $1570 
$4E2A  D0 75     BNE L_BRS_($4EA1)_($4E2A) OK
$4E2C  AD 74 4A  LDA $4A74 
$4E2F  8D 70 15  STA $1570 
$4E32  4C A1 4E  JMP L_JMP_($4EA1)_($4E32) OK
//------------------------------
L_BRS_($4E35)_($4E1A) OK
//------------------------------
$4E35  A2 65     LDX #$65
$4E37  A0 4A     LDY #$4A
$4E39  20 18 50  JSR L_JSR_($5018)_($4E39) OK
$4E3C  A5 83     LDA $83 
$4E3E  48        PHA 
$4E3F  A5 82     LDA $82 
//------------------------------
L_JSR_($4E41)_($19E5) OK
//------------------------------
$4E41  48        PHA 
$4E42  A2 53     LDX #$53
//------------------------------
L_JSR_($4E45)_($1A2A) BAD
L_JMP_($4E45)_($7301) BAD
//------------------------------
$4E44  A0 4A     LDY #$4A
$4E46  20 18 50  JSR L_JSR_($5018)_($4E46) OK
$4E49  68        PLA 
$4E4A  38        SEC 
$4E4B  E5 82     SBC $82 
$4E4D  68        PLA 
$4E4E  E5 83     SBC $83 
$4E50  10 CA     BPL L_BRS_($4E1C)_($4E50) OK
$4E52  A9 00     LDA #$00
$4E54  8D 47 15  STA $1547 
$4E57  A2 05     LDX #$05
//------------------------------
L_BRS_($4E59)_($4E60) OK
//------------------------------
$4E59  BD 65 4A  LDA $4A65,X 
$4E5C  9D 36 15  STA $1536,X 
$4E5F  CA        DEX 
$4E60  10 F7     BPL L_BRS_($4E59)_($4E60) OK
$4E62  AD 67 4A  LDA $4A67 
$4E65  38        SEC 
$4E66  ED 70 4A  SBC $4A70 
$4E69  8D 67 4A  STA $4A67 
$4E6C  8D 38 15  STA $1538 
$4E6F  AD 68 4A  LDA $4A68 
$4E72  ED 71 4A  SBC $4A71 
$4E75  8D 68 4A  STA $4A68 
$4E78  8D 39 15  STA $1539 
$4E7B  AD 71 4A  LDA $4A71 
$4E7E  0E 70 4A  ASL $4A70 
$4E81  2A        ROL A 
$4E82  0E 70 4A  ASL $4A70 
$4E85  2A        ROL A 
$4E86  CD 43 1C  CMP $1C43 
$4E89  F0 08     BEQ L_BRS_($4E93)_($4E89) OK
$4E8B  30 06     BMI L_BRS_($4E93)_($4E8B) OK
$4E8D  20 21 79  JSR L_JSR_($7921)_($4E8D) OK
$4E90  4C CA 4E  JMP L_JMP_($4ECA)_($4E90) OK
//------------------------------
L_BRS_($4E93)_($4E89) OK
L_BRS_($4E93)_($4E8B) OK
//------------------------------
$4E93  AD 74 4A  LDA $4A74 
$4E96  8D 70 15  STA $1570 
$4E99  A9 0C     LDA #$0C
$4E9B  8D 49 15  STA $1549 
$4E9E  4C CA 4E  JMP L_JMP_($4ECA)_($4E9E) OK
//------------------------------
L_BRS_($4EA1)_($4E2A) OK
L_JMP_($4EA1)_($4E32) OK
//------------------------------
$4EA1  AD 46 1C  LDA $1C46 
$4EA4  D0 24     BNE L_BRS_($4ECA)_($4EA4) OK
$4EA6  AD 5C 4A  LDA $4A5C 
$4EA9  30 1F     BMI L_BRS_($4ECA)_($4EA9) OK
$4EAB  AD 5B 4A  LDA $4A5B 
$4EAE  38        SEC 
$4EAF  ED 38 15  SBC $1538 
$4EB2  85 82     STA $82 
$4EB4  AD 5C 4A  LDA $4A5C 
$4EB7  ED 39 15  SBC $1539 
$4EBA  06 82     ASL $82 
$4EBC  2A        ROL A 
$4EBD  06 82     ASL $82 
$4EBF  2A        ROL A 
$4EC0  CD 44 1C  CMP $1C44 
$4EC3  F0 02     BEQ L_BRS_($4EC7)_($4EC3) OK
$4EC5  B0 03     BCS L_BRS_($4ECA)_($4EC5) OK
//------------------------------
L_BRS_($4EC7)_($4EC3) OK
//------------------------------
$4EC7  20 35 4F  JSR L_JSR_($4F35)_($4EC7) OK
//------------------------------
L_JMP_($4ECA)_($4AE7) OK
L_JMP_($4ECA)_($4E90) OK
L_JMP_($4ECA)_($4E9E) OK
L_BRS_($4ECA)_($4EA4) OK
L_BRS_($4ECA)_($4EA9) OK
L_BRS_($4ECA)_($4EC5) OK
//------------------------------
$4ECA  A9 00     LDA #$00
$4ECC  8D 35 17  STA $1735 
$4ECF  AD 37 15  LDA $1537 
$4ED2  30 1F     BMI L_BRS_($4EF3)_($4ED2) OK
$4ED4  AD 36 15  LDA $1536 
$4ED7  38        SEC 
$4ED8  E9 C0     SBC #$C0
$4EDA  AD 37 15  LDA $1537 
$4EDD  E9 1F     SBC #$1F
$4EDF  10 12     BPL L_BRS_($4EF3)_($4EDF) OK
$4EE1  AD 3B 15  LDA $153B 
$4EE4  30 0D     BMI L_BRS_($4EF3)_($4EE4) OK
$4EE6  AD 3A 15  LDA $153A 
$4EE9  38        SEC 
$4EEA  E9 C0     SBC #$C0
$4EEC  AD 3B 15  LDA $153B 
$4EEF  E9 1F     SBC #$1F
$4EF1  30 03     BMI L_BRS_($4EF6)_($4EF1) OK
//------------------------------
L_BRS_($4EF3)_($4ED2) OK
L_BRS_($4EF3)_($4EDF) OK
L_BRS_($4EF3)_($4EE4) OK
//------------------------------
$4EF3  EE 35 17  INC $1735 
//------------------------------
L_BRS_($4EF6)_($4EF1) OK
//------------------------------
$4EF6  A2 00     LDX #$00
$4EF8  AD 36 15  LDA $1536 
$4EFB  CD 2E 1C  CMP $1C2E 
$4EFE  D0 28     BNE L_BRS_($4F28)_($4EFE) OK
$4F00  AD 37 15  LDA $1537 
$4F03  CD 2F 1C  CMP $1C2F 
$4F06  D0 20     BNE L_BRS_($4F28)_($4F06) OK
$4F08  AD 38 15  LDA $1538 
$4F0B  CD 30 1C  CMP $1C30 
$4F0E  D0 18     BNE L_BRS_($4F28)_($4F0E) OK
$4F10  AD 39 15  LDA $1539 
$4F13  CD 31 1C  CMP $1C31 
$4F16  D0 10     BNE L_BRS_($4F28)_($4F16) OK
$4F18  AD 3A 15  LDA $153A 
$4F1B  CD 32 1C  CMP $1C32 
$4F1E  D0 08     BNE L_BRS_($4F28)_($4F1E) OK
//------------------------------
L_JSR_($4F20)_($71B8) OK
//------------------------------
$4F20  AD 3B 15  LDA $153B 
$4F23  CD 33 1C  CMP $1C33 
$4F26  F0 0C     BEQ L_BRS_($4F34)_($4F26) OK
//------------------------------
L_BRS_($4F28)_($4EFE) OK
L_BRS_($4F28)_($4F06) OK
L_BRS_($4F28)_($4F0E) OK
L_BRS_($4F28)_($4F16) OK
L_BRS_($4F28)_($4F1E) OK
//------------------------------
$4F28  E8        INX 
$4F29  A0 05     LDY #$05
//------------------------------
L_BRS_($4F2B)_($4F32) OK
//------------------------------
$4F2B  B9 36 15  LDA $1536,Y 
$4F2E  99 2E 1C  STA $1C2E,Y 
$4F31  88        DEY 
$4F32  10 F7     BPL L_BRS_($4F2B)_($4F32) OK
//------------------------------
L_JMP_($4F34)_($4AEC) OK
L_JMP_($4F34)_($4BD3) OK
L_JMP_($4F34)_($4E14) OK
L_BRS_($4F34)_($4F26) OK
L_JMP_($4F34)_($50F7) OK
//------------------------------
$4F34  60        RTS 
//------------------------------
L_JSR_($4F35)_($4EC7) OK
//------------------------------
$4F35  AE 49 1C  LDX $1C49 
$4F38  F0 0D     BEQ L_BRS_($4F47)_($4F38) OK
$4F3A  AD 4A 1C  LDA $1C4A 
$4F3D  85 7E     STA $7E 
$4F3F  AD 4B 1C  LDA $1C4B 
//------------------------------
L_JSR_($4F43)_($1A1C) BAD
L_JSR_($4F42)_($8987) OK
//------------------------------
$4F42  85 7F     STA $7F 
//------------------------------
L_JSR_($4F46)_($19CB) BAD
L_JSR_($4F46)_($842A) BAD
//------------------------------
$4F44  20 72 4F  JSR L_JSR_($4F72)_($4F44) OK
//------------------------------
L_JSR_($4F48)_($19A7) BAD
L_BRS_($4F47)_($4F38) OK
//------------------------------
$4F47  AE 4B 15  LDX $154B 
$4F4A  F0 0D     BEQ L_BRS_($4F59)_($4F4A) OK
//------------------------------
L_JSR_($4F4E)_($1A27) BAD
//------------------------------
$4F4C  AD 4C 15  LDA $154C 
$4F4F  85 7E     STA $7E 
$4F51  AD 4D 15  LDA $154D 
//------------------------------
L_JSR_($4F54)_($196B) OK
L_JSR_($4F54)_($1994) OK
L_JSR_($4F54)_($19AB) OK
L_JSR_($4F54)_($1A13) OK
L_JSR_($4F54)_($1A19) OK
//------------------------------
$4F54  85 7F     STA $7F 
$4F56  20 72 4F  JSR L_JSR_($4F72)_($4F56) OK
//------------------------------
L_BRS_($4F59)_($4F4A) OK
//------------------------------
$4F59  A9 00     LDA #$00
$4F5B  8D 47 15  STA $1547 
$4F5E  A2 05     LDX #$05
//------------------------------
L_BRS_($4F60)_($4F67) OK
//------------------------------
$4F60  BD 59 4A  LDA $4A59,X 
$4F63  9D 36 15  STA $1536,X 
$4F66  CA        DEX 
$4F67  10 F7     BPL L_BRS_($4F60)_($4F67) OK
$4F69  A9 0C     LDA #$0C
$4F6B  8D 49 15  STA $1549 
//------------------------------
L_JMP_($4F6E)_($5004) OK
//------------------------------
$4F6E  60        RTS 
//------------------------------
L_BRS_($4F6F)_($4F78) OK
//------------------------------
$4F6F  4C 07 50  JMP L_JMP_($5007)_($4F6F) OK
//------------------------------
L_JSR_($4F72)_($4F44) OK
L_JSR_($4F72)_($4F56) OK
//------------------------------
$4F72  A0 00     LDY #$00
$4F74  B1 7E     LDA ($7E),Y 
$4F76  29 40     AND #$40
$4F78  D0 F5     BNE L_BRS_($4F6F)_($4F78) OK
$4F7A  A0 02     LDY #$02
$4F7C  B1 7E     LDA ($7E),Y 
$4F7E  20 61 50  JSR L_JSR_($5061)_($4F7E) OK
$4F81  38        SEC 
$4F82  ED 6C 4A  SBC $4A6C 
$4F85  85 82     STA $82 
$4F87  A5 83     LDA $83 
$4F89  ED 6D 4A  SBC $4A6D 
$4F8C  85 83     STA $83 
$4F8E  38        SEC 
$4F8F  A5 82     LDA $82 
$4F91  ED 5B 4A  SBC $4A5B 
$4F94  A5 83     LDA $83 
$4F96  ED 5C 4A  SBC $4A5C 
$4F99  10 6C     BPL L_BRS_($5007)_($4F99) OK
$4F9B  B1 7E     LDA ($7E),Y 
$4F9D  18        CLC 
$4F9E  A0 05     LDY #$05
$4FA0  71 7E     ADC ($7E),Y 
$4FA2  20 61 50  JSR L_JSR_($5061)_($4FA2) OK
$4FA5  AD 5B 4A  LDA $4A5B 
$4FA8  38        SEC 
$4FA9  E5 82     SBC $82 
$4FAB  AD 5C 4A  LDA $4A5C 
$4FAE  E5 83     SBC $83 
$4FB0  10 55     BPL L_BRS_($5007)_($4FB0) OK
$4FB2  A0 01     LDY #$01
$4FB4  B1 7E     LDA ($7E),Y 
$4FB6  20 61 50  JSR L_JSR_($5061)_($4FB6) OK
$4FB9  AD 59 4A  LDA $4A59 
$4FBC  38        SEC 
$4FBD  E5 82     SBC $82 
$4FBF  AD 5A 4A  LDA $4A5A 
$4FC2  E5 83     SBC $83 
$4FC4  30 41     BMI L_BRS_($5007)_($4FC4) OK
$4FC6  B1 7E     LDA ($7E),Y 
$4FC8  18        CLC 
$4FC9  A0 04     LDY #$04
$4FCB  71 7E     ADC ($7E),Y 
$4FCD  20 61 50  JSR L_JSR_($5061)_($4FCD) OK
$4FD0  ED 59 4A  SBC $4A59 
$4FD3  A5 83     LDA $83 
$4FD5  ED 5A 4A  SBC $4A5A 
$4FD8  30 2D     BMI L_BRS_($5007)_($4FD8) OK
$4FDA  A0 03     LDY #$03
$4FDC  B1 7E     LDA ($7E),Y 
$4FDE  20 61 50  JSR L_JSR_($5061)_($4FDE) OK
$4FE1  AD 5D 4A  LDA $4A5D 
$4FE4  38        SEC 
$4FE5  E5 82     SBC $82 
$4FE7  AD 5E 4A  LDA $4A5E 
$4FEA  E5 83     SBC $83 
$4FEC  30 19     BMI L_BRS_($5007)_($4FEC) OK
$4FEE  B1 7E     LDA ($7E),Y 
$4FF0  18        CLC 
$4FF1  A0 06     LDY #$06
$4FF3  71 7E     ADC ($7E),Y 
$4FF5  20 61 50  JSR L_JSR_($5061)_($4FF5) OK
$4FF8  ED 5D 4A  SBC $4A5D 
$4FFB  A5 83     LDA $83 
$4FFD  ED 5E 4A  SBC $4A5E 
//------------------------------
L_JMP_($5000)_($CA10) OK
//------------------------------
$5000  30 05     BMI L_BRS_($5007)_($5000) OK
$5002  68        PLA 
$5003  68        PLA 
$5004  4C 6E 4F  JMP L_JMP_($4F6E)_($5004) OK
//------------------------------
L_JMP_($5007)_($4F6F) OK
L_BRS_($5007)_($4F99) OK
L_BRS_($5007)_($4FB0) OK
L_BRS_($5007)_($4FC4) OK
L_BRS_($5007)_($4FD8) OK
L_BRS_($5007)_($4FEC) OK
L_BRS_($5007)_($5000) OK
//------------------------------
$5007  A0 08     LDY #$08
$5009  B1 7E     LDA ($7E),Y 
$500B  18        CLC 
$500C  65 7E     ADC $7E 
$500E  85 7E     STA $7E 
$5010  90 02     BCC L_BRS_($5014)_($5010) OK
$5012  E6 7F     INC $7F 
//------------------------------
L_BRS_($5014)_($5010) OK
L_BRS_($5014)_($5015) OK
//------------------------------
$5014  CA        DEX 
$5015  D0 FD     BNE L_BRS_($5014)_($5015) OK
$5017  60        RTS 
//------------------------------
L_JSR_($5018)_($4E39) OK
L_JSR_($5018)_($4E46) OK
L_JSR_($5018)_($5072) OK
L_JSR_($5018)_($507F) OK
//------------------------------
$5018  8E 2B 50  STX $502B 
$501B  8E 35 50  STX $5035 
$501E  8C 2C 50  STY $502C 
$5021  8C 36 50  STY $5036 
$5024  A2 00     LDX #$00
$5026  86 82     STX $82 
$5028  86 83     STX $83 
//------------------------------
L_BRS_($502A)_($505E) OK
//------------------------------
$502A  BD FF FF  LDA $FFFF,X 
$502D  38        SEC 
$502E  FD 2E 1C  SBC $1C2E,X 
$5031  85 84     STA $84 
$5033  E8        INX 
$5034  BD FF FF  LDA $FFFF,X 
$5037  FD 2E 1C  SBC $1C2E,X 
$503A  85 85     STA $85 
$503C  10 10     BPL L_BRS_($504E)_($503C) OK
$503E  49 FF     EOR #$FF
$5040  85 85     STA $85 
$5042  A5 84     LDA $84 
$5044  49 FF     EOR #$FF
$5046  85 84     STA $84 
//------------------------------
L_JMP_($5049)_($195C) BAD
L_JMP_($5049)_($199E) BAD
L_JMP_($5049)_($89BB) BAD
//------------------------------
$5048  E6 84     INC $84 
$504A  D0 02     BNE L_BRS_($504E)_($504A) OK
$504C  E6 85     INC $85 
//------------------------------
L_BRS_($504E)_($503C) OK
L_BRS_($504E)_($504A) OK
//------------------------------
$504E  E8        INX 
$504F  A5 82     LDA $82 
$5051  18        CLC 
$5052  65 84     ADC $84 
$5054  85 82     STA $82 
$5056  A5 83     LDA $83 
$5058  65 85     ADC $85 
$505A  85 83     STA $83 
$505C  E0 06     CPX #$06
$505E  D0 CA     BNE L_BRS_($502A)_($505E) OK
$5060  60        RTS 
//------------------------------
L_JSR_($5061)_($4B2E) OK
L_JSR_($5061)_($4C3E) OK
L_JSR_($5061)_($4C53) OK
L_JSR_($5061)_($4C64) OK
L_JSR_($5061)_($4C79) OK
L_JSR_($5061)_($4CBC) OK
L_JSR_($5061)_($4D11) OK
L_JSR_($5061)_($4D28) OK
L_JSR_($5061)_($4D88) OK
L_JSR_($5061)_($4F7E) OK
L_JSR_($5061)_($4FA2) OK
L_JSR_($5061)_($4FB6) OK
L_JSR_($5061)_($4FCD) OK
L_JSR_($5061)_($4FDE) OK
L_JSR_($5061)_($4FF5) OK
L_JSR_($5061)_($5145) OK
L_JSR_($5061)_($515D) OK
L_JSR_($5061)_($5174) OK
L_JSR_($5061)_($5186) OK
L_JSR_($5061)_($519D) OK
L_JSR_($5061)_($5231) OK
L_JSR_($5061)_($5246) OK
L_JSR_($5061)_($525A) OK
L_JSR_($5061)_($526F) OK
L_JSR_($5061)_($5283) OK
L_JSR_($5061)_($5298) OK
L_JSR_($5061)_($52E0) OK
L_JSR_($5061)_($534C) OK
L_JSR_($5061)_($5379) OK
L_JSR_($5061)_($53F8) OK
L_JSR_($5061)_($5428) OK
L_JSR_($5061)_($54D0) OK
L_JSR_($5061)_($5536) OK
L_JSR_($5061)_($5563) OK
L_JSR_($5061)_($55E2) OK
L_JSR_($5061)_($560F) OK
L_JSR_($5061)_($5698) OK
L_JSR_($5061)_($5704) OK
L_JSR_($5061)_($5727) OK
L_JSR_($5061)_($579C) OK
L_JSR_($5061)_($57C2) OK
//------------------------------
$5061  85 83     STA $83 
$5063  A9 00     LDA #$00
$5065  46 83     LSR $83 
$5067  6A        ROR A 
$5068  46 83     LSR $83 
$506A  6A        ROR A 
$506B  85 82     STA $82 
$506D  60        RTS 
//------------------------------
L_JSR_($506E)_($5495) OK
L_JSR_($506E)_($5660) OK
L_JSR_($506E)_($5825) OK
//------------------------------
$506E  A2 53     LDX #$53
$5070  A0 4A     LDY #$4A
$5072  20 18 50  JSR L_JSR_($5018)_($5072) OK
$5075  A5 83     LDA $83 
$5077  48        PHA 
$5078  A5 82     LDA $82 
$507A  48        PHA 
$507B  A2 41     LDX #$41
$507D  A0 4A     LDY #$4A
$507F  20 18 50  JSR L_JSR_($5018)_($507F) OK
$5082  68        PLA 
$5083  38        SEC 
$5084  E5 82     SBC $82 
$5086  85 82     STA $82 
$5088  68        PLA 
$5089  E5 83     SBC $83 
$508B  85 83     STA $83 
$508D  30 6B     BMI L_BRS_($50FA)_($508D) OK
$508F  A2 02     LDX #$02
$5091  A0 00     LDY #$00
$5093  B1 7E     LDA ($7E),Y 
$5095  29 0F     AND #$0F
$5097  C9 03     CMP #$03
$5099  F0 05     BEQ L_BRS_($50A0)_($5099) OK
$509B  C9 0A     CMP #$0A
$509D  B0 01     BCS L_BRS_($50A0)_($509D) OK
$509F  CA        DEX 
//------------------------------
L_BRS_($50A0)_($5099) OK
L_BRS_($50A0)_($509D) OK
//------------------------------
$50A0  A5 82     LDA $82 
$50A2  05 83     ORA $83
$50A4  D0 1E     BNE L_BRS_($50C4)_($50A4) OK
$50A6  AD 6E 4A  LDA $4A6E 
$50A9  F0 19     BEQ L_BRS_($50C4)_($50A9) OK
$50AB  EC 6E 4A  CPX $4A6E 
$50AE  F0 05     BEQ L_BRS_($50B5)_($50AE) OK
$50B0  90 48     BCC L_BRS_($50FA)_($50B0) OK
$50B2  4C C4 50  JMP L_JMP_($50C4)_($50B2) OK
//------------------------------
L_BRS_($50B5)_($50AE) OK
//------------------------------
$50B5  AD 5B 4A  LDA $4A5B 
$50B8  38        SEC 
$50B9  ED 49 4A  SBC $4A49 
$50BC  AD 5C 4A  LDA $4A5C 
$50BF  ED 4A 4A  SBC $4A4A 
$50C2  10 36     BPL L_BRS_($50FA)_($50C2) OK
//------------------------------
L_BRS_($50C4)_($50A4) OK
L_BRS_($50C4)_($50A9) OK
L_JMP_($50C4)_($50B2) OK
//------------------------------
$50C4  8E 6E 4A  STX $4A6E 
$50C7  A0 07     LDY #$07
$50C9  B1 7E     LDA ($7E),Y 
$50CB  8D 70 15  STA $1570 
$50CE  A9 01     LDA #$01
$50D0  8D 47 15  STA $1547 
$50D3  A2 05     LDX #$05
//------------------------------
L_BRS_($50D5)_($50E8) OK
//------------------------------
$50D5  BD 47 4A  LDA $4A47,X 
$50D8  9D 59 4A  STA $4A59,X 
$50DB  BD 4D 4A  LDA $4A4D,X 
$50DE  9D 5F 4A  STA $4A5F,X 
$50E1  BD 41 4A  LDA $4A41,X 
$50E4  9D 53 4A  STA $4A53,X 
$50E7  CA        DEX 
$50E8  10 EB     BPL L_BRS_($50D5)_($50E8) OK
$50EA  AD 32 15  LDA $1532 
$50ED  D0 0B     BNE L_BRS_($50FA)_($50ED) OK
$50EF  AA        TAX 
$50F0  68        PLA 
$50F1  68        PLA 
$50F2  68        PLA 
$50F3  68        PLA 
$50F4  68        PLA 
$50F5  68        PLA 
$50F6  68        PLA 
$50F7  4C 34 4F  JMP L_JMP_($4F34)_($50F7) OK
//------------------------------
L_BRS_($50FA)_($508D) OK
L_BRS_($50FA)_($50B0) OK
L_BRS_($50FA)_($50C2) OK
L_BRS_($50FA)_($50ED) OK
//------------------------------
$50FA  60        RTS 
//------------------------------
L_JSR_($50FB)_($4C20) OK
L_JSR_($50FB)_($4C92) OK
//------------------------------
$50FB  AD 67 4A  LDA $4A67 
$50FE  8D 70 4A  STA $4A70 
//------------------------------
L_JSR_($5102)_($6EFB) BAD
//------------------------------
$5101  AD 68 4A  LDA $4A68 
$5104  8D 71 4A  STA $4A71 
$5107  A9 00     LDA #$00
$5109  8D 74 4A  STA $4A74 
$510C  AE 49 1C  LDX $1C49 
$510F  F0 0D     BEQ L_BRS_($511E)_($510F) OK
$5111  AD 4A 1C  LDA $1C4A 
$5114  85 7E     STA $7E 
$5116  AD 4B 1C  LDA $1C4B 
$5119  85 7F     STA $7F 
$511B  20 34 51  JSR L_JSR_($5134)_($511B) OK
//------------------------------
L_BRS_($511E)_($510F) OK
//------------------------------
$511E  AE 4B 15  LDX $154B 
$5121  F0 0D     BEQ L_BRS_($5130)_($5121) OK
$5123  AD 4C 15  LDA $154C 
$5126  85 7E     STA $7E 
$5128  AD 4D 15  LDA $154D 
$512B  85 7F     STA $7F 
$512D  20 34 51  JSR L_JSR_($5134)_($512D) OK
//------------------------------
L_BRS_($5130)_($5121) OK
//------------------------------
$5130  60        RTS 
//------------------------------
L_BRS_($5131)_($513A) OK
L_BRS_($5131)_($5157) OK
L_BRS_($5131)_($516B) OK
//------------------------------
$5131  4C EB 51  JMP L_JMP_($51EB)_($5131) OK
//------------------------------
L_JSR_($5134)_($511B) OK
L_JSR_($5134)_($512D) OK
L_JMP_($5134)_($51FB) OK
//------------------------------
$5134  A0 00     LDY #$00
$5136  B1 7E     LDA ($7E),Y 
$5138  29 40     AND #$40
$513A  D0 F5     BNE L_BRS_($5131)_($513A) OK
$513C  A0 02     LDY #$02
$513E  B1 7E     LDA ($7E),Y 
$5140  18        CLC 
$5141  A0 05     LDY #$05
$5143  71 7E     ADC ($7E),Y 
$5145  20 61 50  JSR L_JSR_($5061)_($5145) OK
$5148  AD 67 4A  LDA $4A67 
$514B  38        SEC 
$514C  E5 82     SBC $82 
$514E  85 84     STA $84 
$5150  AD 68 4A  LDA $4A68 
$5153  E5 83     SBC $83 
$5155  85 85     STA $85 
$5157  30 D8     BMI L_BRS_($5131)_($5157) OK
$5159  A0 01     LDY #$01
$515B  B1 7E     LDA ($7E),Y 
$515D  20 61 50  JSR L_JSR_($5061)_($515D) OK
$5160  AD 65 4A  LDA $4A65 
$5163  38        SEC 
$5164  E5 82     SBC $82 
$5166  AD 66 4A  LDA $4A66 
$5169  E5 83     SBC $83 
$516B  30 C4     BMI L_BRS_($5131)_($516B) OK
$516D  B1 7E     LDA ($7E),Y 
$516F  18        CLC 
$5170  A0 04     LDY #$04
$5172  71 7E     ADC ($7E),Y 
$5174  20 61 50  JSR L_JSR_($5061)_($5174) OK
$5177  38        SEC 
$5178  ED 65 4A  SBC $4A65 
$517B  A5 83     LDA $83 
$517D  ED 66 4A  SBC $4A66 
$5180  30 69     BMI L_BRS_($51EB)_($5180) OK
$5182  A0 03     LDY #$03
$5184  B1 7E     LDA ($7E),Y 
$5186  20 61 50  JSR L_JSR_($5061)_($5186) OK
$5189  AD 69 4A  LDA $4A69 
$518C  38        SEC 
$518D  E5 82     SBC $82 
$518F  AD 6A 4A  LDA $4A6A 
$5192  E5 83     SBC $83 
$5194  30 55     BMI L_BRS_($51EB)_($5194) OK
$5196  B1 7E     LDA ($7E),Y 
$5198  18        CLC 
$5199  A0 06     LDY #$06
$519B  71 7E     ADC ($7E),Y 
$519D  20 61 50  JSR L_JSR_($5061)_($519D) OK
$51A0  38        SEC 
$51A1  ED 69 4A  SBC $4A69 
$51A4  A5 83     LDA $83 
$51A6  ED 6A 4A  SBC $4A6A 
$51A9  30 40     BMI L_BRS_($51EB)_($51A9) OK
$51AB  AD 70 4A  LDA $4A70 
$51AE  38        SEC 
$51AF  E5 84     SBC $84 
$51B1  85 82     STA $82 
$51B3  AD 71 4A  LDA $4A71 
$51B6  E5 85     SBC $85 
$51B8  85 83     STA $83 
$51BA  30 2F     BMI L_BRS_($51EB)_($51BA) OK
$51BC  A5 84     LDA $84 
$51BE  8D 70 4A  STA $4A70 
$51C1  A5 85     LDA $85 
$51C3  8D 71 4A  STA $4A71 
$51C6  A5 82     LDA $82 
$51C8  05 83     ORA $83
$51CA  D0 0E     BNE L_BRS_($51DA)_($51CA) OK
$51CC  A0 00     LDY #$00
$51CE  B1 7E     LDA ($7E),Y 
$51D0  29 0F     AND #$0F
$51D2  C9 03     CMP #$03
$51D4  F0 04     BEQ L_BRS_($51DA)_($51D4) OK
$51D6  C9 0A     CMP #$0A
$51D8  90 11     BCC L_BRS_($51EB)_($51D8) OK
//------------------------------
L_BRS_($51DA)_($51CA) OK
L_BRS_($51DA)_($51D4) OK
//------------------------------
$51DA  A5 7E     LDA $7E 
$51DC  8D 72 4A  STA $4A72 
$51DF  A5 7F     LDA $7F 
$51E1  8D 73 4A  STA $4A73 
$51E4  A0 07     LDY #$07
$51E6  B1 7E     LDA ($7E),Y 
$51E8  8D 74 4A  STA $4A74 
//------------------------------
L_JMP_($51EB)_($5131) OK
L_BRS_($51EB)_($5180) OK
L_BRS_($51EB)_($5194) OK
L_BRS_($51EB)_($51A9) OK
L_BRS_($51EB)_($51BA) OK
L_BRS_($51EB)_($51D8) OK
//------------------------------
$51EB  A0 08     LDY #$08
$51ED  B1 7E     LDA ($7E),Y 
$51EF  18        CLC 
$51F0  65 7E     ADC $7E 
$51F2  85 7E     STA $7E 
$51F4  90 02     BCC L_BRS_($51F8)_($51F4) OK
$51F6  E6 7F     INC $7F 
//------------------------------
L_BRS_($51F8)_($51F4) OK
//------------------------------
$51F8  CA        DEX 
$51F9  F0 03     BEQ L_BRS_($51FE)_($51F9) OK
$51FB  4C 34 51  JMP L_JMP_($5134)_($51FB) OK
//------------------------------
L_BRS_($51FE)_($51F9) OK
//------------------------------
$51FE  60        RTS 
//------------------------------
L_JSR_($51FF)_($4E0A) OK
//------------------------------
$51FF  AE 49 1C  LDX $1C49 
$5202  F0 0D     BEQ L_BRS_($5211)_($5202) OK
$5204  AD 4A 1C  LDA $1C4A 
$5207  85 7E     STA $7E 
$5209  AD 4B 1C  LDA $1C4B 
$520C  85 7F     STA $7F 
$520E  20 24 52  JSR L_JSR_($5224)_($520E) OK
//------------------------------
L_BRS_($5211)_($5202) OK
//------------------------------
$5211  AE 4B 15  LDX $154B 
$5214  F0 0D     BEQ L_BRS_($5223)_($5214) OK
$5216  AD 4C 15  LDA $154C 
$5219  85 7E     STA $7E 
$521B  AD 4D 15  LDA $154D 
$521E  85 7F     STA $7F 
//------------------------------
L_JSR_($5220)_($19B5) OK
L_JSR_($5220)_($1A35) OK
//------------------------------
$5220  20 24 52  JSR L_JSR_($5224)_($5220) OK
//------------------------------
L_BRS_($5223)_($5214) OK
//------------------------------
$5223  60        RTS 
//------------------------------
L_JSR_($5224)_($520E) OK
L_JSR_($5224)_($5220) OK
L_JMP_($5224)_($583A) OK
//------------------------------
$5224  8A        TXA 
$5225  48        PHA 
$5226  A0 00     LDY #$00
$5228  B1 7E     LDA ($7E),Y 
$522A  29 40     AND #$40
$522C  D0 7A     BNE L_BRS_($52A8)_($522C) OK
$522E  C8        INY 
$522F  B1 7E     LDA ($7E),Y 
$5231  20 61 50  JSR L_JSR_($5061)_($5231) OK
$5234  38        SEC 
$5235  ED 35 4A  SBC $4A35 
$5238  A5 83     LDA $83 
$523A  ED 36 4A  SBC $4A36 
$523D  10 69     BPL L_BRS_($52A8)_($523D) OK
$523F  B1 7E     LDA ($7E),Y 
$5241  18        CLC 
$5242  A0 04     LDY #$04
//------------------------------
L_JSR_($5245)_($8437) BAD
//------------------------------
$5244  71 7E     ADC ($7E),Y 
$5246  20 61 50  JSR L_JSR_($5061)_($5246) OK
$5249  AD 3B 4A  LDA $4A3B 
$524C  38        SEC 
$524D  E5 82     SBC $82 
$524F  AD 3C 4A  LDA $4A3C 
$5252  E5 83     SBC $83 
//------------------------------
L_JMP_($5255)_($194F) BAD
//------------------------------
$5254  10 52     BPL L_BRS_($52A8)_($5254) OK
$5256  A0 02     LDY #$02
$5258  B1 7E     LDA ($7E),Y 
$525A  20 61 50  JSR L_JSR_($5061)_($525A) OK
$525D  38        SEC 
$525E  ED 37 4A  SBC $4A37 
$5261  A5 83     LDA $83 
$5263  ED 38 4A  SBC $4A38 
$5266  10 40     BPL L_BRS_($52A8)_($5266) OK
$5268  B1 7E     LDA ($7E),Y 
$526A  18        CLC 
$526B  A0 05     LDY #$05
$526D  71 7E     ADC ($7E),Y 
$526F  20 61 50  JSR L_JSR_($5061)_($526F) OK
$5272  AD 3D 4A  LDA $4A3D 
$5275  38        SEC 
$5276  E5 82     SBC $82 
$5278  AD 3E 4A  LDA $4A3E 
$527B  E5 83     SBC $83 
$527D  10 29     BPL L_BRS_($52A8)_($527D) OK
$527F  A0 03     LDY #$03
$5281  B1 7E     LDA ($7E),Y 
$5283  20 61 50  JSR L_JSR_($5061)_($5283) OK
$5286  38        SEC 
$5287  ED 39 4A  SBC $4A39 
$528A  A5 83     LDA $83 
$528C  ED 3A 4A  SBC $4A3A 
$528F  10 17     BPL L_BRS_($52A8)_($528F) OK
$5291  B1 7E     LDA ($7E),Y 
$5293  18        CLC 
$5294  A0 06     LDY #$06
$5296  71 7E     ADC ($7E),Y 
$5298  20 61 50  JSR L_JSR_($5061)_($5298) OK
$529B  AD 3F 4A  LDA $4A3F 
$529E  38        SEC 
$529F  E5 82     SBC $82 
$52A1  AD 40 4A  LDA $4A40 
$52A4  E5 83     SBC $83 
$52A6  30 03     BMI L_BRS_($52AB)_($52A6) OK
//------------------------------
L_BRS_($52A8)_($522C) OK
L_BRS_($52A8)_($523D) OK
L_BRS_($52A8)_($5254) OK
L_BRS_($52A8)_($5266) OK
L_BRS_($52A8)_($527D) OK
L_BRS_($52A8)_($528F) OK
//------------------------------
$52A8  4C 28 58  JMP L_JMP_($5828)_($52A8) OK
//------------------------------
L_BRS_($52AB)_($52A6) OK
//------------------------------
$52AB  AD 32 15  LDA $1532 
$52AE  85 84     STA $84 
$52B0  A9 00     LDA #$00
$52B2  85 85     STA $85 
$52B4  A0 01     LDY #$01
$52B6  AD 6B 4A  LDA $4A6B 
$52B9  29 01     AND #$01
$52BB  F0 0D     BEQ L_BRS_($52CA)_($52BB) OK
$52BD  B1 7E     LDA ($7E),Y 
$52BF  18        CLC 
$52C0  A0 04     LDY #$04
$52C2  71 7E     ADC ($7E),Y 
$52C4  4C E0 52  JMP L_JMP_($52E0)_($52C4) OK
//------------------------------
L_BRS_($52C7)_($52CF) OK
//------------------------------
$52C7  4C 9B 54  JMP L_JMP_($549B)_($52C7) OK
//------------------------------
L_BRS_($52CA)_($52BB) OK
//------------------------------
$52CA  AD 6B 4A  LDA $4A6B 
$52CD  29 02     AND #$02
$52CF  F0 F6     BEQ L_BRS_($52C7)_($52CF) OK
$52D1  A9 00     LDA #$00
$52D3  38        SEC 
$52D4  E5 84     SBC $84 
$52D6  85 84     STA $84 
$52D8  F0 04     BEQ L_BRS_($52DE)_($52D8) OK
$52DA  A9 FF     LDA #$FF
$52DC  85 85     STA $85 
//------------------------------
L_BRS_($52DE)_($52D8) OK
//------------------------------
$52DE  B1 7E     LDA ($7E),Y 
//------------------------------
L_JMP_($52E0)_($52C4) OK
//------------------------------
$52E0  20 61 50  JSR L_JSR_($5061)_($52E0) OK
$52E3  18        CLC 
$52E4  65 84     ADC $84 
$52E6  8D 41 4A  STA $4A41 
$52E9  A5 83     LDA $83 
$52EB  65 85     ADC $85 
$52ED  8D 42 4A  STA $4A42 
$52F0  AD 41 4A  LDA $4A41 
$52F3  38        SEC 
$52F4  ED 2E 1C  SBC $1C2E 
$52F7  85 88     STA $88 
$52F9  AD 42 4A  LDA $4A42 
$52FC  ED 2F 1C  SBC $1C2F 
$52FF  85 89     STA $89 
$5301  AD 33 4A  LDA $4A33 
$5304  85 8C     STA $8C 
$5306  AD 34 4A  LDA $4A34 
$5309  85 8D     STA $8D 
$530B  20 31 1D  JSR L_JSR_($1D31)_($530B) OK
$530E  A5 82     LDA $82 
$5310  85 88     STA $88 
$5312  A5 83     LDA $83 
$5314  85 89     STA $89 
$5316  A5 84     LDA $84 
$5318  85 8A     STA $8A 
$531A  A5 85     LDA $85 
$531C  85 8B     STA $8B 
//------------------------------
L_JSR_($5320)_($1954) BAD
L_JSR_($5320)_($1A79) BAD
L_JSR_($5320)_($7195) BAD
//------------------------------
$531E  AD 2F 4A  LDA $4A2F 
$5321  85 8C     STA $8C 
$5323  AD 30 4A  LDA $4A30 
$5326  85 8D     STA $8D 
$5328  20 DE 1E  JSR L_JSR_($1EDE)_($5328) OK
$532B  AD 32 1C  LDA $1C32 
$532E  18        CLC 
$532F  65 88     ADC $88 
$5331  8D 45 4A  STA $4A45 
$5334  8D 4B 4A  STA $4A4B 
$5337  8D 51 4A  STA $4A51 
$533A  AD 33 1C  LDA $1C33 
$533D  65 89     ADC $89 
$533F  8D 46 4A  STA $4A46 
$5342  8D 4C 4A  STA $4A4C 
$5345  8D 52 4A  STA $4A52 
$5348  A0 03     LDY #$03
$534A  B1 7E     LDA ($7E),Y 
$534C  20 61 50  JSR L_JSR_($5061)_($534C) OK
$534F  38        SEC 
$5350  ED 32 15  SBC $1532 
$5353  85 82     STA $82 
$5355  A5 83     LDA $83 
$5357  E9 00     SBC #$00
$5359  85 83     STA $83 
$535B  AD 45 4A  LDA $4A45 
$535E  38        SEC 
$535F  E5 82     SBC $82 
$5361  AD 46 4A  LDA $4A46 
$5364  E5 83     SBC $83 
$5366  10 0A     BPL L_BRS_($5372)_($5366) OK
$5368  AD 6B 4A  LDA $4A6B 
$536B  29 10     AND #$10
$536D  D0 30     BNE L_BRS_($539F)_($536D) OK
$536F  4C 9B 54  JMP L_JMP_($549B)_($536F) OK
//------------------------------
L_BRS_($5372)_($5366) OK
//------------------------------
$5372  B1 7E     LDA ($7E),Y 
$5374  18        CLC 
$5375  A0 06     LDY #$06
$5377  71 7E     ADC ($7E),Y 
$5379  20 61 50  JSR L_JSR_($5061)_($5379) OK
$537C  18        CLC 
$537D  6D 32 15  ADC $1532 
$5380  85 82     STA $82 
$5382  A5 83     LDA $83 
$5384  69 00     ADC #$00
$5386  85 83     STA $83 
$5388  AD 45 4A  LDA $4A45 
$538B  38        SEC 
$538C  E5 82     SBC $82 
$538E  AD 46 4A  LDA $4A46 
$5391  E5 83     SBC $83 
$5393  30 0D     BMI L_BRS_($53A2)_($5393) OK
$5395  AD 6B 4A  LDA $4A6B 
$5398  29 20     AND #$20
$539A  D0 03     BNE L_BRS_($539F)_($539A) OK
$539C  4C 9B 54  JMP L_JMP_($549B)_($539C) OK
//------------------------------
L_BRS_($539F)_($536D) OK
L_BRS_($539F)_($539A) OK
//------------------------------
$539F  4C 28 58  JMP L_JMP_($5828)_($539F) OK
//------------------------------
L_BRS_($53A2)_($5393) OK
//------------------------------
$53A2  AD 41 4A  LDA $4A41 
$53A5  38        SEC 
$53A6  ED 2E 1C  SBC $1C2E 
$53A9  85 88     STA $88 
$53AB  AD 42 4A  LDA $4A42 
$53AE  ED 2F 1C  SBC $1C2F 
$53B1  85 89     STA $89 
$53B3  AD 31 4A  LDA $4A31 
$53B6  85 8C     STA $8C 
$53B8  AD 32 4A  LDA $4A32 
$53BB  85 8D     STA $8D 
$53BD  20 31 1D  JSR L_JSR_($1D31)_($53BD) OK
$53C0  A5 82     LDA $82 
$53C2  85 88     STA $88 
$53C4  A5 83     LDA $83 
$53C6  85 89     STA $89 
$53C8  A5 84     LDA $84 
$53CA  85 8A     STA $8A 
$53CC  A5 85     LDA $85 
$53CE  85 8B     STA $8B 
$53D0  AD 2F 4A  LDA $4A2F 
$53D3  85 8C     STA $8C 
$53D5  AD 30 4A  LDA $4A30 
$53D8  85 8D     STA $8D 
$53DA  20 DE 1E  JSR L_JSR_($1EDE)_($53DA) OK
$53DD  AD 30 1C  LDA $1C30 
$53E0  18        CLC 
$53E1  65 88     ADC $88 
$53E3  8D 43 4A  STA $4A43 
$53E6  8D 4F 4A  STA $4A4F 
$53E9  AD 31 1C  LDA $1C31 
$53EC  65 89     ADC $89 
$53EE  8D 44 4A  STA $4A44 
$53F1  8D 50 4A  STA $4A50 
$53F4  A0 02     LDY #$02
$53F6  B1 7E     LDA ($7E),Y 
$53F8  20 61 50  JSR L_JSR_($5061)_($53F8) OK
$53FB  18        CLC 
$53FC  AD 43 4A  LDA $4A43 
$53FF  6D 6C 4A  ADC $4A6C 
$5402  85 84     STA $84 
$5404  AD 44 4A  LDA $4A44 
$5407  6D 6D 4A  ADC $4A6D 
$540A  85 85     STA $85 
$540C  A5 84     LDA $84 
$540E  38        SEC 
$540F  E5 82     SBC $82 
$5411  A5 85     LDA $85 
$5413  E5 83     SBC $83 
$5415  10 0A     BPL L_BRS_($5421)_($5415) OK
$5417  AD 6B 4A  LDA $4A6B 
$541A  29 04     AND #$04
$541C  D0 7A     BNE L_BRS_($5498)_($541C) OK
$541E  4C 9B 54  JMP L_JMP_($549B)_($541E) OK
//------------------------------
L_BRS_($5421)_($5415) OK
//------------------------------
$5421  B1 7E     LDA ($7E),Y 
$5423  18        CLC 
$5424  A0 05     LDY #$05
$5426  71 7E     ADC ($7E),Y 
$5428  20 61 50  JSR L_JSR_($5061)_($5428) OK
$542B  AD 43 4A  LDA $4A43 
$542E  38        SEC 
$542F  E5 82     SBC $82 
$5431  AD 44 4A  LDA $4A44 
$5434  E5 83     SBC $83 
$5436  30 0A     BMI L_BRS_($5442)_($5436) OK
$5438  AD 6B 4A  LDA $4A6B 
$543B  29 08     AND #$08
$543D  D0 59     BNE L_BRS_($5498)_($543D) OK
$543F  4C 9B 54  JMP L_JMP_($549B)_($543F) OK
//------------------------------
L_BRS_($5442)_($5436) OK
//------------------------------
$5442  A5 82     LDA $82 
$5444  8D 49 4A  STA $4A49 
$5447  A5 83     LDA $83 
$5449  8D 4A 4A  STA $4A4A 
$544C  EE 75 4A  INC $4A75 
$544F  AD 41 4A  LDA $4A41 
$5452  38        SEC 
$5453  ED 75 4A  SBC $4A75 
$5456  8D 47 4A  STA $4A47 
$5459  AD 42 4A  LDA $4A42 
$545C  E9 00     SBC #$00
$545E  8D 48 4A  STA $4A48 
$5461  AD 41 4A  LDA $4A41 
$5464  18        CLC 
$5465  6D 75 4A  ADC $4A75 
$5468  8D 4D 4A  STA $4A4D 
$546B  AD 42 4A  LDA $4A42 
$546E  69 00     ADC #$00
$5470  8D 4E 4A  STA $4A4E 
$5473  AD 6B 4A  LDA $4A6B 
$5476  29 01     AND #$01
$5478  D0 18     BNE L_BRS_($5492)_($5478) OK
$547A  AD 4D 4A  LDA $4A4D 
$547D  AE 47 4A  LDX $4A47 
$5480  8D 47 4A  STA $4A47 
$5483  8E 4D 4A  STX $4A4D 
$5486  AD 4E 4A  LDA $4A4E 
$5489  AE 48 4A  LDX $4A48 
$548C  8D 48 4A  STA $4A48 
$548F  8E 4E 4A  STX $4A4E 
//------------------------------
L_BRS_($5492)_($5478) OK
//------------------------------
$5492  CE 75 4A  DEC $4A75 
$5495  20 6E 50  JSR L_JSR_($506E)_($5495) OK
//------------------------------
L_BRS_($5498)_($541C) OK
L_BRS_($5498)_($543D) OK
//------------------------------
$5498  4C 28 58  JMP L_JMP_($5828)_($5498) OK
//------------------------------
L_JMP_($549B)_($52C7) OK
L_JMP_($549B)_($536F) OK
L_JMP_($549B)_($539C) OK
L_JMP_($549B)_($541E) OK
L_JMP_($549B)_($543F) OK
//------------------------------
$549B  AD 32 15  LDA $1532 
$549E  85 84     STA $84 
$54A0  A9 00     LDA #$00
$54A2  85 85     STA $85 
$54A4  A0 02     LDY #$02
$54A6  AD 6B 4A  LDA $4A6B 
$54A9  29 04     AND #$04
$54AB  F0 0D     BEQ L_BRS_($54BA)_($54AB) OK
$54AD  B1 7E     LDA ($7E),Y 
$54AF  18        CLC 
$54B0  A0 05     LDY #$05
$54B2  71 7E     ADC ($7E),Y 
$54B4  4C D0 54  JMP L_JMP_($54D0)_($54B4) OK
//------------------------------
L_BRS_($54B7)_($54BF) OK
//------------------------------
$54B7  4C 66 56  JMP L_JMP_($5666)_($54B7) OK
//------------------------------
L_BRS_($54BA)_($54AB) OK
//------------------------------
$54BA  AD 6B 4A  LDA $4A6B 
$54BD  29 08     AND #$08
$54BF  F0 F6     BEQ L_BRS_($54B7)_($54BF) OK
$54C1  A9 00     LDA #$00
$54C3  38        SEC 
$54C4  E5 84     SBC $84 
$54C6  85 84     STA $84 
$54C8  F0 04     BEQ L_BRS_($54CE)_($54C8) OK
$54CA  A9 FF     LDA #$FF
$54CC  85 85     STA $85 
//------------------------------
L_BRS_($54CE)_($54C8) OK
//------------------------------
$54CE  B1 7E     LDA ($7E),Y 
//------------------------------
L_JMP_($54D0)_($54B4) OK
//------------------------------
$54D0  20 61 50  JSR L_JSR_($5061)_($54D0) OK
$54D3  18        CLC 
$54D4  65 84     ADC $84 
$54D6  8D 43 4A  STA $4A43 
$54D9  A5 83     LDA $83 
$54DB  65 85     ADC $85 
$54DD  8D 44 4A  STA $4A44 
$54E0  AD 43 4A  LDA $4A43 
$54E3  38        SEC 
$54E4  ED 30 1C  SBC $1C30 
$54E7  85 88     STA $88 
$54E9  AD 44 4A  LDA $4A44 
$54EC  ED 31 1C  SBC $1C31 
$54EF  85 89     STA $89 
$54F1  AD 33 4A  LDA $4A33 
$54F4  85 8C     STA $8C 
$54F6  AD 34 4A  LDA $4A34 
$54F9  85 8D     STA $8D 
$54FB  20 31 1D  JSR L_JSR_($1D31)_($54FB) OK
$54FE  A5 82     LDA $82 
$5500  85 88     STA $88 
$5502  A5 83     LDA $83 
$5504  85 89     STA $89 
$5506  A5 84     LDA $84 
$5508  85 8A     STA $8A 
$550A  A5 85     LDA $85 
$550C  85 8B     STA $8B 
$550E  AD 31 4A  LDA $4A31 
$5511  85 8C     STA $8C 
$5513  AD 32 4A  LDA $4A32 
$5516  85 8D     STA $8D 
$5518  20 DE 1E  JSR L_JSR_($1EDE)_($5518) OK
$551B  AD 32 1C  LDA $1C32 
$551E  18        CLC 
$551F  65 88     ADC $88 
$5521  8D 45 4A  STA $4A45 
$5524  8D 51 4A  STA $4A51 
$5527  AD 33 1C  LDA $1C33 
$552A  65 89     ADC $89 
$552C  8D 46 4A  STA $4A46 
$552F  8D 52 4A  STA $4A52 
$5532  A0 03     LDY #$03
$5534  B1 7E     LDA ($7E),Y 
$5536  20 61 50  JSR L_JSR_($5061)_($5536) OK
$5539  38        SEC 
$553A  ED 32 15  SBC $1532 
$553D  85 82     STA $82 
$553F  A5 83     LDA $83 
$5541  E9 00     SBC #$00
$5543  85 83     STA $83 
$5545  AD 45 4A  LDA $4A45 
$5548  38        SEC 
$5549  E5 82     SBC $82 
//------------------------------
L_JMP_($554C)_($1AB2) BAD
//------------------------------
$554B  AD 46 4A  LDA $4A46 
$554E  E5 83     SBC $83 
$5550  10 0A     BPL L_BRS_($555C)_($5550) OK
$5552  AD 6B 4A  LDA $4A6B 
$5555  29 10     AND #$10
$5557  D0 30     BNE L_BRS_($5589)_($5557) OK
$5559  4C 66 56  JMP L_JMP_($5666)_($5559) OK
//------------------------------
L_BRS_($555C)_($5550) OK
//------------------------------
$555C  B1 7E     LDA ($7E),Y 
$555E  18        CLC 
$555F  A0 06     LDY #$06
$5561  71 7E     ADC ($7E),Y 
$5563  20 61 50  JSR L_JSR_($5061)_($5563) OK
$5566  18        CLC 
$5567  6D 32 15  ADC $1532 
$556A  85 82     STA $82 
$556C  A5 83     LDA $83 
$556E  69 00     ADC #$00
$5570  85 83     STA $83 
$5572  AD 45 4A  LDA $4A45 
$5575  38        SEC 
$5576  E5 82     SBC $82 
$5578  AD 46 4A  LDA $4A46 
$557B  E5 83     SBC $83 
$557D  30 0D     BMI L_BRS_($558C)_($557D) OK
$557F  AD 6B 4A  LDA $4A6B 
$5582  29 20     AND #$20
$5584  D0 03     BNE L_BRS_($5589)_($5584) OK
$5586  4C 66 56  JMP L_JMP_($5666)_($5586) OK
//------------------------------
L_BRS_($5589)_($5557) OK
L_BRS_($5589)_($5584) OK
//------------------------------
$5589  4C 28 58  JMP L_JMP_($5828)_($5589) OK
//------------------------------
L_BRS_($558C)_($557D) OK
//------------------------------
$558C  AD 43 4A  LDA $4A43 
$558F  38        SEC 
$5590  ED 30 1C  SBC $1C30 
$5593  85 88     STA $88 
$5595  AD 44 4A  LDA $4A44 
$5598  ED 31 1C  SBC $1C31 
$559B  85 89     STA $89 
$559D  AD 2F 4A  LDA $4A2F 
$55A0  85 8C     STA $8C 
$55A2  AD 30 4A  LDA $4A30 
$55A5  85 8D     STA $8D 
$55A7  20 31 1D  JSR L_JSR_($1D31)_($55A7) OK
$55AA  A5 82     LDA $82 
$55AC  85 88     STA $88 
$55AE  A5 83     LDA $83 
$55B0  85 89     STA $89 
$55B2  A5 84     LDA $84 
$55B4  85 8A     STA $8A 
$55B6  A5 85     LDA $85 
$55B8  85 8B     STA $8B 
$55BA  AD 31 4A  LDA $4A31 
$55BD  85 8C     STA $8C 
$55BF  AD 32 4A  LDA $4A32 
$55C2  85 8D     STA $8D 
$55C4  20 DE 1E  JSR L_JSR_($1EDE)_($55C4) OK
$55C7  AD 2E 1C  LDA $1C2E 
$55CA  18        CLC 
$55CB  65 88     ADC $88 
$55CD  8D 41 4A  STA $4A41 
$55D0  8D 4D 4A  STA $4A4D 
$55D3  AD 2F 1C  LDA $1C2F 
$55D6  65 89     ADC $89 
$55D8  8D 42 4A  STA $4A42 
$55DB  8D 4E 4A  STA $4A4E 
$55DE  A0 01     LDY #$01
$55E0  B1 7E     LDA ($7E),Y 
$55E2  20 61 50  JSR L_JSR_($5061)_($55E2) OK
$55E5  38        SEC 
$55E6  ED 32 15  SBC $1532 
$55E9  85 82     STA $82 
$55EB  A5 83     LDA $83 
$55ED  E9 00     SBC #$00
$55EF  85 83     STA $83 
$55F1  AD 41 4A  LDA $4A41 
$55F4  38        SEC 
$55F5  E5 82     SBC $82 
$55F7  AD 42 4A  LDA $4A42 
$55FA  E5 83     SBC $83 
$55FC  10 0A     BPL L_BRS_($5608)_($55FC) OK
$55FE  AD 6B 4A  LDA $4A6B 
$5601  29 01     AND #$01
$5603  D0 5E     BNE L_BRS_($5663)_($5603) OK
$5605  4C 66 56  JMP L_JMP_($5666)_($5605) OK
//------------------------------
L_BRS_($5608)_($55FC) OK
//------------------------------
$5608  B1 7E     LDA ($7E),Y 
$560A  18        CLC 
$560B  A0 04     LDY #$04
$560D  71 7E     ADC ($7E),Y 
$560F  20 61 50  JSR L_JSR_($5061)_($560F) OK
$5612  18        CLC 
$5613  6D 32 15  ADC $1532 
$5616  85 82     STA $82 
$5618  A5 83     LDA $83 
$561A  69 00     ADC #$00
$561C  85 83     STA $83 
$561E  AD 41 4A  LDA $4A41 
$5621  38        SEC 
$5622  E5 82     SBC $82 
$5624  AD 42 4A  LDA $4A42 
$5627  E5 83     SBC $83 
$5629  30 0A     BMI L_BRS_($5635)_($5629) OK
$562B  AD 6B 4A  LDA $4A6B 
$562E  29 02     AND #$02
$5630  D0 31     BNE L_BRS_($5663)_($5630) OK
$5632  4C 66 56  JMP L_JMP_($5666)_($5632) OK
//------------------------------
L_BRS_($5635)_($5629) OK
//------------------------------
$5635  AD 6B 4A  LDA $4A6B 
$5638  29 04     AND #$04
$563A  F0 12     BEQ L_BRS_($564E)_($563A) OK
$563C  AD 43 4A  LDA $4A43 
$563F  18        CLC 
$5640  6D 32 15  ADC $1532 
$5643  8D 4F 4A  STA $4A4F 
$5646  AD 44 4A  LDA $4A44 
$5649  69 00     ADC #$00
$564B  4C 5D 56  JMP L_JMP_($565D)_($564B) OK
//------------------------------
L_JSR_($564F)_($1A69) BAD
L_BRS_($564E)_($563A) OK
//------------------------------
$564E  AD 43 4A  LDA $4A43 
//------------------------------
L_JMP_($5651)_($0FA9) OK
//------------------------------
$5651  38        SEC 
$5652  ED 32 15  SBC $1532 
$5655  8D 4F 4A  STA $4A4F 
$5658  AD 44 4A  LDA $4A44 
$565B  E9 00     SBC #$00
//------------------------------
L_JMP_($565D)_($564B) OK
//------------------------------
$565D  8D 50 4A  STA $4A50 
$5660  20 6E 50  JSR L_JSR_($506E)_($5660) OK
//------------------------------
L_BRS_($5663)_($5603) OK
L_BRS_($5663)_($5630) OK
L_BRS_($5663)_($5687) OK
//------------------------------
$5663  4C 28 58  JMP L_JMP_($5828)_($5663) OK
//------------------------------
L_JMP_($5666)_($54B7) OK
L_JMP_($5666)_($5559) OK
L_JMP_($5666)_($5586) OK
L_JMP_($5666)_($5605) OK
L_JMP_($5666)_($5632) OK
//------------------------------
$5666  AD 32 15  LDA $1532 
$5669  85 84     STA $84 
$566B  A9 00     LDA #$00
$566D  85 85     STA $85 
$566F  A0 03     LDY #$03
$5671  AD 6B 4A  LDA $4A6B 
$5674  29 10     AND #$10
$5676  F0 0A     BEQ L_BRS_($5682)_($5676) OK
$5678  B1 7E     LDA ($7E),Y 
$567A  18        CLC 
$567B  A0 06     LDY #$06
$567D  71 7E     ADC ($7E),Y 
$567F  4C 98 56  JMP L_JMP_($5698)_($567F) OK
//------------------------------
L_BRS_($5682)_($5676) OK
//------------------------------
$5682  AD 6B 4A  LDA $4A6B 
$5685  29 20     AND #$20
$5687  F0 DA     BEQ L_BRS_($5663)_($5687) OK
$5689  A9 00     LDA #$00
$568B  38        SEC 
$568C  E5 84     SBC $84 
$568E  85 84     STA $84 
$5690  F0 04     BEQ L_BRS_($5696)_($5690) OK
$5692  A9 FF     LDA #$FF
$5694  85 85     STA $85 
//------------------------------
L_BRS_($5696)_($5690) OK
//------------------------------
$5696  B1 7E     LDA ($7E),Y 
//------------------------------
L_JMP_($5698)_($567F) OK
//------------------------------
$5698  20 61 50  JSR L_JSR_($5061)_($5698) OK
$569B  18        CLC 
$569C  65 84     ADC $84 
$569E  8D 45 4A  STA $4A45 
$56A1  A5 83     LDA $83 
$56A3  65 85     ADC $85 
$56A5  8D 46 4A  STA $4A46 
$56A8  AD 45 4A  LDA $4A45 
$56AB  38        SEC 
$56AC  ED 32 1C  SBC $1C32 
$56AF  85 88     STA $88 
$56B1  AD 46 4A  LDA $4A46 
$56B4  ED 33 1C  SBC $1C33 
$56B7  85 89     STA $89 
$56B9  AD 2F 4A  LDA $4A2F 
$56BC  85 8C     STA $8C 
$56BE  AD 30 4A  LDA $4A30 
$56C1  85 8D     STA $8D 
$56C3  20 31 1D  JSR L_JSR_($1D31)_($56C3) OK
$56C6  A5 82     LDA $82 
$56C8  85 88     STA $88 
$56CA  A5 83     LDA $83 
$56CC  85 89     STA $89 
$56CE  A5 84     LDA $84 
$56D0  85 8A     STA $8A 
$56D2  A5 85     LDA $85 
$56D4  85 8B     STA $8B 
$56D6  AD 33 4A  LDA $4A33 
$56D9  85 8C     STA $8C 
$56DB  AD 34 4A  LDA $4A34 
$56DE  85 8D     STA $8D 
$56E0  20 DE 1E  JSR L_JSR_($1EDE)_($56E0) OK
$56E3  AD 2E 1C  LDA $1C2E 
$56E6  18        CLC 
$56E7  65 88     ADC $88 
$56E9  8D 41 4A  STA $4A41 
$56EC  8D 47 4A  STA $4A47 
$56EF  8D 4D 4A  STA $4A4D 
$56F2  AD 2F 1C  LDA $1C2F 
$56F5  65 89     ADC $89 
$56F7  8D 42 4A  STA $4A42 
$56FA  8D 48 4A  STA $4A48 
$56FD  8D 4E 4A  STA $4A4E 
$5700  A0 01     LDY #$01
$5702  B1 7E     LDA ($7E),Y 
$5704  20 61 50  JSR L_JSR_($5061)_($5704) OK
$5707  38        SEC 
$5708  ED 32 15  SBC $1532 
$570B  85 82     STA $82 
$570D  A5 83     LDA $83 
$570F  E9 00     SBC #$00
//------------------------------
L_JSR_($5711)_($1043) OK
//------------------------------
$5711  85 83     STA $83 
$5713  AD 41 4A  LDA $4A41 
$5716  38        SEC 
$5717  E5 82     SBC $82 
$5719  AD 42 4A  LDA $4A42 
$571C  E5 83     SBC $83 
$571E  30 23     BMI L_BRS_($5743)_($571E) OK
//------------------------------
L_JSR_($5720)_($19D4) OK
//------------------------------
$5720  B1 7E     LDA ($7E),Y 
$5722  18        CLC 
$5723  A0 04     LDY #$04
$5725  71 7E     ADC ($7E),Y 
$5727  20 61 50  JSR L_JSR_($5061)_($5727) OK
$572A  18        CLC 
$572B  6D 32 15  ADC $1532 
$572E  85 82     STA $82 
$5730  A5 83     LDA $83 
$5732  69 00     ADC #$00
$5734  85 83     STA $83 
$5736  AD 41 4A  LDA $4A41 
$5739  38        SEC 
$573A  E5 82     SBC $82 
$573C  AD 42 4A  LDA $4A42 
$573F  E5 83     SBC $83 
$5741  30 03     BMI L_BRS_($5746)_($5741) OK
//------------------------------
L_BRS_($5743)_($571E) OK
//------------------------------
$5743  4C 28 58  JMP L_JMP_($5828)_($5743) OK
//------------------------------
L_BRS_($5746)_($5741) OK
//------------------------------
$5746  AD 41 4A  LDA $4A41 
$5749  38        SEC 
$574A  ED 2E 1C  SBC $1C2E 
$574D  85 88     STA $88 
$574F  AD 42 4A  LDA $4A42 
$5752  ED 2F 1C  SBC $1C2F 
$5755  85 89     STA $89 
$5757  AD 31 4A  LDA $4A31 
$575A  85 8C     STA $8C 
$575C  AD 32 4A  LDA $4A32 
$575F  85 8D     STA $8D 
$5761  20 31 1D  JSR L_JSR_($1D31)_($5761) OK
$5764  A5 82     LDA $82 
$5766  85 88     STA $88 
$5768  A5 83     LDA $83 
$576A  85 89     STA $89 
$576C  A5 84     LDA $84 
$576E  85 8A     STA $8A 
$5770  A5 85     LDA $85 
$5772  85 8B     STA $8B 
$5774  AD 2F 4A  LDA $4A2F 
$5777  85 8C     STA $8C 
$5779  AD 30 4A  LDA $4A30 
$577C  85 8D     STA $8D 
$577E  20 DE 1E  JSR L_JSR_($1EDE)_($577E) OK
$5781  AD 30 1C  LDA $1C30 
$5784  18        CLC 
$5785  65 88     ADC $88 
$5787  8D 43 4A  STA $4A43 
$578A  8D 4F 4A  STA $4A4F 
$578D  AD 31 1C  LDA $1C31 
$5790  65 89     ADC $89 
$5792  8D 44 4A  STA $4A44 
$5795  8D 50 4A  STA $4A50 
$5798  A0 02     LDY #$02
$579A  B1 7E     LDA ($7E),Y 
$579C  20 61 50  JSR L_JSR_($5061)_($579C) OK
$579F  18        CLC 
$57A0  AD 43 4A  LDA $4A43 
$57A3  6D 6C 4A  ADC $4A6C 
$57A6  85 84     STA $84 
$57A8  AD 44 4A  LDA $4A44 
$57AB  6D 6D 4A  ADC $4A6D 
$57AE  85 85     STA $85 
$57B0  A5 84     LDA $84 
$57B2  38        SEC 
$57B3  E5 82     SBC $82 
$57B5  A5 85     LDA $85 
$57B7  E5 83     SBC $83 
$57B9  30 6D     BMI L_BRS_($5828)_($57B9) OK
$57BB  B1 7E     LDA ($7E),Y 
$57BD  18        CLC 
$57BE  A0 05     LDY #$05
$57C0  71 7E     ADC ($7E),Y 
$57C2  20 61 50  JSR L_JSR_($5061)_($57C2) OK
$57C5  AD 43 4A  LDA $4A43 
$57C8  38        SEC 
$57C9  E5 82     SBC $82 
$57CB  AD 44 4A  LDA $4A44 
$57CE  E5 83     SBC $83 
$57D0  10 56     BPL L_BRS_($5828)_($57D0) OK
$57D2  A5 82     LDA $82 
$57D4  8D 49 4A  STA $4A49 
$57D7  A5 83     LDA $83 
$57D9  8D 4A 4A  STA $4A4A 
$57DC  EE 75 4A  INC $4A75 
$57DF  AD 45 4A  LDA $4A45 
$57E2  38        SEC 
$57E3  ED 75 4A  SBC $4A75 
$57E6  8D 4B 4A  STA $4A4B 
$57E9  AD 46 4A  LDA $4A46 
$57EC  E9 00     SBC #$00
$57EE  8D 4C 4A  STA $4A4C 
$57F1  AD 45 4A  LDA $4A45 
$57F4  18        CLC 
$57F5  6D 75 4A  ADC $4A75 
$57F8  8D 51 4A  STA $4A51 
$57FB  AD 46 4A  LDA $4A46 
$57FE  69 00     ADC #$00
$5800  8D 52 4A  STA $4A52 
$5803  AD 6B 4A  LDA $4A6B 
$5806  29 10     AND #$10
$5808  D0 18     BNE L_BRS_($5822)_($5808) OK
$580A  AD 51 4A  LDA $4A51 
$580D  AE 4B 4A  LDX $4A4B 
$5810  8D 4B 4A  STA $4A4B 
$5813  8E 51 4A  STX $4A51 
$5816  AD 52 4A  LDA $4A52 
$5819  AE 4C 4A  LDX $4A4C 
$581C  8D 4C 4A  STA $4A4C 
$581F  8E 52 4A  STX $4A52 
//------------------------------
L_BRS_($5822)_($5808) OK
//------------------------------
$5822  CE 75 4A  DEC $4A75 
$5825  20 6E 50  JSR L_JSR_($506E)_($5825) OK
//------------------------------
L_JMP_($5828)_($52A8) OK
L_JMP_($5828)_($539F) OK
L_JMP_($5828)_($5498) OK
L_JMP_($5828)_($5589) OK
L_JMP_($5828)_($5663) OK
L_JMP_($5828)_($5743) OK
L_BRS_($5828)_($57B9) OK
L_BRS_($5828)_($57D0) OK
//------------------------------
$5828  A0 08     LDY #$08
$582A  B1 7E     LDA ($7E),Y 
$582C  18        CLC 
$582D  65 7E     ADC $7E 
$582F  85 7E     STA $7E 
$5831  90 02     BCC L_BRS_($5835)_($5831) OK
$5833  E6 7F     INC $7F 
//------------------------------
L_BRS_($5835)_($5831) OK
//------------------------------
$5835  68        PLA 
$5836  AA        TAX 
$5837  CA        DEX 
$5838  F0 03     BEQ L_BRS_($583D)_($5838) OK
$583A  4C 24 52  JMP L_JMP_($5224)_($583A) OK
//------------------------------
L_BRS_($583D)_($5838) OK
//------------------------------
$583D  60        RTS 
//------------------------------
$583E            .byte $43
$583F  46 43     LSR $43 
//------------------------------
L_JSR_($5842)_($42FB) BAD
//------------------------------
$5841  46 A2     LSR $A2 
$5843            .byte $00
$5844  8E 40 58  STX $5840 
$5847  8E 41 58  STX $5841 
$584A  C9 01     CMP #$01
$584C  F0 03     BEQ L_BRS_($5851)_($584C) OK
$584E  4C 03 59  JMP L_JMP_($5903)_($584E) OK
//------------------------------
L_BRS_($5851)_($584C) OK
//------------------------------
$5851  AD 3F 1C  LDA $1C3F 
$5854  C9 01     CMP #$01
$5856  F0 24     BEQ L_BRS_($587C)_($5856) OK
$5858  CE 3F 1C  DEC $1C3F 
$585B  AE 45 1C  LDX $1C45 
$585E  AC 42 1C  LDY $1C42 
//------------------------------
L_BRS_($5861)_($5874) OK
//------------------------------
$5861  AD 30 1C  LDA $1C30 
$5864  38        SEC 
$5865  E9 40     SBC #$40
$5867  8D 30 1C  STA $1C30 
$586A  AD 31 1C  LDA $1C31 
$586D  E9 00     SBC #$00
$586F  8D 31 1C  STA $1C31 
$5872  88        DEY 
$5873  CA        DEX 
$5874  D0 EB     BNE L_BRS_($5861)_($5874) OK
$5876  8C 42 1C  STY $1C42 
$5879  4C EB 58  JMP L_JMP_($58EB)_($5879) OK
//------------------------------
L_BRS_($587C)_($5856) OK
//------------------------------
$587C  AD 2E 1C  LDA $1C2E 
$587F  8D 36 15  STA $1536 
$5882  AD 2F 1C  LDA $1C2F 
$5885  8D 37 15  STA $1537 
$5888  AD 32 1C  LDA $1C32 
$588B  8D 3A 15  STA $153A 
$588E  AD 33 1C  LDA $1C33 
$5891  8D 3B 15  STA $153B 
$5894  AE 45 1C  LDX $1C45 
$5897  AD 30 1C  LDA $1C30 
$589A  8D 3E 58  STA $583E 
$589D  8D 38 15  STA $1538 
$58A0  AD 31 1C  LDA $1C31 
$58A3  8D 3F 58  STA $583F 
$58A6  8D 39 15  STA $1539 
//------------------------------
L_BRS_($58A9)_($58BB) OK
//------------------------------
$58A9  AD 38 15  LDA $1538 
$58AC  18        CLC 
$58AD  69 40     ADC #$40
$58AF  8D 38 15  STA $1538 
$58B2  AD 39 15  LDA $1539 
$58B5  69 00     ADC #$00
$58B7  8D 39 15  STA $1539 
$58BA  CA        DEX 
$58BB  D0 EC     BNE L_BRS_($58A9)_($58BB) OK
$58BD  A9 01     LDA #$01
$58BF  8D 46 1C  STA $1C46 
$58C2  AD 39 15  LDA $1539 
$58C5  48        PHA 
$58C6  AD 38 15  LDA $1538 
$58C9  48        PHA 
$58CA  20 77 4A  JSR L_JSR_($4A77)_($58CA) OK
$58CD  A9 00     LDA #$00
$58CF  8D 46 1C  STA $1C46 
$58D2  68        PLA 
$58D3  CD 30 1C  CMP $1C30 
$58D6  D0 1B     BNE L_BRS_($58F3)_($58D6) OK
$58D8  68        PLA 
$58D9  CD 31 1C  CMP $1C31 
$58DC  D0 16     BNE L_BRS_($58F4)_($58DC) OK
$58DE  EE 3F 1C  INC $1C3F 
$58E1  AD 45 1C  LDA $1C45 
$58E4  18        CLC 
$58E5  6D 42 1C  ADC $1C42 
$58E8  8D 42 1C  STA $1C42 
//------------------------------
L_JMP_($58EB)_($5879) OK
//------------------------------
$58EB  A9 1C     LDA #$1C
$58ED  8D 40 58  STA $5840 
$58F0  4C 19 5B  JMP L_JMP_($5B19)_($58F0) OK
//------------------------------
L_BRS_($58F3)_($58D6) OK
//------------------------------
$58F3  68        PLA 
//------------------------------
L_BRS_($58F4)_($58DC) OK
//------------------------------
$58F4  AD 3E 58  LDA $583E 
$58F7  8D 30 1C  STA $1C30 
$58FA  AD 3F 58  LDA $583F 
$58FD  8D 31 1C  STA $1C31 
$5900  4C 19 5B  JMP L_JMP_($5B19)_($5900) OK
//------------------------------
L_JMP_($5903)_($584E) OK
//------------------------------
$5903  C9 03     CMP #$03
$5905  F0 07     BEQ L_BRS_($590E)_($5905) OK
$5907  C9 04     CMP #$04
$5909  F0 03     BEQ L_BRS_($590E)_($5909) OK
$590B  4C 03 5A  JMP L_JMP_($5A03)_($590B) OK
//------------------------------
L_BRS_($590E)_($5905) OK
L_BRS_($590E)_($5909) OK
//------------------------------
$590E  48        PHA 
$590F  AD 34 1C  LDA $1C34 
$5912  85 83     STA $83 
$5914  AD 35 1C  LDA $1C35 
$5917  85 84     STA $84 
$5919  A5 83     LDA $83 
$591B  48        PHA 
$591C  A5 84     LDA $84 
$591E  48        PHA 
$591F  AD 39 1C  LDA $1C39 
$5922  0A        ASL A 
$5923  AA        TAX 
$5924  8E 3E 58  STX $583E 
$5927  BC 9D 17  LDY $179D,X 
$592A  A5 83     LDA $83 
$592C  A6 84     LDX $84 
$592E  20 A3 1C  JSR L_JSR_($1CA3)_($592E) OK
$5931  06 82     ASL $82 
$5933  26 83     ROL $83 
$5935  26 84     ROL $84 
$5937  06 82     ASL $82 
$5939  26 83     ROL $83 
$593B  26 84     ROL $84 
$593D  68        PLA 
$593E  A8        TAY 
$593F  68        PLA 
$5940  AA        TAX 
$5941  68        PLA 
$5942  48        PHA 
$5943  85 82     STA $82 
$5945  8A        TXA 
$5946  48        PHA 
$5947  98        TYA 
$5948  48        PHA 
$5949  A5 82     LDA $82 
$594B  C9 03     CMP #$03
$594D  F0 13     BEQ L_BRS_($5962)_($594D) OK
$594F  A5 84     LDA $84 
$5951  49 FF     EOR #$FF
$5953  85 84     STA $84 
$5955  A5 83     LDA $83 
$5957  49 FF     EOR #$FF
$5959  18        CLC 
$595A  69 01     ADC #$01
$595C  85 83     STA $83 
$595E  90 02     BCC L_BRS_($5962)_($595E) OK
$5960  E6 84     INC $84 
//------------------------------
L_BRS_($5962)_($594D) OK
L_BRS_($5962)_($595E) OK
//------------------------------
$5962  A5 83     LDA $83 
$5964  18        CLC 
$5965  6D 32 1C  ADC $1C32 
$5968  8D 3A 15  STA $153A 
$596B  A5 84     LDA $84 
$596D  6D 33 1C  ADC $1C33 
$5970  8D 3B 15  STA $153B 
$5973  AE 3E 58  LDX $583E 
$5976  BC 9C 17  LDY $179C,X 
$5979  68        PLA 
$597A  AA        TAX 
$597B  68        PLA 
$597C  20 A3 1C  JSR L_JSR_($1CA3)_($597C) OK
$597F  06 82     ASL $82 
$5981  26 83     ROL $83 
$5983  26 84     ROL $84 
$5985  06 82     ASL $82 
$5987  26 83     ROL $83 
$5989  26 84     ROL $84 
$598B  68        PLA 
$598C  C9 03     CMP #$03
$598E  F0 13     BEQ L_BRS_($59A3)_($598E) OK
$5990  A5 84     LDA $84 
$5992  49 FF     EOR #$FF
$5994  85 84     STA $84 
$5996  A5 83     LDA $83 
$5998  49 FF     EOR #$FF
$599A  18        CLC 
$599B  69 01     ADC #$01
$599D  85 83     STA $83 
$599F  90 02     BCC L_BRS_($59A3)_($599F) OK
$59A1  E6 84     INC $84 
//------------------------------
L_BRS_($59A3)_($598E) OK
L_BRS_($59A3)_($599F) OK
//------------------------------
$59A3  A5 83     LDA $83 
$59A5  18        CLC 
$59A6  6D 2E 1C  ADC $1C2E 
$59A9  8D 36 15  STA $1536 
$59AC  A5 84     LDA $84 
$59AE  6D 2F 1C  ADC $1C2F 
$59B1  8D 37 15  STA $1537 
$59B4  AE 42 1C  LDX $1C42 
$59B7  CA        DEX 
$59B8  8E 3F 58  STX $583F 
$59BB  A9 80     LDA #$80
$59BD  4E 3F 58  LSR $583F 
$59C0  6A        ROR A 
$59C1  4E 3F 58  LSR $583F 
$59C4  6A        ROR A 
$59C5  8D 3E 58  STA $583E 
$59C8  AD 30 1C  LDA $1C30 
$59CB  38        SEC 
$59CC  ED 3E 58  SBC $583E 
$59CF  8D 30 1C  STA $1C30 
$59D2  8D 38 15  STA $1538 
$59D5  AD 31 1C  LDA $1C31 
$59D8  ED 3F 58  SBC $583F 
$59DB  8D 31 1C  STA $1C31 
$59DE  8D 39 15  STA $1539 
$59E1  20 77 4A  JSR L_JSR_($4A77)_($59E1) OK
$59E4  E0 01     CPX #$01
$59E6  D0 05     BNE L_BRS_($59ED)_($59E6) OK
$59E8  A9 14     LDA #$14
$59EA  8D 40 58  STA $5840 
//------------------------------
L_BRS_($59ED)_($59E6) OK
//------------------------------
$59ED  AD 30 1C  LDA $1C30 
$59F0  18        CLC 
$59F1  6D 3E 58  ADC $583E 
$59F4  8D 30 1C  STA $1C30 
$59F7  AD 3F 58  LDA $583F 
$59FA  6D 31 1C  ADC $1C31 
$59FD  8D 31 1C  STA $1C31 
$5A00  4C 19 5B  JMP L_JMP_($5B19)_($5A00) OK
//------------------------------
L_JMP_($5A03)_($590B) OK
//------------------------------
$5A03  C9 05     CMP #$05
$5A05  D0 0A     BNE L_BRS_($5A11)_($5A05) OK
$5A07  A2 01     LDX #$01
$5A09  A9 24     LDA #$24
$5A0B  8D 40 58  STA $5840 
$5A0E  4C 76 5A  JMP L_JMP_($5A76)_($5A0E) OK
//------------------------------
L_BRS_($5A11)_($5A05) OK
//------------------------------
$5A11  C9 06     CMP #$06
$5A13  D0 0A     BNE L_BRS_($5A1F)_($5A13) OK
$5A15  A2 01     LDX #$01
$5A17  A9 24     LDA #$24
$5A19  8D 40 58  STA $5840 
$5A1C  4C 4E 5A  JMP L_JMP_($5A4E)_($5A1C) OK
//------------------------------
L_BRS_($5A1F)_($5A13) OK
//------------------------------
$5A1F  C9 0C     CMP #$0C
$5A21  D0 12     BNE L_BRS_($5A35)_($5A21) OK
$5A23  AD 38 1C  LDA $1C38 
$5A26  F0 4B     BEQ L_BRS_($5A73)_($5A26) OK
$5A28  A9 44     LDA #$44
$5A2A  8D 40 58  STA $5840 
$5A2D  A9 00     LDA #$00
$5A2F  8D 38 1C  STA $1C38 
$5A32  4C 19 5B  JMP L_JMP_($5B19)_($5A32) OK
//------------------------------
L_BRS_($5A35)_($5A21) OK
//------------------------------
$5A35  C9 07     CMP #$07
$5A37  D0 0A     BNE L_BRS_($5A43)_($5A37) OK
$5A39  A2 00     LDX #$00
$5A3B  A9 44     LDA #$44
$5A3D  8D 40 58  STA $5840 
$5A40  4C 76 5A  JMP L_JMP_($5A76)_($5A40) OK
//------------------------------
L_BRS_($5A43)_($5A37) OK
//------------------------------
$5A43  C9 08     CMP #$08
$5A45  D0 55     BNE L_BRS_($5A9C)_($5A45) OK
$5A47  A2 00     LDX #$00
$5A49  A9 44     LDA #$44
$5A4B  8D 40 58  STA $5840 
//------------------------------
L_JMP_($5A4E)_($5A1C) OK
//------------------------------
$5A4E  AD 3E 1C  LDA $1C3E 
$5A51  18        CLC 
$5A52  7D 38 1C  ADC $1C38,X 
$5A55  C9 48     CMP #$48
$5A57  90 03     BCC L_BRS_($5A5C)_($5A57) OK
$5A59  38        SEC 
$5A5A  E9 48     SBC #$48
//------------------------------
L_BRS_($5A5C)_($5A57) OK
//------------------------------
$5A5C  9D 38 1C  STA $1C38,X 
$5A5F  E0 00     CPX #$00
$5A61  D0 10     BNE L_BRS_($5A73)_($5A61) OK
$5A63  AD 38 1C  LDA $1C38 
$5A66  C9 13     CMP #$13
$5A68  90 09     BCC L_BRS_($5A73)_($5A68) OK
$5A6A  C9 36     CMP #$36
$5A6C  B0 05     BCS L_BRS_($5A73)_($5A6C) OK
$5A6E  A9 12     LDA #$12
$5A70  8D 38 1C  STA $1C38 
//------------------------------
L_BRS_($5A73)_($5A26) OK
L_BRS_($5A73)_($5A61) OK
L_BRS_($5A73)_($5A68) OK
L_BRS_($5A73)_($5A6C) OK
//------------------------------
$5A73  4C 19 5B  JMP L_JMP_($5B19)_($5A73) OK
//------------------------------
L_JMP_($5A76)_($5A0E) OK
L_JMP_($5A76)_($5A40) OK
//------------------------------
$5A76  BD 38 1C  LDA $1C38,X 
$5A79  38        SEC 
$5A7A  ED 3E 1C  SBC $1C3E 
$5A7D  10 03     BPL L_BRS_($5A82)_($5A7D) OK
$5A7F  18        CLC 
$5A80  69 48     ADC #$48
//------------------------------
L_BRS_($5A82)_($5A7D) OK
//------------------------------
$5A82  9D 38 1C  STA $1C38,X 
$5A85  E0 00     CPX #$00
$5A87  D0 10     BNE L_BRS_($5A99)_($5A87) OK
$5A89  AD 38 1C  LDA $1C38 
$5A8C  C9 36     CMP #$36
$5A8E  B0 09     BCS L_BRS_($5A99)_($5A8E) OK
$5A90  C9 13     CMP #$13
$5A92  90 05     BCC L_BRS_($5A99)_($5A92) OK
$5A94  A9 36     LDA #$36
$5A96  8D 38 1C  STA $1C38 
//------------------------------
L_BRS_($5A99)_($5A87) OK
L_BRS_($5A99)_($5A8E) OK
L_BRS_($5A99)_($5A92) OK
//------------------------------
$5A99  4C 19 5B  JMP L_JMP_($5B19)_($5A99) OK
//------------------------------
L_BRS_($5A9C)_($5A45) OK
//------------------------------
$5A9C  C9 0D     CMP #$0D
$5A9E  D0 18     BNE L_BRS_($5AB8)_($5A9E) OK
$5AA0  A9 24     LDA #$24
$5AA2  8D 40 58  STA $5840 
$5AA5  AD 39 1C  LDA $1C39 
$5AA8  18        CLC 
$5AA9  69 24     ADC #$24
$5AAB  C9 48     CMP #$48
$5AAD  90 03     BCC L_BRS_($5AB2)_($5AAD) OK
$5AAF  38        SEC 
$5AB0  E9 48     SBC #$48
//------------------------------
L_BRS_($5AB2)_($5AAD) OK
//------------------------------
$5AB2  8D 39 1C  STA $1C39 
$5AB5  4C 19 5B  JMP L_JMP_($5B19)_($5AB5) OK
//------------------------------
L_BRS_($5AB8)_($5A9E) OK
//------------------------------
$5AB8  C9 0B     CMP #$0B
$5ABA  D0 1C     BNE L_BRS_($5AD8)_($5ABA) OK
$5ABC  AE 3D 1C  LDX $1C3D 
$5ABF  E8        INX 
$5AC0  EC 2A 15  CPX $152A 
$5AC3  90 02     BCC L_BRS_($5AC7)_($5AC3) OK
$5AC5  A2 00     LDX #$00
//------------------------------
L_BRS_($5AC7)_($5AC3) OK
//------------------------------
$5AC7  8E 3D 1C  STX $1C3D 
$5ACA  BD 27 15  LDA $1527,X 
$5ACD  8D 3E 1C  STA $1C3E 
$5AD0  A9 80     LDA #$80
$5AD2  8D 40 58  STA $5840 
$5AD5  4C 07 5B  JMP L_JMP_($5B07)_($5AD5) OK
//------------------------------
L_BRS_($5AD8)_($5ABA) OK
//------------------------------
$5AD8  C9 11     CMP #$11
$5ADA  D0 42     BNE L_BRS_($5B1E)_($5ADA) OK
$5ADC  AE 37 1C  LDX $1C37 
$5ADF  E8        INX 
$5AE0  EC 2B 15  CPX $152B 
$5AE3  90 02     BCC L_BRS_($5AE7)_($5AE3) OK
$5AE5  A2 00     LDX #$00
//------------------------------
L_BRS_($5AE7)_($5AE3) OK
//------------------------------
$5AE7  8E 37 1C  STX $1C37 
$5AEA  BD 2C 15  LDA $152C,X 
$5AED  8D 36 1C  STA $1C36 
$5AF0  A2 00     LDX #$00
$5AF2  AC 45 1C  LDY $1C45 
$5AF5  20 A3 1C  JSR L_JSR_($1CA3)_($5AF5) OK
$5AF8  A5 82     LDA $82 
$5AFA  8D 34 1C  STA $1C34 
$5AFD  A5 83     LDA $83 
$5AFF  8D 35 1C  STA $1C35 
$5B02  A9 01     LDA #$01
$5B04  8D 41 58  STA $5841 
//------------------------------
L_JMP_($5B07)_($5AD5) OK
//------------------------------
$5B07  A9 00     LDA #$00
$5B09  8D 73 15  STA $1573 
$5B0C  A9 0C     LDA #$0C
$5B0E  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($5B11)_($5B14) OK
//------------------------------
$5B11  AD 4E 15  LDA $154E 
$5B14  D0 FB     BNE L_BRS_($5B11)_($5B14) OK
$5B16  4C 1E 5B  JMP L_JMP_($5B1E)_($5B16) OK
//------------------------------
L_JMP_($5B19)_($58F0) OK
L_JMP_($5B19)_($5900) OK
L_JMP_($5B19)_($5A00) OK
L_JMP_($5B19)_($5A32) OK
L_JMP_($5B19)_($5A73) OK
L_JMP_($5B19)_($5A99) OK
L_JMP_($5B19)_($5AB5) OK
//------------------------------
$5B19  A9 01     LDA #$01
$5B1B  8D 73 15  STA $1573 
//------------------------------
L_BRS_($5B1E)_($5ADA) OK
L_JMP_($5B1E)_($5B16) OK
//------------------------------
$5B1E  AD 43 15  LDA $1543 
$5B21  0D 40 58  ORA $5840
$5B24  8D 43 15  STA $1543 
$5B27  AD 44 15  LDA $1544 
$5B2A  0D 41 58  ORA $5841
$5B2D  8D 44 15  STA $1544 
$5B30  60        RTS 
//------------------------------
$5B31            .byte $3B
$5B32  20        .byte $20
//------------------------------
L_JSR_($5B33)_($2FA8) OK
L_JSR_($5B33)_($67B4) OK
L_JSR_($5B33)_($7CCA) OK
L_JSR_($5B33)_($7D08) OK
//------------------------------
$5B33  A9 35     LDA #$35		; TODO SetColors3D
$5B35  85 01     STA $01 
$5B37  A9 68     LDA #$68
$5B39  4A        LSR A 
$5B3A  4A        LSR A 
$5B3B  4A        LSR A 
$5B3C  8D 31 5B  STA $5B31 
$5B3F  A9 00     LDA #$00
$5B41  8D 4F 15  STA $154F 
$5B44  A2 04     LDX #$04
//------------------------------
L_BRS_($5B46)_($5B4D) OK
//------------------------------
$5B46  BD 63 1C  LDA $1C63,X 
$5B49  9D 5F 1C  STA $1C5F,X 
$5B4C  CA        DEX 
$5B4D  D0 F7     BNE L_BRS_($5B46)_($5B4D) OK
$5B4F  AD 33 17  LDA $1733 
$5B52  85 82     STA $82 
$5B54  AD 34 17  LDA $1734 
$5B57  38        SEC 
$5B58  E9 E0     SBC #$E0		; $E000 - C64 vram
$5B5A  4A        LSR A 
$5B5B  66 82     ROR $82 
$5B5D  4A        LSR A 
$5B5E  66 82     ROR $82 
$5B60  4A        LSR A 
$5B61  66 82     ROR $82 
$5B63  18        CLC 
$5B64  48        PHA 
$5B65  69 D8     ADC #$D8		; TODO: This accesses data at $d800 (C+4 has this at $dc00)
$5B67  8D 8E 5B  STA $5B8E 
$5B6A  A5 82     LDA $82 
$5B6C  8D 8D 5B  STA $5B8D 
$5B6F  8D 93 5B  STA $5B93 
$5B72  68        PLA 
$5B73  18        CLC 
$5B74  69 C4     ADC #$C4		; TODO: Color memory access (at C400)? C+4 has #$CE here, but this is in bitmap memory?
$5B76  8D 94 5B  STA $5B94 
$5B79  AD 61 1C  LDA $1C61 
$5B7C  0A        ASL A 
$5B7D  0A        ASL A 
$5B7E  0A        ASL A 
$5B7F  0A        ASL A 
$5B80  0D 62 1C  ORA $1C62
$5B83  8D 32 5B  STA $5B32 
//------------------------------
L_BRS_($5B86)_($5BAF) OK
//------------------------------
$5B86  A2 20     LDX #$20
$5B88  CA        DEX 
//------------------------------
L_BRS_($5B89)_($5B96) OK
//------------------------------
$5B89  AD 63 1C  LDA $1C63 
$5B8C  9D FF FF  STA $FFFF,X 	; TODO: C+4 changes these into LDA
$5B8F  AD 32 5B  LDA $5B32 
$5B92  9D FF FF  STA $FFFF,X 	; TODO: C+4 changes these into LDA
$5B95  CA        DEX 
$5B96  10 F1     BPL L_BRS_($5B89)_($5B96) OK
$5B98  AD 8D 5B  LDA $5B8D 
$5B9B  18        CLC 
$5B9C  69 28     ADC #$28
$5B9E  8D 8D 5B  STA $5B8D 
$5BA1  8D 93 5B  STA $5B93 
$5BA4  90 06     BCC L_BRS_($5BAC)_($5BA4) OK
$5BA6  EE 8E 5B  INC $5B8E 
$5BA9  EE 94 5B  INC $5B94 
//------------------------------
L_BRS_($5BAC)_($5BA4) OK
//------------------------------
$5BAC  CE 31 5B  DEC $5B31 
$5BAF  D0 D5     BNE L_BRS_($5B86)_($5BAF) OK
$5BB1  AD 60 1C  LDA $1C60 
$5BB4  8D 20 D0  STA $D020                          // Border Color
$5BB7  8D 21 D0  STA $D021                          // Background Color 0
$5BBA  60        RTS 
//------------------------------
$5BBB            .byte $37
$5BBC  46 37     LSR $37 
$5BBE  46 37     LSR $37 
$5BC0            .byte $37
$5BC1  38        SEC 
$5BC2            .byte $44
$5BC3  38        SEC 
$5BC4  46 37     LSR $37 
$5BC6  46 37     LSR $37 
$5BC8  46 37     LSR $37 
$5BCA  46	     .byte $46
//------------------------------
L_JSR_($5BCB)_($77C0) OK
L_JSR_($5BCB)_($77DE) OK
L_JSR_($5BCB)_($77F9) OK
L_JSR_($5BCB)_($780D) OK
L_JSR_($5BCB)_($781C) OK
L_JSR_($5BCB)_($7B5B) OK
//------------------------------
$5BCB  8A		 TXA			; called by update compass
$5BCC  AE C6 1A  LDX $1AC6 
$5BCF  38        SEC 
$5BD0  ED 2B 17  SBC $172B 
$5BD3  D0 0C     BNE L_BRS_($5BE1)_($5BD3) OK
$5BD5  9D BB 5B  STA $5BBB,X 
$5BD8  9D C3 5B  STA $5BC3,X 
$5BDB  9D C5 5B  STA $5BC5,X 
$5BDE  4C 01 5C  JMP L_JMP_($5C01)_($5BDE) OK
//------------------------------
L_BRS_($5BE1)_($5BD3) OK
//------------------------------
$5BE1  10 13     BPL L_BRS_($5BF6)_($5BE1) OK
$5BE3  49 FF     EOR #$FF
$5BE5  18        CLC 
$5BE6  69 01     ADC #$01
$5BE8  9D BB 5B  STA $5BBB,X 
$5BEB  A9 FF     LDA #$FF
$5BED  9D C3 5B  STA $5BC3,X 
$5BF0  9D C5 5B  STA $5BC5,X 
$5BF3  4C 01 5C  JMP L_JMP_($5C01)_($5BF3) OK
//------------------------------
L_BRS_($5BF6)_($5BE1) OK
//------------------------------
$5BF6  9D BB 5B  STA $5BBB,X 
$5BF9  A9 01     LDA #$01
$5BFB  9D C3 5B  STA $5BC3,X 
$5BFE  9D C5 5B  STA $5BC5,X 
//------------------------------
L_JMP_($5C01)_($5BDE) OK
L_JMP_($5C01)_($5BF3) OK
//------------------------------
$5C01  98        TYA 
$5C02  38        SEC 
$5C03  ED 2C 17  SBC $172C 
$5C06  D0 0C     BNE L_BRS_($5C14)_($5C06) OK
$5C08  9D BD 5B  STA $5BBD,X 
$5C0B  9D BF 5B  STA $5BBF,X 
$5C0E  9D C1 5B  STA $5BC1,X 
$5C11  4C 34 5C  JMP L_JMP_($5C34)_($5C11) OK
//------------------------------
L_BRS_($5C14)_($5C06) OK
//------------------------------
$5C14  10 13     BPL L_BRS_($5C29)_($5C14) OK
$5C16  49 FF     EOR #$FF
$5C18  18        CLC 
$5C19  69 01     ADC #$01
$5C1B  9D BD 5B  STA $5BBD,X 
$5C1E  A9 FF     LDA #$FF
$5C20  9D BF 5B  STA $5BBF,X 
$5C23  9D C1 5B  STA $5BC1,X 
$5C26  4C 34 5C  JMP L_JMP_($5C34)_($5C26) OK
//------------------------------
L_BRS_($5C29)_($5C14) OK
//------------------------------
$5C29  9D BD 5B  STA $5BBD,X 
$5C2C  A9 01     LDA #$01
$5C2E  9D BF 5B  STA $5BBF,X 
$5C31  9D C1 5B  STA $5BC1,X 
//------------------------------
L_JMP_($5C34)_($5C11) OK
L_JMP_($5C34)_($5C26) OK
//------------------------------
$5C34  BD BB 5B  LDA $5BBB,X 
$5C37  DD BD 5B  CMP $5BBD,X 
$5C3A  B0 40     BCS L_BRS_($5C7C)_($5C3A) OK
$5C3C  BD BD 5B  LDA $5BBD,X 
$5C3F  9D C7 5B  STA $5BC7,X 
$5C42  4A        LSR A 
$5C43  9D C9 5B  STA $5BC9,X 
//------------------------------
L_BRS_($5C46)_($5C79) OK
//------------------------------
$5C46  20 8C 5D  JSR L_JSR_($5D8C)_($5C46) BAD
$5C49  AE C6 1A  LDX $1AC6 
$5C4C  AD 2C 17  LDA $172C 
$5C4F  18        CLC 
$5C50  7D BF 5B  ADC $5BBF,X 
$5C53  8D 2C 17  STA $172C 
$5C56  BD C9 5B  LDA $5BC9,X 
$5C59  18        CLC 
$5C5A  7D BB 5B  ADC $5BBB,X 
$5C5D  9D C9 5B  STA $5BC9,X 
$5C60  DD BD 5B  CMP $5BBD,X 
$5C63  90 11     BCC L_BRS_($5C76)_($5C63) OK
$5C65  38        SEC 
$5C66  FD BD 5B  SBC $5BBD,X 
$5C69  9D C9 5B  STA $5BC9,X 
$5C6C  AD 2B 17  LDA $172B 
$5C6F  18        CLC 
$5C70  7D C5 5B  ADC $5BC5,X 
$5C73  8D 2B 17  STA $172B 
//------------------------------
L_BRS_($5C76)_($5C63) OK
//------------------------------
$5C76  DE C7 5B  DEC $5BC7,X 
$5C79  D0 CB     BNE L_BRS_($5C46)_($5C79) OK
$5C7B  60        RTS 
//------------------------------
L_BRS_($5C7C)_($5C3A) OK
//------------------------------
$5C7C  BD BB 5B  LDA $5BBB,X 
$5C7F  9D C7 5B  STA $5BC7,X 
$5C82  4A        LSR A 
$5C83  9D C9 5B  STA $5BC9,X 
//------------------------------
L_BRS_($5C86)_($5CB9) OK
//------------------------------
$5C86  20 8C 5D  JSR L_JSR_($5D8C)_($5C86) BAD
$5C89  AE C6 1A  LDX $1AC6 
$5C8C  AD 2B 17  LDA $172B 
$5C8F  18        CLC 
$5C90  7D C3 5B  ADC $5BC3,X 
$5C93  8D 2B 17  STA $172B 
$5C96  BD C9 5B  LDA $5BC9,X 
$5C99  18        CLC 
$5C9A  7D BD 5B  ADC $5BBD,X 
$5C9D  9D C9 5B  STA $5BC9,X 
$5CA0  DD BB 5B  CMP $5BBB,X 
$5CA3  90 11     BCC L_BRS_($5CB6)_($5CA3) OK
$5CA5  38        SEC 
$5CA6  FD BB 5B  SBC $5BBB,X 
$5CA9  9D C9 5B  STA $5BC9,X 
$5CAC  AD 2C 17  LDA $172C 
$5CAF  18        CLC 
$5CB0  7D C1 5B  ADC $5BC1,X 
$5CB3  8D 2C 17  STA $172C 
//------------------------------
L_BRS_($5CB6)_($5CA3) OK
//------------------------------
$5CB6  DE C7 5B  DEC $5BC7,X 
$5CB9  D0 CB     BNE L_BRS_($5C86)_($5CB9) OK
$5CBB  60        RTS 
//------------------------------
$5CBC  58        CLI 
$5CBD  20 46 39  JSR L_JSR_($3946)_($5CBD) OK
//------------------------------
L_JSR_($5CC1)_($2EE1) BAD
L_JSR_($5CC1)_($4429) BAD
L_JSR_($5CC1)_($49BB) BAD
L_JSR_($5CC1)_($6400) BAD
L_JSR_($5CC1)_($6556) BAD
L_JSR_($5CC1)_($7475) BAD
L_JSR_($5CC1)_($7496) BAD
//------------------------------
$5CC0  46 8E     LSR $8E 
$5CC2            .byte $BF,$5C
$5CC4  8C C0 5C  STY $5CC0 
$5CC7  C9 00     CMP #$00
$5CC9  D0 3F     BNE L_BRS_($5D0A)_($5CC9) OK
$5CCB  AD 4B 15  LDA $154B 
$5CCE  F0 2A     BEQ L_BRS_($5CFA)_($5CCE) OK
$5CD0  8D BC 5C  STA $5CBC 
$5CD3  AD 4C 15  LDA $154C 
$5CD6  85 7C     STA $7C 
$5CD8  AD 4D 15  LDA $154D 
$5CDB  85 7D     STA $7D 
//------------------------------
L_BRS_($5CDD)_($5CF8) OK
//------------------------------
$5CDD  AD 46 15  LDA $1546 
$5CE0  A0 07     LDY #$07
$5CE2  D1 7C     CMP ($7C),Y 
$5CE4  D0 03     BNE L_BRS_($5CE9)_($5CE4) OK
$5CE6  4C 7D 5D  JMP L_JMP_($5D7D)_($5CE6) OK
//------------------------------
L_BRS_($5CE9)_($5CE4) OK
//------------------------------
$5CE9  C8        INY 
$5CEA  B1 7C     LDA ($7C),Y 
$5CEC  18        CLC 
$5CED  65 7C     ADC $7C 
$5CEF  85 7C     STA $7C 
$5CF1  90 02     BCC L_BRS_($5CF5)_($5CF1) OK
$5CF3  E6 7D     INC $7D 
//------------------------------
L_BRS_($5CF5)_($5CF1) OK
//------------------------------
$5CF5  CE BC 5C  DEC $5CBC 
$5CF8  D0 E3     BNE L_BRS_($5CDD)_($5CF8) OK
//------------------------------
L_BRS_($5CFA)_($5CCE) OK
//------------------------------
$5CFA  AD 4A 1C  LDA $1C4A 
$5CFD  85 7C     STA $7C 
$5CFF  AD 4B 1C  LDA $1C4B 
$5D02  85 7D     STA $7D 
$5D04  AE 49 1C  LDX $1C49 
$5D07  4C 53 5D  JMP L_JMP_($5D53)_($5D07) OK
//------------------------------
L_BRS_($5D0A)_($5CC9) OK
//------------------------------
$5D0A  AA        TAX 
$5D0B  AD 78 15  LDA $1578 
$5D0E  8D BC 5C  STA $5CBC 
$5D11  AD 8C 15  LDA $158C 
$5D14  85 7E     STA $7E 
$5D16  AD 8D 15  LDA $158D 
$5D19  85 7F     STA $7F 
$5D1B  A0 00     LDY #$00
//------------------------------
L_BRS_($5D1D)_($5D3E) OK
//------------------------------
$5D1D  B1 7E     LDA ($7E),Y 
$5D1F  18        CLC 
$5D20  6D 8A 15  ADC $158A 
$5D23  85 7C     STA $7C 
$5D25  C8        INY 
$5D26  B1 7E     LDA ($7E),Y 
$5D28  C8        INY 
$5D29  6D 8B 15  ADC $158B 
$5D2C  85 7D     STA $7D 
$5D2E  8C BD 5C  STY $5CBD 
$5D31  A0 02     LDY #$02
$5D33  8A        TXA 
$5D34  D1 7C     CMP ($7C),Y 
$5D36  F0 0B     BEQ L_BRS_($5D43)_($5D36) OK
$5D38  AC BD 5C  LDY $5CBD 
$5D3B  CE BC 5C  DEC $5CBC 
$5D3E  D0 DD     BNE L_BRS_($5D1D)_($5D3E) OK
$5D40  4C 74 5D  JMP L_JMP_($5D74)_($5D40) OK
//------------------------------
L_BRS_($5D43)_($5D36) OK
//------------------------------
$5D43  A0 01     LDY #$01
$5D45  B1 7C     LDA ($7C),Y 
$5D47  AA        TAX 
$5D48  A5 7C     LDA $7C 
$5D4A  18        CLC 
$5D4B  69 0F     ADC #$0F
$5D4D  85 7C     STA $7C 
$5D4F  90 02     BCC L_BRS_($5D53)_($5D4F) OK
$5D51  E6 7D     INC $7D 
//------------------------------
L_JMP_($5D53)_($5D07) OK
L_BRS_($5D53)_($5D4F) OK
//------------------------------
$5D53  E0 00     CPX #$00
$5D55  F0 1D     BEQ L_BRS_($5D74)_($5D55) OK
$5D57  8E BC 5C  STX $5CBC 
//------------------------------
L_BRS_($5D5A)_($5D72) OK
//------------------------------
$5D5A  AD 46 15  LDA $1546 
$5D5D  A0 07     LDY #$07
$5D5F  D1 7C     CMP ($7C),Y 
$5D61  F0 1A     BEQ L_BRS_($5D7D)_($5D61) OK
$5D63  C8        INY 
$5D64  B1 7C     LDA ($7C),Y 
$5D66  18        CLC 
$5D67  65 7C     ADC $7C 
$5D69  85 7C     STA $7C 
$5D6B  90 02     BCC L_BRS_($5D6F)_($5D6B) OK
$5D6D  E6 7D     INC $7D 
//------------------------------
L_BRS_($5D6F)_($5D6B) OK
//------------------------------
$5D6F  CE BC 5C  DEC $5CBC 
$5D72  D0 E6     BNE L_BRS_($5D5A)_($5D72) OK
//------------------------------
L_JMP_($5D74)_($5D40) OK
L_BRS_($5D74)_($5D55) OK
//------------------------------
$5D74  AE BF 5C  LDX $5CBF 
$5D77  AC C0 5C  LDY $5CC0 
$5D7A  A9 01     LDA #$01
$5D7C  60        RTS 
//------------------------------
L_JMP_($5D7D)_($5CE6) OK
L_BRS_($5D7D)_($5D61) OK
//------------------------------
$5D7D  AE BF 5C  LDX $5CBF 
$5D80  AC C0 5C  LDY $5CC0 
$5D83  A9 00     LDA #$00
$5D85  60        RTS 
//------------------------------
$5D86            .byte $37
$5D87  38        SEC 
$5D88            .byte $43
$5D89  38        SEC 
$5D8A            .byte $37
$5D8B  26        .byte $26 	
//------------------------------
L_JSR_($5D8C)_($5C46) OK
L_JSR_($5D8C)_($5C86) OK
L_JSR_($5D8C)_($7D67) OK
L_JSR_($5D8C)_($7DBA) OK
//------------------------------
$5D8C  AD 2B 17  LDA $172B	; TODO: updates screen? (for example called by update compass) (plot pixel?)
$5D8F  29 03     AND #$03
$5D91  8D 86 5D  STA $5D86 	; 172B - x position; 5D86 - index of pixel in screen byte
$5D94  AD 2F 17  LDA $172F 	; color?
$5D97  18        CLC 
$5D98  6A        ROR A 
$5D99  6A        ROR A 
$5D9A  6A        ROR A 
$5D9B  8D 87 5D  STA $5D87 ; pixel data to write (bits 0-1)
$5D9E  AD 2B 17  LDA $172B ; x position
$5DA1  29 FC     AND #$FC
$5DA3  0A        ASL A 
$5DA4  6D 31 17  ADC $1731 	; #$27 (pointer to last row)
$5DA7  85 F9     STA $F9 	
$5DA9  A9 00     LDA #$00
$5DAB  6D 32 17  ADC $1732 	; #$FE (pointer to last row)
$5DAE  85 FA     STA $FA 
$5DB0  AD 2C 17  LDA $172C 	; y position
$5DB3  29 07     AND #$07
$5DB5  85 82     STA $82   	; extract 3 bits, index of line within one char
$5DB7  A5 F9     LDA $F9 	; subtract index of line from screen pointer
$5DB9  38        SEC 
$5DBA  E5 82     SBC $82 
$5DBC  85 F9     STA $F9 
$5DBE  A5 FA     LDA $FA 
$5DC0  E9 00     SBC #$00
$5DC2  85 FA     STA $FA 
$5DC4  A9 00     LDA #$00
$5DC6  85 82     STA $82 
$5DC8  AD 2C 17  LDA $172C 	; y position
$5DCB  29 F8     AND #$F8  
$5DCD  4A        LSR A 
$5DCE  4A        LSR A 
$5DCF  4A        LSR A 		; character row number
$5DD0  48        PHA 
$5DD1  85 83     STA $83 
$5DD3  46 83     LSR $83 
$5DD5  66 82     ROR $82 
$5DD7  46 83     LSR $83 
$5DD9  66 82     ROR $82 
$5DDB  68        PLA 
$5DDC  18        CLC 
$5DDD  65 83     ADC $83 
$5DDF  85 83     STA $83 	; $82/83 - character row number * $140
$5DE1  A5 F9     LDA $F9 
$5DE3  38        SEC 
$5DE4  E5 82     SBC $82 
$5DE6  85 F9     STA $F9 
$5DE8  A5 FA     LDA $FA 
$5DEA  E5 83     SBC $83 
$5DEC  85 FA     STA $FA 
$5DEE  AD 87 5D  LDA $5D87 
$5DF1  A2 C0     LDX #$C0
$5DF3  8E 89 5D  STX $5D89 
$5DF6  AE 86 5D  LDX $5D86 
$5DF9  F0 0B     BEQ L_BRS_($5E06)_($5DF9) OK
//------------------------------
L_BRS_($5DFB)_($5E04) OK
//------------------------------
$5DFB  4A        LSR A 
$5DFC  4A        LSR A 
$5DFD  4E 89 5D  LSR $5D89 
$5E00  4E 89 5D  LSR $5D89 
$5E03  CA        DEX 
$5E04  D0 F5     BNE L_BRS_($5DFB)_($5E04) OK
//------------------------------
L_BRS_($5E06)_($5DF9) OK
//------------------------------
$5E06  A0 00     LDY #$00
$5E08  AE 2E 17  LDX $172E 
$5E0B  F0 12     BEQ L_BRS_($5E1F)_($5E0B) OK
$5E0D  8D 88 5D  STA $5D88 
$5E10  AD 89 5D  LDA $5D89 
$5E13  49 FF     EOR #$FF
$5E15  31 F9     AND ($F9),Y 
$5E17  0D 88 5D  ORA $5D88
$5E1A  91 F9     STA ($F9),Y 
$5E1C  4C 23 5E  JMP L_JMP_($5E23)_($5E1C) OK
//------------------------------
L_BRS_($5E1F)_($5E0B) OK
//------------------------------
$5E1F  51 F9     EOR ($F9),Y 
$5E21  91 F9     STA ($F9),Y 
//------------------------------
L_JMP_($5E23)_($5E1C) OK
//------------------------------
$5E23  CE 8A 5D  DEC $5D8A 
$5E26  D0 2C     BNE L_BRS_($5E54)_($5E26) OK
$5E28  AD 36 17  LDA $1736 
$5E2B  F0 1E     BEQ L_BRS_($5E4B)_($5E2B) OK
$5E2D  A5 A7     LDA $A7 
$5E2F  48        PHA 
$5E30  A5 A8     LDA $A8 
$5E32  48        PHA 
$5E33  A5 A9     LDA $A9 
$5E35  48        PHA 
$5E36  A5 AA     LDA $AA 
$5E38  48        PHA 
$5E39  20 01 09  JSR L_JSR_($0901)_($5E39) OK	; TODO: music player?
$5E3C  68        PLA 
$5E3D  85 AA     STA $AA 
$5E3F  68        PLA 
$5E40  85 A9     STA $A9 
$5E42  68        PLA 
$5E43  85 A8     STA $A8 
$5E45  68        PLA 
$5E46  85 A7     STA $A7 
$5E48  4C 4E 5E  JMP L_JMP_($5E4E)_($5E48) OK
//------------------------------
L_BRS_($5E4B)_($5E2B) OK
//------------------------------
$5E4B  20 2D CC  JSR L_JSR_($CC2D)_($5E4B) OK	; TODO: sound effect player?
//------------------------------
L_JMP_($5E4E)_($5E48) OK
//------------------------------
$5E4E  AD 8B 5D  LDA $5D8B 
$5E51  8D 8A 5D  STA $5D8A 
//------------------------------
L_BRS_($5E54)_($5E26) OK
//------------------------------
$5E54  60        RTS 
//------------------------------
$5E55  70 71     BVS L_BRS_($5EC8)_($5E55) BAD
$5E57            .byte $00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($5E5E)_($4310) OK
L_JSR_($5E5E)_($4315) OK
L_JSR_($5E5E)_($431A) OK
//------------------------------
$5E5E  C9 1E     CMP #$1E
$5E60  D0 57     BNE L_BRS_($5EB9)_($5E60) OK
$5E62  AD 91 1C  LDA $1C91 
$5E65  49 FF     EOR #$FF
$5E67  8D 91 1C  STA $1C91 
$5E6A  AD 43 15  LDA $1543 
$5E6D  48        PHA 
$5E6E  AD 44 15  LDA $1544 
$5E71  48        PHA 
$5E72  A9 01     LDA #$01
$5E74  8D 43 15  STA $1543 
$5E77  A9 00     LDA #$00
$5E79  8D 44 15  STA $1544 
$5E7C  20 82 69  JSR L_JSR_($6982)_($5E7C) OK
$5E7F  68        PLA 
$5E80  8D 44 15  STA $1544 
$5E83  68        PLA 
$5E84  8D 43 15  STA $1543 
$5E87  AD 91 1C  LDA $1C91 
$5E8A  D0 15     BNE L_BRS_($5EA1)_($5E8A) OK
$5E8C  A9 00     LDA #$00
$5E8E  20 41 7A  JSR L_JSR_($7A41)_($5E8E) OK
$5E91  A9 01     LDA #$01
$5E93  20 41 7A  JSR L_JSR_($7A41)_($5E93) OK
$5E96  AD A0 1C  LDA $1CA0 
$5E99  F0 03     BEQ L_BRS_($5E9E)_($5E99) OK
$5E9B  20 F5 5F  JSR L_JSR_($5FF5)_($5E9B) OK
//------------------------------
L_BRS_($5E9E)_($5E99) OK
//------------------------------
$5E9E  4C CD 5E  JMP L_JMP_($5ECD)_($5E9E) OK
//------------------------------
L_BRS_($5EA1)_($5E8A) OK
//------------------------------
$5EA1  AD A0 1C  LDA $1CA0 
$5EA4  F0 03     BEQ L_BRS_($5EA9)_($5EA4) OK
$5EA6  20 F5 5F  JSR L_JSR_($5FF5)_($5EA6) OK
//------------------------------
L_BRS_($5EA9)_($5EA4) OK
//------------------------------
$5EA9  A9 3F     LDA #$3F
$5EAB  8D 93 1C  STA $1C93 
$5EAE  A9 35     LDA #$35
$5EB0  8D 94 1C  STA $1C94 
$5EB3  20 FC 5F  JSR L_JSR_($5FFC)_($5EB3) OK
$5EB6  4C CD 5E  JMP L_JMP_($5ECD)_($5EB6) OK
//------------------------------
L_BRS_($5EB9)_($5E60) OK
//------------------------------
$5EB9  C9 15     CMP #$15
$5EBB  D0 1D     BNE L_BRS_($5EDA)_($5EBB) OK
$5EBD  AD 91 1C  LDA $1C91 
$5EC0  D0 15     BNE L_BRS_($5ED7)_($5EC0) OK
$5EC2  AD A0 1C  LDA $1CA0 
$5EC5  49 FF     EOR #$FF
//------------------------------
L_BRS_($5EC8)_($5E55) BAD
//------------------------------
$5EC7  8D A0 1C  STA $1CA0 
$5ECA  20 F5 5F  JSR L_JSR_($5FF5)_($5ECA) OK
//------------------------------
L_JMP_($5ECD)_($5E9E) OK
L_JMP_($5ECD)_($5EB6) OK
//------------------------------
$5ECD  A9 0F     LDA #$0F
$5ECF  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($5ED2)_($5ED5) OK
//------------------------------
$5ED2  AD 4E 15  LDA $154E 
$5ED5  D0 FB     BNE L_BRS_($5ED2)_($5ED5) OK
//------------------------------
L_BRS_($5ED7)_($5EC0) OK
L_BRS_($5ED7)_($5EDD) OK
L_BRS_($5ED7)_($5EE6) OK
L_BRS_($5ED7)_($5EFA) OK
L_BRS_($5ED7)_($5F0E) OK
L_BRS_($5ED7)_($5F22) OK
L_BRS_($5ED7)_($5F2F) OK
//------------------------------
$5ED7  4C F4 5F  JMP L_JMP_($5FF4)_($5ED7) OK
//------------------------------
L_BRS_($5EDA)_($5EBB) OK
//------------------------------
$5EDA  AE 91 1C  LDX $1C91 
$5EDD  F0 F8     BEQ L_BRS_($5ED7)_($5EDD) OK
$5EDF  C9 18     CMP #$18
$5EE1  D0 0E     BNE L_BRS_($5EF1)_($5EE1) OK
$5EE3  AD 93 1C  LDA $1C93 
$5EE6  F0 EF     BEQ L_BRS_($5ED7)_($5EE6) OK
$5EE8  CE 93 1C  DEC $1C93 
$5EEB  20 FC 5F  JSR L_JSR_($5FFC)_($5EEB) OK
$5EEE  4C F4 5F  JMP L_JMP_($5FF4)_($5EEE) OK
//------------------------------
L_BRS_($5EF1)_($5EE1) OK
//------------------------------
$5EF1  C9 17     CMP #$17
$5EF3  D0 10     BNE L_BRS_($5F05)_($5EF3) OK
$5EF5  AD 93 1C  LDA $1C93 
$5EF8  C9 7F     CMP #$7F
$5EFA  F0 DB     BEQ L_BRS_($5ED7)_($5EFA) OK
$5EFC  EE 93 1C  INC $1C93 
$5EFF  20 FC 5F  JSR L_JSR_($5FFC)_($5EFF) OK
$5F02  4C F4 5F  JMP L_JMP_($5FF4)_($5F02) OK
//------------------------------
L_BRS_($5F05)_($5EF3) OK
//------------------------------
$5F05  C9 19     CMP #$19
$5F07  D0 10     BNE L_BRS_($5F19)_($5F07) OK
$5F09  AD 94 1C  LDA $1C94 
$5F0C  C9 01     CMP #$01
$5F0E  F0 C7     BEQ L_BRS_($5ED7)_($5F0E) OK
$5F10  CE 94 1C  DEC $1C94 
$5F13  20 FC 5F  JSR L_JSR_($5FFC)_($5F13) OK
$5F16  4C F4 5F  JMP L_JMP_($5FF4)_($5F16) OK
//------------------------------
L_BRS_($5F19)_($5F07) OK
//------------------------------
$5F19  C9 1A     CMP #$1A
$5F1B  D0 10     BNE L_BRS_($5F2D)_($5F1B) OK
$5F1D  AD 94 1C  LDA $1C94 
$5F20  C9 68     CMP #$68
$5F22  F0 B3     BEQ L_BRS_($5ED7)_($5F22) OK
$5F24  EE 94 1C  INC $1C94 
$5F27  20 FC 5F  JSR L_JSR_($5FFC)_($5F27) OK
$5F2A  4C F4 5F  JMP L_JMP_($5FF4)_($5F2A) OK
//------------------------------
L_BRS_($5F2D)_($5F1B) OK
//------------------------------
$5F2D  C9 16     CMP #$16
$5F2F  D0 A6     BNE L_BRS_($5ED7)_($5F2F) OK
$5F31  A9 96     LDA #$96
$5F33  85 7C     STA $7C 
$5F35  A9 96     LDA #$96
$5F37  85 7D     STA $7D 
$5F39  A2 55     LDX #$55
$5F3B  A0 5E     LDY #$5E
$5F3D  20 6C 68  JSR L_JSR_($686C)_($5F3D) OK
$5F40  A9 01     LDA #$01
$5F42  20 4B CB  JSR L_JSR_($CB4B)_($5F42) OK	; TODO: start sound effect? (1: Ping)
$5F45  AD 93 1C  LDA $1C93 
$5F48  38        SEC 
$5F49  E9 40     SBC #$40
$5F4B  8D 5A 5E  STA $5E5A 
$5F4E  0E 5A 5E  ASL $5E5A 
$5F51  AD 94 1C  LDA $1C94 
$5F54  8D 5B 5E  STA $5E5B 
$5F57  A9 AC     LDA #$AC
$5F59  8D 57 5E  STA $5E57 
$5F5C  AA        TAX 
$5F5D  A9 00     LDA #$00
$5F5F  8D 58 5E  STA $5E58 
$5F62  8D 2D 17  STA $172D 
$5F65  8D 2F 17  STA $172F 
$5F68  A9 B0     LDA #$B0
$5F6A  8D 59 5E  STA $5E59 
$5F6D  A8        TAY 
$5F6E  A9 03     LDA #$03
$5F70  8D 5D 5E  STA $5E5D 
$5F73  20 F8 79  JSR L_JSR_($79F8)_($5F73) OK	; show sprite 3
$5F76  A9 03     LDA #$03
$5F78  8D 5C 5E  STA $5E5C 
//------------------------------
L_BRS_($5F7B)_($5FCF) OK
//------------------------------
$5F7B  A9 03     LDA #$03
$5F7D  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($5F80)_($5F83) OK
//------------------------------
$5F80  AD 4E 15  LDA $154E 
$5F83  D0 FB     BNE L_BRS_($5F80)_($5F83) OK
$5F85  AD 5D 5E  LDA $5E5D 
$5F88  20 41 7A  JSR L_JSR_($7A41)_($5F88) OK
$5F8B  AD 5A 5E  LDA $5E5A 
$5F8E  0A        ASL A 
$5F8F  6E 5A 5E  ROR $5E5A 
$5F92  4E 5B 5E  LSR $5E5B 
$5F95  AD 57 5E  LDA $5E57 
$5F98  18        CLC 
$5F99  6D 5A 5E  ADC $5E5A 
$5F9C  8D 57 5E  STA $5E57 
$5F9F  AA        TAX 
$5FA0  AD 58 5E  LDA $5E58 
$5FA3  69 00     ADC #$00
$5FA5  8D 58 5E  STA $5E58 
$5FA8  8D 2D 17  STA $172D 
$5FAB  AD 5A 5E  LDA $5E5A 
$5FAE  10 08     BPL L_BRS_($5FB8)_($5FAE) OK
$5FB0  A9 00     LDA #$00
$5FB2  8D 58 5E  STA $5E58 
$5FB5  8D 2D 17  STA $172D 
//------------------------------
L_BRS_($5FB8)_($5FAE) OK
//------------------------------
$5FB8  AD 59 5E  LDA $5E59 
$5FBB  38        SEC 
$5FBC  ED 5B 5E  SBC $5E5B 
$5FBF  8D 59 5E  STA $5E59 
$5FC2  A8        TAY 
$5FC3  EE 5D 5E  INC $5E5D 
$5FC6  AD 5D 5E  LDA $5E5D 
$5FC9  20 F8 79  JSR L_JSR_($79F8)_($5FC9) OK
$5FCC  CE 5C 5E  DEC $5E5C 
$5FCF  D0 AA     BNE L_BRS_($5F7B)_($5FCF) OK
$5FD1  A9 03     LDA #$03
$5FD3  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($5FD6)_($5FD9) OK
//------------------------------
$5FD6  AD 4E 15  LDA $154E 
$5FD9  D0 FB     BNE L_BRS_($5FD6)_($5FD9) OK
$5FDB  AD 5D 5E  LDA $5E5D 
$5FDE  20 41 7A  JSR L_JSR_($7A41)_($5FDE) OK
$5FE1  20 52 60  JSR L_JSR_($6052)_($5FE1) OK
$5FE4  A9 01     LDA #$01
$5FE6  8D 73 15  STA $1573 
$5FE9  8D 72 15  STA $1572 
$5FEC  AD 43 15  LDA $1543 
$5FEF  09 08     ORA #$08
$5FF1  8D 43 15  STA $1543 
//------------------------------
L_JMP_($5FF4)_($5ED7) OK
L_JMP_($5FF4)_($5EEE) OK
L_JMP_($5FF4)_($5F02) OK
L_JMP_($5FF4)_($5F16) OK
L_JMP_($5FF4)_($5F2A) OK
//------------------------------
$5FF4  60        RTS 
//------------------------------
L_JSR_($5FF5)_($5E9B) OK
L_JSR_($5FF5)_($5EA6) OK
L_JSR_($5FF5)_($5ECA) OK
//------------------------------
$5FF5  20 89 7B  JSR L_JSR_($7B89)_($5FF5) OK
$5FF8  20 DF 44  JSR L_JSR_($44DF)_($5FF8) OK
$5FFB  60        RTS 
//------------------------------
L_JSR_($5FFC)_($5EB3) OK
L_JSR_($5FFC)_($5EEB) OK
L_JSR_($5FFC)_($5EFF) OK
L_JSR_($5FFC)_($5F13) OK
L_JSR_($5FFC)_($5F27) OK
L_JSR_($5FFC)_($72D4) OK
//------------------------------
$5FFC  A9 00     LDA #$00
$5FFE  8D 2D 17  STA $172D 
$6001  A9 B2     LDA #$B2
$6003  38        SEC 
$6004  ED 94 1C  SBC $1C94 
$6007  A8        TAY 
$6008  48        PHA 
$6009  A9 2C     LDA #$2C
$600B  18        CLC 
$600C  6D 93 1C  ADC $1C93 
$600F  18        CLC 
$6010  6D 93 1C  ADC $1C93 
$6013  AA        TAX 
$6014  48        PHA 
$6015  90 03     BCC L_BRS_($601A)_($6015) OK
$6017  EE 2D 17  INC $172D 
//------------------------------
L_BRS_($601A)_($6015) OK
//------------------------------
$601A  A9 03     LDA #$03
$601C  8D 2F 17  STA $172F 
//------------------------------
L_JSR_($6020)_($1ABF) BAD
//------------------------------
$601F  A9 00     LDA #$00
$6021  20 F8 79  JSR L_JSR_($79F8)_($6021) OK
$6024  A9 00     LDA #$00
$6026  8D 2F 17  STA $172F 
$6029  68        PLA 
$602A  AA        TAX 
$602B  68        PLA 
$602C  A8        TAY 
$602D  A9 01     LDA #$01
$602F  20 F8 79  JSR L_JSR_($79F8)_($602F) OK
$6032  A0 07     LDY #$07
//------------------------------
L_BRS_($6034)_($603A) OK
//------------------------------
$6034  A2 FF     LDX #$FF
//------------------------------
L_BRS_($6036)_($6037) OK
//------------------------------
$6036  CA        DEX 
$6037  D0 FD     BNE L_BRS_($6036)_($6037) OK
$6039  88        DEY 
$603A  D0 F8     BNE L_BRS_($6034)_($603A) OK
$603C  60        RTS 
//------------------------------
$603D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$6045            .byte $00,$00,$00,$00,$00,$00,$00,$00
$604D            .byte $00,$00,$00,$00,$00
//------------------------------
L_JSR_($6052)_($2EB2) OK
L_JSR_($6052)_($5FE1) OK
//------------------------------
$6052  AD 94 15  LDA $1594 
$6055  85 7C     STA $7C 
$6057  AD 95 15  LDA $1595 
$605A  85 7D     STA $7D 
$605C  AD 54 15  LDA $1554 
$605F  D0 03     BNE L_BRS_($6064)_($605F) OK
$6061  4C D2 62  JMP L_JMP_($62D2)_($6061) OK
//------------------------------
L_BRS_($6064)_($605F) OK
//------------------------------
$6064  8D 49 60  STA $6049 
$6067  85 82     STA $82 
$6069  A9 00     LDA #$00
$606B  06 82     ASL $82 
$606D  2A        ROL A 
$606E  06 82     ASL $82 
$6070  2A        ROL A 
$6071  85 83     STA $83 
$6073  A5 82     LDA $82 
$6075  18        CLC 
$6076  65 7C     ADC $7C 
$6078  85 7C     STA $7C 
$607A  A5 83     LDA $83 
$607C  65 7D     ADC $7D 
$607E  85 7D     STA $7D 
//------------------------------
L_JMP_($6080)_($62CF) OK
//------------------------------
$6080  A0 00     LDY #$00
$6082  B1 7C     LDA ($7C),Y 
$6084  85 7E     STA $7E 
$6086  C8        INY 
$6087  B1 7C     LDA ($7C),Y 
$6089  85 7F     STA $7F 
$608B  A0 00     LDY #$00
$608D  B1 7E     LDA ($7E),Y 
$608F  C8        INY 
$6090  8D 46 60  STA $6046 
$6093  B1 7E     LDA ($7E),Y 
$6095  D0 03     BNE L_BRS_($609A)_($6095) OK
$6097  4C BD 62  JMP L_JMP_($62BD)_($6097) OK
//------------------------------
L_BRS_($609A)_($6095) OK
//------------------------------
$609A  8D 45 60  STA $6045 
$609D  10 03     BPL L_BRS_($60A2)_($609D) OK
$609F  4C AC 62  JMP L_JMP_($62AC)_($609F) OK
//------------------------------
L_BRS_($60A2)_($609D) OK
//------------------------------
$60A2  A5 7E     LDA $7E 
$60A4  18        CLC 
$60A5  69 02     ADC #$02
$60A7  85 7E     STA $7E 
$60A9  90 02     BCC L_BRS_($60AD)_($60A9) OK
$60AB  E6 7F     INC $7F 
//------------------------------
L_BRS_($60AD)_($60A9) OK
L_JMP_($60AD)_($62BA) OK
//------------------------------
$60AD  A0 00     LDY #$00
$60AF  A5 7E     LDA $7E 
$60B1  8D 3D 60  STA $603D 
$60B4  A5 7F     LDA $7F 
$60B6  8D 3E 60  STA $603E 
$60B9  B1 7E     LDA ($7E),Y 
$60BB  C8        INY 
$60BC  29 0F     AND #$0F
$60BE  8D 4E 60  STA $604E 
$60C1  A9 00     LDA #$00
$60C3  8D 50 60  STA $6050 
//------------------------------
L_BRS_($60C6)_($6103) OK
//------------------------------
$60C6  B1 7E     LDA ($7E),Y 
$60C8  38        SEC 
$60C9  ED 93 1C  SBC $1C93 
$60CC  F0 0C     BEQ L_BRS_($60DA)_($60CC) OK
$60CE  10 05     BPL L_BRS_($60D5)_($60CE) OK
$60D0  A9 01     LDA #$01
$60D2  4C DC 60  JMP L_JMP_($60DC)_($60D2) OK
//------------------------------
L_BRS_($60D5)_($60CE) OK
//------------------------------
$60D5  A9 02     LDA #$02
$60D7  4C DC 60  JMP L_JMP_($60DC)_($60D7) OK
//------------------------------
L_BRS_($60DA)_($60CC) OK
//------------------------------
$60DA  A9 04     LDA #$04
//------------------------------
L_JMP_($60DC)_($60D2) OK
L_JMP_($60DC)_($60D7) OK
//------------------------------
$60DC  0D 50 60  ORA $6050
$60DF  8D 50 60  STA $6050 
$60E2  C8        INY 
$60E3  B1 7E     LDA ($7E),Y 
$60E5  38        SEC 
$60E6  ED 94 1C  SBC $1C94 
$60E9  F0 0C     BEQ L_BRS_($60F7)_($60E9) OK
$60EB  10 05     BPL L_BRS_($60F2)_($60EB) OK
$60ED  A9 08     LDA #$08
$60EF  4C F9 60  JMP L_JMP_($60F9)_($60EF) OK
//------------------------------
L_BRS_($60F2)_($60EB) OK
//------------------------------
$60F2  A9 10     LDA #$10
$60F4  4C F9 60  JMP L_JMP_($60F9)_($60F4) OK
//------------------------------
L_BRS_($60F7)_($60E9) OK
//------------------------------
$60F7  A9 20     LDA #$20
//------------------------------
L_JMP_($60F9)_($60EF) OK
L_JMP_($60F9)_($60F4) OK
//------------------------------
$60F9  0D 50 60  ORA $6050
$60FC  8D 50 60  STA $6050 
$60FF  C8        INY 
$6100  CE 4E 60  DEC $604E 
$6103  D0 C1     BNE L_BRS_($60C6)_($6103) OK
$6105  98        TYA 
$6106  18        CLC 
$6107  65 7E     ADC $7E 
$6109  85 7E     STA $7E 
$610B  90 02     BCC L_BRS_($610F)_($610B) OK
$610D  E6 7F     INC $7F 
//------------------------------
L_BRS_($610F)_($610B) OK
//------------------------------
$610F  AE 50 60  LDX $6050 
$6112  8A        TXA 
$6113  29 20     AND #$20
$6115  D0 0A     BNE L_BRS_($6121)_($6115) OK
$6117  8A        TXA 
$6118  29 10     AND #$10
$611A  F0 14     BEQ L_BRS_($6130)_($611A) OK
$611C  8A        TXA 
$611D  29 08     AND #$08
$611F  F0 0F     BEQ L_BRS_($6130)_($611F) OK
//------------------------------
L_BRS_($6121)_($6115) OK
//------------------------------
$6121  8A        TXA 
$6122  29 04     AND #$04
$6124  D0 0D     BNE L_BRS_($6133)_($6124) OK
$6126  8A        TXA 
$6127  29 02     AND #$02
$6129  F0 05     BEQ L_BRS_($6130)_($6129) OK
$612B  8A        TXA 
$612C  29 01     AND #$01
$612E  D0 03     BNE L_BRS_($6133)_($612E) OK
//------------------------------
L_BRS_($6130)_($611A) OK
L_BRS_($6130)_($611F) OK
L_BRS_($6130)_($6129) OK
//------------------------------
$6130  4C B5 62  JMP L_JMP_($62B5)_($6130) OK
//------------------------------
L_BRS_($6133)_($6124) OK
L_BRS_($6133)_($612E) OK
//------------------------------
$6133  AD 3D 60  LDA $603D 
$6136  85 7A     STA $7A 
$6138  AD 3E 60  LDA $603E 
$613B  85 7B     STA $7B 
$613D  A0 00     LDY #$00
$613F  B1 7A     LDA ($7A),Y 
$6141  29 0F     AND #$0F
$6143  48        PHA 
$6144  0A        ASL A 
$6145  A8        TAY 
//------------------------------
L_BRS_($6146)_($614C) OK
//------------------------------
$6146  B1 7A     LDA ($7A),Y 
$6148  99 BF 00  STA $00BF,Y 
$614B  88        DEY 
$614C  D0 F8     BNE L_BRS_($6146)_($614C) OK
$614E  68        PLA 
$614F  AA        TAX 
$6150  E0 02     CPX #$02
$6152  D0 04     BNE L_BRS_($6158)_($6152) OK
$6154  CA        DEX 
$6155  4C 6A 61  JMP L_JMP_($616A)_($6155) OK
//------------------------------
L_BRS_($6158)_($6152) OK
//------------------------------
$6158  8A        TXA 
$6159  48        PHA 
$615A  0A        ASL A 
$615B  AA        TAX 
$615C  A0 01     LDY #$01
$615E  B1 7A     LDA ($7A),Y 
$6160  95 C0     STA $C0,X 
$6162  E8        INX 
$6163  C8        INY 
$6164  B1 7A     LDA ($7A),Y 
$6166  95 C0     STA $C0,X 
$6168  68        PLA 
$6169  AA        TAX 
//------------------------------
L_JMP_($616A)_($6155) OK
//------------------------------
$616A  A0 00     LDY #$00
$616C  8C 3F 60  STY $603F 
$616F  8C 51 60  STY $6051 
$6172  8E 4A 60  STX $604A 
//------------------------------
L_JMP_($6175)_($627C) OK
//------------------------------
$6175  B9 C1 00  LDA $00C1,Y 
$6178  38        SEC 
$6179  ED 94 1C  SBC $1C94 
$617C  F0 2B     BEQ L_BRS_($61A9)_($617C) OK
$617E  10 05     BPL L_BRS_($6185)_($617E) OK
$6180  A9 01     LDA #$01
$6182  4C 87 61  JMP L_JMP_($6187)_($6182) OK
//------------------------------
L_BRS_($6185)_($617E) OK
//------------------------------
$6185  A9 02     LDA #$02
//------------------------------
L_JMP_($6187)_($6182) OK
//------------------------------
$6187  0D 51 60  ORA $6051
$618A  8D 51 60  STA $6051 
$618D  B9 C3 00  LDA $00C3,Y 
$6190  38        SEC 
$6191  ED 94 1C  SBC $1C94 
$6194  F0 13     BEQ L_BRS_($61A9)_($6194) OK
$6196  10 05     BPL L_BRS_($619D)_($6196) OK
$6198  A9 01     LDA #$01
$619A  4C 9F 61  JMP L_JMP_($619F)_($619A) OK
//------------------------------
L_BRS_($619D)_($6196) OK
//------------------------------
$619D  A9 02     LDA #$02
//------------------------------
L_JMP_($619F)_($619A) OK
//------------------------------
$619F  0D 51 60  ORA $6051
$61A2  C9 03     CMP #$03
$61A4  F0 03     BEQ L_BRS_($61A9)_($61A4) OK
$61A6  4C 75 62  JMP L_JMP_($6275)_($61A6) OK
//------------------------------
L_BRS_($61A9)_($617C) OK
L_BRS_($61A9)_($6194) OK
L_BRS_($61A9)_($61A4) OK
//------------------------------
$61A9  B9 C1 00  LDA $00C1,Y 
$61AC  D9 C3 00  CMP $00C3,Y 
$61AF  D0 03     BNE L_BRS_($61B4)_($61AF) OK
$61B1  4C AC 62  JMP L_JMP_($62AC)_($61B1) OK
//------------------------------
L_BRS_($61B4)_($61AF) OK
//------------------------------
$61B4  B9 C0 00  LDA $00C0,Y 
$61B7  D9 C2 00  CMP $00C2,Y 
$61BA  D0 03     BNE L_BRS_($61BF)_($61BA) OK
$61BC  4C 67 62  JMP L_JMP_($6267)_($61BC) OK
//------------------------------
L_BRS_($61BF)_($61BA) OK
//------------------------------
$61BF  B9 C2 00  LDA $00C2,Y 
$61C2  38        SEC 
$61C3  F9 C0 00  SBC $00C0,Y 
$61C6  8D 48 60  STA $6048 
$61C9  B9 C3 00  LDA $00C3,Y 
$61CC  38        SEC 
$61CD  F9 C1 00  SBC $00C1,Y 
$61D0  85 89     STA $89 
$61D2  18        CLC 
$61D3  08        PHP 
$61D4  A9 00     LDA #$00
$61D6  85 88     STA $88 
$61D8  28        PLP 
$61D9  10 03     BPL L_BRS_($61DE)_($61D9) OK
$61DB  38        SEC 
$61DC  A9 FF     LDA #$FF
//------------------------------
L_BRS_($61DE)_($61D9) OK
//------------------------------
$61DE  4A        LSR A 
$61DF  85 8A     STA $8A 
$61E1  66 89     ROR $89 
$61E3  66 88     ROR $88 
$61E5  98        TYA 
$61E6  48        PHA 
$61E7  AD 48 60  LDA $6048 
$61EA  85 8C     STA $8C 
$61EC  08        PHP 
$61ED  A9 00     LDA #$00
$61EF  28        PLP 
$61F0  10 02     BPL L_BRS_($61F4)_($61F0) OK
$61F2  A9 FF     LDA #$FF
//------------------------------
L_BRS_($61F4)_($61F0) OK
//------------------------------
$61F4  85 8D     STA $8D 
$61F6  A5 88     LDA $88 
$61F8  A6 89     LDX $89 
$61FA  A4 8A     LDY $8A 
$61FC  20 D2 1D  JSR L_JSR_($1DD2)_($61FC) BAD
$61FF  68        PLA 
$6200  A8        TAY 
$6201  A5 88     LDA $88 
$6203  48        PHA 
$6204  A5 89     LDA $89 
$6206  48        PHA 
$6207  98        TYA 
$6208  48        PHA 
$6209  B9 C0 00  LDA $00C0,Y 
$620C  A8        TAY 
$620D  A5 88     LDA $88 
$620F  A6 89     LDX $89 
$6211  20 A3 1C  JSR L_JSR_($1CA3)_($6211) OK
$6214  A5 82     LDA $82 
$6216  8D 4B 60  STA $604B 
$6219  A5 83     LDA $83 
$621B  8D 4C 60  STA $604C 
$621E  A5 84     LDA $84 
$6220  8D 4D 60  STA $604D 
$6223  68        PLA 
$6224  A8        TAY 
$6225  48        PHA 
$6226  AD 94 1C  LDA $1C94 
$6229  38        SEC 
$622A  F9 C1 00  SBC $00C1,Y 
$622D  85 83     STA $83 
$622F  18        CLC 
$6230  08        PHP 
$6231  A9 00     LDA #$00
$6233  85 82     STA $82 
$6235  28        PLP 
$6236  10 03     BPL L_BRS_($623B)_($6236) OK
$6238  38        SEC 
$6239  A9 FF     LDA #$FF
//------------------------------
L_BRS_($623B)_($6236) OK
//------------------------------
$623B  4A        LSR A 
$623C  85 84     STA $84 
$623E  66 83     ROR $83 
$6240  66 82     ROR $82 
$6242  68        PLA 
$6243  A8        TAY 
$6244  68        PLA 
$6245  85 8D     STA $8D 
$6247  68        PLA 
$6248  85 8C     STA $8C 
$624A  98        TYA 
$624B  48        PHA 
$624C  AD 4B 60  LDA $604B 
$624F  18        CLC 
$6250  65 82     ADC $82 
$6252  48        PHA 
$6253  AD 4C 60  LDA $604C 
$6256  65 83     ADC $83 
$6258  AA        TAX 
$6259  AD 4D 60  LDA $604D 
$625C  65 84     ADC $84 
$625E  A8        TAY 
$625F  68        PLA 
$6260  20 D2 1D  JSR L_JSR_($1DD2)_($6260) BAD
$6263  68        PLA 
$6264  A8        TAY 
$6265  A5 88     LDA $88 
//------------------------------
L_JMP_($6267)_($61BC) OK
//------------------------------
$6267  AE 3F 60  LDX $603F 
$626A  E8        INX 
$626B  E0 06     CPX #$06
$626D  F0 06     BEQ L_BRS_($6275)_($626D) OK
$626F  8E 3F 60  STX $603F 
$6272  9D 3F 60  STA $603F,X 
//------------------------------
L_JMP_($6275)_($61A6) OK
L_BRS_($6275)_($626D) OK
//------------------------------
$6275  C8        INY 
$6276  C8        INY 
$6277  CE 4A 60  DEC $604A 
$627A  F0 03     BEQ L_BRS_($627F)_($627A) OK
$627C  4C 75 61  JMP L_JMP_($6175)_($627C) OK
//------------------------------
L_BRS_($627F)_($627A) OK
//------------------------------
$627F  AD 3F 60  LDA $603F 
$6282  F0 31     BEQ L_BRS_($62B5)_($6282) OK
$6284  8D 4A 60  STA $604A 
$6287  A2 01     LDX #$01
$6289  A0 00     LDY #$00
//------------------------------
L_BRS_($628B)_($62A5) OK
//------------------------------
$628B  BD 3F 60  LDA $603F,X 
$628E  38        SEC 
$628F  ED 93 1C  SBC $1C93 
$6292  F0 18     BEQ L_BRS_($62AC)_($6292) OK
$6294  10 07     BPL L_BRS_($629D)_($6294) OK
$6296  98        TYA 
$6297  09 01     ORA #$01
$6299  A8        TAY 
$629A  4C A1 62  JMP L_JMP_($62A1)_($629A) OK
//------------------------------
L_BRS_($629D)_($6294) OK
//------------------------------
$629D  98        TYA 
$629E  09 02     ORA #$02
$62A0  A8        TAY 
//------------------------------
L_JMP_($62A1)_($629A) OK
//------------------------------
$62A1  E8        INX 
$62A2  CE 4A 60  DEC $604A 
$62A5  10 E4     BPL L_BRS_($628B)_($62A5) OK
$62A7  98        TYA 
$62A8  C9 03     CMP #$03
$62AA  D0 09     BNE L_BRS_($62B5)_($62AA) OK
//------------------------------
L_JMP_($62AC)_($609F) OK
L_JMP_($62AC)_($61B1) OK
L_BRS_($62AC)_($6292) OK
//------------------------------
$62AC  AD 46 60  LDA $6046 
$62AF  8D 70 15  STA $1570 
$62B2  4C D2 62  JMP L_JMP_($62D2)_($62B2) OK
//------------------------------
L_JMP_($62B5)_($6130) OK
L_BRS_($62B5)_($6282) OK
L_BRS_($62B5)_($62AA) OK
//------------------------------
$62B5  CE 45 60  DEC $6045 
$62B8  F0 03     BEQ L_BRS_($62BD)_($62B8) OK
$62BA  4C AD 60  JMP L_JMP_($60AD)_($62BA) OK
//------------------------------
L_JMP_($62BD)_($6097) OK
L_BRS_($62BD)_($62B8) OK
//------------------------------
$62BD  A5 7C     LDA $7C 
$62BF  38        SEC 
$62C0  E9 04     SBC #$04
$62C2  85 7C     STA $7C 
$62C4  A5 7D     LDA $7D 
$62C6  E9 00     SBC #$00
$62C8  85 7D     STA $7D 
$62CA  CE 49 60  DEC $6049 
$62CD  F0 03     BEQ L_BRS_($62D2)_($62CD) OK
$62CF  4C 80 60  JMP L_JMP_($6080)_($62CF) OK
//------------------------------
L_JMP_($62D2)_($6061) OK
L_JMP_($62D2)_($62B2) OK
L_BRS_($62D2)_($62CD) OK
//------------------------------
$62D2  60        RTS 
//------------------------------
$62D3  46 37     LSR $37 
$62D5            .byte $37,$32,$37,$32
$62D9  30 32     BMI L_BRS_($630D)_($62D9) OK
//------------------------------
L_JSR_($62DB)_($4459) OK
L_JSR_($62DB)_($446F) OK
L_JSR_($62DB)_($4494) OK
L_JSR_($62DB)_($44CA) OK
//------------------------------
$62DB  8D D3 62  STA $62D3 
$62DE  A5 7C     LDA $7C 
$62E0  48        PHA 
$62E1  A5 7D     LDA $7D 
$62E3  48        PHA 
//------------------------------
L_JMP_($62E4)_($680F) OK
//------------------------------
$62E4  A0 00     LDY #$00
$62E6  B1 7C     LDA ($7C),Y 
$62E8  8D D8 62  STA $62D8 
$62EB  29 3F     AND #$3F
$62ED  8D D4 62  STA $62D4 
$62F0  AD D8 62  LDA $62D8 
$62F3  29 C0     AND #$C0
$62F5  C9 C0     CMP #$C0
$62F7  D0 03     BNE L_BRS_($62FC)_($62F7) OK
$62F9  4C EF 67  JMP L_JMP_($67EF)_($62F9) OK
//------------------------------
L_BRS_($62FC)_($62F7) OK
//------------------------------
$62FC  C9 40     CMP #$40
$62FE  D0 08     BNE L_BRS_($6308)_($62FE) OK
$6300  AE 74 15  LDX $1574 
$6303  D0 1F     BNE L_BRS_($6324)_($6303) OK
$6305  4C F2 67  JMP L_JMP_($67F2)_($6305) OK
//------------------------------
L_BRS_($6308)_($62FE) OK
//------------------------------
$6308  AE 73 15  LDX $1573 
$630B  D0 03     BNE L_BRS_($6310)_($630B) OK
//------------------------------
L_BRS_($630D)_($62D9) OK
//------------------------------
$630D  4C F2 67  JMP L_JMP_($67F2)_($630D) OK
//------------------------------
L_BRS_($6310)_($630B) OK
//------------------------------
$6310  C9 80     CMP #$80
$6312  D0 08     BNE L_BRS_($631C)_($6312) OK
$6314  AE 72 15  LDX $1572 
$6317  D0 0B     BNE L_BRS_($6324)_($6317) OK
$6319  4C F2 67  JMP L_JMP_($67F2)_($6319) OK
//------------------------------
L_BRS_($631C)_($6312) OK
//------------------------------
$631C  AE 72 15  LDX $1572 
$631F  F0 03     BEQ L_BRS_($6324)_($631F) OK
$6321  4C F2 67  JMP L_JMP_($67F2)_($6321) OK
//------------------------------
L_BRS_($6324)_($6303) OK
L_BRS_($6324)_($6317) OK
L_BRS_($6324)_($631F) OK
//------------------------------
$6324  AD D4 62  LDA $62D4 
$6327  C9 01     CMP #$01
$6329  D0 54     BNE L_BRS_($637F)_($6329) OK
$632B  AD 68 1C  LDA $1C68 
$632E  C8        INY 
$632F  18        CLC 
$6330  71 7C     ADC ($7C),Y 
$6332  8D D9 62  STA $62D9 
$6335  AD 69 1C  LDA $1C69 
$6338  C8        INY 
$6339  71 7C     ADC ($7C),Y 
$633B  8D DA 62  STA $62DA 
$633E  AD 6A 1C  LDA $1C6A 
$6341  C8        INY 
$6342  71 7C     ADC ($7C),Y 
$6344  48        PHA 
$6345  10 1D     BPL L_BRS_($6364)_($6345) OK
$6347  B1 7C     LDA ($7C),Y 
$6349  10 0D     BPL L_BRS_($6358)_($6349) OK
$634B  68        PLA 
$634C  A9 00     LDA #$00
$634E  8D DA 62  STA $62DA 
$6351  8D D9 62  STA $62D9 
$6354  48        PHA 
$6355  4C 64 63  JMP L_JMP_($6364)_($6355) OK
//------------------------------
L_BRS_($6358)_($6349) OK
//------------------------------
$6358  68        PLA 
$6359  A9 FF     LDA #$FF
$635B  8D DA 62  STA $62DA 
$635E  8D D9 62  STA $62D9 
$6361  A9 7F     LDA #$7F
$6363  48        PHA 
//------------------------------
L_BRS_($6364)_($6345) OK
L_JMP_($6364)_($6355) OK
//------------------------------
$6364  68        PLA 
$6365  8D 6A 1C  STA $1C6A 
$6368  AD DA 62  LDA $62DA 
$636B  8D 69 1C  STA $1C69 
$636E  AD D9 62  LDA $62D9 
$6371  8D 68 1C  STA $1C68 
$6374  AD 44 15  LDA $1544 
$6377  09 02     ORA #$02
$6379  8D 44 15  STA $1544 
$637C  4C F2 67  JMP L_JMP_($67F2)_($637C) OK
//------------------------------
L_BRS_($637F)_($6329) OK
//------------------------------
$637F  C9 02     CMP #$02
$6381  D0 2D     BNE L_BRS_($63B0)_($6381) OK
$6383  78        SEI 
$6384  AD 6B 1C  LDA $1C6B 
$6387  C8        INY 
$6388  18        CLC 
$6389  71 7C     ADC ($7C),Y 
$638B  F0 14     BEQ L_BRS_($63A1)_($638B) OK
$638D  10 05     BPL L_BRS_($6394)_($638D) OK
$638F  A9 00     LDA #$00
$6391  4C A1 63  JMP L_JMP_($63A1)_($6391) OK
//------------------------------
L_BRS_($6394)_($638D) OK
//------------------------------
$6394  8D D6 62  STA $62D6 
$6397  A9 23     LDA #$23
$6399  CD D6 62  CMP $62D6 
$639C  30 03     BMI L_BRS_($63A1)_($639C) OK
$639E  AD D6 62  LDA $62D6 
//------------------------------
L_BRS_($63A1)_($638B) OK
L_JMP_($63A1)_($6391) OK
L_BRS_($63A1)_($639C) OK
//------------------------------
$63A1  8D 6B 1C  STA $1C6B 
$63A4  58        CLI 
$63A5  AD 44 15  LDA $1544 
$63A8  09 04     ORA #$04
$63AA  8D 44 15  STA $1544 
$63AD  4C F2 67  JMP L_JMP_($67F2)_($63AD) OK
//------------------------------
L_BRS_($63B0)_($6381) OK
//------------------------------
$63B0  C9 13     CMP #$13
$63B2  D0 23     BNE L_BRS_($63D7)_($63B2) OK
$63B4  78        SEI 
$63B5  AD 9D 1C  LDA $1C9D 
$63B8  C8        INY 
$63B9  18        CLC 
$63BA  71 7C     ADC ($7C),Y 
$63BC  C9 0B     CMP #$0B
$63BE  10 0A     BPL L_BRS_($63CA)_($63BE) OK
$63C0  A9 01     LDA #$01
$63C2  8D 89 15  STA $1589 
$63C5  A9 0A     LDA #$0A
$63C7  4C D0 63  JMP L_JMP_($63D0)_($63C7) OK
//------------------------------
L_BRS_($63CA)_($63BE) OK
//------------------------------
$63CA  C9 3C     CMP #$3C
$63CC  90 02     BCC L_BRS_($63D0)_($63CC) OK
$63CE  A9 3C     LDA #$3C
//------------------------------
L_JMP_($63D0)_($63C7) OK
L_BRS_($63D0)_($63CC) OK
//------------------------------
$63D0  8D 9D 1C  STA $1C9D 
$63D3  58        CLI 
$63D4  4C F2 67  JMP L_JMP_($67F2)_($63D4) OK
//------------------------------
L_BRS_($63D7)_($63B2) OK
//------------------------------
$63D7  C9 03     CMP #$03
$63D9  F0 17     BEQ L_BRS_($63F2)_($63D9) OK
$63DB  C9 04     CMP #$04
$63DD  F0 13     BEQ L_BRS_($63F2)_($63DD) OK
$63DF  C9 05     CMP #$05
$63E1  F0 0F     BEQ L_BRS_($63F2)_($63E1) OK
$63E3  C9 10     CMP #$10
$63E5  F0 0B     BEQ L_BRS_($63F2)_($63E5) OK
$63E7  C9 1E     CMP #$1E
$63E9  F0 07     BEQ L_BRS_($63F2)_($63E9) OK
$63EB  C9 1F     CMP #$1F
$63ED  F0 03     BEQ L_BRS_($63F2)_($63ED) OK
$63EF  4C 29 65  JMP L_JMP_($6529)_($63EF) OK
//------------------------------
L_BRS_($63F2)_($63D9) OK
L_BRS_($63F2)_($63DD) OK
L_BRS_($63F2)_($63E1) OK
L_BRS_($63F2)_($63E5) OK
L_BRS_($63F2)_($63E9) OK
L_BRS_($63F2)_($63ED) OK
//------------------------------
$63F2  C8        INY 
$63F3  B1 7C     LDA ($7C),Y 
$63F5  8D 46 15  STA $1546 
$63F8  A5 7C     LDA $7C 
$63FA  48        PHA 
$63FB  A5 7D     LDA $7D 
$63FD  48        PHA 
$63FE  A9 00     LDA #$00
$6400  20 C1 5C  JSR L_JSR_($5CC1)_($6400) BAD
$6403  C9 00     CMP #$00
$6405  F0 03     BEQ L_BRS_($640A)_($6405) OK
$6407  4C 20 65  JMP L_JMP_($6520)_($6407) OK
//------------------------------
L_BRS_($640A)_($6405) OK
//------------------------------
$640A  AD D4 62  LDA $62D4 
$640D  A0 00     LDY #$00
$640F  C9 1E     CMP #$1E
$6411  D0 18     BNE L_BRS_($642B)_($6411) OK
$6413  B1 7C     LDA ($7C),Y 
$6415  8D D5 62  STA $62D5 
$6418  68        PLA 
$6419  85 7D     STA $7D 
$641B  68        PLA 
$641C  85 7C     STA $7C 
$641E  AD D5 62  LDA $62D5 
$6421  29 40     AND #$40
$6423  D0 03     BNE L_BRS_($6428)_($6423) OK
$6425  4C F2 67  JMP L_JMP_($67F2)_($6425) OK
//------------------------------
L_BRS_($6428)_($6423) OK
//------------------------------
$6428  4C EF 67  JMP L_JMP_($67EF)_($6428) OK
//------------------------------
L_BRS_($642B)_($6411) OK
//------------------------------
$642B  C9 1F     CMP #$1F
$642D  D0 18     BNE L_BRS_($6447)_($642D) OK
$642F  B1 7C     LDA ($7C),Y 
$6431  8D D5 62  STA $62D5 
$6434  68        PLA 
$6435  85 7D     STA $7D 
$6437  68        PLA 
$6438  85 7C     STA $7C 
$643A  AD D5 62  LDA $62D5 
$643D  29 40     AND #$40
$643F  F0 03     BEQ L_BRS_($6444)_($643F) OK
$6441  4C F2 67  JMP L_JMP_($67F2)_($6441) OK
//------------------------------
L_BRS_($6444)_($643F) OK
//------------------------------
$6444  4C EF 67  JMP L_JMP_($67EF)_($6444) OK
//------------------------------
L_BRS_($6447)_($642D) OK
//------------------------------
$6447  B1 7C     LDA ($7C),Y 
$6449  29 20     AND #$20
$644B  F0 03     BEQ L_BRS_($6450)_($644B) OK
$644D  4C 20 65  JMP L_JMP_($6520)_($644D) OK
//------------------------------
L_BRS_($6450)_($644B) OK
//------------------------------
$6450  AD D4 62  LDA $62D4 
$6453  C9 10     CMP #$10
$6455  D0 09     BNE L_BRS_($6460)_($6455) OK
$6457  B1 7C     LDA ($7C),Y 
$6459  09 20     ORA #$20
$645B  91 7C     STA ($7C),Y 
$645D  4C 89 64  JMP L_JMP_($6489)_($645D) OK
//------------------------------
L_BRS_($6460)_($6455) OK
//------------------------------
$6460  C9 03     CMP #$03
$6462  D0 09     BNE L_BRS_($646D)_($6462) OK
$6464  B1 7C     LDA ($7C),Y 
$6466  29 40     AND #$40
$6468  D0 07     BNE L_BRS_($6471)_($6468) OK
$646A  4C 89 64  JMP L_JMP_($6489)_($646A) OK
//------------------------------
L_BRS_($646D)_($6462) OK
//------------------------------
$646D  C9 04     CMP #$04
$646F  D0 18     BNE L_BRS_($6489)_($646F) OK
//------------------------------
L_BRS_($6471)_($6468) OK
//------------------------------
$6471  B1 7C     LDA ($7C),Y 
$6473  29 BF     AND #$BF
$6475  09 10     ORA #$10
$6477  91 7C     STA ($7C),Y 
$6479  A9 01     LDA #$01
$647B  8D 75 15  STA $1575 
$647E  AD 43 15  LDA $1543 
$6481  09 04     ORA #$04
$6483  8D 43 15  STA $1543 
$6486  4C 20 65  JMP L_JMP_($6520)_($6486) OK
//------------------------------
L_JMP_($6489)_($645D) OK
L_JMP_($6489)_($646A) OK
L_BRS_($6489)_($646F) OK
//------------------------------
$6489  B1 7C     LDA ($7C),Y 
$648B  09 40     ORA #$40
$648D  91 7C     STA ($7C),Y 
$648F  A9 01     LDA #$01
$6491  8D 76 15  STA $1576 
$6494  29 0F     AND #$0F
$6496  C9 02     CMP #$02
$6498  D0 2F     BNE L_BRS_($64C9)_($6498) OK
$649A  AD 98 17  LDA $1798 
$649D  F0 2A     BEQ L_BRS_($64C9)_($649D) OK
$649F  8D D8 62  STA $62D8 
$64A2  A2 00     LDX #$00
//------------------------------
L_BRS_($64A4)_($64C7) OK
//------------------------------
$64A4  BD 68 17  LDA $1768,X 
$64A7  A0 07     LDY #$07
$64A9  D1 7C     CMP ($7C),Y 
$64AB  D0 12     BNE L_BRS_($64BF)_($64AB) OK
//------------------------------
L_BRS_($64AD)_($64B2) OK
//------------------------------
$64AD  AD 51 15  LDA $1551 
$64B0  29 01     AND #$01
$64B2  D0 F9     BNE L_BRS_($64AD)_($64B2) OK
$64B4  A9 00     LDA #$00
$64B6  9D 6B 17  STA $176B,X 
$64B9  9D 3B 17  STA $173B,X 
$64BC  4C C9 64  JMP L_JMP_($64C9)_($64BC) OK
//------------------------------
L_BRS_($64BF)_($64AB) OK
//------------------------------
$64BF  98        TYA 
$64C0  18        CLC 
$64C1  69 06     ADC #$06
$64C3  A8        TAY 
$64C4  CE D8 62  DEC $62D8 
$64C7  D0 DB     BNE L_BRS_($64A4)_($64C7) OK
//------------------------------
L_BRS_($64C9)_($6498) OK
L_BRS_($64C9)_($649D) OK
L_JMP_($64C9)_($64BC) OK
//------------------------------
$64C9  AD 94 15  LDA $1594 
$64CC  18        CLC 
$64CD  69 04     ADC #$04
$64CF  85 7A     STA $7A 
$64D1  AD 95 15  LDA $1595 
$64D4  69 00     ADC #$00
$64D6  85 7B     STA $7B 
$64D8  AD 54 15  LDA $1554 
$64DB  F0 43     BEQ L_BRS_($6520)_($64DB) OK
$64DD  8D D8 62  STA $62D8 
$64E0  AE 46 15  LDX $1546 
//------------------------------
L_BRS_($64E3)_($6505) OK
//------------------------------
$64E3  A0 00     LDY #$00
$64E5  B1 7A     LDA ($7A),Y 
$64E7  85 7E     STA $7E 
$64E9  C8        INY 
$64EA  B1 7A     LDA ($7A),Y 
$64EC  85 7F     STA $7F 
$64EE  A0 00     LDY #$00
$64F0  8A        TXA 
$64F1  D1 7E     CMP ($7E),Y 
$64F3  F0 15     BEQ L_BRS_($650A)_($64F3) OK
$64F5  A5 7A     LDA $7A 
$64F7  18        CLC 
$64F8  69 04     ADC #$04
$64FA  85 7A     STA $7A 
$64FC  A5 7B     LDA $7B 
$64FE  69 00     ADC #$00
$6500  85 7B     STA $7B 
$6502  CE D8 62  DEC $62D8 
$6505  D0 DC     BNE L_BRS_($64E3)_($6505) OK
$6507  4C 20 65  JMP L_JMP_($6520)_($6507) OK
//------------------------------
L_BRS_($650A)_($64F3) OK
//------------------------------
$650A  C8        INY 
$650B  B1 7E     LDA ($7E),Y 
$650D  29 80     AND #$80
$650F  F0 03     BEQ L_BRS_($6514)_($650F) OK
$6511  CE 55 15  DEC $1555 
//------------------------------
L_BRS_($6514)_($650F) OK
//------------------------------
$6514  A9 00     LDA #$00
$6516  91 7E     STA ($7E),Y 
$6518  AD 44 15  LDA $1544 
$651B  09 08     ORA #$08
$651D  8D 44 15  STA $1544 
//------------------------------
L_JMP_($6520)_($6407) OK
L_JMP_($6520)_($644D) OK
L_JMP_($6520)_($6486) OK
L_BRS_($6520)_($64DB) OK
L_JMP_($6520)_($6507) OK
//------------------------------
$6520  68        PLA 
$6521  85 7D     STA $7D 
$6523  68        PLA 
$6524  85 7C     STA $7C 
$6526  4C F2 67  JMP L_JMP_($67F2)_($6526) OK
//------------------------------
L_JMP_($6529)_($63EF) OK
//------------------------------
$6529  C9 06     CMP #$06
$652B  F0 17     BEQ L_BRS_($6544)_($652B) OK
$652D  C9 07     CMP #$07
$652F  F0 13     BEQ L_BRS_($6544)_($652F) OK
$6531  C9 08     CMP #$08
$6533  F0 0F     BEQ L_BRS_($6544)_($6533) OK
$6535  C9 11     CMP #$11
$6537  F0 0B     BEQ L_BRS_($6544)_($6537) OK
$6539  C9 20     CMP #$20
$653B  F0 07     BEQ L_BRS_($6544)_($653B) OK
$653D  C9 21     CMP #$21
$653F  F0 03     BEQ L_BRS_($6544)_($653F) OK
$6541  4C D7 65  JMP L_JMP_($65D7)_($6541) OK
//------------------------------
L_BRS_($6544)_($652B) OK
L_BRS_($6544)_($652F) OK
L_BRS_($6544)_($6533) OK
L_BRS_($6544)_($6537) OK
L_BRS_($6544)_($653B) OK
L_BRS_($6544)_($653F) OK
//------------------------------
$6544  A0 02     LDY #$02
$6546  B1 7C     LDA ($7C),Y 
$6548  8D 46 15  STA $1546 
$654B  88        DEY 
$654C  A5 7C     LDA $7C 
$654E  48        PHA 
$654F  A5 7D     LDA $7D 
$6551  48        PHA 
$6552  A0 01     LDY #$01
$6554  B1 7C     LDA ($7C),Y 
$6556  20 C1 5C  JSR L_JSR_($5CC1)_($6556) BAD
$6559  D0 73     BNE L_BRS_($65CE)_($6559) OK
$655B  A0 00     LDY #$00
$655D  AD D4 62  LDA $62D4 
$6560  C9 20     CMP #$20
$6562  D0 18     BNE L_BRS_($657C)_($6562) OK
$6564  B1 7C     LDA ($7C),Y 
$6566  8D D5 62  STA $62D5 
$6569  68        PLA 
$656A  85 7D     STA $7D 
$656C  68        PLA 
$656D  85 7C     STA $7C 
$656F  AD D5 62  LDA $62D5 
$6572  29 40     AND #$40
$6574  D0 03     BNE L_BRS_($6579)_($6574) OK
$6576  4C F2 67  JMP L_JMP_($67F2)_($6576) OK
//------------------------------
L_BRS_($6579)_($6574) OK
//------------------------------
$6579  4C EF 67  JMP L_JMP_($67EF)_($6579) OK
//------------------------------
L_BRS_($657C)_($6562) OK
//------------------------------
$657C  C9 21     CMP #$21
$657E  D0 18     BNE L_BRS_($6598)_($657E) OK
$6580  B1 7C     LDA ($7C),Y 
$6582  8D D5 62  STA $62D5 
$6585  68        PLA 
$6586  85 7D     STA $7D 
$6588  68        PLA 
$6589  85 7C     STA $7C 
$658B  AD D5 62  LDA $62D5 
$658E  29 40     AND #$40
$6590  F0 03     BEQ L_BRS_($6595)_($6590) OK
$6592  4C F2 67  JMP L_JMP_($67F2)_($6592) OK
//------------------------------
L_BRS_($6595)_($6590) OK
//------------------------------
$6595  4C EF 67  JMP L_JMP_($67EF)_($6595) OK
//------------------------------
L_BRS_($6598)_($657E) OK
//------------------------------
$6598  B1 7C     LDA ($7C),Y 
$659A  29 20     AND #$20
$659C  D0 30     BNE L_BRS_($65CE)_($659C) OK
$659E  AD D4 62  LDA $62D4 
$65A1  C9 11     CMP #$11
$65A3  D0 09     BNE L_BRS_($65AE)_($65A3) OK
$65A5  B1 7C     LDA ($7C),Y 
$65A7  09 20     ORA #$20
$65A9  91 7C     STA ($7C),Y 
$65AB  4C C8 65  JMP L_JMP_($65C8)_($65AB) OK
//------------------------------
L_BRS_($65AE)_($65A3) OK
//------------------------------
$65AE  C9 06     CMP #$06
$65B0  D0 09     BNE L_BRS_($65BB)_($65B0) OK
$65B2  B1 7C     LDA ($7C),Y 
$65B4  29 40     AND #$40
$65B6  D0 07     BNE L_BRS_($65BF)_($65B6) OK
$65B8  4C C8 65  JMP L_JMP_($65C8)_($65B8) OK
//------------------------------
L_BRS_($65BB)_($65B0) OK
//------------------------------
$65BB  C9 07     CMP #$07
$65BD  D0 09     BNE L_BRS_($65C8)_($65BD) OK
//------------------------------
L_BRS_($65BF)_($65B6) OK
//------------------------------
$65BF  B1 7C     LDA ($7C),Y 
$65C1  29 BF     AND #$BF
$65C3  91 7C     STA ($7C),Y 
$65C5  4C CE 65  JMP L_JMP_($65CE)_($65C5) OK
//------------------------------
L_JMP_($65C8)_($65AB) OK
L_JMP_($65C8)_($65B8) OK
L_BRS_($65C8)_($65BD) OK
//------------------------------
$65C8  B1 7C     LDA ($7C),Y 
$65CA  09 40     ORA #$40
$65CC  91 7C     STA ($7C),Y 
//------------------------------
L_BRS_($65CE)_($6559) OK
L_BRS_($65CE)_($659C) OK
L_JMP_($65CE)_($65C5) OK
//------------------------------
$65CE  68        PLA 
$65CF  85 7D     STA $7D 
$65D1  68        PLA 
$65D2  85 7C     STA $7C 
$65D4  4C F2 67  JMP L_JMP_($67F2)_($65D4) OK
//------------------------------
L_JMP_($65D7)_($6541) OK
//------------------------------
$65D7  C9 09     CMP #$09
$65D9  F0 0C     BEQ L_BRS_($65E7)_($65D9) OK
$65DB  C9 0A     CMP #$0A
$65DD  F0 08     BEQ L_BRS_($65E7)_($65DD) OK
$65DF  C9 0B     CMP #$0B
$65E1  F0 04     BEQ L_BRS_($65E7)_($65E1) OK
$65E3  C9 14     CMP #$14
$65E5  D0 41     BNE L_BRS_($6628)_($65E5) OK
//------------------------------
L_BRS_($65E7)_($65D9) OK
L_BRS_($65E7)_($65DD) OK
L_BRS_($65E7)_($65E1) OK
//------------------------------
$65E7  A0 01     LDY #$01
$65E9  B1 7C     LDA ($7C),Y 
$65EB  AA        TAX 
$65EC  AD D4 62  LDA $62D4 
$65EF  C9 09     CMP #$09
$65F1  D0 06     BNE L_BRS_($65F9)_($65F1) OK
$65F3  FE 6F 1C  INC $1C6F,X 
$65F6  4C 00 66  JMP L_JMP_($6600)_($65F6) OK
//------------------------------
L_BRS_($65F9)_($65F1) OK
//------------------------------
$65F9  C9 0A     CMP #$0A
$65FB  D0 0E     BNE L_BRS_($660B)_($65FB) OK
$65FD  DE 6F 1C  DEC $1C6F,X 
//------------------------------
L_JMP_($6600)_($65F6) OK
//------------------------------
$6600  AD 44 15  LDA $1544 
$6603  09 40     ORA #$40
$6605  8D 44 15  STA $1544 
$6608  4C 25 66  JMP L_JMP_($6625)_($6608) OK
//------------------------------
L_BRS_($660B)_($65FB) OK
//------------------------------
$660B  C9 14     CMP #$14
$660D  D0 0A     BNE L_BRS_($6619)_($660D) OK
$660F  A0 02     LDY #$02
$6611  B1 7C     LDA ($7C),Y 
$6613  9D 6F 1C  STA $1C6F,X 
$6616  4C 25 66  JMP L_JMP_($6625)_($6616) OK
//------------------------------
L_BRS_($6619)_($660D) OK
//------------------------------
$6619  A0 02     LDY #$02
$661B  B1 7C     LDA ($7C),Y 
$661D  DD 6F 1C  CMP $1C6F,X 
$6620  F0 03     BEQ L_BRS_($6625)_($6620) OK
$6622  4C EF 67  JMP L_JMP_($67EF)_($6622) OK
//------------------------------
L_JMP_($6625)_($6608) OK
L_JMP_($6625)_($6616) OK
L_BRS_($6625)_($6620) OK
//------------------------------
$6625  4C F2 67  JMP L_JMP_($67F2)_($6625) OK
//------------------------------
L_BRS_($6628)_($65E5) OK
//------------------------------
$6628  C9 0C     CMP #$0C
$662A  F0 0F     BEQ L_BRS_($663B)_($662A) OK
$662C  C9 0D     CMP #$0D
$662E  F0 0B     BEQ L_BRS_($663B)_($662E) OK
$6630  C9 0E     CMP #$0E
$6632  F0 07     BEQ L_BRS_($663B)_($6632) OK
$6634  C9 1D     CMP #$1D
$6636  F0 03     BEQ L_BRS_($663B)_($6636) OK
$6638  4C BA 66  JMP L_JMP_($66BA)_($6638) OK
//------------------------------
L_BRS_($663B)_($662A) OK
L_BRS_($663B)_($662E) OK
L_BRS_($663B)_($6632) OK
L_BRS_($663B)_($6636) OK
//------------------------------
$663B  A0 01     LDY #$01
$663D  B1 7C     LDA ($7C),Y 
$663F  38        SEC 
$6640  E9 01     SBC #$01
$6642  A2 00     LDX #$00
$6644  C9 08     CMP #$08
$6646  30 14     BMI L_BRS_($665C)_($6646) OK
$6648  38        SEC 
$6649  E9 08     SBC #$08
$664B  E8        INX 
$664C  C9 08     CMP #$08
$664E  30 0C     BMI L_BRS_($665C)_($664E) OK
$6650  38        SEC 
$6651  E9 08     SBC #$08
$6653  E8        INX 
$6654  C9 08     CMP #$08
$6656  30 04     BMI L_BRS_($665C)_($6656) OK
$6658  38        SEC 
$6659  E9 08     SBC #$08
$665B  E8        INX 
//------------------------------
L_BRS_($665C)_($6646) OK
L_BRS_($665C)_($664E) OK
L_BRS_($665C)_($6656) OK
//------------------------------
$665C  A0 01     LDY #$01
$665E  8C D7 62  STY $62D7 
$6661  C9 00     CMP #$00
$6663  F0 0B     BEQ L_BRS_($6670)_($6663) OK
$6665  8D D8 62  STA $62D8 
//------------------------------
L_BRS_($6668)_($666E) OK
//------------------------------
$6668  0E D7 62  ASL $62D7 
$666B  CE D8 62  DEC $62D8 
$666E  D0 F8     BNE L_BRS_($6668)_($666E) OK
//------------------------------
L_BRS_($6670)_($6663) OK
//------------------------------
$6670  AD D4 62  LDA $62D4 
$6673  C9 1D     CMP #$1D
$6675  D0 0B     BNE L_BRS_($6682)_($6675) OK
$6677  AD D7 62  LDA $62D7 
$667A  3D 6C 1C  AND $1C6C,X 
$667D  F0 07     BEQ L_BRS_($6686)_($667D) OK
$667F  4C 96 66  JMP L_JMP_($6696)_($667F) OK
//------------------------------
L_BRS_($6682)_($6675) OK
//------------------------------
$6682  C9 0C     CMP #$0C
$6684  D0 0C     BNE L_BRS_($6692)_($6684) OK
//------------------------------
L_BRS_($6686)_($667D) OK
//------------------------------
$6686  AD D7 62  LDA $62D7 
$6689  1D 6C 1C  ORA $1C6C,X
$668C  9D 6C 1C  STA $1C6C,X 
$668F  4C B7 66  JMP L_JMP_($66B7)_($668F) OK
//------------------------------
L_BRS_($6692)_($6684) OK
//------------------------------
$6692  C9 0D     CMP #$0D
$6694  D0 0E     BNE L_BRS_($66A4)_($6694) OK
//------------------------------
L_JMP_($6696)_($667F) OK
//------------------------------
$6696  AD D7 62  LDA $62D7 
$6699  49 FF     EOR #$FF
$669B  3D 6C 1C  AND $1C6C,X 
$669E  9D 6C 1C  STA $1C6C,X 
$66A1  4C B7 66  JMP L_JMP_($66B7)_($66A1) OK
//------------------------------
L_BRS_($66A4)_($6694) OK
//------------------------------
$66A4  AD D7 62  LDA $62D7 
$66A7  3D 6C 1C  AND $1C6C,X 
$66AA  F0 02     BEQ L_BRS_($66AE)_($66AA) OK
$66AC  A9 01     LDA #$01
//------------------------------
L_BRS_($66AE)_($66AA) OK
//------------------------------
$66AE  A0 02     LDY #$02
$66B0  D1 7C     CMP ($7C),Y 
$66B2  F0 03     BEQ L_BRS_($66B7)_($66B2) OK
$66B4  4C EF 67  JMP L_JMP_($67EF)_($66B4) OK
//------------------------------
L_JMP_($66B7)_($668F) OK
L_JMP_($66B7)_($66A1) OK
L_BRS_($66B7)_($66B2) OK
//------------------------------
$66B7  4C F2 67  JMP L_JMP_($67F2)_($66B7) OK
//------------------------------
L_JMP_($66BA)_($6638) OK
//------------------------------
$66BA  C9 0F     CMP #$0F
$66BC  F0 1C     BEQ L_BRS_($66DA)_($66BC) OK
$66BE  C9 1C     CMP #$1C
$66C0  D0 22     BNE L_BRS_($66E4)_($66C0) OK
$66C2  AD 43 15  LDA $1543 
$66C5  29 04     AND #$04
$66C7  D0 07     BNE L_BRS_($66D0)_($66C7) OK
$66C9  AD 44 15  LDA $1544 
$66CC  29 08     AND #$08
$66CE  F0 0A     BEQ L_BRS_($66DA)_($66CE) OK
//------------------------------
L_BRS_($66D0)_($66C7) OK
//------------------------------
$66D0  A0 01     LDY #$01
$66D2  B1 7C     LDA ($7C),Y 
$66D4  8D 49 15  STA $1549 
$66D7  4C F2 67  JMP L_JMP_($67F2)_($66D7) OK
//------------------------------
L_BRS_($66DA)_($66BC) OK
L_BRS_($66DA)_($66CE) OK
//------------------------------
$66DA  A0 01     LDY #$01
$66DC  B1 7C     LDA ($7C),Y 
$66DE  20 4B CB  JSR L_JSR_($CB4B)_($66DE) OK	; TODO: start sound effect (from script?)
$66E1  4C F2 67  JMP L_JMP_($67F2)_($66E1) OK
//------------------------------
L_BRS_($66E4)_($66C0) OK
//------------------------------
$66E4  C9 12     CMP #$12
$66E6  D0 38     BNE L_BRS_($6720)_($66E6) OK
$66E8  A9 07     LDA #$07
$66EA  8D 49 15  STA $1549 
$66ED  A0 01     LDY #$01
$66EF  AD 47 1C  LDA $1C47 
$66F2  8D 48 1C  STA $1C48 
$66F5  B1 7C     LDA ($7C),Y 
$66F7  C9 FF     CMP #$FF
$66F9  F0 03     BEQ L_BRS_($66FE)_($66F9) OK
$66FB  8D 47 1C  STA $1C47 
//------------------------------
L_BRS_($66FE)_($66F9) OK
//------------------------------
$66FE  C8        INY 
$66FF  B1 7C     LDA ($7C),Y 
$6701  8D 50 15  STA $1550 
$6704  A5 7C     LDA $7C 
$6706  48        PHA 
$6707  A5 7D     LDA $7D 
$6709  48        PHA 
$670A  20 A2 49  JSR L_JSR_($49A2)_($670A) OK
$670D  68        PLA 
$670E  85 7D     STA $7D 
$6710  68        PLA 
$6711  85 7C     STA $7C 
$6713  A9 7F     LDA #$7F
$6715  8D 44 15  STA $1544 
$6718  A9 FC     LDA #$FC
$671A  8D 43 15  STA $1543 
$671D  4C F2 67  JMP L_JMP_($67F2)_($671D) OK
//------------------------------
L_BRS_($6720)_($66E6) OK
//------------------------------
$6720  C9 22     CMP #$22
$6722  D0 4E     BNE L_BRS_($6772)_($6722) OK
$6724  A9 44     LDA #$44
$6726  85 7A     STA $7A 
$6728  A9 19     LDA #$19
$672A  85 7B     STA $7B 
$672C  A0 01     LDY #$01
$672E  B1 7C     LDA ($7C),Y 
$6730  AA        TAX 
$6731  CA        DEX 
$6732  F0 0E     BEQ L_BRS_($6742)_($6732) OK
//------------------------------
L_BRS_($6734)_($6740) OK
//------------------------------
$6734  A9 10     LDA #$10
$6736  18        CLC 
$6737  65 7A     ADC $7A 
$6739  85 7A     STA $7A 
$673B  90 02     BCC L_BRS_($673F)_($673B) OK
$673D  E6 7B     INC $7B 
//------------------------------
L_BRS_($673F)_($673B) OK
//------------------------------
$673F  CA        DEX 
$6740  D0 F2     BNE L_BRS_($6734)_($6740) OK
//------------------------------
L_BRS_($6742)_($6732) OK
//------------------------------
$6742  A6 7A     LDX $7A 
$6744  A4 7B     LDY $7B 
$6746  A5 7C     LDA $7C 
$6748  48        PHA 
$6749  A5 7D     LDA $7D 
$674B  48        PHA 
$674C  A9 78     LDA #$78
$674E  85 7C     STA $7C 
$6750  A9 96     LDA #$96
$6752  85 7D     STA $7D 
$6754  20 6C 68  JSR L_JSR_($686C)_($6754) OK	; print text at room name
$6757  68        PLA 
$6758  85 7D     STA $7D 
$675A  68        PLA 
$675B  85 7C     STA $7C 
$675D  AD 89 15  LDA $1589 
$6760  D0 0D     BNE L_BRS_($676F)_($6760) OK
$6762  A9 32     LDA #$32
$6764  8D 4E 15  STA $154E 
$6767  AD 44 15  LDA $1544 
$676A  09 20     ORA #$20
$676C  8D 44 15  STA $1544 
//------------------------------
L_BRS_($676F)_($6760) OK
//------------------------------
$676F  4C F2 67  JMP L_JMP_($67F2)_($676F) OK
//------------------------------
L_BRS_($6772)_($6722) OK
//------------------------------
$6772  C9 19     CMP #$19
$6774  D0 44     BNE L_BRS_($67BA)_($6774) OK
$6776  AD 5C 1C  LDA $1C5C 
$6779  38        SEC 
$677A  E9 04     SBC #$04
$677C  85 7E     STA $7E 
$677E  AD 5D 1C  LDA $1C5D 
$6781  E9 00     SBC #$00
$6783  85 7F     STA $7F 
$6785  A0 01     LDY #$01
$6787  B1 7C     LDA ($7C),Y 
$6789  29 CC     AND #$CC
$678B  F0 12     BEQ L_BRS_($679F)_($678B) OK
$678D  A9 04     LDA #$04
$678F  8D D8 62  STA $62D8 
//------------------------------
L_BRS_($6792)_($679A) OK
//------------------------------
$6792  B1 7E     LDA ($7E),Y 
$6794  99 64 1C  STA $1C64,Y 
$6797  C8        INY 
$6798  C0 04     CPY #$04
$679A  90 F6     BCC L_BRS_($6792)_($679A) OK
$679C  4C B4 67  JMP L_JMP_($67B4)_($679C) OK
//------------------------------
L_BRS_($679F)_($678B) OK
//------------------------------
$679F  A0 01     LDY #$01
$67A1  B1 7C     LDA ($7C),Y 
$67A3  48        PHA 
$67A4  29 03     AND #$03
$67A6  A8        TAY 
$67A7  68        PLA 
$67A8  29 30     AND #$30
$67AA  4A        LSR A 
$67AB  4A        LSR A 
$67AC  4A        LSR A 
$67AD  4A        LSR A 
$67AE  AA        TAX 
$67AF  B1 7E     LDA ($7E),Y 
$67B1  9D 64 1C  STA $1C64,X 
//------------------------------
L_JMP_($67B4)_($679C) OK
//------------------------------
$67B4  20 33 5B  JSR L_JSR_($5B33)_($67B4) BAD
$67B7  4C F2 67  JMP L_JMP_($67F2)_($67B7) OK
//------------------------------
L_BRS_($67BA)_($6774) OK
//------------------------------
$67BA  C9 1A     CMP #$1A
$67BC  D0 1A     BNE L_BRS_($67D8)_($67BC) OK
$67BE  A5 7C     LDA $7C 
$67C0  48        PHA 
$67C1  A5 7D     LDA $7D 
$67C3  48        PHA 
$67C4  20 88 1F  JSR L_JSR_($1F88)_($67C4) OK
$67C7  68        PLA 
$67C8  85 7D     STA $7D 
$67CA  68        PLA 
$67CB  85 7C     STA $7C 
$67CD  A9 00     LDA #$00
$67CF  8D 43 15  STA $1543 
$67D2  8D 44 15  STA $1544 
$67D5  4C F2 67  JMP L_JMP_($67F2)_($67D5) OK
//------------------------------
L_BRS_($67D8)_($67BC) OK
//------------------------------
$67D8  C9 1B     CMP #$1B
$67DA  D0 0F     BNE L_BRS_($67EB)_($67DA) OK
$67DC  A0 01     LDY #$01
$67DE  B1 7C     LDA ($7C),Y 
$67E0  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($67E3)_($67E6) OK
//------------------------------
$67E3  AD 4E 15  LDA $154E 
$67E6  D0 FB     BNE L_BRS_($67E3)_($67E6) OK
$67E8  4C F2 67  JMP L_JMP_($67F2)_($67E8) OK
//------------------------------
L_BRS_($67EB)_($67DA) OK
//------------------------------
$67EB  C9 23     CMP #$23
$67ED  F0 03     BEQ L_BRS_($67F2)_($67ED) OK
//------------------------------
L_JMP_($67EF)_($62F9) OK
L_JMP_($67EF)_($6428) OK
L_JMP_($67EF)_($6444) OK
L_JMP_($67EF)_($6579) OK
L_JMP_($67EF)_($6595) OK
L_JMP_($67EF)_($6622) OK
L_JMP_($67EF)_($66B4) OK
//------------------------------
$67EF  4C 12 68  JMP L_JMP_($6812)_($67EF) OK
//------------------------------
L_JMP_($67F2)_($6305) OK
L_JMP_($67F2)_($630D) OK
L_JMP_($67F2)_($6319) OK
L_JMP_($67F2)_($6321) OK
L_JMP_($67F2)_($637C) OK
L_JMP_($67F2)_($63AD) OK
L_JMP_($67F2)_($63D4) OK
L_JMP_($67F2)_($6425) OK
L_JMP_($67F2)_($6441) OK
L_JMP_($67F2)_($6526) OK
L_JMP_($67F2)_($6576) OK
L_JMP_($67F2)_($6592) OK
L_JMP_($67F2)_($65D4) OK
L_JMP_($67F2)_($6625) OK
L_JMP_($67F2)_($66B7) OK
L_JMP_($67F2)_($66D7) OK
L_JMP_($67F2)_($66E1) OK
L_JMP_($67F2)_($671D) OK
L_JMP_($67F2)_($676F) OK
L_JMP_($67F2)_($67B7) OK
L_JMP_($67F2)_($67D5) OK
L_JMP_($67F2)_($67E8) OK
L_BRS_($67F2)_($67ED) OK
//------------------------------
$67F2  AE D4 62  LDX $62D4 
$67F5  BD 0D 19  LDA $190D,X 
$67F8  18        CLC 
$67F9  65 7C     ADC $7C 
$67FB  85 7C     STA $7C 
$67FD  90 02     BCC L_BRS_($6801)_($67FD) OK
$67FF  E6 7D     INC $7D 
//------------------------------
L_BRS_($6801)_($67FD) OK
//------------------------------
$6801  AD D3 62  LDA $62D3 
$6804  38        SEC 
$6805  FD 0D 19  SBC $190D,X 
$6808  8D D3 62  STA $62D3 
$680B  F0 05     BEQ L_BRS_($6812)_($680B) OK
$680D  30 03     BMI L_BRS_($6812)_($680D) OK
$680F  4C E4 62  JMP L_JMP_($62E4)_($680F) OK
//------------------------------
L_JMP_($6812)_($67EF) OK
L_BRS_($6812)_($680B) OK
L_BRS_($6812)_($680D) OK
//------------------------------
$6812  68        PLA 
$6813  85 7D     STA $7D 
$6815  68        PLA 
$6816  85 7C     STA $7C 
$6818  60        RTS 
//------------------------------
L_JSR_($6819)_($69DC) OK
//------------------------------
$6819  84 B0     STY $B0 
$681B  A2 00     LDX #$00
$681D  C9 04     CMP #$04
$681F  F0 11     BEQ L_BRS_($6832)_($681F) OK
$6821  8E 19 17  STX $1719 
$6824  C9 03     CMP #$03
$6826  F0 0A     BEQ L_BRS_($6832)_($6826) OK
$6828  8E 18 17  STX $1718 
$682B  C9 02     CMP #$02
$682D  F0 03     BEQ L_BRS_($6832)_($682D) OK
$682F  8E 17 17  STX $1717 
//------------------------------
L_BRS_($6832)_($681F) OK
L_BRS_($6832)_($6826) OK
L_BRS_($6832)_($682D) OK
//------------------------------
$6832  AE 2A 17  LDX $172A 
$6835  AD 16 17  LDA $1716 
$6838  85 88     STA $88 
$683A  AD 17 17  LDA $1717 
$683D  85 89     STA $89 
$683F  AD 18 17  LDA $1718 
$6842  85 8A     STA $8A 
$6844  AD 19 17  LDA $1719 
$6847  85 8B     STA $8B 
//------------------------------
L_BRS_($6849)_($6866) OK
//------------------------------
$6849  A5 B0     LDA $B0 
$684B  85 8C     STA $8C 
$684D  A9 00     LDA #$00
$684F  85 8D     STA $8D 
$6851  86 B1     STX $B1 
$6853  20 DE 1E  JSR L_JSR_($1EDE)_($6853) OK
$6856  A6 B1     LDX $B1 
$6858  A5 82     LDA $82 
$685A  C9 0A     CMP #$0A
$685C  90 02     BCC L_BRS_($6860)_($685C) OK
$685E  69 10     ADC #$10
//------------------------------
L_BRS_($6860)_($685C) OK
//------------------------------
$6860  69 30     ADC #$30
$6862  9D 19 17  STA $1719,X 
$6865  CA        DEX 
$6866  D0 E1     BNE L_BRS_($6849)_($6866) OK
$6868  60        RTS 
//------------------------------
$6869            .byte $00,$00,$00
//------------------------------
L_JSR_($686C)_($411F) OK
L_JSR_($686C)_($42C0) OK
L_JSR_($686C)_($4384) OK
L_JSR_($686C)_($5F3D) OK
L_JSR_($686C)_($6754) OK
L_JSR_($686C)_($69F0) OK
L_JSR_($686C)_($69FF) OK
L_JSR_($686C)_($6A0E) OK
L_JSR_($686C)_($6A6E) OK
L_JSR_($686C)_($6A95) OK
L_JSR_($686C)_($6ACF) OK
L_JSR_($686C)_($6AFE) OK
L_JSR_($686C)_($6B25) OK
L_JSR_($686C)_($7221) OK
L_JSR_($686C)_($7230) OK
L_JSR_($686C)_($723F) OK
L_JSR_($686C)_($724E) OK
L_JSR_($686C)_($72B1) OK
L_JSR_($686C)_($732F) OK
L_JSR_($686C)_($733E) OK
L_JSR_($686C)_($7364) OK
L_JSR_($686C)_($7382) OK
L_JSR_($686C)_($7391) OK
L_JSR_($686C)_($7406) OK
L_JSR_($686C)_($7420) OK
L_JSR_($686C)_($7E5A) OK
L_JSR_($686C)_($856E) OK
//------------------------------
$686C  A9 01     LDA #$01
$686E  4C 73 68  JMP L_JMP_($6873)_($686E) OK
//------------------------------
L_JSR_($6871)_($7C29) OK
L_JSR_($6871)_($7CEB) OK
//------------------------------
$6871  A9 00     LDA #$00
//------------------------------
L_JMP_($6873)_($686E) OK
//------------------------------
$6873  8D 6B 68  STA $686B 
$6876  A5 7C     LDA $7C 
$6878  48        PHA 
$6879  A5 7D     LDA $7D 
$687B  48        PHA 
$687C  86 7A     STX $7A 
$687E  84 7B     STY $7B 
$6880  A0 02     LDY #$02
$6882  B1 7C     LDA ($7C),Y 
$6884  8D 69 68  STA $6869 
$6887  88        DEY 
$6888  B1 7C     LDA ($7C),Y 
$688A  AA        TAX 
$688B  88        DEY 
$688C  B1 7C     LDA ($7C),Y 
$688E  85 7C     STA $7C 
$6890  86 7D     STX $7D 
//------------------------------
L_JMP_($6892)_($693E) OK
//------------------------------
$6892  A5 7C     LDA $7C 
$6894  8D 49 69  STA $6949 
$6897  A5 7D     LDA $7D 
$6899  8D 4A 69  STA $694A 
$689C  A0 00     LDY #$00
$689E  B1 7A     LDA ($7A),Y 
$68A0  38        SEC 
$68A1  E9 20     SBC #$20
$68A3  85 82     STA $82 
$68A5  0A        ASL A 
$68A6  18        CLC 
$68A7  65 82     ADC $82 
$68A9  AA        TAX 
$68AA  29 01     AND #$01
$68AC  85 82     STA $82 
$68AE  F0 05     BEQ L_BRS_($68B5)_($68AE) OK
$68B0  8A        TXA 
$68B1  38        SEC 
$68B2  E9 03     SBC #$03
$68B4  AA        TAX 
//------------------------------
L_BRS_($68B5)_($68AE) OK
//------------------------------
$68B5  AD 6B 68  LDA $686B 
$68B8  F0 03     BEQ L_BRS_($68BD)_($68B8) OK
$68BA  AD 30 17  LDA $1730 
//------------------------------
L_BRS_($68BD)_($68B8) OK
//------------------------------
$68BD  20 4B 69  JSR L_JSR_($694B)_($68BD) OK
$68C0  A0 06     LDY #$06
//------------------------------
L_BRS_($68C2)_($691B) OK
//------------------------------
$68C2  A9 00     LDA #$00
$68C4  8D 6A 68  STA $686A 
$68C7  A5 82     LDA $82 
$68C9  08        PHP 
$68CA  BD 00 08  LDA $0800,X 
$68CD  28        PLP 
$68CE  F0 04     BEQ L_BRS_($68D4)_($68CE) OK
$68D0  0A        ASL A 
$68D1  0A        ASL A 
$68D2  0A        ASL A 
$68D3  0A        ASL A 
//------------------------------
L_BRS_($68D4)_($68CE) OK
//------------------------------
$68D4  0A        ASL A 
$68D5  90 07     BCC L_BRS_($68DE)_($68D5) OK
$68D7  48        PHA 
$68D8  A9 C0     LDA #$C0
$68DA  8D 6A 68  STA $686A 
$68DD  68        PLA 
//------------------------------
L_BRS_($68DE)_($68D5) OK
//------------------------------
$68DE  0A        ASL A 
$68DF  90 0A     BCC L_BRS_($68EB)_($68DF) OK
$68E1  48        PHA 
$68E2  A9 30     LDA #$30
$68E4  0D 6A 68  ORA $686A
$68E7  8D 6A 68  STA $686A 
$68EA  68        PLA 
//------------------------------
L_BRS_($68EB)_($68DF) OK
//------------------------------
$68EB  0A        ASL A 
$68EC  90 0A     BCC L_BRS_($68F8)_($68EC) OK
$68EE  48        PHA 
$68EF  A9 0C     LDA #$0C
$68F1  0D 6A 68  ORA $686A
$68F4  8D 6A 68  STA $686A 
$68F7  68        PLA 
//------------------------------
L_BRS_($68F8)_($68EC) OK
//------------------------------
$68F8  0A        ASL A 
$68F9  90 08     BCC L_BRS_($6903)_($68F9) OK
$68FB  A9 03     LDA #$03
$68FD  0D 6A 68  ORA $686A
$6900  8D 6A 68  STA $686A 
//------------------------------
L_BRS_($6903)_($68F9) OK
//------------------------------
$6903  AD 6B 68  LDA $686B 
$6906  F0 08     BEQ L_BRS_($6910)_($6906) OK
$6908  AD 6A 68  LDA $686A 
$690B  49 FF     EOR #$FF
$690D  8D 6A 68  STA $686A 
//------------------------------
L_BRS_($6910)_($6906) OK
//------------------------------
$6910  AD 6A 68  LDA $686A 
$6913  2D 30 17  AND $1730 
$6916  20 48 69  JSR L_JSR_($6948)_($6916) OK
$6919  E8        INX 
$691A  88        DEY 
$691B  D0 A5     BNE L_BRS_($68C2)_($691B) OK
$691D  AD 6B 68  LDA $686B 
$6920  F0 03     BEQ L_BRS_($6925)_($6920) OK
$6922  AD 30 17  LDA $1730 
//------------------------------
L_BRS_($6925)_($6920) OK
//------------------------------
$6925  20 4B 69  JSR L_JSR_($694B)_($6925) OK
$6928  E6 7A     INC $7A 
$692A  D0 02     BNE L_BRS_($692E)_($692A) OK
$692C  E6 7B     INC $7B 
//------------------------------
L_BRS_($692E)_($692A) OK
//------------------------------
$692E  A5 7C     LDA $7C 
$6930  18        CLC 
$6931  69 08     ADC #$08
$6933  85 7C     STA $7C 
$6935  90 02     BCC L_BRS_($6939)_($6935) OK
$6937  E6 7D     INC $7D 
//------------------------------
L_BRS_($6939)_($6935) OK
//------------------------------
$6939  CE 69 68  DEC $6869 
$693C  F0 03     BEQ L_BRS_($6941)_($693C) OK
$693E  4C 92 68  JMP L_JMP_($6892)_($693E) OK
//------------------------------
L_BRS_($6941)_($693C) OK
//------------------------------
$6941  68        PLA 
$6942  85 7D     STA $7D 
$6944  68        PLA 
$6945  85 7C     STA $7C 
$6947  60        RTS 
//------------------------------
L_JSR_($6948)_($6916) OK
//------------------------------
$6948  8D FF FF  STA $FFFF 	; TODO: updates screen for?
//------------------------------
L_JSR_($694B)_($68BD) OK
L_JSR_($694B)_($6925) OK
//------------------------------
$694B  EE 49 69  INC $6949 
$694E  D0 03     BNE L_BRS_($6953)_($694E) OK
$6950  EE 4A 69  INC $694A 
//------------------------------
L_BRS_($6953)_($694E) OK
//------------------------------
$6953  AD 49 69  LDA $6949 
$6956  29 07     AND #$07
$6958  D0 11     BNE L_BRS_($696B)_($6958) OK
$695A  AD 49 69  LDA $6949 
$695D  18        CLC 
$695E  69 38     ADC #$38
$6960  8D 49 69  STA $6949 
$6963  90 03     BCC L_BRS_($6968)_($6963) OK
$6965  EE 4A 69  INC $694A 
//------------------------------
L_BRS_($6968)_($6963) OK
//------------------------------
$6968  EE 4A 69  INC $694A 
//------------------------------
L_BRS_($696B)_($6958) OK
//------------------------------
$696B  60        RTS 
//------------------------------
$696C  60        RTS 
//------------------------------
$696D  61 5E     ADC ($5E,X) 
$696F            .byte $5F,$5C
$6971  5D 66 67  EOR $6766,X 
$6974            .byte $64
$6975  65 62     ADC $62 
$6977            .byte $63
$6978  6A        ROR A 
$6979            .byte $6B
$697A  68        PLA 
$697B  69 6E     ADC #$6E
$697D            .byte $6F
$697E  6C 6D 00  JMP ($006D) 
$6981            .byte $00
//------------------------------
L_JSR_($6982)_($2004) OK
L_JSR_($6982)_($5E7C) OK
//------------------------------
$6982  AD 3C 1C  LDA $1C3C 
$6985  CD 6E 15  CMP $156E 
$6988  F0 26     BEQ L_BRS_($69B0)_($6988) OK
$698A  8D 6E 15  STA $156E 
$698D  18        CLC 
$698E  69 10     ADC #$10
$6990  C9 10     CMP #$10
$6992  D0 05     BNE L_BRS_($6999)_($6992) OK
$6994  A2 02     LDX #$02
$6996  8E 89 15  STX $1589 
//------------------------------
L_BRS_($6999)_($6992) OK
//------------------------------
$6999  18        CLC 
$699A  69 E5     ADC #$E5
$699C  AA        TAX 
$699D  A9 00     LDA #$00
$699F  69 00     ADC #$00
$69A1  8D 2D 17  STA $172D 
$69A4  A0 31     LDY #$31
$69A6  A9 05     LDA #$05
$69A8  8D 2F 17  STA $172F 
$69AB  A9 02     LDA #$02
$69AD  20 F8 79  JSR L_JSR_($79F8)_($69AD) OK
//------------------------------
L_BRS_($69B0)_($6988) OK
//------------------------------
$69B0  AD 77 15  LDA $1577 
$69B3  C9 01     CMP #$01
$69B5  F0 03     BEQ L_BRS_($69BA)_($69B5) OK
$69B7  4C 16 6A  JMP L_JMP_($6A16)_($69B7) OK
//------------------------------
L_BRS_($69BA)_($69B5) OK
//------------------------------
$69BA  AD 44 15  LDA $1544 
$69BD  29 02     AND #$02
$69BF  F0 55     BEQ L_BRS_($6A16)_($69BF) OK
$69C1  AD 68 1C  LDA $1C68 
$69C4  8D 16 17  STA $1716 
$69C7  AD 69 1C  LDA $1C69 
$69CA  8D 17 17  STA $1717 
$69CD  AD 6A 1C  LDA $1C6A 
$69D0  8D 18 17  STA $1718 
$69D3  A0 0A     LDY #$0A
$69D5  A9 07     LDA #$07
$69D7  8D 2A 17  STA $172A 
$69DA  A9 03     LDA #$03
$69DC  20 19 68  JSR L_JSR_($6819)_($69DC) OK
$69DF  A9 FF     LDA #$FF
$69E1  8D 30 17  STA $1730 
$69E4  A2 1A     LDX #$1A
$69E6  A0 17     LDY #$17
$69E8  A9 75     LDA #$75
$69EA  85 7C     STA $7C 
$69EC  A9 96     LDA #$96
$69EE  85 7D     STA $7D 
$69F0  20 6C 68  JSR L_JSR_($686C)_($69F0) OK	; print milion digit
$69F3  A2 1B     LDX #$1B
$69F5  A0 17     LDY #$17
$69F7  A9 90     LDA #$90
$69F9  85 7C     STA $7C 
$69FB  A9 96     LDA #$96
$69FD  85 7D     STA $7D 
$69FF  20 6C 68  JSR L_JSR_($686C)_($69FF) OK
$6A02  A2 1E     LDX #$1E
$6A04  A0 17     LDY #$17
$6A06  A9 93     LDA #$93
$6A08  85 7C     STA $7C 
$6A0A  A9 96     LDA #$96
$6A0C  85 7D     STA $7D 
$6A0E  20 6C 68  JSR L_JSR_($686C)_($6A0E) OK
$6A11  A9 55     LDA #$55
$6A13  8D 30 17  STA $1730 
//------------------------------
L_JMP_($6A16)_($69B7) OK
L_BRS_($6A16)_($69BF) OK
//------------------------------
$6A16  AD 44 15  LDA $1544 
$6A19  29 40     AND #$40
$6A1B  F0 34     BEQ L_BRS_($6A51)_($6A1B) OK
$6A1D  A2 00     LDX #$00
$6A1F  AD 8F 1C  LDA $1C8F 
$6A22  F0 15     BEQ L_BRS_($6A39)_($6A22) OK
$6A24  C9 06     CMP #$06
$6A26  90 02     BCC L_BRS_($6A2A)_($6A26) OK
$6A28  A9 05     LDA #$05
//------------------------------
L_BRS_($6A2A)_($6A26) OK
//------------------------------
$6A2A  48        PHA 
$6A2B  A8        TAY 
$6A2C  A9 77     LDA #$77
//------------------------------
L_BRS_($6A2E)_($6A36) OK
//------------------------------
$6A2E  9D 07 C4  STA $C407,X 		; TODO: color change on tokens in top left
$6A31  9D 2F C4  STA $C42F,X 
$6A34  E8        INX 
$6A35  88        DEY 
$6A36  D0 F6     BNE L_BRS_($6A2E)_($6A36) OK
$6A38  68        PLA 
//------------------------------
L_BRS_($6A39)_($6A22) OK
//------------------------------
$6A39  8D 80 69  STA $6980 
$6A3C  A9 05     LDA #$05
$6A3E  38        SEC 
$6A3F  ED 80 69  SBC $6980 
$6A42  F0 0D     BEQ L_BRS_($6A51)_($6A42) OK
$6A44  A8        TAY 
$6A45  A9 22     LDA #$22
//------------------------------
L_BRS_($6A47)_($6A4F) OK
//------------------------------
$6A47  9D 07 C4  STA $C407,X 	; TODO: color change on tokens in top left
$6A4A  9D 2F C4  STA $C42F,X 
$6A4D  E8        INX 
$6A4E  88        DEY 
$6A4F  D0 F6     BNE L_BRS_($6A47)_($6A4F) OK
//------------------------------
L_BRS_($6A51)_($6A1B) OK
L_BRS_($6A51)_($6A42) OK
//------------------------------
$6A51  AD 37 1C  LDA $1C37 
$6A54  0A        ASL A 
$6A55  A8        TAY 
$6A56  B9 72 69  LDA $6972,Y 
$6A59  8D 1A 17  STA $171A 
$6A5C  B9 73 69  LDA $6973,Y 
$6A5F  8D 1B 17  STA $171B 
$6A62  A2 1A     LDX #$1A
$6A64  A0 17     LDY #$17
$6A66  A9 7B     LDA #$7B
$6A68  85 7C     STA $7C 
$6A6A  A9 96     LDA #$96
$6A6C  85 7D     STA $7D 
$6A6E  20 6C 68  JSR L_JSR_($686C)_($6A6E) OK	; hieroglyph on the left
$6A71  AD 43 15  LDA $1543 
$6A74  29 80     AND #$80
$6A76  F0 20     BEQ L_BRS_($6A98)_($6A76) OK
$6A78  AD 3D 1C  LDA $1C3D 
$6A7B  0A        ASL A 
$6A7C  A8        TAY 
$6A7D  B9 6C 69  LDA $696C,Y 
$6A80  8D 1A 17  STA $171A 
$6A83  B9 6D 69  LDA $696D,Y 
$6A86  8D 1B 17  STA $171B 
$6A89  A2 1A     LDX #$1A
$6A8B  A0 17     LDY #$17
$6A8D  A9 7E     LDA #$7E
$6A8F  85 7C     STA $7C 
$6A91  A9 96     LDA #$96
$6A93  85 7D     STA $7D 
$6A95  20 6C 68  JSR L_JSR_($686C)_($6A95) OK
//------------------------------
L_BRS_($6A98)_($6A76) OK
//------------------------------
$6A98  AD 43 15  LDA $1543 
$6A9B  29 20     AND #$20
$6A9D  F0 06     BEQ L_BRS_($6AA5)_($6A9D) OK
$6A9F  AD 39 1C  LDA $1C39 
$6AA2  8D 31 15  STA $1531 
//------------------------------
L_BRS_($6AA5)_($6A9D) OK
//------------------------------
$6AA5  AD 43 15  LDA $1543 
$6AA8  29 01     AND #$01
$6AAA  F0 26     BEQ L_BRS_($6AD2)_($6AAA) OK
$6AAC  AE 78 69  LDX $6978 
$6AAF  AC 79 69  LDY $6979 
$6AB2  AD 91 1C  LDA $1C91 
$6AB5  F0 06     BEQ L_BRS_($6ABD)_($6AB5) OK
$6AB7  AE 7A 69  LDX $697A 
$6ABA  AC 7B 69  LDY $697B 
//------------------------------
L_BRS_($6ABD)_($6AB5) OK
//------------------------------
$6ABD  8E 1A 17  STX $171A 
$6AC0  8C 1B 17  STY $171B 
$6AC3  A2 1A     LDX #$1A
$6AC5  A0 17     LDY #$17
$6AC7  A9 99     LDA #$99
$6AC9  85 7C     STA $7C 
$6ACB  A9 96     LDA #$96
$6ACD  85 7D     STA $7D 
$6ACF  20 6C 68  JSR L_JSR_($686C)_($6ACF) OK
//------------------------------
L_BRS_($6AD2)_($6AAA) OK
//------------------------------
$6AD2  AD 43 15  LDA $1543 
$6AD5  29 08     AND #$08
$6AD7  F0 28     BEQ L_BRS_($6B01)_($6AD7) OK
$6AD9  AE 7C 69  LDX $697C 
$6ADC  AC 7D 69  LDY $697D 
$6ADF  AD 3F 1C  LDA $1C3F 
$6AE2  C9 01     CMP #$01
$6AE4  F0 06     BEQ L_BRS_($6AEC)_($6AE4) OK
$6AE6  AE 7E 69  LDX $697E 
$6AE9  AC 7F 69  LDY $697F 
//------------------------------
L_BRS_($6AEC)_($6AE4) OK
//------------------------------
$6AEC  8E 1A 17  STX $171A 
$6AEF  8C 1B 17  STY $171B 
$6AF2  A2 1A     LDX #$1A
$6AF4  A0 17     LDY #$17
$6AF6  A9 96     LDA #$96
$6AF8  85 7C     STA $7C 
$6AFA  A9 96     LDA #$96
$6AFC  85 7D     STA $7D 
$6AFE  20 6C 68  JSR L_JSR_($686C)_($6AFE) OK
//------------------------------
L_BRS_($6B01)_($6AD7) OK
//------------------------------
$6B01  AD 44 15  LDA $1544 
$6B04  29 80     AND #$80
$6B06  F0 05     BEQ L_BRS_($6B0D)_($6B06) OK
$6B08  78        SEI 
$6B09  20 A2 7A  JSR L_JSR_($7AA2)_($6B09) OK
$6B0C  58        CLI 
//------------------------------
L_BRS_($6B0D)_($6B06) OK
//------------------------------
$6B0D  AD 44 15  LDA $1544 
$6B10  29 20     AND #$20
$6B12  F0 14     BEQ L_BRS_($6B28)_($6B12) OK
//------------------------------
L_BRS_($6B14)_($6B17) OK
//------------------------------
$6B14  AD 4E 15  LDA $154E 
$6B17  D0 FB     BNE L_BRS_($6B14)_($6B17) OK
$6B19  A9 78     LDA #$78
$6B1B  85 7C     STA $7C 
$6B1D  A9 96     LDA #$96
$6B1F  85 7D     STA $7D 
$6B21  A2 4C     LDX #$4C
$6B23  A0 1C     LDY #$1C
$6B25  20 6C 68  JSR L_JSR_($686C)_($6B25) OK ; print text at room name position
//------------------------------
L_BRS_($6B28)_($6B12) OK
//------------------------------
$6B28  60        RTS 
//------------------------------
$6B29            .byte $00
//------------------------------
L_JSR_($6B2A)_($6CB1) OK
L_JSR_($6B2A)_($7D8D) OK
L_JSR_($6B2A)_($7D95) OK
//------------------------------
$6B2A  AD 6F 15  LDA $156F 	; TODO: water level in bottle
$6B2D  0A        ASL A 
$6B2E  18        CLC 
$6B2F  69 C7     ADC #$C7
$6B31  85 7A     STA $7A 
$6B33  A9 00     LDA #$00
$6B35  69 1A     ADC #$1A
$6B37  85 7B     STA $7B 
$6B39  AD 6F 15  LDA $156F 
$6B3C  38        SEC 
$6B3D  ED 6B 1C  SBC $1C6B 
$6B40  F0 62     BEQ L_BRS_($6BA4)_($6B40) OK
$6B42  10 36     BPL L_BRS_($6B7A)_($6B42) OK
$6B44  8D 29 6B  STA $6B29 
$6B47  A9 00     LDA #$00
$6B49  38        SEC 
$6B4A  ED 29 6B  SBC $6B29 
$6B4D  AA        TAX 
//------------------------------
L_BRS_($6B4E)_($6B75) OK
//------------------------------
$6B4E  A0 00     LDY #$00
$6B50  B1 7A     LDA ($7A),Y 
$6B52  8D 60 6B  STA $6B60 
$6B55  C8        INY 
$6B56  B1 7A     LDA ($7A),Y 
$6B58  8D 61 6B  STA $6B61 
$6B5B  A0 20     LDY #$20
//------------------------------
L_BRS_($6B5D)_($6B67) OK
//------------------------------
$6B5D  A9 FF     LDA #$FF
$6B5F  99 FF FF  STA $FFFF,Y 
$6B62  98        TYA 
$6B63  38        SEC 
$6B64  E9 08     SBC #$08
$6B66  A8        TAY 
$6B67  D0 F4     BNE L_BRS_($6B5D)_($6B67) OK
$6B69  A5 7A     LDA $7A 
$6B6B  18        CLC 
$6B6C  69 02     ADC #$02
$6B6E  85 7A     STA $7A 
$6B70  90 02     BCC L_BRS_($6B74)_($6B70) OK
$6B72  E6 7B     INC $7B 
//------------------------------
L_BRS_($6B74)_($6B70) OK
//------------------------------
$6B74  CA        DEX 
$6B75  D0 D7     BNE L_BRS_($6B4E)_($6B75) OK
$6B77  4C A4 6B  JMP L_JMP_($6BA4)_($6B77) OK
//------------------------------
L_BRS_($6B7A)_($6B42) OK
//------------------------------
$6B7A  AA        TAX 
//------------------------------
L_BRS_($6B7B)_($6BA2) OK
//------------------------------
$6B7B  A5 7A     LDA $7A 
$6B7D  38        SEC 
$6B7E  E9 02     SBC #$02
$6B80  85 7A     STA $7A 
$6B82  B0 02     BCS L_BRS_($6B86)_($6B82) OK
$6B84  C6 7B     DEC $7B 
//------------------------------
L_BRS_($6B86)_($6B82) OK
//------------------------------
$6B86  A0 00     LDY #$00
$6B88  B1 7A     LDA ($7A),Y 
$6B8A  8D 98 6B  STA $6B98 
$6B8D  C8        INY 
$6B8E  B1 7A     LDA ($7A),Y 
$6B90  8D 99 6B  STA $6B99 
$6B93  A0 20     LDY #$20
//------------------------------
L_BRS_($6B95)_($6B9F) OK
//------------------------------
$6B95  A9 00     LDA #$00
$6B97  99 FF FF  STA $FFFF,Y 
$6B9A  98        TYA 
$6B9B  38        SEC 
$6B9C  E9 08     SBC #$08
$6B9E  A8        TAY 
$6B9F  D0 F4     BNE L_BRS_($6B95)_($6B9F) OK
$6BA1  CA        DEX 
$6BA2  D0 D7     BNE L_BRS_($6B7B)_($6BA2) OK
//------------------------------
L_BRS_($6BA4)_($6B40) OK
L_JMP_($6BA4)_($6B77) OK
//------------------------------
$6BA4  AD 6B 1C  LDA $1C6B 
$6BA7  8D 6F 15  STA $156F 
$6BAA  60        RTS 
//------------------------------
$6BAB            .byte $00,$00,$00
//------------------------------
L_JSR_($6BAE)_($40A1) OK
L_JSR_($6BAE)_($852A) OK
L_JSR_($6BAE)_($8546) OK
//------------------------------
$6BAE  78        SEI 		; TODO: startup code
$6BAF  A9 D0     LDA #$D0
$6BB1  8D 14 03  STA $0314 
$6BB4  A9 6B     LDA #$6B
$6BB6  8D 15 03  STA $0315 
$6BB9  A9 B6     LDA #$B6
$6BBB  8D 18 03  STA $0318 
$6BBE  A9 6E     LDA #$6E
$6BC0  8D 19 03  STA $0319 
$6BC3  A9 00     LDA #$00
$6BC5  8D 51 15  STA $1551 
$6BC8  8D C6 1A  STA $1AC6 
$6BCB  8D AD 6B  STA $6BAD 
$6BCE  58        CLI 
$6BCF  60        RTS 
//------------------------------
$6BD0  A9 01     LDA #$01
$6BD2  8D C6 1A  STA $1AC6 
$6BD5  AD 8B 5D  LDA $5D8B 
$6BD8  8D 8A 5D  STA $5D8A 
$6BDB  AD 2B 17  LDA $172B 
$6BDE  48        PHA 
$6BDF  AD 2C 17  LDA $172C 
$6BE2  48        PHA 
$6BE3  AD 2F 17  LDA $172F 
$6BE6  48        PHA 
$6BE7  A5 7A     LDA $7A 
$6BE9  48        PHA 
$6BEA  A5 7B     LDA $7B 
$6BEC  48        PHA 
$6BED  A5 7C     LDA $7C 
$6BEF  48        PHA 
$6BF0  A5 7D     LDA $7D 
$6BF2  48        PHA 
$6BF3  A5 7E     LDA $7E 
$6BF5  48        PHA 
$6BF6  A5 7F     LDA $7F 
$6BF8  48        PHA 
$6BF9  A5 85     LDA $85 
$6BFB  48        PHA 
$6BFC  A5 84     LDA $84 
$6BFE  48        PHA 
$6BFF  A5 83     LDA $83 
$6C01  48        PHA 
$6C02  A5 82     LDA $82 
$6C04  48        PHA 
$6C05  AD 36 17  LDA $1736 
$6C08  F0 1E     BEQ L_BRS_($6C28)_($6C08) OK
$6C0A  A5 A7     LDA $A7 
$6C0C  48        PHA 
$6C0D  A5 A8     LDA $A8 
$6C0F  48        PHA 
$6C10  A5 A9     LDA $A9 
$6C12  48        PHA 
$6C13  A5 AA     LDA $AA 
$6C15  48        PHA 
$6C16  20 01 09  JSR L_JSR_($0901)_($6C16) OK	; TODO: sound player?
$6C19  68        PLA 
$6C1A  85 AA     STA $AA 
$6C1C  68        PLA 
$6C1D  85 A9     STA $A9 
$6C1F  68        PLA 
$6C20  85 A8     STA $A8 
$6C22  68        PLA 
$6C23  85 A7     STA $A7 
$6C25  4C 2B 6C  JMP L_JMP_($6C2B)_($6C25) OK
//------------------------------
L_BRS_($6C28)_($6C08) OK
//------------------------------
$6C28  20 2D CC  JSR L_JSR_($CC2D)_($6C28) OK	; TODO: sound effect player?
//------------------------------
L_JMP_($6C2B)_($6C25) OK
//------------------------------
$6C2B  AD 4E 15  LDA $154E 
$6C2E  F0 03     BEQ L_BRS_($6C33)_($6C2E) OK
$6C30  CE 4E 15  DEC $154E 
//------------------------------
L_BRS_($6C33)_($6C2E) OK
//------------------------------
$6C33  AD 89 15  LDA $1589 
$6C36  F0 03     BEQ L_BRS_($6C3B)_($6C36) OK
$6C38  4C 9D 6D  JMP L_JMP_($6D9D)_($6C38) OK
//------------------------------
L_BRS_($6C3B)_($6C36) OK
//------------------------------
$6C3B  AD 6C 15  LDA $156C 
$6C3E  D0 12     BNE L_BRS_($6C52)_($6C3E) OK
$6C40  EE 9E 1C  INC $1C9E 
$6C43  AD 9E 1C  LDA $1C9E 
$6C46  C9 3C     CMP #$3C
$6C48  F0 03     BEQ L_BRS_($6C4D)_($6C48) OK
$6C4A  4C 17 6D  JMP L_JMP_($6D17)_($6C4A) OK
//------------------------------
L_BRS_($6C4D)_($6C48) OK
//------------------------------
$6C4D  A9 00     LDA #$00
$6C4F  8D 9E 1C  STA $1C9E 
//------------------------------
L_BRS_($6C52)_($6C3E) OK
//------------------------------
$6C52  EE 98 1C  INC $1C98 
$6C55  AD 98 1C  LDA $1C98 
$6C58  C9 0A     CMP #$0A
$6C5A  D0 0B     BNE L_BRS_($6C67)_($6C5A) OK
$6C5C  A9 00     LDA #$00
$6C5E  8D 98 1C  STA $1C98 
$6C61  EE 8D 1C  INC $1C8D 
$6C64  EE 8E 1C  INC $1C8E 
//------------------------------
L_BRS_($6C67)_($6C5A) OK
//------------------------------
$6C67  EE 9A 1C  INC $1C9A 
$6C6A  D0 17     BNE L_BRS_($6C83)_($6C6A) OK
$6C6C  EE 9B 1C  INC $1C9B 
$6C6F  A9 02     LDA #$02
$6C71  CD 9B 1C  CMP $1C9B 
$6C74  D0 0D     BNE L_BRS_($6C83)_($6C74) OK
$6C76  A9 00     LDA #$00
$6C78  8D 9B 1C  STA $1C9B 
$6C7B  A9 01     LDA #$01
$6C7D  8D 6D 15  STA $156D 
$6C80  CE 3C 1C  DEC $1C3C 
//------------------------------
L_BRS_($6C83)_($6C6A) OK
L_BRS_($6C83)_($6C74) OK
//------------------------------
$6C83  AD 6C 15  LDA $156C 
$6C86  D0 36     BNE L_BRS_($6CBE)_($6C86) OK
$6C88  EE 99 1C  INC $1C99 
$6C8B  AD 99 1C  LDA $1C99 
$6C8E  C9 1E     CMP #$1E
$6C90  D0 2C     BNE L_BRS_($6CBE)_($6C90) OK
$6C92  A9 00     LDA #$00
$6C94  8D 99 1C  STA $1C99 
$6C97  AD 6B 1C  LDA $1C6B 
$6C9A  D0 12     BNE L_BRS_($6CAE)_($6C9A) OK
$6C9C  CE 9D 1C  DEC $1C9D 
$6C9F  AD 9D 1C  LDA $1C9D 
$6CA2  C9 0A     CMP #$0A
$6CA4  D0 18     BNE L_BRS_($6CBE)_($6CA4) OK
$6CA6  A9 01     LDA #$01
$6CA8  8D 89 15  STA $1589 
$6CAB  4C BE 6C  JMP L_JMP_($6CBE)_($6CAB) OK
//------------------------------
L_BRS_($6CAE)_($6C9A) OK
//------------------------------
$6CAE  CE 6B 1C  DEC $1C6B 
$6CB1  20 2A 6B  JSR L_JSR_($6B2A)_($6CB1) OK
$6CB4  AD 9D 1C  LDA $1C9D 
$6CB7  C9 3C     CMP #$3C
$6CB9  90 03     BCC L_BRS_($6CBE)_($6CB9) OK
$6CBB  EE 9D 1C  INC $1C9D 
//------------------------------
L_BRS_($6CBE)_($6C86) OK
L_BRS_($6CBE)_($6C90) OK
L_BRS_($6CBE)_($6CA4) OK
L_JMP_($6CBE)_($6CAB) OK
L_BRS_($6CBE)_($6CB9) OK
//------------------------------
$6CBE  EE 9C 1C  INC $1C9C 
$6CC1  AD 9C 1C  LDA $1C9C 
$6CC4  C9 3C     CMP #$3C
$6CC6  D0 0F     BNE L_BRS_($6CD7)_($6CC6) OK
$6CC8  A9 00     LDA #$00
$6CCA  8D 9C 1C  STA $1C9C 
$6CCD  AD 9D 1C  LDA $1C9D 
$6CD0  C9 3C     CMP #$3C
$6CD2  B0 03     BCS L_BRS_($6CD7)_($6CD2) OK
$6CD4  EE 9D 1C  INC $1C9D 
//------------------------------
L_BRS_($6CD7)_($6CC6) OK
L_BRS_($6CD7)_($6CD2) OK
//------------------------------
$6CD7  EE 97 1C  INC $1C97 
$6CDA  AD 97 1C  LDA $1C97 
$6CDD  C9 3C     CMP #$3C
$6CDF  D0 33     BNE L_BRS_($6D14)_($6CDF) OK
$6CE1  A9 00     LDA #$00
$6CE3  8D 97 1C  STA $1C97 
$6CE6  EE 96 1C  INC $1C96 
$6CE9  AD 96 1C  LDA $1C96 
$6CEC  C9 0C     CMP #$0C
$6CEE  F0 15     BEQ L_BRS_($6D05)_($6CEE) OK
$6CF0  C9 18     CMP #$18
$6CF2  F0 11     BEQ L_BRS_($6D05)_($6CF2) OK
$6CF4  C9 24     CMP #$24
$6CF6  F0 0D     BEQ L_BRS_($6D05)_($6CF6) OK
$6CF8  C9 30     CMP #$30
$6CFA  F0 09     BEQ L_BRS_($6D05)_($6CFA) OK
$6CFC  C9 3C     CMP #$3C
$6CFE  D0 14     BNE L_BRS_($6D14)_($6CFE) OK
$6D00  A9 00     LDA #$00
$6D02  8D 96 1C  STA $1C96 
//------------------------------
L_BRS_($6D05)_($6CEE) OK
L_BRS_($6D05)_($6CF2) OK
L_BRS_($6D05)_($6CF6) OK
L_BRS_($6D05)_($6CFA) OK
//------------------------------
$6D05  EE 95 1C  INC $1C95 
$6D08  AD 95 1C  LDA $1C95 
$6D0B  C9 3C     CMP #$3C
$6D0D  D0 05     BNE L_BRS_($6D14)_($6D0D) OK
$6D0F  A9 00     LDA #$00
$6D11  8D 95 1C  STA $1C95 
//------------------------------
L_BRS_($6D14)_($6CDF) OK
L_BRS_($6D14)_($6CFE) OK
L_BRS_($6D14)_($6D0D) OK
//------------------------------
$6D14  20 A2 7A  JSR L_JSR_($7AA2)_($6D14) OK
//------------------------------
L_JMP_($6D17)_($6C4A) OK
//------------------------------
$6D17  AD 30 15  LDA $1530 
$6D1A  CD 31 15  CMP $1531 
$6D1D  F0 3D     BEQ L_BRS_($6D5C)_($6D1D) OK
$6D1F  A2 FF     LDX #$FF
$6D21  18        CLC 
$6D22  ED 31 15  SBC $1531 
$6D25  10 0B     BPL L_BRS_($6D32)_($6D25) OK
$6D27  A2 01     LDX #$01
$6D29  8D AC 6B  STA $6BAC 
$6D2C  A9 00     LDA #$00
$6D2E  38        SEC 
$6D2F  ED AC 6B  SBC $6BAC 
//------------------------------
L_BRS_($6D32)_($6D25) OK
//------------------------------
$6D32  8E AC 6B  STX $6BAC 
$6D35  C9 24     CMP #$24
$6D37  90 09     BCC L_BRS_($6D42)_($6D37) OK
$6D39  A9 00     LDA #$00
$6D3B  38        SEC 
$6D3C  ED AC 6B  SBC $6BAC 
$6D3F  8D AC 6B  STA $6BAC 
//------------------------------
L_BRS_($6D42)_($6D37) OK
//------------------------------
$6D42  AD 30 15  LDA $1530 
$6D45  18        CLC 
$6D46  6D AC 6B  ADC $6BAC 
$6D49  10 05     BPL L_BRS_($6D50)_($6D49) OK
$6D4B  A9 47     LDA #$47
$6D4D  4C 56 6D  JMP L_JMP_($6D56)_($6D4D) OK
//------------------------------
L_BRS_($6D50)_($6D49) OK
//------------------------------
$6D50  C9 48     CMP #$48
$6D52  D0 02     BNE L_BRS_($6D56)_($6D52) OK
$6D54  A9 00     LDA #$00
//------------------------------
L_JMP_($6D56)_($6D4D) OK
L_BRS_($6D56)_($6D52) OK
//------------------------------
$6D56  8D 30 15  STA $1530 
$6D59  20 F9 76  JSR L_JSR_($76F9)_($6D59) OK
//------------------------------
L_BRS_($6D5C)_($6D1D) OK
//------------------------------
$6D5C  CE 6B 15  DEC $156B 
$6D5F  AD 6B 15  LDA $156B 
$6D62  F0 22     BEQ L_BRS_($6D86)_($6D62) OK
$6D64  C9 05     CMP #$05
$6D66  D0 35     BNE L_BRS_($6D9D)_($6D66) OK
$6D68  AD 01 C8  LDA $C801 	; TODO: sfx flag?
$6D6B  D0 05     BNE L_BRS_($6D72)_($6D6B) OK
$6D6D  A9 01     LDA #$01
$6D6F  20 4B CB  JSR L_JSR_($CB4B)_($6D6F) OK	; TODO: start sound effect? (1: Ping)
//------------------------------
L_BRS_($6D72)_($6D6B) OK
//------------------------------
$6D72  A2 0F     LDX #$0F
//------------------------------
L_BRS_($6D74)_($6D81) OK
//------------------------------
$6D74  BD 2D 1B  LDA $1B2D,X 	; TODO: heart update on screen
$6D77  9D F0 FA  STA $FAF0,X 
$6D7A  BD 3D 1B  LDA $1B3D,X 
$6D7D  9D 30 FC  STA $FC30,X 
$6D80  CA        DEX 
$6D81  10 F1     BPL L_BRS_($6D74)_($6D81) OK
$6D83  4C 9D 6D  JMP L_JMP_($6D9D)_($6D83) OK
//------------------------------
L_BRS_($6D86)_($6D62) OK
//------------------------------
$6D86  AD 9D 1C  LDA $1C9D 
$6D89  8D 6B 15  STA $156B 
$6D8C  A2 0F     LDX #$0F
//------------------------------
L_BRS_($6D8E)_($6D9B) OK
//------------------------------
$6D8E  BD 0D 1B  LDA $1B0D,X 	; TODO: heart update on screen
$6D91  9D F0 FA  STA $FAF0,X 
$6D94  BD 1D 1B  LDA $1B1D,X 
$6D97  9D 30 FC  STA $FC30,X 
$6D9A  CA        DEX 
$6D9B  10 F1     BPL L_BRS_($6D8E)_($6D9B) OK
//------------------------------
L_JMP_($6D9D)_($6C38) OK
L_BRS_($6D9D)_($6D66) OK
L_JMP_($6D9D)_($6D83) OK
//------------------------------
$6D9D  A9 01     LDA #$01
$6D9F  2D 51 15  AND $1551 
$6DA2  D0 0A     BNE L_BRS_($6DAE)_($6DA2) OK
$6DA4  A9 04     LDA #$04
$6DA6  2D 51 15  AND $1551 
$6DA9  F0 03     BEQ L_BRS_($6DAE)_($6DA9) OK
//------------------------------
L_BRS_($6DAB)_($6DB9) OK
//------------------------------
$6DAB  4C 7F 6E  JMP L_JMP_($6E7F)_($6DAB) OK
//------------------------------
L_BRS_($6DAE)_($6DA2) OK
L_BRS_($6DAE)_($6DA9) OK
//------------------------------
$6DAE  A9 FE     LDA #$FE
$6DB0  2D 51 15  AND $1551 
$6DB3  8D 51 15  STA $1551 
$6DB6  AD 98 17  LDA $1798 
$6DB9  F0 F0     BEQ L_BRS_($6DAB)_($6DB9) OK
$6DBB  8D AB 6B  STA $6BAB 
$6DBE  A2 00     LDX #$00
//------------------------------
L_JMP_($6DC0)_($6E7C) OK
//------------------------------
$6DC0  AD AD 6B  LDA $6BAD 
$6DC3  F0 08     BEQ L_BRS_($6DCD)_($6DC3) OK
$6DC5  DD 68 17  CMP $1768,X 
$6DC8  F0 03     BEQ L_BRS_($6DCD)_($6DC8) OK
//------------------------------
L_BRS_($6DCA)_($6DE0) OK
L_BRS_($6DCA)_($6DF5) OK
//------------------------------
$6DCA  4C 72 6E  JMP L_JMP_($6E72)_($6DCA) OK
//------------------------------
L_BRS_($6DCD)_($6DC3) OK
L_BRS_($6DCD)_($6DC8) OK
//------------------------------
$6DCD  FE 6A 17  INC $176A,X 
$6DD0  BD 6A 17  LDA $176A,X 
$6DD3  DD 69 17  CMP $1769,X 
$6DD6  90 05     BCC L_BRS_($6DDD)_($6DD6) OK
$6DD8  A9 00     LDA #$00
$6DDA  9D 6A 17  STA $176A,X 
//------------------------------
L_BRS_($6DDD)_($6DD6) OK
//------------------------------
$6DDD  BD 6B 17  LDA $176B,X 
$6DE0  F0 E8     BEQ L_BRS_($6DCA)_($6DE0) OK
$6DE2  BD 6A 17  LDA $176A,X 
$6DE5  D0 46     BNE L_BRS_($6E2D)_($6DE5) OK
$6DE7  8A        TXA 
$6DE8  48        PHA 
$6DE9  A9 02     LDA #$02
$6DEB  20 4B CB  JSR L_JSR_($CB4B)_($6DEB) OK	; TODO: start sound effect? (2: Buzz)
$6DEE  68        PLA 
$6DEF  AA        TAX 
$6DF0  BD 6B 17  LDA $176B,X 
$6DF3  C9 01     CMP #$01
$6DF5  D0 D3     BNE L_BRS_($6DCA)_($6DF5) OK
$6DF7  AD 2D 17  LDA $172D 
$6DFA  48        PHA 
$6DFB  BD 68 17  LDA $1768,X 
$6DFE  8D AD 6B  STA $6BAD 
$6E01  BD 6C 17  LDA $176C,X 
$6E04  0A        ASL A 
$6E05  18        CLC 
$6E06  69 2C     ADC #$2C
$6E08  85 82     STA $82 
$6E0A  A9 00     LDA #$00
$6E0C  8D 2F 17  STA $172F 
$6E0F  69 00     ADC #$00
$6E11  8D 2D 17  STA $172D 
$6E14  A9 AF     LDA #$AF
$6E16  38        SEC 
$6E17  FD 6D 17  SBC $176D,X 
$6E1A  A8        TAY 
$6E1B  8A        TXA 
$6E1C  48        PHA 
$6E1D  A6 82     LDX $82 
$6E1F  A9 07     LDA #$07
$6E21  20 F8 79  JSR L_JSR_($79F8)_($6E21) OK
$6E24  68        PLA 
$6E25  AA        TAX 
$6E26  68        PLA 
$6E27  8D 2D 17  STA $172D 
$6E2A  4C 58 6E  JMP L_JMP_($6E58)_($6E2A) OK
//------------------------------
L_BRS_($6E2D)_($6DE5) OK
//------------------------------
$6E2D  BD 6B 17  LDA $176B,X 
$6E30  C9 01     CMP #$01
$6E32  F0 0A     BEQ L_BRS_($6E3E)_($6E32) OK
$6E34  BD 6A 17  LDA $176A,X 
$6E37  C9 04     CMP #$04
$6E39  F0 28     BEQ L_BRS_($6E63)_($6E39) OK
$6E3B  4C 72 6E  JMP L_JMP_($6E72)_($6E3B) OK
//------------------------------
L_BRS_($6E3E)_($6E32) OK
//------------------------------
$6E3E  BD 6A 17  LDA $176A,X 
$6E41  C9 04     CMP #$04
$6E43  90 13     BCC L_BRS_($6E58)_($6E43) OK
$6E45  D0 2B     BNE L_BRS_($6E72)_($6E45) OK
$6E47  A9 00     LDA #$00
$6E49  8D AD 6B  STA $6BAD 
$6E4C  8A        TXA 
$6E4D  48        PHA 
$6E4E  A9 07     LDA #$07
$6E50  20 41 7A  JSR L_JSR_($7A41)_($6E50) OK
$6E53  68        PLA 
$6E54  AA        TAX 
$6E55  4C 63 6E  JMP L_JMP_($6E63)_($6E55) OK
//------------------------------
L_JMP_($6E58)_($6E2A) OK
L_BRS_($6E58)_($6E43) OK
//------------------------------
$6E58  AD 51 15  LDA $1551 
$6E5B  09 01     ORA #$01
$6E5D  8D 51 15  STA $1551 
$6E60  4C 7F 6E  JMP L_JMP_($6E7F)_($6E60) OK
//------------------------------
L_BRS_($6E63)_($6E39) OK
L_JMP_($6E63)_($6E55) OK
//------------------------------
$6E63  CE 9D 1C  DEC $1C9D 
$6E66  AD 9D 1C  LDA $1C9D 
$6E69  C9 0A     CMP #$0A
$6E6B  D0 05     BNE L_BRS_($6E72)_($6E6B) OK
$6E6D  A9 01     LDA #$01
$6E6F  8D 89 15  STA $1589 
//------------------------------
L_JMP_($6E72)_($6DCA) OK
L_JMP_($6E72)_($6E3B) OK
L_BRS_($6E72)_($6E45) OK
L_BRS_($6E72)_($6E6B) OK
//------------------------------
$6E72  8A        TXA 
$6E73  18        CLC 
$6E74  69 06     ADC #$06
$6E76  AA        TAX 
$6E77  CE AB 6B  DEC $6BAB 
$6E7A  F0 03     BEQ L_BRS_($6E7F)_($6E7A) OK
$6E7C  4C C0 6D  JMP L_JMP_($6DC0)_($6E7C) OK
//------------------------------
L_JMP_($6E7F)_($6DAB) OK
L_JMP_($6E7F)_($6E60) OK
L_BRS_($6E7F)_($6E7A) OK
//------------------------------
$6E7F  68        PLA 
$6E80  85 82     STA $82 
$6E82  68        PLA 
$6E83  85 83     STA $83 
$6E85  68        PLA 
$6E86  85 84     STA $84 
$6E88  68        PLA 
$6E89  85 85     STA $85 
$6E8B  68        PLA 
$6E8C  85 7F     STA $7F 
$6E8E  68        PLA 
$6E8F  85 7E     STA $7E 
$6E91  68        PLA 
$6E92  85 7D     STA $7D 
$6E94  68        PLA 
$6E95  85 7C     STA $7C 
$6E97  68        PLA 
$6E98  85 7B     STA $7B 
$6E9A  68        PLA 
$6E9B  85 7A     STA $7A 
$6E9D  68        PLA 
$6E9E  8D 2F 17  STA $172F 
$6EA1  68        PLA 
$6EA2  8D 2C 17  STA $172C 
$6EA5  68        PLA 
$6EA6  8D 2B 17  STA $172B 
$6EA9  AD 0D DC  LDA $DC0D                          ; TODO: // Interrupt (IRQ) Control Register
$6EAC  A9 00     LDA #$00
$6EAE  8D C6 1A  STA $1AC6 
$6EB1  68        PLA 
$6EB2  A8        TAY 
$6EB3  68        PLA 
$6EB4  AA        TAX 
$6EB5  68        PLA 
$6EB6  40        RTI 
//------------------------------
$6EB7  FE 14 0D  INC $0D14,X 
$6EBA  1D 88 85  ORA $8588,X
$6EBD  86 87     STX $87 
$6EBF  11 FD     ORA ($FD),Y
$6EC1            .byte $33,$57
$6EC3  41 34     EOR ($34,X) 
$6EC5            .byte $5A,$53
$6EC7  45 01     EOR $01 
$6EC9            .byte $FB
$6ECA  35 52     AND $52,X 
$6ECC            .byte $44
$6ECD  36 43     ROL $43,X 
$6ECF  46 54     LSR $54 
$6ED1  58        CLI 
$6ED2            .byte $F7,$37
$6ED4  59 47 38  EOR $3847,Y 
$6ED7            .byte $42
$6ED8  48        PHA 
$6ED9  55 56     EOR $56,X 
$6EDB            .byte $EF
$6EDC  39 49 4A  AND $4A49,Y 
$6EDF  30 4D     BMI L_BRS_($6F2E)_($6EDF) OK
$6EE1            .byte $4B,$4F
$6EE3  4E DF 2B  LSR $2BDF 
$6EE6  50 4C     BVC L_BRS_($6F34)_($6EE6) OK
$6EE8  2D 2E 3A  AND $3A2E 
$6EEB  40        RTI 
//------------------------------
$6EEC  2C BF 5C  BIT $5CBF 
$6EEF  2A        ROL A 
$6EF0            .byte $3B,$13
$6EF2  01 3D     ORA ($3D,X)
$6EF4  5E 2F 7F  LSR $7F2F,X 
$6EF7  31 5F     AND ($5F),Y 
$6EF9            .byte $04,$32
$6EFB  20 02 51  JSR L_JSR_($5102)_($6EFB) BAD
$6EFE            .byte $03,$FF
//------------------------------
L_JSR_($6F00)_($4122) OK
L_JSR_($6F00)_($4127) OK
L_JSR_($6F00)_($412C) OK
L_JSR_($6F00)_($41B4) OK
L_JSR_($6F00)_($4238) OK
L_JSR_($6F00)_($43E1) OK
L_JSR_($6F00)_($7256) OK
L_JSR_($6F00)_($7341) OK
L_JSR_($6F00)_($73AF) OK
//------------------------------
$6F00  A2 00     LDX #$00
$6F02  AD 00 DC  LDA $DC00                          ; TODO: joystick 2? // Data Port A (Keyboard, Joystick, Paddles)
$6F05  4A        LSR A 
$6F06  B0 06     BCS L_BRS_($6F0E)_($6F06) OK
$6F08  A0 91     LDY #$91
$6F0A  8C DB 18  STY $18DB 
$6F0D  E8        INX 
//------------------------------
L_BRS_($6F0E)_($6F06) OK
//------------------------------
$6F0E  4A        LSR A 
$6F0F  B0 08     BCS L_BRS_($6F19)_($6F0F) OK
$6F11  A8        TAY 
$6F12  A9 92     LDA #$92
$6F14  9D DB 18  STA $18DB,X 
$6F17  98        TYA 
$6F18  E8        INX 
//------------------------------
L_BRS_($6F19)_($6F0F) OK
//------------------------------
$6F19  4A        LSR A 
$6F1A  B0 08     BCS L_BRS_($6F24)_($6F1A) OK
$6F1C  A8        TAY 
$6F1D  A9 93     LDA #$93
$6F1F  9D DB 18  STA $18DB,X 
$6F22  98        TYA 
$6F23  E8        INX 
//------------------------------
L_BRS_($6F24)_($6F1A) OK
//------------------------------
$6F24  4A        LSR A 
$6F25  B0 08     BCS L_BRS_($6F2F)_($6F25) OK
$6F27  A8        TAY 
$6F28  A9 94     LDA #$94
$6F2A  9D DB 18  STA $18DB,X 
$6F2D  98        TYA 
//------------------------------
L_BRS_($6F2E)_($6EDF) OK
//------------------------------
$6F2E  E8        INX 
//------------------------------
L_BRS_($6F2F)_($6F25) OK
//------------------------------
$6F2F  4A        LSR A 
$6F30  B0 06     BCS L_BRS_($6F38)_($6F30) OK
$6F32  A9 95     LDA #$95
//------------------------------
L_BRS_($6F34)_($6EE6) OK
//------------------------------
$6F34  9D DB 18  STA $18DB,X 
$6F37  E8        INX 
//------------------------------
L_BRS_($6F38)_($6F30) OK
//------------------------------
$6F38  8E DA 18  STX $18DA 
$6F3B  E0 05     CPX #$05
$6F3D  F0 45     BEQ L_BRS_($6F84)_($6F3D) OK
$6F3F  A2 00     LDX #$00
//------------------------------
L_JMP_($6F41)_($6F62) OK
//------------------------------
$6F41  A0 01     LDY #$01
$6F43  BD B7 6E  LDA $6EB7,X 
$6F46  C9 FF     CMP #$FF
$6F48  F0 3A     BEQ L_BRS_($6F84)_($6F48) OK
$6F4A  8D 00 DC  STA $DC00                          ; TODO: keyboard/joystick // Data Port A (Keyboard, Joystick, Paddles)
//------------------------------
L_BRS_($6F4D)_($6F53) OK
//------------------------------
$6F4D  AD 01 DC  LDA $DC01                          // Data Port B (Keyboard, Joystick, Paddles)
$6F50  CD 01 DC  CMP $DC01                          // Data Port B (Keyboard, Joystick, Paddles)
$6F53  D0 F8     BNE L_BRS_($6F4D)_($6F53) OK
//------------------------------
L_BRS_($6F55)_($6F5B) OK
//------------------------------
$6F55  4A        LSR A 
$6F56  90 0D     BCC L_BRS_($6F65)_($6F56) OK
//------------------------------
L_JMP_($6F58)_($6F80) OK
//------------------------------
$6F58  C8        INY 
$6F59  C0 09     CPY #$09
$6F5B  D0 F8     BNE L_BRS_($6F55)_($6F5B) OK
$6F5D  8A        TXA 
$6F5E  18        CLC 
$6F5F  69 09     ADC #$09
$6F61  AA        TAX 
$6F62  4C 41 6F  JMP L_JMP_($6F41)_($6F62) OK
//------------------------------
L_BRS_($6F65)_($6F56) OK
//------------------------------
$6F65  48        PHA 
$6F66  84 82     STY $82 
$6F68  8A        TXA 
$6F69  18        CLC 
$6F6A  65 82     ADC $82 
$6F6C  A8        TAY 
$6F6D  B9 B7 6E  LDA $6EB7,Y 
$6F70  AC DA 18  LDY $18DA 
$6F73  EE DA 18  INC $18DA 
$6F76  99 DB 18  STA $18DB,Y 
$6F79  C0 05     CPY #$05
$6F7B  B0 06     BCS L_BRS_($6F83)_($6F7B) OK
$6F7D  68        PLA 
$6F7E  A4 82     LDY $82 
$6F80  4C 58 6F  JMP L_JMP_($6F58)_($6F80) OK
//------------------------------
L_BRS_($6F83)_($6F7B) OK
//------------------------------
$6F83  68        PLA 
//------------------------------
L_BRS_($6F84)_($6F3D) OK
L_BRS_($6F84)_($6F48) OK
//------------------------------
$6F84  18        CLC 
$6F85  AD DA 18  LDA $18DA 
$6F88  F0 01     BEQ L_BRS_($6F8B)_($6F88) OK
$6F8A  38        SEC 
//------------------------------
L_BRS_($6F8B)_($6F88) OK
//------------------------------
$6F8B  AD DB 18  LDA $18DB 
$6F8E  60        RTS 
//------------------------------
L_JSR_($6F8F)_($4925) OK
//------------------------------
$6F8F  AD BB 96  LDA $96BB 
$6F92  8D 9D 1C  STA $1C9D 
$6F95  4A        LSR A 
$6F96  8D 6B 15  STA $156B 
$6F99  AD BC 96  LDA $96BC 
$6F9C  8D 40 1C  STA $1C40 
$6F9F  AD BD 96  LDA $96BD 
$6FA2  8D 41 1C  STA $1C41 
$6FA5  AD C0 96  LDA $96C0 
$6FA8  8D 88 15  STA $1588 
$6FAB  AD C4 96  LDA $96C4 
$6FAE  8D D9 18  STA $18D9 
$6FB1  AD C5 96  LDA $96C5 
$6FB4  8D E1 18  STA $18E1 
$6FB7  AD 51 96  LDA $9651 
$6FBA  8D 33 17  STA $1733 
$6FBD  AD 52 96  LDA $9652 
$6FC0  8D 34 17  STA $1734 
$6FC3  A9 27     LDA #$27
$6FC5  8D 31 17  STA $1731 
$6FC8  A9 FE     LDA #$FE	; TODO: screen pointer (FE27)	C64: FE27, Atari: FF1C, Row 199, Character column 4
$6FCA  8D 32 17  STA $1732 
$6FCD  AD 46 96  LDA $9646 
$6FD0  18        CLC 
$6FD1  6D 8A 15  ADC $158A 
$6FD4  8D 81 15  STA $1581 
$6FD7  8D 83 15  STA $1583 
$6FDA  AD 47 96  LDA $9647 
$6FDD  6D 8B 15  ADC $158B 
$6FE0  8D 82 15  STA $1582 
$6FE3  8D 84 15  STA $1584 
$6FE6  A9 00     LDA #$00
$6FE8  8D 85 15  STA $1585 
$6FEB  AD 48 96  LDA $9648 
$6FEE  18        CLC 
$6FEF  6D 8A 15  ADC $158A 
$6FF2  8D 86 15  STA $1586 
$6FF5  AD 49 96  LDA $9649 
$6FF8  6D 8B 15  ADC $158B 
$6FFB  8D 87 15  STA $1587 
$6FFE  AD C1 96  LDA $96C1 
$7001  8D 46 1C  STA $1C46 
$7004  A9 00     LDA #$00
$7006  8D 35 17  STA $1735 
$7009  AD 46 1C  LDA $1C46 
$700C  F0 08     BEQ L_BRS_($7016)_($700C) OK
$700E  AD 6F 1C  LDA $1C6F 
$7011  09 80     ORA #$80
$7013  8D 6F 1C  STA $1C6F 
//------------------------------
L_BRS_($7016)_($700C) OK
//------------------------------
$7016  AE 00 96  LDX $9600 
$7019  8E 78 15  STX $1578 
$701C  AD 8C 15  LDA $158C 
$701F  85 7A     STA $7A 
$7021  AD 8D 15  LDA $158D 
$7024  85 7B     STA $7B 
//------------------------------
L_BRS_($7026)_($704B) OK
//------------------------------
$7026  A0 00     LDY #$00
$7028  B1 7A     LDA ($7A),Y 
$702A  18        CLC 
$702B  6D 8A 15  ADC $158A 
$702E  85 7C     STA $7C 
$7030  C8        INY 
$7031  B1 7A     LDA ($7A),Y 
$7033  6D 8B 15  ADC $158B 
$7036  85 7D     STA $7D 
$7038  C8        INY 
$7039  A9 FF     LDA #$FF
$703B  D1 7C     CMP ($7C),Y 
$703D  F0 14     BEQ L_BRS_($7053)_($703D) OK
$703F  A5 7A     LDA $7A 
$7041  18        CLC 
$7042  69 02     ADC #$02
$7044  85 7A     STA $7A 
$7046  90 02     BCC L_BRS_($704A)_($7046) OK
$7048  E6 7B     INC $7B 
//------------------------------
L_BRS_($704A)_($7046) OK
//------------------------------
$704A  CA        DEX 
$704B  D0 D9     BNE L_BRS_($7026)_($704B) OK
$704D  8E 4B 15  STX $154B 
$7050  4C 68 70  JMP L_JMP_($7068)_($7050) OK
//------------------------------
L_BRS_($7053)_($703D) OK
//------------------------------
$7053  88        DEY 
$7054  B1 7C     LDA ($7C),Y 
$7056  8D 4B 15  STA $154B 
$7059  A5 7C     LDA $7C 
$705B  18        CLC 
$705C  69 0F     ADC #$0F
$705E  8D 4C 15  STA $154C 
$7061  A5 7D     LDA $7D 
$7063  69 00     ADC #$00
$7065  8D 4D 15  STA $154D 
//------------------------------
L_JMP_($7068)_($7050) OK
//------------------------------
$7068  60        RTS 
//------------------------------
L_JSR_($706A)_($49B0) BAD
//------------------------------
$7069  A1 A9     LDA ($A9,X) 
$706B            .byte $00
$706C  8D A1 1C  STA $1CA1 
$706F  8D 8D 1C  STA $1C8D 
$7072  A9 01     LDA #$01
$7074  8D 4F 15  STA $154F 
$7077  8D 76 15  STA $1576 
$707A  AD 78 15  LDA $1578 
$707D  8D 69 70  STA $7069 
$7080  AE 47 1C  LDX $1C47 
$7083  A0 00     LDY #$00
$7085  AD 8C 15  LDA $158C 
$7088  85 7E     STA $7E 
$708A  AD 8D 15  LDA $158D 
$708D  85 7F     STA $7F 
//------------------------------
L_BRS_($708F)_($70AE) OK
//------------------------------
$708F  B1 7E     LDA ($7E),Y 
$7091  18        CLC 
$7092  6D 8A 15  ADC $158A 
$7095  85 7C     STA $7C 
$7097  C8        INY 
$7098  B1 7E     LDA ($7E),Y 
$709A  6D 8B 15  ADC $158B 
$709D  85 7D     STA $7D 
$709F  98        TYA 
$70A0  48        PHA 
$70A1  A0 02     LDY #$02
$70A3  8A        TXA 
$70A4  D1 7C     CMP ($7C),Y 
$70A6  F0 09     BEQ L_BRS_($70B1)_($70A6) OK
$70A8  68        PLA 
$70A9  A8        TAY 
$70AA  C8        INY 
$70AB  CE 69 70  DEC $7069 
$70AE  D0 DF     BNE L_BRS_($708F)_($70AE) OK
$70B0  48        PHA 
//------------------------------
L_BRS_($70B1)_($70A6) OK
//------------------------------
$70B1  68        PLA 
$70B2  A0 00     LDY #$00
$70B4  B1 7C     LDA ($7C),Y 
$70B6  8D 90 1C  STA $1C90 
$70B9  C8        INY 
$70BA  B1 7C     LDA ($7C),Y 
$70BC  8D 49 1C  STA $1C49 
$70BF  A0 03     LDY #$03
$70C1  B1 7C     LDA ($7C),Y 
$70C3  18        CLC 
$70C4  65 7C     ADC $7C 
$70C6  8D 5E 1C  STA $1C5E 
$70C9  C8        INY 
$70CA  B1 7C     LDA ($7C),Y 
$70CC  65 7D     ADC $7D 
$70CE  8D 5F 1C  STA $1C5F 
$70D1  C8        INY 
$70D2  B1 7C     LDA ($7C),Y 
$70D4  8D 45 1C  STA $1C45 
$70D7  8D 69 70  STA $7069 
$70DA  A8        TAY 
$70DB  AD 36 1C  LDA $1C36 
$70DE  A2 00     LDX #$00
$70E0  20 A3 1C  JSR L_JSR_($1CA3)_($70E0) OK
$70E3  A5 82     LDA $82 
$70E5  8D 34 1C  STA $1C34 
$70E8  A5 83     LDA $83 
$70EA  8D 35 1C  STA $1C35 
$70ED  AE 69 70  LDX $7069 
$70F0  AC 40 1C  LDY $1C40 
$70F3  20 76 1E  JSR L_JSR_($1E76)_($70F3) OK
$70F6  A5 82     LDA $82 
$70F8  8D 43 1C  STA $1C43 
$70FB  AE 69 70  LDX $7069 
$70FE  AC 41 1C  LDY $1C41 
$7101  20 76 1E  JSR L_JSR_($1E76)_($7101) OK
$7104  A5 82     LDA $82 
$7106  8D 44 1C  STA $1C44 
$7109  AE 69 70  LDX $7069 
$710C  AC 3F 1C  LDY $1C3F 
$710F  20 76 1E  JSR L_JSR_($1E76)_($710F) OK
$7112  A5 82     LDA $82 
$7114  8D 42 1C  STA $1C42 
$7117  A2 00     LDX #$00
$7119  A0 06     LDY #$06
//------------------------------
L_BRS_($711B)_($7129) OK
//------------------------------
$711B  B1 7C     LDA ($7C),Y 
$711D  9D 64 1C  STA $1C64,X 
$7120  E6 7C     INC $7C 
$7122  D0 02     BNE L_BRS_($7126)_($7122) OK
$7124  E6 7D     INC $7D 
//------------------------------
L_BRS_($7126)_($7122) OK
//------------------------------
$7126  E8        INX 
$7127  E0 04     CPX #$04
$7129  D0 F0     BNE L_BRS_($711B)_($7129) OK
$712B  A9 06     LDA #$06
$712D  18        CLC 
$712E  65 7C     ADC $7C 
$7130  8D 5C 1C  STA $1C5C 
$7133  85 7C     STA $7C 
$7135  A5 7D     LDA $7D 
$7137  69 00     ADC #$00
$7139  8D 5D 1C  STA $1C5D 
$713C  85 7D     STA $7D 
$713E  A0 00     LDY #$00
$7140  B1 7C     LDA ($7C),Y 
$7142  0A        ASL A 
$7143  0A        ASL A 
$7144  0A        ASL A 
$7145  18        CLC 
$7146  69 79     ADC #$79
$7148  8D 54 71  STA $7154 
$714B  98        TYA 
$714C  69 1A     ADC #$1A
$714E  8D 55 71  STA $7155 
$7151  A2 07     LDX #$07
//------------------------------
L_BRS_($7153)_($715A) OK
//------------------------------
$7153  BD FF FF  LDA $FFFF,X 
$7156  9D 4D 1C  STA $1C4D,X 
$7159  CA        DEX 
$715A  10 F7     BPL L_BRS_($7153)_($715A) OK
$715C  C8        INY 
$715D  B1 7C     LDA ($7C),Y 
$715F  8D 56 1C  STA $1C56 
$7162  C8        INY 
$7163  B1 7C     LDA ($7C),Y 
$7165  8D 58 1C  STA $1C58 
$7168  C8        INY 
$7169  B1 7C     LDA ($7C),Y 
$716B  8D 59 1C  STA $1C59 
$716E  C8        INY 
$716F  B1 7C     LDA ($7C),Y 
$7171  8D 5A 1C  STA $1C5A 
$7174  A5 7C     LDA $7C 
$7176  18        CLC 
$7177  69 05     ADC #$05
$7179  8D 4A 1C  STA $1C4A 
$717C  A5 7D     LDA $7D 
$717E  69 00     ADC #$00
$7180  8D 4B 1C  STA $1C4B 
$7183  20 44 74  JSR L_JSR_($7444)_($7183) OK
$7186  60        RTS 
//------------------------------
$7187            .byte $00,$00,$4F
$718A  4E 20 4F  LSR $4F20 
$718D  46 46     LSR $46 
$718F  4C 2D 4C  JMP L_JMP_($4C2D)_($718F) BAD
$7192            .byte $4F
$7193  41 44     EOR ($44,X) 
$7195  20 20 53  JSR L_JSR_($5320)_($7195) BAD
$7198  2D 53 41  AND $4153 
$719B  56 45     LSR $45,X 
$719D            .byte $52
$719E  55 4E     EOR $4E,X 
//------------------------------
L_JSR_($71A2)_($89D1) JAM
//------------------------------
$71A0            .byte $2F,$53,$54,$4F
$71A4  50 2D     BVC L_BRS_($71D3)_($71A4) BAD
$71A6  41 42     EOR ($42,X) 
$71A8            .byte $4F,$52,$54
$71AB  4D 2D 4D  EOR $4D2D 
$71AE  55 53     EOR $53,X 
$71B0  49 43     EOR #$43
$71B2  20 3A 20  JSR L_JSR_($203A)_($71B2) OK
$71B5  20 20 20  JSR $2020
$71B8  20 20 4F  JSR L_JSR_($4F20)_($71B8) OK
$71BB            .byte $54
$71BC  48        PHA 
$71BD  45 52     EOR $52 
$71BF            .byte $53
$71C0  2D 45 58  AND $5845 
$71C3  49 54     EOR #$54
//------------------------------
L_JSR_($71C7)_($4324) BAD
//------------------------------
$71C5  20 20 AD  JSR L_JSR_($AD20)_($71C5) OK
$71C8            .byte $DA
$71C9  18        CLC 
$71CA  C9 02     CMP #$02
$71CC  90 01     BCC L_BRS_($71CF)_($71CC) OK
$71CE  60        RTS 
//------------------------------
L_BRS_($71CF)_($71CC) OK
//------------------------------
$71CF  AD 51 15  LDA $1551 
//------------------------------
L_BRS_($71D3)_($71A4) BAD
//------------------------------
$71D2  09 04     ORA #$04
$71D4  8D 51 15  STA $1551 
//------------------------------
L_BRS_($71D7)_($71DC) OK
//------------------------------
$71D7  AD 51 15  LDA $1551 
$71DA  29 01     AND #$01
$71DC  D0 F9     BNE L_BRS_($71D7)_($71DC) OK
$71DE  A9 06     LDA #$06
$71E0  8D 89 15  STA $1589 
$71E3  AD 15 D0  LDA $D015                          ; TODO: // Sprite display Enable
$71E6  8D 92 1C  STA $1C92 
$71E9  A9 FC     LDA #$FC
$71EB  2D 15 D0  AND $D015                          ; TODO: disable sprites 0,1 // Sprite display Enable
$71EE  8D 15 D0  STA $D015                          // Sprite display Enable
$71F1  A2 03     LDX #$03
$71F3  AD 37 17  LDA $1737 
$71F6  F0 0C     BEQ L_BRS_($7204)_($71F6) OK
//------------------------------
L_BRS_($71F8)_($71FF) OK
//------------------------------
$71F8  BD 88 71  LDA $7188,X 
$71FB  9D B4 71  STA $71B4,X 
$71FE  CA        DEX 
$71FF  D0 F7     BNE L_BRS_($71F8)_($71FF) OK
$7201  4C 0D 72  JMP L_JMP_($720D)_($7201) OK
//------------------------------
L_BRS_($7204)_($71F6) OK
L_BRS_($7204)_($720B) OK
//------------------------------
$7204  BD 8B 71  LDA $718B,X 
$7207  9D B4 71  STA $71B4,X 
$720A  CA        DEX 
$720B  D0 F7     BNE L_BRS_($7204)_($720B) OK
//------------------------------
L_JMP_($720D)_($7201) OK
//------------------------------
$720D  A9 19     LDA #$19
$720F  8D 4E 15  STA $154E 
$7212  20 70 75  JSR L_JSR_($7570)_($7212) OK
$7215  A2 8F     LDX #$8F	; L-LOAD S-SAVE
$7217  A0 71     LDY #$71
$7219  A9 A2     LDA #$A2
$721B  85 7C     STA $7C 
$721D  A9 96     LDA #$96
$721F  85 7D     STA $7D 
$7221  20 6C 68  JSR L_JSR_($686C)_($7221) OK
$7224  A2 9D     LDX #$9D
$7226  A0 71     LDY #$71
$7228  A9 A5     LDA #$A5
$722A  85 7C     STA $7C 
$722C  A9 96     LDA #$96
$722E  85 7D     STA $7D 
$7230  20 6C 68  JSR L_JSR_($686C)_($7230) OK
$7233  A2 AB     LDX #$AB
$7235  A0 71     LDY #$71
$7237  A9 A8     LDA #$A8
$7239  85 7C     STA $7C 
$723B  A9 96     LDA #$96
$723D  85 7D     STA $7D 
$723F  20 6C 68  JSR L_JSR_($686C)_($723F) OK
$7242  A2 B9     LDX #$B9
$7244  A0 71     LDY #$71
$7246  A9 AE     LDA #$AE
$7248  85 7C     STA $7C 
$724A  A9 96     LDA #$96
$724C  85 7D     STA $7D 
$724E  20 6C 68  JSR L_JSR_($686C)_($724E) OK
//------------------------------
L_BRS_($7251)_($7254) OK
L_JMP_($7251)_($72BE) OK
//------------------------------
$7251  AD 4E 15  LDA $154E 
$7254  D0 FB     BNE L_BRS_($7251)_($7254) OK
//------------------------------
L_BRS_($7256)_($7259) OK
//------------------------------
$7256  20 00 6F  JSR L_JSR_($6F00)_($7256) OK
$7259  90 FB     BCC L_BRS_($7256)_($7259) OK
$725B  C9 03     CMP #$03
$725D  D0 03     BNE L_BRS_($7262)_($725D) OK
$725F  4C E2 72  JMP L_JMP_($72E2)_($725F) OK
//------------------------------
L_BRS_($7262)_($725D) OK
//------------------------------
$7262  C9 53     CMP #$53
$7264  F0 04     BEQ L_BRS_($726A)_($7264) OK
$7266  C9 4C     CMP #$4C
$7268  D0 0B     BNE L_BRS_($7275)_($7268) OK
//------------------------------
L_BRS_($726A)_($7264) OK
//------------------------------
$726A  20 4D 04  JSR $044D
$726D  A9 00     LDA #$00
$726F  8D 4E 15  STA $154E 
$7272  4C C9 72  JMP L_JMP_($72C9)_($7272) OK
//------------------------------
L_BRS_($7275)_($7268) OK
//------------------------------
$7275  C9 4D     CMP #$4D
$7277  D0 48     BNE L_BRS_($72C1)_($7277) OK
$7279  A9 A8     LDA #$A8
$727B  85 7C     STA $7C 
$727D  A9 96     LDA #$96
$727F  85 7D     STA $7D 
$7281  AD 37 17  LDA $1737 
$7284  49 01     EOR #$01
$7286  8D 37 17  STA $1737 
$7289  08        PHP 
$728A  8D 36 17  STA $1736 
$728D  8D 00 09  STA $0900 
$7290  20 21 10  JSR L_JSR_($1021)_($7290) OK
$7293  A2 03     LDX #$03
$7295  28        PLP 
$7296  F0 0C     BEQ L_BRS_($72A4)_($7296) OK
//------------------------------
L_BRS_($7298)_($729F) OK
//------------------------------
$7298  BD 88 71  LDA $7188,X 
$729B  9D B4 71  STA $71B4,X 
$729E  CA        DEX 
$729F  D0 F7     BNE L_BRS_($7298)_($729F) OK
$72A1  4C AD 72  JMP L_JMP_($72AD)_($72A1) OK
//------------------------------
L_BRS_($72A4)_($7296) OK
L_BRS_($72A4)_($72AB) OK
//------------------------------
$72A4  BD 8B 71  LDA $718B,X 
$72A7  9D B4 71  STA $71B4,X 
$72AA  CA        DEX 
$72AB  D0 F7     BNE L_BRS_($72A4)_($72AB) OK
//------------------------------
L_JMP_($72AD)_($72A1) OK
//------------------------------
$72AD  A2 AB     LDX #$AB
$72AF  A0 71     LDY #$71
$72B1  20 6C 68  JSR L_JSR_($686C)_($72B1) OK
$72B4  A9 03     LDA #$03
$72B6  20 4B CB  JSR L_JSR_($CB4B)_($72B6) OK	; TODO: start sound effect? (3: Fire)
$72B9  A9 1E     LDA #$1E
$72BB  8D 4E 15  STA $154E 
$72BE  4C 51 72  JMP L_JMP_($7251)_($72BE) OK
//------------------------------
L_BRS_($72C1)_($7277) OK
//------------------------------
$72C1  A9 0B     LDA #$0B
$72C3  8D 4E 15  STA $154E 
$72C6  20 DF 44  JSR L_JSR_($44DF)_($72C6) OK
//------------------------------
L_JMP_($72C9)_($7272) OK
//------------------------------
$72C9  AD 92 1C  LDA $1C92 
$72CC  8D 15 D0  STA $D015                          ; TODO: previous sprite enable // Sprite display Enable
$72CF  AD 91 1C  LDA $1C91 
$72D2  F0 03     BEQ L_BRS_($72D7)_($72D2) OK
$72D4  20 FC 5F  JSR L_JSR_($5FFC)_($72D4) OK
//------------------------------
L_BRS_($72D7)_($72D2) OK
L_BRS_($72D7)_($72DA) OK
//------------------------------
$72D7  AD 4E 15  LDA $154E 
$72DA  D0 FB     BNE L_BRS_($72D7)_($72DA) OK
$72DC  8D 89 15  STA $1589 
$72DF  8D 51 15  STA $1551 
//------------------------------
L_JMP_($72E2)_($725F) OK
//------------------------------
$72E2  60        RTS 
//------------------------------
$72E3            .byte $54
$72E4  41 50     EOR ($50,X) 
$72E6  45 20     EOR $20 
$72E8            .byte $4F,$52
$72EA  20 44 49  JSR L_JSR_($4944)_($72EA) OK
$72ED            .byte $53,$43
$72EF  20 20 28  JSR L_JSR_($2820)_($72EF) BAD
$72F2            .byte $54,$2F,$44
$72F5  29 20     AND #$20
$72F7            .byte $3F
$72F8  20 2A 20  JSR L_JSR_($202A)_($72F8) OK
$72FB  20 20 20  JSR $2020
$72FE  20 46 49  JSR L_JSR_($4946)_($72FE) BAD
$7301  4C 45 4E  JMP L_JMP_($4E45)_($7301) BAD
$7304  41 4D     EOR ($4D,X) 
$7306  45 20     EOR $20 
$7308            .byte $3A
$7309  20 20 20  JSR $2020
$730C  20 2A 20  JSR L_JSR_($202A)_($730C) OK
$730F  20 20 20  JSR $2020
$7312  20 20 20  JSR $2020
$7315  20 20 20  JSR $2020
$7318  20 20 20  JSR $2020
//------------------------------
L_JSR_($731B)_($8465) OK
//------------------------------
$731B  20 70 75  JSR L_JSR_($7570)_($731B) OK
$731E  A9 2A     LDA #$2A
$7320  8D F9 72  STA $72F9 
$7323  A9 A2     LDA #$A2
$7325  85 7C     STA $7C 
$7327  A9 96     LDA #$96
$7329  85 7D     STA $7D 
$732B  A2 E3     LDX #$E3
$732D  A0 72     LDY #$72
$732F  20 6C 68  JSR L_JSR_($686C)_($732F) OK
$7332  A9 A5     LDA #$A5
$7334  85 7C     STA $7C 
$7336  A9 96     LDA #$96
$7338  85 7D     STA $7D 
$733A  A2 F1     LDX #$F1
$733C  A0 72     LDY #$72
$733E  20 6C 68  JSR L_JSR_($686C)_($733E) OK
//------------------------------
L_BRS_($7341)_($7344) OK
L_BRS_($7341)_($7350) OK
//------------------------------
$7341  20 00 6F  JSR L_JSR_($6F00)_($7341) OK
$7344  90 FB     BCC L_BRS_($7341)_($7344) OK
$7346  A2 01     LDX #$01
$7348  C9 54     CMP #$54
$734A  F0 06     BEQ L_BRS_($7352)_($734A) OK
$734C  A2 08     LDX #$08
$734E  C9 44     CMP #$44
$7350  D0 EF     BNE L_BRS_($7341)_($7350) OK
//------------------------------
L_BRS_($7352)_($734A) OK
//------------------------------
$7352  8E 3C 15  STX $153C 
$7355  8D F9 72  STA $72F9 
$7358  A9 A5     LDA #$A5
$735A  85 7C     STA $7C 
$735C  A9 96     LDA #$96
$735E  85 7D     STA $7D 
$7360  A2 F1     LDX #$F1
$7362  A0 72     LDY #$72
$7364  20 6C 68  JSR L_JSR_($686C)_($7364) OK
$7367  A9 2A     LDA #$2A
$7369  8D 0D 73  STA $730D 
$736C  A2 0C     LDX #$0C
$736E  A9 20     LDA #$20
//------------------------------
L_BRS_($7370)_($7374) OK
//------------------------------
$7370  9D 0D 73  STA $730D,X 
$7373  CA        DEX 
$7374  D0 FA     BNE L_BRS_($7370)_($7374) OK
$7376  A9 A8     LDA #$A8
$7378  85 7C     STA $7C 
$737A  A9 96     LDA #$96
$737C  85 7D     STA $7D 
$737E  A2 FF     LDX #$FF
$7380  A0 72     LDY #$72
$7382  20 6C 68  JSR L_JSR_($686C)_($7382) OK
$7385  A9 AB     LDA #$AB
$7387  85 7C     STA $7C 
$7389  A9 96     LDA #$96
$738B  85 7D     STA $7D 
$738D  A2 0D     LDX #$0D
$738F  A0 73     LDY #$73
$7391  20 6C 68  JSR L_JSR_($686C)_($7391) OK
$7394  A9 00     LDA #$00
$7396  8D 2A 17  STA $172A 
//------------------------------
L_JMP_($7399)_($7409) OK
//------------------------------
$7399  A0 12     LDY #$12
//------------------------------
L_BRS_($739B)_($73AD) OK
//------------------------------
$739B  A9 FF     LDA #$FF
$739D  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($73A0)_($73AA) OK
//------------------------------
$73A0  CE 4E 15  DEC $154E 
$73A3  EA        NOP 
$73A4  EA        NOP 
$73A5  EA        NOP 
$73A6  EA        NOP 
$73A7  AD 4E 15  LDA $154E 
$73AA  D0 F4     BNE L_BRS_($73A0)_($73AA) OK
$73AC  88        DEY 
$73AD  D0 EC     BNE L_BRS_($739B)_($73AD) OK
//------------------------------
L_BRS_($73AF)_($73B2) OK
L_BRS_($73AF)_($73BF) OK
L_BRS_($73AF)_($73D4) OK
L_BRS_($73AF)_($73D8) OK
L_BRS_($73AF)_($73DC) OK
L_BRS_($73AF)_($73E5) OK
L_BRS_($73AF)_($73EC) OK
//------------------------------
$73AF  20 00 6F  JSR L_JSR_($6F00)_($73AF) OK
$73B2  90 FB     BCC L_BRS_($73AF)_($73B2) OK
$73B4  C9 0D     CMP #$0D
$73B6  F0 54     BEQ L_BRS_($740C)_($73B6) OK
$73B8  C9 14     CMP #$14
$73BA  D0 16     BNE L_BRS_($73D2)_($73BA) OK
$73BC  AE 2A 17  LDX $172A 
$73BF  F0 EE     BEQ L_BRS_($73AF)_($73BF) OK
$73C1  CE 2A 17  DEC $172A 
$73C4  A9 20     LDA #$20
$73C6  9D 0D 73  STA $730D,X 
$73C9  CA        DEX 
$73CA  A9 2A     LDA #$2A
$73CC  9D 0D 73  STA $730D,X 
$73CF  4C FA 73  JMP L_JMP_($73FA)_($73CF) OK
//------------------------------
L_BRS_($73D2)_($73BA) OK
//------------------------------
$73D2  C9 20     CMP #$20
$73D4  90 D9     BCC L_BRS_($73AF)_($73D4) OK
$73D6  C9 5B     CMP #$5B
$73D8  B0 D5     BCS L_BRS_($73AF)_($73D8) OK
$73DA  C9 2A     CMP #$2A
$73DC  F0 D1     BEQ L_BRS_($73AF)_($73DC) OK
$73DE  AE C5 1A  LDX $1AC5 
$73E1  D0 04     BNE L_BRS_($73E7)_($73E1) OK
$73E3  C9 3F     CMP #$3F
$73E5  F0 C8     BEQ L_BRS_($73AF)_($73E5) OK
//------------------------------
L_BRS_($73E7)_($73E1) OK
//------------------------------
$73E7  AE 2A 17  LDX $172A 
$73EA  E0 05     CPX #$05
$73EC  B0 C1     BCS L_BRS_($73AF)_($73EC) OK
$73EE  9D 0D 73  STA $730D,X 
$73F1  E8        INX 
$73F2  A9 2A     LDA #$2A
$73F4  9D 0D 73  STA $730D,X 
$73F7  8E 2A 17  STX $172A 
//------------------------------
L_JMP_($73FA)_($73CF) OK
//------------------------------
$73FA  A2 0D     LDX #$0D
$73FC  A0 73     LDY #$73
$73FE  A9 AB     LDA #$AB
$7400  85 7C     STA $7C 
$7402  A9 96     LDA #$96
$7404  85 7D     STA $7D 
$7406  20 6C 68  JSR L_JSR_($686C)_($7406) OK
$7409  4C 99 73  JMP L_JMP_($7399)_($7409) OK
//------------------------------
L_BRS_($740C)_($73B6) OK
//------------------------------
$740C  A9 20     LDA #$20
$740E  AE 2A 17  LDX $172A 
$7411  9D 0D 73  STA $730D,X 
$7414  A2 0D     LDX #$0D
$7416  A0 73     LDY #$73
$7418  A9 AB     LDA #$AB
$741A  85 7C     STA $7C 
$741C  A9 96     LDA #$96
$741E  85 7D     STA $7D 
$7420  20 6C 68  JSR L_JSR_($686C)_($7420) OK
$7423  A2 05     LDX #$05
//------------------------------
L_BRS_($7425)_($742C) OK
//------------------------------
$7425  BD 0C 73  LDA $730C,X 
$7428  9D BB 1A  STA $1ABB,X 
$742B  CA        DEX 
$742C  D0 F7     BNE L_BRS_($7425)_($742C) OK
$742E  A9 60     LDA #$60
$7430  8D C1 1A  STA $1AC1 
$7433  A9 20     LDA #$20
$7435  A2 0E     LDX #$0E
//------------------------------
L_BRS_($7437)_($743B) OK
//------------------------------
$7437  9D 19 17  STA $1719,X 
$743A  CA        DEX 
$743B  D0 FA     BNE L_BRS_($7437)_($743B) OK
$743D  8E 28 17  STX $1728 
$7440  8E 29 17  STX $1729 
$7443  60        RTS 
//------------------------------
L_JSR_($7444)_($7183) OK
//------------------------------
$7444  AD 4B 15  LDA $154B 
$7447  F0 67     BEQ L_BRS_($74B0)_($7447) OK
$7449  AA        TAX 
$744A  AD 4C 15  LDA $154C 
$744D  85 7C     STA $7C 
$744F  AD 4D 15  LDA $154D 
$7452  85 7D     STA $7D 
//------------------------------
L_BRS_($7454)_($746C) OK
//------------------------------
$7454  A0 00     LDY #$00
$7456  B1 7C     LDA ($7C),Y 
$7458  29 8F     AND #$8F
$745A  09 40     ORA #$40
$745C  91 7C     STA ($7C),Y 
$745E  A0 08     LDY #$08
$7460  B1 7C     LDA ($7C),Y 
$7462  18        CLC 
$7463  65 7C     ADC $7C 
$7465  85 7C     STA $7C 
$7467  90 02     BCC L_BRS_($746B)_($7467) OK
$7469  E6 7D     INC $7D 
//------------------------------
L_BRS_($746B)_($7467) OK
//------------------------------
$746B  CA        DEX 
$746C  D0 E6     BNE L_BRS_($7454)_($746C) OK
$746E  A9 FF     LDA #$FF
$7470  8D 46 15  STA $1546 
$7473  A9 00     LDA #$00
$7475  20 C1 5C  JSR L_JSR_($5CC1)_($7475) BAD
$7478  D0 36     BNE L_BRS_($74B0)_($7478) OK
$747A  A0 08     LDY #$08
$747C  B1 7C     LDA ($7C),Y 
$747E  38        SEC 
$747F  E9 03     SBC #$03
$7481  AA        TAX 
$7482  A5 7C     LDA $7C 
$7484  85 7A     STA $7A 
$7486  A5 7D     LDA $7D 
$7488  85 7B     STA $7B 
$748A  A0 00     LDY #$00
//------------------------------
L_BRS_($748C)_($74AE) OK
//------------------------------
$748C  C8        INY 
$748D  B1 7A     LDA ($7A),Y 
$748F  F0 16     BEQ L_BRS_($74A7)_($748F) OK
$7491  8D 46 15  STA $1546 
$7494  A9 00     LDA #$00
$7496  20 C1 5C  JSR L_JSR_($5CC1)_($7496) BAD
$7499  D0 0C     BNE L_BRS_($74A7)_($7499) OK
$749B  98        TYA 
$749C  48        PHA 
$749D  A0 00     LDY #$00
$749F  B1 7C     LDA ($7C),Y 
$74A1  29 BF     AND #$BF
$74A3  91 7C     STA ($7C),Y 
$74A5  68        PLA 
$74A6  A8        TAY 
//------------------------------
L_BRS_($74A7)_($748F) OK
L_BRS_($74A7)_($7499) OK
//------------------------------
$74A7  C0 06     CPY #$06
$74A9  D0 02     BNE L_BRS_($74AD)_($74A9) OK
$74AB  C8        INY 
$74AC  C8        INY 
//------------------------------
L_BRS_($74AD)_($74A9) OK
//------------------------------
$74AD  CA        DEX 
$74AE  D0 DC     BNE L_BRS_($748C)_($74AE) OK
//------------------------------
L_BRS_($74B0)_($7447) OK
L_BRS_($74B0)_($7478) OK
//------------------------------
$74B0  60        RTS 
//------------------------------
$74B1  F1 74     SBC ($74),Y 
$74B3  FD 74 09  SBC $0974,X 
$74B6  75 15     ADC $15,X 
$74B8  75 21     ADC $21,X 
$74BA  75 2D     ADC $2D,X 
$74BC  75 39     ADC $39,X 
$74BE  75 45     ADC $45,X 
$74C0  75 51     ADC $51,X 
$74C2  75 5B     ADC $5B,X 
$74C4  75 5B     ADC $5B,X 
$74C6  75 5B     ADC $5B,X 
$74C8  75 61     ADC $61,X 
$74CA  75 61     ADC $61,X 
$74CC  75 61     ADC $61,X 
$74CE  75 61     ADC $61,X 
$74D0  75 61     ADC $61,X 
$74D2  75 61     ADC $61,X 
$74D4  75 61     ADC $61,X 
//------------------------------
L_BRS_($74D6)_($7514) OK
//------------------------------
$74D6  75 61     ADC $61,X 
$74D8  75 67     ADC $67,X 
$74DA  75 67     ADC $67,X 
//------------------------------
L_BRS_($74DC)_($751A) OK
//------------------------------
$74DC  75 67     ADC $67,X 
$74DE  75 67     ADC $67,X 
$74E0  75 67     ADC $67,X 
$74E2  75 67     ADC $67,X 
$74E4  75 67     ADC $67,X 
$74E6  75 67     ADC $67,X 
//------------------------------
L_BRS_($74E8)_($7526) OK
//------------------------------
$74E8  75 67     ADC $67,X 
$74EA  75 67     ADC $67,X 
$74EC  75 67     ADC $67,X 
$74EE  75 67     ADC $67,X 
$74F0  75 FF     ADC $FF,X 
$74F2            .byte $00,$00,$00,$FF,$00,$FF,$00,$00
$74FA            .byte $00,$FF,$00
$74FD  F0 00     BEQ L_BRS_($74FF)_($74FD) JAM
//------------------------------
L_BRS_($74FF)_($74FD) JAM
//------------------------------
$74FF            .byte $00
$7500  55 3F     EOR $3F,X 
$7502            .byte $00,$FC,$00,$00
$7506  55 0F     EOR $0F,X 
$7508            .byte $00
$7509  C0 05     CPY #$05
$750B            .byte $00
$750C  55 0F     EOR $0F,X 
$750E  40        RTI 
//------------------------------
$750F  F0 01     BEQ L_BRS_($7512)_($750F) OK
$7511            .byte $00
//------------------------------
L_BRS_($7512)_($750F) OK
//------------------------------
$7512  55 03     EOR $03,X 
$7514  50 C0     BVC L_BRS_($74D6)_($7514) OK
$7516  05 00     ORA $00
$7518  55 03     EOR $03,X 
$751A  50 C0     BVC L_BRS_($74DC)_($751A) OK
$751C  05 00     ORA $00
$751E  55 03     EOR $03,X 
$7520  50 00     BVC L_BRS_($7522)_($7520) JAM
//------------------------------
L_BRS_($7522)_($7520) JAM
//------------------------------
$7522            .byte $14,$00
$7524  55 03     EOR $03,X 
$7526  50 C0     BVC L_BRS_($74E8)_($7526) OK
$7528  05 00     ORA $00
$752A  55 00     EOR $00,X 
$752C            .byte $14,$00
$752E  15 00     ORA $00,X
$7530  01 0F     ORA ($0F,X)
$7532  40        RTI 
//------------------------------
$7533  F0 01     BEQ L_BRS_($7536)_($7533) OK
$7535            .byte $00
//------------------------------
L_BRS_($7536)_($7533) OK
//------------------------------
$7536  40        RTI 
//------------------------------
$7537            .byte $00,$54,$00
$753A  15 01     ORA $01,X
$753C            .byte $54,$02,$00,$02,$00
$7541  01 15     ORA ($15,X)
$7543            .byte $00,$54,$00
$7546  15 03     ORA $03,X
$7548  55 02     EOR $02,X 
$754A            .byte $00,$02,$00,$03
$754E  55 00     EOR $00,X 
$7550            .byte $54,$00
$7552  15 05     ORA $05,X
$7554  55 06     EOR $06,X 
$7556            .byte $00
//------------------------------
L_BRS_($7558)_($7566) BAD
//------------------------------
$7557  05 55     ORA $55
$7559            .byte $00,$54,$00
$755C  15 10     ORA $10,X
$755E  55 00     EOR $00,X 
$7560            .byte $54
$7561  C0 05     CPY #$05
$7563  10 55     BPL L_BRS_($75BA)_($7563) OK
$7565            .byte $03
$7566  50 F0     BVC L_BRS_($7558)_($7566) BAD
$7568  01 10     ORA ($10,X)
$756A  55 0F     EOR $0F,X 
$756C  40        RTI 
//------------------------------
$756D            .byte $00,$00,$00
//------------------------------
L_JSR_($7570)_($7212) OK
L_JSR_($7570)_($731B) OK
//------------------------------
$7570  A9 B1     LDA #$B1
$7572  85 7C     STA $7C 
$7574  A9 74     LDA #$74
$7576  85 7D     STA $7D 
$7578  A9 DC     LDA #$DC
$757A  85 7A     STA $7A 
$757C  A9 E7     LDA #$E7	; TODO: Screen pointer C64: E7DC, Atari: E82B, Row 52, Column 88, Character column 11
$757E  85 7B     STA $7B 	; top left of 3D window?
$7580  A2 01     LDX #$01
$7582  8E 6D 75  STX $756D 
//------------------------------
L_JMP_($7585)_($762C) OK
L_JMP_($7585)_($763B) OK
L_JMP_($7585)_($764E) OK
//------------------------------
$7585  8A        TXA 
$7586  48        PHA 
$7587  A0 00     LDY #$00
$7589  8C 6E 75  STY $756E 
$758C  B1 7C     LDA ($7C),Y 
$758E  8D 58 76  STA $7658 
$7591  8D 5E 76  STA $765E 
$7594  8D 77 76  STA $7677 
$7597  8D 7E 76  STA $767E 
$759A  C8        INY 
$759B  B1 7C     LDA ($7C),Y 
$759D  8D 59 76  STA $7659 
$75A0  8D 5F 76  STA $765F 
$75A3  8D 78 76  STA $7678 
$75A6  8D 7F 76  STA $767F 
$75A9  88        DEY 
$75AA  E0 07     CPX #$07
$75AC  B0 0F     BCS L_BRS_($75BD)_($75AC) OK
$75AE  A2 03     LDX #$03
$75B0  20 52 76  JSR L_JSR_($7652)_($75B0) OK
$75B3  98        TYA 
$75B4  18        CLC 
$75B5  69 60     ADC #$60
$75B7  A8        TAY 
$75B8  A2 03     LDX #$03
//------------------------------
L_BRS_($75BA)_($7563) OK
//------------------------------
$75BA  4C 02 76  JMP L_JMP_($7602)_($75BA) OK
//------------------------------
L_BRS_($75BD)_($75AC) OK
//------------------------------
$75BD  E0 08     CPX #$08
$75BF  B0 11     BCS L_BRS_($75D2)_($75BF) OK
$75C1  A2 01     LDX #$01
$75C3  20 52 76  JSR L_JSR_($7652)_($75C3) OK
$75C6  A2 02     LDX #$02
$75C8  20 71 76  JSR L_JSR_($7671)_($75C8) OK
$75CB  98        TYA 
$75CC  18        CLC 
$75CD  69 50     ADC #$50
$75CF  4C E4 75  JMP L_JMP_($75E4)_($75CF) OK
//------------------------------
L_BRS_($75D2)_($75BF) OK
//------------------------------
$75D2  E0 09     CPX #$09
$75D4  B0 14     BCS L_BRS_($75EA)_($75D4) OK
$75D6  A2 01     LDX #$01
$75D8  20 52 76  JSR L_JSR_($7652)_($75D8) OK
$75DB  A2 02     LDX #$02
$75DD  20 71 76  JSR L_JSR_($7671)_($75DD) OK
$75E0  98        TYA 
$75E1  18        CLC 
$75E2  69 30     ADC #$30
//------------------------------
L_JMP_($75E4)_($75CF) OK
//------------------------------
$75E4  A8        TAY 
$75E5  A2 02     LDX #$02
$75E7  4C FE 75  JMP L_JMP_($75FE)_($75E7) OK
//------------------------------
L_BRS_($75EA)_($75D4) OK
//------------------------------
$75EA  E0 0A     CPX #$0A
$75EC  B0 0A     BCS L_BRS_($75F8)_($75EC) OK
$75EE  A2 01     LDX #$01
$75F0  20 52 76  JSR L_JSR_($7652)_($75F0) OK
$75F3  A2 03     LDX #$03
$75F5  4C FE 75  JMP L_JMP_($75FE)_($75F5) OK
//------------------------------
L_BRS_($75F8)_($75EC) OK
//------------------------------
$75F8  A2 01     LDX #$01
$75FA  20 52 76  JSR L_JSR_($7652)_($75FA) OK
$75FD  E8        INX 
//------------------------------
L_JMP_($75FE)_($75E7) OK
L_JMP_($75FE)_($75F5) OK
//------------------------------
$75FE  20 71 76  JSR L_JSR_($7671)_($75FE) OK
$7601  E8        INX 
//------------------------------
L_JMP_($7602)_($75BA) OK
//------------------------------
$7602  20 52 76  JSR L_JSR_($7652)_($7602) OK
$7605  E6 7A     INC $7A 
$7607  D0 02     BNE L_BRS_($760B)_($7607) OK
$7609  E6 7B     INC $7B 
//------------------------------
L_BRS_($760B)_($7607) OK
//------------------------------
$760B  A5 7A     LDA $7A 
$760D  29 07     AND #$07
$760F  D0 0D     BNE L_BRS_($761E)_($760F) OK
$7611  A5 7A     LDA $7A 
$7613  18        CLC 
$7614  69 38     ADC #$38
$7616  85 7A     STA $7A 
$7618  90 02     BCC L_BRS_($761C)_($7618) OK
$761A  E6 7B     INC $7B 
//------------------------------
L_BRS_($761C)_($7618) OK
//------------------------------
$761C  E6 7B     INC $7B 
//------------------------------
L_BRS_($761E)_($760F) OK
//------------------------------
$761E  68        PLA 
$761F  AA        TAX 
$7620  AD 6D 75  LDA $756D 
$7623  F0 19     BEQ L_BRS_($763E)_($7623) OK
$7625  E0 20     CPX #$20
$7627  D0 06     BNE L_BRS_($762F)_($7627) OK
$7629  CE 6D 75  DEC $756D 
$762C  4C 85 75  JMP L_JMP_($7585)_($762C) OK
//------------------------------
L_BRS_($762F)_($7627) OK
//------------------------------
$762F  E8        INX 
$7630  A5 7C     LDA $7C 
$7632  18        CLC 
$7633  69 02     ADC #$02
$7635  85 7C     STA $7C 
$7637  90 02     BCC L_BRS_($763B)_($7637) OK
$7639  E6 7D     INC $7D 
//------------------------------
L_BRS_($763B)_($7637) OK
L_BRS_($763B)_($764A) OK
//------------------------------
$763B  4C 85 75  JMP L_JMP_($7585)_($763B) OK
//------------------------------
L_BRS_($763E)_($7623) OK
//------------------------------
$763E  E0 01     CPX #$01
$7640  F0 0F     BEQ L_BRS_($7651)_($7640) OK
$7642  CA        DEX 
$7643  A5 7C     LDA $7C 
$7645  38        SEC 
$7646  E9 02     SBC #$02
$7648  85 7C     STA $7C 
$764A  B0 EF     BCS L_BRS_($763B)_($764A) OK
$764C  C6 7D     DEC $7D 
$764E  4C 85 75  JMP L_JMP_($7585)_($764E) OK
//------------------------------
L_BRS_($7651)_($7640) OK
//------------------------------
$7651  60        RTS 
//------------------------------
L_JSR_($7652)_($75B0) OK
L_JSR_($7652)_($75C3) OK
L_JSR_($7652)_($75D8) OK
L_JSR_($7652)_($75F0) OK
L_JSR_($7652)_($75FA) OK
L_JSR_($7652)_($7602) OK
L_BRS_($7652)_($766E) OK
//------------------------------
$7652  8A        TXA 
$7653  48        PHA 
$7654  AE 6E 75  LDX $756E 
$7657  BD FF FF  LDA $FFFF,X 
$765A  31 7A     AND ($7A),Y 
$765C  E8        INX 
$765D  1D FF FF  ORA $FFFF,X
$7660  E8        INX 
$7661  8E 6E 75  STX $756E 
$7664  91 7A     STA ($7A),Y 
$7666  98        TYA 
$7667  18        CLC 
$7668  69 08     ADC #$08	; TODO: $7A is screen pointer, Y is screen index
$766A  A8        TAY 
$766B  68        PLA 
$766C  AA        TAX 
$766D  CA        DEX 
$766E  D0 E2     BNE L_BRS_($7652)_($766E) OK
$7670  60        RTS 
//------------------------------
L_JSR_($7671)_($75C8) OK
L_JSR_($7671)_($75DD) OK
L_JSR_($7671)_($75FE) OK
L_BRS_($7671)_($7695) OK
//------------------------------
$7671  8A        TXA 
$7672  48        PHA 
$7673  AE 6E 75  LDX $756E 
$7676  BD FF FF  LDA $FFFF,X 
$7679  8D 6F 75  STA $756F 
$767C  E8        INX 
$767D  BD FF FF  LDA $FFFF,X 
$7680  E8        INX 
$7681  8E 6E 75  STX $756E 
//------------------------------
L_BRS_($7684)_($7690) OK
//------------------------------
$7684  91 7A     STA ($7A),Y 
$7686  48        PHA 
$7687  98        TYA 
$7688  18        CLC 
$7689  69 08     ADC #$08
$768B  A8        TAY 
$768C  68        PLA 
$768D  CE 6F 75  DEC $756F 
$7690  D0 F2     BNE L_BRS_($7684)_($7690) OK
$7692  68        PLA 
$7693  AA        TAX 
$7694  CA        DEX 
$7695  D0 DA     BNE L_BRS_($7671)_($7695) OK
$7697  60        RTS 
//------------------------------
L_JSR_($7698)_($78FD) OK
L_JSR_($7698)_($7943) OK
L_JSR_($7698)_($7C1A) OK
L_JSR_($7698)_($7CDC) OK
//------------------------------
$7698  AD 8E 15  LDA $158E 		; TODO: clear backbuffer
$769B  85 7A     STA $7A 
$769D  AD 8F 15  LDA $158F 
$76A0  85 7B     STA $7B 
$76A2  A2 68     LDX #$68
//------------------------------
L_BRS_($76A4)_($76B9) OK
//------------------------------
$76A4  A0 1F     LDY #$1F
$76A6  A9 00     LDA #$00
//------------------------------
L_BRS_($76A8)_($76AB) OK
//------------------------------
$76A8  91 7A     STA ($7A),Y 
$76AA  88        DEY 
$76AB  10 FB     BPL L_BRS_($76A8)_($76AB) OK
$76AD  A9 20     LDA #$20
$76AF  18        CLC 
$76B0  65 7A     ADC $7A 
$76B2  85 7A     STA $7A 
$76B4  90 02     BCC L_BRS_($76B8)_($76B4) OK
$76B6  E6 7B     INC $7B 
//------------------------------
L_BRS_($76B8)_($76B4) OK
//------------------------------
$76B8  CA        DEX 
$76B9  D0 E9     BNE L_BRS_($76A4)_($76B9) OK
$76BB  AD 51 15  LDA $1551 
$76BE  09 04     ORA #$04
$76C0  8D 51 15  STA $1551 
//------------------------------
L_BRS_($76C3)_($76C8) OK
//------------------------------
$76C3  AD 51 15  LDA $1551 
$76C6  29 01     AND #$01
$76C8  D0 F9     BNE L_BRS_($76C3)_($76C8) OK
$76CA  20 DF 44  JSR L_JSR_($44DF)_($76CA) OK
$76CD  60        RTS 
//------------------------------
$76CE            .byte $00
$76CF  09 01     ORA #$01
$76D1  09 01     ORA #$01
$76D3  09 02     ORA #$02
$76D5  09 02     ORA #$02
$76D7  09 03     ORA #$03
$76D9  09 03     ORA #$03
$76DB  09 03     ORA #$03
$76DD  08        PHP 
$76DE            .byte $04
$76DF  08        PHP 
$76E0            .byte $04,$07,$04,$07,$04
$76E5  06 05     ASL $05 
$76E7  06 05     ASL $05 
$76E9  05 05     ORA $05
$76EB            .byte $04
$76EC  05 03     ORA $03
$76EE  05 02     ORA $02
$76F0  05 01     ORA $01
$76F2  05 00     ORA $00
$76F4            .byte $00,$00,$00,$00,$00
//------------------------------
L_JSR_($76F9)_($6D59) OK
//------------------------------
$76F9  48        PHA 
$76FA  A2 1F     LDX #$1F
//------------------------------
L_BRS_($76FC)_($770F) OK
//------------------------------
$76FC  BD CD 1B  LDA $1BCD,X 	; TODO: Update compass on screen
$76FF  9D 28 FB  STA $FB28,X 
$7702  BD ED 1B  LDA $1BED,X 
$7705  9D 68 FC  STA $FC68,X 
$7708  BD 0D 1C  LDA $1C0D,X 
$770B  9D A8 FD  STA $FDA8,X 
$770E  CA        DEX 
$770F  10 EB     BPL L_BRS_($76FC)_($770F) OK
$7711  A9 01     LDA #$01
$7713  8D 2E 17  STA $172E 
$7716  A9 00     LDA #$00
$7718  8D 2F 17  STA $172F 
$771B  68        PLA 
$771C  A2 02     LDX #$02
$771E  C9 12     CMP #$12
$7720  90 29     BCC L_BRS_($774B)_($7720) OK
$7722  C9 24     CMP #$24
$7724  B0 0E     BCS L_BRS_($7734)_($7724) OK
$7726  A2 00     LDX #$00
$7728  8D F8 76  STA $76F8 
$772B  A9 24     LDA #$24
$772D  38        SEC 
$772E  ED F8 76  SBC $76F8 
$7731  4C 4B 77  JMP L_JMP_($774B)_($7731) OK
//------------------------------
L_BRS_($7734)_($7724) OK
//------------------------------
$7734  C9 36     CMP #$36
$7736  B0 08     BCS L_BRS_($7740)_($7736) OK
$7738  A2 01     LDX #$01
$773A  38        SEC 
$773B  E9 24     SBC #$24
$773D  4C 4B 77  JMP L_JMP_($774B)_($773D) OK
//------------------------------
L_BRS_($7740)_($7736) OK
//------------------------------
$7740  A2 03     LDX #$03
$7742  8D F8 76  STA $76F8 
$7745  A9 48     LDA #$48
$7747  38        SEC 
$7748  ED F8 76  SBC $76F8 
//------------------------------
L_BRS_($774B)_($7720) OK
L_JMP_($774B)_($7731) OK
L_JMP_($774B)_($773D) OK
//------------------------------
$774B  0A        ASL A 
$774C  A8        TAY 
$774D  B9 CE 76  LDA $76CE,Y 
$7750  8D F4 76  STA $76F4 
$7753  4A        LSR A 
$7754  8D F7 76  STA $76F7 
$7757  E0 00     CPX #$00
$7759  F0 16     BEQ L_BRS_($7771)_($7759) OK
$775B  E0 02     CPX #$02
$775D  F0 12     BEQ L_BRS_($7771)_($775D) OK
$775F  A9 00     LDA #$00
$7761  38        SEC 
$7762  ED F4 76  SBC $76F4 
$7765  8D F4 76  STA $76F4 
$7768  A9 00     LDA #$00
$776A  38        SEC 
$776B  ED F7 76  SBC $76F7 
$776E  8D F7 76  STA $76F7 
//------------------------------
L_BRS_($7771)_($7759) OK
L_BRS_($7771)_($775D) OK
//------------------------------
$7771  C8        INY 
$7772  B9 CE 76  LDA $76CE,Y 
$7775  8D F5 76  STA $76F5 
$7778  4A        LSR A 
$7779  4A        LSR A 
$777A  8D F6 76  STA $76F6 
$777D  E0 02     CPX #$02
$777F  90 12     BCC L_BRS_($7793)_($777F) OK
$7781  A9 00     LDA #$00
$7783  38        SEC 
$7784  ED F5 76  SBC $76F5 
$7787  8D F5 76  STA $76F5 
$778A  A9 00     LDA #$00
$778C  38        SEC 
$778D  ED F6 76  SBC $76F6 
$7790  8D F6 76  STA $76F6 
//------------------------------
L_BRS_($7793)_($777F) OK
//------------------------------
$7793  AD F4 76  LDA $76F4 
$7796  18        CLC 
$7797  69 6B     ADC #$6B
$7799  AA        TAX 
$779A  48        PHA 
$779B  A9 00     LDA #$00
$779D  38        SEC 
$779E  ED F5 76  SBC $76F5 
$77A1  18        CLC 
$77A2  69 14     ADC #$14
$77A4  A8        TAY 
$77A5  48        PHA 
$77A6  A9 00     LDA #$00
$77A8  38        SEC 
$77A9  ED F6 76  SBC $76F6 
$77AC  18        CLC 
$77AD  69 6B     ADC #$6B
$77AF  8D 2B 17  STA $172B 
$77B2  48        PHA 
$77B3  A9 00     LDA #$00
$77B5  38        SEC 
$77B6  ED F7 76  SBC $76F7 
$77B9  18        CLC 
$77BA  69 14     ADC #$14
$77BC  8D 2C 17  STA $172C 
$77BF  48        PHA 
$77C0  20 CB 5B  JSR L_JSR_($5BCB)_($77C0) BAD
$77C3  68        PLA 
$77C4  A8        TAY 
$77C5  68        PLA 
$77C6  AA        TAX 
$77C7  A9 00     LDA #$00
$77C9  38        SEC 
$77CA  ED F4 76  SBC $76F4 
$77CD  18        CLC 
$77CE  69 6B     ADC #$6B
$77D0  8D 2B 17  STA $172B 
$77D3  48        PHA 
$77D4  AD F5 76  LDA $76F5 
$77D7  18        CLC 
$77D8  69 14     ADC #$14
$77DA  8D 2C 17  STA $172C 
$77DD  48        PHA 
$77DE  20 CB 5B  JSR L_JSR_($5BCB)_($77DE) BAD
$77E1  68        PLA 
$77E2  A8        TAY 
$77E3  68        PLA 
$77E4  AA        TAX 
$77E5  AD F6 76  LDA $76F6 
$77E8  18        CLC 
$77E9  69 6B     ADC #$6B
$77EB  8D 2B 17  STA $172B 
$77EE  48        PHA 
$77EF  AD F7 76  LDA $76F7 
$77F2  18        CLC 
$77F3  69 14     ADC #$14
$77F5  8D 2C 17  STA $172C 
$77F8  48        PHA 
$77F9  20 CB 5B  JSR L_JSR_($5BCB)_($77F9) BAD
$77FC  68        PLA 
$77FD  A8        TAY 
$77FE  68        PLA 
$77FF  AA        TAX 
$7800  68        PLA 
$7801  8D 2C 17  STA $172C 
$7804  68        PLA 
$7805  8D 2B 17  STA $172B 
$7808  48        PHA 
$7809  AD 2C 17  LDA $172C 
$780C  48        PHA 
$780D  20 CB 5B  JSR L_JSR_($5BCB)_($780D) BAD
$7810  68        PLA 
$7811  8D 2C 17  STA $172C 
$7814  68        PLA 
$7815  8D 2B 17  STA $172B 
$7818  A2 6B     LDX #$6B
$781A  A0 14     LDY #$14
$781C  20 CB 5B  JSR L_JSR_($5BCB)_($781C) BAD
$781F  60        RTS 
//------------------------------
L_JSR_($7820)_($1F8D) OK
//------------------------------
$7820  A9 00     LDA #$00
$7822  8D 75 15  STA $1575 
$7825  AD 2E 1C  LDA $1C2E 
$7828  8D 36 15  STA $1536 
$782B  85 82     STA $82 
$782D  AD 2F 1C  LDA $1C2F 
$7830  8D 37 15  STA $1537 
$7833  06 82     ASL $82 
$7835  2A        ROL A 
$7836  06 82     ASL $82 
$7838  2A        ROL A 
$7839  85 B0     STA $B0 
$783B  AD 30 1C  LDA $1C30 
$783E  8D 38 15  STA $1538 
$7841  85 82     STA $82 
$7843  AD 31 1C  LDA $1C31 
$7846  8D 39 15  STA $1539 
$7849  06 82     ASL $82 
$784B  2A        ROL A 
$784C  06 82     ASL $82 
$784E  2A        ROL A 
$784F  85 B1     STA $B1 
$7851  AD 32 1C  LDA $1C32 
$7854  8D 3A 15  STA $153A 
$7857  85 82     STA $82 
$7859  AD 33 1C  LDA $1C33 
$785C  8D 3B 15  STA $153B 
$785F  06 82     ASL $82 
$7861  2A        ROL A 
$7862  06 82     ASL $82 
$7864  2A        ROL A 
$7865  85 B2     STA $B2 
$7867  AE 49 1C  LDX $1C49 
$786A  F0 0D     BEQ L_BRS_($7879)_($786A) OK
$786C  AD 4A 1C  LDA $1C4A 
$786F  85 7A     STA $7A 
$7871  AD 4B 1C  LDA $1C4B 
$7874  85 7B     STA $7B 
$7876  20 90 78  JSR L_JSR_($7890)_($7876) OK
//------------------------------
L_BRS_($7879)_($786A) OK
//------------------------------
$7879  AE 4B 15  LDX $154B 
$787C  F0 0D     BEQ L_BRS_($788B)_($787C) OK
$787E  AD 4C 15  LDA $154C 
$7881  85 7A     STA $7A 
$7883  AD 4D 15  LDA $154D 
$7886  85 7B     STA $7B 
$7888  20 90 78  JSR L_JSR_($7890)_($7888) OK
//------------------------------
L_BRS_($788B)_($787C) OK
//------------------------------
$788B  20 77 4A  JSR L_JSR_($4A77)_($788B) OK
$788E  18        CLC 
$788F  60        RTS 
//------------------------------
L_JSR_($7890)_($7876) OK
L_JSR_($7890)_($7888) OK
L_JMP_($7890)_($791D) OK
//------------------------------
$7890  A0 00     LDY #$00
$7892  B1 7A     LDA ($7A),Y 
$7894  29 10     AND #$10
$7896  F0 75     BEQ L_BRS_($790D)_($7896) OK
$7898  B1 7A     LDA ($7A),Y 
$789A  29 EF     AND #$EF
$789C  91 7A     STA ($7A),Y 
$789E  A0 01     LDY #$01
$78A0  B1 7A     LDA ($7A),Y 
$78A2  38        SEC 
$78A3  E9 01     SBC #$01
$78A5  C5 B0     CMP $B0 
$78A7  10 64     BPL L_BRS_($790D)_($78A7) OK
$78A9  A0 04     LDY #$04
$78AB  18        CLC 
$78AC  71 7A     ADC ($7A),Y 
$78AE  C5 B0     CMP $B0 
$78B0  30 5B     BMI L_BRS_($790D)_($78B0) OK
$78B2  A0 03     LDY #$03
$78B4  B1 7A     LDA ($7A),Y 
$78B6  38        SEC 
$78B7  E9 01     SBC #$01
$78B9  C5 B2     CMP $B2 
$78BB  10 50     BPL L_BRS_($790D)_($78BB) OK
$78BD  A0 06     LDY #$06
$78BF  18        CLC 
$78C0  71 7A     ADC ($7A),Y 
$78C2  C5 B2     CMP $B2 
$78C4  30 47     BMI L_BRS_($790D)_($78C4) OK
$78C6  A0 02     LDY #$02
$78C8  B1 7A     LDA ($7A),Y 
$78CA  38        SEC 
$78CB  E9 01     SBC #$01
$78CD  C5 B1     CMP $B1 
$78CF  10 3C     BPL L_BRS_($790D)_($78CF) OK
$78D1  A5 B1     LDA $B1 
$78D3  85 82     STA $82 
$78D5  AD 42 1C  LDA $1C42 
$78D8  F0 0E     BEQ L_BRS_($78E8)_($78D8) OK
$78DA  CE 42 1C  DEC $1C42 
$78DD  A5 B1     LDA $B1 
$78DF  38        SEC 
$78E0  ED 42 1C  SBC $1C42 
$78E3  EE 42 1C  INC $1C42 
$78E6  85 82     STA $82 
//------------------------------
L_BRS_($78E8)_($78D8) OK
//------------------------------
$78E8  A0 02     LDY #$02
$78EA  B1 7A     LDA ($7A),Y 
$78EC  38        SEC 
$78ED  E9 01     SBC #$01
$78EF  A0 05     LDY #$05
$78F1  18        CLC 
$78F2  71 7A     ADC ($7A),Y 
$78F4  C5 82     CMP $82 
$78F6  30 15     BMI L_BRS_($790D)_($78F6) OK
$78F8  A9 07     LDA #$07
$78FA  8D 89 15  STA $1589 
$78FD  20 98 76  JSR L_JSR_($7698)_($78FD) OK
$7900  A9 00     LDA #$00
$7902  8D 43 15  STA $1543 
$7905  8D 44 15  STA $1544 
$7908  68        PLA 
$7909  68        PLA 
$790A  38        SEC 
$790B  B0 13     BCS L_BRS_($7920)_($790B) OK
//------------------------------
L_BRS_($790D)_($7896) OK
L_BRS_($790D)_($78A7) OK
L_BRS_($790D)_($78B0) OK
L_BRS_($790D)_($78BB) OK
L_BRS_($790D)_($78C4) OK
L_BRS_($790D)_($78CF) OK
L_BRS_($790D)_($78F6) OK
//------------------------------
$790D  A0 08     LDY #$08
$790F  B1 7A     LDA ($7A),Y 
$7911  18        CLC 
$7912  65 7A     ADC $7A 
$7914  85 7A     STA $7A 
$7916  90 02     BCC L_BRS_($791A)_($7916) OK
$7918  E6 7B     INC $7B 
//------------------------------
L_BRS_($791A)_($7916) OK
//------------------------------
$791A  CA        DEX 
$791B  F0 03     BEQ L_BRS_($7920)_($791B) OK
$791D  4C 90 78  JMP L_JMP_($7890)_($791D) OK
//------------------------------
L_BRS_($7920)_($790B) OK
L_BRS_($7920)_($791B) OK
//------------------------------
$7920  60        RTS 
//------------------------------
L_JSR_($7921)_($4E8D) OK
L_JSR_($7921)_($79DD) OK
//------------------------------
$7921  A9 00     LDA #$00
$7923  8D 38 1C  STA $1C38 
$7926  A9 06     LDA #$06
$7928  8D 49 15  STA $1549 
$792B  78        SEI 
$792C  AD 9D 1C  LDA $1C9D 
$792F  38        SEC 
$7930  E9 0F     SBC #$0F
$7932  30 04     BMI L_BRS_($7938)_($7932) OK
$7934  C9 0B     CMP #$0B
$7936  B0 07     BCS L_BRS_($793F)_($7936) OK
//------------------------------
L_BRS_($7938)_($7932) OK
//------------------------------
$7938  A9 04     LDA #$04
$793A  8D 89 15  STA $1589 
$793D  A9 0A     LDA #$0A
//------------------------------
L_BRS_($793F)_($7936) OK
//------------------------------
$793F  8D 9D 1C  STA $1C9D 
$7942  58        CLI 
$7943  20 98 76  JSR L_JSR_($7698)_($7943) OK
$7946  A9 08     LDA #$08
$7948  8D 49 15  STA $1549 
$794B  60        RTS 
//------------------------------
$794C            .byte $00,$00,$00,$00
//------------------------------
L_JSR_($7950)_($41A4) OK
//------------------------------
$7950  A9 00     LDA #$00
$7952  8D 76 15  STA $1576 
$7955  AD 2E 1C  LDA $1C2E 
$7958  8D 36 15  STA $1536 
$795B  AD 2F 1C  LDA $1C2F 
$795E  8D 37 15  STA $1537 
$7961  AD 32 1C  LDA $1C32 
$7964  8D 3A 15  STA $153A 
$7967  AD 33 1C  LDA $1C33 
$796A  8D 3B 15  STA $153B 
$796D  A9 00     LDA #$00
$796F  8D 38 15  STA $1538 
$7972  8D 39 15  STA $1539 
$7975  A9 01     LDA #$01
$7977  8D 46 1C  STA $1C46 
$797A  AD 42 1C  LDA $1C42 
$797D  38        SEC 
$797E  E9 01     SBC #$01
$7980  85 83     STA $83 
$7982  A9 00     LDA #$00
$7984  46 83     LSR $83 
$7986  6A        ROR A 
$7987  46 83     LSR $83 
$7989  6A        ROR A 
$798A  85 82     STA $82 
$798C  8D 4E 79  STA $794E 
$798F  A5 83     LDA $83 
$7991  8D 4F 79  STA $794F 
$7994  AD 30 1C  LDA $1C30 
$7997  38        SEC 
$7998  E5 82     SBC $82 
$799A  8D 4C 79  STA $794C 
$799D  8D 30 1C  STA $1C30 
$79A0  AD 31 1C  LDA $1C31 
$79A3  E5 83     SBC $83 
$79A5  8D 31 1C  STA $1C31 
$79A8  8D 4D 79  STA $794D 
$79AB  20 77 4A  JSR L_JSR_($4A77)_($79AB) OK
$79AE  A9 00     LDA #$00
$79B0  8D 46 1C  STA $1C46 
$79B3  AD 4C 79  LDA $794C 
$79B6  38        SEC 
$79B7  ED 30 1C  SBC $1C30 
$79BA  AA        TAX 
$79BB  AD 4D 79  LDA $794D 
$79BE  ED 31 1C  SBC $1C31 
$79C1  A8        TAY 
$79C2  8A        TXA 
$79C3  0A        ASL A 
$79C4  AA        TAX 
$79C5  98        TYA 
$79C6  2A        ROL A 
$79C7  A8        TAY 
$79C8  8A        TXA 
$79C9  0A        ASL A 
$79CA  98        TYA 
$79CB  2A        ROL A 
$79CC  F0 12     BEQ L_BRS_($79E0)_($79CC) OK
$79CE  48        PHA 
$79CF  AD 43 15  LDA $1543 
$79D2  09 14     ORA #$14
$79D4  8D 43 15  STA $1543 
$79D7  68        PLA 
$79D8  CD 43 1C  CMP $1C43 
$79DB  90 03     BCC L_BRS_($79E0)_($79DB) OK
$79DD  20 21 79  JSR L_JSR_($7921)_($79DD) OK
//------------------------------
L_BRS_($79E0)_($79CC) OK
L_BRS_($79E0)_($79DB) OK
//------------------------------
$79E0  AD 30 1C  LDA $1C30 
$79E3  29 C0     AND #$C0
$79E5  09 20     ORA #$20
$79E7  18        CLC 
$79E8  6D 4E 79  ADC $794E 
$79EB  8D 30 1C  STA $1C30 
$79EE  AD 31 1C  LDA $1C31 
$79F1  6D 4F 79  ADC $794F 
$79F4  8D 31 1C  STA $1C31 
$79F7  60        RTS 
//------------------------------
L_JSR_($79F8)_($5F73) OK
L_JSR_($79F8)_($5FC9) OK
L_JSR_($79F8)_($6021) OK
L_JSR_($79F8)_($602F) OK
L_JSR_($79F8)_($69AD) OK
L_JSR_($79F8)_($6E21) OK
//------------------------------
$79F8  78        SEI 					; TODO: show sprites?
$79F9  86 82     STX $82 
$79FB  85 83     STA $83 
$79FD  29 0F     AND #$0F
$79FF  AA        TAX 
$7A00  AD 2F 17  LDA $172F 
$7A03  9D 27 D0  STA $D027,X                          // Sprite 0 Color
$7A06  8A        TXA 
$7A07  0A        ASL A 
$7A08  AA        TAX 
$7A09  98        TYA 
$7A0A  9D 01 D0  STA $D001,X                          // Sprite 0 Y Pos
$7A0D  A5 82     LDA $82 
$7A0F  9D 00 D0  STA $D000,X                          // Sprite 0 X Pos
$7A12  A9 01     LDA #$01
$7A14  A6 83     LDX $83 
$7A16  F0 04     BEQ L_BRS_($7A1C)_($7A16) OK
//------------------------------
L_BRS_($7A18)_($7A1A) OK
//------------------------------
$7A18  0A        ASL A 
$7A19  CA        DEX 
$7A1A  D0 FC     BNE L_BRS_($7A18)_($7A1A) OK
//------------------------------
L_BRS_($7A1C)_($7A16) OK
//------------------------------
$7A1C  48        PHA 
$7A1D  0D 15 D0  ORA $D015                         // Sprite display Enable
$7A20  8D 15 D0  STA $D015                          // Sprite display Enable
$7A23  68        PLA 
$7A24  AC 2D 17  LDY $172D 
$7A27  F0 09     BEQ L_BRS_($7A32)_($7A27) OK
$7A29  0D 10 D0  ORA $D010                         // Sprites 0-7 MSB of X coordinate
$7A2C  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
$7A2F  4C 3A 7A  JMP L_JMP_($7A3A)_($7A2F) OK
//------------------------------
L_BRS_($7A32)_($7A27) OK
//------------------------------
$7A32  49 FF     EOR #$FF
$7A34  2D 10 D0  AND $D010                          // Sprites 0-7 MSB of X coordinate
$7A37  8D 10 D0  STA $D010                          // Sprites 0-7 MSB of X coordinate
//------------------------------
L_JMP_($7A3A)_($7A2F) OK
//------------------------------
$7A3A  AD C6 1A  LDA $1AC6 
$7A3D  D0 01     BNE L_BRS_($7A40)_($7A3D) OK
$7A3F  58        CLI 
//------------------------------
L_BRS_($7A40)_($7A3D) OK
//------------------------------
$7A40  60        RTS 
//------------------------------
L_JSR_($7A41)_($5E8E) OK
L_JSR_($7A41)_($5E93) OK
L_JSR_($7A41)_($5F88) OK
L_JSR_($7A41)_($5FDE) OK
L_JSR_($7A41)_($6E50) OK
//------------------------------
$7A41  78        SEI 
$7A42  29 07     AND #$07
$7A44  AA        TAX 
$7A45  08        PHP 
$7A46  A9 01     LDA #$01
$7A48  28        PLP 
$7A49  F0 04     BEQ L_BRS_($7A4F)_($7A49) OK
//------------------------------
L_BRS_($7A4B)_($7A4D) OK
//------------------------------
$7A4B  0A        ASL A 
$7A4C  CA        DEX 
$7A4D  D0 FC     BNE L_BRS_($7A4B)_($7A4D) OK
//------------------------------
L_BRS_($7A4F)_($7A49) OK
//------------------------------
$7A4F  49 FF     EOR #$FF
$7A51  2D 15 D0  AND $D015                          // Sprite display Enable
$7A54  8D 15 D0  STA $D015                          // Sprite display Enable
$7A57  AD C6 1A  LDA $1AC6 
$7A5A  D0 01     BNE L_BRS_($7A5D)_($7A5A) OK
$7A5C  58        CLI 
//------------------------------
L_BRS_($7A5D)_($7A5A) OK
//------------------------------
$7A5D  60        RTS 
//------------------------------
$7A5E            .byte $14,$1A,$00
$7A61  0D 01 0D  ORA $0D01
$7A64            .byte $02
$7A65  0D 02 0C  ORA $0C02
$7A68            .byte $03,$0C,$03,$0B,$04,$0B,$04
$7A6F  0A        ASL A 
$7A70  05 08     ORA $08
$7A72  06 07     ASL $07 
$7A74  06 06     ASL $06 
$7A76  06 05     ASL $05 
$7A78  06 04     ASL $04 
$7A7A            .byte $07,$03,$07,$02,$07,$00,$00
$7A81  0A        ASL A 
$7A82  01 0A     ORA ($0A,X)
$7A84  01 0A     ORA ($0A,X)
$7A86            .byte $02
$7A87  0A        ASL A 
$7A88            .byte $02
$7A89  0A        ASL A 
$7A8A            .byte $03
$7A8B  09 03     ORA #$03
$7A8D  09 04     ORA #$04
$7A8F  08        PHP 
$7A90            .byte $04,$07,$04
$7A93  06 04     ASL $04 
$7A95  05 05     ORA $05
$7A97            .byte $04
$7A98  05 03     ORA $03
$7A9A  05 02     ORA $02
$7A9C  05 01     ORA $01
$7A9E  05 00     ORA $00
$7AA0            .byte $00,$00
//------------------------------
L_JSR_($7AA2)_($6B09) OK
L_JSR_($7AA2)_($6D14) OK
//------------------------------
$7AA2  A2 1F     LDX #$1F
//------------------------------
L_BRS_($7AA4)_($7ABD) OK
//------------------------------
$7AA4  BD 4D 1B  LDA $1B4D,X 	; TODO: Update watch on screen
$7AA7  9D 38 F9  STA $F938,X 
$7AAA  BD 6D 1B  LDA $1B6D,X 
$7AAD  9D 78 FA  STA $FA78,X 
$7AB0  BD 8D 1B  LDA $1B8D,X 
$7AB3  9D B8 FB  STA $FBB8,X 
$7AB6  BD AD 1B  LDA $1BAD,X 
$7AB9  9D F8 FC  STA $FCF8,X 
$7ABC  CA        DEX 
$7ABD  10 E5     BPL L_BRS_($7AA4)_($7ABD) OK
$7ABF  A9 03     LDA #$03
$7AC1  8D A1 7A  STA $7AA1 
$7AC4  A9 01     LDA #$01
$7AC6  8D 2E 17  STA $172E 
$7AC9  A9 00     LDA #$00
$7ACB  8D 2F 17  STA $172F 
$7ACE  A9 95     LDA #$95
$7AD0  8D E9 7A  STA $7AE9 
$7AD3  A9 1C     LDA #$1C
$7AD5  8D EA 7A  STA $7AEA 
$7AD8  A9 80     LDA #$80
$7ADA  8D 23 7B  STA $7B23 
$7ADD  8D 3F 7B  STA $7B3F 
$7AE0  A9 7A     LDA #$7A
$7AE2  8D 24 7B  STA $7B24 
$7AE5  8D 40 7B  STA $7B40 
//------------------------------
L_JMP_($7AE8)_($7B85) OK
//------------------------------
$7AE8  AD FF FF  LDA $FFFF 
$7AEB  A2 02     LDX #$02
$7AED  C9 10     CMP #$10
$7AEF  30 2F     BMI L_BRS_($7B20)_($7AEF) OK
$7AF1  C9 1F     CMP #$1F
$7AF3  10 0E     BPL L_BRS_($7B03)_($7AF3) OK
$7AF5  A2 00     LDX #$00
$7AF7  8D A0 7A  STA $7AA0 
$7AFA  A9 1E     LDA #$1E
$7AFC  38        SEC 
$7AFD  ED A0 7A  SBC $7AA0 
$7B00  4C 20 7B  JMP L_JMP_($7B20)_($7B00) OK
//------------------------------
L_BRS_($7B03)_($7AF3) OK
//------------------------------
$7B03  C9 2E     CMP #$2E
$7B05  10 0E     BPL L_BRS_($7B15)_($7B05) OK
$7B07  A2 1E     LDX #$1E
$7B09  8E A0 7A  STX $7AA0 
$7B0C  38        SEC 
$7B0D  ED A0 7A  SBC $7AA0 
$7B10  A2 01     LDX #$01
$7B12  4C 20 7B  JMP L_JMP_($7B20)_($7B12) OK
//------------------------------
L_BRS_($7B15)_($7B05) OK
//------------------------------
$7B15  A2 03     LDX #$03
$7B17  8D A0 7A  STA $7AA0 
$7B1A  A9 3C     LDA #$3C
$7B1C  38        SEC 
$7B1D  ED A0 7A  SBC $7AA0 
//------------------------------
L_BRS_($7B20)_($7AEF) OK
L_JMP_($7B20)_($7B00) OK
L_JMP_($7B20)_($7B12) OK
//------------------------------
$7B20  0A        ASL A 
$7B21  A8        TAY 
$7B22  B9 FF FF  LDA $FFFF,Y 
$7B25  E0 00     CPX #$00
$7B27  F0 0D     BEQ L_BRS_($7B36)_($7B27) OK
$7B29  E0 02     CPX #$02
$7B2B  F0 09     BEQ L_BRS_($7B36)_($7B2B) OK
$7B2D  8D A0 7A  STA $7AA0 
$7B30  A9 00     LDA #$00
$7B32  38        SEC 
$7B33  ED A0 7A  SBC $7AA0 
//------------------------------
L_BRS_($7B36)_($7B27) OK
L_BRS_($7B36)_($7B2B) OK
//------------------------------
$7B36  18        CLC 
$7B37  6D 5E 7A  ADC $7A5E 
$7B3A  8D 2B 17  STA $172B 
$7B3D  C8        INY 
$7B3E  B9 FF FF  LDA $FFFF,Y 
$7B41  E0 02     CPX #$02
$7B43  B0 09     BCS L_BRS_($7B4E)_($7B43) OK
$7B45  8D A0 7A  STA $7AA0 
$7B48  A9 00     LDA #$00
$7B4A  38        SEC 
$7B4B  ED A0 7A  SBC $7AA0 
//------------------------------
L_BRS_($7B4E)_($7B43) OK
//------------------------------
$7B4E  18        CLC 
$7B4F  6D 5F 7A  ADC $7A5F 
$7B52  8D 2C 17  STA $172C 
$7B55  AE 5E 7A  LDX $7A5E 
$7B58  AC 5F 7A  LDY $7A5F 
$7B5B  20 CB 5B  JSR L_JSR_($5BCB)_($7B5B) BAD
$7B5E  EE E9 7A  INC $7AE9 
$7B61  D0 03     BNE L_BRS_($7B66)_($7B61) OK
$7B63  EE EA 7A  INC $7AEA 
//------------------------------
L_BRS_($7B66)_($7B61) OK
//------------------------------
$7B66  A9 60     LDA #$60
$7B68  8D 23 7B  STA $7B23 
$7B6B  8D 3F 7B  STA $7B3F 
$7B6E  A9 7A     LDA #$7A
$7B70  8D 24 7B  STA $7B24 
$7B73  8D 40 7B  STA $7B40 
$7B76  AD A1 7A  LDA $7AA1 
$7B79  C9 02     CMP #$02
$7B7B  D0 03     BNE L_BRS_($7B80)_($7B7B) OK
$7B7D  8D 2F 17  STA $172F 
//------------------------------
L_BRS_($7B80)_($7B7B) OK
//------------------------------
$7B80  CE A1 7A  DEC $7AA1 
$7B83  F0 03     BEQ L_BRS_($7B88)_($7B83) OK
$7B85  4C E8 7A  JMP L_JMP_($7AE8)_($7B85) OK
//------------------------------
L_BRS_($7B88)_($7B83) OK
//------------------------------
$7B88  60        RTS 
//------------------------------
L_JSR_($7B89)_($2E71) OK
L_JSR_($7B89)_($5FF5) OK
//------------------------------
$7B89  A9 30     LDA #$30		; TODO: Probably draws targeting cursor in the middle of the screen (see eor usage)
$7B8B  18        CLC 
$7B8C  6D 8E 15  ADC $158E 
$7B8F  85 7A     STA $7A 
$7B91  A9 06     LDA #$06
$7B93  6D 8F 15  ADC $158F 
$7B96  85 7B     STA $7B 
$7B98  A0 00     LDY #$00
$7B9A  A2 03     LDX #$03
//------------------------------
L_BRS_($7B9C)_($7BA8) OK
//------------------------------
$7B9C  B1 7A     LDA ($7A),Y 
$7B9E  49 01     EOR #$01
$7BA0  91 7A     STA ($7A),Y 
$7BA2  98        TYA 
$7BA3  18        CLC 
$7BA4  69 20     ADC #$20
$7BA6  A8        TAY 
$7BA7  CA        DEX 
$7BA8  D0 F2     BNE L_BRS_($7B9C)_($7BA8) OK
$7BAA  B1 7A     LDA ($7A),Y 
$7BAC  49 14     EOR #$14
$7BAE  91 7A     STA ($7A),Y 
$7BB0  88        DEY 
$7BB1  B1 7A     LDA ($7A),Y 
$7BB3  49 50     EOR #$50
$7BB5  91 7A     STA ($7A),Y 
$7BB7  C8        INY 
$7BB8  A2 03     LDX #$03
//------------------------------
L_BRS_($7BBA)_($7BC6) OK
//------------------------------
$7BBA  98        TYA 
$7BBB  18        CLC 
$7BBC  69 20     ADC #$20
$7BBE  A8        TAY 
$7BBF  B1 7A     LDA ($7A),Y 
$7BC1  49 01     EOR #$01
$7BC3  91 7A     STA ($7A),Y 
$7BC5  CA        DEX 
$7BC6  D0 F2     BNE L_BRS_($7BBA)_($7BC6) OK
$7BC8  60        RTS 
//------------------------------
$7BC9            .byte $00,$00,$00
$7BCC  01 02     ORA ($02,X)
$7BCE            .byte $00
$7BCF  01 02     ORA ($02,X)
$7BD1            .byte $02,$03,$04
$7BD4  05 07     ORA $07
$7BD6  09 0B     ORA #$0B
$7BD8  0E 11 14  ASL $1411 
$7BDB  18        CLC 
$7BDC            .byte $1C
$7BDD  20 25 2A  JSR L_JSR_($2A25)_($7BDD) BAD
$7BE0            .byte $2F
$7BE1  35 3B     AND $3B,X 
$7BE3  41 48     EOR ($48,X) 
$7BE5            .byte $4F
$7BE6  56 00     LSR $00,X 
//------------------------------
L_JSR_($7BE8)_($43D5) OK
//------------------------------
$7BE8  AD 89 15  LDA $1589 
$7BEB  48        PHA 
//------------------------------
L_JMP_($7BEC)_($7BFF) OK
//------------------------------
$7BEC  AD 3C 1C  LDA $1C3C 
$7BEF  F0 11     BEQ L_BRS_($7C02)_($7BEF) OK
$7BF1  AA        TAX 
$7BF2  E8        INX 
$7BF3  8A        TXA 
$7BF4  29 FE     AND #$FE
$7BF6  AA        TAX 
$7BF7  CA        DEX 
$7BF8  CA        DEX 
$7BF9  8E 3C 1C  STX $1C3C 
$7BFC  20 88 1F  JSR L_JSR_($1F88)_($7BFC) OK
$7BFF  4C EC 7B  JMP L_JMP_($7BEC)_($7BFF) OK
//------------------------------
L_BRS_($7C02)_($7BEF) OK
//------------------------------
$7C02  68        PLA 
$7C03  C9 05     CMP #$05
$7C05  D0 28     BNE L_BRS_($7C2F)_($7C05) OK
$7C07  A9 08     LDA #$08
$7C09  8D E7 7B  STA $7BE7 
//------------------------------
L_BRS_($7C0C)_($7C18) OK
//------------------------------
$7C0C  CE 3C 1C  DEC $1C3C 
$7C0F  CE 3C 1C  DEC $1C3C 
$7C12  20 88 1F  JSR L_JSR_($1F88)_($7C12) OK
$7C15  CE E7 7B  DEC $7BE7 
$7C18  D0 F2     BNE L_BRS_($7C0C)_($7C18) OK
$7C1A  20 98 76  JSR L_JSR_($7698)_($7C1A) OK
$7C1D  A2 64     LDX #$64
$7C1F  A0 1A     LDY #$1A
$7C21  A9 8A     LDA #$8A
$7C23  85 7C     STA $7C 
$7C25  A9 96     LDA #$96
$7C27  85 7D     STA $7D 
$7C29  20 71 68  JSR L_JSR_($6871)_($7C29) OK	; print text in the center
$7C2C  4C 0B 7D  JMP L_JMP_($7D0B)_($7C2C) OK
//------------------------------
L_BRS_($7C2F)_($7C05) OK
//------------------------------
$7C2F  A9 00     LDA #$00
$7C31  8D 2E 17  STA $172E 
$7C34  A9 03     LDA #$03
$7C36  8D 2F 17  STA $172F 
$7C39  A9 05     LDA #$05
$7C3B  20 4B CB  JSR L_JSR_($CB4B)_($7C3B) OK	; TODO: start sound effect? (5: Bump)
$7C3E  A2 16     LDX #$16
$7C40  A0 02     LDY #$02
$7C42  8C C9 7B  STY $7BC9 
$7C45  8C CA 7B  STY $7BCA 
//------------------------------
L_BRS_($7C48)_($7C5C) OK
//------------------------------
$7C48  20 0C 7D  JSR L_JSR_($7D0C)_($7C48) OK
$7C4B  AD CA 7B  LDA $7BCA 
$7C4E  0A        ASL A 
$7C4F  18        CLC 
$7C50  69 07     ADC #$07
$7C52  4A        LSR A 
$7C53  8D CA 7B  STA $7BCA 
$7C56  4A        LSR A 
$7C57  4A        LSR A 
$7C58  8D C9 7B  STA $7BC9 
$7C5B  CA        DEX 
$7C5C  D0 EA     BNE L_BRS_($7C48)_($7C5C) OK
$7C5E  A9 05     LDA #$05
$7C60  20 4B CB  JSR L_JSR_($CB4B)_($7C60) OK	; TODO: start sound effect (5: Bump)
$7C63  A9 01     LDA #$01
$7C65  8D 2F 17  STA $172F 
$7C68  A2 00     LDX #$00
$7C6A  A9 00     LDA #$00
//------------------------------
L_BRS_($7C6C)_($7CA0) OK
//------------------------------
$7C6C  48        PHA 
$7C6D  C9 16     CMP #$16
$7C6F  08        PHP 
$7C70  BD D1 7B  LDA $7BD1,X 
$7C73  8D C9 7B  STA $7BC9 
$7C76  4A        LSR A 
$7C77  8D CA 7B  STA $7BCA 
$7C7A  28        PLP 
//------------------------------
L_JSR_($7C7C)_($A46B) BAD
L_JSR_($7C7C)_($A4AB) BAD
//------------------------------
$7C7B  B0 03     BCS L_BRS_($7C80)_($7C7B) OK
$7C7D  20 0C 7D  JSR L_JSR_($7D0C)_($7C7D) OK
//------------------------------
L_BRS_($7C80)_($7C7B) OK
//------------------------------
$7C80  68        PLA 
$7C81  48        PHA 
$7C82  C9 02     CMP #$02
$7C84  08        PHP 
$7C85  CA        DEX 
$7C86  CA        DEX 
$7C87  BD D1 7B  LDA $7BD1,X 
$7C8A  8D C9 7B  STA $7BC9 
$7C8D  4A        LSR A 
$7C8E  8D CA 7B  STA $7BCA 
$7C91  28        PLP 
$7C92  90 03     BCC L_BRS_($7C97)_($7C92) OK
$7C94  20 0C 7D  JSR L_JSR_($7D0C)_($7C94) OK
//------------------------------
L_BRS_($7C97)_($7C92) OK
//------------------------------
$7C97  E8        INX 
$7C98  E8        INX 
$7C99  E8        INX 
$7C9A  68        PLA 
$7C9B  A8        TAY 
$7C9C  C8        INY 
$7C9D  98        TYA 
$7C9E  C9 18     CMP #$18
$7CA0  D0 CA     BNE L_BRS_($7C6C)_($7CA0) OK
$7CA2  A9 08     LDA #$08
$7CA4  20 4B CB  JSR L_JSR_($CB4B)_($7CA4) OK	; TODO: start sound effect? (8: Bonus #1)
$7CA7  AD 64 1C  LDA $1C64 
$7CAA  48        PHA 
$7CAB  AD 65 1C  LDA $1C65 
$7CAE  48        PHA 
$7CAF  AD 66 1C  LDA $1C66 
$7CB2  48        PHA 
$7CB3  AD 67 1C  LDA $1C67 
$7CB6  48        PHA 
$7CB7  A2 06     LDX #$06
//------------------------------
L_BRS_($7CB9)_($7CDA) OK
//------------------------------
$7CB9  8A        TXA 
$7CBA  48        PHA 
$7CBB  BD CA 7B  LDA $7BCA,X 
$7CBE  8D 64 1C  STA $1C64 
$7CC1  8D 65 1C  STA $1C65 
$7CC4  8D 66 1C  STA $1C66 
$7CC7  8D 67 1C  STA $1C67 
$7CCA  20 33 5B  JSR L_JSR_($5B33)_($7CCA) BAD
$7CCD  A0 50     LDY #$50
//------------------------------
L_BRS_($7CCF)_($7CD5) OK
//------------------------------
$7CCF  A2 00     LDX #$00
//------------------------------
L_BRS_($7CD1)_($7CD2) OK
//------------------------------
$7CD1  CA        DEX 
$7CD2  D0 FD     BNE L_BRS_($7CD1)_($7CD2) OK
$7CD4  88        DEY 
$7CD5  D0 F8     BNE L_BRS_($7CCF)_($7CD5) OK
$7CD7  68        PLA 
$7CD8  AA        TAX 
$7CD9  CA        DEX 
$7CDA  D0 DD     BNE L_BRS_($7CB9)_($7CDA) OK
$7CDC  20 98 76  JSR L_JSR_($7698)_($7CDC) OK
$7CDF  A2 64     LDX #$64
$7CE1  A0 1A     LDY #$1A
$7CE3  A9 8A     LDA #$8A
$7CE5  85 7C     STA $7C 
$7CE7  A9 96     LDA #$96
$7CE9  85 7D     STA $7D 
$7CEB  20 71 68  JSR L_JSR_($6871)_($7CEB) OK
$7CEE  68        PLA 
$7CEF  8D 67 1C  STA $1C67 
$7CF2  68        PLA 
$7CF3  8D 66 1C  STA $1C66 
$7CF6  68        PLA 
$7CF7  8D 65 1C  STA $1C65 
$7CFA  68        PLA 
$7CFB  8D 64 1C  STA $1C64 
$7CFE  A9 32     LDA #$32
$7D00  8D 4E 15  STA $154E 
//------------------------------
L_BRS_($7D03)_($7D06) OK
//------------------------------
$7D03  AD 4E 15  LDA $154E 
$7D06  D0 FB     BNE L_BRS_($7D03)_($7D06) OK
$7D08  20 33 5B  JSR L_JSR_($5B33)_($7D08) BAD
//------------------------------
L_JMP_($7D0B)_($7C2C) OK
//------------------------------
$7D0B  60        RTS 
//------------------------------
L_JSR_($7D0C)_($7C48) OK
L_JSR_($7D0C)_($7C7D) OK
L_JSR_($7D0C)_($7C94) OK
//------------------------------
$7D0C  8A        TXA 
$7D0D  48        PHA 
$7D0E  98        TYA 
$7D0F  48        PHA 
$7D10  A0 48     LDY #$48
$7D12  A2 00     LDX #$00
//------------------------------
L_BRS_($7D14)_($7D70) OK
//------------------------------
$7D14  98        TYA 
$7D15  48        PHA 
$7D16  8A        TXA 
$7D17  48        PHA 
$7D18  BD 9C 17  LDA $179C,X 
$7D1B  AA        TAX 
$7D1C  AC C9 7B  LDY $7BC9 
$7D1F  20 76 1E  JSR L_JSR_($1E76)_($7D1F) OK
$7D22  06 82     ASL $82 
$7D24  26 83     ROL $83 
$7D26  06 82     ASL $82 
$7D28  26 83     ROL $83 
$7D2A  A9 41     LDA #$41
$7D2C  18        CLC 
$7D2D  65 83     ADC $83 
$7D2F  8D 2C 17  STA $172C 
$7D32  68        PLA 
$7D33  AA        TAX 
$7D34  E8        INX 
$7D35  8A        TXA 
$7D36  48        PHA 
$7D37  BD 9C 17  LDA $179C,X 
$7D3A  AA        TAX 
$7D3B  AC CA 7B  LDY $7BCA 
$7D3E  20 76 1E  JSR L_JSR_($1E76)_($7D3E) OK
$7D41  06 82     ASL $82 
$7D43  26 83     ROL $83 
$7D45  06 82     ASL $82 
$7D47  26 83     ROL $83 
$7D49  A9 40     LDA #$40
$7D4B  18        CLC 
$7D4C  65 83     ADC $83 
$7D4E  F0 1A     BEQ L_BRS_($7D6A)_($7D4E) OK
$7D50  C9 81     CMP #$81
$7D52  B0 16     BCS L_BRS_($7D6A)_($7D52) OK
$7D54  8D 2B 17  STA $172B 
$7D57  AD 2C 17  LDA $172C 
$7D5A  C9 69     CMP #$69
$7D5C  B0 0C     BCS L_BRS_($7D6A)_($7D5C) OK
$7D5E  AD 2C 17  LDA $172C 
$7D61  18        CLC 
$7D62  69 40     ADC #$40
$7D64  8D 2C 17  STA $172C 
$7D67  20 8C 5D  JSR L_JSR_($5D8C)_($7D67) OK
//------------------------------
L_BRS_($7D6A)_($7D4E) OK
L_BRS_($7D6A)_($7D52) OK
L_BRS_($7D6A)_($7D5C) OK
//------------------------------
$7D6A  68        PLA 
$7D6B  AA        TAX 
$7D6C  E8        INX 
$7D6D  68        PLA 
$7D6E  A8        TAY 
$7D6F  88        DEY 
$7D70  D0 A2     BNE L_BRS_($7D14)_($7D70) OK
$7D72  68        PLA 
$7D73  A8        TAY 
$7D74  68        PLA 
$7D75  AA        TAX 
$7D76  60        RTS 
//------------------------------
$7D77            .byte $0B
$7D78  08        PHP 
$7D79  0D 0A 0E  ORA $0E0A
$7D7C  0D 10 0F  ORA $0F10
$7D7F  11 12     ORA ($12),Y
$7D81            .byte $13,$14,$14,$17
$7D85  16 19     ASL $19,X 
$7D87            .byte $17
$7D88  1D 19 1D  ORA $1D19,X
//------------------------------
L_JSR_($7D8B)_($1FA1) OK
L_JSR_($7D8B)_($1FCD) OK
L_JSR_($7D8B)_($1FE4) OK
L_JSR_($7D8B)_($1FEC) OK
L_JSR_($7D8B)_($2001) OK
L_JSR_($7D8B)_($4187) OK
//------------------------------
$7D8B  78        SEI 		; draw bottle
$7D8C  48        PHA 
$7D8D  20 2A 6B  JSR L_JSR_($6B2A)_($7D8D) OK
$7D90  A2 00     LDX #$00
$7D92  8E 6F 15  STX $156F 
$7D95  20 2A 6B  JSR L_JSR_($6B2A)_($7D95) OK
$7D98  68        PLA 
$7D99  C9 00     CMP #$00
$7D9B  F0 30     BEQ L_BRS_($7DCD)_($7D9B) OK
$7D9D  A8        TAY 
$7D9E  88        DEY 
$7D9F  98        TYA 
$7DA0  0A        ASL A 
$7DA1  0A        ASL A 
$7DA2  A8        TAY 
$7DA3  A9 00     LDA #$00
$7DA5  8D 2F 17  STA $172F 
$7DA8  A9 2A     LDA #$2A
$7DAA  8D 2B 17  STA $172B 
$7DAD  A2 04     LDX #$04
//------------------------------
L_BRS_($7DAF)_($7DCB) OK
//------------------------------
$7DAF  B9 77 7D  LDA $7D77,Y 
$7DB2  C8        INY 
$7DB3  8D 2C 17  STA $172C 
$7DB6  8A        TXA 
$7DB7  48        PHA 
$7DB8  98        TYA 
$7DB9  48        PHA 
$7DBA  20 8C 5D  JSR L_JSR_($5D8C)_($7DBA) OK	; draw bubbles in bottle?
$7DBD  68        PLA 
$7DBE  A8        TAY 
$7DBF  68        PLA 
$7DC0  AA        TAX 
$7DC1  AD 2B 17  LDA $172B 
$7DC4  18        CLC 
$7DC5  69 04     ADC #$04
$7DC7  8D 2B 17  STA $172B 
$7DCA  CA        DEX 
$7DCB  D0 E2     BNE L_BRS_($7DAF)_($7DCB) OK
//------------------------------
L_BRS_($7DCD)_($7D9B) OK
//------------------------------
$7DCD  58        CLI 
$7DCE  60        RTS 
//------------------------------
$7DCF            .byte $00,$00
$7DD1  08        PHP 			; TODO: IBSOUT Vector to Kernal CHROUT Routine, used by C64 system file save routines to show messages for the user (PRESS PLAY ON TAPE, etc)
$7DD2  48        PHA 
$7DD3  A5 9A     LDA $9A 
$7DD5  C9 03     CMP #$03
$7DD7  F0 05     BEQ L_BRS_($7DDE)_($7DD7) OK
$7DD9  68        PLA 
$7DDA  28        PLP 
$7DDB  4C CA F1  JMP L_JMP_($F1CA)_($7DDB) JAM
//------------------------------
L_BRS_($7DDE)_($7DD7) OK
//------------------------------
$7DDE  68        PLA 
$7DDF  8D CF 7D  STA $7DCF 
$7DE2  48        PHA 
$7DE3  8A        TXA 
$7DE4  48        PHA 
$7DE5  98        TYA 
$7DE6  48        PHA 
//------------------------------
L_JMP_($7DE7)_($7E82) OK
//------------------------------
$7DE7  AD 29 17  LDA $1729 
$7DEA  F0 2A     BEQ L_BRS_($7E16)_($7DEA) OK
$7DEC  78        SEI 
$7DED  A9 35     LDA #$35
$7DEF  85 01     STA $01 
$7DF1  A2 70     LDX #$70
//------------------------------
L_BRS_($7DF3)_($7E0C) OK
//------------------------------
$7DF3  BD A7 EB  LDA $EBA7,X 		; TODO: Update screen?
$7DF6  9D 67 EA  STA $EA67,X 
$7DF9  BD E7 EC  LDA $ECE7,X                          // Shift-Run Equivalent
$7DFC  9D A7 EB  STA $EBA7,X 
$7DFF  BD 27 EE  LDA $EE27,X 
$7E02  9D E7 EC  STA $ECE7,X                          // Shift-Run Equivalent
$7E05  BD 67 EF  LDA $EF67,X 
$7E08  9D 27 EE  STA $EE27,X 
$7E0B  CA        DEX 
$7E0C  D0 E5     BNE L_BRS_($7DF3)_($7E0C) OK
$7E0E  8E 29 17  STX $1729 
$7E11  A9 37     LDA #$37
$7E13  85 01     STA $01 
$7E15  58        CLI 
//------------------------------
L_BRS_($7E16)_($7DEA) OK
//------------------------------
$7E16  AD CF 7D  LDA $7DCF 
$7E19  C9 40     CMP #$40
$7E1B  D0 16     BNE L_BRS_($7E33)_($7E1B) OK
$7E1D  AD D0 7D  LDA $7DD0 
$7E20  F0 0A     BEQ L_BRS_($7E2C)_($7E20) OK
$7E22  A9 00     LDA #$00
$7E24  8D D0 7D  STA $7DD0 
$7E27  A9 40     LDA #$40
$7E29  4C 45 7E  JMP L_JMP_($7E45)_($7E29) OK
//------------------------------
L_BRS_($7E2C)_($7E20) OK
//------------------------------
$7E2C  A9 01     LDA #$01
$7E2E  8D D0 7D  STA $7DD0 
$7E31  A9 0D     LDA #$0D
//------------------------------
L_BRS_($7E33)_($7E1B) OK
//------------------------------
$7E33  C9 0D     CMP #$0D
$7E35  D0 08     BNE L_BRS_($7E3F)_($7E35) OK
$7E37  AD 28 17  LDA $1728 
$7E3A  D0 28     BNE L_BRS_($7E64)_($7E3A) OK
$7E3C  4C 78 7E  JMP L_JMP_($7E78)_($7E3C) OK
//------------------------------
L_BRS_($7E3F)_($7E35) OK
//------------------------------
$7E3F  C9 60     CMP #$60
$7E41  D0 02     BNE L_BRS_($7E45)_($7E41) OK
$7E43  A9 2D     LDA #$2D
//------------------------------
L_JMP_($7E45)_($7E29) OK
L_BRS_($7E45)_($7E41) OK
//------------------------------
$7E45  AE 28 17  LDX $1728 
$7E48  9D 1A 17  STA $171A,X 
$7E4B  EE 28 17  INC $1728 
$7E4E  A2 1A     LDX #$1A
$7E50  A0 17     LDY #$17
$7E52  A9 AE     LDA #$AE
$7E54  85 7C     STA $7C 
$7E56  A9 96     LDA #$96
$7E58  85 7D     STA $7D 
$7E5A  20 6C 68  JSR L_JSR_($686C)_($7E5A) OK
$7E5D  AD 28 17  LDA $1728 
$7E60  C9 0E     CMP #$0E
$7E62  D0 21     BNE L_BRS_($7E85)_($7E62) OK
//------------------------------
L_BRS_($7E64)_($7E3A) OK
//------------------------------
$7E64  A9 00     LDA #$00
$7E66  8D 28 17  STA $1728 
$7E69  A9 01     LDA #$01
$7E6B  8D 29 17  STA $1729 
$7E6E  A9 20     LDA #$20
$7E70  A2 0E     LDX #$0E
//------------------------------
L_BRS_($7E72)_($7E76) OK
//------------------------------
$7E72  9D 19 17  STA $1719,X 
$7E75  CA        DEX 
$7E76  D0 FA     BNE L_BRS_($7E72)_($7E76) OK
//------------------------------
L_JMP_($7E78)_($7E3C) OK
//------------------------------
$7E78  AD D0 7D  LDA $7DD0 
$7E7B  F0 08     BEQ L_BRS_($7E85)_($7E7B) OK
$7E7D  A9 40     LDA #$40
$7E7F  8D CF 7D  STA $7DCF 
$7E82  4C E7 7D  JMP L_JMP_($7DE7)_($7E82) OK
//------------------------------
L_BRS_($7E85)_($7E62) OK
L_BRS_($7E85)_($7E7B) OK
//------------------------------
$7E85  68        PLA 
$7E86  A8        TAY 
$7E87  68        PLA 
$7E88  AA        TAX 
$7E89  68        PLA 
$7E8A  28        PLP 
$7E8B  60        RTS 
//------------------------------
L_JSR_($7E8C)_($4071) OK
L_JSR_($7E8C)_($8457) OK
L_JSR_($7E8C)_($8527) OK
L_JSR_($7E8C)_($8543) OK
//------------------------------
$7E8C  78        SEI 			; TODO: make copy of zero page at $df00, this is only required to call C64 ROM functions, not needed for Atari.
$7E8D  A9 34     LDA #$34
$7E8F  85 01     STA $01 
$7E91  A2 02     LDX #$02
//------------------------------
L_BRS_($7E93)_($7EA0) OK
//------------------------------
$7E93  B5 00     LDA $00,X 
$7E95  48        PHA 
$7E96  BD 00 DF  LDA $DF00,X 
$7E99  95 00     STA $00,X 
$7E9B  68        PLA 
$7E9C  9D 00 DF  STA $DF00,X 
$7E9F  E8        INX 
$7EA0  D0 F1     BNE L_BRS_($7E93)_($7EA0) OK
$7EA2  A9 35     LDA #$35
$7EA4  85 01     STA $01 
$7EA6  60        RTS 
//------------------------------
$7EA7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EAF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EB7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7ECF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7ED7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EDF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EE7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EEF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EF7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7EFF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F07            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F0F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F17            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F1F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F27            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F3F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F47            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F5F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F67            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F7F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F87            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F8F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7F9F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FA7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FAF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FB7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FCF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FD7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FDF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FE7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FEF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FF7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$7FFF            .byte $00,$07,$07,$07,$07
$8004  01 01     ORA ($01,X)
$8006  01 01     ORA ($01,X)
$8008  01 01     ORA ($01,X)
$800A  01 01     ORA ($01,X)
$800C  01 01     ORA ($01,X)
//------------------------------
L_JSR_($800E)_($CB45) OK
//------------------------------
$800E  01 01     ORA ($01,X)
$8010  01 01     ORA ($01,X)
$8012  01 01     ORA ($01,X)
$8014  01 01     ORA ($01,X)
$8016  01 01     ORA ($01,X)
$8018  01 01     ORA ($01,X)
$801A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8022            .byte $07,$07,$07,$07,$07,$07,$07,$07
$802A            .byte $07,$07
$802C  01 01     ORA ($01,X)
$802E  01 01     ORA ($01,X)
$8030  01 01     ORA ($01,X)
$8032  01 01     ORA ($01,X)
$8034  01 01     ORA ($01,X)
$8036  01 01     ORA ($01,X)
$8038  01 01     ORA ($01,X)
$803A  01 01     ORA ($01,X)
$803C  01 01     ORA ($01,X)
$803E  01 01     ORA ($01,X)
$8040  01 01     ORA ($01,X)
$8042            .byte $07,$07,$07,$07,$07,$07,$07,$07
//------------------------------
L_JSR_($804E)_($0855) JAM
//------------------------------
$804A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8052            .byte $07,$07,$07,$07,$07,$07,$07,$07
$805A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8062            .byte $07,$07,$07,$07,$07,$07,$07,$07
$806A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8072            .byte $07,$07,$07,$07,$07,$07,$07,$07
$807A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8082            .byte $07,$07,$07,$07,$07,$07,$07,$07
$808A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8092            .byte $07,$07,$07,$07,$07,$07,$07,$07
$809A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80A2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80AA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80B2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80BA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80C2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80CA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80D2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80DA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80E2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80EA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80F2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$80FA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8102            .byte $07,$07,$07,$07,$07,$07,$07,$07
$810A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8112            .byte $07,$07,$07,$07,$07,$07,$07,$07
$811A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8122            .byte $07,$07,$07,$07,$07,$07,$07,$07
$812A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8132            .byte $07,$07,$07,$07,$07,$07,$07,$07
$813A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8142            .byte $07,$07,$07,$07,$07,$07,$07,$07
$814A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8152            .byte $07,$07,$07,$07,$07,$07,$07,$07
$815A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8162            .byte $07,$07,$07,$07,$07,$07,$07,$07
$816A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8172            .byte $07,$07,$07,$07,$07,$07,$07,$07
$817A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8182            .byte $07,$07,$07,$07,$07,$07,$07,$07
$818A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8192            .byte $07,$07,$07,$07,$07,$07,$07,$07
$819A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81A2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81AA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81B2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81BA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81C2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81CA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81D2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81DA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81E2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81EA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81F2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$81FA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8202            .byte $07,$07,$07,$07,$07,$07,$07,$07
$820A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8212            .byte $07,$07,$07,$07,$07,$07,$07,$07
$821A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8222            .byte $07,$07,$07,$07,$07,$07,$07,$07
$822A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8232            .byte $07,$07,$07,$07,$07,$07,$07,$07
$823A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8242            .byte $07,$07,$07,$07,$07,$07,$07,$07
$824A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8252            .byte $07,$07,$07,$07,$07,$07,$07,$07
$825A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8262            .byte $07,$07,$07,$07,$07,$07,$07,$07
$826A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8272            .byte $07,$07,$07,$07,$07,$07,$07,$07
$827A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8282            .byte $07,$07,$07,$07,$07,$07,$07,$07
$828A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8292            .byte $07,$07,$07,$07,$07,$07,$07,$07
$829A            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82A2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82AA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82B2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82BA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82C2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82CA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82D2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82DA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82E2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82EA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82F2            .byte $07,$07,$07,$07,$07,$07,$07,$07
$82FA            .byte $07,$07
$82FC  01 01     ORA ($01,X)
$82FE  01 01     ORA ($01,X)
$8300  01 01     ORA ($01,X)
$8302  01 01     ORA ($01,X)
$8304  01 01     ORA ($01,X)
$8306            .byte $07,$07,$07,$07,$07,$07,$07,$07
$830E            .byte $07,$07,$07,$07,$07,$07,$07
$8315  01 01     ORA ($01,X)
$8317  01 07     ORA ($07,X)
$8319            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8321            .byte $07,$07,$07,$07,$07
$8326  01 01     ORA ($01,X)
$8328  01 01     ORA ($01,X)
$832A  01 01     ORA ($01,X)
$832C  01 07     ORA ($07,X)
$832E            .byte $03,$03,$03,$03,$07,$07,$07,$07
$8336            .byte $07,$07,$07,$07,$07,$07,$07,$07
$833E  01 07     ORA ($07,X)
$8340            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8348            .byte $07,$07,$07,$07,$07,$07
$834E  01 01     ORA ($01,X)
$8350  01 01     ORA ($01,X)
$8352  01 01     ORA ($01,X)
$8354  01 07     ORA ($07,X)
$8356            .byte $03,$03,$03,$03,$07,$07,$07,$07
$835E            .byte $07,$07,$07,$07,$07,$07,$07
$8365  01 01     ORA ($01,X)
$8367  01 01     ORA ($01,X)
$8369            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8371            .byte $07,$07,$07,$07,$07
$8376  01 01     ORA ($01,X)
$8378  01 01     ORA ($01,X)
$837A  01 01     ORA ($01,X)
$837C  01 07     ORA ($07,X)
$837E            .byte $03,$03,$03,$03,$07,$07,$07,$07
$8386            .byte $07,$07,$07,$07,$07,$07,$07
$838D  01 01     ORA ($01,X)
$838F  01 01     ORA ($01,X)
$8391            .byte $07,$07,$07,$07,$07,$07,$07,$07
$8399            .byte $07,$07,$07,$07,$07
$839E  01 01     ORA ($01,X)
$83A0  01 01     ORA ($01,X)
$83A2  01 01     ORA ($01,X)
$83A4  01 07     ORA ($07,X)
$83A6            .byte $03,$03,$03,$03,$07,$07,$07,$07
$83AE            .byte $07,$07,$07,$07,$07,$07
$83B4  01 01     ORA ($01,X)
$83B6  01 01     ORA ($01,X)
$83B8  01 07     ORA ($07,X)
$83BA            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83C2            .byte $07,$07,$07,$07
$83C6  01 07     ORA ($07,X)
$83C8            .byte $07,$07,$07,$07,$07,$07,$03,$03
$83D0            .byte $03,$03,$07,$07,$07,$07,$07,$07
$83D8            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83E0            .byte $07,$07,$07,$07,$07,$07,$07,$07
$83E8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$83F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$83F8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8400  20 20 20  JSR $2020
$8403  20 20 20  JSR $2020
$8406  20 20 20  JSR $2020
$8409  20 20 20  JSR $2020
$840C  20 20 20  JSR $2020
$840F  20 00 00  JSR $0000
$8412            .byte $00,$00
$8414  49 4E     EOR #$4E
$8416  56 41     LSR $41,X 
$8418  4C 49 44  JMP L_JMP_($4449)_($8418) BAD
$841B  20 46 49  JSR L_JSR_($4946)_($841B) BAD
$841E  4C 45 20  JMP L_JMP_($2045)_($841E) OK
$8421  20 46 49  JSR L_JSR_($4946)_($8421) BAD
$8424  4C 45 20  JMP L_JMP_($2045)_($8424) OK
$8427  4E 4F 54  LSR $544F 
$842A  20 46 4F  JSR L_JSR_($4F46)_($842A) BAD
$842D  55 4E     EOR $4E,X 
$842F            .byte $44
$8430  4C 4F 41  JMP L_JMP_($414F)_($8430) OK
$8433            .byte $44
$8434  49 4E     EOR #$4E
$8436            .byte $47
$8437  20 45 52  JSR L_JSR_($5245)_($8437) BAD
$843A            .byte $52,$4F,$52
$843D  20 53 41  JSR L_JSR_($4153)_($843D) BAD
$8440  56 49     LSR $49,X 
$8442  4E 47 20  LSR $2047 
$8445  45 52     EOR $52 
$8447            .byte $52,$4F,$52
$844A  20 20 00  JSR $0020
$844D  A2 01     LDX #$01
$844F  C9 53     CMP #$53
$8451  D0 01     BNE L_BRS_($8454)_($8451) OK
$8453  CA        DEX 
//------------------------------
L_BRS_($8454)_($8451) OK
//------------------------------
$8454  8E C5 1A  STX $1AC5 
$8457  20 8C 7E  JSR L_JSR_($7E8C)_($8457) OK
$845A  58        CLI 
$845B  AD DA 18  LDA $18DA 
$845E  C9 02     CMP #$02
$8460  90 03     BCC L_BRS_($8465)_($8460) OK
$8462  4C C7 05  JMP $05C7
//------------------------------
L_BRS_($8465)_($8460) OK
//------------------------------
$8465  20 1B 73  JSR L_JSR_($731B)_($8465) OK
$8468  A9 00     LDA #$00
$846A  8D 36 17  STA $1736 
$846D  8D 00 09  STA $0900 
$8470  20 12 CD  JSR L_JSR_($CD12)_($8470) OK	; TODO: sound effect stop?
$8473  78        SEI 
$8474  A9 37     LDA #$37
$8476  85 01     STA $01 
$8478  AD 2A 17  LDA $172A 
$847B  8D 12 04  STA $0412 
$847E  A9 20     LDA #$20
$8480  AE 3C 15  LDX $153C 
$8483  A0 00     LDY #$00
$8485  20 BA FF  JSR L_JSR_($FFBA)_($8485) JAM ; TODO:  $FFBA. SETLFS. Set file parameters. Input: A = Logical number; X = Device number; Y = Secondary address
$8488  A2 BC     LDX #$BC
$848A  A0 1A     LDY #$1A
$848C  A9 00     LDA #$00
$848E  8D 2A 17  STA $172A 
$8491  AD 3C 15  LDA $153C 
$8494  C9 08     CMP #$08
$8496  D0 12     BNE L_BRS_($84AA)_($8496) OK
$8498  AD C5 1A  LDA $1AC5 
$849B  D0 0D     BNE L_BRS_($84AA)_($849B) OK
$849D  A2 B9     LDX #$B9
$849F  A0 1A     LDY #$1A
$84A1  EE 2A 17  INC $172A 
$84A4  EE 2A 17  INC $172A 
$84A7  EE 2A 17  INC $172A 
//------------------------------
L_BRS_($84AA)_($8496) OK
L_BRS_($84AA)_($849B) OK
//------------------------------
$84AA  AD C5 1A  LDA $1AC5 
$84AD  F0 0C     BEQ L_BRS_($84BB)_($84AD) OK
$84AF  AD 3C 15  LDA $153C 
$84B2  C9 08     CMP #$08
$84B4  F0 05     BEQ L_BRS_($84BB)_($84B4) OK
$84B6  AD 12 04  LDA $0412 
$84B9  F0 02     BEQ L_BRS_($84BD)_($84B9) OK
//------------------------------
L_BRS_($84BB)_($84AD) OK
L_BRS_($84BB)_($84B4) OK
//------------------------------
$84BB  A9 08     LDA #$08
//------------------------------
L_BRS_($84BD)_($84B9) OK
//------------------------------
$84BD  18        CLC 
$84BE  6D 2A 17  ADC $172A 
$84C1  20 BD FF  JSR L_JSR_($FFBD)_($84C1) JAM	; TODO: $FFBD. SETNAM. Set file name parameters. Input: A = File name length; X/Y = Pointer to file name
$84C4  A9 35     LDA #$35
$84C6  85 01     STA $01 
$84C8  AD C5 1A  LDA $1AC5 
$84CB  F0 03     BEQ L_BRS_($84D0)_($84CB) OK
$84CD  4C 34 05  JMP $0534
//------------------------------
L_BRS_($84D0)_($84CB) OK
//------------------------------
$84D0  AD 8E 15  LDA $158E 
$84D3  85 7C     STA $7C 
$84D5  AD 8F 15  LDA $158F 
$84D8  85 7D     STA $7D 
$84DA  A2 76     LDX #$76
$84DC  A0 00     LDY #$00
//------------------------------
L_BRS_($84DE)_($84E5) OK
//------------------------------
$84DE  B9 2D 1C  LDA $1C2D,Y 
$84E1  91 7C     STA ($7C),Y 
$84E3  C8        INY 
$84E4  CA        DEX 
$84E5  D0 F7     BNE L_BRS_($84DE)_($84E5) OK
$84E7  A5 7C     LDA $7C 
$84E9  18        CLC 
$84EA  69 76     ADC #$76
$84EC  85 7C     STA $7C 
$84EE  90 02     BCC L_BRS_($84F2)_($84EE) OK
$84F0  E6 7D     INC $7D 
//------------------------------
L_BRS_($84F2)_($84EE) OK
//------------------------------
$84F2  20 DB 05  JSR $05DB
//------------------------------
L_BRS_($84F5)_($8504) OK
//------------------------------
$84F5  A2 00     LDX #$00
$84F7  A1 7E     LDA ($7E,X) 
$84F9  81 7C     STA ($7C,X) 
$84FB  E6 7C     INC $7C 
$84FD  D0 02     BNE L_BRS_($8501)_($84FD) OK
$84FF  E6 7D     INC $7D 
//------------------------------
L_BRS_($8501)_($84FD) OK
//------------------------------
$8501  20 14 06  JSR $0614
$8504  D0 EF     BNE L_BRS_($84F5)_($8504) OK
$8506  CE 10 04  DEC $0410 
$8509  F0 06     BEQ L_BRS_($8511)_($8509) OK
$850B  20 ED 05  JSR $05ED
//------------------------------
L_JSR_($8510)_($B84A) BAD
//------------------------------
$850E  4C F5 04  JMP $04F5
//------------------------------
L_BRS_($8511)_($8509) OK
//------------------------------
$8511  20 28 06  JSR $0628
$8514  A6 7C     LDX $7C 
$8516  A4 7D     LDY $7D 
$8518  AD 8E 15  LDA $158E 
$851B  85 2B     STA $2B 
$851D  AD 8F 15  LDA $158F 
$8520  85 2C     STA $2C 
$8522  A9 2B     LDA #$2B
$8524  20 D8 FF  JSR L_JSR_($FFD8)_($8524) JAM	; TODO: Save file
$8527  20 8C 7E  JSR L_JSR_($7E8C)_($8527) OK
$852A  20 AE 6B  JSR L_JSR_($6BAE)_($852A) OK
$852D  A9 35     LDA #$35
$852F  85 01     STA $01 
$8531  4C BE 05  JMP $05BE
$8534  20 28 06  JSR $0628
$8537  AE 8E 15  LDX $158E 
$853A  AC 8F 15  LDY $158F 
$853D  A9 00     LDA #$00
$853F  20 D5 FF  JSR L_JSR_($FFD5)_($853F) JAM	; TODO: load/verify file
$8542  08        PHP 
$8543  20 8C 7E  JSR L_JSR_($7E8C)_($8543) OK
$8546  20 AE 6B  JSR L_JSR_($6BAE)_($8546) OK
$8549  A9 35     LDA #$35
$854B  85 01     STA $01 
$854D  28        PLP 
$854E  B0 21     BCS L_BRS_($8571)_($854E) OK
$8550  AD 8E 15  LDA $158E 
$8553  85 7C     STA $7C 
$8555  AD 8F 15  LDA $158F 
$8558  85 7D     STA $7D 
$855A  A0 00     LDY #$00
$855C  B1 7C     LDA ($7C),Y 
$855E  C9 EA     CMP #$EA
$8560  F0 12     BEQ L_BRS_($8574)_($8560) OK
$8562  A2 14     LDX #$14
$8564  A0 04     LDY #$04
$8566  A9 AE     LDA #$AE
$8568  85 7C     STA $7C 
$856A  A9 96     LDA #$96
$856C  85 7D     STA $7D 
$856E  20 6C 68  JSR L_JSR_($686C)_($856E) OK
//------------------------------
L_BRS_($8571)_($854E) OK
//------------------------------
$8571  4C BE 05  JMP $05BE
//------------------------------
L_BRS_($8574)_($8560) OK
//------------------------------
$8574  A2 76     LDX #$76
$8576  A0 00     LDY #$00
//------------------------------
L_BRS_($8578)_($857F) OK
//------------------------------
$8578  B1 7C     LDA ($7C),Y 
$857A  99 2D 1C  STA $1C2D,Y 
$857D  C8        INY 
$857E  CA        DEX 
$857F  D0 F7     BNE L_BRS_($8578)_($857F) OK
$8581  A5 7C     LDA $7C 
$8583  18        CLC 
$8584  69 76     ADC #$76
$8586  85 7C     STA $7C 
$8588  90 02     BCC L_BRS_($858C)_($8588) OK
$858A  E6 7D     INC $7D 
//------------------------------
L_BRS_($858C)_($8588) OK
//------------------------------
$858C  20 DB 05  JSR $05DB
//------------------------------
L_BRS_($858F)_($859E) OK
//------------------------------
$858F  A2 00     LDX #$00
$8591  A1 7C     LDA ($7C,X) 
$8593  81 7E     STA ($7E,X) 
$8595  E6 7C     INC $7C 
$8597  D0 02     BNE L_BRS_($859B)_($8597) OK
$8599  E6 7D     INC $7D 
//------------------------------
L_BRS_($859B)_($8597) OK
//------------------------------
$859B  20 14 06  JSR $0614
$859E  D0 EF     BNE L_BRS_($858F)_($859E) OK
$85A0  CE 10 04  DEC $0410 
$85A3  F0 06     BEQ L_BRS_($85AB)_($85A3) OK
$85A5  20 ED 05  JSR $05ED
$85A8  4C 8F 05  JMP $058F
//------------------------------
L_BRS_($85AB)_($85A3) OK
//------------------------------
$85AB  AD 92 1C  LDA $1C92 
$85AE  29 FC     AND #$FC
$85B0  AE 91 1C  LDX $1C91 
$85B3  F0 02     BEQ L_BRS_($85B7)_($85B3) OK
$85B5  09 03     ORA #$03
//------------------------------
L_BRS_($85B7)_($85B3) OK
//------------------------------
$85B7  8D 92 1C  STA $1C92 
$85BA  A9 35     LDA #$35
$85BC  85 01     STA $01 
$85BE  AD 37 17  LDA $1737 
$85C1  8D 36 17  STA $1736 
$85C4  8D 00 09  STA $0900 
$85C7  A9 FD     LDA #$FD
$85C9  8D 43 15  STA $1543 
$85CC  A9 FF     LDA #$FF
$85CE  8D 44 15  STA $1544 
$85D1  58        CLI 
$85D2  A9 01     LDA #$01
$85D4  8D 4F 15  STA $154F 
$85D7  20 88 1F  JSR L_JSR_($1F88)_($85D7) OK
$85DA  60        RTS 
//------------------------------
$85DB  AD 8C 15  LDA $158C 
$85DE  85 7A     STA $7A 
$85E0  AD 8D 15  LDA $158D 
$85E3  85 7B     STA $7B 
$85E5  AD 78 15  LDA $1578 
$85E8  8D 10 04  STA $0410 
$85EB  A0 FF     LDY #$FF
$85ED  C8        INY 
$85EE  B1 7A     LDA ($7A),Y 
$85F0  18        CLC 
$85F1  6D 8A 15  ADC $158A 
$85F4  85 7E     STA $7E 
$85F6  C8        INY 
$85F7  B1 7A     LDA ($7A),Y 
$85F9  6D 8B 15  ADC $158B 
$85FC  85 7F     STA $7F 
$85FE  8C 13 04  STY $0413 
$8601  A0 01     LDY #$01
$8603  B1 7E     LDA ($7E),Y 
$8605  8D 11 04  STA $0411 
$8608  A9 0F     LDA #$0F
$860A  18        CLC 
$860B  65 7E     ADC $7E 
$860D  85 7E     STA $7E 
$860F  90 02     BCC L_BRS_($8613)_($860F) OK
$8611  E6 7F     INC $7F 
//------------------------------
L_BRS_($8613)_($860F) OK
//------------------------------
$8613  60        RTS 
//------------------------------
$8614  A0 08     LDY #$08
$8616  B1 7E     LDA ($7E),Y 
$8618  18        CLC 
$8619  65 7E     ADC $7E 
$861B  85 7E     STA $7E 
$861D  90 02     BCC L_BRS_($8621)_($861D) OK
$861F  E6 7F     INC $7F 
//------------------------------
L_BRS_($8621)_($861D) OK
//------------------------------
$8621  AC 13 04  LDY $0413 
$8624  CE 11 04  DEC $0411 
$8627  60        RTS 
//------------------------------
$8628  78        SEI 
$8629  A9 37     LDA #$37
$862B  85 01     STA $01 
$862D  A0 1F     LDY #$1F
//------------------------------
L_BRS_($862F)_($8636) OK
//------------------------------
$862F  B9 30 FD  LDA $FD30,Y                          // Kernal Reset Vectors
$8632  99 14 03  STA $0314,Y 
$8635  88        DEY 
$8636  10 F7     BPL L_BRS_($862F)_($8636) OK
$8638  A9 D1     LDA #$D1							; TODO: IRQ vectors
$863A  8D 26 03  STA $0326 
$863D  A9 7D     LDA #$7D
$863F  8D 27 03  STA $0327 
$8642  A9 B6     LDA #$B6
$8644  8D 18 03  STA $0318 
$8647  A9 6E     LDA #$6E
$8649  8D 19 03  STA $0319 
$864C  58        CLI 
$864D  A9 00     LDA #$00
$864F  8D 15 D0  STA $D015                          ; TODO: // Sprite display Enable
$8652  60        RTS 
//------------------------------
$8653  48        PHA 
$8654  8A        TXA 
$8655  48        PHA 
$8656  98        TYA 
$8657  48        PHA 
$8658  6C 14 03  JMP ($0314) 
$865B  20 20 20  JSR $2020
$865E  20 20 20  JSR $2020
$8661  20 20 20  JSR $2020
$8664  20 20 20  JSR $2020
$8667  20 20 20  JSR $2020
$866A  20 20 20  JSR $2020
$866D  20 20 20  JSR $2020
$8670  20 20 20  JSR $2020
$8673  20 20 20  JSR $2020
$8676  20 20 20  JSR $2020
$8679  20 20 20  JSR $2020
$867C  20 20 20  JSR $2020
$867F  20 20 20  JSR $2020
$8682  20 20 20  JSR $2020
$8685  20 20 20  JSR $2020
$8688  20 20 20  JSR $2020
$868B  20 20 20  JSR $2020
$868E  20 20 20  JSR $2020
$8691  20 20 20  JSR $2020
$8694  20 20 20  JSR $2020
$8697  20 20 20  JSR $2020
$869A  20 20 20  JSR $2020
$869D  20 20 20  JSR $2020
$86A0  20 20 20  JSR $2020
$86A3  20 20 20  JSR $2020
$86A6  20 20 20  JSR $2020
$86A9  20 20 20  JSR $2020
$86AC  20 20 20  JSR $2020
$86AF  20 20 20  JSR $2020
$86B2  20 20 20  JSR $2020
$86B5  20 20 20  JSR $2020
$86B8  20 20 20  JSR $2020
$86BB  20 20 20  JSR $2020
$86BE  20 20 20  JSR $2020
$86C1  20 20 20  JSR $2020
$86C4  20 20 20  JSR $2020
$86C7  20 20 20  JSR $2020
$86CA  20 20 20  JSR $2020
$86CD  20 20 20  JSR $2020
$86D0  20 20 20  JSR $2020
$86D3  20 20 20  JSR $2020
$86D6  20 20 20  JSR $2020
$86D9  20 20 20  JSR $2020
$86DC  20 20 20  JSR $2020
$86DF  20 20 20  JSR $2020
$86E2  20 20 20  JSR $2020
$86E5  20 20 20  JSR $2020
$86E8  20 20 20  JSR $2020
$86EB  20 20 20  JSR $2020
$86EE  20 20 20  JSR $2020
$86F1  20 20 20  JSR $2020
$86F4  20 20 20  JSR $2020
$86F7  20 20 20  JSR $2020
$86FA  20 20 20  JSR $2020
$86FD  20 20 20  JSR $2020
$8700  20 20 20  JSR $2020
$8703  20 20 20  JSR $2020
$8706  20 20 20  JSR $2020
$8709  20 20 20  JSR $2020
$870C  20 20 20  JSR $2020
$870F  20 20 20  JSR $2020
$8712  20 20 20  JSR $2020
$8715  20 20 20  JSR $2020
$8718  20 20 20  JSR $2020
$871B  20 20 20  JSR $2020
$871E  20 20 20  JSR $2020
$8721  20 20 20  JSR $2020
$8724  20 20 20  JSR $2020
$8727  20 20 20  JSR $2020
$872A  20 20 20  JSR $2020
$872D  20 20 20  JSR $2020
$8730  20 20 20  JSR $2020
$8733  20 20 20  JSR $2020
$8736  20 20 20  JSR $2020
$8739  20 20 20  JSR $2020
$873C  20 20 20  JSR $2020
$873F  20 20 20  JSR $2020
$8742  20 20 20  JSR $2020
$8745  20 20 20  JSR $2020
$8748  20 20 20  JSR $2020
$874B  20 20 20  JSR $2020
$874E  20 20 20  JSR $2020
$8751  20 20 20  JSR $2020
$8754  20 20 20  JSR $2020
$8757  20 20 20  JSR $2020
$875A  20 20 20  JSR $2020
$875D  20 20 20  JSR $2020
$8760  20 20 20  JSR $2020
$8763  20 20 20  JSR $2020
$8766  20 20 20  JSR $2020
$8769  20 20 20  JSR $2020
$876C  20 20 20  JSR $2020
$876F  20 20 20  JSR $2020
$8772  20 20 20  JSR $2020
$8775  20 20 20  JSR $2020
$8778  20 20 20  JSR $2020
$877B  20 20 20  JSR $2020
$877E  20 20 20  JSR $2020
$8781  20 20 20  JSR $2020
$8784  20 20 20  JSR $2020
$8787  20 20 20  JSR $2020
$878A  20 20 20  JSR $2020
$878D  20 20 20  JSR $2020
$8790  20 20 20  JSR $2020
$8793  20 20 20  JSR $2020
$8796  20 20 20  JSR $2020
$8799  20 20 20  JSR $2020
$879C  20 20 20  JSR $2020
$879F  20 20 20  JSR $2020
$87A2  20 20 20  JSR $2020
$87A5  20 20 20  JSR $2020
$87A8  20 20 20  JSR $2020
$87AB  20 20 20  JSR $2020
$87AE  20 20 20  JSR $2020
$87B1  20 20 20  JSR $2020
$87B4  20 20 20  JSR $2020
$87B7  20 20 20  JSR $2020
$87BA  20 20 20  JSR $2020
$87BD  20 20 20  JSR $2020
$87C0  20 20 20  JSR $2020
$87C3  20 20 20  JSR $2020
$87C6  20 20 20  JSR $2020
$87C9  20 20 20  JSR $2020
$87CC  20 20 20  JSR $2020
$87CF  20 20 20  JSR $2020
$87D2  20 20 20  JSR $2020
$87D5  20 20 20  JSR $2020
//------------------------------
L_BRS_($87D9)_($8807) BAD
//------------------------------
$87D8  20 20 20  JSR $2020
$87DB  20 20 20  JSR $2020
$87DE  20 20 20  JSR $2020
$87E1  20 20 20  JSR $2020
$87E4  20 20 20  JSR $2020
$87E7  20 20 20  JSR $2020
$87EA  20 20 20  JSR $2020
$87ED  20 20 20  JSR $2020
$87F0  20 20 20  JSR $2020
$87F3  20 20 20  JSR $2020
$87F6  20 20 20  JSR $2020
$87F9  20 20 20  JSR $2020
$87FC  20 20 20  JSR $2020
//------------------------------
L_JMP_($8800)_($8AFC) BAD
L_JSR_($8800)_($C1DA) BAD
//------------------------------
$87FF  20 78 A9  JSR L_JSR_($A978)_($87FF) OK
$8802  35 85     AND $85,X 
$8804  01 AD     ORA ($AD,X)
$8806            .byte $12
$8807  D0 D0     BNE L_BRS_($87D9)_($8807) BAD
$8809            .byte $FB
$880A  8D 11 D0  STA $D011                          ; TODO: print ornaments on left/right // Control Register 1
$880D  A9 C0     LDA #$C0
$880F  85 02     STA $02 
$8811  A9 E3     LDA #$E3
$8813  85 03     STA $03 
$8815  A9 E0     LDA #$E0
$8817  85 04     STA $04 
$8819  A9 E4     LDA #$E4
$881B  85 05     STA $05 
$881D  A9 00     LDA #$00
$881F  85 FC     STA $FC 
$8821  A9 E5     LDA #$E5
$8823  85 FD     STA $FD 
$8825  A9 20     LDA #$20
$8827  85 FE     STA $FE 
$8829  A9 E6     LDA #$E6
$882B  85 FF     STA $FF 
$882D  A2 11     LDX #$11
//------------------------------
L_BRS_($882F)_($8857) OK
//------------------------------
$882F  A0 1F     LDY #$1F
//------------------------------
L_BRS_($8831)_($883A) OK
//------------------------------
$8831  B1 02     LDA ($02),Y 
$8833  91 FC     STA ($FC),Y 
$8835  B1 04     LDA ($04),Y 
$8837  91 FE     STA ($FE),Y 
$8839  88        DEY 
$883A  10 F5     BPL L_BRS_($8831)_($883A) OK
$883C  A5 FC     LDA $FC 
$883E  18        CLC 
$883F  69 40     ADC #$40
$8841  85 FC     STA $FC 
$8843  A5 FD     LDA $FD 
$8845  69 01     ADC #$01
$8847  85 FD     STA $FD 
$8849  A5 FE     LDA $FE 
$884B  18        CLC 
$884C  69 40     ADC #$40
$884E  85 FE     STA $FE 
$8850  A5 FF     LDA $FF 
$8852  69 01     ADC #$01
$8854  85 FF     STA $FF 
$8856  CA        DEX 
$8857  10 D6     BPL L_BRS_($882F)_($8857) OK
$8859  A2 00     LDX #$00
//------------------------------
L_BRS_($885B)_($888C) OK
//------------------------------
$885B  BD 00 80  LDA $8000,X 
$885E  9D 00 D8  STA $D800,X 
$8861  BD 00 81  LDA $8100,X 
$8864  9D 00 D9  STA $D900,X 
$8867  BD 00 82  LDA $8200,X 
$886A  9D 00 DA  STA $DA00,X 
$886D  BD 00 83  LDA $8300,X 
$8870  9D 00 DB  STA $DB00,X 
$8873  BD 00 84  LDA $8400,X 
$8876  9D 00 04  STA $0400,X 
$8879  BD 00 85  LDA $8500,X 
$887C  9D 00 05  STA $0500,X 
$887F  BD 00 86  LDA $8600,X 
$8882  9D 00 06  STA $0600,X 
$8885  BD 00 87  LDA $8700,X 
$8888  9D 00 07  STA $0700,X 
$888B  E8        INX 
$888C  D0 CD     BNE L_BRS_($885B)_($888C) OK
$888E  A5 BA     LDA $BA 
$8890  8D 4D 73  STA $734D 
$8893  8D 95 84  STA $8495 
$8896  8D B3 84  STA $84B3 
$8899  4C 4C 40  JMP L_JMP_($404C)_($8899) OK
$889C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88A4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88AC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88B4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88BC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88C4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88CC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88D4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88DC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88E4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88EC            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88F4            .byte $00,$00,$00,$00,$00,$00,$00,$00
$88FC            .byte $00,$00,$00,$00
$8900  AD 0D DC  LDA $DC0D                          // Interrupt (IRQ) Control Register
$8903  AD 0D DD  LDA $DD0D                          // Interrupt (NMI) Control Register
$8906  58        CLI 
$8907  A9 00     LDA #$00
$8909  8D 20 D0  STA $D020                          // Border Color
$890C  8D 21 D0  STA $D021                          // Background Color 0
$890F  A9 08     LDA #$08
$8911  8D 16 D0  STA $D016                          // Control Register 2
$8914  20 D2 FF  JSR L_JSR_($FFD2)_($8914) JAM		; TODO:  $FFD2. CHROUT. Write byte to default output. (If not screen, must call OPEN and CHKOUT beforehands.)
$8917  A9 16     LDA #$16
$8919  8D 18 D0  STA $D018                          // Memory Control Register
$891C  A2 00     LDX #$00
//------------------------------
L_BRS_($891E)_($893B) OK
//------------------------------
$891E  A9 20     LDA #$20
$8920  9D 00 04  STA $0400,X 
$8923  9D 00 05  STA $0500,X 
$8926  9D 00 06  STA $0600,X 
$8929  9D E8 06  STA $06E8,X 
$892C  A9 05     LDA #$05
$892E  9D 00 D8  STA $D800,X 
$8931  9D 00 D9  STA $D900,X 
$8934  9D 00 DA  STA $DA00,X 
$8937  9D E8 DA  STA $DAE8,X 
$893A  E8        INX 
$893B  D0 E1     BNE L_BRS_($891E)_($893B) OK
$893D  A2 27     LDX #$27
//------------------------------
L_BRS_($893F)_($894B) OK
//------------------------------
$893F  BD AA 89  LDA $89AA,X 
$8942  9D 00 04  STA $0400,X 
$8945  A9 01     LDA #$01
$8947  9D 00 D8  STA $D800,X 
$894A  CA        DEX 
$894B  10 F2     BPL L_BRS_($893F)_($894B) OK
$894D  A9 00     LDA #$00
$894F  85 FA     STA $FA 
//------------------------------
L_JMP_($8951)_($8960) OK
//------------------------------
$8951  20 D2 89  JSR L_JSR_($89D2)_($8951) BAD
//------------------------------
L_BRS_($8954)_($8957) OK
//------------------------------
$8954  20 E4 FF  JSR L_JSR_($FFE4)_($8954) JAM	; $FFE4. GETIN. Read byte from default input. (If not keyboard, must call OPEN )
$8957  F0 FB     BEQ L_BRS_($8954)_($8957) OK
$8959  C9 20     CMP #$20
$895B  F0 06     BEQ L_BRS_($8963)_($895B) OK
$895D  20 61 8A  JSR L_JSR_($8A61)_($895D) OK
$8960  4C 51 89  JMP L_JMP_($8951)_($8960) OK
//------------------------------
L_BRS_($8963)_($895B) OK
//------------------------------
$8963  4C E0 8A  JMP L_JMP_($8AE0)_($8963) OK
$8966            .byte $00,$00,$00,$00,$00
$896B  59 45 53  EOR $5345,Y 
$896E  4E 4F 20  LSR $204F 
$8971            .byte $57,$52
$8973  49 53     EOR #$53
$8975            .byte $54
$8976  20 57 41  JSR L_JSR_($4157)_($8976) BAD
$8979            .byte $54,$43
$897B  48        PHA 
$897C  20 43 48  JSR L_JSR_($4843)_($897C) OK
$897F  45 41     EOR $41 
$8981            .byte $D4,$57
$8983  41 54     EOR ($54,X) 
$8985  45 52     EOR $52 
$8987  20 42 4F  JSR L_JSR_($4F42)_($8987) OK
$898A            .byte $54,$54
$898C  4C 45 20  JMP L_JMP_($2045)_($898C) OK
$898F            .byte $43
$8990  48        PHA 
$8991  45 41     EOR $41 
$8993            .byte $D4
$8994  48        PHA 
$8995  45 41     EOR $41 
$8997            .byte $52,$54
$8999  20 43 48  JSR L_JSR_($4843)_($8999) OK
$899C  45 41     EOR $41 
$899E            .byte $D4
$899F  46 41     LSR $41 
$89A1  4C 4C 20  JMP L_JMP_($204C)_($89A1) BAD
$89A4            .byte $43
$89A5  48        PHA 
$89A6  45 41     EOR $41 
$89A8            .byte $D4,$00
$89AA  20 20 20  JSR $2020
$89AD  20 20 20  JSR $2020
$89B0  20 20 20  JSR $2020
$89B3            .byte $54,$4F,$54
$89B6  41 4C     EOR ($4C,X) 
$89B8  20 45 43  JSR L_JSR_($4345)_($89B8) BAD
$89BB  4C 49 50  JMP L_JMP_($5049)_($89BB) BAD
$89BE            .byte $53
$89BF  45 20     EOR $20 
$89C1            .byte $54,$52
$89C3  41 49     EOR ($49,X) 
$89C5  4E 45 52  LSR $5245 
$89C8  20 20 20  JSR $2020
$89CB  20 20 20  JSR $2020
$89CE  20 20 20  JSR $2020
//------------------------------
L_JSR_($89D2)_($8951) BAD
//------------------------------
$89D1  20 A2 71  JSR L_JSR_($71A2)_($89D1) JAM
$89D4  A0 89     LDY #$89
$89D6  86 FC     STX $FC 
$89D8  84 FD     STY $FD 
$89DA  A2 5F     LDX #$5F
$89DC  A0 04     LDY #$04
$89DE  86 FE     STX $FE 
$89E0  84 FF     STY $FF 
$89E2  A2 00     LDX #$00
//------------------------------
L_JMP_($89E4)_($8A52) OK
//------------------------------
$89E4  E4 FA     CPX $FA 
$89E6  D0 03     BNE L_BRS_($89EB)_($89E6) BAD
$89E8  A9 80     LDA #$80
//------------------------------
L_BRS_($89EB)_($89E6) BAD
//------------------------------
$89EA  2C A9 00  BIT $00A9 
$89ED  85 FB     STA $FB 
$89EF  A0 00     LDY #$00
//------------------------------
L_BRS_($89F1)_($89FE) OK
//------------------------------
$89F1  B1 FC     LDA ($FC),Y 
$89F3  F0 0B     BEQ L_BRS_($8A00)_($89F3) OK
$89F5  C9 C0     CMP #$C0
$89F7  B0 44     BCS L_BRS_($8A3D)_($89F7) OK
$89F9  45 FB     EOR $FB 
$89FB  91 FE     STA ($FE),Y 
$89FD  C8        INY 
$89FE  D0 F1     BNE L_BRS_($89F1)_($89FE) OK
//------------------------------
L_BRS_($8A00)_($89F3) OK
//------------------------------
$8A00  86 F9     STX $F9 
$8A02  A2 5B     LDX #$5B
$8A04  A0 04     LDY #$04
$8A06  86 FE     STX $FE 
$8A08  84 FF     STY $FF 
$8A0A  A2 00     LDX #$00
//------------------------------
L_BRS_($8A0C)_($8A33) OK
//------------------------------
$8A0C  A0 02     LDY #$02
//------------------------------
L_BRS_($8A0E)_($8A2B) OK
//------------------------------
$8A0E  BD 66 89  LDA $8966,X 
$8A11  D0 03     BNE L_BRS_($8A16)_($8A11) BAD
$8A13  A9 6E     LDA #$6E
//------------------------------
L_BRS_($8A16)_($8A11) BAD
//------------------------------
$8A15  2C A9 6B  BIT $6BA9 
$8A18  8D 1C 8A  STA $8A1C 
$8A1B  B9 6E 89  LDA $896E,Y 
$8A1E  91 FE     STA ($FE),Y 
$8A20  20 36 8A  JSR L_JSR_($8A36)_($8A20) OK
$8A23  A9 0F     LDA #$0F
$8A25  91 FE     STA ($FE),Y 
$8A27  20 36 8A  JSR L_JSR_($8A36)_($8A27) OK
$8A2A  88        DEY 
$8A2B  10 E1     BPL L_BRS_($8A0E)_($8A2B) OK
$8A2D  20 55 8A  JSR L_JSR_($8A55)_($8A2D) OK
$8A30  E8        INX 
$8A31  E4 F9     CPX $F9 
$8A33  D0 D7     BNE L_BRS_($8A0C)_($8A33) OK
$8A35  60        RTS 
//------------------------------
L_JSR_($8A36)_($8A20) OK
L_JSR_($8A36)_($8A27) OK
//------------------------------
$8A36  A5 FF     LDA $FF 
$8A38  49 DC     EOR #$DC
$8A3A  85 FF     STA $FF 
$8A3C  60        RTS 
//------------------------------
L_BRS_($8A3D)_($89F7) OK
//------------------------------
$8A3D  49 80     EOR #$80
$8A3F  45 FB     EOR $FB 
$8A41  91 FE     STA ($FE),Y 
$8A43  C8        INY 
$8A44  98        TYA 
$8A45  18        CLC 
$8A46  65 FC     ADC $FC 
$8A48  90 02     BCC L_BRS_($8A4C)_($8A48) OK
$8A4A  E6 FD     INC $FD 
//------------------------------
L_BRS_($8A4C)_($8A48) OK
//------------------------------
$8A4C  85 FC     STA $FC 
$8A4E  20 55 8A  JSR L_JSR_($8A55)_($8A4E) OK
$8A51  E8        INX 
$8A52  4C E4 89  JMP L_JMP_($89E4)_($8A52) OK
//------------------------------
L_JSR_($8A55)_($8A2D) OK
L_JSR_($8A55)_($8A4E) OK
//------------------------------
$8A55  A5 FE     LDA $FE 
$8A57  18        CLC 
$8A58  69 28     ADC #$28
$8A5A  90 02     BCC L_BRS_($8A5E)_($8A5A) OK
$8A5C  E6 FF     INC $FF 
//------------------------------
L_BRS_($8A5E)_($8A5A) OK
//------------------------------
$8A5E  85 FE     STA $FE 
$8A60  60        RTS 
//------------------------------
L_JSR_($8A61)_($895D) OK
//------------------------------
$8A61  A6 FA     LDX $FA 
$8A63  C9 11     CMP #$11
$8A65  D0 08     BNE L_BRS_($8A6F)_($8A65) OK
$8A67  E8        INX 
$8A68  E4 F9     CPX $F9 
$8A6A  F0 02     BEQ L_BRS_($8A6E)_($8A6A) OK
$8A6C  E6 FA     INC $FA 
//------------------------------
L_BRS_($8A6E)_($8A6A) OK
//------------------------------
$8A6E  60        RTS 
//------------------------------
L_BRS_($8A6F)_($8A65) OK
//------------------------------
$8A6F  C9 91     CMP #$91
$8A71  D0 07     BNE L_BRS_($8A7A)_($8A71) OK
$8A73  A5 FA     LDA $FA 
$8A75  F0 02     BEQ L_BRS_($8A79)_($8A75) OK
$8A77  C6 FA     DEC $FA 
//------------------------------
L_BRS_($8A79)_($8A75) OK
//------------------------------
$8A79  60        RTS 
//------------------------------
L_BRS_($8A7A)_($8A71) OK
//------------------------------
$8A7A  C9 0D     CMP #$0D
$8A7C  F0 01     BEQ L_BRS_($8A7F)_($8A7C) OK
$8A7E  60        RTS 
//------------------------------
L_BRS_($8A7F)_($8A7C) OK
//------------------------------
$8A7F  A5 FA     LDA $FA 
$8A81  0A        ASL A 
$8A82  A8        TAY 
$8A83  B9 90 8A  LDA $8A90,Y 
$8A86  85 FE     STA $FE 
$8A88  B9 91 8A  LDA $8A91,Y 
$8A8B  85 FF     STA $FF 
$8A8D  6C FE 00  JMP ($00FE) 
$8A90  98        TYA 
$8A91  8A        TXA 
$8A92  A6 8A     LDX $8A 
$8A94  B4 8A     LDY $8A,X 
$8A96  C9 8A     CMP #$8A
$8A98  20 D7 8A  JSR L_JSR_($8AD7)_($8A98) OK
$8A9B  F0 03     BEQ L_BRS_($8AA0)_($8A9B) BAD
$8A9D  A9 AD     LDA #$AD
//------------------------------
L_BRS_($8AA0)_($8A9B) BAD
//------------------------------
$8A9F  2C A9 EE  BIT $EEA9                          // Get Serial Data And Clock In
$8AA2  8D E1 8A  STA $8AE1 
$8AA5  60        RTS 
//------------------------------
$8AA6  20 D7 8A  JSR L_JSR_($8AD7)_($8AA6) OK
$8AA9  F0 03     BEQ L_BRS_($8AAE)_($8AA9) BAD
$8AAB  A9 AD     LDA #$AD
//------------------------------
L_BRS_($8AAE)_($8AA9) BAD
//------------------------------
$8AAD  2C A9 CE  BIT $CEA9 
$8AB0  8D E6 8A  STA $8AE6 
$8AB3  60        RTS 
//------------------------------
$8AB4  20 D7 8A  JSR L_JSR_($8AD7)_($8AB4) OK
$8AB7  F0 05     BEQ L_BRS_($8ABE)_($8AB7) OK
$8AB9  A9 AD     LDA #$AD
$8ABB  AA        TAX 
$8ABC  D0 04     BNE L_BRS_($8AC2)_($8ABC) OK
//------------------------------
L_BRS_($8ABE)_($8AB7) OK
//------------------------------
$8ABE  A9 8D     LDA #$8D
$8AC0  A2 CE     LDX #$CE
//------------------------------
L_BRS_($8AC2)_($8ABC) OK
//------------------------------
$8AC2  8D EB 8A  STA $8AEB 
$8AC5  8E F0 8A  STX $8AF0 
$8AC8  60        RTS 
//------------------------------
$8AC9  20 D7 8A  JSR L_JSR_($8AD7)_($8AC9) OK
$8ACC  F0 03     BEQ L_BRS_($8AD1)_($8ACC) BAD
$8ACE  A9 00     LDA #$00
//------------------------------
L_BRS_($8AD1)_($8ACC) BAD
//------------------------------
$8AD0  2C A9 0F  BIT $0FA9 
$8AD3  8D F8 8A  STA $8AF8 
$8AD6  60        RTS 
//------------------------------
L_JSR_($8AD7)_($8A98) OK
L_JSR_($8AD7)_($8AA6) OK
L_JSR_($8AD7)_($8AB4) OK
L_JSR_($8AD7)_($8AC9) OK
//------------------------------
$8AD7  BD 66 89  LDA $8966,X 
$8ADA  49 01     EOR #$01
$8ADC  9D 66 89  STA $8966,X 
$8ADF  60        RTS 
//------------------------------
L_JMP_($8AE0)_($8963) OK
//------------------------------
$8AE0  A9 EE     LDA #$EE
$8AE2  8D D7 6C  STA $6CD7 
$8AE5  A9 CE     LDA #$CE
$8AE7  8D AE 6C  STA $6CAE 
$8AEA  A9 8D     LDA #$8D
$8AEC  8D D0 63  STA $63D0 
$8AEF  A9 CE     LDA #$CE
$8AF1  8D 9C 6C  STA $6C9C 
$8AF4  8D 63 6E  STA $6E63 
$8AF7  A9 0F     LDA #$0F
$8AF9  8D 31 79  STA $7931 
$8AFC  4C 00 88  JMP L_JMP_($8800)_($8AFC) BAD
$8AFF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B07            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B0F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B17            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B1F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B27            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B3F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B47            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B5F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B67            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B7F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B87            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B8F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8B9F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BA7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BAF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BB7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BCF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BD7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BDF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BE7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BEF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BF7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8BFF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C07            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C0F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C17            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C1F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C27            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C3F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C47            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C5F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C67            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C7F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C87            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C8F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8C9F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CA7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CAF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CB7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CCF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CD7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CDF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CE7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CEF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CF7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8CFF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D07            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D0F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D17            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D1F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D27            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D3F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D47            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D5F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D67            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D7F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D87            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D8F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8D9F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DA7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DAF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DB7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DCF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DD7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DDF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DE7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DEF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DF7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8DFF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E07            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E0F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E17            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E1F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E27            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E3F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E47            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E5F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E67            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E7F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E87            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E8F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8E9F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EA7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EAF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EB7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8ECF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8ED7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EDF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EE7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EEF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EF7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8EFF            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($8F07)_($B15B) JAM
L_JSR_($8F08)_($BE90) JAM
//------------------------------
$8F07            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F0F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F17            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F1F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F27            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F2F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F37            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F3F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F47            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F5F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F67            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F6F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F77            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F7F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F87            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F8F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8F9F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FA7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FAF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FB7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FCF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FD7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FDF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FE7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FEF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FF7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$8FFF            .byte $00
$9000  78        SEI 
$9001  48        PHA 
$9002  08        PHP 
$9003  A9 08     LDA #$08
$9005  8D 84 91  STA $9184 
$9008  A5 01     LDA $01 
$900A  48        PHA 
$900B  A9 25     LDA #$25
$900D  85 01     STA $01 
$900F  A9 3B     LDA #$3B
$9011  8D 02 DD  STA $DD02                          // Data Direction Register A
$9014  A9 00     LDA #$00
$9016  8D 03 DD  STA $DD03                          // Data Direction Register B
$9019  68        PLA 
$901A  85 01     STA $01 
$901C  28        PLP 
$901D  68        PLA 
//------------------------------
L_JMP_($901E)_($917D) OK
//------------------------------
$901E  08        PHP 
$901F  8D C3 91  STA $91C3 
$9022  68        PLA 
$9023  8D C2 91  STA $91C2 
$9026  8E C4 91  STX $91C4 
$9029  8C C5 91  STY $91C5 
$902C  BA        TSX 
$902D  8E C6 91  STX $91C6 
$9030  BD 01 01  LDA $0101,X 
$9033  8D C8 91  STA $91C8 
$9036  BD 02 01  LDA $0102,X 
$9039  8D C7 91  STA $91C7 
$903C  A5 01     LDA $01 
$903E  8D C9 91  STA $91C9 
$9041  A9 25     LDA #$25
$9043  85 01     STA $01 
//------------------------------
L_BRS_($9045)_($9080) OK
L_JMP_($9045)_($910D) OK
L_JMP_($9045)_($911A) OK
//------------------------------
$9045  20 80 91  JSR L_JSR_($9180)_($9045) OK
$9048  C9 B5     CMP #$B5
$904A  D0 14     BNE L_BRS_($9060)_($904A) OK
$904C  20 80 91  JSR L_JSR_($9180)_($904C) OK
$904F  8D 7C 91  STA $917C 
$9052  20 80 91  JSR L_JSR_($9180)_($9052) OK
$9055  8D 7B 91  STA $917B 
$9058  A9 20     LDA #$20
$905A  8D 7A 91  STA $917A 
$905D  4C 63 91  JMP L_JMP_($9163)_($905D) OK
//------------------------------
L_BRS_($9060)_($904A) OK
//------------------------------
$9060  C9 B4     CMP #$B4
$9062  D0 3C     BNE L_BRS_($90A0)_($9062) OK
$9064  20 80 91  JSR L_JSR_($9180)_($9064) OK
$9067  8D 92 90  STA $9092 
$906A  20 80 91  JSR L_JSR_($9180)_($906A) OK
$906D  A8        TAY 
$906E  20 80 91  JSR L_JSR_($9180)_($906E) OK
$9071  8D 7F 90  STA $907F 
$9074  20 80 91  JSR L_JSR_($9180)_($9074) OK
$9077  8D 7B 90  STA $907B 
//------------------------------
L_BRS_($907A)_($9098) OK
L_JMP_($907A)_($909D) OK
L_JMP_($907A)_($914A) OK
//------------------------------
$907A  A9 00     LDA #$00
$907C  D0 07     BNE L_BRS_($9085)_($907C) OK
$907E  A9 00     LDA #$00
$9080  F0 C3     BEQ L_BRS_($9045)_($9080) OK
$9082  CE 7F 90  DEC $907F 
//------------------------------
L_BRS_($9085)_($907C) OK
//------------------------------
$9085  CE 7B 90  DEC $907B 
$9088  20 80 91  JSR L_JSR_($9180)_($9088) OK
$908B  AE C9 91  LDX $91C9 
$908E  86 01     STX $01 
$9090  99 00 FF  STA $FF00,Y 
$9093  A9 25     LDA #$25
$9095  85 01     STA $01 
$9097  C8        INY 
$9098  D0 E0     BNE L_BRS_($907A)_($9098) OK
$909A  EE 92 90  INC $9092 
$909D  4C 7A 90  JMP L_JMP_($907A)_($909D) OK
//------------------------------
L_BRS_($90A0)_($9062) OK
//------------------------------
$90A0  C9 B6     CMP #$B6
$90A2  D0 6C     BNE L_BRS_($9110)_($90A2) OK
$90A4  20 80 91  JSR L_JSR_($9180)_($90A4) OK
$90A7  8D E6 90  STA $90E6 
$90AA  20 80 91  JSR L_JSR_($9180)_($90AA) OK
$90AD  A8        TAY 
$90AE  20 80 91  JSR L_JSR_($9180)_($90AE) OK
$90B1  8D D6 90  STA $90D6 
$90B4  20 80 91  JSR L_JSR_($9180)_($90B4) OK
$90B7  8D D2 90  STA $90D2 
//------------------------------
L_BRS_($90BA)_($90C2) OK
L_JMP_($90BA)_($9132) OK
//------------------------------
$90BA  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$90BD  4D 84 91  EOR $9184 
$90C0  29 04     AND #$04
$90C2  D0 F6     BNE L_BRS_($90BA)_($90C2) OK
$90C4  A9 FF     LDA #$FF
$90C6  8D 03 DD  STA $DD03                          // Data Direction Register B
$90C9  AD 84 91  LDA $9184 
$90CC  49 04     EOR #$04
$90CE  8D 84 91  STA $9184 
//------------------------------
L_BRS_($90D1)_($90EF) OK
L_JMP_($90D1)_($90F4) OK
//------------------------------
$90D1  A9 01     LDA #$01
$90D3  D0 07     BNE L_BRS_($90DC)_($90D3) OK
$90D5  A9 01     LDA #$01
$90D7  F0 1E     BEQ L_BRS_($90F7)_($90D7) OK
$90D9  CE D6 90  DEC $90D6 
//------------------------------
L_BRS_($90DC)_($90D3) OK
//------------------------------
$90DC  CE D2 90  DEC $90D2 
$90DF  AD C9 91  LDA $91C9 
$90E2  85 01     STA $01 
$90E4  B9 00 01  LDA $0100,Y 
$90E7  A2 25     LDX #$25
$90E9  86 01     STX $01 
$90EB  20 A1 91  JSR L_JSR_($91A1)_($90EB) OK
$90EE  C8        INY 
$90EF  D0 E0     BNE L_BRS_($90D1)_($90EF) OK
$90F1  EE E6 90  INC $90E6 
$90F4  4C D1 90  JMP L_JMP_($90D1)_($90F4) OK
//------------------------------
L_BRS_($90F7)_($90D7) OK
//------------------------------
$90F7  8D 03 DD  STA $DD03                          // Data Direction Register B
$90FA  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$90FD  29 F3     AND #$F3
$90FF  0D 84 91  ORA $9184
$9102  8D 00 DD  STA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$9105  AD 84 91  LDA $9184 
$9108  49 08     EOR #$08
$910A  8D 84 91  STA $9184 
$910D  4C 45 90  JMP L_JMP_($9045)_($910D) OK
//------------------------------
L_BRS_($9110)_($90A2) OK
//------------------------------
$9110  C9 B7     CMP #$B7
$9112  D0 09     BNE L_BRS_($911D)_($9112) OK
$9114  20 80 91  JSR L_JSR_($9180)_($9114) OK
$9117  8D C9 91  STA $91C9 
//------------------------------
L_BRS_($911A)_($914F) OK
//------------------------------
$911A  4C 45 90  JMP L_JMP_($9045)_($911A) OK
//------------------------------
L_BRS_($911D)_($9112) OK
//------------------------------
$911D  C9 B8     CMP #$B8
$911F  D0 14     BNE L_BRS_($9135)_($911F) OK
$9121  A0 C2     LDY #$C2
$9123  A9 91     LDA #$91
$9125  8D E6 90  STA $90E6 
$9128  A9 07     LDA #$07
$912A  8D D2 90  STA $90D2 
$912D  A9 00     LDA #$00
$912F  8D D6 90  STA $90D6 
$9132  4C BA 90  JMP L_JMP_($90BA)_($9132) OK
//------------------------------
L_BRS_($9135)_($911F) OK
//------------------------------
$9135  C9 B9     CMP #$B9
$9137  D0 14     BNE L_BRS_($914D)_($9137) OK
$9139  A0 C2     LDY #$C2
$913B  A9 91     LDA #$91
$913D  8D 92 90  STA $9092 
$9140  A9 07     LDA #$07
$9142  8D 7B 90  STA $907B 
$9145  A9 00     LDA #$00
$9147  8D 7F 90  STA $907F 
$914A  4C 7A 90  JMP L_JMP_($907A)_($914A) OK
//------------------------------
L_BRS_($914D)_($9137) OK
//------------------------------
$914D  C9 BA     CMP #$BA
$914F  D0 C9     BNE L_BRS_($911A)_($914F) OK
$9151  20 80 91  JSR L_JSR_($9180)_($9151) OK
$9154  8D 7A 91  STA $917A 
$9157  20 80 91  JSR L_JSR_($9180)_($9157) OK
$915A  8D 7B 91  STA $917B 
$915D  20 80 91  JSR L_JSR_($9180)_($915D) OK
$9160  8D 7C 91  STA $917C 
//------------------------------
L_JMP_($9163)_($905D) OK
//------------------------------
$9163  AD C9 91  LDA $91C9 
$9166  85 01     STA $01 
$9168  AE C6 91  LDX $91C6 
$916B  9A        TXS 
$916C  AC C5 91  LDY $91C5 
$916F  AE C4 91  LDX $91C4 
$9172  AD C2 91  LDA $91C2 
$9175  48        PHA 
$9176  AD C3 91  LDA $91C3 
$9179  28        PLP 
$917A  20 4C 40  JSR L_JSR_($404C)_($917A) OK
$917D  4C 1E 90  JMP L_JMP_($901E)_($917D) OK
//------------------------------
L_JSR_($9180)_($9045) OK
L_JSR_($9180)_($904C) OK
L_JSR_($9180)_($9052) OK
L_JSR_($9180)_($9064) OK
L_JSR_($9180)_($906A) OK
L_JSR_($9180)_($906E) OK
L_JSR_($9180)_($9074) OK
L_JSR_($9180)_($9088) OK
L_JSR_($9180)_($90A4) OK
L_JSR_($9180)_($90AA) OK
L_JSR_($9180)_($90AE) OK
L_JSR_($9180)_($90B4) OK
L_JSR_($9180)_($9114) OK
L_JSR_($9180)_($9151) OK
L_JSR_($9180)_($9157) OK
L_JSR_($9180)_($915D) OK
L_BRS_($9180)_($9187) OK
//------------------------------
$9180  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$9183  49 08     EOR #$08
$9185  29 04     AND #$04
$9187  D0 F7     BNE L_BRS_($9180)_($9187) OK
$9189  AE 01 DD  LDX $DD01                          // Data Port B (User Port, RS232)
$918C  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$918F  29 F3     AND #$F3
$9191  0D 84 91  ORA $9184
$9194  8D 00 DD  STA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$9197  AD 84 91  LDA $9184 
$919A  49 0C     EOR #$0C
$919C  8D 84 91  STA $9184 
$919F  8A        TXA 
$91A0  60        RTS 
//------------------------------
L_JSR_($91A1)_($90EB) OK
//------------------------------
$91A1  8D 01 DD  STA $DD01                          // Data Port B (User Port, RS232)
$91A4  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$91A7  29 F3     AND #$F3
$91A9  0D 84 91  ORA $9184
$91AC  8D 00 DD  STA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$91AF  AD 84 91  LDA $9184 
$91B2  49 0C     EOR #$0C
$91B4  8D 84 91  STA $9184 
//------------------------------
L_BRS_($91B7)_($91BF) OK
//------------------------------
$91B7  AD 00 DD  LDA $DD00                          // Data Port A (Serial Bus, RS232, VIC Base Mem.)
$91BA  4D 84 91  EOR $9184 
$91BD  29 04     AND #$04
$91BF  F0 F6     BEQ L_BRS_($91B7)_($91BF) OK
$91C1  60        RTS 
//------------------------------
$91C2  36 00     ROL $00,X 
$91C4            .byte $00,$00
$91C6  F6 E1     INC $E1,X 
$91C8  46 37     LSR $37 
$91CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$91FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9202            .byte $00,$00,$00,$00,$00,$00,$00,$00
$920A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9212            .byte $00,$00,$00,$00,$00,$00,$00,$00
$921A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9222            .byte $00,$00,$00,$00,$00,$00,$00,$00
$922A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9232            .byte $00,$00,$00,$00,$00,$00,$00,$00
$923A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9242            .byte $00,$00,$00,$00,$00,$00,$00,$00
$924A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9252            .byte $00,$00,$00,$00,$00,$00,$00,$00
$925A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9262            .byte $00,$00,$00,$00,$00,$00,$00,$00
$926A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9272            .byte $00,$00,$00,$00,$00,$00,$00,$00
$927A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9282            .byte $00,$00,$00,$00,$00,$00,$00,$00
$928A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9292            .byte $00,$00,$00,$00,$00,$00,$00,$00
$929A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$92FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9302            .byte $00,$00,$00,$00,$00,$00,$00,$00
$930A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9312            .byte $00,$00,$00,$00,$00,$00,$00,$00
$931A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9322            .byte $00,$00,$00,$00,$00,$00,$00,$00
$932A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9332            .byte $00,$00,$00,$00,$00,$00,$00,$00
$933A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9342            .byte $00,$00,$00,$00,$00,$00,$00,$00
$934A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9352            .byte $00,$00,$00,$00,$00,$00,$00,$00
$935A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9362            .byte $00,$00,$00,$00,$00,$00,$00,$00
$936A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9372            .byte $00,$00,$00,$00,$00,$00,$00,$00
$937A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9382            .byte $00,$00,$00,$00,$00,$00,$00,$00
$938A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9392            .byte $00,$00,$00,$00,$00,$00,$00,$00
$939A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$93FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9402            .byte $00,$00,$00,$00,$00,$00,$00,$00
$940A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9412            .byte $00,$00,$00,$00,$00,$00,$00,$00
$941A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9422            .byte $00,$00,$00,$00,$00,$00,$00,$00
$942A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9432            .byte $00,$00,$00,$00,$00,$00,$00,$00
$943A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9442            .byte $00,$00,$00,$00,$00,$00,$00,$00
$944A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9452            .byte $00,$00,$00,$00,$00,$00,$00,$00
$945A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9462            .byte $00,$00,$00,$00,$00,$00,$00,$00
$946A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9472            .byte $00,$00,$00,$00,$00,$00,$00,$00
$947A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9482            .byte $00,$00,$00,$00,$00,$00,$00,$00
$948A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9492            .byte $00,$00,$00,$00,$00,$00,$00,$00
$949A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$94FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9502            .byte $00,$00,$00,$00,$00,$00,$00,$00
$950A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9512            .byte $00,$00,$00,$00,$00,$00,$00,$00
$951A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9522            .byte $00,$00,$00,$00,$00,$00,$00,$00
$952A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9532            .byte $00,$00,$00,$00,$00,$00,$00,$00
$953A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9542            .byte $00,$00,$00,$00,$00,$00,$00,$00
$954A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9552            .byte $00,$00,$00,$00,$00,$00,$00,$00
$955A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9562            .byte $00,$00,$00,$00,$00,$00,$00,$00
$956A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9572            .byte $00,$00,$00,$00,$00,$00,$00,$00
$957A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9582            .byte $00,$00,$00,$00,$00,$00,$00,$00
$958A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$9592            .byte $00,$00,$00,$00,$00,$00,$00,$00
$959A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$95FA            .byte $00,$00,$00,$00,$00,$00,$33,$64
$9602  29 01     AND #$01
$9604            .byte $0B,$00
$9606  01 21     ORA ($21,X)
$9608  10 00     BPL L_BRS_($960A)_($9608) JAM
//------------------------------
L_BRS_($960A)_($9608) JAM
//------------------------------
$960A            .byte $00,$00,$00,$00
$960E  55 55     EOR $55,X 
$9610  55 55     EOR $55,X 
$9612  AA        TAX 
$9613  AA        TAX 
$9614  AA        TAX 
$9615  AA        TAX 
$9616            .byte $FF,$FF,$FF,$FF
$961A  88        DEY 
$961B            .byte $22
$961C  88        DEY 
$961D            .byte $22
$961E  CC 33 CC  CPY $CC33 
$9621            .byte $33,$33
$9623  CC 33 CC  CPY $CC33 
$9626  66 99     ROR $99 
$9628  66 99     ROR $99 
$962A  EE BB EE  INC $EEBB                          // RS232 Send
$962D            .byte $BB,$22
$962F  88        DEY 
$9630            .byte $22
$9631  88        DEY 
$9632  DD 77 DD  CMP $DD77,X 
$9635            .byte $77
$9636  11 44     ORA ($44),Y
$9638  11 44     ORA ($44),Y
$963A            .byte $44
$963B  11 44     ORA ($44),Y
$963D  11 BB     ORA ($BB),Y
$963F  EE BB EE  INC $EEBB                          // RS232 Send
$9642  99 66 99  STA $9966,Y 
$9645  66 31     ROR $31 
$9647  29 40     AND #$40
$9649  01 00     ORA ($00,X)
$964B            .byte $00,$00,$00,$00,$00
$9650  51 20     EOR ($20),Y 
$9652  E5 00     SBC $00 
$9654            .byte $00
$9655  48        PHA 
$9656  01 64     ORA ($64,X)
$9658  0A        ASL A 
$9659  D8        CLD 
$965A            .byte $03,$03,$00
$965D  94 C0     STY $C0,X 
$965F            .byte $13
$9660  8D C0 1A  STA $1AC0 
$9663  9A        TXS 
$9664  C0 0C     CPY #$0C
$9666  CE C1 1B  DEC $1BC1 
$9669  86 C1     STX $C1 
$966B  0D 00 00  ORA $0000
$966E            .byte $00,$00,$00,$00,$00,$00,$00
$9675  86 E0     STX $E0 
$9677  01 A1     ORA ($A1,X)
$9679  F5 10     SBC $10,X 
$967B  69 F5     ADC #$F5
$967D            .byte $02,$89
$967F  F5 02     SBC $02,X 
$9681            .byte $00
$9682  E0 05     CPX #$05
$9684  40        RTI 
//------------------------------
$9685  E1 05     SBC ($05,X) 
$9687            .byte $80,$E2
$9689  05 F8     ORA $F8
$968B  EC 0A 00  CPX $000A 
$968E  E0 01     CPX #$01
$9690  96 E0     STX $E0,Y 
$9692            .byte $03
$9693  B6 E0     LDX $E0,Y 
$9695            .byte $03
$9696  39 F6 02  AND $02F6,Y 
$9699  29 F6     AND #$F6
$969B            .byte $02
$969C  49 F6     EOR #$F6
$969E            .byte $02,$80,$F4,$0B
$96A2  68        PLA 
$96A3  EA        NOP 
$96A4  0E A8 EB  ASL $EBA8 
$96A7  0E E8 EC  ASL $ECE8 
$96AA  0E 28 EE  ASL $EE28 
$96AD  0E 68 EF  ASL $EF68 
$96B0  0E 00 00  ASL $0000 
$96B3            .byte $00,$00,$00,$00
$96B7  28        PLP 
$96B8            .byte $00,$00,$02,$32,$02
$96BD  01 02     ORA ($02,X)
$96BF            .byte $02
$96C0  01 00     ORA ($00,X)
$96C2            .byte $02
$96C3  01 03     ORA ($03,X)
$96C5            .byte $03
$96C6  4E 72 49  LSR $4972 
$96C9  01 CE     ORA ($CE,X)
$96CB            .byte $02,$5A
$96CD  06 5B     ASL $5B 
$96CF            .byte $07,$8F
$96D1  08        PHP 
$96D2            .byte $5C
$96D3  09 31     ORA #$31
$96D5  0A        ASL A 
$96D6            .byte $7C,$0C
$96D8  C0 0D     CPY #$0D
$96DA            .byte $27,$0F,$37
$96DD  10 4B     BPL L_BRS_($972A)_($96DD) OK
$96DF  11 EF     ORA ($EF),Y
$96E1  11 90     ORA ($90),Y
$96E3            .byte $12
$96E4  45 13     EOR $13 
$96E6  B0 13     BCS L_BRS_($96FB)_($96E6) BAD
$96E8  3D 14 BC  AND $BC14,X 
$96EB            .byte $14
$96EC  C0 15     CPY #$15
$96EE  E8        INX 
$96EF  16 40     ASL $40,X 
$96F1            .byte $17
$96F2  FE 17 8D  INC $8D17,X 
$96F5  18        CLC 
$96F6            .byte $DF
$96F7  19 31 1A  ORA $1A31,Y
//------------------------------
L_BRS_($96FB)_($96E6) BAD
//------------------------------
$96FA  99 1B 53  STA $531B,Y 
$96FD            .byte $1C
$96FE  F1 1C     SBC ($1C),Y 
$9700  EA        NOP 
$9701  1D 94 1E  ORA $1E94,X
$9704            .byte $63,$1F,$07
$9707  20 72 20  JSR L_JSR_($2072)_($9707) BAD
$970A  BE 21 C4  LDX $C421,Y 
$970D            .byte $22,$43,$23
$9710  4A        LSR A 
$9711  24 99     BIT $99 
$9713  24 D3     BIT $D3 
$9715  25 06     AND $06
$9717  26 46     ROL $46 
$9719  26 86     ROL $86 
$971B  26 D7     ROL $D7 
$971D  26 24     ROL $24 
$971F            .byte $27,$5B,$27
$9722  8E 27 CE  STX $CE27 
$9725            .byte $27
$9726  0E 28 34  ASL $3428 
$9729  28        PLP 
//------------------------------
L_BRS_($972A)_($96DD) OK
//------------------------------
$972A  B5 28     LDA $28,X 
$972C  E8        INX 
$972D  28        PLP 
$972E  69 25     ADC #$25
$9730            .byte $BB
$9731  25 EE     AND $EE
$9733  25 14     AND $14
$9735  26 3A     ROL $3A 
$9737  26 60     ROL $60 
$9739  26 86     ROL $86 
$973B  26 AC     ROL $AC 
$973D  26 D2     ROL $D2 
$973F  26 01     ROL $01 
$9741            .byte $07,$0C,$03,$0B
$9745  20 00 0D  JSR L_JSR_($0D00)_($9745) BAD
$9748            .byte $03,$23,$17
$974B  01 84     ORA ($84,X)
$974D  01 01     ORA ($01,X)
$974F            .byte $00,$07,$03
$9752  08        PHP 
$9753            .byte $00,$42,$32,$34,$43
$9758  05 45     ORA $45
$975A  01 18     ORA ($18,X)
$975C            .byte $03,$02,$02
$975F  01 10     ORA ($10,X)
$9761  66 66     ROR $66 
$9763            .byte $00
$9764  01 01     ORA ($01,X)
$9766            .byte $02
$9767  01 04     ORA ($04,X)
$9769  48        PHA 
$976A  01 18     ORA ($18,X)
$976C  09 02     ORA #$02
$976E            .byte $02,$02,$14
$9771  66 66     ROR $66 
$9773            .byte $00,$00
$9775  01 01     ORA ($01,X)
$9777  01 22     ORA ($22,X)
$9779            .byte $0F,$1C,$03,$03,$47,$04,$13,$02
$9781            .byte $00,$0C,$03
$9784  0A        ASL A 
$9785  CC 03 48  CPY $4803 
$9788  01 13     ORA ($13,X)
$978A            .byte $02,$00,$0C,$04
$978E  0A        ASL A 
$978F  CC 0C 4F  CPY $4F0C 
$9792            .byte $02
$9793  19 02 01  ORA $0102,Y
$9796            .byte $00,$0C
$9798  16 66     ASL $66,X 
$979A  51 02     EOR ($02),Y 
$979C  19 51 03  ORA $0351,Y
$979F  19 50 03  ORA $0350,Y
$97A2  19 4F 02  ORA $024F,Y
$97A5  19 0D 4F  ORA $4F0D,Y
$97A8  01 17     ORA ($17,X)
$97AA            .byte $02,$00,$04
$97AD  05 19     ORA $19
$97AF  CC 50 01  CPY $0150 
$97B2            .byte $1B
$97B3  51 01     EOR ($01),Y 
$97B5            .byte $1B
$97B6  51 01     EOR ($01),Y 
$97B8            .byte $17
$97B9  50 01     BVC L_BRS_($97BC)_($97B9) JAM
//------------------------------
L_BRS_($97BC)_($97B9) JAM
//------------------------------
$97BB            .byte $17,$4F
$97BD  01 19     ORA ($19,X)
$97BF  0A        ASL A 
$97C0  48        PHA 
$97C1  01 14     ORA ($14,X)
$97C3  01 03     ORA ($03,X)
$97C5            .byte $00,$07
$97C7  10 11     BPL L_BRS_($97DA)_($97C7) JAM
$97C9  48        PHA 
$97CA            .byte $04,$14
$97CC  49 01     EOR #$01
$97CE            .byte $14
$97CF  0A        ASL A 
$97D0            .byte $47
$97D1  01 14     ORA ($14,X)
$97D3  01 03     ORA ($03,X)
$97D5            .byte $00
$97D6  08        PHP 
$97D7  10 11     BPL L_BRS_($97EA)_($97D7) JAM
//------------------------------
L_BRS_($97DA)_($97C7) JAM
//------------------------------
$97D9            .byte $47,$04,$14
$97DC  48        PHA 
$97DD  01 14     ORA ($14,X)
$97DF  06 25     ASL $25 
$97E1            .byte $00
$97E2  25 4B     AND $4B
$97E4            .byte $3C,$4B
$97E6  0A        ASL A 
$97E7  10 64     BPL L_BRS_($984D)_($97E7) OK
//------------------------------
L_BRS_($97EA)_($97D7) JAM
//------------------------------
$97E9            .byte $64,$00
$97EB  26 26     ROL $26 
$97ED  26 26     ROL $26 
$97EF  C0 61     CPY #$61
$97F1            .byte $00
$97F2  20 47 36  JSR L_JSR_($3647)_($97F2) BAD
$97F5            .byte $00,$0B
$97F7  09 0A     ORA #$0A
$97F9  45 02     EOR $02 
$97FB  18        CLC 
$97FC            .byte $00,$02,$02
$97FF  20 10 11  JSR L_JSR_($1110)_($97FF) BAD
$9802  45 02     EOR $02 
$9804  18        CLC 
$9805  45 04     EOR $04 
$9807            .byte $1A,$0B
$9809  48        PHA 
$980A            .byte $00,$17
$980C  01 01     ORA ($01,X)
$980E  01 0E     ORA ($0E,X)
$9810            .byte $13
$9811  DD 48 00  CMP $0048,X 
$9814            .byte $17
$9815  48        PHA 
$9816  01 18     ORA ($18,X)
$9818  49 01     EOR #$01
$981A  18        CLC 
$981B            .byte $0B
$981C  48        PHA 
$981D            .byte $00,$1A
$981F  01 01     ORA ($01,X)
$9821  01 0F     ORA ($0F,X)
$9823            .byte $13
$9824  DD 48 00  CMP $0048,X 
$9827            .byte $1B
$9828  48        PHA 
$9829  01 1A     ORA ($1A,X)
$982B  49 01     EOR #$01
$982D            .byte $1A
$982E  0A        ASL A 
$982F  45 02     EOR $02 
$9831  18        CLC 
$9832            .byte $00,$02,$02
$9835  0D 10 11  ORA $1110
$9838  45 04     EOR $04 
$983A  18        CLC 
$983B  45 02     EOR $02 
$983D            .byte $1A
$983E  0A        ASL A 
$983F  48        PHA 
$9840  01 1E     ORA ($1E,X)
$9842  01 03     ORA ($03,X)
$9844            .byte $00
$9845  11 10     ORA ($10),Y
$9847  11 48     ORA ($48),Y
$9849            .byte $04
$984A  1E 49 01  ASL $0149,X 
//------------------------------
L_BRS_($984D)_($97E7) OK
//------------------------------
$984D  1E 0A 47  ASL $470A,X 
$9850  01 1E     ORA ($1E,X)
$9852  01 03     ORA ($03,X)
$9854            .byte $00,$12
$9856  10 11     BPL L_BRS_($9869)_($9856) BAD
$9858            .byte $47,$04
$985A  1E 48 01  ASL $0148,X 
$985D  1E 03 00  ASL $0003,X 
$9860            .byte $00
$9861  16 7E     ASL $7E,X 
$9863            .byte $00,$07,$13
$9866  0A        ASL A 
//------------------------------
L_BRS_($9869)_($9856) BAD
//------------------------------
$9867  99 0C 33  STA $330C,Y 
$986A            .byte $00
$986B  70 04     BVS L_BRS_($9871)_($986B) JAM
$986D  01 00     ORA ($00,X)
$986F  09 19     ORA #$19
//------------------------------
L_BRS_($9871)_($986B) JAM
//------------------------------
$9871            .byte $BB,$34,$00
$9874  70 35     BVS L_BRS_($98AB)_($9874) JAM
$9876            .byte $00
$9877  70 35     BVS L_BRS_($98AE)_($9877) JAM
$9879            .byte $02,$6F,$34,$02,$6F,$12
$987F  19 06 C0  ORA $C006,Y
$9882            .byte $57,$00,$23,$00
$9886  24 00     BIT $00 
$9888  06 09     ASL $09 
$988A  C0 7E     CPY #$7E
$988C  30 2A     BMI L_BRS_($98B8)_($988C) JAM
$988E  46 36     LSR $36 
$9890            .byte $00
$9891  21 09     AND ($09,X) 
$9893            .byte $0C
$9894  56 00     LSR $00,X 
$9896  25 03     AND $03
$9898            .byte $02,$00
$989A  15 19     ORA $19,X
$989C  11 57     ORA ($57),Y
$989E            .byte $00
$989F  25 57     AND $57
$98A1            .byte $02
$98A2  26 58     ROL $58 
$98A4            .byte $02
$98A5  26 58     ROL $58 
$98A7            .byte $00
$98A8  25 12     AND $12
//------------------------------
L_BRS_($98AB)_($9874) JAM
//------------------------------
$98AA            .byte $02,$07
$98AC  C0 34     CPY #$34
//------------------------------
L_BRS_($98AE)_($9877) JAM
//------------------------------
$98AE            .byte $00
$98AF  71 00     ADC ($00),Y 
$98B1            .byte $00,$00
$98B3  16 09     ASL $09,X 
$98B5  01 48     ORA ($48,X)
//------------------------------
L_BRS_($98B8)_($988C) JAM
//------------------------------
$98B7            .byte $02,$1A,$02
$98BA  01 01     ORA ($01,X)
$98BC            .byte $17
$98BD  18        CLC 
$98BE            .byte $00,$00,$00,$0F,$0B
$98C3  09 20     ORA #$20
$98C5  10 17     BPL L_BRS_($98DE)_($98C5) BAD
$98C7            .byte $22
$98C8  09 01     ORA #$01
$98CA  4C 1D 00  JMP $001D
$98CD            .byte $00
$98CE  01 50     ORA ($50,X)
$98D0            .byte $FF,$8B,$03
$98D3  01 00     ORA ($00,X)
$98D5            .byte $07,$03,$02
$98D8  20 50 44  JSR L_JSR_($4450)_($98D8) OK
$98DB            .byte $4F
//------------------------------
L_BRS_($98DE)_($98C5) BAD
//------------------------------
$98DC  20 41 00  JSR $0041
$98DF            .byte $00,$00
$98E1  40        RTI 
//------------------------------
$98E2  01 40     ORA ($40,X)
$98E4            .byte $80,$0C,$22,$FF,$33
$98E9  41 00     EOR ($00,X) 
$98EB  20 00 40  JSR L_JSR_($4000)_($98EB) OK
$98EE  01 40     ORA ($40,X)
$98F0  81 0C     STA ($0C,X) 
$98F2            .byte $22
$98F3  88        DEY 
$98F4            .byte $33
$98F5  41 00     EOR ($00,X) 
$98F7  01 00     ORA ($00,X)
$98F9  01 1F     ORA ($1F,X)
$98FB  40        RTI 
//------------------------------
$98FC            .byte $82,$0C,$22,$44,$33
$9901  41 3F     EOR ($3F,X) 
$9903  01 00     ORA ($00,X)
$9905  01 1F     ORA ($1F,X)
$9907  40        RTI 
//------------------------------
$9908            .byte $83,$0C,$22,$44,$33
$990D  41 01     EOR ($01,X) 
$990F  01 00     ORA ($00,X)
$9911  3E 1F 01  ROL $011F,X 
$9914  84 0C     STY $0C 
$9916            .byte $22,$44,$44
$9919  41 01     EOR ($01,X) 
$991B  01 3F     ORA ($3F,X)
$991D  3E 1F 01  ROL $011F,X 
$9920  85 0C     STA $0C 
$9922            .byte $22,$44,$44
$9925  41 15     EOR ($15,X) 
$9927  01 01     ORA ($01,X)
$9929  01 1F     ORA ($1F,X)
$992B  3E 86 0C  ROL $0C86,X 
$992E            .byte $22,$44,$33
$9931  41 2A     EOR ($2A,X) 
$9933  01 01     ORA ($01,X)
$9935  01 1F     ORA ($1F,X)
$9937  3E 87 0C  ROL $0C87,X 
$993A            .byte $22,$44,$33
$993D  41 01     EOR ($01,X) 
$993F  01 15     ORA ($15,X)
$9941  3E 1F 01  ROL $011F,X 
$9944  88        DEY 
$9945            .byte $0C,$00,$00,$44
$9949  41 01     EOR ($01,X) 
$994B  01 2A     ORA ($2A,X)
$994D  3E 1F 01  ROL $011F,X 
$9950            .byte $89,$0C,$00,$00,$44
$9955  41 01     EOR ($01,X) 
$9957  11 01     ORA ($01),Y
$9959  3E 01 3E  ROL $3E01,X 
$995C  8A        TXA 
$995D            .byte $0C,$22
$995F  88        DEY 
$9960            .byte $33
$9961  41 01     EOR ($01,X) 
$9963  01 0D     ORA ($0D,X)
$9965  08        PHP 
$9966            .byte $04
$9967  08        PHP 
$9968            .byte $8B,$0C
$996A  CC BB 77  CPY $77BB 
$996D  41 01     EOR ($01,X) 
$996F  05 09     ORA $09
$9971  08        PHP 
$9972            .byte $04
$9973  08        PHP 
$9974  8C 0C DD  STY $DD0C                          // Synchronous Serial I/O Data Buffer
$9977            .byte $BB
$9978  66 41     ROR $41 
$997A  01 09     ORA ($09,X)
$997C  05 08     ORA $08
$997E            .byte $04
$997F  08        PHP 
$9980  8D 0C CC  STA $CC0C 
$9983            .byte $BB,$77
$9985  41 01     EOR ($01,X) 
$9987  0D 01 08  ORA $0801
$998A            .byte $04
$998B  08        PHP 
$998C  8E 0C DD  STX $DD0C                          // Synchronous Serial I/O Data Buffer
$998F            .byte $BB
$9990  66 41     ROR $41 
$9992  05 09     ORA $09
$9994  01 08     ORA ($08,X)
$9996            .byte $04
$9997  08        PHP 
$9998            .byte $8F,$0C
$999A  CC BB 77  CPY $77BB 
$999D  41 09     EOR ($09,X) 
$999F  05 01     ORA $01
$99A1  08        PHP 
$99A2            .byte $04
$99A3  08        PHP 
$99A4  90 0C     BCC L_BRS_($99B2)_($99A4) OK
$99A6  DD BB 66  CMP $66BB,X 
$99A9  41 0D     EOR ($0D,X) 
$99AB  01 01     ORA ($01,X)
$99AD  08        PHP 
$99AE            .byte $04
$99AF  08        PHP 
$99B0  91 0C     STA ($0C),Y 
//------------------------------
L_BRS_($99B2)_($99A4) OK
//------------------------------
$99B2  CC BB 77  CPY $77BB 
$99B5  41 2B     EOR ($2B,X) 
$99B7  01 01     ORA ($01,X)
$99B9  08        PHP 
$99BA            .byte $04
$99BB  08        PHP 
$99BC            .byte $92,$0C
$99BE  DD BB 66  CMP $66BB,X 
$99C1  41 2F     EOR ($2F,X) 
$99C3  05 01     ORA $01
$99C5  08        PHP 
$99C6            .byte $04
$99C7  08        PHP 
$99C8            .byte $93,$0C
$99CA  DD BB 66  CMP $66BB,X 
$99CD  41 33     EOR ($33,X) 
$99CF  09 01     ORA #$01
$99D1  08        PHP 
$99D2            .byte $04
$99D3  08        PHP 
$99D4  94 0C     STY $0C,X 
$99D6  DD BB 66  CMP $66BB,X 
$99D9  41 37     EOR ($37,X) 
$99DB  0D 01 08  ORA $0801
$99DE            .byte $04
$99DF  08        PHP 
$99E0  95 0C     STA $0C,X 
$99E2  DD BB 66  CMP $66BB,X 
$99E5  41 37     EOR ($37,X) 
$99E7  09 05     ORA #$05
$99E9  08        PHP 
$99EA            .byte $04
$99EB  08        PHP 
$99EC  96 0C     STX $0C,Y 
$99EE  CC BB 77  CPY $77BB 
$99F1  41 37     EOR ($37,X) 
$99F3  05 09     ORA $09
$99F5  08        PHP 
$99F6            .byte $04
$99F7  08        PHP 
$99F8            .byte $97,$0C
$99FA  DD BB 66  CMP $66BB,X 
$99FD  41 37     EOR ($37,X) 
$99FF  01 0D     ORA ($0D,X)
$9A01  08        PHP 
$9A02            .byte $04
$9A03  08        PHP 
$9A04  98        TYA 
$9A05            .byte $0C
$9A06  CC BB 77  CPY $77BB 
$9A09  41 37     EOR ($37,X) 
$9A0B  01 2B     ORA ($2B,X)
$9A0D  08        PHP 
$9A0E            .byte $04
$9A0F  08        PHP 
$9A10  99 0C DD  STA $DD0C,Y                          // Synchronous Serial I/O Data Buffer
$9A13            .byte $BB
$9A14  66 41     ROR $41 
$9A16            .byte $37
$9A17  05 2F     ORA $2F
$9A19  08        PHP 
$9A1A            .byte $04
$9A1B  08        PHP 
$9A1C  9A        TXS 
$9A1D            .byte $0C
$9A1E  CC BB 77  CPY $77BB 
$9A21  41 37     EOR ($37,X) 
$9A23  09 33     ORA #$33
$9A25  08        PHP 
$9A26            .byte $04
$9A27  08        PHP 
$9A28            .byte $9B,$0C
$9A2A  CC BB 66  CPY $66BB 
$9A2D  41 37     EOR ($37,X) 
$9A2F  0D 37 08  ORA $0837
$9A32            .byte $04
$9A33  08        PHP 
$9A34            .byte $9C,$0C
$9A36  CC BB 77  CPY $77BB 
$9A39  41 33     EOR ($33,X) 
$9A3B  09 37     ORA #$37
$9A3D  08        PHP 
$9A3E            .byte $04
$9A3F  08        PHP 
$9A40  9D 0C CC  STA $CC0C,X 
$9A43            .byte $BB,$77
$9A45  41 2F     EOR ($2F,X) 
$9A47  05 37     ORA $37
$9A49  08        PHP 
$9A4A            .byte $04
$9A4B  08        PHP 
$9A4C            .byte $9E,$0C
$9A4E  CC BB 77  CPY $77BB 
$9A51  41 2B     EOR ($2B,X) 
$9A53  01 37     ORA ($37,X)
$9A55  08        PHP 
$9A56            .byte $04
$9A57  08        PHP 
$9A58            .byte $9F,$0C
$9A5A  CC BB 77  CPY $77BB 
$9A5D  41 0D     EOR ($0D,X) 
$9A5F  01 37     ORA ($37,X)
$9A61  08        PHP 
$9A62            .byte $04
$9A63  08        PHP 
$9A64  A0 0C     LDY #$0C
$9A66  CC BB 77  CPY $77BB 
$9A69  41 09     EOR ($09,X) 
$9A6B  05 37     ORA $37
$9A6D  08        PHP 
$9A6E            .byte $04
$9A6F  08        PHP 
$9A70  A1 0C     LDA ($0C,X) 
$9A72  DD BB 66  CMP $66BB,X 
$9A75  41 05     EOR ($05,X) 
$9A77  09 37     ORA #$37
$9A79  08        PHP 
$9A7A            .byte $04
$9A7B  08        PHP 
$9A7C  A2 0C     LDX #$0C
$9A7E  CC BB 77  CPY $77BB 
$9A81  41 01     EOR ($01,X) 
$9A83  0D 37 08  ORA $0837
$9A86            .byte $04
$9A87  08        PHP 
$9A88            .byte $A3,$0C
$9A8A  DD BB 66  CMP $66BB,X 
$9A8D  41 01     EOR ($01,X) 
$9A8F  09 33     ORA #$33
$9A91  08        PHP 
$9A92            .byte $04
$9A93  08        PHP 
$9A94  A4 0C     LDY $0C 
$9A96  CC BB 77  CPY $77BB 
$9A99  41 01     EOR ($01,X) 
$9A9B  05 2F     ORA $2F
$9A9D  08        PHP 
$9A9E            .byte $04
$9A9F  08        PHP 
$9AA0  A5 0C     LDA $0C 
$9AA2  DD BB 66  CMP $66BB,X 
$9AA5  41 01     EOR ($01,X) 
$9AA7  01 2B     ORA ($2B,X)
$9AA9  08        PHP 
$9AAA            .byte $04
$9AAB  08        PHP 
$9AAC  A6 0C     LDX $0C 
$9AAE  CC BB 77  CPY $77BB 
$9AB1  41 01     EOR ($01,X) 
$9AB3  0D 1C 08  ORA $081C
$9AB6            .byte $04
$9AB7  08        PHP 
$9AB8            .byte $A7,$0C
$9ABA  DD BB 66  CMP $66BB,X 
$9ABD  41 05     EOR ($05,X) 
$9ABF  09 1C     ORA #$1C
$9AC1  08        PHP 
$9AC2            .byte $04
$9AC3  08        PHP 
$9AC4  A8        TAY 
$9AC5            .byte $0C
$9AC6  CC BB 77  CPY $77BB 
$9AC9  41 09     EOR ($09,X) 
$9ACB  05 1C     ORA $1C
$9ACD  08        PHP 
$9ACE            .byte $04
$9ACF  08        PHP 
$9AD0  A9 0C     LDA #$0C
$9AD2  DD BB 66  CMP $66BB,X 
$9AD5  41 0C     EOR ($0C,X) 
$9AD7  01 1C     ORA ($1C,X)
$9AD9  08        PHP 
$9ADA            .byte $04
$9ADB  08        PHP 
$9ADC  AA        TAX 
$9ADD            .byte $0C
$9ADE  CC BB 77  CPY $77BB 
$9AE1  41 37     EOR ($37,X) 
$9AE3  0D 1C 08  ORA $081C
$9AE6            .byte $04
$9AE7  08        PHP 
$9AE8            .byte $AB,$0C
$9AEA  DD BB 66  CMP $66BB,X 
$9AED  41 33     EOR ($33,X) 
$9AEF  09 1C     ORA #$1C
$9AF1  08        PHP 
$9AF2            .byte $04
$9AF3  08        PHP 
$9AF4  AC 0C CC  LDY $CC0C 
$9AF7            .byte $BB,$77
$9AF9  41 2F     EOR ($2F,X) 
$9AFB  05 1C     ORA $1C
$9AFD  08        PHP 
$9AFE            .byte $04
$9AFF  08        PHP 
$9B00  AD 0C DD  LDA $DD0C                          // Synchronous Serial I/O Data Buffer
$9B03            .byte $BB
$9B04  66 41     ROR $41 
$9B06            .byte $2B
$9B07  01 1C     ORA ($1C,X)
$9B09  08        PHP 
$9B0A            .byte $04
$9B0B  08        PHP 
$9B0C  AE 0C CC  LDX $CC0C 
$9B0F            .byte $BB,$77
$9B11  41 1C     EOR ($1C,X) 
$9B13  0D 01 08  ORA $0801
$9B16            .byte $04
$9B17  08        PHP 
$9B18            .byte $AF,$0C
$9B1A  66 BB     ROR $BB 
$9B1C  DD 41 1C  CMP $1C41,X 
$9B1F  09 05     ORA #$05
$9B21  08        PHP 
$9B22            .byte $04
$9B23  08        PHP 
$9B24  B0 0C     BCS L_BRS_($9B32)_($9B24) OK
$9B26            .byte $77,$BB
$9B28  CC 41 1C  CPY $1C41 
$9B2B  05 09     ORA $09
$9B2D  08        PHP 
$9B2E            .byte $04
$9B2F  08        PHP 
$9B30  B1 0C     LDA ($0C),Y 
//------------------------------
L_BRS_($9B32)_($9B24) OK
//------------------------------
$9B32  66 BB     ROR $BB 
$9B34  DD 41 1C  CMP $1C41,X 
$9B37  01 0D     ORA ($0D,X)
$9B39  08        PHP 
$9B3A            .byte $04
$9B3B  08        PHP 
$9B3C            .byte $B2,$0C,$77,$BB
$9B40  CC 41 1C  CPY $1C41 
$9B43  0D 37 08  ORA $0837
$9B46            .byte $04
$9B47  08        PHP 
$9B48            .byte $B3,$0C
$9B4A  DD BB 66  CMP $66BB,X 
$9B4D  41 1C     EOR ($1C,X) 
$9B4F  09 33     ORA #$33
$9B51  08        PHP 
$9B52            .byte $04
$9B53  08        PHP 
$9B54  B4 0C     LDY $0C,X 
$9B56  CC BB 77  CPY $77BB 
$9B59  41 1C     EOR ($1C,X) 
$9B5B  05 2F     ORA $2F
$9B5D  08        PHP 
$9B5E            .byte $04
$9B5F  08        PHP 
$9B60  B5 0C     LDA $0C,X 
$9B62  DD BB 66  CMP $66BB,X 
$9B65  41 1C     EOR ($1C,X) 
$9B67  01 2B     ORA ($2B,X)
$9B69  08        PHP 
$9B6A            .byte $04
$9B6B  08        PHP 
$9B6C  B6 0C     LDX $0C,Y 
$9B6E  CC BB 77  CPY $77BB 
$9B71  C0 03     CPY #$03
$9B73  11 05     ORA ($05),Y
$9B75            .byte $00,$12,$00,$B7
$9B79  09 C0     ORA #$C0
$9B7B  05 11     ORA $11
$9B7D            .byte $03,$00,$00,$00,$B8
$9B82  09 C0     ORA #$C0
$9B84  20 11 03  JSR $0311
$9B87            .byte $00,$00,$00
$9B8A  B9 09 C0  LDA $C009,Y 
$9B8D            .byte $3A
$9B8E  11 03     ORA ($03),Y
$9B90            .byte $00
$9B91  36 00     ROL $00,X 
$9B93  BA        TSX 
$9B94  09 C0     ORA #$C0
$9B96            .byte $3C
$9B97  11 05     ORA ($05),Y
$9B99            .byte $00
$9B9A  36 00     ROL $00,X 
$9B9C            .byte $BB
$9B9D  09 C0     ORA #$C0
$9B9F            .byte $3C
$9BA0  11 20     ORA ($20),Y
$9BA2            .byte $00
$9BA3  36 00     ROL $00,X 
$9BA5  BC 09 C0  LDY $C009,X 
$9BA8            .byte $3C
$9BA9  11 3A     ORA ($3A),Y
$9BAB            .byte $00
$9BAC  36 00     ROL $00,X 
$9BAE  BD 09 C0  LDA $C009,X 
$9BB1            .byte $3A
$9BB2  11 3C     ORA ($3C),Y
$9BB4            .byte $00
$9BB5  24 00     BIT $00 
$9BB7  BE 09 C0  LDX $C009,Y 
$9BBA  20 11 3C  JSR L_JSR_($3C11)_($9BBA) BAD
$9BBD            .byte $00
$9BBE  24 00     BIT $00 
$9BC0            .byte $BF
$9BC1  09 C0     ORA #$C0
$9BC3  05 11     ORA $11
$9BC5            .byte $3C,$00
$9BC7  24 00     BIT $00 
$9BC9  C0 09     CPY #$09
$9BCB  C0 03     CPY #$03
$9BCD  11 3A     ORA ($3A),Y
$9BCF            .byte $00,$12,$00
$9BD2  C1 09     CMP ($09,X) 
$9BD4  C0 03     CPY #$03
$9BD6  11 20     ORA ($20),Y
$9BD8            .byte $00,$12,$00,$C2
$9BDC  09 C0     ORA #$C0
$9BDE            .byte $03
$9BDF  01 05     ORA ($05,X)
$9BE1            .byte $00,$12,$00,$C3
$9BE5  09 C0     ORA #$C0
$9BE7  05 01     ORA $01
$9BE9            .byte $03,$00,$00,$00
$9BED  C4 09     CPY $09 
$9BEF  C0 20     CPY #$20
$9BF1  01 03     ORA ($03,X)
$9BF3            .byte $00,$00,$00
$9BF6  C5 09     CMP $09 
$9BF8  C0 3A     CPY #$3A
$9BFA  01 03     ORA ($03,X)
$9BFC            .byte $00,$00,$00
$9BFF  C6 09     DEC $09 
$9C01  C0 3C     CPY #$3C
$9C03  01 05     ORA ($05,X)
$9C05            .byte $00
//------------------------------
L_BRS_($9C07)_($9C51) BAD
//------------------------------
$9C06  36 00     ROL $00,X 
$9C08            .byte $C7
$9C09  09 C0     ORA #$C0
$9C0B            .byte $3C
$9C0C  01 20     ORA ($20,X)
$9C0E            .byte $00
$9C0F  36 00     ROL $00,X 
$9C11  C8        INY 
$9C12  09 C0     ORA #$C0
$9C14            .byte $3C
$9C15  01 3A     ORA ($3A,X)
$9C17            .byte $00
$9C18  36 00     ROL $00,X 
$9C1A  C9 09     CMP #$09
$9C1C  C0 3A     CPY #$3A
$9C1E  01 3C     ORA ($3C,X)
$9C20            .byte $00
$9C21  36 00     ROL $00,X 
$9C23  CA        DEX 
$9C24  09 C0     ORA #$C0
$9C26  20 01 3D  JSR L_JSR_($3D01)_($9C26) OK
$9C29            .byte $00
$9C2A  24 00     BIT $00 
$9C2C            .byte $CB
$9C2D  09 C0     ORA #$C0
$9C2F  05 01     ORA $01
$9C31            .byte $3C,$00
$9C33  24 00     BIT $00 
$9C35  CC 09 C0  CPY $C009 
$9C38            .byte $03
$9C39  01 3A     ORA ($3A,X)
$9C3B            .byte $00,$12,$00
$9C3E  CD 09 C0  CMP $C009 
$9C41            .byte $03
$9C42  01 20     ORA ($20,X)
$9C44            .byte $00,$12,$00
$9C47  CE 09 47  DEC $4709 
$9C4A  1D 1E 1D  ORA $1D1E,X
$9C4D  06 02     ASL $02 
$9C4F  06 D0     ASL $D0 
$9C51  10 B4     BPL L_BRS_($9C07)_($9C51) BAD
$9C53  B4 22     LDY $22,X 
$9C55            .byte $03,$03,$03,$03,$00,$00
$9C5B  0E 02 00  ASL $0002 
$9C5E  01 05     ORA ($05,X)
$9C60            .byte $00,$07
$9C62  06 08     ASL $08 
$9C64  01 41     ORA ($41,X)
$9C66            .byte $32,$34,$43
$9C69  C0 80     CPY #$80
$9C6B  86 87     STX $87 
$9C6D  85 00     STA $00 
$9C6F            .byte $00,$FF
$9C71  09 0C     ORA #$0C
$9C73  1D 01 0B  ORA $0B01,X
$9C76  06 0B     ASL $0B 
$9C78            .byte $00
$9C79  01 19     ORA ($19,X)
$9C7B  11 1D     ORA ($1D),Y
$9C7D  01 01     ORA ($01,X)
$9C7F  1D 0D 0B  ORA $0B0D,X
$9C82  24 0D     BIT $0D 
$9C84            .byte $0B
$9C85  24 01     BIT $01 
$9C87  01 12     ORA ($12,X)
$9C89  01 06     ORA ($06,X)
$9C8B  01 16     ORA ($16,X)
$9C8D            .byte $12
$9C8E  01 14     ORA ($14,X)
$9C90  01 3E     ORA ($3E,X)
$9C92            .byte $02,$0C,$33
$9C95  88        DEY 
$9C96  55 08     EOR $08,X 
$9C98  16 0C     ASL $0C,X 
$9C9A  0A        ASL A 
$9C9B            .byte $14
$9C9C  06 05     ASL $05 
$9C9E            .byte $04
$9C9F  10 00     BPL L_BRS_($9CA1)_($9C9F) JAM
//------------------------------
L_BRS_($9CA1)_($9C9F) JAM
//------------------------------
$9CA1            .byte $04,$00,$00
$9CA4  06 14     ASL $14 
$9CA6  06 08     ASL $08 
$9CA8  16 01     ASL $01,X 
$9CAA  01 14     ORA ($14,X)
$9CAC            .byte $0B
$9CAD  09 03     ORA #$03
$9CAF  10 00     BPL L_BRS_($9CB1)_($9CAF) JAM
//------------------------------
L_BRS_($9CB1)_($9CAF) JAM
//------------------------------
$9CB1            .byte $04,$00,$00,$0B,$14,$0B,$03
$9CB8  1E 01 3F  ASL $3F01,X 
$9CBB            .byte $04,$0C,$00
$9CBE  05 0D     ORA $0D
$9CC0  11 12     ORA ($12),Y
$9CC2            .byte $07
$9CC3  0A        ASL A 
$9CC4  C1 24     CMP ($24,X) 
$9CC6  01 3C     ORA ($3C,X)
$9CC8  06 0B     ASL $0B 
$9CCA            .byte $02
$9CCB  06 0C     ASL $0C 
$9CCD  66 99     ROR $99 
$9CCF  CC C0 20  CPY $20C0 
$9CD2  01 0B     ORA ($0B,X)
$9CD4            .byte $00,$00,$00,$07
$9CD8  09 01     ORA #$01
$9CDA  24 02     BIT $02 
$9CDC  3D 06 0A  AND $0A06,X 
$9CDF            .byte $02
$9CE0  08        PHP 
$9CE1            .byte $12
$9CE2  CC B4 06  CPY $06B4 
$9CE5  85 08     STA $08 
$9CE7  84 09     STY $09 
$9CE9            .byte $8F
$9CEA  0D C1 1D  ORA $1DC1
$9CED            .byte $02
$9CEE  3D 06 0A  AND $0A06,X 
$9CF1            .byte $02
$9CF2  09 12     ORA #$12
$9CF4  CC BB B6  CPY $B6BB 
$9CF7  85 09     STA $09 
$9CF9  84 08     STY $08 
$9CFB            .byte $9C
$9CFC  08        PHP 
$9CFD            .byte $07
$9CFE  16 06     ASL $06,X 
$9D00  1E 02 02  ASL $0202,X 
$9D03  08        PHP 
$9D04  0A        ASL A 
$9D05  18        CLC 
$9D06  06 C7     ASL $C7 
$9D08            .byte $03,$00,$02,$00
$9D0C  06 02     ASL $02 
$9D0E  01 1C     ORA ($1C,X)
$9D10            .byte $12
$9D11  A2 0E     LDX #$0E
$9D13            .byte $8F
$9D14  05 0E     ORA $0E
$9D16  18        CLC 
$9D17  05 3F     ORA $3F
$9D19            .byte $03
$9D1A  06 00     ASL $00 
$9D1C            .byte $0B
$9D1D  31 11     AND ($11),Y 
//------------------------------
L_BRS_($9D20)_($9D6D) BAD
//------------------------------
$9D1F  19 0B 3F  ORA $3F0B,Y
$9D22            .byte $1A,$0B,$3F,$1B
$9D26  0A        ASL A 
$9D27            .byte $3F,$1A
$9D29  08        PHP 
$9D2A            .byte $3F
$9D2B  19 08 3F  ORA $3F08,Y
$9D2E  18        CLC 
$9D2F  0A        ASL A 
$9D30            .byte $3F,$1A
$9D32  09 20     ORA #$20
$9D34  05 0B     ORA $0B
$9D36  05 0C     ORA $0C
$9D38  05 0D     ORA $0D
$9D3A            .byte $0F,$0B
$9D3C  01 4C     ORA ($4C,X)
$9D3E  1D 00 22  ORA $2200,X
$9D41  09 A2     ORA #$A2
$9D43  0E 8F 05  ASL $058F 
$9D46            .byte $03
$9D47  19 05 3F  ORA $3F05,Y
$9D4A  01 04     ORA ($04,X)
$9D4C            .byte $00,$0C
$9D4E  0A        ASL A 
$9D4F  11 03     ORA ($03),Y
$9D51  18        CLC 
$9D52            .byte $07,$3F,$03
$9D55  01 00     ORA ($00,X)
$9D57  0D 0A 11  ORA $110A
$9D5A            .byte $00,$00
$9D5C  11 03     ORA ($03),Y
$9D5E            .byte $33
$9D5F  01 05     ORA ($05,X)
$9D61            .byte $00,$07
$9D63  06 08     ASL $08 
$9D65  01 46     ORA ($46,X)
$9D67            .byte $32,$34,$43
$9D6A  C0 80     CPY #$80
$9D6C            .byte $AF
$9D6D  B0 B1     BCS L_BRS_($9D20)_($9D6D) BAD
$9D6F            .byte $B2,$00,$FF
$9D72  0A        ASL A 
$9D73            .byte $AB,$03
$9D75  1D 11 01  ORA $0111,X
$9D78  06 0C     ASL $0C 
$9D7A            .byte $00
$9D7B  01 0D     ORA ($0D,X)
$9D7D  11 12     ORA ($12),Y
$9D7F  06 CB     ASL $CB 
$9D81  01 00     ORA ($00,X)
$9D83            .byte $3F,$00
$9D85  40        RTI 
//------------------------------
$9D86  01 40     ORA ($40,X)
$9D88            .byte $02,$0C,$22
$9D8B  88        DEY 
$9D8C            .byte $33
$9D8D  01 00     ORA ($00,X)
$9D8F  01 00     ORA ($00,X)
$9D91  01 3E     ORA ($3E,X)
$9D93  40        RTI 
//------------------------------
$9D94            .byte $03,$0C,$22,$44,$33
$9D99  01 3F     ORA ($3F,X)
$9D9B  01 00     ORA ($00,X)
$9D9D  01 3E     ORA ($3E,X)
$9D9F  40        RTI 
//------------------------------
$9DA0            .byte $04,$0C,$22,$44,$33
$9DA5  01 01     ORA ($01,X)
$9DA7  01 00     ORA ($00,X)
$9DA9  3E 3E 01  ROL $013E,X 
$9DAC  05 0C     ORA $0C
$9DAE            .byte $22,$44,$44
$9DB1  01 01     ORA ($01,X)
$9DB3  01 3F     ORA ($3F,X)
$9DB5  3E 3E 01  ROL $013E,X 
$9DB8  06 0C     ASL $0C 
$9DBA            .byte $22,$44,$44,$03,$3F
$9DBF  11 1D     ORA ($1D),Y
$9DC1            .byte $00,$0C
$9DC3  06 07     ASL $07 
$9DC5  0D 11 12  ORA $1211
$9DC8            .byte $04
$9DC9  CE C0 20  DEC $20C0 
$9DCC            .byte $22
$9DCD  3D 00 24  AND $2400,X 
$9DD0            .byte $00
$9DD1  08        PHP 
$9DD2  09 01     ORA #$01
$9DD4            .byte $1C
$9DD5  1E 37 08  ASL $0837,X 
$9DD8            .byte $04
$9DD9  08        PHP 
$9DDA  09 0C     ORA #$0C
$9DDC  DD BB 66  CMP $66BB,X 
$9DDF            .byte $03
$9DE0  1D 22 3F  ORA $3F22,X
$9DE3  06 0C     ASL $0C 
$9DE5            .byte $00
$9DE6  0A        ASL A 
$9DE7  0D 11 12  ORA $1211
$9DEA  1D C5 01  ORA $01C5,X
$9DED            .byte $1C
$9DEE  15 01     ORA $01,X
$9DF0  08        PHP 
$9DF1            .byte $04
$9DF2  01 50     ORA ($50,X)
$9DF4  18        CLC 
$9DF5  55 66     EOR $66,X 
$9DF7  99 0E 03  STA $030E,Y 
$9DFA  01 0A     ORA ($0A,X)
$9DFC  20 1C 09  JSR L_JSR_($091C)_($9DFC) OK
$9DFF  05 50     ORA $50
$9E01  08        PHP 
$9E02  06 01     ASL $01 
$9E04            .byte $0C
$9E05  11 19     ORA ($19),Y
$9E07            .byte $22,$00,$04
$9E0A  09 10     ORA #$10
$9E0C  16 11     ASL $11,X 
$9E0E  01 1B     ORA ($1B,X)
$9E10            .byte $2B
$9E11  01 19     ORA ($19,X)
$9E13            .byte $22
$9E14  01 1B     ORA ($1B,X)
$9E16  25 01     AND $01
$9E18  1D 2B 0C  ORA $0C2B,X
$9E1B  01 19     ORA ($19,X)
$9E1D            .byte $2B,$00,$04
$9E20  09 11     ORA #$11
$9E22  16 11     ASL $11,X 
$9E24  01 1B     ORA ($1B,X)
$9E26            .byte $2B
$9E27  01 19     ORA ($19,X)
$9E29            .byte $34
$9E2A  01 1B     ORA ($1B,X)
$9E2C  31 01     AND ($01),Y 
$9E2E  1D 2B 0C  ORA $0C2B,X
$9E31  01 15     ORA ($15,X)
$9E33            .byte $22,$00,$04
$9E36  09 12     ORA #$12
$9E38  16 11     ASL $11,X 
$9E3A  01 17     ORA ($17,X)
$9E3C            .byte $2B
$9E3D  01 19     ORA ($19,X)
$9E3F            .byte $22
$9E40  01 17     ORA ($17,X)
$9E42  25 01     AND $01
$9E44  15 2B     ORA $2B,X
$9E46            .byte $0C
$9E47  01 15     ORA ($15,X)
$9E49            .byte $2B,$00,$04
$9E4C  09 13     ORA #$13
$9E4E  16 11     ASL $11,X 
$9E50  01 17     ORA ($17,X)
$9E52            .byte $2B
$9E53  01 19     ORA ($19,X)
$9E55            .byte $34
$9E56  01 17     ORA ($17,X)
$9E58  31 01     AND ($01),Y 
$9E5A  15 2B     ORA $2B,X
$9E5C  0E 01 17  ASL $1701 
$9E5F  29 00     AND #$00
$9E61            .byte $04,$04,$14,$32
$9E65  99 01 1B  STA $1B01,Y 
$9E68            .byte $2B
$9E69  01 1A     ORA ($1A,X)
$9E6B  2D 01 18  AND $1801 
$9E6E  2D 01 17  AND $1701 
$9E71            .byte $2B
$9E72  01 18     ORA ($18,X)
$9E74  29 01     AND #$01
$9E76            .byte $1A
$9E77  29 85     AND #$85
$9E79            .byte $14,$9C
$9E7B  0E 87 06  ASL $0687 
$9E7E            .byte $0B
$9E7F  88        DEY 
$9E80  06 0C     ASL $0C 
$9E82            .byte $87
$9E83  21 0E     AND ($0E,X) 
$9E85  81 A8     STA ($A8,X) 
$9E87  61 00     ADC ($00,X) 
$9E89  91 06     STA ($06),Y 
$9E8B            .byte $1B
$9E8C  A2 12     LDX #$12
$9E8E            .byte $00,$00,$0C,$04
$9E92  CC 00 05  CPY $0500 
$9E95            .byte $00,$07
$9E97  06 08     ASL $08 
$9E99  01 43     ORA ($43,X)
$9E9B            .byte $33
$9E9C  36 43     ROL $43,X 
$9E9E  C0 80     CPY #$80
$9EA0  81 82     STA ($82,X) 
$9EA2            .byte $83
$9EA3  84 85     STY $85 
$9EA5            .byte $FF
$9EA6  0D A6 A5  ORA $A5A6
$9EA9  A4 A3     LDY $A3 
$9EAB  01 16     ORA ($16,X)
$9EAD  01 16     ORA ($16,X)
$9EAF            .byte $14,$02,$14,$02,$0C,$44
$9EB5  66 CC     ROR $CC 
$9EB7            .byte $03
$9EB8  18        CLC 
$9EB9            .byte $03
$9EBA  18        CLC 
$9EBB  10 00     BPL L_BRS_($9EBD)_($9EBB) OK
//------------------------------
L_BRS_($9EBD)_($9EBB) OK
//------------------------------
$9EBD  10 03     BPL L_BRS_($9EC2)_($9EBD) JAM
$9EBF  0E 33 02  ASL $0233 
//------------------------------
L_BRS_($9EC2)_($9EBD) JAM
//------------------------------
$9EC2            .byte $04,$0F
$9EC4  15 03     ORA $03,X
$9EC6  01 01     ORA ($01,X)
$9EC8            .byte $1C,$00,$0C
$9ECB  06 04     ASL $04 
$9ECD  0D 11 12  ORA $1211
$9ED0            .byte $03
$9ED1  BC 03 1D  LDY $1D03,X 
$9ED4  01 01     ORA ($01,X)
$9ED6  06 0C     ASL $0C 
$9ED8            .byte $00
$9ED9  05 0D     ORA $0D
$9EDB  11 12     ORA ($12),Y
$9EDD            .byte $07,$BF,$07,$1C
$9EE1  01 3E     ORA ($3E,X)
$9EE3  08        PHP 
$9EE4            .byte $0C
$9EE5  01 06     ORA ($06,X)
$9EE7            .byte $14,$6B
$9EE9  60        RTS 
//------------------------------
$9EEA  CC 02 00  CPY $0002 
$9EED  06 01     ASL $01 
$9EEF  A2 0D     LDX #$0D
$9EF1            .byte $8F
$9EF2  05 03     ORA $03
$9EF4            .byte $3F
$9EF5  01 1D     ORA ($1D,X)
$9EF7            .byte $00,$0C
$9EF9  06 0B     ASL $0B 
$9EFB  0D 11 12  ORA $1211
$9EFE  05 C2     ORA $C2
$9F00            .byte $03,$02
$9F02  11 3F     ORA ($3F),Y
$9F04  06 0C     ASL $0C 
$9F06            .byte $00,$0C
$9F08  0D 11 12  ORA $1211
$9F0B  1E C4 01  ASL $01C4,X 
$9F0E  3E 05 1C  ROL $1C05,X 
$9F11  01 04     ORA ($04,X)
$9F13  08        PHP 
$9F14  50 18     BVC L_BRS_($9F2E)_($9F14) OK
$9F16  55 66     EOR $66,X 
$9F18  99 0E 03  STA $030E,Y 
$9F1B  01 0A     ORA ($0A,X)
$9F1D  20 1C 09  JSR L_JSR_($091C)_($9F1D) OK
$9F20  05 50     ORA $50
$9F22  08        PHP 
$9F23  05 50     ORA $50
$9F25            .byte $0B
$9F26  2A        ROL A 
$9F27  0A        ASL A 
//------------------------------
L_BRS_($9F28)_($9F75) JAM
//------------------------------
$9F28            .byte $3F,$0B
$9F2A  08        PHP 
$9F2B            .byte $00
$9F2C  10 19     BPL L_BRS_($9F47)_($9F2C) OK
//------------------------------
L_BRS_($9F2E)_($9F14) OK
//------------------------------
$9F2E  99 2A 0A  STA $0A2A,Y 
$9F31            .byte $3F,$2F,$12,$3F,$34
$9F36  0A        ASL A 
$9F37            .byte $3F,$9E
$9F39  06 A2     ASL $A2 
$9F3B  0D 8F 05  ORA $058F
$9F3E            .byte $C3,$1F
$9F40  01 3F     ORA ($3F,X)
$9F42            .byte $02,$0C,$00
$9F45  01 0D     ORA ($0D,X)
//------------------------------
L_BRS_($9F47)_($9F2C) OK
//------------------------------
$9F47  11 12     ORA ($12),Y
$9F49  16 C5     ASL $C5,X 
$9F4B            .byte $03
$9F4C  2D 04 3F  AND $3F04 
$9F4F            .byte $04
$9F50  06 00     ASL $00 
$9F52  11 10     ORA ($10),Y
$9F54  99 9E 06  STA $069E,Y 
$9F57  A2 0D     LDX #$0D
$9F59            .byte $8F
$9F5A  05 00     ORA $00
$9F5C            .byte $00,$0B
$9F5E  05 D4     ORA $D4
$9F60            .byte $00
$9F61  05 00     ORA $00
$9F63            .byte $07
$9F64  06 08     ASL $08 
$9F66  01 44     ORA ($44,X)
$9F68            .byte $32,$34,$43
$9F6B  C0 80     CPY #$80
$9F6D  81 82     STA ($82,X) 
$9F6F            .byte $83
$9F70  84 85     STY $85 
$9F72            .byte $FF
$9F73  11 AF     ORA ($AF),Y
$9F75  B0 B1     BCS L_BRS_($9F28)_($9F75) JAM
$9F77            .byte $B2,$A7
$9F79  A8        TAY 
$9F7A  A9 AA     LDA #$AA
$9F7C            .byte $03
$9F7D  1D 11 01  ORA $0111,X
$9F80  06 0C     ASL $0C 
$9F82            .byte $00
$9F83  01 0D     ORA ($0D,X)
$9F85  11 12     ORA ($12),Y
$9F87  08        PHP 
$9F88            .byte $CB,$03
$9F8A  01 11     ORA ($11,X)
$9F8C  1D 00 0C  ORA $0C00,X
$9F8F  06 02     ASL $02 
$9F91  0D 11 12  ORA $1211
$9F94            .byte $04
$9F95  C8        INY 
$9F96  06 2A     ASL $2A 
$9F98  01 02     ORA ($02,X)
$9F9A            .byte $04,$07
$9F9C  3D 03 19  AND $1903,X 
$9F9F            .byte $9C,$9C
$9FA1  66 04     ROR $04 
$9FA3            .byte $00,$04
$9FA5  3D 89 03  AND $0389,X 
$9FA8            .byte $8B,$03
$9FAA  06 9C     ASL $9C 
$9FAC  08        PHP 
$9FAD  85 03     STA $03 
$9FAF  01 3C     ORA ($3C,X)
$9FB1  01 1B     ORA ($1B,X)
$9FB3            .byte $03,$0C
$9FB5  0A        ASL A 
$9FB6  09 0C     ORA #$0C
$9FB8  55 CC     EOR $CC,X 
$9FBA  66 03     ROR $03 
$9FBC            .byte $3C
$9FBD  01 1B     ORA ($1B,X)
$9FBF            .byte $03,$0C,$00
$9FC2  0A        ASL A 
$9FC3            .byte $12
$9FC4  06 05     ASL $05 
$9FC6  0A        ASL A 
$9FC7  05 09     ORA $09
$9FC9            .byte $04,$0B,$1C
$9FCC  0D C1 3C  ORA $3CC1
$9FCF  01 23     ORA ($23,X)
$9FD1            .byte $03,$0C
$9FD3  0A        ASL A 
$9FD4            .byte $0B,$0C
$9FD6  55 CC     EOR $CC,X 
$9FD8  66 03     ROR $03 
$9FDA            .byte $3F
$9FDB  01 1D     ORA ($1D,X)
$9FDD            .byte $00,$0C
$9FDF  06 0C     ASL $0C 
$9FE1  0D 11 12  ORA $1211
$9FE4  29 C2     AND #$C2
$9FE6  01 01     ORA ($01,X)
$9FE8  15 1C     ORA $1C,X
$9FEA  01 04     ORA ($04,X)
$9FEC  08        PHP 
$9FED  50 18     BVC L_BRS_($A007)_($9FED) OK
$9FEF  55 66     EOR $66,X 
$9FF1  99 0E 03  STA $030E,Y 
$9FF4  01 0A     ORA ($0A,X)
$9FF6  20 1C 09  JSR L_JSR_($091C)_($9FF6) OK
$9FF9  05 50     ORA $50
$9FFB  08        PHP 
$9FFC            .byte $04
$9FFD  50 0B     BVC L_BRS_($A00A)_($9FFD) JAM
$9FFF            .byte $1A,$17,$3F,$0B
$A003  08        PHP 
$A004            .byte $00
$A005  10 28     BPL L_BRS_($A02F)_($A005) OK
//------------------------------
L_BRS_($A007)_($9FED) OK
//------------------------------
$A007  99 1A 17  STA $171A,Y 
//------------------------------
L_BRS_($A00A)_($9FFD) JAM
//------------------------------
$A00A            .byte $3F,$1F,$1F,$3F
$A00E  24 17     BIT $17 
$A010            .byte $3F
$A011  88        DEY 
$A012            .byte $04
$A013  06 87     ASL $87 
$A015            .byte $04
$A016  01 87     ORA ($87,X)
$A018  16 0F     ASL $0F,X 
$A01A  85 10     STA $10 
$A01C  85 11     STA $11 
$A01E            .byte $9C
$A01F  0E 81 A8  ASL $A881 
$A022  61 00     ADC ($00,X) 
$A024  A2 12     LDX #$12
$A026            .byte $03
$A027  1D 11 3F  ORA $3F11,X
$A02A            .byte $04
//------------------------------
L_BRS_($A02B)_($A0A3) OK
//------------------------------
$A02B  08        PHP 
$A02C            .byte $00
$A02D  11 0A     ORA ($0A),Y
//------------------------------
L_BRS_($A02F)_($A005) OK
//------------------------------
$A02F  99 00 00  STA $0000,Y 
$A032            .byte $1C
$A033  06 35     ASL $35 
$A035            .byte $02
$A036  05 00     ORA $00
$A038            .byte $07
$A039  06 08     ASL $08 
$A03B  01 45     ORA ($45,X)
$A03D            .byte $33
$A03E  36 43     ROL $43,X 
$A040  C0 80     CPY #$80
$A042  81 82     STA ($82,X) 
$A044            .byte $83
$A045  84 85     STY $85 
$A047            .byte $FF
$A048  0D A4 A5  ORA $A5A4
$A04B  A6 A3     LDX $A3 
$A04D            .byte $03,$3F
$A04F  01 38     ORA ($38,X)
$A051            .byte $00,$0C
$A053  06 02     ASL $02 
$A055  0D 11 12  ORA $1211
$A058            .byte $07
$A059  C1 0E     CMP ($0E,X) 
$A05B            .byte $34
$A05C  01 30     ORA ($30,X)
$A05E  08        PHP 
$A05F            .byte $00
$A060  05 03     ORA $03
$A062  2C 11 3A  BIT $3A11 
$A065  01 34     ORA ($34,X)
$A067            .byte $3B
$A068  01 33     ORA ($33,X)
$A06A            .byte $3B
$A06B  01 32     ORA ($32,X)
$A06D            .byte $3A
$A06E  01 31     ORA ($31,X)
$A070  38        SEC 
$A071  01 32     ORA ($32,X)
$A073  38        SEC 
$A074  01 33     ORA ($33,X)
$A076  09 20     ORA #$20
$A078  05 03     ORA $03
$A07A  05 04     ORA $04
$A07C  05 05     ORA $05
$A07E            .byte $0F,$0B,$22
$A081  09 01     ORA #$01
$A083  4C 1D 00  JMP $001D
$A086            .byte $03
$A087  35 01     AND $01,X 
$A089            .byte $32,$04,$00
$A08C  01 04     ORA ($04,X)
$A08E  0A        ASL A 
$A08F  11 03     ORA ($03),Y
$A091            .byte $37
$A092  01 31     ORA ($31,X)
$A094  01 00     ORA ($00,X)
$A096            .byte $03
$A097  05 0A     ORA $0A
$A099  11 01     ORA ($01),Y
$A09B  01 0F     ORA ($0F,X)
$A09D  01 1B     ORA ($1B,X)
$A09F            .byte $02
$A0A0  08        PHP 
$A0A1  06 0C     ASL $0C 
$A0A3  90 86     BCC L_BRS_($A02B)_($A0A3) OK
$A0A5            .byte $80
$A0A6  01 24     ORA ($24,X)
$A0A8            .byte $0F
$A0A9  01 1B     ORA ($1B,X)
$A0AB            .byte $02
$A0AC  08        PHP 
$A0AD            .byte $07,$0C
$A0AF  09 86     ORA #$86
$A0B1            .byte $80
$A0B2  01 01     ORA ($01,X)
$A0B4  01 09     ORA ($09,X)
$A0B6  3E 0F 02  ROL $020F,X 
$A0B9  08        PHP 
$A0BA            .byte $12,$BB
$A0BC  66 CC     ROR $CC 
$A0BE  85 08     STA $08 
$A0C0  84 09     STY $09 
$A0C2            .byte $9C,$0F
$A0C4  C1 01     CMP ($01,X) 
$A0C6  10 09     BPL L_BRS_($A0D1)_($A0C6) BAD
$A0C8  3E 10 02  ROL $0210,X 
$A0CB  09 12     ORA #$12
$A0CD            .byte $44,$77
//------------------------------
L_BRS_($A0D1)_($A0C6) BAD
//------------------------------
$A0CF  CC 85 09  CPY $0985 
$A0D2  84 08     STY $08 
$A0D4            .byte $9C
$A0D5  08        PHP 
$A0D6            .byte $03
$A0D7  1D 01 01  ORA $0101,X
$A0DA  06 0C     ASL $0C 
$A0DC            .byte $00
$A0DD  0A        ASL A 
$A0DE  0D 11 12  ORA $1211
$A0E1  09 BF     ORA #$BF
$A0E3            .byte $C3
$A0E4  01 11     ORA ($11,X)
$A0E6            .byte $3A,$00,$0C,$02,$0B
$A0EB  0D 11 12  ORA $1211
$A0EE  21 C9     AND ($C9,X) 
$A0F0            .byte $07
$A0F1  01 11     ORA ($11,X)
$A0F3            .byte $37
$A0F4  01 0C     ORA ($0C,X)
$A0F6  08        PHP 
$A0F7            .byte $0C,$14
$A0F9  55 90     EOR $90,X 
$A0FB            .byte $00,$00,$02
$A0FE  01 06     ORA ($06,X)
$A100  A2 0D     LDX #$0D
$A102            .byte $8F
$A103  05 03     ORA $03
$A105  01 01     ORA ($01,X)
$A107  1D 00 0C  ORA $0C00,X
$A10A  06 0D     ASL $0D 
$A10C  0D 11 12  ORA $1211
$A10F            .byte $0F
$A110  BC 03 01  LDY $0103,X 
$A113  11 02     ORA ($02),Y
$A115            .byte $00,$0C
$A117  06 0E     ASL $0E 
$A119  0D 11 12  ORA $1211
$A11C  21 C7     AND ($C7,X) 
$A11E            .byte $03,$3F
$A120  11 02     ORA ($02),Y
$A122            .byte $00,$0C
$A124  06 0F     ASL $0F 
$A126  0D 11 12  ORA $1211
$A129            .byte $23,$C3
$A12B  01 34     ORA ($34,X)
$A12D  01 1F     ORA ($1F,X)
$A12F  05 04     ORA $04
$A131  0A        ASL A 
$A132  10 0C     BPL L_BRS_($A140)_($A132) OK
$A134  55 10     EOR $10,X 
$A136            .byte $33,$07,$33
$A139  05 1E     ORA $1E
$A13B            .byte $07
$A13C  01 0C     ORA ($0C,X)
$A13E  11 1C     ORA ($1C),Y
//------------------------------
L_BRS_($A140)_($A132) OK
//------------------------------
$A140  35 35     AND $35,X 
$A142  09 01     ORA #$01
$A144  01 06     ORA ($06,X)
$A146            .byte $0B
$A147  85 11     STA $11 
$A149  84 15     STY $15 
$A14B  84 16     STY $16 
$A14D            .byte $8F
$A14E  11 22     ORA ($22),Y
$A150  10 0F     BPL L_BRS_($A161)_($A150) OK
$A152  05 C5     ORA $C5
$A154  39 04 1E  AND $1E04,Y 
$A157  01 07     ORA ($07,X)
$A159            .byte $0C
$A15A  15 18     ORA $18,X
$A15C  35 35     AND $35,X 
$A15E  99 01 01  STA $0101,Y 
//------------------------------
L_BRS_($A161)_($A150) OK
//------------------------------
$A161  06 0B     ASL $0B 
$A163  85 15     STA $15 
$A165  85 16     STA $16 
$A167  84 11     STY $11 
$A169            .byte $8F
$A16A  11 C1     ORA ($C1),Y
$A16C            .byte $34
$A16D  05 1F     ORA $1F
$A16F  05 05     ORA $05
$A171  0A        ASL A 
$A172  16 1B     ASL $1B,X 
$A174            .byte $00,$00,$00
$A177  09 08     ORA #$08
$A179  01 C4     ORA ($C4,X)
$A17B  09 00     ORA #$00
$A17D            .byte $0F,$14,$0B
$A180  08        PHP 
$A181  0A        ASL A 
$A182  10 16     BPL L_BRS_($A19A)_($A182) OK
$A184            .byte $13,$32,$0C
$A187  01 19     ORA ($19,X)
$A189            .byte $22,$00,$04
$A18C  09 17     ORA #$17
$A18E  16 11     ASL $11,X 
$A190  01 1B     ORA ($1B,X)
$A192            .byte $2B
$A193  01 19     ORA ($19,X)
$A195            .byte $22
$A196  01 1B     ORA ($1B,X)
$A198  25 01     AND $01
//------------------------------
L_BRS_($A19A)_($A182) OK
//------------------------------
$A19A  1D 2B 0C  ORA $0C2B,X
$A19D  01 19     ORA ($19,X)
$A19F            .byte $2B,$00,$04
$A1A2  09 18     ORA #$18
$A1A4  16 11     ASL $11,X 
$A1A6  01 1B     ORA ($1B,X)
$A1A8            .byte $2B
$A1A9  01 19     ORA ($19,X)
$A1AB            .byte $34
$A1AC  01 1B     ORA ($1B,X)
$A1AE  31 01     AND ($01),Y 
$A1B0  1D 2B 0C  ORA $0C2B,X
$A1B3  01 15     ORA ($15,X)
$A1B5            .byte $22,$00,$04
$A1B8  09 19     ORA #$19
$A1BA  16 11     ASL $11,X 
$A1BC  01 17     ORA ($17,X)
$A1BE            .byte $2B
$A1BF  01 19     ORA ($19,X)
$A1C1            .byte $22
$A1C2  01 17     ORA ($17,X)
$A1C4  25 01     AND $01
$A1C6  15 2B     ORA $2B,X
$A1C8            .byte $0C
$A1C9  01 15     ORA ($15,X)
$A1CB            .byte $2B,$00,$04
$A1CE  09 1A     ORA #$1A
$A1D0  16 11     ASL $11,X 
$A1D2  01 17     ORA ($17,X)
$A1D4            .byte $2B
$A1D5  01 19     ORA ($19,X)
$A1D7            .byte $34
$A1D8  01 17     ORA ($17,X)
$A1DA  31 01     AND ($01),Y 
$A1DC  15 2B     ORA $2B,X
$A1DE  0E 01 17  ASL $1701 
$A1E1  29 00     AND #$00
$A1E3            .byte $04,$04,$1B
$A1E6  31 33     AND ($33),Y 
$A1E8  01 1B     ORA ($1B,X)
$A1EA            .byte $2B
$A1EB  01 1A     ORA ($1A,X)
$A1ED  2D 01 18  AND $1801 
$A1F0  2D 01 17  AND $1701 
$A1F3            .byte $2B
$A1F4  01 18     ORA ($18,X)
$A1F6  29 01     AND #$01
$A1F8            .byte $1A
$A1F9  29 85     AND #$85
$A1FB            .byte $17
$A1FC  85 18     STA $18 
$A1FE  85 19     STA $19 
$A200  85 1A     STA $1A 
$A202  85 1B     STA $1B 
$A204  84 1C     STY $1C 
$A206  84 1D     STY $1D 
$A208            .byte $9C,$0F,$A3
$A20B  01 9A     ORA ($9A,X)
$A20D  A2 0D     LDX #$0D
$A20F  CD 01 16  CMP $1601 
$A212            .byte $22,$00
$A214  06 09     ASL $09 
$A216            .byte $1C
$A217  19 11 01  ORA $0111,Y
$A21A            .byte $1C,$2B
$A21C  01 16     ORA ($16,X)
$A21E            .byte $2B
$A21F  01 17     ORA ($17,X)
$A221  26 01     ROL $01 
$A223  19 22 01  ORA $0122,Y
$A226            .byte $1B
$A227  26 CD     ROL $CD 
$A229  01 16     ORA ($16,X)
$A22B            .byte $2B,$00
$A22D  06 09     ASL $09 
$A22F  1D 19 11  ORA $1119,X
$A232  01 1C     ORA ($1C,X)
$A234            .byte $2B
$A235  01 16     ORA ($16,X)
$A237            .byte $2B
$A238  01 17     ORA ($17,X)
$A23A  30 01     BMI L_BRS_($A23D)_($A23A) BAD
//------------------------------
L_BRS_($A23D)_($A23A) BAD
//------------------------------
$A23C  19 34 01  ORA $0134,Y
$A23F            .byte $1B
$A240  30 03     BMI L_BRS_($A245)_($A240) OK
$A242  1D 01 3F  ORA $3F01,X
//------------------------------
L_BRS_($A245)_($A240) OK
//------------------------------
$A245  06 0C     ASL $0C 
$A247            .byte $00
$A248  1E 0D 11  ASL $110D,X 
$A24B            .byte $12,$03
$A24D  B9 01 1C  LDA $1C01,Y 
$A250  05 3E     ORA $3E
$A252  08        PHP 
$A253            .byte $04
$A254  01 01     ORA ($01,X)
$A256  18        CLC 
$A257  55 66     EOR $66,X 
$A259  99 0E 03  STA $030E,Y 
$A25C  01 0A     ORA ($0A,X)
$A25E  20 1C 09  JSR L_JSR_($091C)_($A25E) OK
$A261  05 01     ORA $01
$A263  08        PHP 
$A264            .byte $03
$A265  50 01     BVC L_BRS_($A268)_($A265) JAM
//------------------------------
L_BRS_($A268)_($A265) JAM
//------------------------------
$A267            .byte $14,$9F,$17
$A26A  84 18     STY $18 
$A26C  84 19     STY $19 
$A26E  84 1A     STY $1A 
$A270  84 1B     STY $1B 
$A272  85 1C     STA $1C 
$A274  85 1D     STA $1D 
$A276  84 17     STY $17 
$A278            .byte $9C
$A279  05 A3     ORA $A3
$A27B            .byte $00,$00
$A27D  11 07     ORA ($07),Y
$A27F            .byte $37
$A280  01 05     ORA ($05,X)
$A282            .byte $00,$07
$A284  06 08     ASL $08 
$A286  01 42     ORA ($42,X)
$A288            .byte $32,$34,$43
$A28B  C0 81     CPY #$81
$A28D  81 82     STA ($82,X) 
$A28F            .byte $83
$A290  84 85     STY $85 
$A292            .byte $FF,$12
$A294  A0 A1     LDY #$A1
$A296  A2 A3     LDX #$A3
$A298            .byte $8B
$A299  8C 8D 8E  STY $8E8D 
$A29C            .byte $AB,$03
$A29E  1D 11 3F  ORA $3F11,X
$A2A1  06 0C     ASL $0C 
$A2A3            .byte $00
$A2A4  01 0D     ORA ($0D,X)
$A2A6  11 12     ORA ($12),Y
$A2A8            .byte $04
$A2A9  C5 03     CMP $03 
$A2AB  2C 01 01  BIT $0101 
//------------------------------
L_BRS_($A2AE)_($A313) JAM
//------------------------------
$A2AE            .byte $04,$0C,$00,$02
$A2B2  0D 11 12  ORA $1211
$A2B5            .byte $02,$CB,$03
$A2B8  1D 11 01  ORA $0111,X
$A2BB  06 0C     ASL $0C 
$A2BD            .byte $00,$03
$A2BF  0D 11 12  ORA $1211
$A2C2  0A        ASL A 
$A2C3            .byte $CB
$A2C4  01 1D     ORA ($1D,X)
$A2C6  10 01     BPL L_BRS_($A2C9)_($A2C6) BAD
//------------------------------
L_BRS_($A2C9)_($A2C6) BAD
//------------------------------
$A2C8  06 01     ASL $01 
$A2CA  3E 04 10  ROL $1004,X 
$A2CD  99 55 66  STA $6655,Y 
$A2D0  85 04     STA $04 
$A2D2            .byte $9C
$A2D3  08        PHP 
$A2D4            .byte $03
$A2D5  01 11     ORA ($11,X)
$A2D7  38        SEC 
$A2D8            .byte $00,$0C
$A2DA  06 05     ASL $05 
$A2DC  0D 11 12  ORA $1211
$A2DF  06 CA     ASL $CA 
$A2E1  01 38     ORA ($38,X)
$A2E3  01 30     ORA ($30,X)
$A2E5            .byte $04,$04,$04
$A2E8  06 1D     ASL $1D 
$A2EA  66 CC     ROR $CC 
$A2EC  99 83 AC  STA $AC83,Y 
$A2EF            .byte $9C,$0F
$A2F1  9A        TXS 
$A2F2            .byte $83
$A2F3  AD 9C 0F  LDA $0F9C 
$A2F6  9A        TXS 
$A2F7            .byte $83
$A2F8  AE 9C 0F  LDX $0F9C 
$A2FB  9A        TXS 
$A2FC  9D 02 03  STA $0302,X 
$A2FF            .byte $3F
$A300  11 1D     ORA ($1D),Y
$A302            .byte $00,$0B
$A304  06 07     ASL $07 
$A306  0D 11 12  ORA $1211
$A309  08        PHP 
$A30A  CE 01 01  DEC $0101 
$A30D  05 11     ORA $11
$A30F  08        PHP 
$A310  0D 01 08  ORA $0801
$A313  10 99     BPL L_BRS_($A2AE)_($A313) JAM
$A315            .byte $FF
$A316  55 90     EOR $90,X 
$A318  08        PHP 
$A319            .byte $9C
$A31A  08        PHP 
$A31B            .byte $03,$02
$A31D  11 01     ORA ($01),Y
$A31F  06 0B     ASL $0B 
$A321            .byte $00
$A322  09 0D     ORA #$0D
$A324  11 12     ORA ($12),Y
$A326  0A        ASL A 
$A327  CC C0 2E  CPY $2EC0 
$A32A  01 03     ORA ($03,X)
$A32C            .byte $00,$00,$00
$A32F  0A        ASL A 
$A330  09 03     ORA #$03
$A332            .byte $2B
$A333  01 1C     ORA ($1C,X)
$A335  10 00     BPL L_BRS_($A337)_($A335) OK
//------------------------------
L_BRS_($A337)_($A335) OK
//------------------------------
$A337  08        PHP 
$A338            .byte $0B,$12
$A33A  88        DEY 
$A33B  1E 06 05  ASL $0506,X 
$A33E  06 1C     ASL $1C 
$A340  15 23     ORA $23,X
$A342            .byte $00
$A343  01 00     ORA ($00,X)
$A345            .byte $00,$00
$A347  40        RTI 
//------------------------------
$A348  01 40     ORA ($40,X)
$A34A            .byte $0C,$14,$22
$A34D  88        DEY 
$A34E            .byte $33,$1F
$A350  06 04     ASL $04 
$A352  06 1C     ASL $1C 
$A354  15 23     ORA $23,X
$A356            .byte $00,$07
$A358  2E 01 37  ROL $3701 
$A35B  05 06     ORA $06
$A35D  05 0D     ORA $0D
$A35F  16 53     ASL $53,X 
$A361            .byte $53,$00,$02,$02,$03,$03,$0F,$13
$A369  A2 0E     LDX #$0E
$A36B            .byte $8F
$A36C  05 06     ORA $06
$A36E  2E 07 37  ROL $3707 
$A371  05 01     ORA $01
$A373  05 0E     ORA $0E
$A375            .byte $33
$A376  35 35     AND $35,X 
$A378  10 01     BPL L_BRS_($A37B)_($A378) BAD
//------------------------------
L_BRS_($A37B)_($A378) BAD
//------------------------------
$A37A  01 04     ORA ($04,X)
$A37C            .byte $04,$1C,$14
$A37F  01 C4     ORA ($C4,X)
$A381  09 00     ORA #$00
$A383  09 02     ORA #$02
$A385            .byte $0B,$02
$A387  06 05     ASL $05 
$A389  0E 05 0D  ASL $0D05 
$A38C            .byte $1C
$A38D  08        PHP 
$A38E            .byte $13,$32,$00,$00,$00,$00,$00,$00
$A396            .byte $00,$00,$00,$00,$00,$00,$00,$00
$A39E            .byte $00
$A39F  4D 03 1B  EOR $1B03 
$A3A2            .byte $1F,$1B
$A3A4  0A        ASL A 
$A3A5            .byte $00
$A3A6  0A        ASL A 
$A3A7  16 0A     ASL $0A,X 
$A3A9  11 C0     ORA ($C0),Y
$A3AB  20 11 20  JSR L_JSR_($2011)_($A3AB) BAD
$A3AE            .byte $00,$00,$00,$17
$A3B2  09 01     ORA #$01
$A3B4            .byte $0B
$A3B5  0E 02 01  ASL $0102 
$A3B8            .byte $1F
$A3B9  AC 04 AC  LDY $AC04 
$A3BC            .byte $04
$A3BD  AD 04 AE  LDA $AE04 
$A3C0            .byte $00,$12
$A3C2  08        PHP 
$A3C3  66 01     ROR $01 
$A3C5  05 00     ORA $00
$A3C7            .byte $07
$A3C8  06 08     ASL $08 
$A3CA  01 47     ORA ($47,X)
$A3CC            .byte $33
$A3CD  36 43     ROL $43,X 
$A3CF  C0 80     CPY #$80
$A3D1  8A        TXA 
$A3D2            .byte $82,$83
$A3D4  84 85     STY $85 
$A3D6            .byte $FF
$A3D7  09 03     ORA #$03
$A3D9  1D 01 3F  ORA $3F01,X
$A3DC  06 0C     ASL $0C 
$A3DE            .byte $00
$A3DF  01 0D     ORA ($0D,X)
$A3E1  11 12     ORA ($12),Y
$A3E3  05 B9     ORA $B9
$A3E5            .byte $03
$A3E6  01 01     ORA ($01,X)
$A3E8  1D 00 0C  ORA $0C00,X
$A3EB  06 02     ASL $02 
$A3ED  0D 11 12  ORA $1211
$A3F0            .byte $07
$A3F1  BC 03 02  LDY $0203,X 
$A3F4  01 01     ORA ($01,X)
$A3F6  06 0C     ASL $0C 
$A3F8            .byte $00,$04
$A3FA  0D 11 12  ORA $1211
$A3FD            .byte $0B
$A3FE  C0 01     CPY #$01
$A400  01 06     ORA ($06,X)
$A402  39 3E 04  AND $043E,Y 
$A405            .byte $02
$A406  05 15     ORA $15
$A408            .byte $00
$A409  66 CC     ROR $CC 
$A40B  85 05     STA $05 
$A40D            .byte $9C,$0F
$A40F  9A        TXS 
$A410  84 05     STY $05 
$A412            .byte $9C,$0F
$A414  01 37     ORA ($37,X)
$A416  01 2A     ORA ($2A,X)
$A418  05 06     ORA $06
$A41A            .byte $0C
$A41B  06 1F     ASL $1F 
$A41D  55 10     EOR $10,X 
$A41F            .byte $33,$1F,$07,$0F,$14
$A424  01 C4     ORA ($C4,X)
$A426  09 00     ORA #$00
$A428  09 0B     ORA #$0B
$A42A            .byte $0B,$0B,$1A
$A42D  05 06     ORA $06
$A42F            .byte $13,$32,$1C
$A432  08        PHP 
$A433            .byte $07
$A434  36 07     ROL $07,X 
$A436  29 07     AND #$07
$A438  01 0E     ORA ($0E,X)
$A43A            .byte $07
$A43B  18        CLC 
$A43C  35 35     AND $35,X 
$A43E  99 01 01  STA $0101,Y 
$A441  06 0D     ASL $0D 
$A443  90 07     BCC L_BRS_($A44C)_($A443) OK
$A445            .byte $9C
$A446  08        PHP 
$A447            .byte $22
$A448  10 0F     BPL L_BRS_($A459)_($A448) JAM
$A44A  05 07     ORA $07
//------------------------------
L_BRS_($A44C)_($A443) OK
//------------------------------
$A44C  3D 06 07  AND $0706,X 
$A44F            .byte $02,$02
$A451  08        PHP 
$A452  08        PHP 
$A453  18        CLC 
$A454  6C 6C 33  JMP ($336C) 
//------------------------------
L_BRS_($A459)_($A448) JAM
//------------------------------
$A457            .byte $02,$02,$02
$A45A  06 02     ASL $02 
$A45C  01 1C     ORA ($1C,X)
$A45E            .byte $12
$A45F  85 08     STA $08 
$A461            .byte $9C
$A462  05 C6     ORA $C6
//------------------------------
L_BRS_($A464)_($A49B) OK
//------------------------------
$A464  3D 09 1B  AND $1B09,X 
$A467  01 03     ORA ($03,X)
$A469  06 11     ASL $11 
$A46B  20 7C 7C  JSR L_JSR_($7C7C)_($A46B) BAD
$A46E  30 00     BMI L_BRS_($A470)_($A46E) JAM
//------------------------------
L_BRS_($A470)_($A46E) JAM
//------------------------------
$A470            .byte $02
$A471  01 04     ORA ($04,X)
$A473  85 11     STA $11 
$A475  85 14     STA $14 
$A477  84 13     STY $13 
$A479  84 16     STY $16 
$A47B  84 17     STY $17 
$A47D  84 18     STY $18 
$A47F  84 19     STY $19 
$A481            .byte $8F
$A482  11 06     ORA ($06),Y
$A484  3E 09 1B  ROL $1B09,X 
$A487  01 03     ORA ($03,X)
$A489  06 12     ASL $12 
$A48B  10 6C     BPL L_BRS_($A4F9)_($A48B) OK
$A48D  6C 90 00  JMP ($0090) 
$A490            .byte $02
$A491  01 04     ORA ($04,X)
$A493  06 38     ASL $38 
$A495  09 21     ORA #$21
$A497  06 03     ASL $03 
$A499  01 13     ORA ($13,X)
$A49B  10 C7     BPL L_BRS_($A464)_($A49B) OK
$A49D            .byte $C7
$A49E  30 02     BMI L_BRS_($A4A2)_($A49E) OK
$A4A0            .byte $00,$04
//------------------------------
L_BRS_($A4A2)_($A49E) OK
//------------------------------
$A4A2  01 C7     ORA ($C7,X)
//------------------------------
L_BRS_($A4A4)_($A4DB) OK
//------------------------------
$A4A4  3D 01 1B  AND $1B01,X 
$A4A7  01 08     ORA ($08,X)
$A4A9  06 14     ASL $14 
$A4AB  20 7C 7C  JSR L_JSR_($7C7C)_($A4AB) BAD
$A4AE  50 00     BVC L_BRS_($A4B0)_($A4AE) OK
//------------------------------
L_BRS_($A4B0)_($A4AE) OK
//------------------------------
$A4B0  01 01     ORA ($01,X)
$A4B2  05 85     ORA $85
$A4B4  11 85     ORA ($85),Y
$A4B6            .byte $14
$A4B7  84 13     STY $13 
$A4B9  84 16     STY $16 
$A4BB  84 17     STY $17 
$A4BD  84 18     STY $18 
$A4BF  84 19     STY $19 
//------------------------------
L_BRS_($A4C2)_($A507) JAM
//------------------------------
$A4C1            .byte $00,$00,$07
$A4C4  3E 01 1B  ROL $1B01,X 
$A4C7  01 08     ORA ($08,X)
$A4C9  06 15     ASL $15 
$A4CB  10 6C     BPL L_BRS_($A539)_($A4CB) BAD
$A4CD  6C 50 00  JMP ($0050) 
$A4D0  01 01     ORA ($01,X)
$A4D2  05 07     ORA $07
$A4D4  38        SEC 
$A4D5  01 21     ORA ($21,X)
$A4D7  06 08     ASL $08 
$A4D9  01 16     ORA ($16,X)
$A4DB  10 C7     BPL L_BRS_($A4A4)_($A4DB) OK
$A4DD            .byte $C7
$A4DE  50 01     BVC L_BRS_($A4E1)_($A4DE) OK
$A4E0            .byte $00
//------------------------------
L_BRS_($A4E1)_($A4DE) OK
//------------------------------
$A4E1  05 01     ORA $01
$A4E3  01 3C     ORA ($3C,X)
$A4E5  09 1D     ORA #$1D
$A4E7  01 02     ORA ($02,X)
$A4E9            .byte $02,$17,$1C,$BB
$A4ED  88        DEY 
$A4EE  99 85 17  STA $1785,Y 
$A4F1  85 18     STA $18 
$A4F3  85 13     STA $13 
$A4F5  85 16     STA $16 
$A4F7  85 19     STA $19 
//------------------------------
L_BRS_($A4F9)_($A48B) OK
//------------------------------
$A4F9  84 11     STY $11 
$A4FB  84 14     STY $14 
$A4FD            .byte $8F
$A4FE  11 07     ORA ($07),Y
$A500            .byte $3C
$A501  01 1C     ORA ($1C,X)
$A503  01 08     ORA ($08,X)
$A505            .byte $04
$A506  18        CLC 
$A507  10 B9     BPL L_BRS_($A4C2)_($A507) JAM
$A509  B9 CC 00  LDA $00CC,Y 
$A50C  01 01     ORA ($01,X)
$A50E            .byte $03,$02,$3C
$A511  0A        ASL A 
$A512  1E 00 00  ASL $0000,X 
$A515            .byte $00
$A516  19 0E 11  ORA $110E,Y
$A519  FE 80 28  INC $2880,X 
$A51C  01 C0     ORA ($C0,X)
$A51E            .byte $04
$A51F  01 03     ORA ($03,X)
$A521            .byte $00,$00,$00,$1A
$A525  09 00     ORA #$00
$A527            .byte $00,$0C
$A529  09 0F     ORA #$0F
$A52B  01 05     ORA ($05,X)
$A52D            .byte $00,$07
$A52F  06 08     ASL $08 
$A531  01 48     ORA ($48,X)
$A533            .byte $32,$34,$43
$A536  C0 80     CPY #$80
//------------------------------
L_BRS_($A539)_($A4CB) BAD
//------------------------------
$A538  81 82     STA ($82,X) 
$A53A            .byte $83
$A53B  84 85     STY $85 
$A53D            .byte $FF
$A53E  15 95     ORA $95,X
$A540  96 97     STX $97,Y 
$A542  98        TYA 
$A543            .byte $A7
$A544  A8        TAY 
$A545  A9 AA     LDA #$AA
$A547            .byte $B3
$A548  B4 B5     LDY $B5,X 
$A54A  B6 03     LDX $03,Y 
$A54C  1D 11 3F  ORA $3F11,X
$A54F  06 0C     ASL $0C 
$A551            .byte $00
$A552  01 0D     ORA ($0D,X)
$A554  11 12     ORA ($12),Y
$A556  06 C5     ASL $C5 
$A558            .byte $03,$3F
$A55A  11 02     ORA ($02),Y
$A55C            .byte $00,$0C
$A55E  06 03     ASL $03 
$A560  0D 11 12  ORA $1211
$A563  0A        ASL A 
$A564            .byte $C3,$03
$A566  01 11     ORA ($11,X)
$A568  1D 00 0C  ORA $0C00,X
$A56B  06 04     ASL $04 
$A56D  0D 11 12  ORA $1211
$A570  11 C8     ORA ($C8),Y
$A572  0E 19 01  ASL $0119 
$A575  15 03     ORA $03,X
$A577            .byte $00,$02
$A579  06 1C     ASL $1C 
$A57B  55 1B     EOR $1B,X 
$A57D  01 14     ORA ($14,X)
$A57F            .byte $1A
$A580  01 16     ORA ($16,X)
$A582  1D 01 18  ORA $1801,X
$A585  1E 01 17  ASL $1701,X 
$A588            .byte $1C
$A589  01 14     ORA ($14,X)
$A58B            .byte $1B
$A58C  01 14     ORA ($14,X)
$A58E  0E 19 01  ASL $0119 
$A591  0E 00 00  ASL $0000 
$A594            .byte $00,$07,$1C
$A597  55 1A     EOR $1A,X 
$A599  01 0F     ORA ($0F,X)
$A59B            .byte $1A
$A59C  01 10     ORA ($10,X)
$A59E  1D 01 12  ORA $1201,X
$A5A1  1E 01 11  ASL $1101,X 
$A5A4            .byte $1C
$A5A5  01 0E     ORA ($0E,X)
$A5A7            .byte $1A
$A5A8  01 0F     ORA ($0F,X)
$A5AA  0E 13 01  ASL $0113 
$A5AD  0E 00 00  ASL $0000 
$A5B0            .byte $00
$A5B1  08        PHP 
$A5B2            .byte $1C
$A5B3  55 15     EOR $15,X 
$A5B5  01 0E     ORA ($0E,X)
$A5B7            .byte $14
$A5B8  01 10     ORA ($10,X)
$A5BA            .byte $17
$A5BB  01 12     ORA ($12,X)
$A5BD  18        CLC 
$A5BE  01 11     ORA ($11,X)
$A5C0  16 01     ASL $01,X 
$A5C2  0E 15 01  ASL $0115 
$A5C5  0E 0E 13  ASL $130E 
$A5C8  01 08     ORA ($08,X)
$A5CA            .byte $00,$00,$00
$A5CD  09 1C     ORA #$1C
$A5CF  55 14     EOR $14,X 
$A5D1  01 09     ORA ($09,X)
$A5D3            .byte $14
$A5D4  01 0A     ORA ($0A,X)
$A5D6            .byte $17
$A5D7  01 0C     ORA ($0C,X)
$A5D9  18        CLC 
$A5DA  01 0B     ORA ($0B,X)
$A5DC  16 01     ASL $01,X 
$A5DE  08        PHP 
$A5DF            .byte $14
$A5E0  01 09     ORA ($09,X)
$A5E2            .byte $03
$A5E3  01 01     ORA ($01,X)
$A5E5            .byte $02,$00,$0C
$A5E8  06 0A     ASL $0A 
$A5EA  0D 11 12  ORA $1211
$A5ED            .byte $34,$C7
$A5EF  01 15     ORA ($15,X)
$A5F1  01 01     ORA ($01,X)
$A5F3  01 1F     ORA ($1F,X)
$A5F5  3E 0B 17  ROL $170B,X 
$A5F8  99 44 33  STA $3344,Y 
$A5FB            .byte $1C,$03
$A5FD  09 07     ORA #$07
$A5FF            .byte $0B,$07,$03
$A602  05 0B     ORA $0B
$A604            .byte $1C
$A605  08        PHP 
$A606  01 01     ORA ($01,X)
$A608  15 1C     ORA $1C,X
$A60A  01 04     ORA ($04,X)
$A60C  08        PHP 
$A60D  50 18     BVC L_BRS_($A627)_($A60D) OK
$A60F  55 66     EOR $66,X 
$A611  99 0E 03  STA $030E,Y 
$A614  01 0A     ORA ($0A,X)
$A616  20 1C 09  JSR L_JSR_($091C)_($A616) OK
$A619  05 50     ORA $50
$A61B  08        PHP 
$A61C  11 50     ORA ($50),Y
$A61E  01 3E     ORA ($3E,X)
$A620  15 01     ORA $01,X
$A622  01 04     ORA ($04,X)
$A624  08        PHP 
$A625  51 18     EOR ($18),Y 
//------------------------------
L_BRS_($A627)_($A60D) OK
//------------------------------
$A627  55 66     EOR $66,X 
$A629  99 0E 03  STA $030E,Y 
$A62C  01 0A     ORA ($0A,X)
$A62E  20 1C 09  JSR L_JSR_($091C)_($A62E) OK
$A631  05 51     ORA $51
$A633  08        PHP 
$A634  0A        ASL A 
$A635  50 00     BVC L_BRS_($A637)_($A635) JAM
//------------------------------
L_BRS_($A637)_($A635) JAM
//------------------------------
$A637            .byte $00
$A638  0E 0A 13  ASL $130A 
$A63B  01 05     ORA ($05,X)
$A63D            .byte $00,$07
$A63F  06 08     ASL $08 
$A641  01 49     ORA ($49,X)
$A643            .byte $33
$A644  36 43     ROL $43,X 
$A646  C0 80     CPY #$80
$A648  81 82     STA ($82,X) 
$A64A            .byte $83
$A64B  84 85     STY $85 
$A64D            .byte $FF
$A64E  11 99     ORA ($99),Y
$A650  9A        TXS 
$A651            .byte $9B,$9C,$92,$8B
$A655  A0 AA     LDY #$AA
$A657            .byte $03
$A658  1D 01 3F  ORA $3F01,X
$A65B  06 0C     ASL $0C 
$A65D            .byte $00
$A65E  01 0D     ORA ($0D,X)
$A660  11 12     ORA ($12),Y
$A662            .byte $07
$A663  B9 03 38  LDA $3803,Y 
$A666  11 3F     ORA ($3F),Y
$A668  06 0C     ASL $0C 
$A66A            .byte $00,$02
$A66C  0D 11 12  ORA $1211
$A66F            .byte $23
$A670  C6 03     DEC $03 
$A672            .byte $02
$A673  01 3F     ORA ($3F,X)
$A675  06 0C     ASL $0C 
$A677            .byte $00,$03
$A679  0D 11 12  ORA $1211
$A67C            .byte $07,$B8,$03
$A67F  01 01     ORA ($01,X)
$A681            .byte $02,$00,$0C
$A684  06 04     ASL $04 
$A686  0D 11 12  ORA $1211
$A689  09 BB     ORA #$BB
$A68B  01 1A     ORA ($1A,X)
$A68D  15 1C     ORA $1C,X
$A68F            .byte $0C,$04
$A691  05 06     ORA $06
$A693            .byte $0C
$A694  55 11     EOR $11,X 
$A696            .byte $33,$07
$A698  19 19 1B  ORA $1B19,Y
$A69B  0E 01 07  ASL $0701 
$A69E            .byte $07
$A69F  10 35     BPL L_BRS_($A6D6)_($A69F) JAM
$A6A1  35 0B     AND $0B,X 
$A6A3  01 01     ORA ($01,X)
$A6A5  0D 06 01  ORA $0106
$A6A8            .byte $1F
$A6A9  01 1E     ORA ($1E,X)
$A6AB            .byte $02,$14
$A6AD  01 08     ORA ($08,X)
$A6AF            .byte $27
$A6B0  55 00     EOR $00,X 
$A6B2  99 05 08  STA $0805,Y 
$A6B5  05 06     ORA $06
$A6B7  05 07     ORA $07
$A6B9            .byte $04
$A6BA  09 04     ORA #$04
$A6BC  0A        ASL A 
$A6BD            .byte $89
$A6BE  01 8B     ORA ($8B,X)
$A6C0  01 16     ORA ($16,X)
$A6C2  85 08     STA $08 
$A6C4  85 06     STA $06 
$A6C6  85 07     STA $07 
$A6C8  84 09     STY $09 
$A6CA  84 0A     STY $0A 
$A6CC            .byte $9C
$A6CD  08        PHP 
$A6CE  C1 1A     CMP ($1A,X) 
$A6D0  01 1C     ORA ($1C,X)
$A6D2            .byte $0C,$04
$A6D4  05 09     ORA $09
//------------------------------
L_BRS_($A6D6)_($A69F) JAM
//------------------------------
$A6D6            .byte $0C
$A6D7  55 10     EOR $10,X 
$A6D9            .byte $33,$C7
$A6DB  19 05 1B  ORA $1B05,Y
$A6DE  0E 01 07  ASL $0701 
$A6E1  0A        ASL A 
$A6E2  18        CLC 
$A6E3  35 35     AND $35,X 
$A6E5  09 01     ORA #$01
$A6E7  01 0D     ORA ($0D,X)
$A6E9  06 85     ASL $85 
$A6EB  0A        ASL A 
$A6EC  84 0C     STY $0C 
$A6EE  84 0D     STY $0D 
$A6F0            .byte $8F
$A6F1  11 03     ORA ($03),Y
$A6F3            .byte $3F
$A6F4  01 02     ORA ($02,X)
$A6F6            .byte $00,$0C
//------------------------------
L_BRS_($A6F9)_($A766) BAD
//------------------------------
$A6F8  06 0B     ASL $0B 
$A6FA  0D 11 12  ORA $1211
$A6FD            .byte $0B,$B7
$A6FF  01 01     ORA ($01,X)
$A701  05 01     ORA $01
$A703  01 04     ORA ($04,X)
$A705  08        PHP 
$A706  50 18     BVC L_BRS_($A720)_($A706) JAM
$A708  55 66     EOR $66,X 
$A70A  99 0E 03  STA $030E,Y 
$A70D  01 0A     ORA ($0A,X)
$A70F  20 1C 09  JSR L_JSR_($091C)_($A70F) OK
$A712  05 50     ORA $50
$A714  08        PHP 
$A715  09 51     ORA #$51
$A717  C1 1A     CMP ($1A,X) 
$A719  05 1C     ORA $1C
$A71B            .byte $0C,$04
$A71D  05 0D     ORA $0D
//------------------------------
L_BRS_($A720)_($A706) JAM
//------------------------------
$A71F            .byte $1B,$00,$00,$00
$A723  09 09     ORA #$09
$A725            .byte $0F,$14
$A727  01 C4     ORA ($C4,X)
$A729  09 00     ORA #$00
$A72B            .byte $0B
$A72C  09 10     ORA #$10
$A72E  10 0D     BPL L_BRS_($A73D)_($A72E) OK
$A730            .byte $13,$32
$A732  C9 19     CMP #$19
$A734            .byte $04
$A735  21 0E     AND ($0E,X) 
$A737            .byte $07
$A738  01 0C     ORA ($0C,X)
$A73A  18        CLC 
$A73B  35 35     AND $35,X 
//------------------------------
L_BRS_($A73D)_($A72E) OK
//------------------------------
$A73D  99 01 01  STA $0101,Y 
$A740  0D 06 85  ORA $8506
$A743            .byte $0C
$A744  84 0A     STY $0A 
$A746            .byte $8F
$A747  11 85     ORA ($85),Y
$A749  0D 00 00  ORA $0000
$A74C  09 0B     ORA #$0B
$A74E            .byte $A3,$00
$A750  05 00     ORA $00
$A752            .byte $07
$A753  06 08     ASL $08 
$A755  01 4A     ORA ($4A,X)
$A757            .byte $32,$34,$43
$A75A  C0 80     CPY #$80
//------------------------------
L_BRS_($A75C)_($A77D) OK
//------------------------------
$A75C  81 82     STA ($82,X) 
$A75E  86 84     STX $84 
$A760  85 FF     STA $FF 
$A762  0E A3 8E  ASL $8EA3 
$A765            .byte $8F
$A766  90 91     BCC L_BRS_($A6F9)_($A766) BAD
$A768            .byte $03,$02
$A76A  11 3F     ORA ($3F),Y
//------------------------------
L_BRS_($A76C)_($A78D) OK
//------------------------------
$A76C  06 0C     ASL $0C 
$A76E            .byte $00
$A76F  01 0D     ORA ($0D,X)
$A771  11 12     ORA ($12),Y
$A773  08        PHP 
$A774            .byte $1A
$A775  01 06     ORA ($06,X)
$A777  09 33     ORA #$33
$A779            .byte $03,$04,$04,$02
$A77D  10 DD     BPL L_BRS_($A75C)_($A77D) OK
$A77F            .byte $BB,$77
$A781  85 02     STA $02 
$A783            .byte $9C
$A784  08        PHP 
$A785  01 01     ORA ($01,X)
$A787  05 2F     ORA $2F
$A789  08        PHP 
$A78A            .byte $04,$04,$03
$A78D  10 DD     BPL L_BRS_($A76C)_($A78D) OK
$A78F            .byte $BB
$A790  66 85     ROR $85 
$A792            .byte $03,$9C
$A794  08        PHP 
$A795  01 01     ORA ($01,X)
$A797  01 2B     ORA ($2B,X)
$A799            .byte $03,$04,$04,$04,$0C
$A79E  DD BB 77  CMP $77BB,X 
$A7A1            .byte $03
$A7A2  01 11     ORA ($11,X)
$A7A4            .byte $02,$00,$0C
$A7A7  06 05     ASL $05 
$A7A9  0D 11 12  ORA $1211
$A7AC  0A        ASL A 
$A7AD            .byte $C7,$03
$A7AF  05 01     ORA $01
$A7B1            .byte $02
$A7B2  01 00     ORA ($00,X)
$A7B4            .byte $04,$07
$A7B6  0A        ASL A 
$A7B7  11 03     ORA ($03),Y
$A7B9            .byte $04
$A7BA  01 04     ORA ($04,X)
$A7BC            .byte $03,$00
$A7BE  01 08     ORA ($08,X)
$A7C0  0A        ASL A 
$A7C1  11 0E     ORA ($0E),Y
$A7C3            .byte $03
$A7C4  01 01     ORA ($01,X)
$A7C6  05 00     ORA $00
$A7C8  08        PHP 
$A7C9  06 2C     ASL $2C 
$A7CB  11 05     ORA ($05),Y
$A7CD  01 05     ORA ($05,X)
$A7CF            .byte $04
$A7D0  01 07     ORA ($07,X)
$A7D2  05 01     ORA $01
$A7D4  08        PHP 
$A7D5  06 01     ASL $01 
$A7D7  08        PHP 
$A7D8            .byte $07
$A7D9  01 07     ORA ($07,X)
$A7DB  06 01     ASL $01 
$A7DD  05 05     ORA $05
$A7DF  06 05     ASL $05 
$A7E1            .byte $07
$A7E2  05 08     ORA $08
$A7E4  09 20     ORA #$20
$A7E6            .byte $0F,$0B
$A7E8  01 4C     ORA ($4C,X)
$A7EA  1D 00 22  ORA $2200,X
$A7ED  09 00     ORA #$00
$A7EF            .byte $00
$A7F0  0A        ASL A 
$A7F1            .byte $0C
$A7F2  A0 00     LDY #$00
$A7F4  05 00     ORA $00
$A7F6  08        PHP 
$A7F7            .byte $03,$02,$02
$A7FA  41 32     EOR ($32,X) 
$A7FC            .byte $34,$43
$A7FE  C0 80     CPY #$80
$A800  81 82     STA ($82,X) 
$A802            .byte $83
$A803  84 85     STY $85 
$A805            .byte $FF,$14,$8B
$A808  8C 8D 8E  STY $8E8D 
$A80B            .byte $AB
$A80C  AC B3 B4  LDY $B4B3 
$A80F  B5 B6     LDA $B6,X 
$A811            .byte $B7,$03
$A813  1D 11 3F  ORA $3F11,X
$A816  06 0C     ASL $0C 
$A818            .byte $00
$A819  01 0D     ORA ($0D,X)
$A81B  11 12     ORA ($12),Y
$A81D            .byte $1A
$A81E  C5 01     CMP $01 
$A820            .byte $33
$A821  01 13     ORA ($13,X)
$A823            .byte $04,$04
$A825  08        PHP 
//------------------------------
L_BRS_($A826)_($A859) JAM
//------------------------------
$A826            .byte $02,$0C
$A828  DD BB 66  CMP $66BB,X 
$A82B  01 33     ORA ($33,X)
$A82D  05 18     ORA $18
$A82F            .byte $04,$04
$A831  06 03     ASL $03 
$A833            .byte $0C
$A834  DD BB 66  CMP $66BB,X 
$A837            .byte $03,$02
$A839  11 01     ORA ($01),Y
$A83B  06 0C     ASL $0C 
$A83D            .byte $00,$04
$A83F  0D 11 12  ORA $1211
//------------------------------
L_BRS_($A844)_($A880) BAD
//------------------------------
$A842  0E CC 03  ASL $03CC 
$A845            .byte $3F
$A846  11 1D     ORA ($1D),Y
$A848            .byte $00,$0C
$A84A  06 05     ASL $05 
$A84C  0D 11 12  ORA $1211
$A84F  0D CE 07  ORA $07CE
$A852  1E 05 2C  ASL $2C05,X 
$A855            .byte $04
$A856  08        PHP 
$A857  01 06     ORA ($06,X)
$A859  10 CB     BPL L_BRS_($A826)_($A859) JAM
$A85B            .byte $CB,$02
$A85D  01 00     ORA ($00,X)
$A85F            .byte $03
//------------------------------
L_BRS_($A860)_($A8AD) OK
//------------------------------
$A860  01 01     ORA ($01,X)
$A862            .byte $1F
$A863  0D 2C 02  ORA $022C
$A866            .byte $02
$A867  01 07     ORA ($07,X)
$A869            .byte $12
$A86A  CC 22 BB  CPY $BB22 
$A86D  85 09     STA $09 
$A86F  84 0A     STY $0A 
$A871            .byte $9C,$13,$02
$A874  20 0E 2C  JSR L_JSR_($2C0E)_($A874) OK
$A877            .byte $00,$00,$00
$A87A  09 0E     ORA #$0E
$A87C  11 E4     ORA ($E4),Y
$A87E  C0 16     CPY #$16
$A880  10 C2     BPL L_BRS_($A844)_($A880) BAD
//------------------------------
L_BRS_($A884)_($A8E8) BAD
//------------------------------
$A882  20 0E 2C  JSR L_JSR_($2C0E)_($A882) OK
$A885            .byte $00,$00,$00
$A888  0A        ASL A 
$A889  0E 11 10  ASL $1011 
$A88C  50 13     BVC L_BRS_($A8A1)_($A88C) OK
$A88E  10 00     BPL L_BRS_($A890)_($A88E) JAM
//------------------------------
L_BRS_($A890)_($A88E) JAM
//------------------------------
$A890            .byte $00
$A891  09 0D     ORA #$0D
$A893  B4 00     LDY $00,X 
$A895  05 00     ORA $00
$A897  08        PHP 
$A898            .byte $03,$02,$02,$42,$33
$A89D  36 43     ROL $43,X 
$A89F  C0 80     CPY #$80
//------------------------------
L_BRS_($A8A1)_($A88C) OK
//------------------------------
$A8A1  81 82     STA ($82,X) 
$A8A3            .byte $83
$A8A4  84 85     STY $85 
$A8A6            .byte $FF,$1A,$A7
$A8A9  A8        TAY 
$A8AA  A9 AA     LDA #$AA
$A8AC            .byte $AF
$A8AD  B0 B1     BCS L_BRS_($A860)_($A8AD) OK
$A8AF            .byte $B2,$AB
$A8B1  AC AD AE  LDY $AEAD                          // Continue Expression
$A8B4            .byte $B3
$A8B5  B4 B5     LDY $B5,X 
$A8B7  B6 D0     LDX $D0,Y 
$A8B9            .byte $03
$A8BA  1D 01 3F  ORA $3F01,X
$A8BD  06 0C     ASL $0C 
$A8BF            .byte $00
$A8C0  01 0D     ORA ($0D,X)
$A8C2  11 12     ORA ($12),Y
$A8C4            .byte $1B
$A8C5  B9 03 01  LDA $0103,Y 
$A8C8  01 1D     ORA ($1D,X)
$A8CA            .byte $00,$0C
$A8CC  06 02     ASL $02 
$A8CE  0D 11 12  ORA $1211
$A8D1            .byte $0C
$A8D2  BC 03 1D  LDY $1D03,X 
$A8D5  01 01     ORA ($01,X)
$A8D7  06 0C     ASL $0C 
$A8D9            .byte $00,$03
$A8DB  0D 11 12  ORA $1211
$A8DE            .byte $0F,$BF,$07
$A8E1  1E 01 1E  ASL $1E01,X 
$A8E4  05 06     ORA $06
$A8E6  05 05     ORA $05
$A8E8  10 9A     BPL L_BRS_($A884)_($A8E8) BAD
$A8EA  9A        TXS 
$A8EB            .byte $22,$02,$02,$03,$03
$A8F0  06 1E     ASL $1E 
$A8F2            .byte $07
$A8F3  1E 05 01  ASL $0105,X 
$A8F6  05 06     ORA $06
$A8F8  21 A9     AND ($A9,X) 
$A8FA  A9 11     LDA #$11
$A8FC  01 01     ORA ($01,X)
$A8FE            .byte $04,$04,$0F,$14
$A902  01 C4     ORA ($C4,X)
$A904  09 00     ORA #$00
$A906  09 0F     ORA #$0F
$A908            .byte $0B,$0F,$3C
$A90B  05 06     ORA $06
$A90D  05 05     ORA $05
$A90F            .byte $13,$32,$02
$A912  20 1E 20  JSR L_JSR_($201E)_($A912) BAD
$A915            .byte $00,$00,$00
$A918  08        PHP 
$A919  0E 11 40  ASL $4011 
$A91C  30 12     BMI L_BRS_($A930)_($A91C) OK
$A91E            .byte $04,$03
$A920  1D 11 3F  ORA $3F11,X
$A923  06 0C     ASL $0C 
$A925            .byte $00
$A926  09 0D     ORA #$0D
$A928  11 12     ORA ($12),Y
$A92A            .byte $1C
$A92B  C5 01     CMP $01 
$A92D            .byte $1C
$A92E  05 3E     ORA $3E
//------------------------------
L_BRS_($A930)_($A91C) OK
//------------------------------
$A930  08        PHP 
$A931            .byte $04
$A932  01 50     ORA ($50,X)
$A934  18        CLC 
$A935  55 66     EOR $66,X 
$A937  99 0E 03  STA $030E,Y 
$A93A  01 0A     ORA ($0A,X)
$A93C  20 1C 09  JSR L_JSR_($091C)_($A93C) OK
$A93F  05 50     ORA $50
$A941  08        PHP 
$A942            .byte $1B
$A943  50 00     BVC L_BRS_($A945)_($A943) JAM
//------------------------------
L_BRS_($A945)_($A943) JAM
//------------------------------
$A945            .byte $00
$A946  05 0E     ORA $0E
$A948  6A        ROR A 
$A949            .byte $00
$A94A  05 00     ORA $00
$A94C  08        PHP 
//------------------------------
L_BRS_($A94F)_($A98E) JAM
//------------------------------
$A94D            .byte $03,$02,$02,$43,$33
$A952  36 43     ROL $43,X 
$A954  C0 80     CPY #$80
$A956  81 82     STA ($82,X) 
$A958            .byte $83
$A959  84 85     STY $85 
$A95B            .byte $FF
$A95C  15 A0     ORA $A0,X
$A95E  A6 AA     LDX $AA 
$A960            .byte $8B
$A961  91 B2     STA ($B2),Y 
$A963            .byte $92
$A964  98        TYA 
$A965  AE 99 9F  LDX $9F99 
$A968  B6 03     LDX $03,Y 
$A96A            .byte $02
$A96B  01 3F     ORA ($3F,X)
$A96D  06 0C     ASL $0C 
$A96F            .byte $00
$A970  01 0D     ORA ($0D,X)
$A972  11 12     ORA ($12),Y
$A974            .byte $0C,$B8,$03,$3F
//------------------------------
L_JSR_($A978)_($87FF) OK
//------------------------------
$A978  01 1D     ORA ($1D,X)
$A97A            .byte $00,$0C
$A97C  06 02     ASL $02 
$A97E  0D 11 12  ORA $1211
$A981            .byte $0F,$C2,$03
$A984  1D 01 01  ORA $0101,X
$A987  06 0C     ASL $0C 
$A989            .byte $00,$03
$A98B  0D 11 12  ORA $1211
$A98E  10 BF     BPL L_BRS_($A94F)_($A98E) JAM
$A990            .byte $03
$A991  01 03     ORA ($03,X)
$A993            .byte $1A,$00,$0F,$0C
$A997  10 1F     BPL L_BRS_($A9B8)_($A997) JAM
$A999  99 19 21  STA $2119,Y 
$A99C            .byte $1B,$02,$0F
$A99F  0D 19 22  ORA $2219
$A9A2  09 11     ORA #$11
$A9A4            .byte $0B
$A9A5  11 10     ORA ($10),Y
$A9A7            .byte $14
$A9A8  11 01     ORA ($01),Y
$A9AA            .byte $12,$12
$A9AC  CC 1C 08  CPY $081C 
$A9AF            .byte $00,$00
$A9B1  0A        ASL A 
$A9B2            .byte $0F
$A9B3  8C 00 05  STY $0500 
$A9B6            .byte $00
$A9B7  08        PHP 
//------------------------------
L_BRS_($A9B8)_($A997) JAM
//------------------------------
$A9B8            .byte $03,$02,$02,$44,$32,$34,$43
$A9BF  C0 80     CPY #$80
$A9C1  81 82     STA ($82,X) 
$A9C3            .byte $83
$A9C4  84 85     STY $85 
$A9C6            .byte $FF,$0C,$AB,$A7,$B3,$03
$A9CC  1D 11 3F  ORA $3F11,X
$A9CF  06 0C     ASL $0C 
$A9D1            .byte $00
$A9D2  01 0D     ORA ($0D,X)
$A9D4  11 12     ORA ($12),Y
$A9D6  0D C5 01  ORA $01C5
$A9D9  1D 0F 01  ORA $010F,X
$A9DC  06 02     ASL $02 
$A9DE  15 02     ORA $02,X
$A9E0            .byte $0C
$A9E1  EE 55 99  INC $9955 
$A9E4  01 0F     ORA ($0F,X)
$A9E6            .byte $0F
$A9E7  16 14     ASL $14,X 
$A9E9            .byte $02,$02,$03,$0C
$A9ED  EE 55 99  INC $9955 
$A9F0  01 0F     ORA ($0F,X)
$A9F2            .byte $0F
$A9F3  18        CLC 
$A9F4            .byte $04,$02,$1B,$04,$0C
$A9F9  EE 55 99  INC $9955 
$A9FC  01 0F     ORA ($0F,X)
$A9FE            .byte $0F,$33
$AA00  24 02     BIT $02 
$AA02            .byte $04
$AA03  05 0C     ORA $0C
$AA05  EE 55 99  INC $9955 
$AA08            .byte $03
$AA09  1D 11 01  ORA $0111,X
$AA0C  06 0C     ASL $0C 
$AA0E            .byte $00
$AA0F  06 0D     ASL $0D 
$AA11  11 12     ORA ($12),Y
$AA13  11 CB     ORA ($CB),Y
$AA15            .byte $03,$3F
$AA17  11 1D     ORA ($1D),Y
$AA19            .byte $00,$0C
$AA1B  06 07     ASL $07 
$AA1D  0D 11 12  ORA $1211
$AA20  06 CE     ASL $CE 
$AA22            .byte $03
$AA23  01 11     ORA ($11,X)
$AA25  1D 00 0C  ORA $0C00,X
$AA28  06 08     ASL $08 
$AA2A  0D 11 12  ORA $1211
$AA2D  0E C8 03  ASL $03C8 
$AA30            .byte $02
$AA31  01 01     ORA ($01,X)
$AA33  06 0C     ASL $0C 
$AA35            .byte $00
$AA36  09 0D     ORA #$0D
$AA38  11 12     ORA ($12),Y
$AA3A            .byte $34
$AA3B  CC 00 00  CPY $0000 
$AA3E  08        PHP 
$AA3F  10 7E     BPL L_BRS_($AABF)_($AA3F) BAD
$AA41            .byte $00
$AA42  05 00     ORA $00
$AA44  08        PHP 
$AA45            .byte $03,$02,$02
$AA48  45 32     EOR $32 
$AA4A            .byte $34,$43
$AA4C  C0 80     CPY #$80
$AA4E  81 82     STA ($82,X) 
$AA50            .byte $83
$AA51  84 85     STY $85 
$AA53            .byte $FF
$AA54  09 03     ORA #$03
$AA56  1D 11 3F  ORA $3F11,X
$AA59  06 0C     ASL $0C 
$AA5B            .byte $00
$AA5C  01 0D     ORA ($0D,X)
$AA5E  11 12     ORA ($12),Y
$AA60  0E C5 01  ASL $01C5 
$AA63            .byte $1C
$AA64  0D 37 08  ORA $0837
$AA67            .byte $04
$AA68  08        PHP 
$AA69            .byte $02,$0C
$AA6B  DD BB 66  CMP $66BB,X 
$AA6E  01 37     ORA ($37,X)
$AA70  0D 1C 08  ORA $081C
$AA73            .byte $04
$AA74  08        PHP 
$AA75            .byte $03,$0C
$AA77  DD BB 66  CMP $66BB,X 
$AA7A  06 1E     ASL $1E 
$AA7C  01 1E     ORA ($1E,X)
$AA7E            .byte $04,$0C,$04,$04
$AA82  10 35     BPL L_BRS_($AAB9)_($AA82) OK
$AA84  35 60     AND $60,X 
$AA86            .byte $02,$02,$02,$02
$AA8A  C1 1E     CMP ($1E,X) 
$AA8C  0D 09 04  ORA $0409
$AA8F            .byte $04
$AA90  2E 05 12  ROL $1205 
$AA93  DD 99 66  CMP $6699,X 
$AA96  84 06     STY $06 
$AA98  85 05     STA $05 
$AA9A            .byte $9C
$AA9B  0D 01 09  ORA $0901
$AA9E  0D 1E 2E  ORA $2E1E
$AAA1            .byte $04,$04
$AAA3  06 12     ASL $12 
$AAA5  DD 99 66  CMP $6699,X 
$AAA8  84 05     STY $05 
$AAAA  85 06     STA $06 
$AAAC            .byte $9C
//------------------------------
L_BRS_($AAAE)_($AAF0) BAD
//------------------------------
$AAAD  0D 03 3F  ORA $3F03
$AAB0  11 1D     ORA ($1D),Y
$AAB2            .byte $00,$0C
$AAB4  06 07     ASL $07 
$AAB6  0D 11 12  ORA $1211
//------------------------------
L_BRS_($AAB9)_($AA82) OK
//------------------------------
$AAB9  11 CE     ORA ($CE),Y
$AABB            .byte $00,$00
//------------------------------
L_BRS_($AABF)_($AA3F) BAD
//------------------------------
$AABD  0D 11 F7  ORA $F711
$AAC0            .byte $00
$AAC1  05 00     ORA $00
$AAC3  08        PHP 
$AAC4            .byte $03,$02,$02
$AAC7  46 33     LSR $33 
$AAC9  36 43     ROL $43,X 
$AACB  C0 80     CPY #$80
$AACD  81 82     STA ($82,X) 
$AACF            .byte $83
$AAD0  84 85     STY $85 
$AAD2            .byte $FF
$AAD3  0D B3 B4  ORA $B4B3
$AAD6  B5 B6     LDA $B6,X 
$AAD8            .byte $03
$AAD9  1D 01 3F  ORA $3F01,X
$AADC  06 0C     ASL $0C 
$AADE            .byte $00
$AADF  01 0D     ORA ($0D,X)
$AAE1  11 12     ORA ($12),Y
$AAE3            .byte $0F
$AAE4  B9 03 01  LDA $0103,Y 
$AAE7  01 1D     ORA ($1D,X)
$AAE9            .byte $00,$0C
$AAEB  06 02     ASL $02 
$AAED  0D 11 12  ORA $1211
$AAF0  10 BC     BPL L_BRS_($AAAE)_($AAF0) BAD
$AAF2            .byte $03,$3F
$AAF4  01 1D     ORA ($1D,X)
$AAF6            .byte $00,$0C
$AAF8  06 03     ASL $03 
$AAFA  0D 11 12  ORA $1211
$AAFD  09 C2     ORA #$C2
$AAFF            .byte $0C
$AB00  01 05     ORA ($05,X)
$AB02            .byte $0C,$00,$07,$0B,$04
$AB07  16 11     ASL $11,X 
$AB09  01 0B     ORA ($0B,X)
$AB0B            .byte $0C
$AB0C  01 0C     ORA ($0C,X)
$AB0E  0E 01 08  ASL $0801 
$AB11  16 01     ASL $01,X 
$AB13  05 10     ORA $10
$AB15            .byte $0C
$AB16  01 05     ORA ($05,X)
$AB18  11 00     ORA ($00),Y
$AB1A            .byte $04
$AB1B  05 05     ORA $05
//------------------------------
L_BRS_($AB1D)_($AB94) OK
//------------------------------
$AB1D  16 11     ASL $11,X 
$AB1F  01 08     ORA ($08,X)
$AB21            .byte $12
$AB22  01 09     ORA ($09,X)
$AB24            .byte $13
$AB25  01 06     ORA ($06,X)
$AB27            .byte $1A
$AB28  01 05     ORA ($05,X)
$AB2A  18        CLC 
$AB2B            .byte $0C
$AB2C  01 0B     ORA ($0B,X)
$AB2E  09 00     ORA #$00
$AB30            .byte $02,$03,$07
$AB33  16 11     ASL $11,X 
$AB35  01 0B     ORA ($0B,X)
$AB37            .byte $0C
$AB38  01 0C     ORA ($0C,X)
$AB3A  09 01     ORA #$01
$AB3C  0D 0D 01  ORA $010D
$AB3F  0A        ASL A 
$AB40            .byte $0F
$AB41  0A        ASL A 
$AB42  01 03     ORA ($03,X)
$AB44  0E 00 02  ASL $0200 
$AB47            .byte $02
$AB48  08        PHP 
$AB49  10 11     BPL L_BRS_($AB5C)_($AB49) BAD
$AB4B  01 05     ORA ($05,X)
$AB4D  10 01     BPL L_BRS_($AB50)_($AB4D) JAM
//------------------------------
L_BRS_($AB50)_($AB4D) JAM
//------------------------------
$AB4F            .byte $03,$0F
$AB51  0A        ASL A 
$AB52  01 03     ORA ($03,X)
$AB54  0E 00 02  ASL $0200 
$AB57  01 06     ORA ($06,X)
$AB59  10 11     BPL L_BRS_($AB6C)_($AB59) OK
//------------------------------
L_BRS_($AB5C)_($AB49) BAD
//------------------------------
$AB5B  01 06     ORA ($06,X)
$AB5D  10 01     BPL L_BRS_($AB60)_($AB5D) OK
$AB5F            .byte $03
//------------------------------
L_BRS_($AB60)_($AB5D) OK
//------------------------------
$AB60  0E 01 3E  ASL $3E01 
$AB63  05 1C     ORA $1C
$AB65  01 04     ORA ($04,X)
$AB67  08        PHP 
$AB68  50 18     BVC L_BRS_($AB82)_($AB68) OK
$AB6A  55 66     EOR $66,X 
//------------------------------
L_BRS_($AB6C)_($AB59) OK
//------------------------------
$AB6C  99 0E 03  STA $030E,Y 
$AB6F  01 0A     ORA ($0A,X)
$AB71  20 1C 09  JSR L_JSR_($091C)_($AB71) OK
$AB74  05 50     ORA $50
$AB76  08        PHP 
$AB77  09 50     ORA #$50
$AB79            .byte $03
$AB7A  1D 11 3F  ORA $3F11,X
$AB7D  06 0C     ASL $0C 
$AB7F            .byte $00
$AB80  49 0D     EOR #$0D
//------------------------------
L_BRS_($AB82)_($AB68) OK
//------------------------------
$AB82  11 12     ORA ($12),Y
$AB84  21 C5     AND ($C5,X) 
$AB86  01 02     ORA ($02,X)
$AB88  01 08     ORA ($08,X)
$AB8A            .byte $02,$02,$02
$AB8D  10 21     BPL L_BRS_($ABB0)_($AB8D) OK
//------------------------------
L_BRS_($AB90)_($ABDD) BAD
//------------------------------
$AB8F  55 66     EOR $66,X 
$AB91  99 88 12  STA $1288,Y 
$AB94  10 87     BPL L_BRS_($AB1D)_($AB94) OK
$AB96            .byte $12
$AB97  01 87     ORA ($87,X)
$AB99  15 01     ORA $01,X
$AB9B  90 10     BCC L_BRS_($ABAD)_($AB9B) BAD
$AB9D            .byte $8F
$AB9E  0E 81 50  ASL $5081 
$ABA1            .byte $C3,$00
$ABA3  85 11     STA $11 
$ABA5  A2 12     LDX #$12
$ABA7  01 10     ORA ($10,X)
$ABA9  01 01     ORA ($01,X)
$ABAB            .byte $02
//------------------------------
L_BRS_($ABAD)_($AB9B) BAD
//------------------------------
$ABAC  0E 3E 11  ASL $113E 
$ABAF            .byte $0C
//------------------------------
L_BRS_($ABB0)_($AB8D) OK
//------------------------------
$ABB0  99 77 CC  STA $CC77,Y 
$ABB3            .byte $02
$ABB4  06 5E     ASL $5E 
$ABB6  10 45     BPL L_BRS_($ABFD)_($ABB6) BAD
$ABB8  10 5C     BPL L_BRS_($AC16)_($ABB8) OK
$ABBA  08        PHP 
$ABBB            .byte $04,$03
$ABBD  10 23     BPL L_BRS_($ABE2)_($ABBD) OK
$ABBF            .byte $00,$00
$ABC1  11 12     ORA ($12),Y
$ABC3            .byte $27
$ABC4  01 05     ORA ($05,X)
$ABC6            .byte $00,$07
$ABC8  0E 08 03  ASL $0308 
$ABCB  41 32     EOR ($32,X) 
$ABCD            .byte $34,$43
$ABCF  C0 80     CPY #$80
$ABD1  81 82     STA ($82,X) 
$ABD3            .byte $83
$ABD4  84 85     STY $85 
$ABD6            .byte $FF
$ABD7  11 AB     ORA ($AB),Y
$ABD9  AC AD AE  LDY $AEAD                          // Continue Expression
$ABDC            .byte $AF
$ABDD  B0 B1     BCS L_BRS_($AB90)_($ABDD) BAD
$ABDF            .byte $B2,$C3,$1F
//------------------------------
L_BRS_($ABE2)_($ABBD) OK
//------------------------------
$ABE2  11 01     ORA ($01),Y
$ABE4            .byte $02,$0C,$00
$ABE7  01 0D     ORA ($0D,X)
$ABE9  11 12     ORA ($12),Y
$ABEB  15 CB     ORA $CB,X
$ABED            .byte $03,$3F
$ABEF  11 1D     ORA ($1D),Y
$ABF1            .byte $00,$0C
$ABF3  06 02     ASL $02 
$ABF5  0D 11 12  ORA $1211
$ABF8            .byte $13
$ABF9  CE 01 25  DEC $2501 
//------------------------------
L_BRS_($ABFD)_($ABB6) BAD
//------------------------------
$ABFC  01 33     ORA ($33,X)
$ABFE            .byte $12,$03,$0C,$03,$0C
$AC03  66 BB     ROR $BB 
$AC05  CC 01 27  CPY $2701 
$AC08            .byte $04
$AC09  35 0E     AND $0E,X 
$AC0B            .byte $02
$AC0C  0A        ASL A 
$AC0D            .byte $04,$0C,$77,$BB
$AC11  DD 01 29  CMP $2901,X 
$AC14  06 37     ASL $37 
//------------------------------
L_BRS_($AC16)_($ABB8) OK
//------------------------------
$AC16  0A        ASL A 
$AC17  01 08     ORA ($08,X)
$AC19  05 0C     ORA $0C
$AC1B  66 BB     ROR $BB 
$AC1D  CC 07 27  CPY $2707 
$AC20            .byte $12
$AC21  35 0E     AND $0E,X 
$AC23            .byte $02
$AC24  0A        ASL A 
$AC25  06 10     ASL $10 
$AC27  98        TYA 
$AC28  98        TYA 
$AC29            .byte $BB
$AC2A  01 01     ORA ($01,X)
$AC2C            .byte $0C
$AC2D  0A        ASL A 
$AC2E  01 2C     ORA ($2C,X)
$AC30            .byte $07
$AC31  39 04 02  AND $0204,Y 
$AC34  01 07     ORA ($07,X)
$AC36            .byte $0C
$AC37  CC 00 66  CPY $6600 
$AC3A  01 2C     ORA ($2C,X)
$AC3C            .byte $07,$3C,$04
$AC3F  06 01     ASL $01 
$AC41  08        PHP 
$AC42            .byte $0C
$AC43  CC 20 77  CPY $7720 
$AC46  01 2C     ORA ($2C,X)
$AC48  09 39     ORA #$39
$AC4A            .byte $04
$AC4B  01 03     ORA ($03,X)
$AC4D  09 13     ORA #$13
$AC4F  CC BB 66  CPY $66BB 
$AC52            .byte $0F
$AC53  0D 12 0E  ORA $0E12
$AC56  CE 1C 08  DEC $081C 
$AC59            .byte $0C,$34
$AC5B  15 01     ORA $01,X
$AC5D            .byte $0B,$07,$00
$AC60  0A        ASL A 
$AC61  16 11     ASL $11,X 
$AC63            .byte $34,$1B
$AC65  01 35     ORA ($35,X)
$AC67            .byte $1C
$AC68  01 2A     ORA ($2A,X)
$AC6A  18        CLC 
$AC6B  01 30     ORA ($30,X)
$AC6D  15 01     ORA $01,X
$AC6F            .byte $0C,$37,$1B
$AC72  01 03     ORA ($03,X)
$AC74            .byte $02,$00,$0B
$AC77  16 11     ASL $11,X 
$AC79            .byte $34,$1B
$AC7B  01 37     ORA ($37,X)
$AC7D            .byte $1C
$AC7E  01 33     ORA ($33,X)
$AC80  1D 01 31  ORA $3101,X
$AC83            .byte $1A
$AC84  01 0C     ORA ($0C,X)
$AC86            .byte $2F
$AC87  15 01     ORA $01,X
$AC89  05 04     ORA $04
$AC8B            .byte $00,$0C
$AC8D  16 11     ASL $11,X 
$AC8F  2E 18 01  ROL $0118 
$AC92  2D 19 01  AND $0119 
$AC95  26 16     ROL $16 
$AC97  01 28     ORA ($28,X)
$AC99  15 01     ORA $01,X
$AC9B  0A        ASL A 
$AC9C            .byte $32,$13
$AC9E  01 02     ORA ($02,X)
$ACA0            .byte $02,$00
$ACA2  0D 10 11  ORA $1110
$ACA5            .byte $2F
$ACA6  16 01     ASL $01,X 
$ACA8  31 13     AND ($13),Y 
$ACAA  01 0A     ORA ($0A,X)
$ACAC            .byte $32,$13
$ACAE  01 01     ORA ($01,X)
$ACB0            .byte $02,$00
$ACB2  0E 10 11  ASL $1110 
$ACB5  30 16     BMI L_BRS_($ACCD)_($ACB5) BAD
$ACB7  01 32     ORA ($32,X)
$ACB9            .byte $13
$ACBA  01 01     ORA ($01,X)
$ACBC  3E 16 1C  ROL $1C16,X 
$ACBF  01 04     ORA ($04,X)
$ACC1  08        PHP 
$ACC2  50 18     BVC L_BRS_($ACDC)_($ACC2) OK
$ACC4  55 66     EOR $66,X 
$ACC6  99 0E 03  STA $030E,Y 
$ACC9  01 0A     ORA ($0A,X)
//------------------------------
L_BRS_($ACCD)_($ACB5) BAD
//------------------------------
$ACCB  20 1C 09  JSR L_JSR_($091C)_($ACCB) OK
$ACCE  05 50     ORA $50
$ACD0  08        PHP 
$ACD1            .byte $13
$ACD2  50 07     BVC L_BRS_($ACDB)_($ACD2) BAD
$ACD4            .byte $1C
$ACD5  11 01     ORA ($01),Y
$ACD7  08        PHP 
$ACD8            .byte $0C,$02
//------------------------------
L_BRS_($ACDB)_($ACD2) BAD
//------------------------------
$ACDA  10 14     BPL L_BRS_($ACF0)_($ACDA) OK
//------------------------------
L_BRS_($ACDC)_($ACC2) OK
//------------------------------
$ACDC  99 92 99  STA $9992,Y 
$ACDF            .byte $02,$00
$ACE1  06 02     ASL $02 
$ACE3  A2 0D     LDX #$0D
$ACE5            .byte $8F
$ACE6  05 00     ORA $00
$ACE8            .byte $00
$ACE9  05 13     ORA $13
$ACEB            .byte $57,$00
$ACED  05 00     ORA $00
$ACEF            .byte $07
//------------------------------
L_BRS_($ACF0)_($ACDA) OK
//------------------------------
$ACF0  0E 08 03  ASL $0308 
$ACF3            .byte $42,$33
$ACF5  36 43     ROL $43,X 
$ACF7  C0 80     CPY #$80
$ACF9  8A        TXA 
$ACFA            .byte $82,$83
$ACFC  84 85     STY $85 
$ACFE            .byte $FF
$ACFF  09 03     ORA #$03
$AD01  38        SEC 
$AD02  01 01     ORA ($01,X)
$AD04  06 0C     ASL $0C 
$AD06            .byte $00
$AD07  01 0D     ORA ($0D,X)
$AD09  11 12     ORA ($12),Y
$AD0B  16 BE     ASL $BE,X 
$AD0D            .byte $03,$3F
$AD0F  01 1D     ORA ($1D,X)
$AD11            .byte $00,$0C
$AD13  06 02     ASL $02 
$AD15  0D 11 12  ORA $1211
$AD18            .byte $14,$C2,$03
$AD1B  01 01     ORA ($01,X)
$AD1D  1D 00 0C  ORA $0C00,X
//------------------------------
L_JSR_($AD20)_($71C5) OK
//------------------------------
$AD20  06 03     ASL $03 
$AD22  0D 11 12  ORA $1211
$AD25            .byte $12
$AD26  BC 01 01  LDY $0101,X 
$AD29  05 1C     ORA $1C
$AD2B  01 04     ORA ($04,X)
$AD2D  08        PHP 
$AD2E  50 18     BVC L_BRS_($AD48)_($AD2E) OK
$AD30  55 66     EOR $66,X 
$AD32  99 0E 03  STA $030E,Y 
$AD35  01 0A     ORA ($0A,X)
$AD37  20 1C 09  JSR L_JSR_($091C)_($AD37) OK
$AD3A  05 50     ORA $50
$AD3C  08        PHP 
$AD3D            .byte $12
$AD3E  50 00     BVC L_BRS_($AD40)_($AD3E) JAM
//------------------------------
L_BRS_($AD40)_($AD3E) JAM
//------------------------------
$AD40            .byte $00,$0C,$14
$AD43  BD 00 05  LDA $0500,X 
$AD46            .byte $00,$07
//------------------------------
L_BRS_($AD48)_($AD2E) OK
//------------------------------
$AD48  0E 08 03  ASL $0308 
$AD4B            .byte $43,$32,$34,$43
$AD4F  C0 80     CPY #$80
$AD51  81 82     STA ($82,X) 
$AD53            .byte $83
$AD54  84 85     STY $85 
$AD56            .byte $FF,$0C
$AD58  A0 A1     LDY #$A1
$AD5A  A2 03     LDX #$03
$AD5C  1D 11 01  ORA $0111,X
$AD5F  06 0C     ASL $0C 
$AD61            .byte $00
$AD62  01 0D     ORA ($0D,X)
$AD64  11 12     ORA ($12),Y
$AD66            .byte $17,$CB
$AD68  01 01     ORA ($01,X)
$AD6A            .byte $0F
$AD6B  01 22     ORA ($22,X)
$AD6D            .byte $02
$AD6E  08        PHP 
$AD6F            .byte $02,$0C
$AD71  DD BB 66  CMP $66BB,X 
$AD74  01 01     ORA ($01,X)
$AD76            .byte $0F
$AD77  09 08     ORA #$08
$AD79            .byte $02
$AD7A  36 03     ROL $03,X 
$AD7C            .byte $0C
$AD7D  DD BB 66  CMP $66BB,X 
$AD80            .byte $03
$AD81  01 11     ORA ($11,X)
$AD83  1D 00 0C  ORA $0C00,X
$AD86  06 05     ASL $05 
$AD88  0D 11 12  ORA $1211
$AD8B            .byte $13
$AD8C  C8        INY 
$AD8D            .byte $03
$AD8E  05 01     ORA $01
$AD90            .byte $3A,$04,$00
$AD93  01 07     ORA ($07,X)
$AD95  0A        ASL A 
$AD96  11 03     ORA ($03),Y
$AD98            .byte $07
$AD99  01 39     ORA ($39,X)
$AD9B  01 00     ORA ($00,X)
$AD9D            .byte $03
$AD9E  08        PHP 
$AD9F  0A        ASL A 
$ADA0  11 0E     ORA ($0E),Y
$ADA2  05 01     ORA $01
$ADA4  39 06 00  AND $0006,Y 
$ADA7            .byte $03
$ADA8  06 2C     ASL $2C 
$ADAA  11 08     ORA ($08),Y
$ADAC  01 3B     ORA ($3B,X)
$ADAE  0A        ASL A 
$ADAF  01 3C     ORA ($3C,X)
$ADB1            .byte $0B
$ADB2  01 3B     ORA ($3B,X)
$ADB4            .byte $0B
$ADB5  01 3A     ORA ($3A,X)
$ADB7  0A        ASL A 
$ADB8  01 39     ORA ($39,X)
$ADBA  08        PHP 
$ADBB  01 3A     ORA ($3A,X)
$ADBD  05 06     ORA $06
$ADBF  05 07     ORA $07
$ADC1  05 08     ORA $08
$ADC3            .byte $0F,$0B
$ADC5  09 20     ORA #$20
$ADC7  01 4C     ORA ($4C,X)
$ADC9  1D 00 22  ORA $2200,X
$ADCC  09 01     ORA #$01
$ADCE  15 01     ORA $01,X
$ADD0  15 05     ORA $05,X
$ADD2            .byte $1F
$ADD3  05 09     ORA $09
$ADD5            .byte $0C
$ADD6  99 00 AA  STA $AA00,Y 
$ADD9  01 2A     ORA ($2A,X)
$ADDB  01 15     ORA ($15,X)
$ADDD  05 1F     ORA $1F
$ADDF  05 0A     ORA $0A
$ADE1            .byte $0C
$ADE2  99 00 AA  STA $AA00,Y 
$ADE5  01 2A     ORA ($2A,X)
$ADE7  01 2A     ORA ($2A,X)
$ADE9  05 1F     ORA $1F
$ADEB  05 0B     ORA $0B
$ADED            .byte $0C
$ADEE  99 00 AA  STA $AA00,Y 
$ADF1  01 15     ORA ($15,X)
$ADF3  01 2A     ORA ($2A,X)
$ADF5  05 1F     ORA $1F
$ADF7  05 0C     ORA $0C
$ADF9            .byte $0C
$ADFA  99 00 AA  STA $AA00,Y 
$ADFD            .byte $00,$00
$ADFF  09 15     ORA #$15
$AE01  8E 00 05  STX $0500 
$AE04            .byte $00,$07
$AE06  0E 08 03  ASL $0308 
$AE09            .byte $44,$33
$AE0B  36 43     ROL $43,X 
$AE0D  C0 80     CPY #$80
$AE0F  81 82     STA ($82,X) 
$AE11            .byte $83
$AE12  84 85     STY $85 
//------------------------------
L_BRS_($AE15)_($AE47) JAM
//------------------------------
$AE14            .byte $FF,$0B,$A7
$AE17  AA        TAX 
$AE18            .byte $C3,$1F
$AE1A  01 3F     ORA ($3F,X)
$AE1C            .byte $02,$0C,$00
$AE1F  01 0D     ORA ($0D,X)
$AE21  11 12     ORA ($12),Y
$AE23            .byte $12
$AE24  B9 03 01  LDA $0103,Y 
$AE27  11 1D     ORA ($1D),Y
$AE29            .byte $00,$0C
$AE2B  06 02     ASL $02 
$AE2D  0D 11 12  ORA $1211
$AE30            .byte $1C
$AE31  C8        INY 
$AE32            .byte $03
$AE33  01 01     ORA ($01,X)
$AE35  1D 00 0C  ORA $0C00,X
$AE38  06 03     ASL $03 
$AE3A  0D 11 12  ORA $1211
$AE3D            .byte $1B
$AE3E  BC 01 04  LDY $0401,X 
$AE41  09 1C     ORA #$1C
$AE43  08        PHP 
$AE44            .byte $04
$AE45  08        PHP 
$AE46            .byte $04
$AE47  10 CC     BPL L_BRS_($AE15)_($AE47) JAM
$AE49            .byte $BB
$AE4A  66 85     ROR $85 
$AE4C            .byte $04,$9C
$AE4E  08        PHP 
$AE4F  01 09     ORA ($09,X)
$AE51  05 1C     ORA $1C
$AE53  08        PHP 
$AE54            .byte $04
$AE55  08        PHP 
$AE56  05 10     ORA $10
$AE58  DD BB 66  CMP $66BB,X 
$AE5B  85 05     STA $05 
$AE5D            .byte $9C
$AE5E  08        PHP 
$AE5F  06 01     ASL $01 
$AE61  01 24     ORA ($24,X)
$AE63            .byte $1A
$AE64  18        CLC 
$AE65            .byte $02
$AE66  06 10     ASL $10 
$AE68  35 35     AND $35,X 
$AE6A  66 00     ROR $00 
$AE6C            .byte $00,$03,$02
$AE6F  06 01     ASL $01 
$AE71  01 1A     ORA ($1A,X)
$AE73            .byte $1A
$AE74  18        CLC 
$AE75            .byte $02,$07
$AE77  10 35     BPL L_BRS_($AEAE)_($AE77) BAD
$AE79  35 66     AND $66,X 
$AE7B            .byte $00,$00,$03,$02,$03,$3F
$AE81  01 02     ORA ($02,X)
$AE83            .byte $00,$0C
$AE85  06 08     ASL $08 
$AE87  0D 11 12  ORA $1211
$AE8A  16 B7     ASL $B7,X 
$AE8C            .byte $00,$00,$12
$AE8F  16 51     ASL $51,X 
$AE91  01 05     ORA ($05,X)
$AE93            .byte $00,$07
$AE95  0E 08 03  ASL $0308 
$AE98  45 32     EOR $32 
$AE9A            .byte $34,$43
$AE9C  C0 80     CPY #$80
$AE9E  81 82     STA ($82,X) 
$AEA0            .byte $83
$AEA1  84 85     STY $85 
$AEA3            .byte $FF,$12,$9C
$AEA6  9D 9E 9F  STA $9F9E,X 
$AEA9            .byte $92,$93
$AEAB  94 95     STY $95,X 
//------------------------------
L_BRS_($AEAE)_($AE77) BAD
//------------------------------
$AEAD  8E 03 01  STX $0103 
$AEB0  11 02     ORA ($02),Y
$AEB2            .byte $00,$0C
$AEB4  06 01     ASL $01 
$AEB6  0D 11 12  ORA $1211
$AEB9  15 C7     ORA $C7,X
$AEBB  01 15     ORA ($15,X)
$AEBD  01 01     ORA ($01,X)
$AEBF  01 1F     ORA ($1F,X)
$AEC1  3E 02 17  ROL $1702,X 
$AEC4            .byte $92,$44,$33,$8F,$12,$89
$AECA  06 8B     ASL $8B 
$AECC  06 0A     ASL $0A 
$AECE  90 02     BCC L_BRS_($AED2)_($AECE) JAM
$AED0            .byte $9C
$AED1  08        PHP 
//------------------------------
L_BRS_($AED2)_($AECE) JAM
//------------------------------
$AED2            .byte $03
$AED3  16 01     ASL $01,X 
$AED5  09 29     ORA #$29
$AED7            .byte $00
$AED8  08        PHP 
$AED9            .byte $03
$AEDA  16 00     ASL $00,X 
$AEDC            .byte $04
$AEDD  05 04     ORA $04
$AEDF  06 05     ASL $05 
$AEE1            .byte $07
$AEE2  05 08     ORA $08
$AEE4  05 09     ORA $09
$AEE6            .byte $23,$00,$03
$AEE9  16 01     ASL $01,X 
$AEEB  11 29     ORA ($29),Y
$AEED            .byte $00
$AEEE  08        PHP 
$AEEF            .byte $04
$AEF0  18        CLC 
//------------------------------
L_BRS_($AEF1)_($AF24) OK
//------------------------------
$AEF1  CC 04 07  CPY $0704 
$AEF4            .byte $04
$AEF5  08        PHP 
$AEF6  05 05     ORA $05
$AEF8  05 06     ORA $06
$AEFA            .byte $04
$AEFB  09 23     ORA #$23
$AEFD  01 0F     ORA ($0F,X)
$AEFF            .byte $13
$AF00  09 23     ORA #$23
$AF02  01 2F     ORA ($2F,X)
$AF04            .byte $04
$AF05  01 08     ORA ($08,X)
$AF07  05 10     ORA $10
$AF09            .byte $CB,$CB
$AF0B  66 01     ROR $01 
$AF0D            .byte $00,$03
$AF0F  01 01     ORA ($01,X)
$AF11  24 01     BIT $01 
$AF13            .byte $37,$02
$AF15  01 02     ORA ($02,X)
$AF17  06 0C     ASL $0C 
$AF19  CC BB 66  CPY $66BB 
$AF1C            .byte $C7,$23
$AF1E  01 2E     ORA ($2E,X)
$AF20            .byte $04
$AF21  08        PHP 
$AF22  01 07     ORA ($07,X)
$AF24  10 CB     BPL L_BRS_($AEF1)_($AF24) OK
$AF26            .byte $CB
$AF27  66 01     ROR $01 
$AF29            .byte $00,$03
$AF2B  01 C1     ORA ($C1,X)
$AF2D  24 09     BIT $09 
$AF2F  2E 02 02  ROL $0202 
$AF32  01 08     ORA ($08,X)
$AF34            .byte $0C
$AF35  DD CC BB  CMP $BBCC,X 
$AF38            .byte $C2
$AF39  25 0A     AND $0A
$AF3B  2E 00 00  ROL $0000 
$AF3E            .byte $00
$AF3F  09 0E     ORA #$0E
$AF41  11 08     ORA ($08),Y
$AF43  40        RTI 
//------------------------------
$AF44  20 10 07  JSR $0710
$AF47            .byte $1A
$AF48  01 34     ORA ($34,X)
$AF4A  05 06     ORA $06
$AF4C  05 0B     ORA $0B
$AF4E  10 3A     BPL L_BRS_($AF8A)_($AF4E) JAM
$AF50            .byte $3A,$00,$02,$02,$03,$03
$AF56  06 1A     ASL $1A 
$AF58            .byte $07,$34
$AF5A  05 01     ORA $01
$AF5C  05 0A     ORA $0A
$AF5E  21 A3     AND ($A3,X) 
$AF60            .byte $A3
$AF61  11 01     ORA ($01),Y
$AF63  01 04     ORA ($04,X)
$AF65            .byte $04,$0F,$14
$AF68  01 C4     ORA ($C4,X)
$AF6A  09 00     ORA #$00
$AF6C  09 0A     ORA #$0A
$AF6E            .byte $0B
$AF6F  0A        ASL A 
$AF70            .byte $2B
$AF71  05 0B     ORA $0B
$AF73  05 0A     ORA $0A
$AF75            .byte $13,$32
$AF77  0E 04 01  ASL $0104 
$AF7A  2D 05 00  AND $0005 
$AF7D  08        PHP 
$AF7E            .byte $0C
$AF7F  2C 11 06  BIT $0611 
$AF82  01 31     ORA ($31,X)
$AF84  05 01     ORA $01
$AF86            .byte $33
$AF87  06 01     ASL $01 
//------------------------------
L_BRS_($AF8A)_($AF4E) JAM
//------------------------------
$AF89            .byte $34,$07
$AF8B  01 34     ORA ($34,X)
$AF8D  08        PHP 
$AF8E  01 33     ORA ($33,X)
$AF90            .byte $07
$AF91  01 31     ORA ($31,X)
$AF93  05 0C     ORA $0C
$AF95  05 0D     ORA $0D
$AF97  05 0E     ORA $0E
$AF99  09 20     ORA #$20
$AF9B            .byte $0F,$0B,$22
$AF9E  09 01     ORA #$01
$AFA0  4C 1D 00  JMP $001D
$AFA3            .byte $03
$AFA4  06 01     ASL $01 
$AFA6  2E 01 00  ROL $0001 
$AFA9            .byte $04
$AFAA  0D 0A 11  ORA $110A
$AFAD            .byte $03
$AFAE  05 01     ORA $01
$AFB0  30 03     BMI L_BRS_($AFB5)_($AFB0) OK
$AFB2            .byte $00
$AFB3  01 0E     ORA ($0E,X)
//------------------------------
L_BRS_($AFB5)_($AFB0) OK
//------------------------------
$AFB5  0A        ASL A 
$AFB6  11 03     ORA ($03),Y
$AFB8            .byte $3F
$AFB9  11 02     ORA ($02),Y
$AFBB            .byte $00,$0C
$AFBD  06 11     ASL $11 
$AFBF  0D 11 12  ORA $1211
$AFC2            .byte $17,$C3,$03
$AFC5  38        SEC 
$AFC6  11 3F     ORA ($3F),Y
$AFC8  06 0C     ASL $0C 
$AFCA            .byte $00,$12
$AFCC  0D 11 12  ORA $1211
$AFCF            .byte $13
$AFD0  C6 C3     DEC $C3 
$AFD2            .byte $1F
$AFD3  01 01     ORA ($01,X)
$AFD5            .byte $02,$0C,$00,$0F
$AFD9  0D 11 12  ORA $1211
$AFDC            .byte $04,$CB,$00,$00
$AFE0  05 17     ORA $17
$AFE2  4A        LSR A 
$AFE3            .byte $00
$AFE4  05 00     ORA $00
$AFE6            .byte $07
$AFE7  0E 08 03  ASL $0308 
$AFEA  46 33     LSR $33 
$AFEC  36 43     ROL $43,X 
$AFEE  C0 80     CPY #$80
$AFF0  8A        TXA 
$AFF1            .byte $82,$83
$AFF3  84 85     STY $85 
$AFF5            .byte $FF
$AFF6  09 03     ORA #$03
$AFF8  1D 01 3F  ORA $3F01,X
$AFFB  06 0C     ASL $0C 
//------------------------------
L_BRS_($AFFD)_($B04A) JAM
//------------------------------
$AFFD            .byte $00
$AFFE  01 0D     ORA ($0D,X)
$B000  11 12     ORA ($12),Y
$B002            .byte $14
$B003  B9 03 01  LDA $0103,Y 
$B006  01 02     ORA ($02,X)
$B008            .byte $00,$0C
$B00A  06 02     ASL $02 
$B00C  0D 11 12  ORA $1211
$B00F  16 BB     ASL $BB,X 
$B011  01 01     ORA ($01,X)
$B013  01 39     ORA ($39,X)
$B015            .byte $3A
$B016  10 01     BPL L_BRS_($B019)_($B016) JAM
//------------------------------
L_BRS_($B019)_($B016) JAM
//------------------------------
$B018            .byte $03,$0C
$B01A  66 00     ROR $00 
$B01C  99 01 34  STA $3401,Y 
$B01F  01 01     ORA ($01,X)
$B021  01 10     ORA ($10,X)
$B023            .byte $33,$04,$0C,$BB,$00
$B028  66 01     ROR $01 
$B02A  06 53     ASL $53 
$B02C  FD 4F 12  SBC $124F,X 
$B02F            .byte $62
$B030  11 00     ORA ($00),Y
$B032  16 18     ASL $18,X 
$B034            .byte $67
$B035  01 05     ORA ($05,X)
$B037            .byte $00
$B038  01 06     ORA ($06,X)
$B03A  08        PHP 
$B03B            .byte $04
$B03C  41 32     EOR ($32,X) 
$B03E            .byte $34,$43
$B040  C0 80     CPY #$80
$B042  81 82     STA ($82,X) 
$B044            .byte $83
$B045  84 85     STY $85 
$B047            .byte $FF,$0C,$AF
$B04A  B0 B1     BCS L_BRS_($AFFD)_($B04A) JAM
$B04C            .byte $03
$B04D  1D 11 01  ORA $0111,X
$B050  06 0C     ASL $0C 
$B052            .byte $00
$B053  01 0D     ORA ($0D,X)
$B055  11 12     ORA ($12),Y
$B057            .byte $1A,$CB
$B059  01 01     ORA ($01,X)
$B05B  0D 01 17  ORA $1701
$B05E            .byte $04
$B05F  08        PHP 
$B060            .byte $02,$0C
$B062  55 68     EOR $68,X 
$B064  99 01 28  STA $2801,Y 
$B067  0D 01 17  ORA $1701
$B06A            .byte $04
$B06B  08        PHP 
$B06C            .byte $03,$0C
$B06E  55 78     EOR $78,X 
$B070  99 03 02  STA $0203,Y 
$B073  11 01     ORA ($01),Y
$B075  06 08     ASL $08 
$B077            .byte $00,$04
$B079  0D 11 12  ORA $1211
$B07C            .byte $1A
$B07D  CA        DEX 
$B07E            .byte $03
$B07F  38        SEC 
$B080  11 01     ORA ($01),Y
$B082  06 08     ASL $08 
$B084            .byte $00
$B085  05 0D     ORA $0D
$B087  11 12     ORA ($12),Y
$B089            .byte $1A
$B08A  CC 03 2B  CPY $2B03 
$B08D  11 01     ORA ($01),Y
$B08F  06 0A     ASL $0A 
$B091            .byte $00
$B092  06 0D     ASL $0D 
$B094  11 12     ORA ($12),Y
$B096            .byte $1A
$B097  09 03     ORA #$03
$B099            .byte $0F
$B09A  11 01     ORA ($01),Y
$B09C  06 0A     ASL $0A 
$B09E            .byte $00,$07
$B0A0  0D 11 12  ORA $1211
$B0A3  18        CLC 
$B0A4  B9 C0 2E  LDA $2EC0,Y 
$B0A7  11 03     ORA ($03),Y
$B0A9            .byte $00,$00,$00
$B0AC  08        PHP 
$B0AD  09 C0     ORA #$C0
$B0AF            .byte $12
$B0B0  11 01     ORA ($01),Y
$B0B2            .byte $00,$00,$00
$B0B5  09 09     ORA #$09
$B0B7            .byte $03,$02
$B0B9  01 01     ORA ($01,X)
$B0BB  06 0C     ASL $0C 
$B0BD            .byte $00
$B0BE  0A        ASL A 
$B0BF  0D 11 12  ORA $1211
$B0C2  35 CC     AND $CC,X 
$B0C4  01 27     ORA ($27,X)
$B0C6  01 11     ORA ($11,X)
$B0C8  08        PHP 
$B0C9            .byte $0C
$B0CA  08        PHP 
$B0CB            .byte $0B,$0C
$B0CD  99 66 55  STA $5566,Y 
$B0D0  C1 1C     CMP ($1C,X) 
$B0D2  01 11     ORA ($11,X)
$B0D4  08        PHP 
$B0D5            .byte $0C
$B0D6  08        PHP 
$B0D7            .byte $0C,$0C
$B0D9  EE 66 55  INC $5566 
$B0DC            .byte $03,$2F
$B0DE  01 11     ORA ($11,X)
$B0E0            .byte $00,$0C
$B0E2  08        PHP 
$B0E3  0D 12 00  ORA $0012
$B0E6  05 0D     ORA $0D
$B0E8  05 0B     ORA $0B
$B0EA            .byte $04,$0C,$1C
$B0ED  0D 01 1C  ORA $1C01
$B0F0  0D 15 08  ORA $0815
$B0F3            .byte $04
$B0F4  08        PHP 
$B0F5  0E 0C 66  ASL $660C 
$B0F8            .byte $BB
$B0F9  DD 01 01  CMP $0101,X 
$B0FC  10 1D     BPL L_BRS_($B11B)_($B0FC) BAD
$B0FE  3E 01 22  ROL $2201,X 
$B101            .byte $0F,$0C
$B103  66 BB     ROR $BB 
$B105  DD 01 01  CMP $0101,X 
$B108  11 2B     ORA ($2B),Y
$B10A            .byte $0F,$0F
$B10C  01 10     ORA ($10,X)
$B10E            .byte $0C,$33
$B110  55 CC     EOR $CC,X 
$B112            .byte $0C
$B113  01 15     ORA ($15,X)
$B115            .byte $37,$00,$07,$04
//------------------------------
L_BRS_($B11B)_($B0FC) BAD
//------------------------------
$B119  1E 16 99  ASL $9916,X 
$B11C  01 15     ORA ($15,X)
$B11E            .byte $37
$B11F  01 15     ORA ($15,X)
$B121            .byte $3B
$B122  01 1C     ORA ($1C,X)
$B124  39 01 1C  AND $1C01,Y 
$B127            .byte $37,$0C
$B129  01 1A     ORA ($1A,X)
$B12B            .byte $34,$00,$02,$03,$1F
$B130  16 99     ASL $99,X 
$B132  01 1A     ORA ($1A,X)
$B134            .byte $34
$B135  01 1A     ORA ($1A,X)
$B137            .byte $37
$B138  01 1C     ORA ($1C,X)
$B13A            .byte $37
$B13B  01 1B     ORA ($1B,X)
$B13D            .byte $34
$B13E  0E 01 16  ASL $1601 
$B141            .byte $34,$00,$04,$04
$B145  20 31 44  JSR L_JSR_($4431)_($B145) BAD
$B148  01 16     ORA ($16,X)
$B14A  35 01     AND $01,X 
$B14C  16 36     ASL $36,X 
$B14E  01 17     ORA ($17,X)
$B150            .byte $37
$B151  01 1A     ORA ($1A,X)
$B153            .byte $37
$B154  01 1A     ORA ($1A,X)
$B156            .byte $34
$B157  01 18     ORA ($18,X)
$B159            .byte $34
$B15A  88        DEY 
$B15B  20 07 8F  JSR L_JSR_($8F07)_($B15B) JAM
$B15E  0E A2 12  ASL $12A2 
$B161  81 A0     STA ($A0,X) 
$B163  86 01     STX $01 
$B165  85 1E     STA $1E 
$B167  85 1F     STA $1F 
$B169  85 20     STA $20 
$B16B  85 21     STA $21 
$B16D  85 22     STA $22 
$B16F            .byte $0C
$B170  01 15     ORA ($15,X)
$B172  36 00     ROL $00,X 
$B174            .byte $02
$B175  01 21     ORA ($21,X)
$B177  16 44     ASL $44,X 
$B179  01 15     ORA ($15,X)
$B17B  36 01     ROL $01,X 
$B17D  15 37     ORA $37,X
$B17F  01 17     ORA ($17,X)
$B181            .byte $37
$B182  01 16     ORA ($16,X)
$B184  36 0B     ROL $0B,X 
$B186  01 18     ORA ($18,X)
$B188            .byte $33,$00
$B18A  01 01     ORA ($01,X)
$B18C            .byte $22,$13,$44
$B18F  01 18     ORA ($18,X)
$B191            .byte $33
$B192  01 18     ORA ($18,X)
$B194            .byte $34
$B195  01 1A     ORA ($1A,X)
$B197            .byte $34,$00,$00
$B19A  0A        ASL A 
$B19B  19 B9 00  ORA $00B9,Y
$B19E  05 00     ORA $00
$B1A0  01 06     ORA ($06,X)
$B1A2  08        PHP 
$B1A3            .byte $04,$42,$32,$34,$43
$B1A8  C0 80     CPY #$80
$B1AA  81 82     STA ($82,X) 
$B1AC            .byte $83
$B1AD  84 85     STY $85 
$B1AF            .byte $FF,$0B
$B1B1  86 87     STX $87 
$B1B3  01 16     ORA ($16,X)
$B1B5            .byte $12
$B1B6  01 14     ORA ($14,X)
$B1B8  01 3E     ORA ($3E,X)
$B1BA            .byte $02,$0C
$B1BC  88        DEY 
$B1BD  88        DEY 
$B1BE  88        DEY 
$B1BF  09 16     ORA #$16
$B1C1            .byte $0C
$B1C2  31 14     AND ($14),Y 
$B1C4  06 05     ASL $05 
$B1C6            .byte $03
$B1C7  10 04     BPL L_BRS_($B1CD)_($B1C7) BAD
$B1C9            .byte $3B
$B1CA  45 00     EOR $00 
//------------------------------
L_BRS_($B1CD)_($B1C7) BAD
//------------------------------
$B1CC  06 14     ASL $14 
$B1CE  06 0C     ASL $0C 
$B1D0  1D 01 32  ORA $3201,X
$B1D3  06 0B     ASL $0B 
$B1D5            .byte $00
$B1D6  05 19     ORA $19
$B1D8  11 1D     ORA ($1D),Y
$B1DA  01 3E     ORA ($3E,X)
$B1DC  1D 0D 32  ORA $320D,X
$B1DF  24 0D     BIT $0D 
$B1E1            .byte $32
$B1E2  24 01     BIT $01 
$B1E4  3E 12 01  ROL $0112,X 
$B1E7  16 09     ASL $09,X 
$B1E9  16 01     ASL $01,X 
$B1EB  35 14     AND $14,X 
$B1ED            .byte $0B
$B1EE  09 04     ORA #$04
$B1F0  10 04     BPL L_BRS_($B1F6)_($B1F0) JAM
//------------------------------
L_BRS_($B1F6)_($B1F0) JAM
//------------------------------
$B1F2            .byte $00,$00,$00,$0C,$14,$14
$B1F8  C0 1F     CPY #$1F
$B1FA  01 30     ORA ($30,X)
$B1FC            .byte $00
$B1FD  24 00     BIT $00 
$B1FF  06 09     ASL $09 
$B201            .byte $03
$B202  1D 01 01  ORA $0101,X
$B205  06 0C     ASL $0C 
$B207            .byte $00,$07
$B209  0D 11 12  ORA $1211
$B20C            .byte $1B,$CB
$B20E  01 1D     ORA ($1D,X)
$B210            .byte $02
$B211  01 06     ORA ($06,X)
$B213  0A        ASL A 
$B214  01 09     ORA ($09,X)
$B216  18        CLC 
$B217  55 66     EOR $66,X 
$B219  99 83 08  STA $0883,Y 
$B21C            .byte $83
$B21D  09 9C     ORA #$9C
$B21F  08        PHP 
$B220  88        DEY 
$B221            .byte $1B
$B222  09 87     ORA #$87
$B224            .byte $1B
$B225  01 C1     ORA ($C1,X)
$B227  16 02     ASL $02,X 
$B229  01 06     ORA ($06,X)
$B22B  0A        ASL A 
$B22C  01 08     ORA ($08,X)
$B22E  18        CLC 
$B22F  55 66     EOR $66,X 
$B231  99 83 08  STA $0883,Y 
$B234            .byte $83
$B235  09 9C     ORA #$9C
$B237  0D 87 1B  ORA $1B87
$B23A  09 88     ORA #$88
$B23C            .byte $1B
$B23D  01 07     ORA ($07,X)
$B23F  16 06     ASL $06,X 
$B241  10 02     BPL L_BRS_($B245)_($B241) OK
$B243            .byte $02
$B244  08        PHP 
//------------------------------
L_BRS_($B245)_($B241) OK
//------------------------------
$B245  0A        ASL A 
$B246            .byte $14
$B247  06 C7     ASL $C7 
$B249            .byte $03,$00,$02,$00
$B24D  06 02     ASL $02 
$B24F  01 1C     ORA ($1C,X)
$B251            .byte $12,$00,$00,$0B,$1A
$B256  9D 00 05  STA $0500,X 
$B259            .byte $00
$B25A  01 06     ORA ($06,X)
$B25C  08        PHP 
$B25D            .byte $04,$43,$33
//------------------------------
L_BRS_($B261)_($B2D8) BAD
//------------------------------
$B260  36 43     ROL $43,X 
$B262  C0 80     CPY #$80
$B264  8A        TXA 
$B265            .byte $82,$83
$B267  84 85     STY $85 
$B269            .byte $FF
$B26A  09 03     ORA #$03
$B26C  1D 01 3F  ORA $3F01,X
$B26F  06 0C     ASL $0C 
$B271            .byte $00
$B272  01 0D     ORA ($0D,X)
$B274  11 12     ORA ($12),Y
$B276  18        CLC 
$B277  BA        TSX 
$B278            .byte $03
$B279  38        SEC 
$B27A  01 3F     ORA ($3F,X)
$B27C  06 06     ASL $06 
$B27E            .byte $00,$02
$B280  0D 11 12  ORA $1211
$B283  18        CLC 
$B284  08        PHP 
$B285            .byte $03,$02
$B287  01 3F     ORA ($3F,X)
$B289  06 06     ASL $06 
$B28B            .byte $00,$03
$B28D  0D 11 12  ORA $1211
$B290  18        CLC 
$B291  08        PHP 
$B292            .byte $03,$0F
$B294  01 3F     ORA ($3F,X)
$B296  06 09     ASL $09 
$B298            .byte $00,$04
$B29A  0D 11 12  ORA $1211
$B29D  18        CLC 
$B29E  BA        TSX 
$B29F            .byte $03,$2B
$B2A1  01 3F     ORA ($3F,X)
$B2A3  06 09     ASL $09 
$B2A5            .byte $00
$B2A6  05 0D     ORA $0D
$B2A8  11 12     ORA ($12),Y
$B2AA  18        CLC 
$B2AB            .byte $B8,$03,$3F
$B2AE  01 1D     ORA ($1D,X)
$B2B0            .byte $00,$0C
$B2B2  06 06     ASL $06 
$B2B4  0D 11 12  ORA $1211
$B2B7            .byte $1B,$C2,$03
//------------------------------
L_BRS_($B2BC)_($B309) BAD
//------------------------------
$B2BA  1D 01 01  ORA $0101,X
$B2BD  06 0C     ASL $0C 
$B2BF            .byte $00,$07
$B2C1  0D 11 12  ORA $1211
$B2C4            .byte $0C,$BF
$B2C6  01 3D     ORA ($3D,X)
$B2C8  01 1C     ORA ($1C,X)
$B2CA            .byte $02
$B2CB  0D 08 08  ORA $0808
$B2CE  18        CLC 
$B2CF            .byte $33
$B2D0  55 77     EOR $77,X 
$B2D2  85 08     STA $08 
$B2D4  84 06     STY $06 
$B2D6  88        DEY 
$B2D7            .byte $1B
$B2D8  10 87     BPL L_BRS_($B261)_($B2D8) BAD
$B2DA            .byte $1B
$B2DB  06 9C     ASL $9C 
$B2DD  08        PHP 
$B2DE  C0 13     CPY #$13
$B2E0  01 3D     ORA ($3D,X)
$B2E2            .byte $00
$B2E3  24 00     BIT $00 
$B2E5  09 09     ORA #$09
$B2E7  C0 1E     CPY #$1E
$B2E9  01 3D     ORA ($3D,X)
$B2EB            .byte $00
$B2EC  24 00     BIT $00 
$B2EE  0A        ASL A 
$B2EF  09 00     ORA #$00
$B2F1            .byte $00,$0F,$1B,$F8,$00
$B2F6  05 00     ORA $00
$B2F8  01 06     ORA ($06,X)
$B2FA  08        PHP 
$B2FB            .byte $04,$44,$32,$34,$43
$B300  C0 80     CPY #$80
$B302  81 82     STA ($82,X) 
$B304            .byte $83
$B305  84 85     STY $85 
$B307            .byte $FF,$0B
$B309  B0 B1     BCS L_BRS_($B2BC)_($B309) BAD
$B30B            .byte $C3
$B30C  1D 01 3F  ORA $3F01,X
$B30F  06 0C     ASL $0C 
$B311            .byte $00
$B312  01 0D     ORA ($0D,X)
$B314  11 12     ORA ($12),Y
$B316  19 C5 01  ORA $01C5,Y
$B319  01 0D     ORA ($0D,X)
$B31B  01 3E     ORA ($3E,X)
$B31D            .byte $04
$B31E  08        PHP 
$B31F            .byte $02,$0C
$B321  DD B8 66  CMP $66B8,X 
$B324  01 01     ORA ($01,X)
$B326  0D 09 08  ORA $0809
$B329            .byte $04,$1B,$03,$0C
$B32D  DD B8 66  CMP $66B8,X 
$B330  01 37     ORA ($37,X)
$B332  0D 09 08  ORA $0809
$B335            .byte $04,$1B,$04,$0C
$B339  DD B8 66  CMP $66B8,X 
$B33C            .byte $03,$3F
$B33E  11 1D     ORA ($1D),Y
$B340            .byte $00,$0C
$B342  06 05     ASL $05 
$B344  0D 11 12  ORA $1211
$B347  15 CE     ORA $CE,X
$B349            .byte $C3
$B34A  01 11     ORA ($11,X)
$B34C  1D 00 0C  ORA $0C00,X
$B34F  06 06     ASL $06 
$B351  0D 11 12  ORA $1211
$B354            .byte $1A
$B355  C8        INY 
$B356            .byte $03
$B357  1D 11 01  ORA $0111,X
$B35A  06 0C     ASL $0C 
$B35C            .byte $00,$07
$B35E  0D 11 12  ORA $1211
$B361  0D CB 03  ORA $03CB
$B364  01 01     ORA ($01,X)
$B366            .byte $02,$00,$0B
$B369  05 08     ORA $08
$B36B  0E 55 22  ASL $2255 
$B36E  0A        ASL A 
$B36F            .byte $1C,$13
$B371  01 1C     ORA ($1C,X)
$B373  15 01     ORA $01,X
$B375  08        PHP 
$B376            .byte $04
$B377  01 50     ORA ($50,X)
$B379  18        CLC 
$B37A  55 66     EOR $66,X 
$B37C  99 0E 03  STA $030E,Y 
$B37F  01 0A     ORA ($0A,X)
$B381  20 1C 09  JSR L_JSR_($091C)_($B381) OK
$B384  05 50     ORA $50
$B386  08        PHP 
$B387  0D 50 03  ORA $0350
$B38A  1D 01 3F  ORA $3F01,X
$B38D  06 0C     ASL $0C 
$B38F            .byte $00
$B390  09 0E     ORA #$0E
$B392  55 22     EOR $22,X 
$B394  0A        ASL A 
$B395            .byte $0F,$13,$C3
$B398  01 01     ORA ($01,X)
$B39A            .byte $02,$00,$0B
$B39D  05 11     ORA $11
$B39F  0D 11 12  ORA $1211
$B3A2  35 C7     AND $C7,X 
$B3A4            .byte $03
$B3A5  01 11     ORA ($11,X)
$B3A7  1D 00 0C  ORA $0C00,X
//------------------------------
L_BRS_($B3AA)_($B425) OK
//------------------------------
$B3AA  06 10     ASL $10 
$B3AC  0E 55 22  ASL $2255 
$B3AF  0A        ASL A 
$B3B0            .byte $1C,$13
$B3B2  06 30     ASL $30 
$B3B4            .byte $07
$B3B5  30 05     BMI L_BRS_($B3BC)_($B3B5) OK
$B3B7  01 05     ORA ($05,X)
//------------------------------
L_BRS_($B3B9)_($B406) OK
//------------------------------
$B3B9  20 21 35  JSR L_JSR_($3521)_($B3B9) OK
//------------------------------
L_BRS_($B3BC)_($B3B5) OK
//------------------------------
$B3BC  35 11     AND $11,X 
$B3BE  01 01     ORA ($01,X)
$B3C0            .byte $04,$04,$0F,$14
$B3C4  01 C4     ORA ($C4,X)
$B3C6  09 00     ORA #$00
$B3C8  09 10     ORA #$10
$B3CA            .byte $0B
$B3CB  10 14     BPL L_BRS_($B3E1)_($B3CB) JAM
$B3CD  05 20     ORA $20
$B3CF  05 21     ORA $21
$B3D1            .byte $13,$32,$07
$B3D4  30 01     BMI L_BRS_($B3D7)_($B3D4) BAD
//------------------------------
L_BRS_($B3D7)_($B3D4) BAD
//------------------------------
$B3D6  30 05     BMI L_BRS_($B3DD)_($B3D6) JAM
$B3D8  06 05     ASL $05 
$B3DA  21 16     AND ($16,X) 
//------------------------------
L_BRS_($B3DD)_($B3D6) JAM
L_BRS_($B3E1)_($B3CB) JAM
//------------------------------
$B3DC            .byte $53,$53,$00,$02,$02,$03,$03,$0F
$B3E4            .byte $13
$B3E5  A2 0E     LDX #$0E
$B3E7            .byte $8F
//------------------------------
L_BRS_($B3E8)_($B461) OK
//------------------------------
$B3E8  05 00     ORA $00
$B3EA            .byte $00,$07,$1C,$97,$00
$B3EF  05 00     ORA $00
$B3F1  01 06     ORA ($06,X)
$B3F3            .byte $02
$B3F4  05 41     ORA $41
$B3F6            .byte $34
$B3F7  38        SEC 
$B3F8            .byte $43
$B3F9  C0 80     CPY #$80
$B3FB  81 82     STA ($82,X) 
$B3FD            .byte $83
$B3FE  84 85     STY $85 
$B400            .byte $FF
//------------------------------
L_BRS_($B401)_($B463) OK
//------------------------------
$B401  11 AB     ORA ($AB),Y
$B403  AE AF B2  LDX $B2AF 
$B406  B0 B1     BCS L_BRS_($B3B9)_($B406) OK
$B408  AC AD 03  LDY $03AD 
$B40B  1D 01 01  ORA $0101,X
$B40E  06 0C     ASL $0C 
$B410            .byte $00
$B411  01 0D     ORA ($0D,X)
$B413  11 12     ORA ($12),Y
$B415  0D BF 03  ORA $03BF
$B418  1D 11 01  ORA $0111,X
$B41B  06 0C     ASL $0C 
$B41D            .byte $00,$02,$13
$B420  11 12     ORA ($12),Y
$B422            .byte $1F,$CB,$83
$B425  B0 83     BCS L_BRS_($B3AA)_($B425) OK
$B427  B1 9C     LDA ($9C),Y 
$B429            .byte $0F,$03,$3F
$B42C  11 1D     ORA ($1D),Y
$B42E            .byte $00,$0C
$B430  06 03     ASL $03 
$B432            .byte $13
$B433  11 12     ORA ($12),Y
$B435  1D CE 83  ORA $83CE,X
$B438  AC 83 AD  LDY $AD83 
$B43B            .byte $9C,$0F,$03,$3F
$B43F  01 1D     ORA ($1D,X)
$B441            .byte $00,$0C
$B443  06 04     ASL $04 
$B445  0D 11 12  ORA $1211
$B448  15 C2     ORA $C2,X
$B44A  01 1C     ORA ($1C,X)
$B44C  15 01     ORA $01,X
$B44E  08        PHP 
$B44F            .byte $04
$B450  01 50     ORA ($50,X)
$B452            .byte $1F
$B453  55 66     EOR $66,X 
$B455  99 0E 03  STA $030E,Y 
$B458  01 0A     ORA ($0A,X)
$B45A  20 1C 09  JSR L_JSR_($091C)_($B45A) OK
$B45D  05 50     ORA $50
$B45F  08        PHP 
$B460            .byte $1F
$B461  50 85     BVC L_BRS_($B3E8)_($B461) OK
$B463  50 9C     BVC L_BRS_($B401)_($B463) OK
$B465  08        PHP 
$B466  88        DEY 
$B467            .byte $1F
$B468  50 01     BVC L_BRS_($B46B)_($B468) BAD
//------------------------------
L_BRS_($B46B)_($B468) BAD
//------------------------------
$B46A  3E 15 1C  ROL $1C15,X 
$B46D  01 04     ORA ($04,X)
$B46F  08        PHP 
$B470  51 18     EOR ($18),Y 
$B472  55 66     EOR $66,X 
$B474  99 0E 03  STA $030E,Y 
$B477  01 0A     ORA ($0A,X)
$B479  20 1C 09  JSR L_JSR_($091C)_($B479) OK
$B47C  05 51     ORA $51
$B47E  08        PHP 
$B47F  1D 50 02  ORA $0250,X
$B482  08        PHP 
$B483  5E AC 45  LSR $45AC,X 
$B486  AC 45 AD  LDY $AD45 
$B489            .byte $5C
$B48A  05 08     ORA $08
$B48C  5E B0 45  LSR $45B0,X 
$B48F  B0 45     BCS L_BRS_($B4D6)_($B48F) OK
$B491  B1 5C     LDA ($5C),Y 
$B493  05 00     ORA $00
$B495            .byte $0B
$B496  1D CE 00  ORA $00CE,X
$B499  05 00     ORA $00
$B49B  01 06     ORA ($06,X)
$B49D            .byte $02
$B49E  05 42     ORA $42
$B4A0  36 30     ROL $30,X 
$B4A2            .byte $43
$B4A3  C0 80     CPY #$80
$B4A5  81 82     STA ($82,X) 
$B4A7            .byte $83
$B4A8  84 85     STY $85 
$B4AA            .byte $FF
$B4AB  09 03     ORA #$03
$B4AD  01 01     ORA ($01,X)
$B4AF  1D 00 0C  ORA $0C00,X
$B4B2  06 01     ASL $01 
$B4B4  0D 11 12  ORA $1211
$B4B7            .byte $1C
$B4B8  BC 03 1D  LDY $1D03,X 
$B4BB  01 01     ORA ($01,X)
$B4BD  06 0C     ASL $0C 
$B4BF            .byte $00,$02
//------------------------------
L_BRS_($B4C1)_($B4E2) OK
//------------------------------
$B4C1  0D 11 12  ORA $1211
$B4C4            .byte $03
$B4C5  08        PHP 
$B4C6  01 2A     ORA ($2A,X)
$B4C8  01 01     ORA ($01,X)
$B4CA  15 04     ORA $04,X
$B4CC  15 03     ORA $03,X
$B4CE            .byte $14
$B4CF  DD BB 66  CMP $66BB,X 
$B4D2  85 03     STA $03 
$B4D4            .byte $9C
$B4D5  08        PHP 
//------------------------------
L_BRS_($B4D6)_($B48F) OK
//------------------------------
$B4D6  85 04     STA $04 
$B4D8  85 05     STA $05 
$B4DA  01 2E     ORA ($2E,X)
$B4DC  05 01     ORA $01
$B4DE  11 04     ORA ($04),Y
$B4E0  11 04     ORA ($04),Y
$B4E2  10 DD     BPL L_BRS_($B4C1)_($B4E2) OK
$B4E4            .byte $BB
$B4E5  66 85     ROR $85 
$B4E7            .byte $04,$9C
$B4E9  08        PHP 
$B4EA  01 32     ORA ($32,X)
$B4EC  09 01     ORA #$01
$B4EE  0D 04 0D  ORA $0D04
$B4F1  05 10     ORA $10
$B4F3  DD BB 66  CMP $66BB,X 
$B4F6  85 05     STA $05 
$B4F8            .byte $9C
$B4F9  08        PHP 
$B4FA  01 36     ORA ($36,X)
$B4FC  0D 01 09  ORA $0901
$B4FF            .byte $04
$B500  09 06     ORA #$06
$B502            .byte $0C
$B503  DD BB 66  CMP $66BB,X 
$B506            .byte $07
$B507  39 11 02  AND $0211,Y 
$B50A  05 06     ORA $06
$B50C  05 07     ORA $07
$B50E  16 35     ASL $35,X 
$B510  35 00     AND $00,X 
$B512            .byte $02,$02,$03,$03,$0F,$13
$B518  A2 0E     LDX #$0E
$B51A            .byte $8F
$B51B  05 06     ORA $06
$B51D  39 17 02  AND $0217,Y 
$B520  05 01     ORA $01
$B522  05 08     ORA $08
$B524  21 53     AND ($53,X) 
$B526            .byte $53
$B527  11 01     ORA ($01),Y
$B529  01 04     ORA ($04,X)
$B52B            .byte $04,$0F,$14
$B52E  01 C4     ORA ($C4,X)
$B530  09 00     ORA #$00
$B532  09 0D     ORA #$0D
$B534            .byte $0B
$B535  0D A0 05  ORA $05A0
$B538  08        PHP 
$B539  05 07     ORA $07
$B53B            .byte $13,$32,$03,$3F
$B53F  01 02     ORA ($02,X)
$B541            .byte $00,$0C
$B543  06 09     ASL $09 
$B545  0D 11 12  ORA $1211
$B548  1E B7 01  ASL $01B7,X 
$B54B  01 05     ORA ($05,X)
$B54D            .byte $1C
$B54E  01 04     ORA ($04,X)
$B550  08        PHP 
$B551  50 18     BVC L_BRS_($B56B)_($B551) BAD
$B553  55 66     EOR $66,X 
$B555  99 0E 03  STA $030E,Y 
$B558  01 0A     ORA ($0A,X)
$B55A  20 1C 09  JSR L_JSR_($091C)_($B55A) OK
$B55D  05 50     ORA $50
$B55F  08        PHP 
$B560            .byte $1C
$B561  51 00     EOR ($00),Y 
$B563            .byte $00
$B564  08        PHP 
$B565  1E A3 00  ASL $00A3,X 
$B568  05 00     ORA $00
//------------------------------
L_BRS_($B56B)_($B551) BAD
//------------------------------
$B56A  01 06     ORA ($06,X)
$B56C            .byte $02
$B56D  05 43     ORA $43
$B56F            .byte $34
$B570  38        SEC 
$B571            .byte $43
$B572  C0 80     CPY #$80
$B574  81 82     STA ($82,X) 
$B576            .byte $83
$B577  84 85     STY $85 
$B579            .byte $FF
$B57A  0D B3 B4  ORA $B4B3
$B57D  B5 B6     LDA $B6,X 
$B57F            .byte $03
$B580  01 11     ORA ($11,X)
$B582            .byte $02,$00,$0C
$B585  06 01     ASL $01 
$B587            .byte $12
$B588  11 1C     ORA ($1C),Y
$B58A            .byte $13
$B58B  21 1D     AND ($1D,X) 
$B58D            .byte $03,$12
$B58F  1D C7 03  ORA $03C7,X
$B592  1D 11 01  ORA $0111,X
$B595  06 0C     ASL $0C 
$B597            .byte $00,$02
$B599  0D 11 12  ORA $1211
$B59C  20 CB 03  JSR $03CB
$B59F            .byte $02
$B5A0  01 01     ORA ($01,X)
$B5A2  06 0C     ASL $0C 
$B5A4            .byte $00,$03
$B5A6  0D 11 12  ORA $1211
$B5A9            .byte $04
$B5AA  C0 01     CPY #$01
$B5AC  01 0F     ORA ($0F,X)
$B5AE  01 3E     ORA ($3E,X)
$B5B0            .byte $02
$B5B1  1E 04 0C  ASL $0C04,X 
$B5B4  DD BB 66  CMP $66BB,X 
$B5B7  01 1C     ORA ($1C,X)
$B5B9  15 01     ORA $01,X
$B5BB  08        PHP 
$B5BC            .byte $04
$B5BD  01 50     ORA ($50,X)
$B5BF  18        CLC 
$B5C0  55 66     EOR $66,X 
$B5C2  99 0E 03  STA $030E,Y 
$B5C5  01 0A     ORA ($0A,X)
$B5C7  20 1C 09  JSR L_JSR_($091C)_($B5C7) OK
$B5CA  05 50     ORA $50
$B5CC  08        PHP 
$B5CD  20 50 06  JSR $0650
$B5D0  30 17     BMI L_BRS_($B5E9)_($B5D0) OK
$B5D2  06 05     ASL $05 
$B5D4  01 05     ORA ($05,X)
$B5D6  10 21     BPL L_BRS_($B5F9)_($B5D6) JAM
$B5D8  35 35     AND $35,X 
$B5DA  11 01     ORA ($01),Y
$B5DC  01 04     ORA ($04,X)
$B5DE            .byte $04,$0F,$14
$B5E1  01 C4     ORA ($C4,X)
$B5E3  09 00     ORA #$00
$B5E5  09 0C     ORA #$0C
$B5E7            .byte $0B,$0C
//------------------------------
L_BRS_($B5E9)_($B5D0) OK
//------------------------------
$B5E9  9D 05 10  STA $1005,X 
$B5EC  05 11     ORA $11
$B5EE            .byte $13,$32,$07
$B5F1  30 11     BMI L_BRS_($B604)_($B5F1) JAM
$B5F3  06 05     ASL $05 
$B5F5  06 05     ASL $05 
$B5F7  11 16     ORA ($16),Y
//------------------------------
L_BRS_($B5F9)_($B5D6) JAM
//------------------------------
$B5F9            .byte $53,$53,$00,$02,$02,$03,$03,$0F
$B601            .byte $13
$B602  A2 0E     LDX #$0E
//------------------------------
L_BRS_($B604)_($B5F1) JAM
//------------------------------
$B604            .byte $8F
$B605  05 00     ORA $00
$B607            .byte $00
$B608  06 1F     ASL $1F 
$B60A  6A        ROR A 
$B60B            .byte $00
$B60C  05 00     ORA $00
$B60E  01 06     ORA ($06,X)
$B610            .byte $02
$B611  05 44     ORA $44
$B613  36 30     ROL $30,X 
$B615            .byte $43
$B616  C0 80     CPY #$80
$B618  81 82     STA ($82,X) 
$B61A            .byte $83
$B61B  84 85     STY $85 
$B61D            .byte $FF
$B61E  11 AB     ORA ($AB),Y
$B620  AC AD AE  LDY $AEAD                          // Continue Expression
$B623            .byte $A7
$B624  A8        TAY 
$B625  A9 AA     LDA #$AA
$B627            .byte $03
$B628  1D 01 3F  ORA $3F01,X
$B62B  06 0C     ASL $0C 
$B62D            .byte $00
$B62E  01 0D     ORA ($0D,X)
$B630  11 12     ORA ($12),Y
$B632            .byte $1C
$B633  B9 03 1D  LDA $1D03,Y 
$B636  01 01     ORA ($01,X)
$B638  06 0C     ASL $0C 
$B63A            .byte $00,$03
$B63C  0D 11 12  ORA $1211
$B63F  21 BF     AND ($BF,X) 
$B641  01 05     ORA ($05,X)
$B643  01 1A     ORA ($1A,X)
$B645            .byte $3A,$0B,$02,$04,$0C,$33,$77
$B64C  55 01     EOR $01,X 
$B64E  18        CLC 
$B64F  01 1C     ORA ($1C,X)
$B651            .byte $02,$14,$23
$B654  05 0C     ORA $0C
$B656            .byte $33
$B657  66 55     ROR $55 
$B659  01 1C     ORA ($1C,X)
$B65B  05 3E     ORA $3E
$B65D  08        PHP 
$B65E            .byte $04
$B65F  01 50     ORA ($50,X)
$B661  18        CLC 
$B662  55 66     EOR $66,X 
$B664  99 0E 03  STA $030E,Y 
$B667  01 0A     ORA ($0A,X)
$B669  20 1C 09  JSR L_JSR_($091C)_($B669) OK
$B66C  05 50     ORA $50
$B66E  08        PHP 
$B66F            .byte $1C
$B670  50 00     BVC L_BRS_($B672)_($B670) JAM
//------------------------------
L_BRS_($B672)_($B670) JAM
//------------------------------
$B672            .byte $00
$B673  11 20     ORA ($20),Y
$B675  2E 01 05  ROL $0501 
$B678            .byte $00
$B679  01 06     ORA ($06,X)
$B67B            .byte $02
$B67C  05 45     ORA $45
$B67E  36 30     ROL $30,X 
$B680            .byte $43
$B681  C0 80     CPY #$80
$B683  81 82     STA ($82,X) 
$B685            .byte $83
$B686  84 85     STY $85 
$B688            .byte $FF
$B689  0D A8 A8  ORA $A8A8
$B68C  A9 AA     LDA #$AA
$B68E            .byte $03
$B68F  1D 01 3F  ORA $3F01,X
$B692  06 0C     ASL $0C 
$B694            .byte $00
$B695  01 0D     ORA ($0D,X)
$B697  11 12     ORA ($12),Y
$B699  1E B9 03  ASL $03B9,X 
$B69C  1D 01 01  ORA $0101,X
$B69F  06 0C     ASL $0C 
$B6A1            .byte $00,$02
$B6A3  0D 11 12  ORA $1211
$B6A6            .byte $23,$BF
$B6A8  01 1C     ORA ($1C,X)
$B6AA            .byte $04
$B6AB  3E 08 04  ROL $0408,X 
$B6AE  01 50     ORA ($50,X)
$B6B0  18        CLC 
$B6B1  55 66     EOR $66,X 
$B6B3  99 0E 03  STA $030E,Y 
$B6B6  01 0A     ORA ($0A,X)
$B6B8  20 1C 09  JSR L_JSR_($091C)_($B6B8) OK
$B6BB  05 50     ORA $50
$B6BD  08        PHP 
$B6BE  1E 50 03  ASL $0350,X 
$B6C1  01 11     ORA ($11,X)
$B6C3  1D 00 0C  ORA $0C00,X
$B6C6  06 04     ASL $04 
$B6C8  0D 11 12  ORA $1211
$B6CB  24 C8     BIT $C8 
$B6CD  01 01     ORA ($01,X)
$B6CF  0D 08 04  ORA $0408
$B6D2  10 30     BPL L_BRS_($B704)_($B6D2) OK
$B6D4  05 10     ORA $10
$B6D6            .byte $33,$FF
$B6D8  99 00 00  STA $0000,Y 
$B6DB            .byte $00,$00,$07,$03
$B6DF  01 2E     ORA ($2E,X)
$B6E1  01 0C     ORA ($0C,X)
$B6E3  08        PHP 
$B6E4            .byte $07,$14
$B6E6  95 95     STA $95,X 
$B6E8            .byte $00,$00,$02
$B6EB  01 06     ORA ($06,X)
$B6ED  A2 0D     LDX #$0D
$B6EF            .byte $8F
$B6F0  05 07     ORA $07
$B6F2            .byte $03
$B6F3  01 0B     ORA ($0B,X)
$B6F5  01 0C     ORA ($0C,X)
$B6F7  08        PHP 
$B6F8  08        PHP 
$B6F9            .byte $14
$B6FA  95 95     STA $95,X 
$B6FC            .byte $00,$00,$02
$B6FF  01 06     ORA ($06,X)
$B701  A2 0D     LDX #$0D
$B703            .byte $8F
//------------------------------
L_BRS_($B704)_($B6D2) OK
//------------------------------
$B704  05 C1     ORA $C1
$B706  01 01     ORA ($01,X)
$B708  08        PHP 
$B709            .byte $04
$B70A  10 30     BPL L_BRS_($B73C)_($B70A) JAM
$B70C  06 0C     ASL $0C 
$B70E  55 77     EOR $77,X 
$B710  88        DEY 
$B711            .byte $0C
$B712  05 10     ORA $10
$B714            .byte $32,$00,$07,$04
$B718  0E 16 44  ASL $4416 
$B71B  05 10     ORA $10
$B71D            .byte $32
$B71E  05 10     ORA $10
$B720  36 05     ROL $05,X 
$B722            .byte $17,$34
$B724  05 17     ORA $17
$B726            .byte $32,$0C
$B728  05 15     ORA $15
$B72A            .byte $2F,$00,$02,$03,$0F
$B72F  16 44     ASL $44,X 
$B731  05 15     ORA $15
$B733            .byte $2F
$B734  05 15     ORA $15
$B736            .byte $32
$B737  05 17     ORA $17
$B739            .byte $32
$B73A  05 16     ORA $16
//------------------------------
L_BRS_($B73C)_($B70A) JAM
//------------------------------
$B73C            .byte $2F
$B73D  0E 05 11  ASL $1105 
$B740            .byte $2F,$00,$04,$04
$B744  10 1C     BPL L_BRS_($B762)_($B744) BAD
$B746            .byte $22
$B747  05 11     ORA $11
$B749  30 05     BMI L_BRS_($B750)_($B749) OK
$B74B  11 31     ORA ($31),Y
$B74D  05 12     ORA $12
$B74F            .byte $32
//------------------------------
L_BRS_($B750)_($B749) OK
//------------------------------
$B750  05 15     ORA $15
$B752            .byte $32
$B753  05 15     ORA $15
$B755            .byte $2F
$B756  05 13     ORA $13
$B758            .byte $2F,$0C
$B75A  05 10     ORA $10
$B75C  31 00     AND ($00),Y 
$B75E            .byte $02
$B75F  01 11     ORA ($11,X)
//------------------------------
L_BRS_($B762)_($B744) BAD
//------------------------------
$B761  16 22     ASL $22,X 
$B763  05 10     ORA $10
$B765  31 05     AND ($05),Y 
$B767  10 32     BPL L_BRS_($B79B)_($B767) OK
$B769  05 12     ORA $12
$B76B            .byte $32
$B76C  05 11     ORA $11
$B76E  31 0B     AND ($0B),Y 
$B770  05 13     ORA $13
$B772  2E 00 01  ROL $0100 
$B775  01 12     ORA ($12,X)
$B777            .byte $13,$22
$B779  05 13     ORA $13
$B77B  2E 05 13  ROL $1305 
$B77E            .byte $2F
$B77F  05 15     ORA $15
$B781            .byte $2F,$03
$B783  05 12     ORA $12
$B785            .byte $13,$00,$03
$B788  01 13     ORA ($13,X)
$B78A  0A        ASL A 
$B78B            .byte $22,$03
$B78D  05 12     ORA $12
$B78F            .byte $0B,$00,$03
$B792  01 14     ORA ($14,X)
$B794  0A        ASL A 
$B795            .byte $22,$03
$B797  05 13     ORA $13
$B799  0A        ASL A 
$B79A            .byte $00
//------------------------------
L_BRS_($B79B)_($B767) OK
//------------------------------
$B79B  01 0B     ORA ($0B,X)
$B79D  15 0A     ORA $0A,X
$B79F            .byte $22
$B7A0  01 1C     ORA ($1C,X)
$B7A2            .byte $5F,$07,$5F
$B7A5  08        PHP 
$B7A6            .byte $5F
$B7A7  06 45     ASL $45 
$B7A9  05 44     ORA $44
$B7AB  06 5C     ASL $5C 
$B7AD  08        PHP 
$B7AE  45 0E     EOR $0E 
$B7B0  45 0F     EOR $0F 
$B7B2  45 10     EOR $10 
$B7B4  45 11     EOR $11 
$B7B6  45 12     EOR $12 
$B7B8  45 13     EOR $13 
$B7BA  45 14     EOR $14 
$B7BC  45 15     EOR $15 
$B7BE            .byte $00,$0F
$B7C0  21 05     AND ($05,X) 
$B7C2  01 05     ORA ($05,X)
$B7C4            .byte $00
$B7C5  01 06     ORA ($06,X)
$B7C7            .byte $02
$B7C8  05 46     ORA $46
$B7CA            .byte $34
$B7CB  38        SEC 
$B7CC            .byte $43
$B7CD  C0 80     CPY #$80
$B7CF  81 82     STA ($82,X) 
$B7D1            .byte $83
$B7D2  84 85     STY $85 
$B7D4            .byte $FF
$B7D5  09 03     ORA #$03
$B7D7  1D 11 3F  ORA $3F11,X
$B7DA  06 0C     ASL $0C 
$B7DC            .byte $00
$B7DD  01 0D     ORA ($0D,X)
$B7DF  11 12     ORA ($12),Y
$B7E1            .byte $1F
//------------------------------
L_BRS_($B7E3)_($B804) BAD
//------------------------------
$B7E2  C5 03     CMP $03 
$B7E4            .byte $3F
$B7E5  11 1D     ORA ($1D),Y
$B7E7            .byte $00,$0C
$B7E9  06 02     ASL $02 
$B7EB  0D 11 12  ORA $1211
$B7EE            .byte $22
$B7EF  CE 01 1C  DEC $1C01 
$B7F2            .byte $0F,$1C,$23,$02
$B7F6  08        PHP 
$B7F7            .byte $03,$0C
$B7F9  DD BB 66  CMP $66BB,X 
$B7FC  01 1C     ORA ($1C,X)
$B7FE            .byte $0F
$B7FF  24 08     BIT $08 
$B801            .byte $02,$1B,$04
$B804  10 DD     BPL L_BRS_($B7E3)_($B804) BAD
$B806            .byte $BB
$B807  66 90     ROR $90 
$B809            .byte $04,$9C
$B80B  08        PHP 
$B80C  0E 0A 0C  ASL $0C0A 
$B80F            .byte $0F,$00,$03
$B812  06 05     ASL $05 
$B814            .byte $1C
$B815  11 0A     ORA ($0A),Y
$B817            .byte $0F
$B818  10 0A     BPL L_BRS_($B824)_($B818) BAD
$B81A  11 0F     ORA ($0F),Y
$B81C  0A        ASL A 
$B81D            .byte $12
$B81E  10 0A     BPL L_BRS_($B82A)_($B81E) JAM
$B820            .byte $12
$B821  11 0A     ORA ($0A),Y
//------------------------------
L_BRS_($B824)_($B818) BAD
//------------------------------
$B823  11 12     ORA ($12),Y
$B825  0A        ASL A 
$B826            .byte $0F
$B827  11 03     ORA ($03),Y
$B829  0A        ASL A 
//------------------------------
L_BRS_($B82A)_($B81E) JAM
//------------------------------
$B82A            .byte $0C
$B82B  10 00     BPL L_BRS_($B82D)_($B82B) JAM
//------------------------------
L_BRS_($B82D)_($B82B) JAM
//------------------------------
$B82D            .byte $04
$B82E  01 06     ORA ($06,X)
$B830  0A        ASL A 
$B831  11 03     ORA ($03),Y
$B833  0A        ASL A 
$B834  0E 0F 00  ASL $000F 
$B837  01 03     ORA ($03,X)
$B839            .byte $07
$B83A  0A        ASL A 
$B83B  11 0A     ORA ($0A),Y
$B83D  0A        ASL A 
$B83E            .byte $12
$B83F  10 00     BPL L_BRS_($B841)_($B83F) OK
//------------------------------
L_BRS_($B841)_($B83F) OK
//------------------------------
$B841  0E 00 08  ASL $0800 
$B844  20 11 0A  JSR L_JSR_($0A11)_($B844) OK
$B847            .byte $12
$B848  10 0A     BPL L_BRS_($B854)_($B848) OK
$B84A  20 10 85  JSR L_JSR_($8510)_($B84A) BAD
$B84D  08        PHP 
$B84E  85 05     STA $05 
$B850  85 06     STA $06 
$B852  85 07     STA $07 
//------------------------------
L_BRS_($B854)_($B848) OK
//------------------------------
$B854  84 09     STY $09 
$B856  84 0A     STY $0A 
$B858  84 0B     STY $0B 
$B85A            .byte $9C
$B85B  06 CE     ASL $CE 
$B85D            .byte $07
$B85E  01 0D     ORA ($0D,X)
$B860  0A        ASL A 
$B861            .byte $00,$07
$B863  09 2C     ORA #$2C
$B865  11 0C     ORA ($0C),Y
$B867  01 10     ORA ($10,X)
$B869  0A        ASL A 
$B86A  01 0F     ORA ($0F,X)
$B86C  09 01     ORA #$01
$B86E  10 09     BPL L_BRS_($B879)_($B86E) BAD
$B870  01 11     ORA ($11,X)
$B872  0A        ASL A 
$B873  01 12     ORA ($12,X)
$B875            .byte $0C
$B876  01 11     ORA ($11,X)
//------------------------------
L_BRS_($B879)_($B86E) BAD
//------------------------------
$B878  05 09     ORA $09
$B87A  05 0A     ORA $0A
$B87C  05 0B     ORA $0B
$B87E  09 20     ORA #$20
$B880            .byte $0F,$0B
$B882  01 4C     ORA ($4C,X)
$B884  1D 00 22  ORA $2200,X
$B887  09 C3     ORA #$C3
$B889            .byte $0B
$B88A  01 10     ORA ($10,X)
$B88C            .byte $04,$00
$B88E  01 0A     ORA ($0A,X)
$B890  0A        ASL A 
$B891  11 C3     ORA ($C3),Y
$B893            .byte $0C
$B894  01 0F     ORA ($0F,X)
$B896  01 00     ORA ($00,X)
$B898            .byte $03,$0B
$B89A  0A        ASL A 
$B89B  11 03     ORA ($03),Y
$B89D            .byte $3F
$B89E  01 02     ORA ($02,X)
$B8A0            .byte $00,$0C
$B8A2  06 0C     ASL $0C 
$B8A4  0D 11 12  ORA $1211
$B8A7  06 B7     ASL $B7 
$B8A9            .byte $03
$B8AA  1D 01 01  ORA $0101,X
$B8AD  06 0C     ASL $0C 
$B8AF            .byte $00
$B8B0  49 0D     EOR #$0D
$B8B2  11 12     ORA ($12),Y
$B8B4  11 BF     ORA ($BF),Y
$B8B6            .byte $C3,$3F
$B8B8  01 3A     ORA ($3A,X)
$B8BA            .byte $00,$0C,$02
$B8BD  0E 0D 11  ASL $110D 
$B8C0            .byte $12
$B8C1  06 C0     ASL $C0 
$B8C3            .byte $00,$00,$07,$22
$B8C7  7E 00 05  ROR $0500,X 
$B8CA            .byte $00
$B8CB  01 06     ORA ($06,X)
$B8CD            .byte $02
$B8CE  05 47     ORA $47
$B8D0  36 30     ROL $30,X 
$B8D2            .byte $43
$B8D3  C0 80     CPY #$80
$B8D5  81 82     STA ($82,X) 
$B8D7            .byte $83
$B8D8  88        DEY 
$B8D9            .byte $89,$FF
$B8DB  09 03     ORA #$03
$B8DD            .byte $3F
//------------------------------
L_BRS_($B8DF)_($B91B) BAD
//------------------------------
$B8DE  01 1D     ORA ($1D,X)
$B8E0            .byte $00,$0C
$B8E2  06 01     ASL $01 
$B8E4  0D 11 12  ORA $1211
$B8E7            .byte $23,$C2,$03
$B8EA  01 01     ORA ($01,X)
$B8EC  1D 00 0C  ORA $0C00,X
$B8EF  06 02     ASL $02 
$B8F1  0D 11 12  ORA $1211
$B8F4  21 BC     AND ($BC,X) 
$B8F6  0A        ASL A 
$B8F7  20 06 16  JSR L_JSR_($1606)_($B8F7) JAM
$B8FA            .byte $00,$02,$14,$03
$B8FE  18        CLC 
$B8FF            .byte $33
$B900  20 06 16  JSR L_JSR_($1606)_($B900) JAM
$B903  20 06 2A  JSR L_JSR_($2A06)_($B903) BAD
$B906            .byte $04,$04,$04
$B909  05 05     ORA $05
$B90B            .byte $03,$1C,$0F,$C2,$12
$B910  0A        ASL A 
$B911  2A        ROL A 
$B912            .byte $00,$00,$00,$04
$B916  0E 11 08  ASL $0811 
$B919  C8        INY 
$B91A            .byte $17
$B91B  10 C2     BPL L_BRS_($B8DF)_($B91B) BAD
$B91D            .byte $12
$B91E  0A        ASL A 
$B91F  16 00     ASL $00,X 
$B921            .byte $00,$00
$B923  05 0E     ORA $0E
$B925  11 08     ORA ($08),Y
$B927  C8        INY 
$B928            .byte $17
$B929  20 01 3E  JSR L_JSR_($3E01)_($B929) OK
$B92C  05 1C     ORA $1C
$B92E  01 04     ORA ($04,X)
$B930  08        PHP 
$B931  50 18     BVC L_BRS_($B94B)_($B931) BAD
$B933  55 66     EOR $66,X 
$B935  99 0E 03  STA $030E,Y 
$B938  01 0A     ORA ($0A,X)
$B93A  20 1C 09  JSR L_JSR_($091C)_($B93A) OK
$B93D  05 50     ORA $50
$B93F  08        PHP 
$B940            .byte $23
$B941  50 00     BVC L_BRS_($B943)_($B941) JAM
//------------------------------
L_BRS_($B943)_($B941) JAM
//------------------------------
$B943            .byte $00
$B944  0E 23 06  ASL $0623 
$B947  01 05     ORA ($05,X)
$B949            .byte $00
//------------------------------
L_BRS_($B94B)_($B931) BAD
//------------------------------
$B94A  01 06     ORA ($06,X)
$B94C            .byte $02
$B94D  05 48     ORA $48
$B94F            .byte $34
$B950  38        SEC 
$B951            .byte $43
$B952  C0 80     CPY #$80
$B954  81 82     STA ($82,X) 
$B956            .byte $83
$B957  84 85     STY $85 
$B959            .byte $FF
$B95A  11 B3     ORA ($B3),Y
$B95C  B4 B5     LDY $B5,X 
$B95E  B6 A7     LDX $A7,Y 
$B960  A8        TAY 
$B961  A9 AA     LDA #$AA
$B963            .byte $03
$B964  1D 11 3F  ORA $3F11,X
$B967  06 0C     ASL $0C 
$B969            .byte $00
$B96A  01 0D     ORA ($0D,X)
$B96C  11 12     ORA ($12),Y
$B96E  20 C5 03  JSR $03C5
$B971  01 11     ORA ($11,X)
$B973  1D 00 0C  ORA $0C00,X
$B976  06 02     ASL $02 
$B978  0D 11 12  ORA $1211
$B97B            .byte $22
$B97C  C8        INY 
$B97D            .byte $07
$B97E  30 01     BMI L_BRS_($B981)_($B97E) BAD
//------------------------------
L_BRS_($B981)_($B97E) BAD
//------------------------------
$B980  2E 05 06  ROL $0605 
$B983  05 03     ORA $03
$B985  16 35     ASL $35,X 
$B987  35 00     AND $00,X 
$B989            .byte $02,$02,$03,$03,$0F,$13
$B98F  A2 0E     LDX #$0E
$B991            .byte $8F
$B992  05 06     ORA $06
$B994  30 07     BMI L_BRS_($B99D)_($B994) JAM
$B996  2E 05 01  ROL $0105 
$B999  05 04     ORA $04
$B99B  21 53     AND ($53,X) 
//------------------------------
L_BRS_($B99D)_($B994) JAM
//------------------------------
$B99D            .byte $53
$B99E  11 01     ORA ($01),Y
$B9A0  01 04     ORA ($04,X)
$B9A2            .byte $04,$0F,$14
$B9A5  01 C4     ORA ($C4,X)
$B9A7  09 00     ORA #$00
$B9A9  09 0E     ORA #$0E
$B9AB            .byte $0B
$B9AC  0E 67 05  ASL $0567 
$B9AF            .byte $04
$B9B0  05 03     ORA $03
$B9B2            .byte $13,$32,$03,$14
$B9B6  01 1C     ORA ($1C,X)
$B9B8  10 00     BPL L_BRS_($B9BA)_($B9B8) JAM
//------------------------------
L_BRS_($B9BA)_($B9B8) JAM
//------------------------------
$B9BA            .byte $0F
$B9BB  05 11     ORA $11
$B9BD  11 12     ORA ($12),Y
$B9BF            .byte $07,$17,$0F
$B9C2  06 1B     ASL $1B 
$B9C4  50 03     BVC L_BRS_($B9C9)_($B9C4) JAM
$B9C6  01 01     ORA ($01,X)
//------------------------------
L_BRS_($B9C9)_($B9C4) JAM
//------------------------------
$B9C8            .byte $02,$00,$0C
$B9CB  06 06     ASL $06 
$B9CD  0D 11 12  ORA $1211
$B9D0  06 BA     ASL $BA 
$B9D2            .byte $03
$B9D3  01 01     ORA ($01,X)
$B9D5  05 3E     ORA $3E
$B9D7            .byte $00
$B9D8  0E 07 19  ASL $1907 
$B9DB  55 1F     EOR $1F,X 
$B9DD  08        PHP 
$B9DE            .byte $1C
$B9DF  0D 1A 04  ORA $041A
$B9E2  08        PHP 
$B9E3            .byte $1A,$04
$B9E5  09 1A     ORA #$1A
$B9E7            .byte $04
$B9E8  0A        ASL A 
$B9E9            .byte $1C
$B9EA  08        PHP 
$B9EB  C1 01     CMP ($01,X) 
$B9ED  01 1A     ORA ($1A,X)
$B9EF  3E 04 02  ROL $0204,X 
$B9F2  08        PHP 
$B9F3            .byte $0C
$B9F4  DD CC EE  CMP $EECC,X 
$B9F7  C1 01     CMP ($01,X) 
$B9F9  05 1A     ORA $1A
$B9FB  3E 04 02  ROL $0204,X 
$B9FE  09 0C     ORA #$0C
$BA00  DD CC EE  CMP $EECC,X 
$BA03  C1 01     CMP ($01,X) 
$BA05  09 1A     ORA #$1A
$BA07  3E 04 01  ROL $0104,X 
$BA0A  0A        ASL A 
$BA0B            .byte $0C
$BA0C  DD CC EE  CMP $EECC,X 
$BA0F            .byte $03
$BA10  38        SEC 
$BA11  01 01     ORA ($01,X)
$BA13  06 0C     ASL $0C 
$BA15            .byte $00,$0B
$BA17  0D 11 12  ORA $1211
$BA1A  0A        ASL A 
$BA1B  BE 03 01  LDX $0103,Y 
$BA1E  01 01     ORA ($01,X)
$BA20  3E 00 04  ROL $0400,X 
$BA23            .byte $0C
$BA24  15 99     ORA $99,X
$BA26  1E 0A 1A  ASL $1A0A,X 
$BA29  05 08     ORA $08
$BA2B  05 09     ORA $09
$BA2D  05 0A     ORA $0A
$BA2F            .byte $1C,$0F
$BA31  01 01     ORA ($01,X)
$BA33  15 1C     ORA $1C,X
$BA35  01 04     ORA ($04,X)
$BA37  08        PHP 
$BA38  50 18     BVC L_BRS_($BA52)_($BA38) JAM
$BA3A  55 66     EOR $66,X 
$BA3C  99 0E 03  STA $030E,Y 
$BA3F  01 0A     ORA ($0A,X)
$BA41  20 1C 09  JSR L_JSR_($091C)_($BA41) OK
$BA44  05 50     ORA $50
$BA46  08        PHP 
$BA47            .byte $22
$BA48  50 00     BVC L_BRS_($BA4A)_($BA48) JAM
//------------------------------
L_BRS_($BA4A)_($BA48) JAM
//------------------------------
$BA4A            .byte $00,$04
$BA4C  24 4E     BIT $4E 
$BA4E            .byte $00
$BA4F  05 00     ORA $00
$BA51  0A        ASL A 
//------------------------------
L_BRS_($BA52)_($BA38) JAM
//------------------------------
$BA52            .byte $02,$07
$BA54  06 42     ASL $42 
$BA56            .byte $37,$32,$43
$BA59  C0 80     CPY #$80
$BA5B  8A        TXA 
$BA5C            .byte $82,$83
$BA5E  84 85     STY $85 
$BA60            .byte $FF,$0B
$BA62  A9 AA     LDA #$AA
$BA64            .byte $03,$3F
$BA66  01 1D     ORA ($1D,X)
$BA68            .byte $00,$0C
$BA6A  06 01     ASL $01 
$BA6C  0D 11 12  ORA $1211
$BA6F  20 C2 03  JSR $03C2
$BA72            .byte $07
$BA73  11 1D     ORA ($1D),Y
$BA75  0D 00 06  ORA $0600
$BA78            .byte $02
$BA79  0D 11 12  ORA $1211
$BA7C  25 CE     AND $CE
$BA7E  01 08     ORA ($08,X)
$BA80  10 1C     BPL L_BRS_($BA9E)_($BA80) BAD
$BA82            .byte $0B
$BA83  01 08     ORA ($08,X)
$BA85            .byte $03,$1A
$BA87  55 99     EOR $99,X 
$BA89  55 A2     EOR $A2,X 
$BA8B            .byte $0B,$8F
$BA8D  05 0B     ORA $0B
$BA8F  20 05 1C  JSR L_JSR_($1C05)_($BA8F) JAM
$BA92  08        PHP 
$BA93  05 03     ORA $03
$BA95            .byte $14
$BA96  20 00 00  JSR $0000
$BA99            .byte $00
$BA9A  0E 25 07  ASL $0725 
//------------------------------
L_BRS_($BA9E)_($BA80) BAD
//------------------------------
$BA9D  01 05     ORA ($05,X)
$BA9F            .byte $00
$BAA0  0A        ASL A 
$BAA1            .byte $02,$07
$BAA3  06 41     ASL $41 
$BAA5  38        SEC 
$BAA6            .byte $34,$43
$BAA8  C0 80     CPY #$80
$BAAA  81 82     STA ($82,X) 
$BAAC            .byte $83
$BAAD  84 85     STY $85 
$BAAF            .byte $FF
$BAB0  0A        ASL A 
$BAB1  D0 03     BNE L_BRS_($BAB6)_($BAB1) OK
$BAB3  08        PHP 
$BAB4  01 1C     ORA ($1C,X)
//------------------------------
L_BRS_($BAB6)_($BAB1) OK
//------------------------------
$BAB6  08        PHP 
$BAB7            .byte $00
$BAB8  08        PHP 
$BAB9  01 0D     ORA ($0D,X)
$BABB  11 12     ORA ($12),Y
$BABD  24 CE     BIT $CE 
//------------------------------
L_BRS_($BABF)_($BAF7) OK
//------------------------------
$BABF  06 37     ASL $37 
$BAC1  0D 18 05  ORA $0518
$BAC4            .byte $0C
$BAC5  10 02     BPL L_BRS_($BAC9)_($BAC5) JAM
$BAC7  10 53     BPL L_BRS_($BB1C)_($BAC7) JAM
//------------------------------
L_BRS_($BAC9)_($BAC5) JAM
//------------------------------
$BAC9            .byte $53
$BACA  55 00     EOR $00,X 
$BACC  05 02     ORA $02
$BACE            .byte $0C
$BACF  06 32     ASL $32 
$BAD1  16 1C     ASL $1C,X 
$BAD3  05 03     ORA $03
$BAD5  09 03     ORA #$03
$BAD7  10 53     BPL L_BRS_($BB2C)_($BAD7) BAD
$BAD9            .byte $53
$BADA  55 02     EOR $02,X 
$BADC  01 05     ORA ($05,X)
$BADE  08        PHP 
$BADF            .byte $07,$32
$BAE1  15 1C     ORA $1C,X
$BAE3  05 01     ORA $01
$BAE5  09 04     ORA #$04
$BAE7  10 4B     BPL L_BRS_($BB34)_($BAE7) JAM
$BAE9            .byte $4B
$BAEA  66 00     ROR $00 
$BAEC  01 05     ORA ($05,X)
$BAEE  08        PHP 
$BAEF  06 32     ASL $32 
$BAF1            .byte $14,$1C
$BAF3  05 01     ORA $01
$BAF5  09 05     ORA #$05
$BAF7  10 C6     BPL L_BRS_($BABF)_($BAF7) OK
$BAF9  C6 11     DEC $11 
$BAFB            .byte $00
$BAFC  01 05     ORA ($05,X)
$BAFE  08        PHP 
$BAFF            .byte $07,$32,$0F,$1C
$BB03  05 05     ORA $05
$BB05  09 06     ORA #$06
$BB07  10 4B     BPL L_BRS_($BB54)_($BB07) BAD
$BB09            .byte $4B
$BB0A  11 01     ORA ($01),Y
$BB0C            .byte $02
$BB0D  05 07     ORA $07
$BB0F            .byte $07,$33
$BB11  0E 1E 04  ASL $041E 
$BB14  01 05     ORA ($05,X)
$BB16            .byte $07
$BB17  10 4B     BPL L_BRS_($BB64)_($BB17) JAM
$BB19            .byte $4B
$BB1A  11 01     ORA ($01),Y
//------------------------------
L_BRS_($BB1C)_($BAC7) JAM
//------------------------------
$BB1C            .byte $02
$BB1D  01 03     ORA ($03,X)
$BB1F  06 31     ASL $31 
$BB21            .byte $12
$BB22  20 01 02  JSR $0201
$BB25  01 08     ORA ($08,X)
$BB27  10 6B     BPL L_BRS_($BB94)_($BB27) BAD
$BB29            .byte $6B
//------------------------------
L_BRS_($BB2C)_($BAD7) BAD
//------------------------------
$BB2A  CC 01 00  CPY $0001 
$BB2D  01 01     ORA ($01,X)
$BB2F  05 34     ORA $34
$BB31  0D 1E 03  ORA $031E
//------------------------------
L_BRS_($BB34)_($BAE7) JAM
//------------------------------
$BB34            .byte $02
$BB35  05 09     ORA $09
$BB37  10 0C     BPL L_BRS_($BB45)_($BB37) OK
$BB39            .byte $0C,$BB,$00,$02
$BB3D  01 03     ORA ($03,X)
$BB3F            .byte $07,$33
$BB41  01 18     ORA ($18,X)
$BB43  0A        ASL A 
$BB44            .byte $0C
//------------------------------
L_BRS_($BB45)_($BB37) OK
//------------------------------
$BB45  10 0A     BPL L_BRS_($BB51)_($BB45) JAM
$BB47  2D 6C 6C  AND $6C6C 
$BB4A  66 03     ROR $03 
$BB4C            .byte $03,$07
$BB4E  0D 89 12  ORA $1289
//------------------------------
L_BRS_($BB51)_($BB45) JAM
//------------------------------
$BB51            .byte $8F,$12
//------------------------------
L_BRS_($BB54)_($BB07) BAD
//------------------------------
$BB53  99 32 9B  STA $9B32,Y 
$BB56            .byte $03
$BB57  99 FF 8B  STA $8BFF,Y 
$BB5A            .byte $12
$BB5B  2D 8C 06  AND $068C 
$BB5E  A2 0C     LDX #$0C
$BB60  81 80     STA ($80,X) 
$BB62  84 1E     STY $1E 
//------------------------------
L_BRS_($BB64)_($BB17) JAM
//------------------------------
$BB64            .byte $92
$BB65  25 CE     AND $CE
$BB67  9A        TXS 
$BB68  85 10     STA $10 
$BB6A            .byte $9B
$BB6B  20 0B 32  JSR L_JSR_($320B)_($BB6B) OK
$BB6E            .byte $0F,$1F,$00,$02,$02,$0B,$13
$BB75  CC 32 10  CPY $1032 
$BB78            .byte $1F,$32
$BB7A  11 20     ORA ($20),Y
$BB7C            .byte $32
$BB7D  10 21     BPL L_BRS_($BBA0)_($BB7D) JAM
$BB7F            .byte $0B,$32,$0F
$BB82  20 00 02  JSR $0200
$BB85            .byte $02,$0C,$13
$BB88  CC 32 10  CPY $1032 
$BB8B  20 32 11  JSR L_JSR_($1132)_($BB8B) OK
$BB8E  21 32     AND ($32,X) 
$BB90  10 22     BPL L_BRS_($BBB4)_($BB90) OK
$BB92            .byte $02
//------------------------------
L_BRS_($BB94)_($BB27) BAD
//------------------------------
$BB93  20 1E 20  JSR L_JSR_($201E)_($BB93) BAD
$BB96            .byte $00,$00,$00
$BB99  10 0E     BPL L_BRS_($BBA9)_($BB99) OK
$BB9B  11 35     ORA ($35),Y
$BB9D  30 18     BMI L_BRS_($BBB7)_($BB9D) OK
//------------------------------
L_BRS_($BBA0)_($BB7D) JAM
//------------------------------
$BB9F            .byte $04,$02
$BBA1  2E 8E 06  ROL $068E 
$BBA4  01 8F     ORA ($8F,X)
$BBA6  08        PHP 
$BBA7  9A        TXS 
$BBA8            .byte $8F
//------------------------------
L_BRS_($BBA9)_($BB99) OK
//------------------------------
$BBA9  08        PHP 
$BBAA  85 08     STA $08 
$BBAC  85 0B     STA $0B 
$BBAE  85 0C     STA $0C 
$BBB0  9A        TXS 
$BBB1            .byte $9B
$BBB2  40        RTI 
//------------------------------
$BBB3            .byte $8F
//------------------------------
L_BRS_($BBB4)_($BB90) OK
//------------------------------
$BBB4  08        PHP 
$BBB5  85 06     STA $06 
//------------------------------
L_BRS_($BBB7)_($BB9D) OK
//------------------------------
$BBB7  85 07     STA $07 
$BBB9  85 09     STA $09 
$BBBB  85 04     STA $04 
$BBBD  85 05     STA $05 
$BBBF  85 10     STA $10 
$BBC1  9A        TXS 
$BBC2            .byte $8F
$BBC3  08        PHP 
$BBC4  85 02     STA $02 
$BBC6  85 03     STA $03 
$BBC8  85 0A     STA $0A 
$BBCA  9A        TXS 
$BBCB            .byte $8F
$BBCC  08        PHP 
$BBCD  8C 10 00  STY $0010 
$BBD0            .byte $02,$4F,$13,$00,$03
$BBD5  26 32     ROL $32 
$BBD7            .byte $00
$BBD8  05 00     ORA $00
$BBDA  01 02     ORA ($02,X)
$BBDC  0A        ASL A 
$BBDD            .byte $07
$BBDE  41 31     EOR ($31,X) 
$BBE0            .byte $32,$43
$BBE2  C0 80     CPY #$80
$BBE4  81 86     STA ($86,X) 
$BBE6            .byte $87
$BBE7  84 85     STY $85 
$BBE9            .byte $FF
$BBEA  09 03     ORA #$03
$BBEC  1D 08 01  ORA $0108,X
$BBEF  06 04     ASL $04 
$BBF1            .byte $00
$BBF2  01 0D     ORA ($0D,X)
$BBF4  11 12     ORA ($12),Y
$BBF6  29 C8     AND #$C8
$BBF8            .byte $03
$BBF9  2A        ROL A 
$BBFA  08        PHP 
$BBFB  1D 00 04  ORA $0400,X
$BBFE  06 02     ASL $02 
$BC00  0D 11 12  ORA $1211
$BC03            .byte $27
$BC04  CE 00 00  DEC $0000 
$BC07            .byte $04,$27,$3F,$00
$BC0B  05 00     ORA $00
$BC0D  01 02     ORA ($02,X)
$BC0F  0A        ASL A 
$BC10            .byte $07,$42
$BC12  31 32     AND ($32),Y 
$BC14            .byte $43
$BC15  C0 80     CPY #$80
$BC17  81 82     STA ($82,X) 
$BC19            .byte $83
$BC1A  88        DEY 
$BC1B            .byte $89,$FF
$BC1D  09 03     ORA #$03
$BC1F  01 08     ORA ($08,X)
$BC21  1D 00 04  ORA $0400,X
$BC24  06 01     ASL $01 
$BC26  0D 11 12  ORA $1211
$BC29            .byte $27
$BC2A  C8        INY 
$BC2B            .byte $03
$BC2C  1D 08 16  ORA $1608,X
$BC2F  06 04     ASL $04 
$BC31            .byte $00,$02
$BC33  0D 11 12  ORA $1211
$BC36  28        PLP 
$BC37  C5 03     CMP $03 
$BC39            .byte $3F
$BC3A  08        PHP 
$BC3B  1D 00 04  ORA $0400,X
$BC3E  06 03     ASL $03 
$BC40  0D 11 12  ORA $1211
$BC43  29 C8     AND #$C8
$BC45            .byte $00,$00,$04
$BC48  28        PLP 
$BC49            .byte $3F,$00
$BC4B  05 00     ORA $00
$BC4D  01 02     ORA ($02,X)
$BC4F  0A        ASL A 
$BC50            .byte $07,$43
$BC52  31 32     AND ($32),Y 
$BC54            .byte $43
$BC55  C0 80     CPY #$80
$BC57  81 86     STA ($86,X) 
$BC59            .byte $87
$BC5A  84 85     STY $85 
$BC5C            .byte $FF
$BC5D  09 03     ORA #$03
$BC5F  1D 08 01  ORA $0108,X
$BC62  06 04     ASL $04 
$BC64            .byte $00
$BC65  01 0D     ORA ($0D,X)
$BC67  11 12     ORA ($12),Y
$BC69  2A        ROL A 
$BC6A            .byte $CB,$03
$BC6C  16 08     ASL $08,X 
$BC6E  1D 00 04  ORA $0400,X
$BC71  06 02     ASL $02 
$BC73  0D 11 12  ORA $1211
$BC76  29 C8     AND #$C8
$BC78            .byte $03
$BC79  1D 08 3F  ORA $3F08,X
$BC7C  06 04     ASL $04 
$BC7E            .byte $00,$03
$BC80  0D 11 12  ORA $1211
$BC83  2E CB 00  ROL $00CB 
$BC86            .byte $00
$BC87  05 29     ORA $29
$BC89  50 00     BVC L_BRS_($BC8B)_($BC89) OK
//------------------------------
L_BRS_($BC8B)_($BC89) OK
//------------------------------
$BC8B  05 00     ORA $00
$BC8D  01 02     ORA ($02,X)
$BC8F  0A        ASL A 
$BC90            .byte $07,$44
$BC92  31 32     AND ($32),Y 
$BC94            .byte $43
$BC95  C0 80     CPY #$80
$BC97  81 82     STA ($82,X) 
$BC99            .byte $83
$BC9A  88        DEY 
$BC9B            .byte $89,$FF
$BC9D  0D A7 A8  ORA $A8A7
$BCA0  A9 AA     LDA #$AA
$BCA2            .byte $03
$BCA3  01 11     ORA ($11,X)
$BCA5  1D 00 0C  ORA $0C00,X
$BCA8  06 01     ASL $01 
$BCAA  0D 11 12  ORA $1211
$BCAD  05 C8     ORA $C8
$BCAF            .byte $03
$BCB0  1D 08 2A  ORA $2A08,X
$BCB3  06 04     ASL $04 
$BCB5            .byte $00,$02
$BCB7  0D 11 12  ORA $1211
$BCBA  26 C5     ROL $C5 
$BCBC            .byte $03
$BCBD  1D 08 16  ORA $1608,X
$BCC0  06 04     ASL $04 
$BCC2            .byte $00,$03
$BCC4  0D 11 12  ORA $1211
$BCC7  2C CB 03  BIT $03CB 
$BCCA            .byte $3F
$BCCB  08        PHP 
$BCCC  1D 00 04  ORA $0400,X
$BCCF  06 04     ASL $04 
$BCD1  0D 11 12  ORA $1211
$BCD4  2A        ROL A 
$BCD5            .byte $CB,$00,$00
$BCD8  05 2A     ORA $2A
$BCDA  4C 00 05  JMP $0500
$BCDD            .byte $00
$BCDE  01 02     ORA ($02,X)
$BCE0  0A        ASL A 
$BCE1            .byte $07
$BCE2  45 31     EOR $31 
$BCE4            .byte $32,$43
$BCE6  C0 80     CPY #$80
$BCE8  81 86     STA ($86,X) 
$BCEA            .byte $87
$BCEB  84 85     STY $85 
$BCED            .byte $FF
$BCEE  09 03     ORA #$03
$BCF0  2A        ROL A 
$BCF1  08        PHP 
$BCF2  1D 00 04  ORA $0400,X
$BCF5  06 01     ASL $01 
$BCF7  0D 11 12  ORA $1211
$BCFA  2D CE 03  AND $03CE 
$BCFD  1D 08 01  ORA $0108,X
$BD00  06 04     ASL $04 
$BD02            .byte $00,$02
$BD04  0D 11 12  ORA $1211
$BD07  2C CB 03  BIT $03CB 
$BD0A  16 08     ASL $08,X 
$BD0C  1D 00 04  ORA $0400,X
$BD0F  06 03     ASL $03 
$BD11  0D 11 12  ORA $1211
$BD14  2D C8 03  AND $03C8 
$BD17  1D 08 3F  ORA $3F08,X
$BD1A  06 04     ASL $04 
$BD1C            .byte $00,$04
$BD1E  0D 11 12  ORA $1211
$BD21  26 C5     ROL $C5 
$BD23            .byte $00,$00,$03,$2B
$BD27  36 00     ROL $00,X 
$BD29  05 00     ORA $00
$BD2B  01 02     ORA ($02,X)
$BD2D  0A        ASL A 
$BD2E            .byte $07
$BD2F  46 31     LSR $31 
$BD31            .byte $32,$43
$BD33  C0 80     CPY #$80
$BD35  81 82     STA ($82,X) 
$BD37            .byte $83
$BD38  88        DEY 
$BD39            .byte $89,$FF
$BD3B  0D AB AC  ORA $ACAB
$BD3E  AD AE 03  LDA $03AE 
$BD41  01 08     ORA ($08,X)
$BD43  1D 00 04  ORA $0400,X
$BD46  06 01     ASL $01 
$BD48  0D 11 12  ORA $1211
$BD4B  29 C8     AND #$C8
$BD4D            .byte $03,$3F
$BD4F  11 1D     ORA ($1D),Y
$BD51            .byte $00,$0C
$BD53  06 02     ASL $02 
$BD55  0D 11 12  ORA $1211
$BD58            .byte $33
$BD59  01 00     ORA ($00,X)
$BD5B            .byte $00,$03
$BD5D  2C 32 00  BIT $0032 
$BD60  05 00     ORA $00
$BD62  01 02     ORA ($02,X)
$BD64  0A        ASL A 
$BD65            .byte $07,$47
$BD67  31 32     AND ($32),Y 
$BD69            .byte $43
$BD6A  C0 80     CPY #$80
$BD6C  81 86     STA ($86,X) 
$BD6E            .byte $87
$BD6F  84 85     STY $85 
$BD71            .byte $FF
$BD72  09 03     ORA #$03
$BD74  1D 08 3F  ORA $3F08,X
$BD77  06 04     ASL $04 
$BD79            .byte $00
$BD7A  01 0D     ORA ($0D,X)
$BD7C  11 12     ORA ($12),Y
$BD7E  29 C8     AND #$C8
$BD80            .byte $03
$BD81  2A        ROL A 
$BD82  08        PHP 
$BD83  1D 00 04  ORA $0400,X
$BD86  06 02     ASL $02 
$BD88  0D 11 12  ORA $1211
$BD8B  2D CE 00  AND $00CE 
$BD8E            .byte $00,$04
$BD90  2D 3F 00  AND $003F 
$BD93  05 00     ORA $00
$BD95  01 02     ORA ($02,X)
$BD97  0A        ASL A 
$BD98            .byte $07
$BD99  48        PHA 
$BD9A  31 32     AND ($32),Y 
$BD9C            .byte $43
$BD9D  C0 80     CPY #$80
$BD9F  81 82     STA ($82,X) 
$BDA1            .byte $83
$BDA2  88        DEY 
$BDA3            .byte $89,$FF
$BDA5  09 03     ORA #$03
$BDA7  01 08     ORA ($08,X)
$BDA9  1D 00 04  ORA $0400,X
$BDAC  06 01     ASL $01 
$BDAE  0D 11 12  ORA $1211
$BDB1  2D C8 03  AND $03C8 
$BDB4  1D 08 2A  ORA $2A08,X
$BDB7  06 04     ASL $04 
$BDB9            .byte $00,$02
$BDBB  0D 11 12  ORA $1211
$BDBE  2A        ROL A 
$BDBF  C5 03     CMP $03 
$BDC1            .byte $3F
$BDC2  08        PHP 
$BDC3  1D 00 04  ORA $0400,X
$BDC6  06 03     ASL $03 
$BDC8  0D 11 12  ORA $1211
$BDCB  2D CE 00  AND $00CE 
$BDCE            .byte $00,$04
$BDD0  2E 3F 00  ROL $003F 
$BDD3  05 00     ORA $00
$BDD5  01 02     ORA ($02,X)
$BDD7  0A        ASL A 
$BDD8            .byte $07
$BDD9  49 31     EOR #$31
$BDDB            .byte $32,$43
$BDDD  C0 80     CPY #$80
$BDDF  81 86     STA ($86,X) 
$BDE1            .byte $87
$BDE2  84 85     STY $85 
$BDE4            .byte $FF
$BDE5  09 03     ORA #$03
$BDE7  16 08     ASL $08,X 
$BDE9  1D 00 04  ORA $0400,X
$BDEC  06 01     ASL $01 
$BDEE  0D 11 12  ORA $1211
$BDF1  2D C8 03  AND $03C8 
$BDF4  1D 08 3F  ORA $3F08,X
$BDF7  06 04     ASL $04 
$BDF9            .byte $00,$02
$BDFB  0D 11 12  ORA $1211
$BDFE            .byte $2B
$BDFF  CE 03 2A  DEC $2A03 
$BE02  08        PHP 
$BE03  1D 00 04  ORA $0400,X
$BE06  06 03     ASL $03 
$BE08  0D 11 12  ORA $1211
$BE0B  2A        ROL A 
$BE0C  C5 00     CMP $00 
$BE0E            .byte $00,$02,$32
$BE11  25 00     AND $00
$BE13  05 00     ORA $00
$BE15            .byte $07,$03
$BE17  08        PHP 
$BE18  20 33 32  JSR L_JSR_($3233)_($BE18) BAD
$BE1B  20 20 C0  JSR L_JSR_($C020)_($BE1B) JAM
$BE1E            .byte $80
$BE1F  81 82     STA ($82,X) 
$BE21            .byte $83
$BE22  84 85     STY $85 
$BE24            .byte $FF
$BE25  09 03     ORA #$03
$BE27  1D 01 3F  ORA $3F01,X
$BE2A  06 0C     ASL $0C 
$BE2C            .byte $00
$BE2D  01 0D     ORA ($0D,X)
$BE2F  11 12     ORA ($12),Y
$BE31  01 06     ORA ($06,X)
$BE33            .byte $00,$23
$BE35  08        PHP 
$BE36            .byte $33,$80,$00
$BE39  01 00     ORA ($00,X)
$BE3B            .byte $07,$03
$BE3D  08        PHP 
$BE3E            .byte $00
$BE3F  41 32     EOR ($32,X) 
$BE41            .byte $34,$43
$BE43  06 40     ASL $40 
$BE45            .byte $00
$BE46  08        PHP 
$BE47  30 20     BMI L_BRS_($BE69)_($BE47) JAM
$BE49  30 06     BMI L_BRS_($BE51)_($BE49) OK
$BE4B  10 46     BPL L_BRS_($BE93)_($BE4B) OK
$BE4D  46 46     LSR $46 
$BE4F  18        CLC 
$BE50  18        CLC 
//------------------------------
L_BRS_($BE51)_($BE49) OK
//------------------------------
$BE51  18        CLC 
$BE52  18        CLC 
$BE53  06 30     ASL $30 
$BE55            .byte $00
$BE56  40        RTI 
//------------------------------
$BE57  30 20     BMI L_BRS_($BE79)_($BE57) BAD
$BE59  30 07     BMI L_BRS_($BE62)_($BE59) OK
$BE5B  10 46     BPL L_BRS_($BEA3)_($BE5B) JAM
$BE5D  46 46     LSR $46 
$BE5F  18        CLC 
$BE60  18        CLC 
$BE61  18        CLC 
//------------------------------
L_BRS_($BE62)_($BE59) OK
//------------------------------
$BE62  18        CLC 
$BE63  C0 1E     CPY #$1E
$BE65            .byte $00
$BE66  18        CLC 
$BE67  46 09     LSR $09 
//------------------------------
L_BRS_($BE69)_($BE47) JAM
//------------------------------
$BE69            .byte $00
$BE6A  01 09     ORA ($09,X)
$BE6C  01 15     ORA ($15,X)
$BE6E            .byte $00,$17
$BE70  08        PHP 
$BE71            .byte $03,$03,$03,$0C
$BE75  55 55     EOR $55,X 
//------------------------------
L_BRS_($BE79)_($BE57) BAD
//------------------------------
$BE77  CC 03 1D  CPY $1D03 
$BE7A            .byte $00
$BE7B  18        CLC 
$BE7C            .byte $00,$02
$BE7E  01 02     ORA ($02,X)
$BE80  0D 11 12  ORA $1211
$BE83            .byte $2B
$BE84  BC 03 02  LDY $0203,X 
$BE87            .byte $00,$02
$BE89  01 00     ORA ($00,X)
$BE8B            .byte $0B
$BE8C  10 1B     BPL L_BRS_($BEA9)_($BE8C) JAM
$BE8E            .byte $44
$BE8F  88        DEY 
$BE90  20 08 8F  JSR L_JSR_($8F08)_($BE90) JAM
//------------------------------
L_BRS_($BE93)_($BE4B) OK
//------------------------------
$BE93  0E A2 12  ASL $12A2 
$BE96  85 10     STA $10 
$BE98  85 11     STA $11 
$BE9A  85 12     STA $12 
$BE9C  81 A0     STA ($A0,X) 
$BE9E            .byte $BB
$BE9F  0D 03 01  ORA $0103
//------------------------------
L_BRS_($BEA3)_($BE5B) JAM
//------------------------------
$BEA2            .byte $00,$0B,$03,$00
$BEA6  01 11     ORA ($11,X)
$BEA8  0A        ASL A 
//------------------------------
L_BRS_($BEA9)_($BE8C) JAM
//------------------------------
$BEA9            .byte $44,$03
$BEAB  01 00     ORA ($00,X)
$BEAD            .byte $03,$03,$00
$BEB0  01 12     ORA ($12,X)
$BEB2  0A        ASL A 
$BEB3            .byte $44,$00,$00,$03,$34,$32,$00
$BEBA  05 00     ORA $00
$BEBC  08        PHP 
$BEBD            .byte $03,$02,$02,$47,$32,$34,$43
$BEC4  C0 80     CPY #$80
$BEC6  8A        TXA 
$BEC7            .byte $82,$83
$BEC9  84 85     STY $85 
$BECB            .byte $FF
$BECC  09 03     ORA #$03
$BECE            .byte $02
$BECF  01 3F     ORA ($3F,X)
$BED1  06 0C     ASL $0C 
$BED3            .byte $00
$BED4  01 0D     ORA ($0D,X)
$BED6  11 12     ORA ($12),Y
$BED8            .byte $0F
$BED9  C4 03     CPY $03 
$BEDB            .byte $3F
$BEDC  01 02     ORA ($02,X)
$BEDE            .byte $00,$0C
$BEE0  06 02     ASL $02 
$BEE2  0D 11 12  ORA $1211
$BEE5  09 C3     ORA #$C3
$BEE7            .byte $00,$00,$04
$BEEA  35 48     AND $48,X 
$BEEC            .byte $00
$BEED  05 00     ORA $00
$BEEF  01 06     ORA ($06,X)
$BEF1  08        PHP 
$BEF2            .byte $04
$BEF3  45 32     EOR $32 
$BEF5            .byte $34,$43
$BEF7  C0 80     CPY #$80
$BEF9  8A        TXA 
$BEFA            .byte $82,$83
$BEFC  84 85     STY $85 
$BEFE            .byte $FF
$BEFF  09 03     ORA #$03
$BF01            .byte $02
$BF02  01 3F     ORA ($3F,X)
$BF04  06 0C     ASL $0C 
$BF06            .byte $00
$BF07  01 0D     ORA ($0D,X)
$BF09  11 12     ORA ($12),Y
$BF0B  18        CLC 
$BF0C  C4 03     CPY $03 
$BF0E            .byte $3F
$BF0F  01 02     ORA ($02,X)
$BF11            .byte $00,$0C
$BF13  06 02     ASL $02 
$BF15  0D 11 12  ORA $1211
$BF18            .byte $1B,$C3
$BF1A  01 3E     ORA ($3E,X)
$BF1C  01 01     ORA ($01,X)
$BF1E  01 0C     ORA ($0C,X)
$BF20  08        PHP 
$BF21            .byte $03
$BF22  16 55     ASL $55,X 
$BF24  66 99     ROR $99 
$BF26  85 03     STA $03 
$BF28            .byte $9C
$BF29  08        PHP 
$BF2A  86 1B     STX $1B 
$BF2C  08        PHP 
$BF2D  86 1B     STX $1B 
$BF2F  11 00     ORA ($00),Y
$BF31            .byte $7F,$83,$03,$83
$BF35  06 89     ASL $89 
$BF37            .byte $03,$82
$BF39  05 82     ORA $82
$BF3B            .byte $03,$82,$04,$82
$BF3F  06 88     ASL $88 
$BF41            .byte $03,$82
$BF43  08        PHP 
$BF44  86 03     STX $03 
$BF46  85 05     STA $05 
$BF48            .byte $82,$07,$82,$03
$BF4C  05 88     ORA $88
$BF4E            .byte $03,$07
$BF50  1E 9A 18  ASL $189A,X 
$BF53            .byte $1A
$BF54  16 1E     ASL $1E,X 
$BF56            .byte $82
$BF57  05 08     ORA $08
$BF59  88        DEY 
$BF5A            .byte $03
$BF5B  86 0B     STX $0B 
$BF5D  86 11     STX $11 
$BF5F            .byte $00,$00
$BF61  86 1B     STX $1B 
$BF63  11 00     ORA ($00),Y
$BF65            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BF6D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BF75            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BF7D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BF85            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BF8D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BF95            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BF9D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFA5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFAD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFB5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFBD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFC5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFCD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFD5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFDD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFE5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFED            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFF5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$BFFD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C005            .byte $00,$00
$C007  08        PHP 
$C008            .byte $00,$00
$C00A  08        PHP 
$C00B            .byte $00,$00
$C00D  3E 00 00  ROL $0000,X 
$C010  49 00     EOR #$00
$C012            .byte $00
$C013  88        DEY 
$C014            .byte $80,$00,$80,$80,$03,$E3
$C01A  E0 00     CPX #$00
$C01C            .byte $80,$80,$00
$C01F  88        DEY 
//------------------------------
L_JSR_($C020)_($BE1B) JAM
//------------------------------
$C020            .byte $80,$00
$C022  49 00     EOR #$00
$C024            .byte $00
$C025  3E 00 00  ROL $0000,X 
$C028  08        PHP 
$C029            .byte $00,$00
$C02B  08        PHP 
$C02C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C034            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C03C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C044            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C04C            .byte $00,$00,$00,$00
$C050  36 00     ROL $00,X 
$C052            .byte $00
$C053  41 00     EOR ($00,X) 
$C055            .byte $00
$C056  49 00     EOR #$00
$C058            .byte $00,$14,$00,$00
$C05C  49 00     EOR #$00
$C05E            .byte $00
$C05F  41 00     EOR ($00,X) 
$C061            .byte $00
$C062  36 00     ROL $00,X 
$C064            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C06C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C074            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C07C            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C084            .byte $00,$00,$00,$00,$00,$00,$3F,$00
$C08C            .byte $00,$FF
$C08E  C0 01     CPY #$01
$C090            .byte $FF
$C091  E0 03     CPX #$03
$C093            .byte $FF
$C094  F0 03     BEQ L_BRS_($C099)_($C094) JAM
$C096            .byte $FF
$C097  F0 07     BEQ L_BRS_($C0A0)_($C097) JAM
//------------------------------
L_BRS_($C099)_($C094) JAM
L_BRS_($C0A0)_($C097) JAM
//------------------------------
$C099            .byte $FF,$F8,$07,$FF,$F8,$07,$FF,$F8
$C0A1            .byte $07,$FF,$F8,$07,$FF,$F8,$07,$FF
$C0A9            .byte $F8,$03,$FF
$C0AC  F0 03     BEQ L_BRS_($C0B1)_($C0AC) JAM
$C0AE            .byte $FF
$C0AF  F0 01     BEQ L_BRS_($C0B2)_($C0AF) OK
//------------------------------
L_BRS_($C0B1)_($C0AC) JAM
//------------------------------
$C0B1            .byte $FF
//------------------------------
L_BRS_($C0B2)_($C0AF) OK
//------------------------------
$C0B2  E0 00     CPX #$00
$C0B4            .byte $FF
$C0B5  C0 00     CPY #$00
$C0B7            .byte $3F,$00,$00,$00,$00,$00,$00,$00
$C0BF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C0C7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C0CF            .byte $00
$C0D0  20 00 00  JSR $0000
$C0D3  20 00 00  JSR $0000
$C0D6  88        DEY 
$C0D7            .byte $00
$C0D8  09 11     ORA #$11
$C0DA            .byte $80,$00
$C0DC  98        TYA 
$C0DD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C0E5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C0ED            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C0F5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C0FD            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C105            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C10D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C115            .byte $00,$00,$00,$00
$C119  2A        ROL A 
$C11A            .byte $00,$00
$C11C  95 80     STA $80,X 
$C11E            .byte $00
$C11F  99 80 00  STA $0080,Y 
$C122  95 80     STA $80,X 
$C124            .byte $00
$C125  2A        ROL A 
$C126            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C12E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C136            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C13E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C146            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C14E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C156            .byte $00,$00,$00,$00,$00,$00
$C15C  28        PLP 
$C15D            .byte $00,$00
$C15F  96 00     STX $00,Y 
$C161            .byte $00
$C162  96 00     STX $00,Y 
$C164            .byte $00
$C165  28        PLP 
$C166            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C16E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C176            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C17E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C186            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C18E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C196            .byte $00,$00,$00,$00,$00,$00
$C19C  08        PHP 
$C19D            .byte $00,$00
$C19F  26 00     ROL $00 
$C1A1            .byte $00
$C1A2  08        PHP 
$C1A3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1AB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1B3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1BB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1C3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1CB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1D3  08        PHP 
$C1D4            .byte $00
$C1D5  08        PHP 
$C1D6  08        PHP 
$C1D7  08        PHP 
$C1D8            .byte $02
$C1D9  08        PHP 
$C1DA  20 00 88  JSR L_JSR_($8800)_($C1DA) BAD
$C1DD            .byte $80,$00,$00,$00
$C1E1  2A        ROL A 
$C1E2  88        DEY 
$C1E3  AA        TAX 
$C1E4            .byte $00,$00,$00,$00
$C1E8  88        DEY 
$C1E9            .byte $80,$02
$C1EB  08        PHP 
$C1EC  20 08 08  JSR L_JSR_($0808)_($C1EC) BAD
$C1EF  08        PHP 
$C1F0            .byte $00
$C1F1  08        PHP 
$C1F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C1FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C202            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C20A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C212            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C21A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C222            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C22A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C232            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C23A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C242            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C24A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C252            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C25A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C262            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C26A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C272            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C27A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C282            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C28A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C292            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C29A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C2FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C302            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C30A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C312            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C31A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C322            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C32A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C332            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C33A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C342            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C34A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C352            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C35A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C362            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C36A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C372            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C37A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C382            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C38A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C392            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C39A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C3FA            .byte $00,$00,$00,$00,$00,$00
$C400  98        TYA 
$C401  98        TYA 
$C402  98        TYA 
$C403  98        TYA 
$C404  21 21     AND ($21,X) 
$C406  21 21     AND ($21,X) 
$C408  21 21     AND ($21,X) 
$C40A  21 21     AND ($21,X) 
$C40C  21 21     AND ($21,X) 
$C40E  11 11     ORA ($11),Y
$C410  11 11     ORA ($11),Y
$C412  11 11     ORA ($11),Y
$C414  11 11     ORA ($11),Y
$C416  11 11     ORA ($11),Y
$C418  11 11     ORA ($11),Y
$C41A  11 11     ORA ($11),Y
$C41C  11 11     ORA ($11),Y
$C41E  11 11     ORA ($11),Y
$C420  11 11     ORA ($11),Y
$C422  11 11     ORA ($11),Y
$C424  98        TYA 
$C425  98        TYA 
$C426  98        TYA 
$C427  98        TYA 
$C428  98        TYA 
$C429  98        TYA 
$C42A  98        TYA 
$C42B  98        TYA 
$C42C  21 21     AND ($21,X) 
$C42E  21 21     AND ($21,X) 
$C430  21 21     AND ($21,X) 
$C432  21 21     AND ($21,X) 
$C434  21 21     AND ($21,X) 
$C436  11 11     ORA ($11),Y
$C438  11 11     ORA ($11),Y
$C43A  11 11     ORA ($11),Y
$C43C  11 11     ORA ($11),Y
$C43E  11 11     ORA ($11),Y
$C440  11 11     ORA ($11),Y
$C442  11 11     ORA ($11),Y
$C444  11 11     ORA ($11),Y
$C446  11 11     ORA ($11),Y
$C448  11 11     ORA ($11),Y
$C44A  11 11     ORA ($11),Y
$C44C  98        TYA 
$C44D  98        TYA 
$C44E  98        TYA 
$C44F  98        TYA 
$C450  98        TYA 
$C451  98        TYA 
$C452  98        TYA 
$C453  98        TYA 
$C454  98        TYA 
$C455  98        TYA 
$C456  98        TYA 
$C457  98        TYA 
$C458  98        TYA 
$C459  98        TYA 
$C45A  98        TYA 
$C45B  98        TYA 
$C45C  98        TYA 
$C45D  98        TYA 
$C45E  11 11     ORA ($11),Y
$C460  11 11     ORA ($11),Y
$C462  11 11     ORA ($11),Y
$C464  11 11     ORA ($11),Y
$C466  11 11     ORA ($11),Y
$C468  11 11     ORA ($11),Y
$C46A  11 11     ORA ($11),Y
$C46C  11 11     ORA ($11),Y
$C46E  11 11     ORA ($11),Y
$C470  11 11     ORA ($11),Y
$C472  11 11     ORA ($11),Y
$C474  98        TYA 
$C475  98        TYA 
$C476  98        TYA 
$C477  98        TYA 
$C478  98        TYA 
$C479  98        TYA 
$C47A  98        TYA 
$C47B  98        TYA 
$C47C  98        TYA 
$C47D  98        TYA 
$C47E  98        TYA 
$C47F  98        TYA 
$C480  98        TYA 
$C481  98        TYA 
$C482  98        TYA 
$C483  98        TYA 
$C484  98        TYA 
$C485  98        TYA 
$C486  98        TYA 
$C487  98        TYA 
$C488  98        TYA 
$C489  98        TYA 
$C48A  98        TYA 
$C48B  98        TYA 
$C48C  98        TYA 
$C48D  98        TYA 
$C48E  98        TYA 
$C48F  98        TYA 
$C490  98        TYA 
$C491  98        TYA 
$C492  98        TYA 
$C493  98        TYA 
$C494  98        TYA 
$C495  98        TYA 
$C496  98        TYA 
$C497  98        TYA 
$C498  98        TYA 
$C499  98        TYA 
$C49A  98        TYA 
$C49B  98        TYA 
$C49C  98        TYA 
$C49D  98        TYA 
$C49E  98        TYA 
$C49F  98        TYA 
$C4A0  98        TYA 
$C4A1  98        TYA 
$C4A2  98        TYA 
$C4A3  98        TYA 
$C4A4  98        TYA 
$C4A5  98        TYA 
$C4A6  98        TYA 
$C4A7  98        TYA 
$C4A8  98        TYA 
$C4A9  98        TYA 
$C4AA  98        TYA 
$C4AB  98        TYA 
$C4AC  98        TYA 
$C4AD  98        TYA 
$C4AE  98        TYA 
$C4AF  98        TYA 
$C4B0  98        TYA 
$C4B1  98        TYA 
$C4B2  98        TYA 
$C4B3  98        TYA 
$C4B4  98        TYA 
$C4B5  98        TYA 
$C4B6  98        TYA 
$C4B7  98        TYA 
$C4B8  98        TYA 
$C4B9  98        TYA 
$C4BA  98        TYA 
$C4BB  98        TYA 
$C4BC  98        TYA 
$C4BD  98        TYA 
$C4BE  98        TYA 
$C4BF  98        TYA 
$C4C0  98        TYA 
$C4C1  98        TYA 
$C4C2  98        TYA 
$C4C3  98        TYA 
$C4C4  98        TYA 
$C4C5  98        TYA 
$C4C6  98        TYA 
$C4C7  98        TYA 
$C4C8  98        TYA 
$C4C9  98        TYA 
$C4CA  98        TYA 
$C4CB  98        TYA 
$C4CC  98        TYA 
$C4CD  98        TYA 
$C4CE  98        TYA 
$C4CF  98        TYA 
$C4D0  98        TYA 
$C4D1  98        TYA 
$C4D2  98        TYA 
$C4D3  98        TYA 
$C4D4  98        TYA 
$C4D5  98        TYA 
$C4D6  98        TYA 
$C4D7  98        TYA 
$C4D8  98        TYA 
$C4D9  98        TYA 
$C4DA  98        TYA 
$C4DB  98        TYA 
$C4DC  98        TYA 
$C4DD  98        TYA 
$C4DE  98        TYA 
$C4DF  98        TYA 
$C4E0  98        TYA 
$C4E1  98        TYA 
$C4E2  98        TYA 
$C4E3  98        TYA 
$C4E4  98        TYA 
$C4E5  98        TYA 
$C4E6  98        TYA 
$C4E7  98        TYA 
$C4E8  98        TYA 
$C4E9  98        TYA 
$C4EA  98        TYA 
$C4EB  98        TYA 
$C4EC  98        TYA 
$C4ED  98        TYA 
$C4EE  98        TYA 
$C4EF  98        TYA 
$C4F0  98        TYA 
$C4F1  98        TYA 
$C4F2  98        TYA 
$C4F3  98        TYA 
$C4F4  98        TYA 
$C4F5  98        TYA 
$C4F6  98        TYA 
$C4F7  98        TYA 
$C4F8  98        TYA 
$C4F9  98        TYA 
$C4FA  98        TYA 
$C4FB  98        TYA 
$C4FC  98        TYA 
$C4FD  98        TYA 
$C4FE  98        TYA 
$C4FF  98        TYA 
$C500  98        TYA 
$C501  98        TYA 
$C502  98        TYA 
$C503  98        TYA 
$C504  98        TYA 
$C505  98        TYA 
$C506  98        TYA 
$C507  98        TYA 
$C508  98        TYA 
$C509  98        TYA 
$C50A  98        TYA 
$C50B  98        TYA 
$C50C  98        TYA 
$C50D  98        TYA 
$C50E  98        TYA 
$C50F  98        TYA 
$C510  98        TYA 
$C511  98        TYA 
$C512  98        TYA 
$C513  98        TYA 
$C514  98        TYA 
$C515  98        TYA 
$C516  98        TYA 
$C517  98        TYA 
$C518  98        TYA 
$C519  98        TYA 
$C51A  98        TYA 
$C51B  98        TYA 
$C51C  98        TYA 
$C51D  98        TYA 
$C51E  98        TYA 
$C51F  98        TYA 
$C520  98        TYA 
$C521  98        TYA 
$C522  98        TYA 
$C523  98        TYA 
$C524  98        TYA 
$C525  98        TYA 
$C526  98        TYA 
$C527  98        TYA 
$C528  98        TYA 
$C529  98        TYA 
$C52A  98        TYA 
$C52B  98        TYA 
$C52C  98        TYA 
$C52D  98        TYA 
$C52E  98        TYA 
$C52F  98        TYA 
$C530  98        TYA 
$C531  98        TYA 
$C532  98        TYA 
$C533  98        TYA 
$C534  98        TYA 
$C535  98        TYA 
$C536  98        TYA 
$C537  98        TYA 
$C538  98        TYA 
$C539  98        TYA 
$C53A  98        TYA 
$C53B  98        TYA 
$C53C  98        TYA 
$C53D  98        TYA 
$C53E  98        TYA 
$C53F  98        TYA 
$C540  98        TYA 
$C541  98        TYA 
$C542  98        TYA 
$C543  98        TYA 
$C544  98        TYA 
$C545  98        TYA 
$C546  98        TYA 
$C547  98        TYA 
$C548  98        TYA 
$C549  98        TYA 
$C54A  98        TYA 
$C54B  98        TYA 
$C54C  98        TYA 
$C54D  98        TYA 
$C54E  98        TYA 
$C54F  98        TYA 
$C550  98        TYA 
$C551  98        TYA 
$C552  98        TYA 
$C553  98        TYA 
$C554  98        TYA 
$C555  98        TYA 
$C556  98        TYA 
$C557  98        TYA 
$C558  98        TYA 
$C559  98        TYA 
$C55A  98        TYA 
$C55B  98        TYA 
$C55C  98        TYA 
$C55D  98        TYA 
$C55E  98        TYA 
$C55F  98        TYA 
$C560  98        TYA 
$C561  98        TYA 
$C562  98        TYA 
$C563  98        TYA 
$C564  98        TYA 
$C565  98        TYA 
$C566  98        TYA 
$C567  98        TYA 
$C568  98        TYA 
$C569  98        TYA 
$C56A  98        TYA 
$C56B  98        TYA 
$C56C  98        TYA 
$C56D  98        TYA 
$C56E  98        TYA 
$C56F  98        TYA 
$C570  98        TYA 
$C571  98        TYA 
$C572  98        TYA 
$C573  98        TYA 
$C574  98        TYA 
$C575  98        TYA 
$C576  98        TYA 
$C577  98        TYA 
$C578  98        TYA 
$C579  98        TYA 
$C57A  98        TYA 
$C57B  98        TYA 
$C57C  98        TYA 
$C57D  98        TYA 
$C57E  98        TYA 
$C57F  98        TYA 
$C580  98        TYA 
$C581  98        TYA 
$C582  98        TYA 
$C583  98        TYA 
$C584  98        TYA 
$C585  98        TYA 
$C586  98        TYA 
$C587  98        TYA 
$C588  98        TYA 
$C589  98        TYA 
$C58A  98        TYA 
$C58B  98        TYA 
$C58C  98        TYA 
$C58D  98        TYA 
$C58E  98        TYA 
$C58F  98        TYA 
$C590  98        TYA 
$C591  98        TYA 
$C592  98        TYA 
$C593  98        TYA 
$C594  98        TYA 
$C595  98        TYA 
$C596  98        TYA 
$C597  98        TYA 
$C598  98        TYA 
$C599  98        TYA 
$C59A  98        TYA 
$C59B  98        TYA 
$C59C  98        TYA 
$C59D  98        TYA 
$C59E  98        TYA 
$C59F  98        TYA 
$C5A0  98        TYA 
$C5A1  98        TYA 
$C5A2  98        TYA 
$C5A3  98        TYA 
$C5A4  98        TYA 
$C5A5  98        TYA 
$C5A6  98        TYA 
$C5A7  98        TYA 
$C5A8  98        TYA 
$C5A9  98        TYA 
$C5AA  98        TYA 
$C5AB  98        TYA 
$C5AC  98        TYA 
$C5AD  98        TYA 
$C5AE  98        TYA 
$C5AF  98        TYA 
$C5B0  98        TYA 
$C5B1  98        TYA 
$C5B2  98        TYA 
$C5B3  98        TYA 
$C5B4  98        TYA 
$C5B5  98        TYA 
$C5B6  98        TYA 
$C5B7  98        TYA 
$C5B8  98        TYA 
$C5B9  98        TYA 
$C5BA  98        TYA 
$C5BB  98        TYA 
$C5BC  98        TYA 
$C5BD  98        TYA 
$C5BE  98        TYA 
$C5BF  98        TYA 
$C5C0  98        TYA 
$C5C1  98        TYA 
$C5C2  98        TYA 
$C5C3  98        TYA 
$C5C4  98        TYA 
$C5C5  98        TYA 
$C5C6  98        TYA 
$C5C7  98        TYA 
$C5C8  98        TYA 
$C5C9  98        TYA 
$C5CA  98        TYA 
$C5CB  98        TYA 
$C5CC  98        TYA 
$C5CD  98        TYA 
$C5CE  98        TYA 
$C5CF  98        TYA 
$C5D0  98        TYA 
$C5D1  98        TYA 
$C5D2  98        TYA 
$C5D3  98        TYA 
$C5D4  98        TYA 
$C5D5  98        TYA 
$C5D6  98        TYA 
$C5D7  98        TYA 
$C5D8  98        TYA 
$C5D9  98        TYA 
$C5DA  98        TYA 
$C5DB  98        TYA 
$C5DC  98        TYA 
$C5DD  98        TYA 
$C5DE  98        TYA 
$C5DF  98        TYA 
$C5E0  98        TYA 
$C5E1  98        TYA 
$C5E2  98        TYA 
$C5E3  98        TYA 
$C5E4  98        TYA 
$C5E5  98        TYA 
$C5E6  98        TYA 
$C5E7  98        TYA 
$C5E8  98        TYA 
$C5E9  98        TYA 
$C5EA  98        TYA 
$C5EB  98        TYA 
$C5EC  98        TYA 
$C5ED  98        TYA 
$C5EE  98        TYA 
$C5EF  98        TYA 
$C5F0  98        TYA 
$C5F1  98        TYA 
$C5F2  98        TYA 
$C5F3  98        TYA 
$C5F4  98        TYA 
$C5F5  98        TYA 
$C5F6  98        TYA 
$C5F7  98        TYA 
$C5F8  98        TYA 
$C5F9  98        TYA 
$C5FA  98        TYA 
$C5FB  98        TYA 
$C5FC  98        TYA 
$C5FD  98        TYA 
$C5FE  98        TYA 
$C5FF  98        TYA 
$C600  98        TYA 
$C601  98        TYA 
$C602  98        TYA 
$C603  98        TYA 
$C604  98        TYA 
$C605  98        TYA 
$C606  98        TYA 
$C607  98        TYA 
$C608  98        TYA 
$C609  98        TYA 
$C60A  98        TYA 
$C60B  98        TYA 
$C60C  98        TYA 
$C60D  98        TYA 
$C60E  98        TYA 
$C60F  98        TYA 
$C610  98        TYA 
$C611  98        TYA 
$C612  98        TYA 
$C613  98        TYA 
$C614  98        TYA 
$C615  98        TYA 
$C616  98        TYA 
$C617  98        TYA 
$C618  98        TYA 
$C619  98        TYA 
$C61A  98        TYA 
$C61B  98        TYA 
$C61C  98        TYA 
$C61D  98        TYA 
$C61E  98        TYA 
$C61F  98        TYA 
$C620  98        TYA 
$C621  98        TYA 
$C622  98        TYA 
$C623  98        TYA 
$C624  98        TYA 
$C625  98        TYA 
$C626  98        TYA 
$C627  98        TYA 
$C628  98        TYA 
$C629  98        TYA 
$C62A  98        TYA 
$C62B  98        TYA 
$C62C  98        TYA 
$C62D  98        TYA 
$C62E  98        TYA 
$C62F  98        TYA 
$C630  98        TYA 
$C631  98        TYA 
$C632  98        TYA 
$C633  98        TYA 
$C634  98        TYA 
$C635  98        TYA 
$C636  98        TYA 
$C637  98        TYA 
$C638  98        TYA 
$C639  98        TYA 
$C63A  98        TYA 
$C63B  98        TYA 
$C63C  98        TYA 
$C63D  98        TYA 
$C63E  98        TYA 
$C63F  98        TYA 
$C640  98        TYA 
$C641  98        TYA 
$C642  98        TYA 
$C643  98        TYA 
$C644  98        TYA 
$C645  98        TYA 
$C646  98        TYA 
$C647  98        TYA 
$C648  98        TYA 
$C649  98        TYA 
$C64A  98        TYA 
$C64B  98        TYA 
$C64C  98        TYA 
$C64D  98        TYA 
$C64E  98        TYA 
$C64F  98        TYA 
$C650  98        TYA 
$C651  98        TYA 
$C652  98        TYA 
$C653  98        TYA 
$C654  98        TYA 
$C655  98        TYA 
$C656  98        TYA 
$C657  98        TYA 
$C658  98        TYA 
$C659  98        TYA 
$C65A  98        TYA 
$C65B  98        TYA 
$C65C  98        TYA 
$C65D  98        TYA 
$C65E  98        TYA 
$C65F  98        TYA 
$C660  98        TYA 
$C661  98        TYA 
$C662  98        TYA 
$C663  98        TYA 
$C664  98        TYA 
$C665  98        TYA 
$C666  98        TYA 
$C667  98        TYA 
$C668  98        TYA 
$C669  98        TYA 
$C66A  98        TYA 
$C66B  98        TYA 
$C66C  98        TYA 
$C66D  98        TYA 
$C66E  98        TYA 
$C66F  98        TYA 
$C670  98        TYA 
$C671  98        TYA 
$C672  98        TYA 
$C673  98        TYA 
$C674  98        TYA 
$C675  98        TYA 
$C676  98        TYA 
$C677  98        TYA 
$C678  98        TYA 
$C679  98        TYA 
$C67A  98        TYA 
$C67B  98        TYA 
$C67C  98        TYA 
$C67D  98        TYA 
$C67E  98        TYA 
$C67F  98        TYA 
$C680  98        TYA 
$C681  98        TYA 
$C682  98        TYA 
$C683  98        TYA 
$C684  98        TYA 
$C685  98        TYA 
$C686  98        TYA 
$C687  98        TYA 
$C688  98        TYA 
$C689  98        TYA 
$C68A  98        TYA 
$C68B  98        TYA 
$C68C  98        TYA 
$C68D  98        TYA 
$C68E  98        TYA 
$C68F  98        TYA 
$C690  98        TYA 
$C691  98        TYA 
$C692  98        TYA 
$C693  98        TYA 
$C694  98        TYA 
$C695  98        TYA 
$C696  98        TYA 
$C697  98        TYA 
$C698  98        TYA 
$C699  98        TYA 
$C69A  98        TYA 
$C69B  98        TYA 
$C69C  98        TYA 
$C69D  98        TYA 
$C69E  98        TYA 
$C69F  98        TYA 
$C6A0  98        TYA 
$C6A1  98        TYA 
$C6A2  98        TYA 
$C6A3  98        TYA 
$C6A4  98        TYA 
$C6A5  98        TYA 
$C6A6  98        TYA 
$C6A7  98        TYA 
$C6A8  98        TYA 
$C6A9  98        TYA 
$C6AA  98        TYA 
$C6AB  98        TYA 
$C6AC            .byte $77,$77,$77,$77,$77,$77,$77,$77
$C6B4            .byte $77,$77,$77,$77,$77,$77,$77,$77
$C6BC            .byte $77,$77,$77,$77,$77,$77,$77,$77
$C6C4            .byte $77,$77,$77,$77,$77,$77,$77,$77
$C6CC  98        TYA 
$C6CD  98        TYA 
$C6CE  98        TYA 
$C6CF  98        TYA 
$C6D0  98        TYA 
$C6D1  98        TYA 
$C6D2  98        TYA 
$C6D3  98        TYA 
$C6D4  18        CLC 
$C6D5  18        CLC 
$C6D6  18        CLC 
$C6D7  18        CLC 
$C6D8  18        CLC 
$C6D9  18        CLC 
$C6DA  18        CLC 
$C6DB  18        CLC 
$C6DC  18        CLC 
$C6DD  18        CLC 
$C6DE  18        CLC 
$C6DF  18        CLC 
$C6E0  18        CLC 
$C6E1  18        CLC 
$C6E2  18        CLC 
$C6E3  18        CLC 
$C6E4  18        CLC 
$C6E5  18        CLC 
$C6E6  18        CLC 
$C6E7  18        CLC 
$C6E8  18        CLC 
$C6E9  18        CLC 
$C6EA  18        CLC 
$C6EB  18        CLC 
$C6EC  18        CLC 
$C6ED  18        CLC 
$C6EE  18        CLC 
$C6EF  18        CLC 
$C6F0  98        TYA 
$C6F1  98        TYA 
$C6F2  98        TYA 
$C6F3  98        TYA 
$C6F4  98        TYA 
$C6F5  98        TYA 
$C6F6  98        TYA 
$C6F7  98        TYA 
$C6F8  98        TYA 
$C6F9  98        TYA 
$C6FA  98        TYA 
$C6FB  98        TYA 
$C6FC  11 11     ORA ($11),Y
$C6FE  11 11     ORA ($11),Y
$C700  11 11     ORA ($11),Y
$C702  11 11     ORA ($11),Y
$C704  11 11     ORA ($11),Y
$C706  76 67     ROR $67,X 
$C708  76 76     ROR $76,X 
$C70A            .byte $27,$27,$27,$27,$27,$27,$27,$27
$C712            .byte $27,$27,$27,$22,$22,$22
$C718  98        TYA 
$C719  98        TYA 
$C71A  98        TYA 
$C71B  98        TYA 
$C71C  98        TYA 
$C71D  98        TYA 
$C71E  98        TYA 
$C71F  98        TYA 
$C720  98        TYA 
$C721  98        TYA 
$C722  98        TYA 
$C723  98        TYA 
$C724  98        TYA 
$C725  98        TYA 
$C726            .byte $92,$92,$92,$92,$92,$92,$92
$C72D  66 67     ROR $67 
$C72F  66 66     ROR $66 
$C731  66 27     ROR $27 
$C733            .byte $27,$27,$27,$27,$27,$27,$27,$27
$C73B            .byte $27,$1B
$C73D  B1 B1     LDA ($B1),Y 
$C73F  B1 1B     LDA ($1B),Y 
$C741            .byte $1B
$C742  98        TYA 
$C743  98        TYA 
$C744  98        TYA 
$C745  98        TYA 
$C746  98        TYA 
$C747  98        TYA 
$C748  98        TYA 
$C749  98        TYA 
$C74A  98        TYA 
$C74B  98        TYA 
$C74C  98        TYA 
$C74D  98        TYA 
$C74E            .byte $92,$92,$92,$92,$92,$92,$92
$C755  66 66     ROR $66 
$C757  66 66     ROR $66 
$C759  66 27     ROR $27 
$C75B            .byte $27,$27,$27,$27,$27,$27,$27,$27
$C763            .byte $27,$1B
$C765  6C 6C 6C  JMP ($6C6C) 
$C768  6C 1B 98  JMP ($981B) 
$C76B  98        TYA 
$C76C  98        TYA 
$C76D  98        TYA 
$C76E  98        TYA 
$C76F  98        TYA 
$C770  98        TYA 
$C771  98        TYA 
$C772  98        TYA 
$C773  98        TYA 
$C774  98        TYA 
$C775  98        TYA 
$C776            .byte $92,$92,$92,$92,$92,$92,$92
$C77D  66 66     ROR $66 
$C77F  66 66     ROR $66 
$C781  66 27     ROR $27 
$C783            .byte $27,$27,$27,$27,$27,$27,$27,$27
$C78B            .byte $27
$C78C  B1 6C     LDA ($6C),Y 
$C78E  6C 6C 6C  JMP ($6C6C) 
$C791            .byte $1B
$C792  98        TYA 
$C793  98        TYA 
$C794  98        TYA 
$C795  98        TYA 
$C796  98        TYA 
$C797  98        TYA 
$C798  98        TYA 
$C799  98        TYA 
$C79A  98        TYA 
$C79B  98        TYA 
$C79C  98        TYA 
$C79D  98        TYA 
$C79E            .byte $92,$92,$92,$92,$92,$92,$92
$C7A5  66 66     ROR $66 
$C7A7  66 66     ROR $66 
$C7A9  66 27     ROR $27 
$C7AB            .byte $27,$27,$27,$27,$27,$27,$27,$27
$C7B3            .byte $27,$6B
$C7B5  6C 6C 6C  JMP ($6C6C) 
$C7B8  6C 1B 98  JMP ($981B) 
$C7BB  98        TYA 
$C7BC  98        TYA 
$C7BD  98        TYA 
$C7BE  98        TYA 
$C7BF  98        TYA 
$C7C0  98        TYA 
$C7C1  98        TYA 
$C7C2  98        TYA 
$C7C3  98        TYA 
$C7C4  98        TYA 
$C7C5  98        TYA 
$C7C6  98        TYA 
$C7C7  81 81     STA ($81,X) 
$C7C9  81 81     STA ($81,X) 
$C7CB  81 81     STA ($81,X) 
$C7CD  81 76     STA ($76,X) 
$C7CF            .byte $67
$C7D0  76 76     ROR $76,X 
$C7D2            .byte $27,$27,$27,$27,$27,$27,$27,$27
$C7DA            .byte $27,$27,$1B,$1B
$C7DE  B1 B1     LDA ($B1),Y 
$C7E0            .byte $1B,$1B
$C7E2  98        TYA 
$C7E3  98        TYA 
$C7E4  98        TYA 
$C7E5  98        TYA 
$C7E6  98        TYA 
$C7E7  98        TYA 
$C7E8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C7F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C7F8  01 00     ORA ($00,X)
$C7FA            .byte $02,$03,$04
$C7FD  05 06     ORA $06
$C7FF            .byte $07,$00,$00,$02
$C803  01 00     ORA ($00,X)
$C805            .byte $00,$44,$00
$C808  18        CLC 
$C809            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C811            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C819            .byte $00,$04,$00,$00,$00,$00,$00,$00
$C821            .byte $00,$00
$C823  01 00     ORA ($00,X)
$C825  EA        NOP 
$C826  01 80     ORA ($80,X)
$C828  15 30     ORA $30,X
$C82A            .byte $04
$C82B  01 00     ORA ($00,X)
$C82D            .byte $00
$C82E  24 00     BIT $00 
$C830  84 00     STY $00 
$C832  28        PLP 
$C833            .byte $00,$80,$00
$C836  24 00     BIT $00 
$C838  94 00     STY $00,X 
$C83A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C842            .byte $02,$02,$02
$C845  06 01     ASL $01 
$C847            .byte $00,$00,$00,$00
$C84B  01 00     ORA ($00,X)
$C84D  EA        NOP 
$C84E  06 40     ASL $40 
$C850  19 13 02  ORA $0213,Y
$C853  01 00     ORA ($00,X)
$C855            .byte $00
$C856  08        PHP 
$C857            .byte $00
$C858  08        PHP 
$C859            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C861            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C869            .byte $00
$C86A  08        PHP 
$C86B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C873  01 00     ORA ($00,X)
$C875            .byte $9E,$02
$C877  20 0C 04  JSR $040C
$C87A            .byte $02
$C87B  01 00     ORA ($00,X)
$C87D            .byte $00
$C87E  CC 00 00  CPY $0000 
$C881            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C889            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C891            .byte $00,$37,$00,$00,$00,$00,$00,$00
$C899            .byte $00,$00
$C89B  01 00     ORA ($00,X)
$C89D  A0 00     LDY #$00
$C89F  10 1E     BPL L_BRS_($C8BF)_($C89F) BAD
$C8A1  11 02     ORA ($02),Y
$C8A3  01 00     ORA ($00,X)
$C8A5            .byte $00
$C8A6  88        DEY 
$C8A7            .byte $00,$00,$00,$34,$00,$14,$00
$C8AE  30 00     BMI L_BRS_($C8B0)_($C8AE) JAM
//------------------------------
L_BRS_($C8B0)_($C8AE) JAM
//------------------------------
$C8B0            .byte $0C,$00,$00,$00,$00,$00,$00,$00
$C8B8            .byte $00,$00,$1C
$C8BB  09 04     ORA #$04
//------------------------------
L_BRS_($C8BF)_($C89F) BAD
//------------------------------
$C8BD  0D 0E 00  ORA $000E
$C8C0            .byte $00,$00,$00
$C8C3  01 00     ORA ($00,X)
$C8C5            .byte $3A
$C8C6  0D 80 19  ORA $1980
$C8C9  10 02     BPL L_BRS_($C8CD)_($C8C9) JAM
$C8CB  01 00     ORA ($00,X)
//------------------------------
L_BRS_($C8CD)_($C8C9) JAM
//------------------------------
$C8CD            .byte $00
$C8CE  CC 00 00  CPY $0000 
$C8D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C8D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C8E1            .byte $00,$37,$00,$00,$00,$00,$00,$00
$C8E9            .byte $00,$00
$C8EB  01 00     ORA ($00,X)
$C8ED  A0 00     LDY #$00
$C8EF  10 1E     BPL L_BRS_($C90F)_($C8EF) OK
$C8F1  11 03     ORA ($03),Y
$C8F3            .byte $04,$00,$00,$00,$00
$C8F8  2C 00 24  BIT $2400 
$C8FB            .byte $00
$C8FC  28        PLP 
$C8FD            .byte $00
$C8FE  58        CLI 
$C8FF            .byte $00
$C900  68        PLA 
$C901            .byte $00
$C902  6C 00 64  JMP ($6400) 
$C905            .byte $00,$54,$00,$3C,$00,$03
$C90B  01 07     ORA ($07,X)
$C90D            .byte $07,$04
//------------------------------
L_BRS_($C90F)_($C8EF) OK
//------------------------------
$C90F  05 0E     ORA $0E
$C911  08        PHP 
$C912            .byte $03
$C913  01 00     ORA ($00,X)
$C915            .byte $62,$07
$C917  40        RTI 
//------------------------------
$C918            .byte $6B,$D4,$07
$C91B  01 00     ORA ($00,X)
$C91D            .byte $00,$00,$00,$04,$00
$C922  10 00     BPL L_BRS_($C924)_($C922) OK
//------------------------------
L_BRS_($C924)_($C922) OK
//------------------------------
$C924  30 00     BMI L_BRS_($C926)_($C924) OK
//------------------------------
L_BRS_($C926)_($C924) OK
//------------------------------
$C926  50 00     BVC L_BRS_($C928)_($C926) OK
//------------------------------
L_BRS_($C928)_($C926) OK
//------------------------------
$C928  A0 00     LDY #$00
$C92A  CC 00 00  CPY $0000 
$C92D            .byte $00,$00,$00,$00,$00
$C932  09 0C     ORA #$0C
$C934            .byte $0B
$C935  05 04     ORA $04
$C937            .byte $02,$00,$00,$00
$C93B  01 00     ORA ($00,X)
$C93D            .byte $80,$02,$80
$C940  35 F9     AND $F9,X 
$C942            .byte $02
$C943  05 00     ORA $00
$C945            .byte $00,$80,$00,$00,$00,$00,$00,$00
$C94D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C955            .byte $00,$00,$00,$00,$00
$C95A  06 00     ASL $00 
$C95C            .byte $00,$00,$00,$00,$00,$00,$00,$02
$C964            .byte $00
$C965  D0 02     BNE L_BRS_($C969)_($C965) JAM
$C967  10 19     BPL L_BRS_($C982)_($C967) JAM
//------------------------------
L_BRS_($C969)_($C965) JAM
//------------------------------
$C969            .byte $F7,$03
$C96B  01 00     ORA ($00,X)
$C96D            .byte $00,$1C,$00,$00,$00
$C972  18        CLC 
$C973            .byte $00,$7C,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($C982)_($C967) JAM
//------------------------------
$C97B            .byte $00,$00,$00,$00,$00,$00,$00,$04
$C983            .byte $07,$02
$C985  15 00     ORA $00,X
$C987            .byte $00,$00,$00,$00
$C98B  01 00     ORA ($00,X)
$C98D  38        SEC 
$C98E            .byte $0F,$80
$C990  38        SEC 
$C991            .byte $FC,$04
$C993  01 00     ORA ($00,X)
$C995            .byte $00
$C996  90 00     BCC L_BRS_($C998)_($C996) OK
//------------------------------
L_BRS_($C998)_($C996) OK
//------------------------------
$C998  C0 00     CPY #$00
$C99A  4C 00 4C  JMP L_JMP_($4C00)_($C99A) BAD
$C99D            .byte $00,$54,$00,$00,$00,$00,$00,$00
$C9A5            .byte $00,$00,$00,$00,$00,$07
$C9AB  0A        ASL A 
$C9AC  06 08     ASL $08 
$C9AE            .byte $00,$00,$00,$00,$00
$C9B3  01 00     ORA ($00,X)
$C9B5  C8        INY 
$C9B6            .byte $00
$C9B7  10 32     BPL L_BRS_($C9EB)_($C9B7) BAD
$C9B9            .byte $F4,$03
$C9BB  01 00     ORA ($00,X)
$C9BD            .byte $00,$D4,$00,$00,$00,$D4,$00,$00
$C9C5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C9CD            .byte $00,$00,$00,$00,$00,$04
$C9D3  05 00     ORA $00
$C9D5            .byte $00,$00,$00,$00,$00,$00
$C9DB  01 00     ORA ($00,X)
$C9DD  A2 03     LDX #$03
$C9DF            .byte $80
$C9E0  2A        ROL A 
$C9E1            .byte $32,$04,$03,$00,$00
$C9E6  AC 00 84  LDY $8400 
$C9E9            .byte $00
//------------------------------
L_BRS_($C9EB)_($C9B7) BAD
//------------------------------
$C9EA  AC 00 84  LDY $8400 
$C9ED            .byte $00,$00,$00,$00,$00,$00,$00,$00
$C9F5            .byte $00,$00,$00,$00,$00,$04,$02
$C9FC  05 00     ORA $00
$C9FE            .byte $00,$00,$00,$00,$00
$CA03  01 00     ORA ($00,X)
$CA05  AA        TAX 
$CA06  05 10     ORA $10
$CA08  16 F8     ASL $F8,X 
$CA0A            .byte $02
$CA0B  05 00     ORA $00
$CA0D            .byte $00,$34,$00
$CA10  4C 00 50  JMP L_JMP_($5000)_($CA10) OK
$CA13            .byte $00,$44,$00,$00,$00,$00,$00,$00
$CA1B            .byte $00,$00,$00,$00,$00,$00,$00,$07
$CA23            .byte $04,$04,$00,$00,$00,$00,$00,$00
$CA2B  01 00     ORA ($00,X)
$CA2D  90 01     BCC L_BRS_($CA30)_($CA2D) BAD
//------------------------------
L_BRS_($CA30)_($CA2D) BAD
//------------------------------
$CA2F  20 33 FA  JSR L_JSR_($FA33)_($CA2F) JAM
$CA32            .byte $03
$CA33  01 00     ORA ($00,X)
$CA35            .byte $00,$B8,$00,$D4,$00,$00,$00,$00
$CA3D            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CA45            .byte $00,$00,$00,$00,$00
$CA4A  08        PHP 
$CA4B            .byte $07,$00,$00,$00,$00,$00,$00,$00
$CA53  01 00     ORA ($00,X)
$CA55  EA        NOP 
$CA56  06 80     ASL $80 
$CA58  15 F7     ORA $F7,X
$CA5A  05 01     ORA $01
$CA5C            .byte $00,$00,$14,$00
$CA60  50 00     BVC L_BRS_($CA62)_($CA60) OK
//------------------------------
L_BRS_($CA62)_($CA60) OK
//------------------------------
$CA62  98        TYA 
$CA63            .byte $00
$CA64  C4 00     CPY $00 
$CA66  94 00     STY $00,X 
$CA68  C0 00     CPY #$00
$CA6A            .byte $34,$00,$74,$00
$CA6E  48        PHA 
$CA6F            .byte $00
$CA70  88        DEY 
$CA71            .byte $00
$CA72  18        CLC 
$CA73            .byte $0F
$CA74  06 06     ASL $06 
$CA76            .byte $12,$04,$04
$CA79  05 02     ORA $02
$CA7B  01 03     ORA ($03,X)
$CA7D  EA        NOP 
$CA7E            .byte $0B
$CA7F  20 32 F8  JSR L_JSR_($F832)_($CA7F) JAM
$CA82            .byte $02
$CA83  01 00     ORA ($00,X)
$CA85            .byte $00,$00,$00
$CA88  08        PHP 
$CA89            .byte $00,$04,$00,$00,$00,$00,$00,$00
$CA91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CA99            .byte $00
$CA9A  19 07 00  ORA $0007,Y
$CA9D            .byte $00,$00,$00,$00,$00,$00,$04,$00
$CAA5  06 04     ASL $04 
$CAA7  20 65 F0  JSR L_JSR_($F065)_($CAA7) JAM
$CAAA            .byte $03
$CAAB  01 00     ORA ($00,X)
$CAAD            .byte $00,$0C,$00,$0C,$00,$1C,$00,$00
$CAB5            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CABD            .byte $00,$00,$00,$00,$00,$02
$CAC3  06 00     ASL $00 
$CAC5            .byte $00,$00,$00,$00,$00,$00
$CACB  01 00     ORA ($00,X)
$CACD            .byte $B2,$02,$80
$CAD0  29 11     AND #$11
$CAD2            .byte $04
$CAD3  01 00     ORA ($00,X)
$CAD5            .byte $00
$CAD6  08        PHP 
$CAD7            .byte $00
$CAD8  08        PHP 
$CAD9            .byte $00
$CADA  28        PLP 
$CADB            .byte $00
$CADC  60        RTS 
//------------------------------
$CADD            .byte $00
$CADE  68        PLA 
$CADF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CAE7            .byte $00,$00,$00
$CAEA  08        PHP 
$CAEB            .byte $12
$CAEC  09 00     ORA #$00
$CAEE            .byte $00,$00,$00,$00,$00,$02,$00
$CAF5  EE 02 40  INC $4002 
$CAF8  4A        LSR A 
$CAF9  11 04     ORA ($04),Y
$CAFB  01 00     ORA ($00,X)
$CAFD            .byte $00,$00,$00
$CB00  18        CLC 
$CB01            .byte $00
$CB02  50 00     BVC L_BRS_($CB04)_($CB02) OK
//------------------------------
L_BRS_($CB04)_($CB02) OK
//------------------------------
$CB04  94 00     STY $00,X 
$CB06            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CB0E            .byte $00,$00,$00,$00
$CB12  15 0B     ORA $0B,X
$CB14  08        PHP 
$CB15  05 00     ORA $00
$CB17            .byte $00,$00,$00,$00,$02,$00,$72
$CB1E  06 40     ASL $40 
$CB20  35 F4     AND $F4,X 
$CB22            .byte $02
$CB23  01 00     ORA ($00,X)
$CB25            .byte $00
$CB26  4C 00 00  JMP $0000
$CB29            .byte $00
$CB2A  38        SEC 
$CB2B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CB33            .byte $00,$00,$00,$00,$00,$00,$00,$0F
$CB3B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CB43  01 00     ORA ($00,X)
$CB45  20 0E 80  JSR L_JSR_($800E)_($CB45) OK
$CB48  26 00     ROL $00 
//------------------------------
L_BRS_($CB4A)_($CB4E) OK
//------------------------------
$CB4A  60        RTS 
//------------------------------
L_JSR_($CB4B)_($4133) OK
L_JSR_($CB4B)_($43A1) OK
L_JSR_($CB4B)_($43F7) OK
L_JSR_($CB4B)_($44E4) OK
L_JSR_($CB4B)_($5F42) OK
L_JSR_($CB4B)_($66DE) OK
L_JSR_($CB4B)_($6D6F) OK
L_JSR_($CB4B)_($6DEB) OK
L_JSR_($CB4B)_($72B6) OK
L_JSR_($CB4B)_($7C3B) OK
L_JSR_($CB4B)_($7C60) OK
L_JSR_($CB4B)_($7CA4) OK
//------------------------------
$CB4B  AE 36 17  LDX $1736 
$CB4E  D0 FA     BNE L_BRS_($CB4A)_($CB4E) OK
$CB50  A2 02     LDX #$02
$CB52  86 7E     STX $7E 
$CB54  A2 C8     LDX #$C8
$CB56  86 7F     STX $7F 
$CB58  AA        TAX 
$CB59  CA        DEX 
$CB5A  F0 0E     BEQ L_BRS_($CB6A)_($CB5A) OK
//------------------------------
L_BRS_($CB5C)_($CB68) OK
//------------------------------
$CB5C  A5 7E     LDA $7E 
$CB5E  18        CLC 
$CB5F  69 28     ADC #$28
$CB61  85 7E     STA $7E 
$CB63  90 02     BCC L_BRS_($CB67)_($CB63) OK
$CB65  E6 7F     INC $7F 
//------------------------------
L_BRS_($CB67)_($CB63) OK
//------------------------------
$CB67  CA        DEX 
$CB68  D0 F2     BNE L_BRS_($CB5C)_($CB68) OK
//------------------------------
L_BRS_($CB6A)_($CB5A) OK
//------------------------------
$CB6A  20 17 CD  JSR L_JSR_($CD17)_($CB6A) OK
$CB6D  A9 00     LDA #$00
$CB6F  8D 04 D4  STA $D404                          // Voice 1: Control Register
$CB72  A0 00     LDY #$00
//------------------------------
L_BRS_($CB74)_($CB7C) OK
//------------------------------
$CB74  B1 7E     LDA ($7E),Y 
$CB76  99 2A CD  STA $CD2A,Y 
$CB79  C8        INY 
$CB7A  C0 28     CPY #$28
$CB7C  90 F6     BCC L_BRS_($CB74)_($CB7C) OK
$CB7E  AD 4D CD  LDA $CD4D 
$CB81  8D 02 D4  STA $D402                          // Voice 1: Pulse Waveform Width - Low-Byte
$CB84  AD 4E CD  LDA $CD4E 
$CB87  8D 03 D4  STA $D403                          // Voice 1: Pulse Waveform Width - High-Nybble
$CB8A  AD 50 CD  LDA $CD50 
$CB8D  8D 05 D4  STA $D405                          // Voice 1: Attack / Decay Cycle Control
$CB90  AD 51 CD  LDA $CD51 
$CB93  8D 06 D4  STA $D406                          // Voice 1: Sustain / Release Cycle Control
$CB96  AE 2A CD  LDX $CD2A 
$CB99  CA        DEX 
$CB9A  8E 00 C8  STX $C800 
$CB9D  A5 88     LDA $88 
$CB9F  48        PHA 
$CBA0  A5 89     LDA $89 
$CBA2  48        PHA 
$CBA3  A5 8A     LDA $8A 
$CBA5  48        PHA 
$CBA6  A5 8B     LDA $8B 
$CBA8  48        PHA 
$CBA9  A5 8C     LDA $8C 
$CBAB  48        PHA 
$CBAC  A5 8D     LDA $8D 
$CBAE  48        PHA 
$CBAF  AD 40 15  LDA $1540 
$CBB2  48        PHA 
$CBB3  A2 00     LDX #$00
$CBB5  A0 00     LDY #$00
//------------------------------
L_JMP_($CBB7)_($CC0E) OK
//------------------------------
$CBB7  BD 2D CD  LDA $CD2D,X 
$CBBA  9D 52 CD  STA $CD52,X 
$CBBD  BD 2E CD  LDA $CD2E,X 
$CBC0  9D 53 CD  STA $CD53,X 
$CBC3  BD 2F CD  LDA $CD2F,X 
$CBC6  38        SEC 
$CBC7  FD 2D CD  SBC $CD2D,X 
$CBCA  85 88     STA $88 
$CBCC  BD 30 CD  LDA $CD30,X 
$CBCF  FD 2E CD  SBC $CD2E,X 
$CBD2  85 89     STA $89 
$CBD4  90 09     BCC L_BRS_($CBDF)_($CBD4) OK
$CBD6  A9 00     LDA #$00
$CBD8  85 8A     STA $8A 
$CBDA  85 8B     STA $8B 
$CBDC  4C E5 CB  JMP L_JMP_($CBE5)_($CBDC) OK
//------------------------------
L_BRS_($CBDF)_($CBD4) OK
//------------------------------
$CBDF  A9 FF     LDA #$FF
$CBE1  85 8A     STA $8A 
$CBE3  85 8B     STA $8B 
//------------------------------
L_JMP_($CBE5)_($CBDC) OK
//------------------------------
$CBE5  B9 42 CD  LDA $CD42,Y 
$CBE8  99 70 CD  STA $CD70,Y 
$CBEB  85 8C     STA $8C 
$CBED  A9 00     LDA #$00
$CBEF  85 8D     STA $8D 
$CBF1  8A        TXA 
$CBF2  48        PHA 
$CBF3  98        TYA 
$CBF4  48        PHA 
$CBF5  20 DE 1E  JSR L_JSR_($1EDE)_($CBF5) OK
$CBF8  68        PLA 
$CBF9  A8        TAY 
$CBFA  68        PLA 
$CBFB  AA        TAX 
$CBFC  A5 88     LDA $88 
$CBFE  9D 61 CD  STA $CD61,X 
$CC01  A5 89     LDA $89 
$CC03  9D 62 CD  STA $CD62,X 
$CC06  C8        INY 
$CC07  E8        INX 
$CC08  E8        INX 
$CC09  CE 00 C8  DEC $C800 
$CC0C  F0 03     BEQ L_BRS_($CC11)_($CC0C) OK
$CC0E  4C B7 CB  JMP L_JMP_($CBB7)_($CC0E) OK
//------------------------------
L_BRS_($CC11)_($CC0C) OK
//------------------------------
$CC11  68        PLA 
$CC12  8D 40 15  STA $1540 
$CC15  68        PLA 
$CC16  85 8D     STA $8D 
$CC18  68        PLA 
$CC19  85 8C     STA $8C 
$CC1B  68        PLA 
$CC1C  85 8B     STA $8B 
$CC1E  68        PLA 
$CC1F  85 8A     STA $8A 
$CC21  68        PLA 
$CC22  85 89     STA $89 
$CC24  68        PLA 
$CC25  85 88     STA $88 
$CC27  A9 01     LDA #$01
$CC29  8D 01 C8  STA $C801 
$CC2C  60        RTS 
//------------------------------
L_JSR_($CC2D)_($5E4B) OK
L_JSR_($CC2D)_($6C28) OK
//------------------------------
$CC2D  AD 36 17  LDA $1736 
$CC30  D0 5F     BNE L_BRS_($CC91)_($CC30) OK
$CC32  AD 01 C8  LDA $C801 
$CC35  D0 01     BNE L_BRS_($CC38)_($CC35) OK
$CC37  60        RTS 
//------------------------------
L_BRS_($CC38)_($CC35) OK
//------------------------------
$CC38  C9 FF     CMP #$FF
$CC3A  D0 06     BNE L_BRS_($CC42)_($CC3A) OK
$CC3C  A9 00     LDA #$00
$CC3E  8D 01 C8  STA $C801 
$CC41  60        RTS 
//------------------------------
L_BRS_($CC42)_($CC3A) OK
//------------------------------
$CC42  C9 01     CMP #$01
$CC44  D0 47     BNE L_BRS_($CC8D)_($CC44) OK
$CC46  AD 2B CD  LDA $CD2B 
$CC49  8D 0D CD  STA $CD0D 
//------------------------------
L_JMP_($CC4C)_($CCF9) OK
//------------------------------
$CC4C  AE 2A CD  LDX $CD2A 
$CC4F  CA        DEX 
$CC50  8E 10 CD  STX $CD10 
$CC53  A9 00     LDA #$00
$CC55  8D 0F CD  STA $CD0F 
$CC58  8D 0E CD  STA $CD0E 
$CC5B  AC 0E CD  LDY $CD0E 
$CC5E  AE 0F CD  LDX $CD0F 
$CC61  AD 4B CD  LDA $CD4B 
$CC64  8D 11 CD  STA $CD11 
$CC67  BD 52 CD  LDA $CD52,X 
$CC6A  8D 0B CD  STA $CD0B 
$CC6D  8D 00 D4  STA $D400                          // Voice 1: Frequency Control - Low-Byte
$CC70  BD 53 CD  LDA $CD53,X 
$CC73  8D 0C CD  STA $CD0C 
$CC76  8D 01 D4  STA $D401                          // Voice 1: Frequency Control - High-Byte
$CC79  B9 70 CD  LDA $CD70,Y 
$CC7C  8D 0A CD  STA $CD0A 
$CC7F  AD 4F CD  LDA $CD4F 
$CC82  09 01     ORA #$01
$CC84  8D 04 D4  STA $D404                          // Voice 1: Control Register
$CC87  A9 02     LDA #$02
$CC89  8D 01 C8  STA $C801 
$CC8C  60        RTS 
//------------------------------
L_BRS_($CC8D)_($CC44) OK
//------------------------------
$CC8D  C9 02     CMP #$02
$CC8F  F0 01     BEQ L_BRS_($CC92)_($CC8F) OK
//------------------------------
L_BRS_($CC91)_($CC30) OK
L_BRS_($CC91)_($CC95) OK
//------------------------------
$CC91  60        RTS 
//------------------------------
L_BRS_($CC92)_($CC8F) OK
//------------------------------
$CC92  CE 11 CD  DEC $CD11 
$CC95  D0 FA     BNE L_BRS_($CC91)_($CC95) OK
$CC97  AD 4B CD  LDA $CD4B 
$CC9A  8D 11 CD  STA $CD11 
$CC9D  AE 0F CD  LDX $CD0F 
$CCA0  AC 0E CD  LDY $CD0E 
$CCA3  AD 0B CD  LDA $CD0B 
$CCA6  18        CLC 
$CCA7  7D 61 CD  ADC $CD61,X 
$CCAA  8D 0B CD  STA $CD0B 
$CCAD  8D 00 D4  STA $D400                          // Voice 1: Frequency Control - Low-Byte
$CCB0  AD 0C CD  LDA $CD0C 
$CCB3  7D 62 CD  ADC $CD62,X 
$CCB6  8D 0C CD  STA $CD0C 
$CCB9  8D 01 D4  STA $D401                          // Voice 1: Frequency Control - High-Byte
$CCBC  CE 0A CD  DEC $CD0A 
$CCBF  D0 48     BNE L_BRS_($CD09)_($CCBF) OK
$CCC1  EE 0F CD  INC $CD0F 
$CCC4  EE 0F CD  INC $CD0F 
$CCC7  EE 0E CD  INC $CD0E 
$CCCA  CE 10 CD  DEC $CD10 
$CCCD  F0 25     BEQ L_BRS_($CCF4)_($CCCD) OK
$CCCF  AE 0F CD  LDX $CD0F 
$CCD2  AC 0E CD  LDY $CD0E 
$CCD5  B9 70 CD  LDA $CD70,Y 
$CCD8  8D 0A CD  STA $CD0A 
$CCDB  AD 4B CD  LDA $CD4B 
$CCDE  8D 11 CD  STA $CD11 
$CCE1  BD 52 CD  LDA $CD52,X 
$CCE4  8D 0B CD  STA $CD0B 
$CCE7  8D 00 D4  STA $D400                          // Voice 1: Frequency Control - Low-Byte
$CCEA  BD 53 CD  LDA $CD53,X 
$CCED  8D 0C CD  STA $CD0C 
$CCF0  8D 01 D4  STA $D401                          // Voice 1: Frequency Control - High-Byte
$CCF3  60        RTS 
//------------------------------
L_BRS_($CCF4)_($CCCD) OK
//------------------------------
$CCF4  CE 0D CD  DEC $CD0D 
$CCF7  F0 03     BEQ L_BRS_($CCFC)_($CCF7) OK
$CCF9  4C 4C CC  JMP L_JMP_($CC4C)_($CCF9) OK
//------------------------------
L_BRS_($CCFC)_($CCF7) OK
//------------------------------
$CCFC  A9 00     LDA #$00
$CCFE  8D 01 C8  STA $C801 
$CD01  AD 4F CD  LDA $CD4F 
$CD04  29 FE     AND #$FE
$CD06  8D 04 D4  STA $D404                          // Voice 1: Control Register
//------------------------------
L_BRS_($CD09)_($CCBF) OK
//------------------------------
$CD09  60        RTS 
//------------------------------
$CD0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($CD12)_($40C1) OK
L_JSR_($CD12)_($40FC) OK
L_JSR_($CD12)_($4387) OK
L_JSR_($CD12)_($8470) OK
//------------------------------
$CD12  A0 13     LDY #$13
$CD14  4C 19 CD  JMP L_JMP_($CD19)_($CD14) OK
//------------------------------
L_JSR_($CD17)_($CB6A) OK
//------------------------------
$CD17  A0 06     LDY #$06
//------------------------------
L_JMP_($CD19)_($CD14) OK
//------------------------------
$CD19  AD 36 17  LDA $1736 
$CD1C  D0 0B     BNE L_BRS_($CD29)_($CD1C) OK
$CD1E  A9 00     LDA #$00
$CD20  8D 01 C8  STA $C801 
//------------------------------
L_BRS_($CD23)_($CD27) OK
//------------------------------
$CD23  99 00 D4  STA $D400,Y                          // Voice 1: Frequency Control - Low-Byte
$CD26  88        DEY 
$CD27  10 FA     BPL L_BRS_($CD23)_($CD27) OK
//------------------------------
L_BRS_($CD29)_($CD1C) OK
//------------------------------
$CD29  60        RTS 
//------------------------------
$CD2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CD9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDCA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDD2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CDFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CE9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CECA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CED2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CEFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CF9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFCA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFD2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$CFFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D002            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D00A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D012            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D01A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D022            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D02A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D032            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D03A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D042            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D04A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D052            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D05A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D062            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D06A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D072            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D07A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D082            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D08A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D092            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D09A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D0FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D102            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D10A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D112            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D11A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D122            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D12A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D132            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D13A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D142            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D14A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D152            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D15A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D162            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D16A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D172            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D17A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D182            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D18A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D192            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D19A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D1FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D202            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D20A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D212            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D21A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D222            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D22A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D232            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D23A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D242            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D24A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D252            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D25A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D262            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D26A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D272            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D27A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D282            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D28A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D292            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D29A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D2FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D302            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D30A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D312            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D31A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D322            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D32A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D332            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D33A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D342            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D34A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D352            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D35A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D362            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D36A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D372            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D37A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D382            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D38A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D392            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D39A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D3FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D402            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D40A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D412            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D41A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D422            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D42A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D432            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D43A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D442            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D44A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D452            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D45A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D462            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D46A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D472            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D47A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D482            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D48A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D492            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D49A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D4FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D502            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D50A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D512            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D51A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D522            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D52A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D532            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D53A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D542            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D54A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D552            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D55A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D562            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D56A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D572            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D57A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D582            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D58A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D592            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D59A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D5FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D602            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D60A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D612            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D61A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D622            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D62A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D632            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D63A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D642            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D64A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D652            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D65A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D662            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D66A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D672            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D67A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D682            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D68A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D692            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D69A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D6FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D702            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D70A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D712            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D71A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D722            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D72A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D732            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D73A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D742            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D74A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D752            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D75A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D762            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D76A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D772            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D77A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D782            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D78A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D792            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D79A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D7FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D802            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D80A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D812            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D81A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D822            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D82A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D832            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D83A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D842            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D84A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D852            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D85A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D862            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D86A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D872            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D87A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D882            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D88A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D892            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D89A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D8FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D902            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D90A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D912            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D91A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D922            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D92A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D932            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D93A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D942            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D94A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D952            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D95A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D962            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D96A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D972            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D97A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D982            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D98A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D992            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D99A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9A2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9AA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9B2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9BA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9C2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9CA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9D2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9DA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9E2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9EA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9F2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$D9FA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DA9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DABA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DACA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAD2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DADA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DAFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DB9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBCA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBD2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DBFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DC9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCCA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCD2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DCFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DD9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDCA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDD2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DDFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DE9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DECA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DED2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DEFA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF02            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF0A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF12            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF1A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF22            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF2A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF32            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF3A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF42            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF4A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF52            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF5A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF62            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF6A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF72            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF7A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF82            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF8A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF92            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DF9A            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFA2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFAA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFB2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFBA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFC2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFCA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFD2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFDA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFE2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFEA            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFF2            .byte $00,$00,$00,$00,$00,$00,$00,$00
$DFFA            .byte $00,$00,$00,$00,$00,$00,$00
$E001  09 16     ORA #$16
$E003  59 50 45  EOR $4550,Y 
$E006  56 15     LSR $15,X 
$E008  9A        TXS 
$E009  AA        TAX 
$E00A  AA        TAX 
$E00B            .byte $00
$E00C  6A        ROR A 
$E00D  9A        TXS 
$E00E  6A        ROR A 
$E00F  9A        TXS 
$E010            .byte $BB,$BB
$E012  AE 03 EC  LDX $EC03                          // Keyboard 3 -- Commodore
$E015            .byte $BB
$E016  AE BB 00  LDX $00BB 
$E019  C0 F0     CPY #$F0
$E01B            .byte $FC,$3C
$E01D  CC FC F0  CPY $F0FC 
$E020            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E028            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E030            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E038            .byte $00,$00,$00,$00
$E03C  10 54     BPL L_BRS_($E092)_($E03C) JAM
$E03E            .byte $44,$44,$00,$00,$00,$00
$E044  10 54     BPL L_BRS_($E09A)_($E044) JAM
$E046            .byte $44,$44,$00,$00,$00,$00
$E04C  10 54     BPL L_BRS_($E0A2)_($E04C) JAM
$E04E            .byte $44,$44,$00,$00,$00,$00
$E054  10 54     BPL L_BRS_($E0AA)_($E054) JAM
$E056            .byte $44,$44,$00,$00,$00,$00
$E05C  10 54     BPL L_BRS_($E0B2)_($E05C) JAM
$E05E            .byte $44,$44,$00,$00,$00,$00,$00,$00
$E066            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E06E            .byte $00,$00,$00,$03,$0C,$3F,$3F,$3F
$E076            .byte $3F,$3F,$00
$E079  A0 A0     LDY #$A0
$E07B            .byte $00
$E07C  AA        TAX 
$E07D  AA        TAX 
$E07E  AA        TAX 
$E07F  0A        ASL A 
$E080            .byte $00,$00,$00,$00
$E084  55 55     EOR $55,X 
$E086  55 03     EOR $03,X 
$E088            .byte $00,$00,$00,$00
$E08C  55 55     EOR $55,X 
$E08E  55 55     EOR $55,X 
//------------------------------
L_BRS_($E092)_($E03C) JAM
//------------------------------
$E090            .byte $00,$00,$00,$00
$E094  40        RTI 
//------------------------------
$E095  55 55     EOR $55,X 
//------------------------------
L_BRS_($E09A)_($E044) JAM
//------------------------------
$E097            .byte $03,$00,$00,$00,$00,$00
$E09D  55 55     EOR $55,X 
//------------------------------
L_BRS_($E0A2)_($E04C) JAM
//------------------------------
$E09F            .byte $03,$00,$00,$00,$00,$00
$E0A5  55 55     EOR $55,X 
//------------------------------
L_BRS_($E0AA)_($E054) JAM
//------------------------------
$E0A7            .byte $03,$00,$00,$00,$00,$00
$E0AD  55 55     EOR $55,X 
$E0AF  55 00     EOR $00,X 
//------------------------------
L_BRS_($E0B2)_($E05C) JAM
//------------------------------
$E0B1            .byte $00,$00,$00
$E0B4  15 55     ORA $55,X
$E0B6  55 03     EOR $03,X 
$E0B8            .byte $00,$00,$00,$00
$E0BC  55 55     EOR $55,X 
$E0BE  55 03     EOR $03,X 
$E0C0            .byte $00
$E0C1  15 14     ORA $14,X
$E0C3  01 55     ORA ($55,X)
$E0C5  55 55     EOR $55,X 
$E0C7            .byte $03,$00,$00
$E0CA  40        RTI 
//------------------------------
$E0CB  50 50     BVC L_BRS_($E11D)_($E0CB) JAM
$E0CD  50 50     BVC L_BRS_($E11F)_($E0CD) JAM
$E0CF  50 00     BVC L_BRS_($E0D1)_($E0CF) JAM
//------------------------------
L_BRS_($E0D1)_($E0CF) JAM
//------------------------------
$E0D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E0D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($E0E8)_($E0F6) JAM
//------------------------------
$E0E1            .byte $03,$0F,$0F,$3F,$3F,$3F,$FF,$00
$E0E9            .byte $FC,$FF,$FF,$FF,$FF,$FF,$FF,$00
$E0F1            .byte $00,$00,$00
$E0F4  C0 C0     CPY #$C0
//------------------------------
L_BRS_($E0F7)_($E139) BAD
//------------------------------
$E0F6  F0 F0     BEQ L_BRS_($E0E8)_($E0F6) JAM
$E0F8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E100            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E108            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E110            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($E11D)_($E0CB) JAM
L_BRS_($E11F)_($E0CD) JAM
//------------------------------
$E118            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E120            .byte $00
$E121  06 15     ASL $15 
$E123  56 50     LSR $50,X 
$E125  45 55     EOR $55 
$E127  15 9A     ORA $9A,X
$E129  6A        ROR A 
$E12A  AA        TAX 
$E12B            .byte $00
$E12C  9A        TXS 
$E12D  66 9A     ROR $9A 
$E12F  66 BB     ROR $BB 
$E131  AE AB 00  LDX $00AB 
$E134            .byte $BB
$E135  AE AB AE  LDX $AEAB 
$E138            .byte $00
$E139  F0 BC     BEQ L_BRS_($E0F7)_($E139) BAD
$E13B            .byte $FF,$0F,$F3,$BF,$FC
$E140  15 05     ORA $05,X
$E142  05 05     ORA $05
$E144            .byte $00
$E145  01 15     ORA ($15,X)
$E147  55 66     EOR $66,X 
$E149  9A        TXS 
$E14A  6A        ROR A 
$E14B  9A        TXS 
$E14C            .byte $00
$E14D  6A        ROR A 
$E14E  6A        ROR A 
$E14F            .byte $00
$E150  EE BB AF  INC $AFBB 
$E153            .byte $BF,$03
$E155  BC BF 0F  LDY $0FBF,X 
$E158  C0 C0     CPY #$C0
$E15A            .byte $00,$00,$00,$00
$E15E  C0 F0     CPY #$F0
$E160            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E168            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E170            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E178            .byte $54
$E179  10 54     BPL L_BRS_($E1CF)_($E179) JAM
$E17B            .byte $54
$E17C  10 10     BPL L_BRS_($E18E)_($E17C) OK
$E17E  10 10     BPL L_BRS_($E190)_($E17E) JAM
$E180            .byte $54
$E181  10 54     BPL L_BRS_($E1D7)_($E181) JAM
$E183            .byte $54
$E184  10 10     BPL L_BRS_($E196)_($E184) OK
$E186  10 10     BPL L_BRS_($E198)_($E186) JAM
$E188            .byte $54
$E189  10 54     BPL L_BRS_($E1DF)_($E189) JAM
$E18B            .byte $54
$E18C  10 10     BPL L_BRS_($E19E)_($E18C) OK
//------------------------------
L_BRS_($E18E)_($E17C) OK
//------------------------------
$E18E  10 10     BPL L_BRS_($E1A0)_($E18E) JAM
//------------------------------
L_BRS_($E190)_($E17E) JAM
//------------------------------
$E190            .byte $54
$E191  10 54     BPL L_BRS_($E1E7)_($E191) JAM
$E193            .byte $54
$E194  10 10     BPL L_BRS_($E1A6)_($E194) JAM
//------------------------------
L_BRS_($E196)_($E184) OK
//------------------------------
$E196  10 10     BPL L_BRS_($E1A8)_($E196) JAM
//------------------------------
L_BRS_($E198)_($E186) JAM
//------------------------------
$E198            .byte $54
$E199  10 54     BPL L_BRS_($E1EF)_($E199) JAM
$E19B            .byte $54
$E19C  10 10     BPL L_BRS_($E1AE)_($E19C) JAM
//------------------------------
L_BRS_($E19E)_($E18C) OK
//------------------------------
$E19E  10 10     BPL L_BRS_($E1B0)_($E19E) JAM
//------------------------------
L_BRS_($E1A0)_($E18E) JAM
L_BRS_($E1A6)_($E194) JAM
//------------------------------
$E1A0            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($E1A8)_($E196) JAM
L_BRS_($E1AE)_($E19C) JAM
//------------------------------
$E1A8            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($E1B0)_($E19E) JAM
//------------------------------
$E1B0            .byte $3F,$3C,$3F,$3F,$3C,$3F,$3F,$3F
$E1B8            .byte $3F,$0F,$3F,$3F,$0F,$FF,$FF,$FF
$E1C0            .byte $33,$33,$33,$33,$03,$FF,$FF,$FF
//------------------------------
L_BRS_($E1CF)_($E179) JAM
//------------------------------
$E1C8            .byte $FF,$FF,$FF,$CF,$CF,$3F,$FF,$FF
//------------------------------
L_BRS_($E1D7)_($E181) JAM
//------------------------------
$E1D0            .byte $33,$33,$33,$33,$03,$FF,$FF,$FF
//------------------------------
L_BRS_($E1DF)_($E189) JAM
//------------------------------
$E1D8            .byte $33,$33,$33,$33,$03,$FF,$FF,$FF
//------------------------------
L_BRS_($E1E7)_($E191) JAM
//------------------------------
$E1E0            .byte $33,$33,$33,$33,$03,$FF,$FF,$FF
//------------------------------
L_BRS_($E1EF)_($E199) JAM
//------------------------------
$E1E8            .byte $FF,$FF,$FF,$CF,$CF,$3F,$FF,$FF
$E1F0            .byte $33,$33,$33,$33,$03,$FF,$FF,$FF
$E1F8            .byte $33,$33,$33,$33,$03,$FF,$FF,$FF
$E200            .byte $33,$33,$33,$33,$03,$FF,$FF,$FF
$E208  50 50     BVC L_BRS_($E25A)_($E208) JAM
$E20A  50 50     BVC L_BRS_($E25C)_($E20A) JAM
$E20C  50 50     BVC L_BRS_($E25E)_($E20C) JAM
$E20E  50 50     BVC L_BRS_($E260)_($E20E) OK
$E210            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E218            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($E222)_($E230) JAM
L_BRS_($E224)_($E232) JAM
L_BRS_($E226)_($E234) JAM
//------------------------------
$E220            .byte $FF,$FF,$FF,$FF,$FF,$3F,$3F,$3F
$E228            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$E230  F0 F0     BEQ L_BRS_($E222)_($E230) JAM
$E232  F0 F0     BEQ L_BRS_($E224)_($E232) JAM
$E234  F0 F0     BEQ L_BRS_($E226)_($E234) JAM
$E236  C0 C0     CPY #$C0
$E238            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E240            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E248            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E250            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($E25A)_($E208) JAM
L_BRS_($E25C)_($E20A) JAM
L_BRS_($E25E)_($E20C) JAM
//------------------------------
$E258            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($E260)_($E20E) OK
//------------------------------
$E260  05 05     ORA $05
$E262  01 01     ORA ($01,X)
$E264  01 00     ORA ($00,X)
$E266  05 15     ORA $15
//------------------------------
L_BRS_($E26A)_($E278) BAD
//------------------------------
$E268  59 66 5A  EOR $5A66,Y 
$E26B  66 00     ROR $00 
$E26D            .byte $5A,$5A
$E26F  40        RTI 
//------------------------------
$E270            .byte $BB
$E271  AE AB AF  LDX $AFAB 
$E274            .byte $00,$AF,$AF,$03
$E278  B0 F0     BCS L_BRS_($E26A)_($E278) BAD
$E27A  C0 C0     CPY #$C0
//------------------------------
L_BRS_($E27C)_($E27E) OK
//------------------------------
$E27C  C0 00     CPY #$00
$E27E  F0 FC     BEQ L_BRS_($E27C)_($E27E) OK
//------------------------------
L_BRS_($E280)_($E290) OK
//------------------------------
$E280  40        RTI 
//------------------------------
$E281  11 05     ORA ($05),Y
$E283  15 45     ORA $45,X
$E285  11 05     ORA ($05),Y
$E287  15 66     ORA $66,X
$E289            .byte $5A
$E28A  66 99     ROR $99 
$E28C  66 5A     ROR $5A 
$E28E  66 99     ROR $99 
$E290  B0 EE     BCS L_BRS_($E280)_($E290) OK
$E292            .byte $BB,$AF,$BB
$E295  EE BB AF  INC $AFBB 
$E298            .byte $3C
$E299  CC F0 FC  CPY $FCF0 
$E29C            .byte $FC,$FC,$FC,$FC,$00,$00,$00,$00
$E2A4            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2AC            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2B4            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2BC            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2C4            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2CC            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2D4            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2DC            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2E4            .byte $00,$00,$00,$FF,$00,$00,$00,$00
$E2EC            .byte $00,$00,$00,$FF
$E2F0  15 15     ORA $15,X
$E2F2            .byte $04
$E2F3  01 00     ORA ($00,X)
$E2F5            .byte $00,$00,$FF
$E2F8  AA        TAX 
$E2F9            .byte $00
$E2FA  A0 A0     LDY #$A0
$E2FC            .byte $00,$00,$00,$FF
$E300  55 00     EOR $00,X 
$E302            .byte $00,$00,$00,$00,$00,$FF
$E308  55 00     EOR $00,X 
$E30A            .byte $00,$00,$00,$00,$00,$FF
$E310  40        RTI 
//------------------------------
$E311            .byte $00,$00,$00,$00,$00,$00,$FF,$00
$E319            .byte $00,$00,$00,$00,$00,$00,$FF,$00
$E321            .byte $00,$00,$00,$00,$00,$00,$FF,$00
$E329            .byte $00,$00,$00,$00,$00,$00,$FF
$E330  15 00     ORA $00,X
$E332            .byte $00,$00,$00,$00,$00,$FF
$E338  55 00     EOR $00,X 
$E33A            .byte $00,$00,$00,$00,$00,$FF
$E340  55 01     EOR $01,X 
$E342            .byte $14
$E343  15 00     ORA $00,X
$E345            .byte $00,$00,$FF
$E348  50 50     BVC L_BRS_($E39A)_($E348) JAM
$E34A  40        RTI 
//------------------------------
$E34B            .byte $00,$00,$00,$00,$FF,$00,$00,$00
$E353            .byte $00,$00,$00,$00,$FF,$00,$00,$00
$E35B            .byte $00,$00,$00,$00,$FF,$0F,$0F,$03
$E363            .byte $00,$00,$00,$00,$FF,$FF,$FF,$FC
$E36B            .byte $00,$00,$00,$00,$FF,$00,$00,$00
$E373            .byte $00,$00,$00,$00,$FF,$00,$00,$00
$E37B            .byte $00,$00,$00,$00,$FF,$00,$00,$00
$E383            .byte $00,$00,$00,$00,$FF,$00,$00,$00
$E38B            .byte $00,$00,$00,$00,$FF,$00,$00,$00
//------------------------------
L_BRS_($E39A)_($E348) JAM
//------------------------------
$E393            .byte $00,$00,$00,$00,$FF,$00,$00,$00
$E39B            .byte $00,$00,$00,$00,$FF
$E3A0  50 44     BVC L_BRS_($E3E6)_($E3A0) JAM
$E3A2  11 45     ORA ($45),Y
$E3A4  11 04     ORA ($04),Y
$E3A6  11 45     ORA ($45),Y
$E3A8  19 56 59  ORA $5956,Y
$E3AB  66 59     ROR $59 
$E3AD  56 59     LSR $59,X 
$E3AF  66 AC     ROR $AC 
$E3B1            .byte $BB
$E3B2  AE 6B AE  LDX $AE6B 
$E3B5            .byte $BB
$E3B6  AE 6B 0F  LDX $0F6B 
$E3B9            .byte $B3,$FC,$FF,$FF,$BF,$FF,$FF
//------------------------------
L_BRS_($E3C1)_($E3F0) BAD
//------------------------------
$E3C0  45 11     EOR $11 
$E3C2  05 15     ORA $15
$E3C4  45 11     EOR $11 
$E3C6  05 15     ORA $15
$E3C8  66 5A     ROR $5A 
//------------------------------
L_BRS_($E3CB)_($E409) BAD
//------------------------------
$E3CA  66 99     ROR $99 
$E3CC  66 5A     ROR $5A 
$E3CE  66 99     ROR $99 
$E3D0            .byte $BB
$E3D1  EE BB AF  INC $AFBB 
$E3D4            .byte $BB
$E3D5  EE BB AF  INC $AFBB 
$E3D8  FD FC FC  SBC $FCFC,X 
$E3DB            .byte $FC
//------------------------------
L_BRS_($E3DD)_($E41B) BAD
//------------------------------
$E3DC  FD FC FC  SBC $FCFC,X 
$E3DF            .byte $FC
$E3E0  C0 CC     CPY #$CC
$E3E2  CC CC CF  CPY $CFCC 
//------------------------------
L_BRS_($E3E6)_($E3A0) JAM
//------------------------------
$E3E5            .byte $CF,$FF,$00,$F3
$E3E9  CC F3 FF  CPY $FFF3                          // Return I/O Base Address
$E3EC  C0 F3     CPY #$F3
$E3EE            .byte $FF,$00
$E3F0  F0 CF     BEQ L_BRS_($E3C1)_($E3F0) BAD
$E3F2  CC CC CF  CPY $CFCC 
//------------------------------
L_BRS_($E3F6)_($E3F5) BAD
//------------------------------
$E3F5  F0 FF     BEQ L_BRS_($E3F6)_($E3F5) BAD
$E3F7            .byte $00,$03,$FC
$E3FA  CC CC FC  CPY $FCCC 
$E3FD            .byte $03,$FF,$00,$CF,$F3,$CF,$F3,$CF
$E405            .byte $F3,$FF,$00,$0C
$E409  F0 C0     BEQ L_BRS_($E3CB)_($E409) BAD
$E40B  C0 F0     CPY #$F0
$E40D            .byte $0C,$FF,$00,$C3,$3F,$0F,$0F,$3F
$E415            .byte $C3,$FF,$00,$0F,$0F,$FC
$E41B  F0 C0     BEQ L_BRS_($E3DD)_($E41B) BAD
$E41D            .byte $3C,$FF,$00,$CF,$03,$0F,$0F,$3F
$E425  CC FF 00  CPY $00FF 
$E428  CC CC CC  CPY $CCCC 
$E42B  CC 00 CC  CPY $CC00 
$E42E            .byte $FF,$00,$F3,$FC,$FC,$FC,$3C,$CF
$E436            .byte $FF,$00,$F3
$E439  C0 FF     CPY #$FF
$E43B            .byte $FF,$03,$FC,$FF,$00,$C3,$C3,$C3
$E443            .byte $C3,$CF,$CF,$FF,$00,$3F,$03,$00
//------------------------------
L_BRS_($E44C)_($E47B) BAD
//------------------------------
$E44B  CC 00 CC  CPY $CC00 
$E44E            .byte $FF,$00,$F3
$E451  C0 F3     CPY #$F3
$E453            .byte $F3,$33,$F3,$FF,$00,$F3
$E459  CC F3 C0  CPY $C0F3 
$E45C            .byte $F3,$F3,$FF,$00
$E460  CC CC FF  CPY $FFCC                          // Restore I/O Vector
$E463  C0 C0     CPY #$C0
//------------------------------
L_BRS_($E466)_($E465) BAD
//------------------------------
$E465  F0 FF     BEQ L_BRS_($E466)_($E465) BAD
$E467            .byte $00,$CF,$CF,$FF,$0F,$0C,$3C,$FF
$E46F            .byte $00,$CF,$CF,$33,$33
$E474  CC 00 FF  CPY $FF00 
$E477            .byte $00
$E478  CC F3 FF  CPY $FFF3                          // Return I/O Base Address
$E47B  F0 CF     BEQ L_BRS_($E44C)_($E47B) BAD
$E47D  C0 FF     CPY #$FF
$E47F            .byte $00,$CF,$3C,$FF,$0F,$FC,$0C,$FF
$E487            .byte $00,$3C,$0C,$3C
$E48B  F0 00     BEQ L_BRS_($E48D)_($E48B) JAM
//------------------------------
L_BRS_($E48D)_($E48B) JAM
//------------------------------
$E48D            .byte $00,$FF,$00,$F3
$E491  C0 C0     CPY #$C0
$E493  C0 F3     CPY #$F3
$E495            .byte $F3,$FF,$00,$FC,$F3
$E49A  CC CC F3  CPY $F3CC 
$E49D            .byte $FC,$FF,$00,$0F,$33,$0C,$0C,$33
$E4A5            .byte $0F,$FF,$00
$E4A8  C0 CF     CPY #$CF
$E4AA            .byte $C3,$FF
$E4AC  C0 F0     CPY #$F0
$E4AE            .byte $FF,$00,$0F,$CF,$0C,$FC,$0F,$3F
$E4B6            .byte $FF,$00,$3C,$3C,$CF,$CF,$3F,$3C
$E4BE            .byte $FF,$00,$F3
$E4C1  CC CC 3C  CPY $3CCC 
$E4C4            .byte $3F,$3C,$FF,$00,$F3
$E4C9  CC FC F3  CPY $F3FC 
$E4CC  30 30     BMI L_BRS_($E4FE)_($E4CC) JAM
$E4CE            .byte $FF,$00,$C3,$F3,$FF,$0F,$03,$03
$E4D6            .byte $FF,$00,$CF,$03,$CF,$CF,$CF,$33
$E4DE            .byte $FF,$00
$E4E0  11 04     ORA ($04),Y
$E4E2  11 45     ORA ($45),Y
$E4E4  11 04     ORA ($04),Y
$E4E6  11 45     ORA ($45),Y
$E4E8  59 56 59  EOR $5956,Y 
$E4EB  66 59     ROR $59 
$E4ED  56 59     LSR $59,X 
$E4EF  66 AE     ROR $AE 
$E4F1            .byte $BB
$E4F2  AE 6B AE  LDX $AE6B 
$E4F5            .byte $BB
$E4F6  AE 6B FF  LDX $FF6B 
//------------------------------
L_BRS_($E4FE)_($E4CC) JAM
//------------------------------
$E4F9            .byte $BF,$FF,$FF,$FF,$BF,$FF,$FF,$00
$E501            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E509            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E511            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E519            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E521            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E529            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E531            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E539            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E541            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E549            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E551            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E559            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E561            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E569            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E571            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E579            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E581            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E589            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E591            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E599            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E5F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E601            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E609            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E611            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E619            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E621            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E629            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E631            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E639            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E641            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E649            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E651            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E659            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E661            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E669            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E671            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E679            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E681            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E689            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E691            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E699            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E6F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E701            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E709            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E711            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E719            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E721            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E729            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E731            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E739            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E741            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E749            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E751            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E759            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E761            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E769            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E771            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E779            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E781            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E789            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E791            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E799            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E7F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E801            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E809            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E811            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E819            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E821            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E829            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E831            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E839            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E841            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E849            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E851            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E859            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E861            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E869            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E871            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E879            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E881            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E889            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E891            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E899            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E8F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E901            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E909            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E911            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E919            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E921            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E929            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E931            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E939            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E941            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E949            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E951            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E959            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E961            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E969            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E971            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E979            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E981            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E989            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E991            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E999            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$E9F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA01            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA19            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA21            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA29            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA31            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA39            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA41            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA49            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA51            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA59            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA61            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA69            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA71            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA79            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA81            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA89            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EA99            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAA9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAB1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAC1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAC9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAD1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAD9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAE9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EAF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB01            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB19            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB21            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB29            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB31            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB39            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB41            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB49            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB51            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB59            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB61            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB69            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB71            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB79            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB81            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB89            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EB99            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBA9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBB1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBC1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBC9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBD1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBD9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBE9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EBF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC01            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC19            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC21            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC29            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC31            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC39            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC41            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC49            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC51            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC59            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC61            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC69            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC71            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC79            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC81            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC89            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EC99            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECA9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECB1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECC1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECC9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECD1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECD9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECE9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ECF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED01            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED19            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED21            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED29            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED31            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED39            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED41            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED49            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED51            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED59            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED61            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED69            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED71            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED79            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED81            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED89            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$ED99            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDA9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDB1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDC1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDC9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDD1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDD9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDE9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EDF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE01            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE19            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE21            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE29            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE31            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE39            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE41            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE49            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE51            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE59            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE61            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE69            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE71            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE79            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE81            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE89            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EE99            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEA9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEB1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEC1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEC9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EED1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EED9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEE9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EEF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF01            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF19            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF21            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF29            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF31            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF39            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF41            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF49            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF51            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF59            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF61            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF69            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF71            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF79            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF81            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF89            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF91            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EF99            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFA9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFB1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFC1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFC9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFD1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFD9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFE9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$EFF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F001            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F009            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F011            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F019            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F021            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F029            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F031            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F039            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F041            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F049            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F051            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F059            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($F065)_($CAA7) JAM
//------------------------------
$F061            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F069            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F071            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F079            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F081            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F089            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F091            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F099            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F0F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F101            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F109            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F111            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F119            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F121            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F129            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F131            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F139            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F141            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F149            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F151            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F159            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F161            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F169            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F171            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F179            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F181            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F189            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F191            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F199            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JMP_($F1CA)_($7DDB) JAM
//------------------------------
$F1C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F1F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F201            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F209            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F211            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F219            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F221            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F229            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F231            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F239            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F241            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F249            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F251            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F259            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F261            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F269            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F271            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F279            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F281            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F289            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F291            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F299            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F2F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F301            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F309            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F311            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F319            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F321            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F329            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F331            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F339            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F341            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F349            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F351            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F359            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F361            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F369            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F371            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F379            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F381            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F389            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F391            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F399            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F3F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F401            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F409            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F411            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F419            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F421            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F429            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F431            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F439            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F441            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F449            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F451            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F459            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F461            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F469            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F471            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F479            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F481            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F489            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F491            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F499            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4A1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4A9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4B1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4B9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4C1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4C9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4D1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4D9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4E1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4E9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4F1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F4F9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F501            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F509            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F511            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F519            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F521            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F529            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F531            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F539            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F541            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F549            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F551            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F559            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F561  55 51     EOR $51,X 
$F563            .byte $44
$F564  51 40     EOR ($40),Y 
$F566  51 51     EOR ($51),Y 
$F568            .byte $00,$FF,$00,$00,$00,$00,$00,$00
$F570            .byte $00,$FF,$00,$00,$00,$00,$00,$00
$F578            .byte $00
$F579  55 54     EOR $54,X 
$F57B  50 54     BVC L_BRS_($F5D1)_($F57B) JAM
$F57D  55 50     EOR $50,X 
$F57F            .byte $54,$00
$F581  55 15     EOR $15,X 
$F583  05 15     ORA $15
$F585  55 05     EOR $05,X 
$F587  15 00     ORA $00,X
$F589            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F591            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F599  D5 15     CMP $15,X 
$F59B  45 15     EOR $15 
$F59D  45 15     EOR $15 
$F59F  45 00     EOR $00 
$F5A1            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5A9            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5B1            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5B9            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5C1            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5C9            .byte $FF,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($F5D1)_($F57B) JAM
//------------------------------
$F5D1            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5D9            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5E1            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5E9            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5F1            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F5F9            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F601            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F609            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F611            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F619            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F621  55 51     EOR $51,X 
$F623  40        RTI 
//------------------------------
$F624  51 51     EOR ($51),Y 
$F626  51 51     EOR ($51),Y 
$F628            .byte $00,$FF,$00,$00,$00,$00,$00,$00
$F630            .byte $00,$FF,$00,$00,$00,$00,$00,$00
$F638            .byte $00,$FF,$00,$00,$00,$00,$00,$00
$F640            .byte $00,$FF,$00,$00,$00,$00,$00,$00
$F648            .byte $00
$F649  55 40     EOR $40,X 
$F64B            .byte $44,$44,$44
$F64E  45 45     EOR $45 
$F650            .byte $00
$F651  55 51     EOR $51,X 
$F653  55 44     EOR $44,X 
$F655            .byte $54
$F656  45 54     EOR $54 
$F658            .byte $00
$F659  55 15     EOR $15,X 
$F65B  51 15     EOR ($15),Y 
$F65D  11 55     ORA ($55),Y
$F65F  45 00     EOR $00 
$F661            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F669            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F671            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F679            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F681            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F689            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F691            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F699            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F6A1            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F6A9            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F6B1            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F6B9            .byte $00,$00,$02,$02,$02
$F6BE  16 16     ASL $16,X 
$F6C0            .byte $FF,$00,$00
$F6C3  AA        TAX 
$F6C4  AA        TAX 
$F6C5  AA        TAX 
$F6C6  AA        TAX 
$F6C7  AA        TAX 
$F6C8            .byte $FF,$00,$00
$F6CB  AA        TAX 
$F6CC  AA        TAX 
$F6CD  AA        TAX 
$F6CE  AA        TAX 
//------------------------------
L_BRS_($F6CF)_($F70D) OK
//------------------------------
$F6CF  AA        TAX 
$F6D0            .byte $FF,$00,$00
$F6D3  A0 A0     LDY #$A0
$F6D5  A0 A5     LDY #$A5
$F6D7  A5 FF     LDA $FF 
$F6D9            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F6E1            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F6E9            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F6F1            .byte $00,$00
$F6F3  30 3C     BMI L_BRS_($F731)_($F6F3) JAM
$F6F5            .byte $0F,$03,$03,$FF,$00,$00,$00,$00
$F6FD            .byte $00,$00,$FF,$FF,$00,$00,$00,$00
$F705            .byte $00,$00,$FF,$FF,$00,$00,$0C,$3C
$F70D  F0 C0     BEQ L_BRS_($F6CF)_($F70D) OK
$F70F  C0 FF     CPY #$FF
$F711            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F719            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F721            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F729            .byte $00,$00,$00,$00,$00,$00,$00,$FF
//------------------------------
L_BRS_($F731)_($F6F3) JAM
//------------------------------
$F731            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F739            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F741            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F749            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F751            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F759            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F761            .byte $00,$00,$00,$00,$00,$00,$00,$FF
$F769            .byte $00,$00,$00,$00,$00
$F76E  01 01     ORA ($01,X)
$F770            .byte $FF,$00
$F772  05 15     ORA $15
$F774  50 40     BVC L_BRS_($F7B6)_($F774) JAM
$F776  40        RTI 
//------------------------------
$F777            .byte $00,$FF,$00
$F77A  40        RTI 
//------------------------------
$F77B  50 14     BVC L_BRS_($F791)_($F77B) JAM
$F77D            .byte $04
$F77E  05 01     ORA $01
$F780            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F788            .byte $FF,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($F791)_($F77B) JAM
//------------------------------
$F790            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F798            .byte $FF,$00,$00,$00,$00,$00,$00,$00
$F7A0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7A8            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($F7B6)_($F774) JAM
//------------------------------
$F7B0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7B8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7C0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7C8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7D0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7E0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7E8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F7F8            .byte $2B
$F7F9  28        PLP 
$F7FA  28        PLP 
$F7FB  28        PLP 
$F7FC  28        PLP 
$F7FD  2A        ROL A 
$F7FE  2A        ROL A 
$F7FF  28        PLP 
$F800            .byte $FF,$00,$00
$F803  2A        ROL A 
$F804  A0 80     LDY #$80
$F806  2A        ROL A 
$F807  AA        TAX 
$F808            .byte $FF,$00,$00
$F80B  AA        TAX 
$F80C            .byte $02,$00
$F80E  AA        TAX 
$F80F  AA        TAX 
$F810            .byte $FA
$F811  0A        ASL A 
$F812  0A        ASL A 
$F813  0A        ASL A 
$F814  8A        TXA 
$F815  AA        TAX 
$F816  2A        ROL A 
$F817  8A        TXA 
$F818            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F820            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F828            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F830  01 05     ORA ($05,X)
//------------------------------
L_JSR_($F832)_($CA7F) JAM
//------------------------------
$F832            .byte $14
$F833  10 50     BPL L_BRS_($F885)_($F833) OK
$F835  40        RTI 
//------------------------------
$F836  40        RTI 
//------------------------------
$F837  40        RTI 
//------------------------------
$F838            .byte $80
$F839  AA        TAX 
$F83A            .byte $00,$00,$00,$00,$00,$00,$03,$FF
$F842            .byte $00,$00,$00,$00,$00,$00
$F848  40        RTI 
//------------------------------
$F849  50 14     BVC L_BRS_($F85F)_($F849) JAM
$F84B            .byte $04
$F84C  05 01     ORA $01
$F84E  01 01     ORA ($01,X)
$F850            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($F85F)_($F849) JAM
//------------------------------
$F858            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F860            .byte $00,$00
$F862  01 01     ORA ($01,X)
$F864  05 05     ORA $05
$F866  05 15     ORA $15
$F868            .byte $00
$F869  55 55     EOR $55,X 
$F86B  55 55     EOR $55,X 
$F86D  55 55     EOR $55,X 
$F86F  55 00     EOR $00,X 
$F871            .byte $00
$F872  40        RTI 
//------------------------------
$F873  50 50     BVC L_BRS_($F8C5)_($F873) JAM
$F875            .byte $54,$54
$F877  55 00     EOR $00,X 
$F879            .byte $00,$00
$F87B  01 01     ORA ($01,X)
$F87D  05 05     ORA $05
$F87F  15 00     ORA $00,X
$F881  15 55     ORA $55,X
$F883  55 55     EOR $55,X 
//------------------------------
L_BRS_($F885)_($F833) OK
//------------------------------
$F885  55 55     EOR $55,X 
$F887  55 00     EOR $00,X 
$F889  40        RTI 
//------------------------------
$F88A  50 50     BVC L_BRS_($F8DC)_($F88A) JAM
$F88C            .byte $54,$54,$54
$F88F  55 00     EOR $00,X 
$F891            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F899            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F8A1            .byte $00,$00,$00,$00,$00,$00,$00,$03
$F8A9            .byte $03,$03,$00,$00,$00,$00,$03,$00
$F8B1            .byte $03,$CF,$CF,$FF,$3F,$0F,$FF,$03
$F8B9            .byte $03,$CF
$F8BB  CC FC F0  CPY $F0FC 
$F8BE  C0 FF     CPY #$FF
//------------------------------
L_BRS_($F8C5)_($F873) JAM
//------------------------------
$F8C0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F8C8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F8D0            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($F8DC)_($F88A) JAM
//------------------------------
$F8D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F8E0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F8E8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F8F0            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F8F8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F900            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F908            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F910            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F918            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F920            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F928            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F930            .byte $00,$00,$00,$00,$03,$03,$03,$03
$F938            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F940            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F948            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F950            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F958            .byte $00,$00
$F95A  C0 C0     CPY #$C0
$F95C  30 30     BMI L_BRS_($F98E)_($F95C) JAM
$F95E  30 30     BMI L_BRS_($F990)_($F95E) OK
$F960            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F968            .byte $03,$03,$03,$03,$03,$03,$03,$03
$F970            .byte $80,$00,$00,$00,$00,$00,$00,$00
$F978            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F980            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($F98E)_($F95C) JAM
//------------------------------
$F988            .byte $03,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($F990)_($F95E) OK
//------------------------------
$F990  C0 C0     CPY #$C0
$F992  C0 C0     CPY #$C0
$F994  C0 C0     CPY #$C0
$F996  C0 C0     CPY #$C0
$F998            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F9A0  15 15     ORA $15,X
$F9A2  55 55     EOR $55,X 
$F9A4  55 55     EOR $55,X 
//------------------------------
L_BRS_($F9A7)_($FA01) BAD
//------------------------------
$F9A6  55 55     EOR $55,X 
$F9A8  55 55     EOR $55,X 
$F9AA  55 55     EOR $55,X 
$F9AC  55 55     EOR $55,X 
$F9AE  55 55     EOR $55,X 
$F9B0  55 55     EOR $55,X 
$F9B2  55 55     EOR $55,X 
$F9B4  55 55     EOR $55,X 
$F9B6  55 55     EOR $55,X 
$F9B8  15 55     ORA $55,X
$F9BA  55 55     EOR $55,X 
$F9BC  55 55     EOR $55,X 
$F9BE  55 55     EOR $55,X 
$F9C0  55 55     EOR $55,X 
$F9C2  55 55     EOR $55,X 
$F9C4  55 55     EOR $55,X 
$F9C6  55 55     EOR $55,X 
$F9C8  55 55     EOR $55,X 
$F9CA  55 55     EOR $55,X 
$F9CC  55 55     EOR $55,X 
$F9CE  55 55     EOR $55,X 
$F9D0            .byte $00,$00
$F9D2  40        RTI 
//------------------------------
$F9D3  40        RTI 
//------------------------------
$F9D4  40        RTI 
//------------------------------
$F9D5  40        RTI 
//------------------------------
$F9D6  40        RTI 
//------------------------------
$F9D7  40        RTI 
//------------------------------
$F9D8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$F9E0            .byte $00,$00,$00,$00
$F9E4  01 01     ORA ($01,X)
$F9E6  06 06     ASL $06 
//------------------------------
L_BRS_($F9E8)_($F9F3) OK
//------------------------------
$F9E8  0A        ASL A 
$F9E9  25 95     AND $95
$F9EB  9A        TXS 
$F9EC            .byte $5A
$F9ED  6A        ROR A 
$F9EE  6A        ROR A 
$F9EF  AA        TAX 
$F9F0  55 55     EOR $55,X 
$F9F2            .byte $FF
$F9F3  F0 F3     BEQ L_BRS_($F9E8)_($F9F3) OK
$F9F5            .byte $F3,$F3,$F3
$F9F8  56 55     LSR $55,X 
$F9FA  A9 2A     LDA #$2A
$F9FC  2A        ROL A 
$F9FD  2A        ROL A 
$F9FE  2A        ROL A 
$F9FF  2A        ROL A 
$FA00  40        RTI 
//------------------------------
$FA01  90 A4     BCC L_BRS_($F9A7)_($FA01) BAD
$FA03            .byte $64
$FA04  69 59     ADC #$59
$FA06            .byte $5A
$FA07  56 00     LSR $00,X 
$FA09            .byte $00,$00,$00,$00,$00
$FA0E  40        RTI 
//------------------------------
$FA0F  40        RTI 
//------------------------------
$FA10            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA18            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA20            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA28            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($FA33)_($CA2F) JAM
//------------------------------
$FA30            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA38            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA40            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA48            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA50            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA58            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA60            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA68            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA70            .byte $0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C
$FA78            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA80            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA88            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA90            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FA98  CC CC CC  CPY $CCCC 
$FA9B            .byte $CF,$CF,$CF,$CF,$CF,$00,$00,$00
$FAA3            .byte $00,$00,$00,$00,$00,$03,$03,$03
$FAAB            .byte $03,$03,$03,$03,$03,$00,$00,$00
$FAB3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FABB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FAC3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FACB            .byte $00,$00,$00,$00,$00
$FAD0  C0 C0     CPY #$C0
$FAD2  C0 C0     CPY #$C0
$FAD4  C0 C0     CPY #$C0
$FAD6  C0 C0     CPY #$C0
//------------------------------
L_BRS_($FADA)_($FB48) JAM
L_BRS_($FADC)_($FB4A) JAM
//------------------------------
$FAD8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FAE0  55 55     EOR $55,X 
$FAE2  55 15     EOR $15,X 
$FAE4  15 15     ORA $15,X
$FAE6  15 05     ORA $05,X
$FAE8  55 55     EOR $55,X 
$FAEA  55 55     EOR $55,X 
$FAEC  55 55     EOR $55,X 
$FAEE  55 55     EOR $55,X 
$FAF0  55 55     EOR $55,X 
$FAF2  55 55     EOR $55,X 
$FAF4  55 55     EOR $55,X 
$FAF6  55 55     EOR $55,X 
$FAF8  55 55     EOR $55,X 
$FAFA  55 55     EOR $55,X 
$FAFC  55 55     EOR $55,X 
$FAFE  55 55     EOR $55,X 
$FB00  55 55     EOR $55,X 
$FB02  55 55     EOR $55,X 
$FB04  55 55     EOR $55,X 
$FB06  55 55     EOR $55,X 
$FB08  55 55     EOR $55,X 
$FB0A  55 55     EOR $55,X 
$FB0C  55 55     EOR $55,X 
$FB0E  55 54     EOR $54,X 
$FB10  40        RTI 
//------------------------------
$FB11  40        RTI 
//------------------------------
$FB12  40        RTI 
//------------------------------
$FB13            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FB1B            .byte $00,$00,$00,$00,$00,$1A
$FB21  19 19 19  ORA $1919,Y
$FB24  69 65     ADC #$65
$FB26  65 65     ADC $65 
$FB28            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$FB30            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$FB38            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$FB40  FE FF FF  INC $FFFF,X 
$FB43            .byte $FF,$FF,$FF,$FF,$FF
$FB48  90 90     BCC L_BRS_($FADA)_($FB48) JAM
$FB4A  90 90     BCC L_BRS_($FADC)_($FB4A) JAM
$FB4C  A4 64     LDY $64 
$FB4E            .byte $64,$64,$00,$00,$00,$00,$00,$00
$FB56            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FB5E            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($FB6A)_($FB9C) JAM
//------------------------------
$FB66            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FB6E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FB76            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FB7E            .byte $00,$00
$FB80  45 11     EOR $11 
$FB82  05 15     ORA $15
$FB84  45 11     EOR $11 
$FB86  40        RTI 
//------------------------------
$FB87  55 66     EOR $66,X 
$FB89            .byte $5A
$FB8A  66 99     ROR $99 
$FB8C  66 5A     ROR $5A 
$FB8E  66 00     ROR $00 
$FB90            .byte $BB
$FB91  EE BB AF  INC $AFBB 
$FB94            .byte $BB
$FB95  EE B0 0F  INC $0FB0 
$FB98  FD FC FC  SBC $FCFC,X 
$FB9B            .byte $FC
$FB9C  F0 CC     BEQ L_BRS_($FB6A)_($FB9C) JAM
$FB9E            .byte $3C
$FB9F  F0 00     BEQ L_BRS_($FBA1)_($FB9F) JAM
//------------------------------
L_BRS_($FBA1)_($FB9F) JAM
//------------------------------
$FBA1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FBA9            .byte $00,$00,$00,$00,$00,$00,$00,$0C
$FBB1            .byte $0C,$0C,$03,$03,$03,$03,$00,$00
$FBB9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FBC1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FBC9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FBD1            .byte $00,$00,$00,$00,$00,$00,$00
$FBD8  CC CC CC  CPY $CCCC 
$FBDB  30 30     BMI L_BRS_($FC0D)_($FBDB) JAM
$FBDD  70 70     BVS L_BRS_($FC4F)_($FBDD) JAM
$FBDF  C0 00     CPY #$00
$FBE1            .byte $00,$00,$00,$00,$00,$00,$00,$03
$FBE9            .byte $03,$03,$03,$03,$03,$03,$03,$00
$FBF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FBF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FC01            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($FC0D)_($FBDB) JAM
//------------------------------
$FC09            .byte $00,$00,$00,$00,$00,$00,$00
$FC10  C0 C0     CPY #$C0
$FC12  C0 C0     CPY #$C0
$FC14  C0 C0     CPY #$C0
$FC16  C0 C0     CPY #$C0
$FC18            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FC20  05 05     ORA $05
$FC22  01 01     ORA ($01,X)
$FC24            .byte $00,$00,$00,$00
$FC28  55 55     EOR $55,X 
$FC2A  55 55     EOR $55,X 
$FC2C  55 55     EOR $55,X 
$FC2E  55 15     EOR $15,X 
$FC30  55 55     EOR $55,X 
$FC32  55 55     EOR $55,X 
$FC34  55 55     EOR $55,X 
$FC36  55 55     EOR $55,X 
$FC38  55 55     EOR $55,X 
$FC3A  55 55     EOR $55,X 
$FC3C  55 55     EOR $55,X 
$FC3E  55 55     EOR $55,X 
$FC40  55 55     EOR $55,X 
$FC42  55 55     EOR $55,X 
$FC44  55 55     EOR $55,X 
$FC46  55 55     EOR $55,X 
$FC48            .byte $54,$54
$FC4A  50 50     BVC L_BRS_($FC9C)_($FC4A) JAM
$FC4C  40        RTI 
//------------------------------
$FC4D  40        RTI 
//------------------------------
$FC4E  40        RTI 
//------------------------------
L_BRS_($FC4F)_($FBDD) JAM
//------------------------------
$FC4F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FC57            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FC5F            .byte $00
$FC60  9A        TXS 
$FC61  98        TYA 
$FC62  98        TYA 
$FC63  98        TYA 
$FC64  98        TYA 
$FC65  98        TYA 
$FC66  9A        TXS 
$FC67  9A        TXS 
$FC68            .byte $FF,$CF,$CF,$CF,$0F,$CF,$FF,$FF
$FC70            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$FC78            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$FC80  C0 CF     CPY #$CF
$FC82  C0 CF     CPY #$CF
$FC84  C0 FF     CPY #$FF
$FC86            .byte $FF,$FF,$64,$64,$64,$64,$64,$64
$FC8E            .byte $64,$64,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($FC9C)_($FC4A) JAM
//------------------------------
$FC96            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FC9E            .byte $00,$00
$FCA0  11 04     ORA ($04),Y
$FCA2  11 45     ORA ($45),Y
$FCA4  11 44     ORA ($44),Y
$FCA6  50 15     BVC L_BRS_($FCBD)_($FCA6) JAM
$FCA8  59 56 59  EOR $5956,Y 
$FCAB  66 59     ROR $59 
$FCAD  56 19     LSR $19,X 
$FCAF  40        RTI 
//------------------------------
$FCB0  AE BB AE  LDX $AEBB 
$FCB3            .byte $6B
$FCB4  AE BB AC  LDX $ACBB 
//------------------------------
L_BRS_($FCBD)_($FCA6) JAM
//------------------------------
$FCB7            .byte $03,$FF,$BF,$FF,$FF,$FC,$B3,$0F
$FCBF            .byte $FC
$FCC0  15 01     ORA $01,X
$FCC2            .byte $04
$FCC3  05 05     ORA $05
$FCC5  05 15     ORA $15
$FCC7  15 6A     ORA $6A,X
$FCC9  6A        ROR A 
$FCCA            .byte $00
$FCCB  9A        TXS 
$FCCC  6A        ROR A 
$FCCD  9A        TXS 
$FCCE  66 9A     ROR $9A 
$FCD0            .byte $BF
$FCD1  BC 03 BB  LDY $BB03,X 
$FCD4  AE BB EE  LDX $EEBB                          // RS232 Send
$FCD7            .byte $BB
$FCD8  C0 00     CPY #$00
$FCDA            .byte $00,$00,$00
$FCDD  C0 C0     CPY #$C0
$FCDF  F0 00     BEQ L_BRS_($FCE1)_($FCDF) JAM
//------------------------------
L_BRS_($FCE1)_($FCDF) JAM
//------------------------------
$FCE1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FCE9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FCF1            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FCF9            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD01            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD19            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD21            .byte $00,$00,$00,$00,$00,$00,$00,$03
$FD29            .byte $03,$03,$03,$03,$03,$03,$03,$00
$FD31            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD39            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD41            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD49            .byte $00,$00,$00,$00,$00,$00,$00
$FD50  C0 C0     CPY #$C0
$FD52  C0 C0     CPY #$C0
$FD54  C0 C0     CPY #$C0
$FD56  C0 C0     CPY #$C0
//------------------------------
L_BRS_($FD5E)_($FDCC) JAM
//------------------------------
$FD58            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD60            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD68  15 05     ORA $05,X
$FD6A  05 01     ORA $01
$FD6C  01 00     ORA ($00,X)
$FD6E            .byte $00,$00
$FD70  55 55     EOR $55,X 
$FD72  55 55     EOR $55,X 
$FD74  55 55     EOR $55,X 
$FD76  55 15     EOR $15,X 
$FD78  55 55     EOR $55,X 
$FD7A  55 55     EOR $55,X 
$FD7C  55 55     EOR $55,X 
$FD7E  55 55     EOR $55,X 
$FD80  55 54     EOR $54,X 
$FD82            .byte $54
$FD83  50 50     BVC L_BRS_($FDD5)_($FD83) JAM
$FD85  40        RTI 
//------------------------------
$FD86  40        RTI 
//------------------------------
$FD87            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD8F            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD97            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FD9F            .byte $00,$EF,$EF,$EB,$3B,$3B,$3B,$3A
$FDA7  0E FF FF  ASL $FFFF 
//------------------------------
L_BRS_($FDAB)_($FDB6) JAM
L_BRS_($FDAF)_($FDFD) JAM
//------------------------------
$FDAA            .byte $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
$FDB2            .byte $FF,$FF,$FF,$FF
$FDB6  F0 F3     BEQ L_BRS_($FDAB)_($FDB6) JAM
$FDB8            .byte $FF,$FF,$FF,$FF,$FF,$FF,$3F,$FF
$FDC0            .byte $FF,$FF,$FF,$FF,$FF,$FF
$FDC6  FE FE 64  INC $64FE,X 
$FDC9            .byte $64
$FDCA  A4 90     LDY $90 
$FDCC  90 90     BCC L_BRS_($FD5E)_($FDCC) JAM
$FDCE  90 40     BCC L_BRS_($FE10)_($FDCE) OK
//------------------------------
L_BRS_($FDD5)_($FD83) JAM
//------------------------------
$FDD0            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($FDDE)_($FE1C) JAM
//------------------------------
$FDD8            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FDE0  05 00     ORA $00
$FDE2  01 01     ORA ($01,X)
$FDE4  01 05     ORA ($05,X)
$FDE6  05 15     ORA $15
$FDE8            .byte $5A,$5A,$00
$FDEB  66 5A     ROR $5A 
$FDED  66 59     ROR $59 
$FDEF  66 AF     ROR $AF 
$FDF1            .byte $AF,$00
$FDF3  AE AB AE  LDX $AEAB 
$FDF6            .byte $BB
$FDF7  AE F0 00  LDX $00F0 
$FDFA  C0 C0     CPY #$C0
$FDFC            .byte $80
$FDFD  F0 B0     BEQ L_BRS_($FDAF)_($FDFD) JAM
$FDFF            .byte $FC
$FE00  56 45     LSR $45,X 
$FE02  50 59     BVC L_BRS_($FE5D)_($FE02) JAM
$FE04  16 09     ASL $09,X 
$FE06            .byte $02,$00
$FE08  6A        ROR A 
$FE09  9A        TXS 
$FE0A  6A        ROR A 
$FE0B            .byte $00
$FE0C  AA        TAX 
$FE0D  AA        TAX 
$FE0E  6A        ROR A 
$FE0F            .byte $00
//------------------------------
L_BRS_($FE10)_($FDCE) OK
//------------------------------
$FE10  AE BB EC  LDX $ECBB 
$FE13            .byte $03
$FE14  AE BB EC  LDX $ECBB 
$FE17            .byte $00,$FC
$FE19  CC 3C FC  CPY $FC3C 
$FE1C  F0 C0     BEQ L_BRS_($FDDE)_($FE1C) JAM
$FE1E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FE26            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FE2E            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FE36            .byte $00,$00
$FE38  28        PLP 
$FE39  28        PLP 
$FE3A  2A        ROL A 
$FE3B  29 29     AND #$29
$FE3D  01 01     ORA ($01,X)
$FE3F  01 00     ORA ($00,X)
$FE41            .byte $00
$FE42  AA        TAX 
$FE43  55 55     EOR $55,X 
$FE45  55 55     EOR $55,X 
$FE47  55 00     EOR $00,X 
$FE49            .byte $00
$FE4A  AA        TAX 
$FE4B  55 55     EOR $55,X 
$FE4D  55 55     EOR $55,X 
$FE4F  55 0A     EOR $0A,X 
$FE51  0A        ASL A 
$FE52  AA        TAX 
$FE53            .byte $5A,$5A
$FE55  50 50     BVC L_BRS_($FEA7)_($FE55) JAM
$FE57  50 00     BVC L_BRS_($FE59)_($FE57) JAM
//------------------------------
L_BRS_($FE59)_($FE57) JAM
L_BRS_($FE5D)_($FE02) JAM
//------------------------------
$FE59            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FE61            .byte $00,$00,$00,$00,$00,$00,$00,$03
$FE69            .byte $03,$03,$03,$03,$00,$00,$00,$FF
$FE71            .byte $FF,$FF,$FF
$FE74  55 51     EOR $51,X 
$FE76  15 00     ORA $00,X
$FE78            .byte $FF,$FF,$FF,$FF
$FE7C  AA        TAX 
$FE7D            .byte $22
$FE7E  AA        TAX 
$FE7F            .byte $00,$FF,$FF,$FF,$FF
$FE84  55 44     EOR $44,X 
$FE86  55 00     EOR $00,X 
$FE88            .byte $FF,$FF,$FF,$FF
$FE8C  55 45     EOR $45,X 
$FE8E            .byte $54,$00
$FE90  C0 C0     CPY #$C0
$FE92  C0 C0     CPY #$C0
$FE94  C0 00     CPY #$00
$FE96            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FE9E            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($FEA7)_($FE55) JAM
//------------------------------
$FEA6            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FEAE            .byte $00,$00
$FEB0  15 05     ORA $05,X
$FEB2  05 01     ORA $01
$FEB4  01 00     ORA ($00,X)
$FEB6            .byte $00,$00
$FEB8  55 54     EOR $54,X 
$FEBA            .byte $54
$FEBB  50 50     BVC L_BRS_($FF0D)_($FEBB) JAM
$FEBD  40        RTI 
//------------------------------
$FEBE  40        RTI 
//------------------------------
$FEBF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FEC7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FECF            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FED7            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FEDF            .byte $00
$FEE0  06 01     ASL $01 
$FEE2  01 00     ORA ($00,X)
$FEE4            .byte $00,$00,$00,$00
$FEE8  95 95     STA $95,X 
$FEEA  A5 65     LDA $65 
$FEEC  6A        ROR A 
$FEED            .byte $1A
$FEEE  05 00     ORA $00
$FEF0  A0 AA     LDY #$AA
$FEF2  AA        TAX 
$FEF3  A0 AA     LDY #$AA
$FEF5  55 55     EOR $55,X 
$FEF7  AA        TAX 
$FEF8  2A        ROL A 
$FEF9  2A        ROL A 
$FEFA  2A        ROL A 
$FEFB  2A        ROL A 
$FEFC  A9 55     LDA #$55
$FEFE  56 A8     LSR $A8,X 
$FF00            .byte $5A
$FF01  59 69 64  EOR $6469,Y 
$FF04  A4 90     LDY $90 
$FF06  40        RTI 
//------------------------------
$FF07            .byte $00
$FF08  40        RTI 
//------------------------------
L_BRS_($FF0D)_($FEBB) JAM
//------------------------------
$FF09            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF11            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF19            .byte $00,$00,$00,$00,$00,$00,$00
$FF20  55 45     EOR $45,X 
$FF22  50 56     BVC L_BRS_($FF7A)_($FF22) JAM
$FF24  15 06     ORA $06,X
$FF26            .byte $00,$00
$FF28  9A        TXS 
$FF29  66 9A     ROR $9A 
$FF2B            .byte $00
$FF2C  AA        TAX 
$FF2D  6A        ROR A 
$FF2E  9A        TXS 
$FF2F            .byte $00,$AB
$FF31  AE BB 00  LDX $00BB 
$FF34            .byte $AB
$FF35  AE BB 00  LDX $00BB 
$FF38            .byte $BF,$F3,$0F,$FF
$FF3C  BC F0 00  LDY $00F0,X 
$FF3F            .byte $00
$FF40  60        RTS 
//------------------------------
$FF41  EA        NOP 
$FF42  EA        NOP 
$FF43  08        PHP 
$FF44  68        PLA 
$FF45  29 EF     AND #$EF
$FF47  48        PHA 
$FF48  48        PHA 
$FF49  8A        TXA 
$FF4A  48        PHA 
$FF4B  98        TYA 
$FF4C  48        PHA 
$FF4D  BA        TSX 
$FF4E  BD 04 01  LDA $0104,X 
$FF51  29 10     AND #$10
$FF53  F0 03     BEQ L_BRS_($FF58)_($FF53) OK
$FF55  6C 16 03  JMP ($0316) 
//------------------------------
L_BRS_($FF58)_($FF53) OK
//------------------------------
$FF58  6C 14 03  JMP ($0314) 
$FF5B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF63            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF6B            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_BRS_($FF7A)_($FF22) JAM
//------------------------------
$FF73            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF7B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF83            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($FF90)_($406E) JAM
//------------------------------
$FF8B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF93            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FF9B            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FFA3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FFAB            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($FFBA)_($8485) JAM
//------------------------------
$FFB3            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($FFBD)_($84C1) JAM
//------------------------------
$FFBB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FFC3            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($FFD2)_($8914) JAM
//------------------------------
$FFCB            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($FFD5)_($853F) JAM
L_JSR_($FFD8)_($8524) JAM
//------------------------------
$FFD3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FFDB            .byte $00,$00,$00,$00,$00,$00,$00,$00
//------------------------------
L_JSR_($FFE4)_($8954) JAM
//------------------------------
$FFE3            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FFEB            .byte $00,$00,$00,$00,$00,$00,$00,$00
$FFF3            .byte $00,$00,$00,$00,$00,$00,$00
$FFFA  B6 6E     LDX $6E,Y 
$FFFC  99 40 48  STA $4840,Y 
//------------------------------
L_JMP_($FFFF)_($2271) JAM
L_JMP_($FFFF)_($30E2) JAM
//------------------------------
$FFFF            .byte $FFF