#include <atari.h>
#include <joystick.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <peekpoke.h>
#include "sfx\sfx.h"

#define GRAPHICS_0_SCREEN_SIZE (40*25)
#define GAME_AREA_SIZE (40*22)

extern char joy_driver;
void play_sfx(unsigned char effect_number);
void play_music_init_sfx();

unsigned char *video_ptr;
unsigned screen_memory;

// Game data

unsigned char joy;
unsigned char lives;
unsigned char level;
unsigned char direction;
unsigned char next;
unsigned char c;
unsigned char last_char;
unsigned char quit=0;

unsigned int dos_return;

#pragma dataseg (push,"FONT")
#include "font.h"
#pragma dataseg (pop)

#define SetChar(x,y,a) video_ptr[(x)+(y)*40]=(a);
#define GetChar(x,y) video_ptr[(x)+(y)*40]

#define TAIL (59)
#define HEAD (60)
#define DEAD (64)
#define EATEN (65)
#define VERTICAL (66)
#define HORIZONTAL (67)
#define TURN1 (68)
#define TURN2 (69)
#define TURN3 (70)
#define TURN4 (71)
#define BRICK (72)
#define DIR_LEFT  0
#define DIR_UP    1
#define DIR_RIGHT 2
#define DIR_DOWN  3
#define RANDOM PEEK(0xD20A)

#define LETTERS 5

void value(unsigned char x,unsigned char y,unsigned char val)
{
	SetChar(x++,y,val/10+0x30-32);
	SetChar(x,y,val%10+0x30-32);
}

void wait(unsigned char t)
{
	POKE(540,t);
	while(PEEK(540))
	{
		if (kbhit())
		{
			c=cgetc();
			if (c==27)
				quit=1;
		}

		joy=joy_read(JOY_1);
		if (JOY_BTN_LEFT(joy) && direction!=DIR_RIGHT)
		{
			if (direction==DIR_UP)
				last_char=TURN2;
			else if (direction==DIR_DOWN)
				last_char=TURN4;

			direction=DIR_LEFT;
		}
		else if (JOY_BTN_RIGHT(joy) && direction!=DIR_LEFT)
		{
			if (direction==DIR_UP)
				last_char=TURN1;
			else if (direction==DIR_DOWN)
				last_char=TURN3;

			direction=DIR_RIGHT;
		}
		else if (JOY_BTN_UP(joy) && direction!=DIR_DOWN)
		{
			if (direction==DIR_LEFT)
				last_char=TURN3;
			else if (direction==DIR_RIGHT)
				last_char=TURN4;

			direction=DIR_UP;
		}
		else if (JOY_BTN_DOWN(joy) && direction!=DIR_UP)
		{
			if (direction==DIR_LEFT)
				last_char=TURN1;
			else if (direction==DIR_RIGHT)
				last_char=TURN2;
			direction=DIR_DOWN;
		}
	};
}

void wait_for_fire()
{
	do 
	{
		wait(1);
	} while (!JOY_BTN_FIRE(joy) && !quit);
	do 
	{
		wait(1);
	} while (JOY_BTN_FIRE(joy) && !quit);
}


void print_string(unsigned char x,unsigned char y,char *s)
{
	do
	{
		if (*s < 32)
		{
			SetChar(x++,y,*s+64);
		}
		else if (*s<96)
		{
			SetChar(x++,y,*s-32);
		}
		else
		{
			SetChar(x++,y,*s);
		}
		++s;
	} while(*s!=0);
}


#define COLOR0 0x2C4
#define COLOR1 0x2C5
#define COLOR2 0x2C6
#define COLOR3 0x2C7

void set_colors()
{
	register unsigned char x;
	POKE(COLOR1,0xFF); // kafelki
	for(x=15;x>0;--x)
	{
		POKE(COLOR2,x+(level%2?0x10*(level+8):0x10*(level))); 
		wait(1);
	}
}

void clear_screen()
{
	register unsigned char x;
	POKE(COLOR1,0xFF); // kafelki
	for(x=0;x<16;++x)
	{
		POKE(COLOR2,x+(level%2?0x10*(level+8):0x10*(level))); 
		wait(1);
	}
	memset(video_ptr,0,GRAPHICS_0_SCREEN_SIZE);
	memset(video_ptr+22*40,18+64,40);
}

void death()
{
	register unsigned char x;
	for(x=0;x<50;++x)
	{
		POKE(COLOR1,RANDOM); // kafelki
		wait(1);
	}
	POKE(COLOR1,0xFF); // kafelki
}

void play()
{
	register unsigned char x,y;
	unsigned char i;

	clear_screen();

	// Add obstacles

	for (i=0;i<level;++i)
	{
		x=RANDOM%37;
		y=RANDOM%20;
		for (c=0;c<level+3;++c)
		{
			if (x+c<39)
			{
				SetChar(x+c,y,BRICK);
			}
		}

		x=RANDOM%40;
		y=RANDOM%16;
		for (c=0;c<level+3;++c)
		{
			if (y+c<20)
			{
				SetChar(x,y+c,BRICK);
			}
		}
	}

	// place viper

	direction=DIR_LEFT;
	SetChar(19,10,HEAD+direction);
	SetChar(20,10,TAIL);

	for (i=0;i<level+LETTERS;++i)
	{
		for(;;)
		{
			x=RANDOM%32+4;
			y=RANDOM%18+2;
			if (GetChar(x,y)==0)
			{
				break;
			}
		}
		SetChar(x,y,i+'A'-32);
	}

	x=19;
	y=10;

	next='A'-32;

	print_string(0,23,"level:");
	value (7,23,level);
	print_string(15,23,"next:");
	SetChar(21,23,next);
	print_string(30,23,"lives:");
	value (37,23,lives);


	set_colors();

	last_char=HORIZONTAL;

	wait_for_fire();

	while(!quit)
	{
		SetChar(x,y,last_char);
		switch(direction)
		{
		case DIR_LEFT:
			last_char=HORIZONTAL;

			if (x>0)
				--x;
			else
				x=39;
			break;
		case DIR_UP:
			last_char=VERTICAL;

			if (y>0)
				--y;
			else
				y=21;
			break;
		case DIR_RIGHT:
			last_char=HORIZONTAL;

			if (x<39)
				++x;
			else
				x=0;
			break;
		case DIR_DOWN:
			last_char=VERTICAL;
			if (y<21)
				++y;
			else
				y=0;
			break;
		}
		c=GetChar(x,y);
		if (c!=0 && c!=next)
		{
			play_sfx(0x21);
			--lives;
			--level;
			SetChar(x,y,DEAD);
			death();
			break;
		}
		else if (c==next)
		{
			play_sfx(0x20);
			++next;
			SetChar(21,23,next);
			last_char=EATEN;

			if (next==level+'A'-32+LETTERS)
			{
				break;
			}			
		}
		SetChar(x,y,HEAD+direction);
		if (JOY_BTN_FIRE(joy))
			wait(5);
		else
			wait(10);
	}
}

void game_over()
{
	clear_screen();
	print_string(11,7,"G A M E   O V E R");

	print_string(15,11,"level:");
	value(22,11,level+1);
	set_colors();
	wait_for_fire();
}

void show_win()
{
	clear_screen();
	print_string(13,10,"YOU HAVE WON!");
	set_colors();
	wait_for_fire();
}

void show_intro()
{
	print_string(15,5,"V I P E R");
	print_string(4,8,"tiny atari game by Ilmenit '2009");
	print_string(4,10,"music by Mad MAx...");
	print_string(15,11,"...converted by Miker");
	print_string(10,18,"press fire to start");
	print_string(10,20,"press escape to quit");
	set_colors();
	wait_for_fire();
}

void play_sfx(unsigned char effect_number)
{
	if (effect_number!=0)
		POKE(SFX_SFX_EFFECT,effect_number);
}

void play_music_init_sfx()
{
	__asm__ ("jsr %w",SFX_START);
}

int main(void)
{
	joy_install(&joy_driver);
	// Set keyboard repeat speed
	POKE(730,2);
	POKE(729,8);
	// Turn the keyboard sound
	POKE(731,255);

	play_music_init_sfx();
	_graphics(0);

	screen_memory=PEEKW(560)+4;
	video_ptr=(unsigned char*)(PEEKW(screen_memory));

	// Set the font
	POKE(756,((unsigned int) &font)/256);

	while(!quit)
	{
		lives=5;
		clear_screen();
		level=0;
		show_intro();		
		for(level=1;level<10 && !quit;++level)
		{
			play();
			if (lives==0)
			{
				game_over();
				break;
			}
		}
		if (level==10)
		{
			show_win();
		}
	}
	__asm__ ("JMP $E474");
}